/*
 * Decompiled with CFR 0.152.
 */
package geotrans.gui;

import geotrans.gui.FillList;
import geotrans.jni.GeotransError;
import geotrans.jni.JNIEngine;
import geotrans.jni.JNIException;
import geotrans.jni.JNIStrtoval;
import geotrans.utility.Center;
import geotrans.utility.Platform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;

public class DeleteDlg
extends JDialog {
    private int listType;
    private int index = 0;
    private JPanel comboBoxPanel;
    private JLabel deleteLabel;
    private JComboBox comboBox;
    private JPanel buttonsPanel;
    private JButton okButton;
    private JButton cancelButton;

    public DeleteDlg(Frame parent, boolean modal, int lType) {
        super(parent, modal);
        this.listType = lType;
        this.initComponents();
        if (this.listType == 0) {
            this.setTitle("Delete Datum");
            this.deleteLabel.setText("Datum:");
            new FillList(this.comboBox, 0);
        } else {
            this.setTitle("Delete Ellipsoid");
            this.deleteLabel.setText("Ellipsoid:");
            new FillList(this.comboBox, 1);
        }
        this.pack();
        new Center(parent, this);
        if (Platform.isJavaV1_3) {
            this.deleteLabel.setForeground(Color.black);
        }
        if (Platform.isUnix) {
            this.deleteLabel.setFont(new Font("Dialog", 1, 10));
            this.comboBox.setFont(new Font("Dialog", 1, 10));
            this.okButton.setFont(new Font("Dialog", 1, 10));
            this.cancelButton.setFont(new Font("Dialog", 1, 10));
        }
    }

    private void initComponents() {
        this.comboBoxPanel = new JPanel();
        this.deleteLabel = new JLabel();
        this.comboBox = new JComboBox();
        this.buttonsPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("DELETE ");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DeleteDlg.this.closeDialog(evt);
            }
        });
        this.comboBoxPanel.setLayout(new GridBagLayout());
        this.deleteLabel.setHorizontalAlignment(2);
        this.deleteLabel.setText("Select Datum");
        this.deleteLabel.setAlignmentX(1.0f);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(15, 20, 0, 20);
        gridBagConstraints1.anchor = 18;
        this.comboBoxPanel.add((Component)this.deleteLabel, gridBagConstraints1);
        this.comboBox.setMaximumRowCount(6);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.insets = new Insets(0, 20, 10, 20);
        gridBagConstraints1.anchor = 17;
        this.comboBoxPanel.add((Component)this.comboBox, gridBagConstraints1);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        this.getContentPane().add((Component)this.comboBoxPanel, gridBagConstraints4);
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.okButton.setMnemonic(79);
        this.okButton.setText("OK");
        this.okButton.setBorder(new BevelBorder(0));
        this.okButton.setMaximumSize(new Dimension(43, 22));
        this.okButton.setMinimumSize(new Dimension(43, 22));
        this.okButton.setPreferredSize(new Dimension(43, 22));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DeleteDlg.this.okActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.ipadx = 25;
        gridBagConstraints3.insets = new Insets(0, 0, 0, 10);
        this.buttonsPanel.add((Component)this.okButton, gridBagConstraints3);
        this.cancelButton.setMnemonic(67);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setBorder(new BevelBorder(0));
        this.cancelButton.setMaximumSize(new Dimension(43, 22));
        this.cancelButton.setMinimumSize(new Dimension(43, 22));
        this.cancelButton.setPreferredSize(new Dimension(43, 22));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DeleteDlg.this.cancelActionPerformed(evt);
            }
        });
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.ipadx = 25;
        gridBagConstraints3.insets = new Insets(0, 10, 0, 0);
        this.buttonsPanel.add((Component)this.cancelButton, gridBagConstraints3);
        gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.insets = new Insets(5, 0, 8, 0);
        this.getContentPane().add((Component)this.buttonsPanel, gridBagConstraints4);
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void okActionPerformed(ActionEvent evt) {
        JNIEngine jniEngine = new JNIEngine();
        JNIStrtoval jniStrtoval = new JNIStrtoval();
        this.index = this.comboBox.getSelectedIndex();
        try {
            if (this.listType == 0) {
                jniEngine.JNIRemoveDatum(jniEngine.JNIGetDatumCode(this.index + 1));
            } else {
                jniEngine.JNIRemoveEllipsoid(jniEngine.JNIGetEllipsoidCode(this.index + 1));
            }
            this.setVisible(false);
            this.dispose();
        }
        catch (GeotransError e) {
            jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
        catch (JNIException e) {
            jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new DeleteDlg((Frame)new JFrame(), true, 0).show();
    }

    public int getIndex() {
        return this.index;
    }
}

