/*
 * Decompiled with CFR 0.152.
 */
package geotrans.gui;

import geotrans.gui.jOptions;
import geotrans.jni.GeotransError;
import geotrans.jni.JNIException;
import geotrans.jni.JNIStrtoval;
import geotrans.utility.Center;
import geotrans.utility.Platform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class FormatOptionsDlg
extends JDialog {
    private jOptions options;
    private jOptions origOptions;
    private JNIStrtoval jniStrtoval = new JNIStrtoval();
    private JRadioButton _0_360RangeRadioButton;
    private JRadioButton _100000mPrecisionRadioButton;
    private JRadioButton _10000mPrecisionRadioButton;
    private JRadioButton _1000mPrecisionRadioButton;
    private JRadioButton _100mPrecisionRadioButton;
    private JRadioButton _10mPrecisionRadioButton;
    private JRadioButton _180_180RangeRadioButton;
    private JRadioButton _1mPrecisionRadioButton;
    private JRadioButton __001mPrecisionRadioButton;
    private JRadioButton __01mPrecisionRadioButton;
    private JRadioButton __1mPrecisionRadioButton;
    private JButton applyButton;
    private JPanel applyFormatPanel;
    private JPanel buttonsPanel;
    private JButton cancelButton;
    private JRadioButton colonSeparatorRadioButton;
    private JRadioButton dUnitsRadioButton;
    private JRadioButton dmUnitsRadioButton;
    private JRadioButton dmsUnitsRadioButton;
    private JLabel formatLabel;
    private JTextField formatTextField;
    private JLabel geodeticSeparatorLabel;
    private JLabel geodeticUnitsLabel;
    private JRadioButton hemiRadioButton;
    private JCheckBox leadingZerosCheckBox;
    private JLabel longRangeLabel;
    private JLabel newFormatLabel;
    private JTextField newFormatTextField;
    private JPanel numberFormatPanel;
    private JButton okButton;
    private JTabbedPane optionsTabbedPane;
    private JPanel precisionPanel;
    private JPanel rangePanel;
    private JPanel separatorPanel;
    private JLabel signHemiLabel;
    private JPanel signHemiPanel;
    private JRadioButton signRadioButton;
    private JRadioButton slashSeparatorRadioButton;
    private JRadioButton spaceSeparatorRadioButton;
    private JPanel unitsPanel;

    public FormatOptionsDlg(Frame parent, boolean modal, jOptions joptions) {
        super(parent, modal);
        this.initComponents();
        this.createButtonGroups();
        this.options = joptions;
        this.origOptions = new jOptions(joptions);
        this.setUnitsButton(joptions.getUnits());
        this.setSeparatorButton(joptions.getSeparator());
        this.setSignButton(joptions.getSignHemi());
        this.setRangeButton(joptions.getRange());
        this.setPrecisionButton(joptions.getPrecision());
        this.leadingZerosCheckBox.setSelected(joptions.getLeadingZeros());
        this.setFormatString(this.formatTextField);
        this.setFormatString(this.newFormatTextField);
        if (Platform.isJavaV1_3) {
            this.formatLabel.setForeground(Color.black);
            this.newFormatLabel.setForeground(Color.black);
            this.geodeticUnitsLabel.setForeground(Color.black);
            this.geodeticSeparatorLabel.setForeground(Color.black);
            this.signHemiLabel.setForeground(Color.black);
            this.longRangeLabel.setForeground(Color.black);
            this.leadingZerosCheckBox.setForeground(Color.black);
        }
        this.pack();
        new Center(parent, this);
    }

    private void initComponents() {
        this.applyFormatPanel = new JPanel();
        this.formatLabel = new JLabel();
        this.newFormatLabel = new JLabel();
        this.formatTextField = new JTextField();
        this.newFormatTextField = new JTextField();
        this.optionsTabbedPane = new JTabbedPane();
        this.numberFormatPanel = new JPanel();
        this.unitsPanel = new JPanel();
        this.geodeticUnitsLabel = new JLabel();
        this.dmsUnitsRadioButton = new JRadioButton();
        this.dmUnitsRadioButton = new JRadioButton();
        this.dUnitsRadioButton = new JRadioButton();
        this.separatorPanel = new JPanel();
        this.geodeticSeparatorLabel = new JLabel();
        this.spaceSeparatorRadioButton = new JRadioButton();
        this.slashSeparatorRadioButton = new JRadioButton();
        this.colonSeparatorRadioButton = new JRadioButton();
        this.signHemiPanel = new JPanel();
        this.signHemiLabel = new JLabel();
        this.signRadioButton = new JRadioButton();
        this.hemiRadioButton = new JRadioButton();
        this.rangePanel = new JPanel();
        this.longRangeLabel = new JLabel();
        this._180_180RangeRadioButton = new JRadioButton();
        this._0_360RangeRadioButton = new JRadioButton();
        this.leadingZerosCheckBox = new JCheckBox();
        this.precisionPanel = new JPanel();
        this._100000mPrecisionRadioButton = new JRadioButton();
        this._10000mPrecisionRadioButton = new JRadioButton();
        this._1000mPrecisionRadioButton = new JRadioButton();
        this._100mPrecisionRadioButton = new JRadioButton();
        this._10mPrecisionRadioButton = new JRadioButton();
        this._1mPrecisionRadioButton = new JRadioButton();
        this.__1mPrecisionRadioButton = new JRadioButton();
        this.__01mPrecisionRadioButton = new JRadioButton();
        this.__001mPrecisionRadioButton = new JRadioButton();
        this.buttonsPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.applyButton = new JButton();
        this.setTitle("Format");
        this.setName("");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                FormatOptionsDlg.this.dialogWindowClosing(evt);
            }
        });
        this.applyFormatPanel.setLayout(new GridLayout(2, 1, 20, 5));
        this.formatLabel.setFont(new Font("Dialog", 3, 14));
        this.formatLabel.setHorizontalAlignment(0);
        this.formatLabel.setText("Current Format:");
        this.applyFormatPanel.add(this.formatLabel);
        this.newFormatLabel.setFont(new Font("Dialog", 3, 14));
        this.newFormatLabel.setHorizontalAlignment(0);
        this.newFormatLabel.setText("New  Format:");
        this.applyFormatPanel.add(this.newFormatLabel);
        this.formatTextField.setEditable(false);
        this.formatTextField.setHorizontalAlignment(0);
        this.formatTextField.setText("260 30 20.0E");
        this.applyFormatPanel.add(this.formatTextField);
        this.newFormatTextField.setEditable(false);
        this.newFormatTextField.setHorizontalAlignment(0);
        this.newFormatTextField.setText("260 30 20.00");
        this.applyFormatPanel.add(this.newFormatTextField);
        this.getContentPane().add((Component)this.applyFormatPanel, "North");
        this.optionsTabbedPane.setFont(new Font("Dialog", 1, 10));
        this.numberFormatPanel.setBorder(BorderFactory.createEtchedBorder());
        this.numberFormatPanel.setLayout(new GridBagLayout());
        this.unitsPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.unitsPanel.setMinimumSize(new Dimension(170, 86));
        this.unitsPanel.setPreferredSize(new Dimension(170, 86));
        this.unitsPanel.setLayout(new GridBagLayout());
        this.geodeticUnitsLabel.setText("Geodetic Units");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.unitsPanel.add((Component)this.geodeticUnitsLabel, gridBagConstraints);
        this.dmsUnitsRadioButton.setFont(new Font("Dialog", 0, 10));
        this.dmsUnitsRadioButton.setText("Degrees / Minutes / Seconds");
        this.dmsUnitsRadioButton.setModel(this.dmsUnitsRadioButton.getModel());
        this.dmsUnitsRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormatOptionsDlg.this.unitsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.unitsPanel.add((Component)this.dmsUnitsRadioButton, gridBagConstraints);
        this.dmUnitsRadioButton.setFont(new Font("Dialog", 0, 10));
        this.dmUnitsRadioButton.setText("Degrees / Minutes ");
        this.dmUnitsRadioButton.setModel(this.dmUnitsRadioButton.getModel());
        this.dmUnitsRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormatOptionsDlg.this.unitsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.unitsPanel.add((Component)this.dmUnitsRadioButton, gridBagConstraints);
        this.dUnitsRadioButton.setFont(new Font("Dialog", 0, 10));
        this.dUnitsRadioButton.setSelected(true);
        this.dUnitsRadioButton.setText("Degrees ");
        this.dUnitsRadioButton.setModel(this.dUnitsRadioButton.getModel());
        this.dUnitsRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormatOptionsDlg.this.unitsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.unitsPanel.add((Component)this.dUnitsRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 3, 0);
        this.numberFormatPanel.add((Component)this.unitsPanel, gridBagConstraints);
        this.separatorPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.separatorPanel.setMinimumSize(new Dimension(150, 86));
        this.separatorPanel.setPreferredSize(new Dimension(125, 86));
        this.separatorPanel.setLayout(new GridBagLayout());
        this.geodeticSeparatorLabel.setText("Geodetic Separator");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.separatorPanel.add((Component)this.geodeticSeparatorLabel, gridBagConstraints);
        this.spaceSeparatorRadioButton.setFont(new Font("Dialog", 0, 10));
        this.spaceSeparatorRadioButton.setSelected(true);
        this.spaceSeparatorRadioButton.setText("DD MM SS");
        this.spaceSeparatorRadioButton.setModel(this.spaceSeparatorRadioButton.getModel());
        this.spaceSeparatorRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormatOptionsDlg.this.separatorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.separatorPanel.add((Component)this.spaceSeparatorRadioButton, gridBagConstraints);
        this.slashSeparatorRadioButton.setFont(new Font("Dialog", 0, 10));
        this.slashSeparatorRadioButton.setText("DD/MM/SS");
        this.slashSeparatorRadioButton.setModel(this.slashSeparatorRadioButton.getModel());
        this.slashSeparatorRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormatOptionsDlg.this.separatorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.separatorPanel.add((Component)this.slashSeparatorRadioButton, gridBagConstraints);
        this.colonSeparatorRadioButton.setFont(new Font("Dialog", 0, 10));
        this.colonSeparatorRadioButton.setText("DD:MM:SS");
        this.colonSeparatorRadioButton.setModel(this.colonSeparatorRadioButton.getModel());
        this.colonSeparatorRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormatOptionsDlg.this.separatorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.separatorPanel.add((Component)this.colonSeparatorRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(6, 5, 3, 6);
        this.numberFormatPanel.add((Component)this.separatorPanel, gridBagConstraints);
        this.signHemiPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.signHemiPanel.setMinimumSize(new Dimension(149, 68));
        this.signHemiPanel.setPreferredSize(new Dimension(119, 68));
        this.signHemiPanel.setLayout(new GridBagLayout());
        this.signHemiLabel.setHorizontalAlignment(2);
        this.signHemiLabel.setText("Sign /  Hemisphere");
        this.signHemiLabel.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.signHemiPanel.add((Component)this.signHemiLabel, gridBagConstraints);
        this.signRadioButton.setFont(new Font("Dialog", 0, 10));
        this.signRadioButton.setSelected(true);
        this.signRadioButton.setText("+ / -");
        this.signRadioButton.setHorizontalAlignment(2);
        this.signRadioButton.setModel(this.signRadioButton.getModel());
        this.signRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormatOptionsDlg.this.signHemiActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.signHemiPanel.add((Component)this.signRadioButton, gridBagConstraints);
        this.hemiRadioButton.setFont(new Font("Dialog", 0, 10));
        this.hemiRadioButton.setText("N / S, E / W");
        this.hemiRadioButton.setHorizontalAlignment(2);
        this.hemiRadioButton.setModel(this.hemiRadioButton.getModel());
        this.hemiRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormatOptionsDlg.this.signHemiActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        this.signHemiPanel.add((Component)this.hemiRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.numberFormatPanel.add((Component)this.signHemiPanel, gridBagConstraints);
        this.rangePanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.rangePanel.setMinimumSize(new Dimension(119, 88));
        this.rangePanel.setPreferredSize(new Dimension(110, 68));
        this.rangePanel.setLayout(new GridBagLayout());
        this.longRangeLabel.setText("Longitude Range");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.rangePanel.add((Component)this.longRangeLabel, gridBagConstraints);
        this._180_180RangeRadioButton.setFont(new Font("Dialog", 0, 10));
        this._180_180RangeRadioButton.setSelected(true);
        this._180_180RangeRadioButton.setText("( -180, 180 )");
        this._180_180RangeRadioButton.setModel(this._180_180RangeRadioButton.getModel());
        this._180_180RangeRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormatOptionsDlg.this.rangeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.rangePanel.add((Component)this._180_180RangeRadioButton, gridBagConstraints);
        this._0_360RangeRadioButton.setFont(new Font("Dialog", 0, 10));
        this._0_360RangeRadioButton.setText("( 0, 360 )");
        this._0_360RangeRadioButton.setModel(this._0_360RangeRadioButton.getModel());
        this._0_360RangeRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormatOptionsDlg.this.rangeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        this.rangePanel.add((Component)this._0_360RangeRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(0, 5, 3, 20);
        this.numberFormatPanel.add((Component)this.rangePanel, gridBagConstraints);
        this.leadingZerosCheckBox.setText("Leading Zeros");
        this.leadingZerosCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormatOptionsDlg.this.leadingZerosCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 11, 6, 0);
        this.numberFormatPanel.add((Component)this.leadingZerosCheckBox, gridBagConstraints);
        this.optionsTabbedPane.addTab("Number Format", null, this.numberFormatPanel, "");
        this.precisionPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 10, 0, 0)));
        this.precisionPanel.setLayout(new GridLayout(9, 1));
        this._100000mPrecisionRadioButton.setFont(new Font("Dialog", 0, 10));
        this._100000mPrecisionRadioButton.setText("100,000m  1 Degree");
        this._100000mPrecisionRadioButton.setModel(this._100000mPrecisionRadioButton.getModel());
        this._100000mPrecisionRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormatOptionsDlg.this.precisionActionPerformed(evt);
            }
        });
        this.precisionPanel.add(this._100000mPrecisionRadioButton);
        this._10000mPrecisionRadioButton.setFont(new Font("Dialog", 0, 10));
        this._10000mPrecisionRadioButton.setText("10,000m    10 Minutes");
        this._10000mPrecisionRadioButton.setModel(this._10000mPrecisionRadioButton.getModel());
        this._10000mPrecisionRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormatOptionsDlg.this.precisionActionPerformed(evt);
            }
        });
        this.precisionPanel.add(this._10000mPrecisionRadioButton);
        this._1000mPrecisionRadioButton.setFont(new Font("Dialog", 0, 10));
        this._1000mPrecisionRadioButton.setText("1000m       1 Minute");
        this._1000mPrecisionRadioButton.setModel(this._1000mPrecisionRadioButton.getModel());
        this._1000mPrecisionRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormatOptionsDlg.this.precisionActionPerformed(evt);
            }
        });
        this.precisionPanel.add(this._1000mPrecisionRadioButton);
        this._100mPrecisionRadioButton.setFont(new Font("Dialog", 0, 10));
        this._100mPrecisionRadioButton.setText("100m         10 Seconds");
        this._100mPrecisionRadioButton.setModel(this._100mPrecisionRadioButton.getModel());
        this._100mPrecisionRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormatOptionsDlg.this.precisionActionPerformed(evt);
            }
        });
        this.precisionPanel.add(this._100mPrecisionRadioButton);
        this._10mPrecisionRadioButton.setFont(new Font("Dialog", 0, 10));
        this._10mPrecisionRadioButton.setText("10m           1 Second");
        this._10mPrecisionRadioButton.setModel(this._10mPrecisionRadioButton.getModel());
        this._10mPrecisionRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormatOptionsDlg.this.precisionActionPerformed(evt);
            }
        });
        this.precisionPanel.add(this._10mPrecisionRadioButton);
        this._1mPrecisionRadioButton.setFont(new Font("Dialog", 0, 10));
        this._1mPrecisionRadioButton.setSelected(true);
        this._1mPrecisionRadioButton.setText("1m             0.1 Second");
        this._1mPrecisionRadioButton.setModel(this._1mPrecisionRadioButton.getModel());
        this._1mPrecisionRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormatOptionsDlg.this.precisionActionPerformed(evt);
            }
        });
        this.precisionPanel.add(this._1mPrecisionRadioButton);
        this.__1mPrecisionRadioButton.setFont(new Font("Dialog", 0, 10));
        this.__1mPrecisionRadioButton.setText("0.1m          0.01 Second");
        this.__1mPrecisionRadioButton.setModel(this.__1mPrecisionRadioButton.getModel());
        this.__1mPrecisionRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormatOptionsDlg.this.precisionActionPerformed(evt);
            }
        });
        this.precisionPanel.add(this.__1mPrecisionRadioButton);
        this.__01mPrecisionRadioButton.setFont(new Font("Dialog", 0, 10));
        this.__01mPrecisionRadioButton.setText("0.01m        0.001 Second");
        this.__01mPrecisionRadioButton.setModel(this.__01mPrecisionRadioButton.getModel());
        this.__01mPrecisionRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormatOptionsDlg.this.precisionActionPerformed(evt);
            }
        });
        this.precisionPanel.add(this.__01mPrecisionRadioButton);
        this.__001mPrecisionRadioButton.setFont(new Font("Dialog", 0, 10));
        this.__001mPrecisionRadioButton.setText("0.001m      0.0001 Second");
        this.__001mPrecisionRadioButton.setModel(this.__001mPrecisionRadioButton.getModel());
        this.__001mPrecisionRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormatOptionsDlg.this.precisionActionPerformed(evt);
            }
        });
        this.precisionPanel.add(this.__001mPrecisionRadioButton);
        this.optionsTabbedPane.addTab("Precision", null, this.precisionPanel, "");
        this.getContentPane().add((Component)this.optionsTabbedPane, "Center");
        this.buttonsPanel.setMinimumSize(new Dimension(204, 41));
        this.buttonsPanel.setPreferredSize(new Dimension(204, 41));
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.okButton.setMnemonic(79);
        this.okButton.setText("OK");
        this.okButton.setBorder(BorderFactory.createBevelBorder(0));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormatOptionsDlg.this.okActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 55;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 25);
        this.buttonsPanel.add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setMnemonic(67);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setBorder(BorderFactory.createBevelBorder(0));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormatOptionsDlg.this.cancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 30;
        this.buttonsPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.applyButton.setMnemonic(65);
        this.applyButton.setText("Apply");
        this.applyButton.setBorder(BorderFactory.createBevelBorder(0));
        this.applyButton.setSelected(true);
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormatOptionsDlg.this.applyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 30;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 25, 0, 0);
        this.buttonsPanel.add((Component)this.applyButton, gridBagConstraints);
        this.getContentPane().add((Component)this.buttonsPanel, "South");
    }

    private void leadingZerosCheckBoxActionPerformed(ActionEvent evt) {
        if (this.leadingZerosCheckBox.isSelected()) {
            this.options.setLeadingZeros(true);
        } else {
            this.options.setLeadingZeros(false);
        }
    }

    private void dialogWindowClosing(WindowEvent evt) {
        this.options.reset(this.origOptions);
        this.setVisible(false);
        this.dispose();
    }

    private void applyActionPerformed(ActionEvent evt) {
        this.setFormatString(this.newFormatTextField);
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.options.reset(this.origOptions);
        this.setVisible(false);
        this.dispose();
    }

    private void okActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void precisionActionPerformed(ActionEvent evt) {
        if (this._100000mPrecisionRadioButton.isSelected()) {
            this.options.setPrecision(0);
        } else if (this._10000mPrecisionRadioButton.isSelected()) {
            this.options.setPrecision(1);
        } else if (this._1000mPrecisionRadioButton.isSelected()) {
            this.options.setPrecision(2);
        } else if (this._100mPrecisionRadioButton.isSelected()) {
            this.options.setPrecision(3);
        } else if (this._10mPrecisionRadioButton.isSelected()) {
            this.options.setPrecision(4);
        } else if (this._1mPrecisionRadioButton.isSelected()) {
            this.options.setPrecision(5);
        } else if (this.__1mPrecisionRadioButton.isSelected()) {
            this.jniStrtoval.displayWarningMsg(this, "Warning:  Output accuracy is limited to ~1m");
            this.options.setPrecision(6);
        } else if (this.__01mPrecisionRadioButton.isSelected()) {
            this.jniStrtoval.displayWarningMsg(this, "Warning:  Output accuracy is limited to ~1m");
            this.options.setPrecision(7);
        } else if (this.__001mPrecisionRadioButton.isSelected()) {
            this.jniStrtoval.displayWarningMsg(this, "Warning:  Output accuracy is limited to ~1m");
            this.options.setPrecision(8);
        }
    }

    private void rangeActionPerformed(ActionEvent evt) {
        if (this._180_180RangeRadioButton.isSelected()) {
            this.options.setRange(0);
        } else if (this._0_360RangeRadioButton.isSelected()) {
            this.options.setRange(1);
        }
    }

    private void signHemiActionPerformed(ActionEvent evt) {
        if (this.signRadioButton.isSelected()) {
            this.options.setSignHemi(0);
        } else if (this.hemiRadioButton.isSelected()) {
            this.options.setSignHemi(1);
        }
    }

    private void separatorActionPerformed(ActionEvent evt) {
        if (this.spaceSeparatorRadioButton.isSelected()) {
            this.options.setSeparator(' ');
        } else if (this.slashSeparatorRadioButton.isSelected()) {
            this.options.setSeparator('/');
        } else if (this.colonSeparatorRadioButton.isSelected()) {
            this.options.setSeparator(':');
        }
    }

    private void unitsActionPerformed(ActionEvent evt) {
        if (this.dmsUnitsRadioButton.isSelected()) {
            this.options.setUnits(0);
        } else if (this.dmUnitsRadioButton.isSelected()) {
            this.options.setUnits(1);
        } else if (this.dUnitsRadioButton.isSelected()) {
            this.options.setUnits(2);
        }
    }

    private void setUnitsButton(int units) {
        if (units == 0) {
            this.dmsUnitsRadioButton.setSelected(true);
        } else if (units == 1) {
            this.dmUnitsRadioButton.setSelected(true);
        } else if (units == 2) {
            this.dUnitsRadioButton.setSelected(true);
        }
    }

    private void setSeparatorButton(int separator) {
        if (separator == 32) {
            this.spaceSeparatorRadioButton.setSelected(true);
        } else if (separator == 47) {
            this.slashSeparatorRadioButton.setSelected(true);
        } else if (separator == 58) {
            this.colonSeparatorRadioButton.setSelected(true);
        }
    }

    private void setSignButton(int signHemi) {
        if (signHemi == 0) {
            this.signRadioButton.setSelected(true);
        } else if (signHemi == 1) {
            this.hemiRadioButton.setSelected(true);
        }
    }

    private void setRangeButton(int range) {
        if (range == 1) {
            this._0_360RangeRadioButton.setSelected(true);
        } else if (range == 0) {
            this._180_180RangeRadioButton.setSelected(true);
        }
    }

    private void setPrecisionButton(int precis) {
        if (precis == 0) {
            this._100000mPrecisionRadioButton.setSelected(true);
        } else if (precis == 1) {
            this._10000mPrecisionRadioButton.setSelected(true);
        } else if (precis == 2) {
            this._1000mPrecisionRadioButton.setSelected(true);
        } else if (precis == 3) {
            this._100mPrecisionRadioButton.setSelected(true);
        } else if (precis == 4) {
            this._10mPrecisionRadioButton.setSelected(true);
        } else if (precis == 5) {
            this._1mPrecisionRadioButton.setSelected(true);
        } else if (precis == 6) {
            this.__1mPrecisionRadioButton.setSelected(true);
        } else if (precis == 7) {
            this.__01mPrecisionRadioButton.setSelected(true);
        } else if (precis == 8) {
            this.__001mPrecisionRadioButton.setSelected(true);
        }
    }

    private void setFormatString(JTextField textField) {
        try {
            String new_test_Str = this.jniStrtoval.JNILongitudeToString(260.50555555555553, this.options.getUseNSEW(), this.options.getUseMinutes(), this.options.getUseSeconds());
            textField.setText(new_test_Str);
        }
        catch (GeotransError e) {
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
        catch (JNIException e) {
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
    }

    public void createButtonGroups() {
        ButtonGroup unit_group = new ButtonGroup();
        ButtonGroup separator_group = new ButtonGroup();
        ButtonGroup sign_group = new ButtonGroup();
        ButtonGroup range_group = new ButtonGroup();
        ButtonGroup precision_group = new ButtonGroup();
        unit_group.add(this.dmsUnitsRadioButton);
        unit_group.add(this.dmUnitsRadioButton);
        unit_group.add(this.dUnitsRadioButton);
        separator_group.add(this.spaceSeparatorRadioButton);
        separator_group.add(this.slashSeparatorRadioButton);
        separator_group.add(this.colonSeparatorRadioButton);
        sign_group.add(this.signRadioButton);
        sign_group.add(this.hemiRadioButton);
        range_group.add(this._180_180RangeRadioButton);
        range_group.add(this._0_360RangeRadioButton);
        precision_group.add(this._100000mPrecisionRadioButton);
        precision_group.add(this._10000mPrecisionRadioButton);
        precision_group.add(this._1000mPrecisionRadioButton);
        precision_group.add(this._100mPrecisionRadioButton);
        precision_group.add(this._10mPrecisionRadioButton);
        precision_group.add(this._1mPrecisionRadioButton);
        precision_group.add(this.__1mPrecisionRadioButton);
        precision_group.add(this.__01mPrecisionRadioButton);
        precision_group.add(this.__001mPrecisionRadioButton);
    }

    public static void main(String[] args) {
        jOptions options = new jOptions();
        new FormatOptionsDlg((Frame)new JFrame(), true, options).show();
    }
}

