/*
** 1998-05-25 -	Header file for the dirpane module. Deals with all aspects of
**		directory panes. Since those are very central to this program,
**		there's quite a lot to deal with.
*/

#if !defined DIRPANE_H
#define	DIRPANE_H

#define	DP_ENTRY(dp)	GTK_ENTRY(gtk_bin_get_child(GTK_BIN(dp->path)))

/* ----------------------------------------------------------------------------------------- */

extern void		dp_initialize(DirPane *dp);

extern DirPane *	dp_mirror(const MainInfo *min, const DirPane *dp);
extern const gchar *	dp_full_name(const DirPane *dp, gint row);
extern const gchar *	dp_name_quoted(const DirPane *dp, gint row, gboolean path);

extern void		dp_show_stats(DirPane *dp);
extern void		dp_update_stats(DirPane *dp);
extern gboolean		dp_activate(DirPane *dp);

extern void		dp_resort(DirPane *dp);
extern void		dp_redisplay(DirPane *dp);
extern void		dp_redisplay_preserve(DirPane *dp);

extern void		dp_unfocus(DirPane *dp);
extern void		dp_focus(DirPane *dp, gint row);
extern void		dp_focus_enter_dir(DirPane *dp);

extern gboolean		dp_has_selection(DirPane *dp);
extern gboolean		dp_is_selected(DirPane *dp, DirRow *row);

extern GSList *		dp_get_selection(DirPane *dp);
extern GSList *		dp_get_selection_full(const DirPane *dp);
#if 0
extern void		dp_print_selection(DirPane *dp, const gchar *tag);
#endif
extern void		dp_free_selection(GSList *sel);

extern gboolean		dp_enter_dir(DirPane *dp, const gchar *path);
extern void		dp_rescan(DirPane *dp);
extern void		dp_rescan_post_cmd(DirPane *dp);

extern void		dp_path_clear(DirPane *dp);
extern void		dp_path_focus(DirPane *dp);
extern void		dp_path_unfocus(DirPane *dp);

extern void		dp_history_set(DirPane *dp, const GList *paths);

extern void		dp_freeze(DirPane *dp);
extern void		dp_thaw(DirPane *dp);

extern void		dp_dbclk_row(DirPane *dp, gint row);

extern void		dp_select(DirPane *dp, gint row);
extern void		dp_select_all(DirPane *dp);
extern void		dp_unselect(DirPane *dp, gint row);
extern void		dp_unselect_all(DirPane *dp);
extern void		dp_toggle(DirPane *dp, gint row);


/* Functionality for letting various modules create alternative widgetry that
** can replace the ordinary parent, path, and hide widget row. ISearch first.
*/
typedef GtkWidget ** (*PageBuilder)(MainInfo *min);

extern guint		dp_pathwidgetry_add(PageBuilder func);
extern GtkWidget **	dp_pathwidgetry_show(DirPane *dp, guint key);

extern GtkWidget *	dp_build(MainInfo *min, DPFormat *fmt, DirPane *dp);

#endif		/* DIRPANE_H */
