using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

#region Google Base specific imports
using Google.GData.Client;
using Google.GData.Extensions;
using Google.GData.GoogleBase;
using Google.GData.Tools;
#endregion

namespace Google_BaseApplication
{
    public partial class Form1 : Form
    {
        GBaseService service;
        String developerKey = null; 

        public Form1()
        {
            InitializeComponent();
            if (this.developerKey == null)
            {
                GoogleClientLogin loginDialog = new GoogleClientLogin(null, "youremailhere@gmail.com");
                if (loginDialog.ShowDialog() == DialogResult.OK)
                {
                    this.developerKey = loginDialog.DeveloperKey;


                    if (this.developerKey != String.Empty && loginDialog.User != String.Empty && loginDialog.Password != String.Empty)
                    {
                        this.service = new GBaseService("Sample Applicaiton", this.developerKey);
                        this.service.setUserCredentials(loginDialog.User, loginDialog.Password);

                        this.Text = "Successfully logged in";

                        GBaseQuery query = new GBaseQuery("http://base.google.com/base/feeds/items");
                        GBaseFeed feed = this.service.Query(query);

                        foreach (GBaseEntry entry in feed.Entries)
                        {
                            ListViewItem item = new ListViewItem(entry.Title.Text);
                            item.Tag = entry;
                            this.listView.Items.Add(item);
                        }

                        this.listView.Update();

                    }
                }
            }
        }
    }
}