package GCPlugins::GCTVepisodes::GCTvdb;

###################################################
#
#  Copyright 2005-2007 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

use GCPlugins::GCTVepisodes::GCTVepisodesCommon;


{
    package GCPlugins::GCTVepisodes::GCPluginTvdb;

    use base qw(GCPlugins::GCTVepisodes::GCTVepisodesPluginsBase);
    use LWP::Simple qw($ua); 
    use Encode;

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;

        $self->{inside}->{$tagname}++;

        if ($self->{pass} eq 1)
        {
            if ($tagname eq 'seriesid')
            {
                $self->{isSeriesID} = 1;
            }
            if ($tagname eq 'seriesname')
            {
                $self->{isSeriesName} = 1;
            }
        }
        else
        {
            if ($self->{parsingList})
            {
                if ($tagname eq 'series')
                {
                    $self->{isSeries} = 1;
                }
                if ($tagname eq 'seriesname')
                {
                    $self->{isSeriesName} = 1;
                }
                if ($tagname eq 'actors')
                {
                    $self->{isActors} = 1;
                }
                if ($tagname eq 'genre')
                {
                    $self->{isGenre} = 1;
                }
                if ($tagname eq 'runtime')
                {
                    $self->{isRuntime} = 1;
                }
                if ($self->{isSeries} eq 0)
                {
                    if ($tagname eq 'episode')
                    {
                        $self->{isEpisode} = 1;
                        $self->{usedDVDordering} = 0;
                    }
                    if ($tagname eq 'episodename')
                    {
                        $self->{isEpisodeName} = 1;
                    }
                    if ($tagname eq 'dvd_episodenumber') 
                    {
                        $self->{isDVDEpisodeNumber} = 1;
                    }  
                    if (($tagname eq 'episodenumber') && (!$self->{usedDVDordering}))
                    {
                        $self->{isEpisodeNumber} = 1;
                    }
                    if ($tagname eq 'dvd_season')
                    {
                        $self->{isDVDSeasonNumber} = 1;
                    }
                    if (($tagname eq 'seasonnumber') && (!$self->{usedDVDordering}))
                    {
                        $self->{isSeasonNumber} = 1;
                    }
                    if ($tagname eq 'director')
                    {
                        $self->{isDirector} = 1;
                    }
                    if ($tagname eq 'firstaired')
                    {
                        $self->{isFirstaired} = 1;
                    }
                    if ($tagname eq 'writer')
                    {
                        $self->{isWriter} = 1;
                    }
                    if ($tagname eq 'filename')
                    {
                        $self->{isImage} = 1;
                    }
                    if ($tagname eq 'overview')
                    {
                        $self->{isOverview} = 1;
                    } 
                }
            }
            else
            {
                $self->{curInfo}->{season} = $self->{itemsList}[$self->{wantedIdx}]->{season};
                $self->{curInfo}->{episode} = $self->{itemsList}[$self->{wantedIdx}]->{episode};
                $self->{curInfo}->{name} = $self->{itemsList}[$self->{wantedIdx}]->{name};
                $self->{curInfo}->{series} = $self->{itemsList}[$self->{wantedIdx}]->{series};
                $self->{curInfo}->{director} = $self->{itemsList}[$self->{wantedIdx}]->{director};
                $self->{curInfo}->{firstaired} = $self->{itemsList}[$self->{wantedIdx}]->{firstaired};
                $self->{curInfo}->{writer} = $self->{itemsList}[$self->{wantedIdx}]->{writer};
                $self->{curInfo}->{actors} = $self->{itemsList}[$self->{wantedIdx}]->{actors};
                $self->{curInfo}->{genre} = $self->{itemsList}[$self->{wantedIdx}]->{genre};
                $self->{curInfo}->{time} = $self->{itemsList}[$self->{wantedIdx}]->{runtime};
                $self->{curInfo}->{image} = $self->{itemsList}[$self->{wantedIdx}]->{image};
                $self->{curInfo}->{synopsis} = $self->{itemsList}[$self->{wantedIdx}]->{overview};
            }
        }
    }

    sub end
    {
	my ($self, $tagname) = @_;
		
#        $self->{inside}->{$tagname}--;

        if ($self->{parsingList})
        {
            if ($tagname eq 'episode')
            {
               $self->{itemsList}[$self->{itemIdx}]->{url} = "";
               $self->{isEpisode} = 0;
               $self->{usedDVDordering} = 0;
            }
            if ($tagname eq 'series')
            {
               $self->{isSeries} = 0;
            }
            if ($tagname eq 'dvd_episodenumber')
            {
               $self->{isDVDEpisodeNumber} = 0;
            }
            if ($tagname eq 'dvd_season')
            {
               $self->{isDVDSeasonNumber} = 0;
            }
        }
    }

    sub text
    {
        my ($self, $origtext) = @_;

        $origtext =~ s/&#34;/"/g;
        $origtext =~ s/&#179;/3/g;
        $origtext =~ s/&#[0-9]*;//g;
        $origtext =~ s/\n//g;
        $origtext =~ s/^(\s)*//;
        $origtext =~ s/^\|//;
        $origtext =~ s/\|$//;

        return if ($self->{parsingEnded});

        if ($self->{pass} eq 1)
        {
            if ($self->{isSeriesID})
            {              
                $self->{itemIdx}++;
                $self->{itemsList}[$self->{itemIdx}]->{nextUrl} = "http://www.thetvdb.com/api/A8CC4AF70D0385F3/series/".$origtext."/all/".$self->siteLanguage().".xml";
                $self->{isSeriesID} = 0;
            }        
            if ($self->{isSeriesName})
            {
                $self->{itemsList}[$self->{itemIdx}]->{name} = $origtext;
                $self->{isSeriesName} = 0;
            }
        }
        else
        {        
            if ($self->{parsingList})
            {
                if ($self->{isSeriesName})
                {
                    $self->{seriesname} = $origtext;
                    $self->{isSeriesName} = 0;
                    return;
                }
                if ($self->{isActors})
                {
                    $self->{actors} = $origtext;
                    $self->{isActors} = 0;
                    return;
                }
                if ($self->{isGenre})
                {
                    $self->{genre} = $origtext;
                    $self->{isGenre} = 0;
                    return;
                }
                if ($self->{isRuntime})
                {
                    $self->{runtime} = $origtext;
                    $self->{isRuntime} = 0;
                    return;
                }
                if ($self->{isSeries} eq 0)
                {
                    if ($self->{isEpisode})
                    {
                        $self->{itemIdx}++;
                        $self->{isEpisode} = 0;
                        $self->{itemsList}[$self->{itemIdx}]->{series} = $self->{seriesname};
                        $self->{itemsList}[$self->{itemIdx}]->{actors} = $self->{actors};
                        $self->{itemsList}[$self->{itemIdx}]->{genre} = $self->{genre};
                        $self->{itemsList}[$self->{itemIdx}]->{runtime} = $self->{runtime};
                        return;
                    }
                    if ($self->{isEpisodeName})
                    {
                        $self->{itemsList}[$self->{itemIdx}]->{name} = $origtext;
                        $self->{isEpisodeName} = 0;
                        return;
                    }
                    if ($self->{isEpisodeNumber})
                    {
                        $self->{itemsList}[$self->{itemIdx}]->{episode} = $origtext;
                        $self->{itemsList}[$self->{itemIdx}]->{episode} =~ s/(\.0)$//;
                        $self->{isEpisodeNumber} = 0;
                        return;
                    }
                    if ($self->{isSeasonNumber})
                    {
                        $self->{itemsList}[$self->{itemIdx}]->{season} = $origtext;
                        $self->{isSeasonNumber} = 0;
                        return;
                    }
                    if (($self->{isDVDEpisodeNumber}) && ($origtext ne ""))
                    {
                        $self->{itemsList}[$self->{itemIdx}]->{episode} = $origtext;
                        $self->{itemsList}[$self->{itemIdx}]->{episode} =~ s/(\.0)$//;
                        $self->{isDVDEpisodeNumber} = 0;
                        $self->{usedDVDordering} = 1;
                        return;
                    }
                    if (($self->{isDVDSeasonNumber}) && ($origtext ne ""))
                    {
                        $self->{itemsList}[$self->{itemIdx}]->{season} = $origtext;
                        $self->{isDVDSeasonNumber} = 0;
                        $self->{usedDVDordering} = 1;
                        return;
                    }
                    if ($self->{isDirector})
                    {
                        $self->{itemsList}[$self->{itemIdx}]->{director} = $origtext;
                        $self->{isDirector} = 0;
                       return;
                    }
                    if ($self->{isFirstaired})
                    {
                        $self->{itemsList}[$self->{itemIdx}]->{firstaired} = $origtext;
                        $self->{isFirstaired} = 0;
                        return;
                    }
                    if ($self->{isWriter})
                    {
                        $self->{itemsList}[$self->{itemIdx}]->{writer} = $origtext;
                        $self->{isWriter} = 0;
                        return;
                    }
                    if ($self->{isImage})
                    {
                        $origtext =~ s/-/\//g;
                        $self->{itemsList}[$self->{itemIdx}]->{image} = "http://thetvdb.com/banners/".$origtext;
                        $self->{isImage} = 0;
                        return;
                    }
                    if ($self->{isOverview})
                    {
                        $self->{itemsList}[$self->{itemIdx}]->{overview} = $origtext;
                        $self->{isOverview} = 0;
                        return;
                    }
                }
            }
        }
    }

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{curName} = undef;
        $self->{curUrl} = undef;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;
        
        $self->{parsingEnded} = 0;

        return decode_utf8($html);
    }

    sub getSearchUrl
    {
	my ($self, $word) = @_;
        return "http://www.thetvdb.com/api/GetSeries.php?seriesname=$word&language=".$self->siteLanguage();
    }
    
    sub getItemUrl
    {
        my ($self, $url) = @_;
		
        return $url if $url =~ /^http:/;
        return "http://www.thetvdb.com".$url;
    }	

    sub getNumberPasses
    {
        return 2;
    }

    sub getName
    {
        return "Tvdb";
    }

    sub getReturnedFields
    {
        my $self = shift;

        if ($self->{pass} == 1)
        {
            $self->{hasField} = {
                name => 1
            };
        }
        else
        {
            $self->{hasField} = {
                name => 1,
                season => 1,
                episode => 1,
            };
        }
    }
    
    sub getAuthor
    {
        return 'Zombiepig';
    }
    
    sub getLang
    {
        return 'EN';
    }
    
    sub getCharset
    {
        my $self = shift;
    
        return "UTF-8";
    }

    sub convertCharset
    {
        my ($self, $value) = @_;
        return $value;
    }

    sub siteLanguage
    {
        my $self = shift;
        
        return 'en';
    }
}

1;
