# This file was created from xpl/ambigfus.xpl, do not edit!
#########################################################################
##
#W  ambigfus.tst              GAP applications              Thomas Breuer
##
#H  @(#)$Id: ambigfus.tst,v 1.8 2004/03/31 06:46:06 gap Exp $
##
#Y  Copyright 2003,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,   Germany
##
##  In order to run the tests, one starts {GAP} from the `tst` subdirectory
##  of the `pkg/` directory, and calls `ReadTest( "ambigfus.tst" );`.
##

gap> START_TEST("$Id: ambigfus.xpl,v 1.8 2004/03/31 06:46:06 gap Exp $");

gap> LoadPackage( "ctbllib" );
true
gap> co3:= CharacterTable( "Co3" );
CharacterTable( "Co3" )
gap> h:= CharacterTable( "Co3N5" );
CharacterTable( "5^(1+2):(24:2)" )
gap> hfusco3:= PossibleClassFusions( h, co3 );;
gap> Length( RepresentativesFusions( h, hfusco3, co3 ) );
2
gap> mx:= Maxes( co3 );
[ "McL.2", "HS", "U4(3).(2^2)_{133}", "M23", "3^5:(2xm11)", "2.S6(2)", 
  "U3(5).3.2", "3^1+4:4s6", "2^4.a8", "psl(3,4):d12", "2xm12", 
  "2^2.(2^7.3^2).s3", "s3xpsl(2,8).3", "a4xs5" ]
gap> maxes:= List( mx, CharacterTable );;
gap> filt:= Filtered( maxes, x -> Size( x ) mod Size( h ) = 0 );
[ CharacterTable( "McL.2" ), CharacterTable( "HS" ), 
  CharacterTable( "U3(5).3.2" ) ]
gap> max:= filt[1];;
gap> hfusmax:= PossibleClassFusions( h, max );;
gap> maxfusco3:= PossibleClassFusions( max, co3 );;
gap> comp:= [];;
gap> for map1 in maxfusco3 do
>      for map2 in hfusmax do
>        AddSet( comp, CompositionMaps( map1, map2 ) );
>      od;
>    od;
gap> Length( comp );
2
gap> reps:= RepresentativesFusions( h, comp, co3 );
[ [ 1, 2, 3, 4, 8, 8, 7, 9, 10, 11, 17, 17, 19, 19, 22, 23, 27, 27, 30, 33, 
      34, 40, 40, 40, 40, 42 ] ]
gap> max:= filt[3];;
gap> hfusmax:= PossibleClassFusions( h, max );;
gap> maxfusco3:= PossibleClassFusions( max, co3 );;
gap> comp:= [];;
gap> for map1 in maxfusco3 do
>      for map2 in hfusmax do
>        AddSet( comp, CompositionMaps( map1, map2 ) );
>      od;
>    od;
gap> reps2:= RepresentativesFusions( h, comp, co3 );;
gap> reps2 = reps;
true
gap> GetFusionMap( h, co3 ) in reps;
true
gap> b:= CharacterTable( "B" );;
gap> h:= CharacterTable( "31:15" );;
gap> hfusb:= PossibleClassFusions( h, b );;
gap> Length( RepresentativesFusions( h, hfusb, b ) );
2
gap> th:= CharacterTable( "Th" );;
gap> hfusth:= PossibleClassFusions( h, th );;
gap> thfusb:= PossibleClassFusions( th, b );;
gap> comp:= [];;
gap> for map1 in hfusth do
>      for map2 in thfusb do
>        AddSet( comp, CompositionMaps( map2, map1 ) );
>      od;
>    od;
gap> Length( comp );
2
gap> reps:= RepresentativesFusions( h, comp, b );
[ [ 1, 145, 146, 82, 82, 19, 82, 7, 19, 82, 82, 19, 7, 82, 19, 82, 82 ] ]
gap> GetFusionMap( h, b ) in reps;
true
gap> h:= CharacterTable( "SuzN3" );
CharacterTable( "3^5:(3^2:SD16)" )
gap> suz:= CharacterTable( "Suz" );
CharacterTable( "Suz" )
gap> hfussuz:= PossibleClassFusions( h, suz );;
gap> Length( RepresentativesFusions( h, hfussuz, suz ) );
2
gap> maxes:= List( Maxes( suz ), CharacterTable );;
gap> filt:= Filtered( maxes, x -> Size( x ) mod Size( h ) = 0 );
[ CharacterTable( "3_2.U4(3).2_3'" ), CharacterTable( "3^5:M11" ), 
  CharacterTable( "3^2+4:2(2^2xa4)2" ) ]
gap> PossibleClassFusions( h, filt[1] );
[  ]
gap> max:= filt[2];;
gap> hfusmax:= PossibleClassFusions( h, max );;
gap> maxfussuz:= PossibleClassFusions( max, suz );;
gap> comp:= [];;
gap> for map1 in hfusmax do
>      for map2 in maxfussuz do
>        AddSet( comp, CompositionMaps( map2, map1 ) );
>      od;
>    od;
gap> repr:= RepresentativesFusions( h, comp, suz );
[ [ 1, 2, 2, 4, 5, 4, 5, 5, 5, 5, 5, 6, 9, 9, 14, 15, 13, 16, 16, 14, 15, 13, 
      13, 13, 16, 15, 14, 16, 16, 16, 21, 21, 23, 22, 29, 29, 29, 38, 39 ] ]
gap> GetFusionMap( h, suz ) in repr;
true
gap> f3p:= CharacterTable( "F3+" );;
gap> h:= CharacterTable( "F3+N5" );;
gap> hfusf3p:= PossibleClassFusions( h, f3p );;
gap> Length( RepresentativesFusions( h, hfusf3p, f3p ) );
2
gap> maxes:= List( Maxes( f3p ), CharacterTable );;
gap> filt:= Filtered( maxes, x -> Size( x ) mod Size( h ) = 0 );
[ CharacterTable( "Fi23" ), CharacterTable( "2.Fi22.2" ), 
  CharacterTable( "(3xO8+(3):3):2" ), CharacterTable( "O10-(2)" ), 
  CharacterTable( "(A4xO8+(2).3).2" ), CharacterTable( "He.2" ), 
  CharacterTable( "F3+M14" ), CharacterTable( "(A5xA9):2" ) ]
gap> possfus:= List( filt, x -> PossibleClassFusions( h, x ) );
[ [  ], [  ], [  ], [  ], 
  [ [ 1, 69, 110, 12, 80, 121, 4, 72, 113, 11, 11, 79, 79, 120, 120, 3, 71, 
          11, 79, 23, 91, 112, 120, 132, 29, 32, 97, 100, 37, 37, 105, 105, 
          139, 140, 145, 146, 155, 155, 156, 156, 44, 44, 167, 167, 48, 48, 
          171, 171, 57, 57, 180, 180, 66, 66, 189, 189 ], 
      [ 1, 69, 110, 12, 80, 121, 4, 72, 113, 11, 11, 79, 79, 120, 120, 3, 71, 
          11, 79, 23, 91, 112, 120, 132, 29, 32, 97, 100, 37, 37, 105, 105, 
          140, 139, 146, 145, 156, 156, 155, 155, 44, 44, 167, 167, 48, 48, 
          171, 171, 57, 57, 180, 180, 66, 66, 189, 189 ] ], [  ], [  ], [  ] ]
gap> max:= filt[5];
CharacterTable( "(A4xO8+(2).3).2" )
gap> hfusmax:= possfus[5];;
gap> maxfusf3p:= PossibleClassFusions( max, f3p );;
gap> comp:= [];;                 
gap> for map1 in maxfusf3p do
>      for map2 in hfusmax do
>        AddSet( comp, CompositionMaps( map1, map2 ) );
>      od;
>    od;
gap> Length( comp );
2
gap> repr:= RepresentativesFusions( h, comp, f3p );
[ [ 1, 2, 4, 12, 35, 54, 3, 3, 16, 9, 9, 11, 11, 40, 40, 2, 3, 9, 11, 35, 36, 
      13, 40, 90, 7, 22, 19, 20, 43, 43, 50, 50, 8, 8, 23, 23, 46, 46, 47, 
      47, 10, 10, 9, 9, 10, 10, 11, 11, 26, 26, 28, 28, 67, 67, 68, 68 ] ]
gap> GetFusionMap( h, f3p ) in repr;
true
gap> m:= CharacterTable( "(A4xO8+(2).3).2" );;
gap> t:= CharacterTable( "F3+" );;
gap> mfust:= PossibleClassFusions( m, t );;
gap> repr:= RepresentativesFusions( m, mfust, t );;
gap> Length( repr );
2
gap> a4inm:= Filtered( ClassPositionsOfNormalSubgroups( m ),
>                      n -> Sum( SizesConjugacyClasses( m ){ n } ) = 12 );
[ [ 1, 69, 110 ] ]
gap> OrdersClassRepresentatives( m ){ a4inm[1] };
[ 1, 2, 3 ]
gap> List( repr, map -> map[110] );
[ 4, 4 ]
gap> OrdersClassRepresentatives( t ){ [ 1 .. 4 ] };
[ 1, 2, 2, 3 ]
gap> s:= CharacterTable( "F3+N3A" );
CharacterTable( "(3xO8+(3):3):2" )
gap> u:= CharacterTable( "Cyclic", 3 ) * CharacterTable( "O8+(2).3" );
CharacterTable( "C3xO8+(2).3" )
gap> ufuss:= PossibleClassFusions( u, s );;
gap> ufusm:= PossibleClassFusions( u, m );;
gap> sfust:= PossibleClassFusions( s, t );;
gap> comp:= [];;
gap> for map1 in ufuss do
>   for map2 in sfust do
>     AddSet( comp, CompositionMaps( map2, map1 ) );
>   od;
> od;
gap> Length( comp );
6
gap> filt:= Filtered( mfust,
>     x -> ForAny( ufusm, map -> CompositionMaps( x, map ) in comp ) );;
gap> repr:= RepresentativesFusions( m, filt, t );;
gap> Length( repr );
1
gap> GetFusionMap( m, t ) in repr;
true
gap> m:= CharacterTable( "A6xL2(8):3" );;
gap> t:= CharacterTable( "F3+" );;
gap> mfust:= PossibleClassFusions( m, t );;
gap> Length( RepresentativesFusions( m, mfust, t ) );
2
gap> dppos:= ClassPositionsOfDirectProductDecompositions( m );
[ [ [ 1, 12 .. 67 ], [ 1 .. 11 ] ] ]
gap> List( dppos[1], l -> Sum( SizesConjugacyClasses( t ){ l } ) );
[ 17733424133316996808705, 4545066196775803392 ]
gap> List( dppos[1], l -> Sum( SizesConjugacyClasses( m ){ l } ) );
[ 360, 1512 ]
gap> 3Apos:= Position( OrdersClassRepresentatives( t ), 3 );
4
gap> 3Ainm:= List( mfust, map -> Position( map, 3Apos ) );
[ 23, 23, 23, 23, 34, 34, 34, 34 ]
gap> ForAll( 3Ainm, x -> x in dppos[1][1] );
true
gap> u:= CharacterTable( "3^2:2" ) * CharacterTable( "L2(8).3" );
CharacterTable( "3^2:2xL2(8).3" )
gap> s:= CharacterTable( "F3+N3A" );
CharacterTable( "(3xO8+(3):3):2" )
gap> ufuss:= PossibleClassFusions( u, s );;
gap> comp:= [];;
gap> for map1 in sfust do
>      for map2 in ufuss do
>        AddSet( comp, CompositionMaps( map1, map2 ) );
>      od;
>    od;
gap> ufusm:= PossibleClassFusions( u, m );;
gap> filt:= Filtered( mfust,
>               map -> ForAny( ufusm,   
>                          map2 -> CompositionMaps( map, map2 ) in comp ) );;
gap> repr:= RepresentativesFusions( m, filt, t );;
gap> Length( repr );
1
gap> GetFusionMap( m, t ) in repr;
true
gap> s:= CharacterTable( "L2(16).4" );;
gap> t:= CharacterTable( "J3.2" );;
gap> fus:= PossibleClassFusions( s, t );
[ [ 1, 2, 3, 6, 14, 15, 16, 2, 5, 7, 12, 5, 5, 8, 8, 13, 13 ],
  [ 1, 2, 3, 6, 14, 15, 16, 2, 5, 7, 12, 19, 19, 22, 22, 23, 23 ],
  [ 1, 2, 3, 6, 14, 16, 15, 2, 5, 7, 12, 5, 5, 8, 8, 13, 13 ],
  [ 1, 2, 3, 6, 14, 16, 15, 2, 5, 7, 12, 19, 19, 22, 22, 23, 23 ] ]
gap> RepresentativesFusions( s, fus, t );
[ [ 1, 2, 3, 6, 14, 15, 16, 2, 5, 7, 12, 5, 5, 8, 8, 13, 13 ], 
  [ 1, 2, 3, 6, 14, 15, 16, 2, 5, 7, 12, 19, 19, 22, 22, 23, 23 ] ]
gap> j3:= CharacterTable( "J3" );;
gap> PossibleClassFusions( s, j3 );
[  ]
gap> GetFusionMap( j3, t );
[ 1, 2, 3, 4, 5, 6, 6, 7, 8, 9, 10, 11, 12, 12, 13, 14, 14, 15, 16, 17, 17 ]
gap> filt:= Filtered( fus,
>          x -> not IsSubset( ClassPositionsOfDerivedSubgroup( t ), x ) );
[ [ 1, 2, 3, 6, 14, 15, 16, 2, 5, 7, 12, 19, 19, 22, 22, 23, 23 ], 
  [ 1, 2, 3, 6, 14, 16, 15, 2, 5, 7, 12, 19, 19, 22, 22, 23, 23 ] ]
gap> smod2:= s mod 2;;
gap> tmod2:= t mod 2;;
gap> admissible:= [];;
gap> for map in filt do
>      modmap:= CompositionMaps( InverseMap( GetFusionMap( tmod2, t ) ),
>                   CompositionMaps( map, GetFusionMap( smod2, s ) ) );
>      if not fail in Decomposition( Irr( smod2 ),
>            List( Irr( tmod2 ), chi -> chi{ modmap } ), "nonnegative" ) then
>        AddSet( admissible, map );
>      fi;
>    od;
gap> admissible;
[ [ 1, 2, 3, 6, 14, 16, 15, 2, 5, 7, 12, 19, 19, 22, 22, 23, 23 ] ]
gap> CTblLibTestDecompositions( s, fus, t ) = admissible;
true
gap> GetFusionMap( s, t ) in admissible;
true
gap> s:= CharacterTable( "L2(19)" );;
gap> t:= CharacterTable( "J3" );;
gap> sfust:= PossibleClassFusions( s, t );
[ [ 1, 2, 4, 6, 7, 10, 11, 12, 13, 14, 20, 21 ],
  [ 1, 2, 4, 6, 7, 10, 11, 12, 13, 14, 21, 20 ],
  [ 1, 2, 4, 6, 7, 11, 12, 10, 13, 14, 20, 21 ],
  [ 1, 2, 4, 6, 7, 11, 12, 10, 13, 14, 21, 20 ],
  [ 1, 2, 4, 6, 7, 12, 10, 11, 13, 14, 20, 21 ],
  [ 1, 2, 4, 6, 7, 12, 10, 11, 13, 14, 21, 20 ],
  [ 1, 2, 4, 7, 6, 10, 11, 12, 14, 13, 20, 21 ],
  [ 1, 2, 4, 7, 6, 10, 11, 12, 14, 13, 21, 20 ],
  [ 1, 2, 4, 7, 6, 11, 12, 10, 14, 13, 20, 21 ],
  [ 1, 2, 4, 7, 6, 11, 12, 10, 14, 13, 21, 20 ],
  [ 1, 2, 4, 7, 6, 12, 10, 11, 14, 13, 20, 21 ],
  [ 1, 2, 4, 7, 6, 12, 10, 11, 14, 13, 21, 20 ] ]
gap> fusreps:= RepresentativesFusions( s, sfust, t );
[ [ 1, 2, 4, 6, 7, 10, 11, 12, 13, 14, 20, 21 ] ]
gap> tmod19:= t mod 19;
BrauerTable( "J3", 19 )
gap> deg110:= Filtered( Irr( tmod19 ), phi -> phi[1] = 110 );
[ Character( BrauerTable( "J3", 19 ), [ 110, -2, 5, 2, 2, 0, 0, 1, 0, 
      -2*E(9)^2+E(9)^3-E(9)^4-E(9)^5+E(9)^6-2*E(9)^7, 
      E(9)^2+E(9)^3-E(9)^4-E(9)^5+E(9)^6+E(9)^7, 
      E(9)^2+E(9)^3+2*E(9)^4+2*E(9)^5+E(9)^6+E(9)^7, -2, -2, -1, 0, 0, 
      E(17)+E(17)^2+E(17)^4+E(17)^8+E(17)^9+E(17)^13+E(17)^15+E(17)^16, 
      E(17)^3+E(17)^5+E(17)^6+E(17)^7+E(17)^10+E(17)^11+E(17)^12+E(17)^14 ] ) 
 ]
gap> 9A:= Position( OrdersClassRepresentatives( tmod19 ), 9 );
10
gap> deg110[1][ 9A ];
-2*E(9)^2+E(9)^3-E(9)^4-E(9)^5+E(9)^6-2*E(9)^7
gap> AtlasIrrationality( "-1+2y9+&4" ) = deg110[1][ 9A ];
true
gap> smod19:= s mod 19;
BrauerTable( "L2(19)", 19 )
gap> compatible:= [];;
gap> for map in sfust do
>      comp:= CompositionMaps( InverseMap( GetFusionMap( tmod19, t ) ),
>      CompositionMaps( map, GetFusionMap( smod19, s ) ) );
>      rest:= List( Irr( tmod19 ), phi -> phi{ comp } );
>      if not fail in Decomposition( Irr( smod19 ), rest, "nonnegative" ) then
>        Add( compatible, map );
>      fi;
>    od;
gap> compatible;
[ [ 1, 2, 4, 6, 7, 11, 12, 10, 13, 14, 20, 21 ],
  [ 1, 2, 4, 6, 7, 11, 12, 10, 13, 14, 21, 20 ],
  [ 1, 2, 4, 6, 7, 12, 10, 11, 13, 14, 20, 21 ],
  [ 1, 2, 4, 6, 7, 12, 10, 11, 13, 14, 21, 20 ],
  [ 1, 2, 4, 7, 6, 11, 12, 10, 14, 13, 20, 21 ],
  [ 1, 2, 4, 7, 6, 11, 12, 10, 14, 13, 21, 20 ],
  [ 1, 2, 4, 7, 6, 12, 10, 11, 14, 13, 20, 21 ],
  [ 1, 2, 4, 7, 6, 12, 10, 11, 14, 13, 21, 20 ] ]
gap> reps:= RepresentativesFusions( s, compatible, t );
[ [ 1, 2, 4, 6, 7, 11, 12, 10, 13, 14, 20, 21 ],
  [ 1, 2, 4, 6, 7, 12, 10, 11, 13, 14, 20, 21 ] ]
gap> compatiblemod19:= List( reps, map -> CompositionMaps(
>        InverseMap( GetFusionMap( tmod19, t ) ),
>        CompositionMaps( map, GetFusionMap( smod19, s ) ) ) );
[ [ 1, 2, 4, 6, 7, 11, 12, 10, 13, 14 ], 
  [ 1, 2, 4, 6, 7, 12, 10, 11, 13, 14 ] ]
gap> rest:= List( compatiblemod19, map -> Irr( tmod19 )[3]{ map } );;
gap> dec:= Decomposition( Irr( smod19 ), rest, "nonnegative" );
[ [ 0, 0, 1, 2, 1, 2, 2, 1, 0, 1 ], [ 0, 2, 0, 2, 0, 1, 2, 0, 2, 1 ] ]
gap> List( Irr( smod19 ), phi -> phi[1] );
[ 1, 3, 5, 7, 9, 11, 13, 15, 17, 19 ]
gap> LoadPackage( "atlasrep" );
true
gap> prog:= AtlasStraightLineProgram( "J3", "maxes", 2 );
rec( program := <straight line program>, standardization := 1, 
  identifier := [ "J3", "J3G1-max2W1", 1 ] )
gap> gens:= OneAtlasGeneratingSet( "J3", Characteristic, 19, Dimension, 110 );
rec( generators := [ < immutable compressed matrix 110x110 over GF(19) >, 
      < immutable compressed matrix 110x110 over GF(19) > ], 
  standardization := 1, 
  identifier := [ "J3", [ "J3G1-f19r110B0.m1", "J3G1-f19r110B0.m2" ], 1, 19 ] 
 )
gap> restgens:= ResultOfStraightLineProgram( prog.program, gens.generators );
[ < immutable compressed matrix 110x110 over GF(19) >,
  < immutable compressed matrix 110x110 over GF(19) > ]
gap> module:= GModuleByMats( restgens, GF( 19 ) );;
gap> facts:= SMTX.CollectedFactors( module );;
gap> Length( facts );
7
gap> List( facts, x -> x[1].dimension );
[ 5, 7, 9, 11, 13, 15, 19 ]
gap> List( facts, x -> x[2] );
[ 1, 2, 1, 2, 2, 1, 1 ]
gap> GetFusionMap( s, t ) = reps[1];
true
gap> LoadPackage( "atlasrep" );
true
gap> t:= CharacterTable( "F3+" );
CharacterTable( "F3+" )
gap> s:= CharacterTable( "U3(3).2" );
CharacterTable( "U3(3).2" )
gap> tnames:= ClassNames( t, "ATLAS" );
[ "1A", "2A", "2B", "3A", "3B", "3C", "3D", "3E", "4A", "4B", "4C", "5A", 
  "6A", "6B", "6C", "6D", "6E", "6F", "6G", "6H", "6I", "6J", "6K", "7A", 
  "7B", "8A", "8B", "8C", "9A", "9B", "9C", "9D", "9E", "9F", "10A", "10B", 
  "11A", "12A", "12B", "12C", "12D", "12E", "12F", "12G", "12H", "12I", 
  "12J", "12K", "12L", "12M", "13A", "14A", "14B", "15A", "15B", "15C", 
  "16A", "17A", "18A", "18B", "18C", "18D", "18E", "18F", "18G", "18H", 
  "20A", "20B", "21A", "21B", "21C", "21D", "22A", "23A", "23B", "24A", 
  "24B", "24C", "24D", "24E", "24F", "24G", "26A", "27A", "27B", "27C", 
  "28A", "29A", "29B", "30A", "30B", "33A", "33B", "35A", "36A", "36B", 
  "36C", "36D", "39A", "39B", "39C", "39D", "42A", "42B", "42C", "45A", 
  "45B", "60A" ]
gap> OrdersClassRepresentatives( s );
[ 1, 2, 3, 3, 4, 4, 6, 7, 8, 12, 2, 4, 6, 8, 12, 12 ]
gap> sfust:= List( [ "1A", "2B", "3D", "3E", "4C", "4C", "6J", "7B", "8C",
>                    "12M" ], x -> Position( tnames, x ) );
[ 1, 3, 7, 8, 11, 11, 22, 25, 28, 50 ]
gap> sfust:= PossibleClassFusions( s, t, rec( fusionmap:= sfust ) );
[ [ 1, 3, 7, 8, 11, 11, 22, 25, 28, 50, 3, 9, 23, 28, 43, 43 ], 
  [ 1, 3, 7, 8, 11, 11, 22, 25, 28, 50, 3, 11, 23, 28, 50, 50 ] ]
gap> OrdersClassRepresentatives( s );
[ 1, 2, 3, 3, 4, 4, 6, 7, 8, 12, 2, 4, 6, 8, 12, 12 ]
gap> Maxes( s );
[ "U3(3)", "3^(1+2):SD16", "L3(2).2", "2^(1+4).S3", "4^2:D12" ]
gap> SizesCentralizers( s );
[ 12096, 192, 216, 18, 96, 32, 24, 7, 8, 12, 48, 48, 6, 8, 12, 12 ]
gap> u:= CharacterTable( Maxes( s )[2] );;
gap> ufuss:= GetFusionMap( u, s );
[ 1, 2, 11, 3, 4, 5, 12, 7, 13, 9, 9, 15, 16, 10 ]
gap> 3Dcentralizer:= SizesCentralizers( t )[7];
153055008
gap> cand:= [];;                                                               
gap> for name in Maxes( t ) do
>      m:= CharacterTable( name );
>      mfust:= GetFusionMap( m, t );        
>      if ForAny( [ 1 .. Length( mfust ) ],                    
>          i -> mfust[i] = 7 and SizesCentralizers( m )[i] = 3Dcentralizer )   
>      then
>        Add( cand, m );
>      fi;
>    od;
gap> cand;
[ CharacterTable( "3^7.O7(3)" ), CharacterTable( "3^2.3^4.3^8.(A5x2A4).2" ) ]
gap> possufust:= List( sfust, x -> CompositionMaps( x, ufuss ) );
[ [ 1, 3, 3, 7, 8, 11, 9, 22, 23, 28, 28, 43, 43, 50 ], 
  [ 1, 3, 3, 7, 8, 11, 11, 22, 23, 28, 28, 50, 50, 50 ] ]
gap> m:= cand[1];;
gap> ufusm:= PossibleClassFusions( u, m );;
gap> Length( ufusm );
242
gap> comp:= List( ufusm, x -> CompositionMaps( GetFusionMap( m, t ), x ) );;
gap> Intersection( possufust, comp );
[ [ 1, 3, 3, 7, 8, 11, 11, 22, 23, 28, 28, 50, 50, 50 ] ]
gap> m:= cand[2];;
gap> ufusm:= PossibleClassFusions( u, m );;
gap> Length( ufusm );                        
256
gap> comp:= List( ufusm, x -> CompositionMaps( GetFusionMap( m, t ), x ) );;   
gap> Intersection( possufust, comp );
[ [ 1, 3, 3, 7, 8, 11, 11, 22, 23, 28, 28, 50, 50, 50 ] ]
gap> GetFusionMap( s, t ) = sfust[2];
true
gap> t:= CharacterTable( "F3+" );;
gap> u:= CharacterTable( "L2(13).2" );;
gap> fus:= PossibleClassFusions( u, t );;
gap> repr:= RepresentativesFusions( u, fus, t );;
gap> Length( repr );
3
gap> filt:= Filtered( repr, x -> t.2b in x and t.3d in x and t.7b in x );
[ [ 1, 3, 7, 22, 25, 25, 25, 51, 3, 9, 43, 43, 53, 53, 53 ], 
  [ 1, 3, 7, 22, 25, 25, 25, 51, 3, 11, 50, 50, 53, 53, 53 ] ]
gap> ClassNames( t ){ [ 43, 50 ] };
[ "12f", "12m" ]
gap> pos:= Position( OrdersClassRepresentatives( t ), 13 );
51
gap> SizesCentralizers( t )[ pos ];
234
gap> ClassOrbit( t, pos );
[ 51 ]
gap> cand:= [];;                                                         
gap> for name in Maxes( t ) do
>      m:= CharacterTable( name );
>      pos:= Position( OrdersClassRepresentatives( m ), 13 );
>      if pos <> fail and                                             
>         SizesCentralizers( m )[ pos ] = 234                         
>         and ClassOrbit( m, pos ) = [ pos ] then
>        Add( cand, m );
>      fi;
>    od;
gap> cand;
[ CharacterTable( "(3^2:2xG2(3)).2" ) ]
gap> s:= cand[1];;
gap> sfust:= PossibleClassFusions( s, t );;
gap> der:= ClassPositionsOfDerivedSubgroup( s );;
gap> outer:= Difference( [ 1 .. NrConjugacyClasses( s ) ], der );;
gap> sfust:= PossibleClassFusions( s, t );;
gap> imgs:= Set( Flat( List( sfust, x -> x{ outer } ) ) );
[ 2, 3, 10, 11, 15, 17, 18, 19, 21, 22, 26, 44, 45, 49, 50, 52, 62, 83, 87, 
  98 ]
gap> t.12f in imgs;
false
gap> t.12m in imgs;
true
gap> GetFusionMap( u, t ) = filt[2];
true
gap> b:= CharacterTable( "B" );;
gap> u:= CharacterTable( "L2(17).2" );;
gap> ufusb:= PossibleClassFusions( u, b );
[ [ 1, 5, 7, 15, 42, 42, 47, 47, 47, 91, 4, 30, 89, 89, 89, 89, 97, 97, 97 ], 
  [ 1, 5, 7, 15, 44, 44, 46, 46, 46, 91, 5, 29, 90, 90, 90, 90, 96, 96, 96 ], 
  [ 1, 5, 7, 15, 44, 44, 47, 47, 47, 91, 5, 29, 90, 90, 90, 90, 95, 95, 95 ] ]
gap> names:= ClassNames( b, "ATLAS" );;
gap> pos:= List( [ "8M", "9A" ], x -> Position( names, x ) );
[ 44, 46 ]
gap> ufusb:= Filtered( ufusb, map -> IsSubset( map, pos ) );
[ [ 1, 5, 7, 15, 44, 44, 46, 46, 46, 91, 5, 29, 90, 90, 90, 90, 96, 96, 96 ] ]
gap> GetFusionMap( u, b ) = ufusb[1];
true
gap> t:= CharacterTable( "G2(5)" );;
gap> s:= CharacterTable( "2^3.L3(2)" );;
gap> sfust:= PossibleClassFusions( s, t );;
gap> RepresentativesFusions( s, sfust, t );
[ [ 1, 2, 2, 5, 6, 4, 13, 16, 17, 15, 15 ], 
  [ 1, 2, 2, 5, 6, 4, 14, 16, 17, 15, 15 ] ]
gap> gens:= OneAtlasGeneratingSet( "G2(5)" );;
gap> g:= Group( gens.generators );;
gap> prg:= AtlasStraightLineProgram( "G2(5)", "maxes", 7 );;
gap> subgens:= ResultOfStraightLineProgram( prg.program, gens.generators );;
gap> u:= Group( gens.generators );;
gap> repeat
>      x:= Random( u );
>    until Order( x ) = 6;
gap> siz:= Size( Centralizer( g, x ) );
36
gap> Filtered( [ 1 .. NrConjugacyClasses( t ) ],
>              i -> SizesCentralizers( t )[i] = siz );
[ 14 ]
gap> GetFusionMap( s, t ) in Filtered( sfust, map -> 14 in map );  
true
gap> tbl:= CharacterTable( "7^2:2psl(2,7)" );
CharacterTable( "7^2:2psl(2,7)" )
gap> tom:= TableOfMarks( FusionToTom( tbl ).name );
TableOfMarks( "7^2:2L2(7)" )
gap> fus:= PossibleFusionsCharTableTom( tbl, tom );
[ [ 1, 6, 2, 4, 3, 5, 13, 13, 7, 8, 10, 9, 16, 7, 10, 9, 8, 16 ], 
  [ 1, 6, 2, 4, 3, 5, 13, 13, 7, 9, 8, 10, 16, 7, 8, 10, 9, 16 ], 
  [ 1, 6, 2, 4, 3, 5, 13, 13, 7, 10, 9, 8, 16, 7, 9, 8, 10, 16 ], 
  [ 1, 6, 2, 4, 3, 5, 13, 13, 7, 8, 9, 10, 16, 7, 9, 10, 8, 16 ], 
  [ 1, 6, 2, 4, 3, 5, 13, 13, 7, 10, 8, 9, 16, 7, 8, 9, 10, 16 ], 
  [ 1, 6, 2, 4, 3, 5, 13, 13, 7, 9, 10, 8, 16, 7, 10, 8, 9, 16 ] ]
gap> reps:= RepresentativesFusions( tbl, fus, Group(()) );        
[ [ 1, 6, 2, 4, 3, 5, 13, 13, 7, 8, 9, 10, 16, 7, 9, 10, 8, 16 ], 
  [ 1, 6, 2, 4, 3, 5, 13, 13, 7, 8, 10, 9, 16, 7, 10, 9, 8, 16 ] ]
gap> AutomorphismsOfTable( tbl );
Group([ (9,14)(10,17)(11,15)(12,16)(13,18), (7,8), (10,11,12)(15,16,17) ])
gap> OrdersClassRepresentatives( tbl );
[ 1, 7, 2, 4, 3, 6, 8, 8, 7, 7, 7, 7, 14, 7, 7, 7, 7, 14 ]
gap> perms1:= PermCharsTom( reps[1], tom );;
gap> perms2:= PermCharsTom( reps[2], tom );;
gap> perms1 = perms2;      
false
gap> Set( perms1 ) = Set( perms2 );
true
gap> Display( tbl );
7^2:2psl(2,7)

      2  4  .  4  3  1  1  3  3   1   .   .   .   1   1   .   .   .   1
      3  1  .  1  .  1  1  .  .   .   .   .   .   .   .   .   .   .   .
      7  3  3  1  .  .  .  .  .   2   2   2   2   1   2   2   2   2   1

        1a 7a 2a 4a 3a 6a 8a 8b  7b  7c  7d  7e 14a  7f  7g  7h  7i 14b
     2P 1a 7a 1a 2a 3a 3a 4a 4a  7b  7c  7d  7e  7b  7f  7g  7h  7i  7f
     3P 1a 7a 2a 4a 1a 2a 8b 8a  7f  7i  7g  7h 14b  7b  7d  7e  7c 14a
     5P 1a 7a 2a 4a 3a 6a 8b 8a  7f  7i  7g  7h 14b  7b  7d  7e  7c 14a
     7P 1a 1a 2a 4a 3a 6a 8a 8b  1a  1a  1a  1a  2a  1a  1a  1a  1a  2a
    11P 1a 7a 2a 4a 3a 6a 8b 8a  7b  7c  7d  7e 14a  7f  7g  7h  7i 14b
    13P 1a 7a 2a 4a 3a 6a 8b 8a  7f  7i  7g  7h 14b  7b  7d  7e  7c 14a

X.1      1  1  1  1  1  1  1  1   1   1   1   1   1   1   1   1   1   1
X.2      3  3  3 -1  .  .  1  1   B   B   B   B   B  /B  /B  /B  /B  /B
X.3      3  3  3 -1  .  .  1  1  /B  /B  /B  /B  /B   B   B   B   B   B
X.4      6  6  6  2  .  .  .  .  -1  -1  -1  -1  -1  -1  -1  -1  -1  -1
X.5      7  7  7 -1  1  1 -1 -1   .   .   .   .   .   .   .   .   .   .
X.6      8  8  8  . -1 -1  .  .   1   1   1   1   1   1   1   1   1   1
X.7      4  4 -4  .  1 -1  .  .  -B  -B  -B  -B   B -/B -/B -/B -/B  /B
X.8      4  4 -4  .  1 -1  .  . -/B -/B -/B -/B  /B  -B  -B  -B  -B   B
X.9      6  6 -6  .  .  .  A -A  -1  -1  -1  -1   1  -1  -1  -1  -1   1
X.10     6  6 -6  .  .  . -A  A  -1  -1  -1  -1   1  -1  -1  -1  -1   1
X.11     8  8 -8  . -1  1  .  .   1   1   1   1  -1   1   1   1   1  -1
X.12    48 -1  .  .  .  .  .  .   6  -1  -1  -1   .   6  -1  -1  -1   .
X.13    48 -1  .  .  .  .  .  .   C  -1  /C  /D   .  /C   C   D  -1   .
X.14    48 -1  .  .  .  .  .  .   C  /C  /D  -1   .  /C   D  -1   C   .
X.15    48 -1  .  .  .  .  .  .  /C   D  -1   C   .   C  -1  /C  /D   .
X.16    48 -1  .  .  .  .  .  .   C  /D  -1  /C   .  /C  -1   C   D   .
X.17    48 -1  .  .  .  .  .  .  /C   C   D  -1   .   C  /D  -1  /C   .
X.18    48 -1  .  .  .  .  .  .  /C  -1   C   D   .   C  /C  /D  -1   .

A = E(8)-E(8)^3
  = ER(2) = r2
B = E(7)+E(7)^2+E(7)^4
  = (-1+ER(-7))/2 = b7
C = 2*E(7)+2*E(7)^2+2*E(7)^4
  = -1+ER(-7) = 2b7
D = -3*E(7)-3*E(7)^2-2*E(7)^3-3*E(7)^4-2*E(7)^5-2*E(7)^6
  = (5-ER(-7))/2 = 2-b7
gap> mat:= MatTom( tom );;
gap> mataut:= MatrixAutomorphisms( mat );;
gap> Print( mataut, "\n" );
Group( [ (11,12)(23,24)(27,28)(46,47)(53,54)(56,57), 
  ( 9,10)(20,21)(31,32)(38,39), ( 8, 9)(20,22)(31,33)(38,40) ] )
gap> RepresentativesFusions( Group( () ), reps, mataut );
[ [ 1, 6, 2, 4, 3, 5, 13, 13, 7, 8, 9, 10, 16, 7, 9, 10, 8, 16 ] ]
gap> g:= UnderlyingGroup( tom );;
gap> tg:= CharacterTable( g );;
gap> tgfustom:= FusionCharTableTom( tg, tom );
[ 1, 6, 2, 3, 5, 16, 7, 8, 10, 9, 7, 8, 10, 9, 16, 4, 13, 13 ]
gap> trans:= TransformingPermutationsCharacterTables( tg, tbl );;
gap> tblfustom:= Permuted( tgfustom, trans.columns );
[ 1, 6, 2, 4, 3, 5, 13, 13, 7, 8, 10, 9, 16, 7, 10, 9, 8, 16 ]
gap> orbits:= List( reps, map -> OrbitFusions( AutomorphismsOfTable( tbl ),
>                                              map, Group( () ) ) );;
gap> PositionProperty( orbits, orb -> tblfustom in orb );
2
gap> PositionProperty( orbits, orb -> FusionToTom( tbl ).map in orb );
2

gap> STOP_TEST( "ambigfus.tst", 6129230950 );

#############################################################################
##
#E

