/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import translate.Translate;

public class BrowseForm
extends List
implements CommandListener {
    Controller controller;
    Command moreCommand;
    Command numericCommand;
    Command textCommand;
    Command mainCommand;
    Command submenuCommand;
    Command refreshCommand;
    Command menuBackCommand;
    Image entryImage;
    Translate t = Translate.getInstance();

    public BrowseForm(Controller controller) {
        super("Menu", 3);
        this.controller = controller;
        this.setCommandListener(this);
        this.menuBackCommand = new Command(Translate.get("Up menu"), 3, 0);
        this.addCommand(this.menuBackCommand);
        this.submenuCommand = new Command(Translate.get("Submenu"), Translate.get("Options submenu"), 1, 2);
        this.addCommand(this.submenuCommand);
        this.refreshCommand = new Command(Translate.get("Refresh"), Translate.get("Refresh menu"), 1, 2);
        this.addCommand(this.refreshCommand);
        this.mainCommand = new Command(Translate.get("Main"), Translate.get("Main actions"), 1, 2);
        this.addCommand(this.mainCommand);
        this.numericCommand = new Command(Translate.get("Numeric"), Translate.get("Numeric keys"), 1, 2);
        this.addCommand(this.numericCommand);
        this.moreCommand = new Command(Translate.get("More"), Translate.get("More actions"), 1, 2);
        this.addCommand(this.moreCommand);
        this.textCommand = new Command(Translate.get("Text"), Translate.get("Send text"), 1, 2);
        this.addCommand(this.textCommand);
        try {
            this.entryImage = Image.createImage((String)"/entry.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void updateDirList(String[] stringArray, boolean bl) {
        int n = 0;
        n = this.size();
        while (n-- > 0) {
            this.delete(n);
        }
        for (n = 0; n < stringArray.length; ++n) {
            String string = stringArray[n];
            this.insert(n, string, this.entryImage);
            this.setFont(n, Font.getFont((int)0, (int)0, (int)8));
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.menuBackCommand) {
            this.controller.protocol.fileBrowser.menuBack();
        } else if (command == this.refreshCommand) {
            this.controller.protocol.fileBrowser.requestMenu();
        } else if (command == this.submenuCommand) {
            this.controller.protocol.fileBrowser.menuSubmenu();
        } else if (command == this.mainCommand) {
            this.controller.showController();
        } else if (command == this.numericCommand) {
            this.controller.showNumericForm();
        } else if (command == this.moreCommand) {
            this.controller.showMoreActions();
        } else if (command == this.textCommand) {
            this.controller.showTextForm();
        } else if (command == List.SELECT_COMMAND) {
            String string = Integer.toString(this.getSelectedIndex(), 10);
            this.controller.protocol.fileBrowser.sendMenuItemSelected(string);
        }
    }
}

