/* Freebirth
 * Copyright (C) 1999 topher lafata <topher@topher.com>,
 *		      Jake Donham <jake@bitmechanic.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */



#include <stdlib.h>
#include "reverb.h"


sample *reverb_get_buffer(reverb *this)
{
  return this->ap_2->get_buffer(this->ap_2);
}

void reverb_next_buffer(reverb *this)
{
  int i;
  for(i=0; i < NUM_COMBS;i++)
    this->combs[i]->next_buffer(this->combs[i]);
  this->comb_mixer->next_buffer(this->comb_mixer);
  this->ap_1->next_buffer(this->ap_1);
  this->ap_2->next_buffer(this->ap_2);
}

static sample_producer **get_children(reverb *this)
{
  return (sample_producer **)&(this->ap_2);
}

static char **get_header(reverb *this)
{
  static char *header[] = { NULL };
  return header;
}

static char **get_code(reverb *this)
{
  static char *code[] = {
    "$o = $i0;",
    NULL
  };
  return code;
}

static char **get_footer(reverb *this)
{
  static char *footer[] = { NULL };
  return footer;
}

reverb *reverb_new(sample_producer *input)
{
  int i;
  reverb *out = (reverb *)malloc(sizeof(reverb));
  out->get_buffer = reverb_get_buffer;
  out->next_buffer = reverb_next_buffer;
  out->get_children	= get_children;
  out->get_header	= get_header;
  out->get_code		= get_code;
  out->get_footer	= get_footer;
  out->unused		= NULL;

  out->input = input;
  out->combs[0] = delay_new(C1_INIT_D,C1_INIT_F,out->input);
  out->combs[1] = delay_new(C2_INIT_D,C2_INIT_F,out->input);
  out->combs[2] = delay_new(C3_INIT_D,C3_INIT_F,out->input);
  out->combs[3] = delay_new(C4_INIT_D,C4_INIT_F,out->input);
  out->combs[4] = delay_new(C5_INIT_D,C5_INIT_F,out->input);
  out->combs[5] = delay_new(C6_INIT_D,C6_INIT_F,out->input);
  out->combs[6] = NULL;
  
  out->comb_mixer = mixer_new((sample_producer**)out->combs);
  for(i = 0; i < NUM_COMBS;i++)
    mixer_set_amplitude(out->comb_mixer,MIX_MAX_AMP,i);

  out->ap_1 = all_pass_new(AP1_INIT_D,AP1_INIT_F,(sample_producer *)out->comb_mixer);
  out->ap_2 = all_pass_new(AP2_INIT_D,AP2_INIT_F,(sample_producer *)out->ap_1);
  return out;
}

/*
  Local Variables:
  mode: font-lock
  End:
*/
