# 27 "src/wp/driver.mll"
 

  open Qed.Logic
  open Lexing
  open Cil_types
  open LogicBuiltins

  type bal = [ `Default | `Left | `Right | `Nary ]

  type token =
    | EOF
    | KEY of string
    | BOOLEAN
    | INTEGER
    | REAL
    | INT of ikind
    | FLT of fkind
    | KIND of kind
    | ID of string
    | LINK of string
    | RECLINK of (string * (string * bal)) list
    | FIELD of string * string

  let keywords = [ 
    "library" , KEY "library" ;
    "type" , KEY "type" ;
    "ctor" , KEY "ctor" ;
    "logic" , KEY "logic" ;
    "predicate" , KEY "predicate" ;
    "boolean" , BOOLEAN ;
    "integer" , INTEGER ;
    "real" , REAL ;
    "char" , INT IChar ;
    "short" , INT IShort ;
    "int" , INT IInt ;
    "unsigned" , INT IUInt ;
    "float" , FLT FFloat ;
    "float32" , KIND (F Ctypes.Float32) ;
    "float64" , KIND (F Ctypes.Float64) ;
    "double" , FLT FDouble ;
  ]

  let ident x = try List.assoc x keywords with Not_found -> ID x

  let newline lexbuf =
    lexbuf.lex_curr_p <-
      { lexbuf.lex_curr_p with pos_lnum = succ lexbuf.lex_curr_p.pos_lnum }

  let rec conv_bal default (name,bal) =
    match bal with
    | `Default -> conv_bal default (name,default)
    | `Nary  -> Qed.Engine.F_call name
    | `Left  -> Qed.Engine.F_left name
    | `Right -> Qed.Engine.F_right name


# 59 "src/wp/driver.ml"
let __ocaml_lex_tables = {
  Lexing.lex_base = 
   "\000\000\246\255\000\000\001\000\248\255\249\255\078\000\160\000\
    \017\000\003\000\254\255\255\255\251\255\027\000\252\255\236\000\
    \055\001\130\001\029\001\252\255\253\255\013\000\255\255\254\255\
    \244\001\251\255\252\255\063\002\148\002\004\000\255\255\187\001\
    \250\255\005\003\254\255\255\255\251\255\252\255\253\255\057\003\
    \251\255\135\003\217\003\253\255\254\255\006\000\255\255\192\000\
    \252\255\253\255\254\255\007\000\075\004\251\255\252\255\150\004\
    \235\004\254\255\008\000\025\003\251\255\252\255\253\255\009\000\
    \255\255\093\005\251\255\171\005\253\005\253\255\254\255\010\000\
    \255\255\018\002\252\255\253\255\254\255\012\000\111\006\251\255\
    \252\255\186\006\015\007\254\255\013\000\248\001\028\000\014\000\
    \255\255\024\000\040\000\034\000\037\000\037\000\053\000\022\000\
    \253\255\056\000\050\000\050\000\252\255\070\000\058\000\052\000\
    \251\255";
  Lexing.lex_backtrk = 
   "\255\255\255\255\009\000\009\000\255\255\255\255\005\000\009\000\
    \009\000\002\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \008\000\255\255\255\255\255\255\255\255\003\000\255\255\255\255\
    \255\255\255\255\255\255\002\000\004\000\001\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\003\000\004\000\255\255\255\255\000\000\255\255\255\255\
    \255\255\255\255\255\255\000\000\255\255\255\255\255\255\002\000\
    \004\000\255\255\000\000\255\255\255\255\255\255\255\255\001\000\
    \255\255\255\255\255\255\003\000\004\000\255\255\255\255\000\000\
    \255\255\255\255\255\255\255\255\255\255\000\000\255\255\255\255\
    \255\255\002\000\004\000\255\255\000\000\004\000\255\255\001\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255";
  Lexing.lex_default = 
   "\001\000\000\000\255\255\255\255\000\000\000\000\255\255\255\255\
    \255\255\255\255\000\000\000\000\000\000\013\000\000\000\255\255\
    \255\255\255\255\019\000\000\000\000\000\255\255\000\000\000\000\
    \025\000\000\000\000\000\255\255\255\255\255\255\000\000\034\000\
    \000\000\036\000\000\000\000\000\000\000\000\000\000\000\040\000\
    \000\000\255\255\255\255\000\000\000\000\255\255\000\000\048\000\
    \000\000\000\000\000\000\255\255\053\000\000\000\000\000\255\255\
    \255\255\000\000\255\255\060\000\000\000\000\000\000\000\255\255\
    \000\000\066\000\000\000\255\255\255\255\000\000\000\000\255\255\
    \000\000\074\000\000\000\000\000\000\000\255\255\079\000\000\000\
    \000\000\255\255\255\255\000\000\255\255\255\255\255\255\255\255\
    \000\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\255\255\255\255\255\255\000\000\255\255\255\255\255\255\
    \000\000";
  Lexing.lex_trans = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\009\000\010\000\000\000\009\000\029\000\000\000\045\000\
    \051\000\058\000\063\000\071\000\000\000\077\000\084\000\087\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \009\000\000\000\005\000\009\000\029\000\014\000\045\000\051\000\
    \058\000\063\000\071\000\002\000\077\000\084\000\087\000\008\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\003\000\012\000\023\000\001\000\001\000\096\000\
    \013\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\100\000\007\000\104\000\000\000\006\000\
    \000\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\004\000\015\000\101\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \089\000\097\000\090\000\092\000\093\000\094\000\091\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\095\000\098\000\099\000\102\000\006\000\103\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\051\000\050\000\000\000\000\000\000\000\000\000\000\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \051\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\000\000\000\000\049\000\000\000\006\000\
    \011\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\255\255\016\000\016\000\016\000\016\000\
    \016\000\016\000\016\000\016\000\016\000\016\000\000\000\020\000\
    \000\000\000\000\000\000\000\000\000\000\016\000\016\000\016\000\
    \016\000\016\000\016\000\016\000\016\000\016\000\016\000\016\000\
    \016\000\016\000\016\000\016\000\016\000\016\000\016\000\016\000\
    \016\000\016\000\016\000\016\000\016\000\016\000\016\000\021\000\
    \017\000\000\000\000\000\016\000\000\000\016\000\016\000\016\000\
    \016\000\016\000\016\000\016\000\016\000\016\000\016\000\016\000\
    \016\000\016\000\016\000\016\000\016\000\016\000\016\000\016\000\
    \016\000\016\000\016\000\016\000\016\000\016\000\016\000\016\000\
    \016\000\016\000\016\000\016\000\016\000\016\000\016\000\016\000\
    \016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \016\000\016\000\016\000\016\000\016\000\016\000\016\000\016\000\
    \016\000\016\000\016\000\016\000\016\000\016\000\016\000\016\000\
    \016\000\016\000\016\000\016\000\016\000\016\000\016\000\016\000\
    \016\000\016\000\000\000\000\000\000\000\000\000\016\000\000\000\
    \016\000\016\000\016\000\016\000\016\000\016\000\016\000\016\000\
    \016\000\016\000\016\000\016\000\016\000\016\000\016\000\016\000\
    \016\000\016\000\016\000\016\000\016\000\016\000\016\000\016\000\
    \016\000\016\000\016\000\016\000\016\000\016\000\016\000\016\000\
    \016\000\016\000\016\000\016\000\000\000\000\000\000\000\000\000\
    \255\255\000\000\000\000\016\000\016\000\016\000\016\000\016\000\
    \016\000\016\000\016\000\016\000\016\000\016\000\016\000\016\000\
    \016\000\016\000\016\000\016\000\016\000\016\000\016\000\016\000\
    \016\000\016\000\016\000\016\000\016\000\035\000\000\000\000\000\
    \000\000\016\000\000\000\016\000\016\000\016\000\016\000\016\000\
    \016\000\016\000\016\000\016\000\016\000\016\000\016\000\016\000\
    \016\000\016\000\016\000\016\000\016\000\016\000\016\000\016\000\
    \016\000\016\000\016\000\016\000\016\000\029\000\030\000\000\000\
    \000\000\087\000\088\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\029\000\000\000\026\000\033\000\
    \087\000\000\000\000\000\077\000\076\000\022\000\000\000\000\000\
    \086\000\000\000\000\000\000\000\027\000\027\000\027\000\027\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\000\000\000\000\
    \000\000\000\000\077\000\000\000\000\000\027\000\027\000\027\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\027\000\027\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\027\000\027\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\027\000\075\000\
    \028\000\000\000\000\000\027\000\000\000\027\000\027\000\027\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\027\000\027\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\027\000\027\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\027\000\027\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\027\000\027\000\
    \027\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\027\000\027\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\027\000\027\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\027\000\027\000\
    \027\000\027\000\000\000\000\000\000\000\000\000\027\000\000\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\027\000\027\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\027\000\027\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\027\000\027\000\
    \027\000\027\000\000\000\032\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\027\000\027\000\027\000\027\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\027\000\027\000\027\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\027\000\027\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\027\000\027\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\027\000\000\000\
    \000\000\000\000\000\000\027\000\255\255\027\000\027\000\027\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\027\000\027\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\027\000\027\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\027\000\037\000\
    \000\000\000\000\255\255\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\063\000\064\000\000\000\000\000\000\000\038\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\063\000\000\000\062\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\045\000\044\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\045\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\038\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\041\000\038\000\046\000\000\000\000\000\038\000\
    \000\000\038\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\041\000\041\000\061\000\042\000\000\000\000\000\
    \041\000\000\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\041\000\041\000\000\000\000\000\043\000\041\000\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\000\000\000\000\000\000\000\000\041\000\000\000\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\000\000\000\000\000\000\255\255\000\000\000\000\
    \000\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\041\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\255\255\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\041\000\041\000\000\000\000\000\000\000\000\000\
    \041\000\255\255\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\041\000\041\000\058\000\057\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\058\000\000\000\054\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\055\000\055\000\055\000\055\000\055\000\
    \055\000\055\000\055\000\055\000\055\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\055\000\055\000\055\000\055\000\
    \055\000\055\000\055\000\055\000\055\000\055\000\055\000\055\000\
    \055\000\055\000\055\000\055\000\055\000\055\000\055\000\055\000\
    \055\000\055\000\055\000\055\000\055\000\055\000\000\000\056\000\
    \000\000\000\000\055\000\000\000\055\000\055\000\055\000\055\000\
    \055\000\055\000\055\000\055\000\055\000\055\000\055\000\055\000\
    \055\000\055\000\055\000\055\000\055\000\055\000\055\000\055\000\
    \055\000\055\000\055\000\055\000\055\000\055\000\055\000\055\000\
    \055\000\055\000\055\000\055\000\055\000\055\000\055\000\055\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\055\000\
    \055\000\055\000\055\000\055\000\055\000\055\000\055\000\055\000\
    \055\000\055\000\055\000\055\000\055\000\055\000\055\000\055\000\
    \055\000\055\000\055\000\055\000\055\000\055\000\055\000\055\000\
    \055\000\000\000\000\000\000\000\000\000\055\000\000\000\055\000\
    \055\000\055\000\055\000\055\000\055\000\055\000\055\000\055\000\
    \055\000\055\000\055\000\055\000\055\000\055\000\055\000\055\000\
    \055\000\055\000\055\000\055\000\055\000\055\000\055\000\055\000\
    \055\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\055\000\055\000\055\000\055\000\055\000\
    \055\000\055\000\055\000\055\000\055\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\055\000\055\000\055\000\055\000\
    \055\000\055\000\055\000\055\000\055\000\055\000\055\000\055\000\
    \055\000\055\000\055\000\055\000\055\000\055\000\055\000\055\000\
    \055\000\055\000\055\000\055\000\055\000\055\000\000\000\000\000\
    \000\000\000\000\055\000\255\255\055\000\055\000\055\000\055\000\
    \055\000\055\000\055\000\055\000\055\000\055\000\055\000\055\000\
    \055\000\055\000\055\000\055\000\055\000\055\000\055\000\055\000\
    \055\000\055\000\055\000\055\000\055\000\055\000\071\000\070\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\071\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\000\000\
    \072\000\000\000\000\000\000\000\000\000\000\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \000\000\068\000\000\000\000\000\067\000\000\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \000\000\000\000\069\000\067\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\000\000\000\000\
    \000\000\000\000\067\000\000\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \000\000\000\000\000\000\000\000\067\000\255\255\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \084\000\083\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\084\000\
    \000\000\080\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\081\000\
    \081\000\081\000\081\000\081\000\081\000\081\000\081\000\081\000\
    \081\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \081\000\081\000\081\000\081\000\081\000\081\000\081\000\081\000\
    \081\000\081\000\081\000\081\000\081\000\081\000\081\000\081\000\
    \081\000\081\000\081\000\081\000\081\000\081\000\081\000\081\000\
    \081\000\081\000\000\000\082\000\000\000\000\000\081\000\000\000\
    \081\000\081\000\081\000\081\000\081\000\081\000\081\000\081\000\
    \081\000\081\000\081\000\081\000\081\000\081\000\081\000\081\000\
    \081\000\081\000\081\000\081\000\081\000\081\000\081\000\081\000\
    \081\000\081\000\081\000\081\000\081\000\081\000\081\000\081\000\
    \081\000\081\000\081\000\081\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\081\000\081\000\081\000\081\000\081\000\
    \081\000\081\000\081\000\081\000\081\000\081\000\081\000\081\000\
    \081\000\081\000\081\000\081\000\081\000\081\000\081\000\081\000\
    \081\000\081\000\081\000\081\000\081\000\000\000\000\000\000\000\
    \000\000\081\000\000\000\081\000\081\000\081\000\081\000\081\000\
    \081\000\081\000\081\000\081\000\081\000\081\000\081\000\081\000\
    \081\000\081\000\081\000\081\000\081\000\081\000\081\000\081\000\
    \081\000\081\000\081\000\081\000\081\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\081\000\
    \081\000\081\000\081\000\081\000\081\000\081\000\081\000\081\000\
    \081\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \081\000\081\000\081\000\081\000\081\000\081\000\081\000\081\000\
    \081\000\081\000\081\000\081\000\081\000\081\000\081\000\081\000\
    \081\000\081\000\081\000\081\000\081\000\081\000\081\000\081\000\
    \081\000\081\000\000\000\000\000\000\000\000\000\081\000\255\255\
    \081\000\081\000\081\000\081\000\081\000\081\000\081\000\081\000\
    \081\000\081\000\081\000\081\000\081\000\081\000\081\000\081\000\
    \081\000\081\000\081\000\081\000\081\000\081\000\081\000\081\000\
    \081\000\081\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    ";
  Lexing.lex_check = 
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\000\000\000\000\255\255\009\000\029\000\255\255\045\000\
    \051\000\058\000\063\000\071\000\255\255\077\000\084\000\087\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\255\255\000\000\009\000\029\000\013\000\045\000\051\000\
    \058\000\063\000\071\000\000\000\077\000\084\000\087\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\008\000\021\000\002\000\003\000\095\000\
    \008\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\099\000\000\000\103\000\255\255\000\000\
    \255\255\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\006\000\089\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \086\000\090\000\086\000\091\000\092\000\093\000\086\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\094\000\097\000\098\000\101\000\006\000\102\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\047\000\047\000\255\255\255\255\255\255\255\255\255\255\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \047\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\255\255\255\255\047\000\255\255\007\000\
    \000\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\013\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\255\255\018\000\
    \255\255\255\255\255\255\255\255\255\255\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\018\000\
    \015\000\255\255\255\255\015\000\255\255\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\016\000\
    \016\000\016\000\016\000\016\000\016\000\016\000\016\000\016\000\
    \016\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \016\000\016\000\016\000\016\000\016\000\016\000\016\000\016\000\
    \016\000\016\000\016\000\016\000\016\000\016\000\016\000\016\000\
    \016\000\016\000\016\000\016\000\016\000\016\000\016\000\016\000\
    \016\000\016\000\255\255\255\255\255\255\255\255\016\000\255\255\
    \016\000\016\000\016\000\016\000\016\000\016\000\016\000\016\000\
    \016\000\016\000\016\000\016\000\016\000\016\000\016\000\016\000\
    \016\000\016\000\016\000\016\000\016\000\016\000\016\000\016\000\
    \016\000\016\000\017\000\017\000\017\000\017\000\017\000\017\000\
    \017\000\017\000\017\000\017\000\255\255\255\255\255\255\255\255\
    \047\000\255\255\255\255\017\000\017\000\017\000\017\000\017\000\
    \017\000\017\000\017\000\017\000\017\000\017\000\017\000\017\000\
    \017\000\017\000\017\000\017\000\017\000\017\000\017\000\017\000\
    \017\000\017\000\017\000\017\000\017\000\031\000\255\255\255\255\
    \255\255\017\000\255\255\017\000\017\000\017\000\017\000\017\000\
    \017\000\017\000\017\000\017\000\017\000\017\000\017\000\017\000\
    \017\000\017\000\017\000\017\000\017\000\017\000\017\000\017\000\
    \017\000\017\000\017\000\017\000\017\000\024\000\024\000\255\255\
    \255\255\085\000\085\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\024\000\255\255\024\000\031\000\
    \085\000\255\255\255\255\073\000\073\000\018\000\255\255\255\255\
    \085\000\255\255\255\255\255\255\024\000\024\000\024\000\024\000\
    \024\000\024\000\024\000\024\000\024\000\024\000\255\255\255\255\
    \255\255\255\255\073\000\255\255\255\255\024\000\024\000\024\000\
    \024\000\024\000\024\000\024\000\024\000\024\000\024\000\024\000\
    \024\000\024\000\024\000\024\000\024\000\024\000\024\000\024\000\
    \024\000\024\000\024\000\024\000\024\000\024\000\024\000\073\000\
    \024\000\255\255\255\255\024\000\255\255\024\000\024\000\024\000\
    \024\000\024\000\024\000\024\000\024\000\024\000\024\000\024\000\
    \024\000\024\000\024\000\024\000\024\000\024\000\024\000\024\000\
    \024\000\024\000\024\000\024\000\024\000\024\000\024\000\027\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\027\000\027\000\
    \027\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \027\000\027\000\027\000\027\000\027\000\027\000\027\000\027\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\027\000\027\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\027\000\027\000\
    \027\000\027\000\255\255\255\255\255\255\255\255\027\000\255\255\
    \027\000\027\000\027\000\027\000\027\000\027\000\027\000\027\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\027\000\027\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\027\000\027\000\
    \027\000\027\000\255\255\031\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\028\000\028\000\028\000\028\000\
    \028\000\028\000\028\000\028\000\028\000\028\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\028\000\028\000\028\000\
    \028\000\028\000\028\000\028\000\028\000\028\000\028\000\028\000\
    \028\000\028\000\028\000\028\000\028\000\028\000\028\000\028\000\
    \028\000\028\000\028\000\028\000\028\000\028\000\028\000\255\255\
    \255\255\255\255\255\255\028\000\024\000\028\000\028\000\028\000\
    \028\000\028\000\028\000\028\000\028\000\028\000\028\000\028\000\
    \028\000\028\000\028\000\028\000\028\000\028\000\028\000\028\000\
    \028\000\028\000\028\000\028\000\028\000\028\000\028\000\033\000\
    \255\255\255\255\073\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\059\000\059\000\255\255\255\255\255\255\033\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\059\000\255\255\059\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\039\000\039\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\039\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\033\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\039\000\039\000\039\000\039\000\039\000\039\000\039\000\
    \039\000\039\000\039\000\033\000\039\000\255\255\255\255\033\000\
    \255\255\033\000\039\000\039\000\039\000\039\000\039\000\039\000\
    \039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\
    \039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\
    \039\000\039\000\039\000\039\000\059\000\039\000\255\255\255\255\
    \039\000\255\255\039\000\039\000\039\000\039\000\039\000\039\000\
    \039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\
    \039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\
    \039\000\039\000\039\000\039\000\255\255\255\255\039\000\041\000\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\255\255\255\255\255\255\255\255\041\000\255\255\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\255\255\255\255\255\255\033\000\255\255\255\255\
    \255\255\042\000\042\000\042\000\042\000\042\000\042\000\042\000\
    \042\000\042\000\042\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\059\000\042\000\042\000\042\000\042\000\042\000\042\000\
    \042\000\042\000\042\000\042\000\042\000\042\000\042\000\042\000\
    \042\000\042\000\042\000\042\000\042\000\042\000\042\000\042\000\
    \042\000\042\000\042\000\042\000\255\255\255\255\255\255\255\255\
    \042\000\039\000\042\000\042\000\042\000\042\000\042\000\042\000\
    \042\000\042\000\042\000\042\000\042\000\042\000\042\000\042\000\
    \042\000\042\000\042\000\042\000\042\000\042\000\042\000\042\000\
    \042\000\042\000\042\000\042\000\052\000\052\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\052\000\255\255\052\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\052\000\052\000\052\000\052\000\052\000\
    \052\000\052\000\052\000\052\000\052\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\052\000\052\000\052\000\052\000\
    \052\000\052\000\052\000\052\000\052\000\052\000\052\000\052\000\
    \052\000\052\000\052\000\052\000\052\000\052\000\052\000\052\000\
    \052\000\052\000\052\000\052\000\052\000\052\000\255\255\052\000\
    \255\255\255\255\052\000\255\255\052\000\052\000\052\000\052\000\
    \052\000\052\000\052\000\052\000\052\000\052\000\052\000\052\000\
    \052\000\052\000\052\000\052\000\052\000\052\000\052\000\052\000\
    \052\000\052\000\052\000\052\000\052\000\052\000\055\000\055\000\
    \055\000\055\000\055\000\055\000\055\000\055\000\055\000\055\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\055\000\
    \055\000\055\000\055\000\055\000\055\000\055\000\055\000\055\000\
    \055\000\055\000\055\000\055\000\055\000\055\000\055\000\055\000\
    \055\000\055\000\055\000\055\000\055\000\055\000\055\000\055\000\
    \055\000\255\255\255\255\255\255\255\255\055\000\255\255\055\000\
    \055\000\055\000\055\000\055\000\055\000\055\000\055\000\055\000\
    \055\000\055\000\055\000\055\000\055\000\055\000\055\000\055\000\
    \055\000\055\000\055\000\055\000\055\000\055\000\055\000\055\000\
    \055\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\056\000\056\000\056\000\056\000\056\000\
    \056\000\056\000\056\000\056\000\056\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\056\000\056\000\056\000\056\000\
    \056\000\056\000\056\000\056\000\056\000\056\000\056\000\056\000\
    \056\000\056\000\056\000\056\000\056\000\056\000\056\000\056\000\
    \056\000\056\000\056\000\056\000\056\000\056\000\255\255\255\255\
    \255\255\255\255\056\000\052\000\056\000\056\000\056\000\056\000\
    \056\000\056\000\056\000\056\000\056\000\056\000\056\000\056\000\
    \056\000\056\000\056\000\056\000\056\000\056\000\056\000\056\000\
    \056\000\056\000\056\000\056\000\056\000\056\000\065\000\065\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\065\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\065\000\065\000\065\000\
    \065\000\065\000\065\000\065\000\065\000\065\000\065\000\255\255\
    \065\000\255\255\255\255\255\255\255\255\255\255\065\000\065\000\
    \065\000\065\000\065\000\065\000\065\000\065\000\065\000\065\000\
    \065\000\065\000\065\000\065\000\065\000\065\000\065\000\065\000\
    \065\000\065\000\065\000\065\000\065\000\065\000\065\000\065\000\
    \255\255\065\000\255\255\255\255\065\000\255\255\065\000\065\000\
    \065\000\065\000\065\000\065\000\065\000\065\000\065\000\065\000\
    \065\000\065\000\065\000\065\000\065\000\065\000\065\000\065\000\
    \065\000\065\000\065\000\065\000\065\000\065\000\065\000\065\000\
    \255\255\255\255\065\000\067\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\067\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\255\255\255\255\
    \255\255\255\255\067\000\255\255\067\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\068\000\068\000\068\000\
    \068\000\068\000\068\000\068\000\068\000\068\000\068\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\068\000\068\000\
    \068\000\068\000\068\000\068\000\068\000\068\000\068\000\068\000\
    \068\000\068\000\068\000\068\000\068\000\068\000\068\000\068\000\
    \068\000\068\000\068\000\068\000\068\000\068\000\068\000\068\000\
    \255\255\255\255\255\255\255\255\068\000\065\000\068\000\068\000\
    \068\000\068\000\068\000\068\000\068\000\068\000\068\000\068\000\
    \068\000\068\000\068\000\068\000\068\000\068\000\068\000\068\000\
    \068\000\068\000\068\000\068\000\068\000\068\000\068\000\068\000\
    \078\000\078\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\078\000\
    \255\255\078\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\078\000\
    \078\000\078\000\078\000\078\000\078\000\078\000\078\000\078\000\
    \078\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \078\000\078\000\078\000\078\000\078\000\078\000\078\000\078\000\
    \078\000\078\000\078\000\078\000\078\000\078\000\078\000\078\000\
    \078\000\078\000\078\000\078\000\078\000\078\000\078\000\078\000\
    \078\000\078\000\255\255\078\000\255\255\255\255\078\000\255\255\
    \078\000\078\000\078\000\078\000\078\000\078\000\078\000\078\000\
    \078\000\078\000\078\000\078\000\078\000\078\000\078\000\078\000\
    \078\000\078\000\078\000\078\000\078\000\078\000\078\000\078\000\
    \078\000\078\000\081\000\081\000\081\000\081\000\081\000\081\000\
    \081\000\081\000\081\000\081\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\081\000\081\000\081\000\081\000\081\000\
    \081\000\081\000\081\000\081\000\081\000\081\000\081\000\081\000\
    \081\000\081\000\081\000\081\000\081\000\081\000\081\000\081\000\
    \081\000\081\000\081\000\081\000\081\000\255\255\255\255\255\255\
    \255\255\081\000\255\255\081\000\081\000\081\000\081\000\081\000\
    \081\000\081\000\081\000\081\000\081\000\081\000\081\000\081\000\
    \081\000\081\000\081\000\081\000\081\000\081\000\081\000\081\000\
    \081\000\081\000\081\000\081\000\081\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\082\000\
    \082\000\082\000\082\000\082\000\082\000\082\000\082\000\082\000\
    \082\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \082\000\082\000\082\000\082\000\082\000\082\000\082\000\082\000\
    \082\000\082\000\082\000\082\000\082\000\082\000\082\000\082\000\
    \082\000\082\000\082\000\082\000\082\000\082\000\082\000\082\000\
    \082\000\082\000\255\255\255\255\255\255\255\255\082\000\078\000\
    \082\000\082\000\082\000\082\000\082\000\082\000\082\000\082\000\
    \082\000\082\000\082\000\082\000\082\000\082\000\082\000\082\000\
    \082\000\082\000\082\000\082\000\082\000\082\000\082\000\082\000\
    \082\000\082\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    ";
  Lexing.lex_base_code = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\075\000\150\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000";
  Lexing.lex_backtrk_code = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000";
  Lexing.lex_default_code = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000";
  Lexing.lex_trans_code = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\000\000\000\000\000\000\000\000\001\000\
    \000\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\000\000\000\000\
    \000\000\000\000\001\000\000\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\000\000\000\000\000\000\000\000\001\000\000\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000";
  Lexing.lex_check_code = 
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\255\255\255\255\255\255\255\255\000\000\
    \255\255\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\255\255\255\255\
    \255\255\255\255\006\000\255\255\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\255\255\255\255\255\255\255\255\007\000\255\255\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255";
  Lexing.lex_code = 
   "\255\001\255\255\000\001\255";
}

let rec tok lexbuf =
  lexbuf.Lexing.lex_mem <- Array.create 2 (-1) ;   __ocaml_lex_tok_rec lexbuf 0
and __ocaml_lex_tok_rec lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 88 "src/wp/driver.mll"
        ( EOF )
# 786 "src/wp/driver.ml"

  | 1 ->
# 89 "src/wp/driver.mll"
         ( newline lexbuf ; tok lexbuf )
# 791 "src/wp/driver.ml"

  | 2 ->
# 90 "src/wp/driver.mll"
           ( tok lexbuf )
# 796 "src/wp/driver.ml"

  | 3 ->
# 91 "src/wp/driver.mll"
                        ( newline lexbuf ; tok lexbuf )
# 801 "src/wp/driver.ml"

  | 4 ->
# 92 "src/wp/driver.mll"
         ( comment lexbuf )
# 806 "src/wp/driver.ml"

  | 5 ->
let
# 93 "src/wp/driver.mll"
             a
# 812 "src/wp/driver.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 93 "src/wp/driver.mll"
               ( ident a )
# 816 "src/wp/driver.ml"

  | 6 ->
# 94 "src/wp/driver.mll"
        ( LINK (string_val (Buffer.create 10) lexbuf) )
# 821 "src/wp/driver.ml"

  | 7 ->
# 95 "src/wp/driver.mll"
        ( RECLINK(reclink [] lexbuf) )
# 826 "src/wp/driver.ml"

  | 8 ->
let
# 96 "src/wp/driver.mll"
              group
# 832 "src/wp/driver.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_mem.(0)
and
# 96 "src/wp/driver.mll"
                                   var
# 837 "src/wp/driver.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_mem.(0) + 1) lexbuf.Lexing.lex_curr_pos in
# 96 "src/wp/driver.mll"
                                        ( FIELD(group,var) )
# 841 "src/wp/driver.ml"

  | 9 ->
# 97 "src/wp/driver.mll"
                    ( KEY (Lexing.lexeme lexbuf) )
# 846 "src/wp/driver.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_tok_rec lexbuf __ocaml_lex_state

and comment lexbuf =
    __ocaml_lex_comment_rec lexbuf 18
and __ocaml_lex_comment_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 100 "src/wp/driver.mll"
        ( failwith "Unterminated comment" )
# 857 "src/wp/driver.ml"

  | 1 ->
# 101 "src/wp/driver.mll"
         ( tok lexbuf )
# 862 "src/wp/driver.ml"

  | 2 ->
# 102 "src/wp/driver.mll"
         ( newline lexbuf ; comment lexbuf )
# 867 "src/wp/driver.ml"

  | 3 ->
# 103 "src/wp/driver.mll"
      ( comment lexbuf )
# 872 "src/wp/driver.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_comment_rec lexbuf __ocaml_lex_state

and value lexbuf =
    __ocaml_lex_value_rec lexbuf 24
and __ocaml_lex_value_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 106 "src/wp/driver.mll"
           ( newline lexbuf ; value lexbuf )
# 883 "src/wp/driver.ml"

  | 1 ->
# 107 "src/wp/driver.mll"
             ( value lexbuf )
# 888 "src/wp/driver.ml"

  | 2 ->
let
# 108 "src/wp/driver.mll"
                a
# 894 "src/wp/driver.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 108 "src/wp/driver.mll"
                  ( a )
# 898 "src/wp/driver.ml"

  | 3 ->
# 109 "src/wp/driver.mll"
          ( string_val (Buffer.create 10) lexbuf )
# 903 "src/wp/driver.ml"

  | 4 ->
# 110 "src/wp/driver.mll"
        ( failwith "Ident or String expected" )
# 908 "src/wp/driver.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_value_rec lexbuf __ocaml_lex_state

and string_val buf lexbuf =
    __ocaml_lex_string_val_rec buf lexbuf 31
and __ocaml_lex_string_val_rec buf lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 113 "src/wp/driver.mll"
        ( Buffer.contents buf;)
# 919 "src/wp/driver.ml"

  | 1 ->
let
# 114 "src/wp/driver.mll"
                    c
# 925 "src/wp/driver.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 115 "src/wp/driver.mll"
      ( Buffer.add_char buf c;
        string_val buf lexbuf )
# 930 "src/wp/driver.ml"

  | 2 ->
let
# 117 "src/wp/driver.mll"
                                    c
# 936 "src/wp/driver.ml"
= Lexing.sub_lexeme_char lexbuf (lexbuf.Lexing.lex_start_pos + 1) in
# 118 "src/wp/driver.mll"
      ( Buffer.add_char buf
          (match c with 'n' -> '\n' | 'r' -> '\r' | 't' -> '\t' | _ -> c);
        string_val buf lexbuf )
# 942 "src/wp/driver.ml"

  | 3 ->
# 122 "src/wp/driver.mll"
      ( string_val buf lexbuf )
# 947 "src/wp/driver.ml"

  | 4 ->
let
# 123 "src/wp/driver.mll"
               c
# 953 "src/wp/driver.ml"
= Lexing.sub_lexeme_char lexbuf (lexbuf.Lexing.lex_start_pos + 1) in
# 124 "src/wp/driver.mll"
      ( Buffer.add_char buf '\\';
        Buffer.add_char buf c;
        string_val buf lexbuf )
# 959 "src/wp/driver.ml"

  | 5 ->
# 128 "src/wp/driver.mll"
      ( failwith "Unterminated string" )
# 964 "src/wp/driver.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_string_val_rec buf lexbuf __ocaml_lex_state

and recstring acc lexbuf =
    __ocaml_lex_recstring_rec acc lexbuf 39
and __ocaml_lex_recstring_rec acc lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 131 "src/wp/driver.mll"
                 ( recstring acc lexbuf )
# 975 "src/wp/driver.ml"

  | 1 ->
# 132 "src/wp/driver.mll"
         ( newline lexbuf ; recstring acc lexbuf )
# 980 "src/wp/driver.ml"

  | 2 ->
# 133 "src/wp/driver.mll"
         ( acc )
# 985 "src/wp/driver.ml"

  | 3 ->
let
# 134 "src/wp/driver.mll"
             field
# 991 "src/wp/driver.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 134 "src/wp/driver.mll"
                   ( recstring_bis acc field lexbuf )
# 995 "src/wp/driver.ml"

  | 4 ->
# 135 "src/wp/driver.mll"
      ( failwith "Identifier or '}' expected" )
# 1000 "src/wp/driver.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_recstring_rec acc lexbuf __ocaml_lex_state

and recstring_bis acc field lexbuf =
    __ocaml_lex_recstring_bis_rec acc field lexbuf 47
and __ocaml_lex_recstring_bis_rec acc field lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 137 "src/wp/driver.mll"
           ( recstring_bis acc field lexbuf )
# 1011 "src/wp/driver.ml"

  | 1 ->
# 138 "src/wp/driver.mll"
         ( newline lexbuf ; recstring_bis acc field lexbuf )
# 1016 "src/wp/driver.ml"

  | 2 ->
# 139 "src/wp/driver.mll"
         ( recstring_ter acc field lexbuf )
# 1021 "src/wp/driver.ml"

  | 3 ->
# 140 "src/wp/driver.mll"
         ( failwith "'=' expected" )
# 1026 "src/wp/driver.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_recstring_bis_rec acc field lexbuf __ocaml_lex_state

and recstring_ter acc field lexbuf =
    __ocaml_lex_recstring_ter_rec acc field lexbuf 52
and __ocaml_lex_recstring_ter_rec acc field lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 142 "src/wp/driver.mll"
           ( recstring_ter acc field lexbuf )
# 1037 "src/wp/driver.ml"

  | 1 ->
# 143 "src/wp/driver.mll"
           ( newline lexbuf ; recstring_ter acc field lexbuf )
# 1042 "src/wp/driver.ml"

  | 2 ->
let
# 144 "src/wp/driver.mll"
             name
# 1048 "src/wp/driver.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 144 "src/wp/driver.mll"
                  ( recstring ((field,name)::acc) lexbuf )
# 1052 "src/wp/driver.ml"

  | 3 ->
# 146 "src/wp/driver.mll"
      ( let name = string_val (Buffer.create 10) lexbuf in
        recstring ((field,name)::acc) lexbuf
      )
# 1059 "src/wp/driver.ml"

  | 4 ->
# 149 "src/wp/driver.mll"
      ( failwith "Identifier or String expected" )
# 1064 "src/wp/driver.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_recstring_ter_rec acc field lexbuf __ocaml_lex_state

and recorstring lexbuf =
    __ocaml_lex_recorstring_rec lexbuf 59
and __ocaml_lex_recorstring_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 152 "src/wp/driver.mll"
           ( newline lexbuf ; recorstring lexbuf )
# 1075 "src/wp/driver.ml"

  | 1 ->
# 153 "src/wp/driver.mll"
           ( recorstring lexbuf )
# 1080 "src/wp/driver.ml"

  | 2 ->
# 154 "src/wp/driver.mll"
           ( `String (string_val (Buffer.create 10) lexbuf) )
# 1085 "src/wp/driver.ml"

  | 3 ->
# 155 "src/wp/driver.mll"
           ( `RecString (recstring [] lexbuf) )
# 1090 "src/wp/driver.ml"

  | 4 ->
let
# 156 "src/wp/driver.mll"
         c
# 1096 "src/wp/driver.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 156 "src/wp/driver.mll"
           ( failwith (Printf.sprintf "found '%c' instead of \" or {" c) )
# 1100 "src/wp/driver.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_recorstring_rec lexbuf __ocaml_lex_state

and reclink acc lexbuf =
    __ocaml_lex_reclink_rec acc lexbuf 65
and __ocaml_lex_reclink_rec acc lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 159 "src/wp/driver.mll"
                 ( reclink acc lexbuf )
# 1111 "src/wp/driver.ml"

  | 1 ->
# 160 "src/wp/driver.mll"
         ( newline lexbuf ; reclink acc lexbuf )
# 1116 "src/wp/driver.ml"

  | 2 ->
# 161 "src/wp/driver.mll"
         ( acc )
# 1121 "src/wp/driver.ml"

  | 3 ->
let
# 162 "src/wp/driver.mll"
             field
# 1127 "src/wp/driver.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 162 "src/wp/driver.mll"
                   ( reclink_bis acc field lexbuf )
# 1131 "src/wp/driver.ml"

  | 4 ->
# 163 "src/wp/driver.mll"
      ( failwith "Identifier or '}' expected" )
# 1136 "src/wp/driver.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_reclink_rec acc lexbuf __ocaml_lex_state

and reclink_bis acc field lexbuf =
    __ocaml_lex_reclink_bis_rec acc field lexbuf 73
and __ocaml_lex_reclink_bis_rec acc field lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 165 "src/wp/driver.mll"
           ( reclink_bis acc field lexbuf )
# 1147 "src/wp/driver.ml"

  | 1 ->
# 166 "src/wp/driver.mll"
           ( newline lexbuf ; reclink_bis acc field lexbuf )
# 1152 "src/wp/driver.ml"

  | 2 ->
# 167 "src/wp/driver.mll"
           ( reclink_ter acc field lexbuf )
# 1157 "src/wp/driver.ml"

  | 3 ->
# 168 "src/wp/driver.mll"
           ( failwith "'=' expected" )
# 1162 "src/wp/driver.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_reclink_bis_rec acc field lexbuf __ocaml_lex_state

and reclink_ter acc field lexbuf =
    __ocaml_lex_reclink_ter_rec acc field lexbuf 78
and __ocaml_lex_reclink_ter_rec acc field lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 170 "src/wp/driver.mll"
           ( reclink_ter acc field lexbuf )
# 1173 "src/wp/driver.ml"

  | 1 ->
# 171 "src/wp/driver.mll"
           ( newline lexbuf ; reclink_ter acc field lexbuf )
# 1178 "src/wp/driver.ml"

  | 2 ->
let
# 172 "src/wp/driver.mll"
             name
# 1184 "src/wp/driver.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 173 "src/wp/driver.mll"
      ( let link  = name,(bal lexbuf) in
        reclink ((field,link)::acc) lexbuf
      )
# 1190 "src/wp/driver.ml"

  | 3 ->
# 177 "src/wp/driver.mll"
      ( let name = string_val (Buffer.create 10) lexbuf in
        let link = name,(bal lexbuf) in
        reclink ((field,link)::acc) lexbuf
      )
# 1198 "src/wp/driver.ml"

  | 4 ->
# 181 "src/wp/driver.mll"
      ( failwith "Identifier or String expected" )
# 1203 "src/wp/driver.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_reclink_ter_rec acc field lexbuf __ocaml_lex_state

and bal lexbuf =
    __ocaml_lex_bal_rec lexbuf 85
and __ocaml_lex_bal_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 184 "src/wp/driver.mll"
         ( newline lexbuf ; bal lexbuf )
# 1214 "src/wp/driver.ml"

  | 1 ->
# 185 "src/wp/driver.mll"
           ( bal lexbuf )
# 1219 "src/wp/driver.ml"

  | 2 ->
# 186 "src/wp/driver.mll"
                      ( `Right )
# 1224 "src/wp/driver.ml"

  | 3 ->
# 187 "src/wp/driver.mll"
                      ( `Nary )
# 1229 "src/wp/driver.ml"

  | 4 ->
let
# 188 "src/wp/driver.mll"
                          c
# 1235 "src/wp/driver.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 188 "src/wp/driver.mll"
                            ( if c = "" then `Default else `Left )
# 1239 "src/wp/driver.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_bal_rec lexbuf __ocaml_lex_state

;;

# 190 "src/wp/driver.mll"
 

  let pretty fmt = function
    | EOF -> Format.pp_print_string fmt "<eof>"
    | KEY a | ID a -> Format.fprintf fmt "'%s'" a
    | LINK s -> Format.fprintf fmt "\"%s\"" s
    | BOOLEAN | INTEGER | REAL | INT _ | FLT _  | KIND _ ->
	Format.pp_print_string fmt "<type>"
    | FIELD(group,name) -> Format.fprintf fmt "%s.%s" group name
    | RECLINK _ -> Format.pp_print_string fmt "<reclink>"

  type input = {
    lexbuf : Lexing.lexbuf ;
    mutable current : token ;
  }

  let skip input =
    if input.current <> EOF then input.current <- tok input.lexbuf

  let token input = input.current

  let value input =
    if input.current = EOF then failwith "Value expected"
    else
      let v = value input.lexbuf in
      skip input; v

  let key input a = match token input with
    | KEY b when a=b -> skip input ; true
    | _ -> false

  let skipkey input a = match token input with
    | KEY b when a=b -> skip input
    | _ -> failwith (Printf.sprintf "Missing '%s'" a)

  let noskipkey input a = match token input with
    | KEY b when a=b -> ()
    | _ -> failwith (Printf.sprintf "Missing '%s'" a)


  let ident input = match token input with
    | ID x | LINK x -> skip input ; x
    | _ -> failwith "missing identifier"

  let kind input = 
    let kd = match token input with
      | INTEGER -> Z
      | REAL -> R
      | BOOLEAN -> A
      | INT i -> I (Ctypes.c_int i)
      | FLT f -> F (Ctypes.c_float f)
      | KIND x -> x
      | ID _ -> A
      | _ -> failwith "<type> expected"
    in skip input ; kd

  let parameter input =
    let k = kind input in
    match token input with
      | ID _ -> skip input ; k
      | _ -> k

  let rec parameters input =
    if key input ")" then [] else
      let p = parameter input in
      if key input "," then p :: parameters input else 
	if key input ")" then [p] else
	  failwith "Missing ',' or ')'"

  let signature input =
    if key input "(" then parameters input else []

  let rec depend input =
    match token input with
      | ID a | LINK a ->
	  skip input ;
	  ignore (key input ",") ;
	  a :: depend input
      | _ -> []

  let link def input =
    match token input with
      | LINK f | ID f ->
        let link = conv_bal def (f,(bal input.lexbuf)) in
        skip input; Lang.infoprover link
      | RECLINK l ->
        skip input ;
        begin try
          {Lang.altergo = conv_bal def (List.assoc "alt-ergo" l);
                why3    = conv_bal def (List.assoc "why3" l);
                coq     = conv_bal def (List.assoc "coq" l) }
        with Not_found ->
          failwith "a link must contain an entry for alt-ergo, why3 and coq"
        end
      | _ -> failwith "Missing link symbol"

  let linkstring input =
    match recorstring input.lexbuf with
      | `String f ->
        skip input ; Lang.infoprover f
      | `RecString l ->
        skip input ;
        begin try
          {Lang.altergo = List.assoc "alt-ergo" l;
                why3    = List.assoc "why3" l;
                coq     = List.assoc "coq" l }
        with Not_found ->
          failwith "a link must contain an entry for alt-ergo, why3 and coq"
        end
      | _ -> failwith "Missing link symbol"

  let input_string input =
    match token input with
      | LINK f | ID f ->
        skip input ; f
      | _ -> failwith "String or ident expected"


  let op = {
    inversible = false ;
    associative = false ;
    commutative = false ;
    idempotent = false ;
    neutral = E_none ;
    absorbant = E_none ;
  }

  let op_elt input =
    ignore (key input ":") ;
    let op = input_string input in
    skipkey input ":" ;
    match op with
      | "0" -> E_int 0
      | "1" -> E_int 1
      | "-1" -> E_int (-1)
      | "\\true" -> E_true
      | "\\false" -> E_false
      | _ ->
        match LogicBuiltins.constant op with
        | ACSLDEF -> failwith (Printf.sprintf "Symbol '%s' not found" op)
        | CONST _ ->
          failwith "Invariant broken only true and false can be const"
        | LFUN lfun -> E_const lfun

  let rec op_link op input =
    match token input with
      | LINK _ | RECLINK _ ->
          Operator op, link `Left input
      | ID "associative" -> skip input ; skipkey input ":" ; 
	  op_link { op with associative = true } input
      | ID "commutative" -> skip input ; skipkey input ":" ; 
	  op_link { op with commutative = true } input
      | ID "ac" -> skip input ; skipkey input ":" ;
	  op_link { op with commutative = true ; associative = true } input
      | ID "idempotent" -> skip input ; skipkey input ":" ;
	  op_link { op with idempotent = true } input
      | ID "inversible" -> skip input ; skipkey input ":" ;
	  op_link { op with inversible = true } input
      | ID "neutral" -> 
	  skip input ; let e = op_elt input in
	  op_link { op with neutral = e } input
      | ID "absorbant" ->
	  skip input ; let e = op_elt input in
	  op_link { op with absorbant = e } input
      | ID t -> failwith (Printf.sprintf "Unknown tag '%s'" t)
      | _ -> failwith "Missing <tag> or <link>"

  let logic_link input =
    match token input with
      | LINK _ | RECLINK _ ->
	  Function, link `Nary input
      | ID "constructor" -> 
	  skip input ; skipkey input ":" ; 
	  Constructor, link `Nary input
      | ID "injective" -> 
	  skip input ; skipkey input ":" ; 
	  Injection, link `Nary input
      | _ -> op_link op input

  let rec parse ~driver_dir library input =
    match token input with
      | EOF -> ()
      | KEY "library" ->
          skip input ;
          let name = input_string input in
          ignore (key input ":") ;
          let depends = depend input in
          ignore (key input ";") ;
          add_library name depends ;
          parse ~driver_dir name input
      | KEY "type" ->
	  skip input ;
	  let name = ident input in
	  noskipkey input "=" ;
	  let link = linkstring input in
	  add_type name ~library ~link () ;
	  skipkey input ";" ;
	  parse ~driver_dir library input
      | KEY "ctor" ->
	  skip input ;
	  let name = ident input in
	  let args = signature input in
	  skipkey input "=" ;
	  let link = link `Nary input in
	  add_ctor name args ~library ~link () ;
	  skipkey input ";" ;
	  parse ~driver_dir library input
      | KEY "logic" ->
	  skip input ;
	  let result = kind input in
	  let name = ident input in
	  let args = signature input in
          if key input ":=" then
            begin
              let alias = ident input in
              add_alias name args ~alias () ;
            end
          else
            begin
	      skipkey input "=" ;
              let category,link = logic_link input in
              add_logic result name args ~library ~category ~link () ;
            end ;
          skipkey input ";" ;
	  parse ~driver_dir library input
      | KEY "predicate" ->
	  skip input ;
	  let name = ident input in
	  let args = signature input in
          if key input ":=" then
            begin
              let alias = ident input in
              add_alias name args ~alias () ;
            end
          else
            begin
	      noskipkey input "=" ;
	      let link = linkstring input in
	      add_predicate name args ~library ~link () ;
            end ;
          skipkey input ";" ;
          parse ~driver_dir library input
      | FIELD (group,var) ->
	skip input ;
        begin match token input with
        | KEY ":=" ->
          let v = value input in
          set_option ~driver_dir group var ~library v
        | KEY "+=" ->
          let v = value input in
          add_option ~driver_dir group var ~library v
        | _ -> failwith "Missing ':=' or '+='"
        end;
        skipkey input ";" ;
        parse ~driver_dir library input
      | _ -> failwith "Unexpected entry"

  let load ?(feedback=true) file =
    try
      if feedback then
        Wp_parameters.feedback "Loading driver '%s'" (Filepath.pretty file) ;
      let driver_dir = Filename.dirname file in
      let inc = open_in file in
      let lex = Lexing.from_channel inc in
      lex.Lexing.lex_curr_p <-
        { lex.Lexing.lex_curr_p with Lexing.pos_fname = file } ;
      let input = { current = tok lex ; lexbuf = lex } in
      try
	parse ~driver_dir "qed" input ;
	close_in inc
      with Failure msg ->
	close_in inc ;
	let source = lex.Lexing.lex_start_p in
	Wp_parameters.abort ~current:false
          ~source "(Driver Error) %s (at %a)" msg
          pretty (token input)
    with exn ->
      Wp_parameters.abort
        ~current:false
        "Error in driver '%s': %s" file (Printexc.to_string exn)

  (*TODO[LC] Think about projectification ... *)
  let dkey = Wp_parameters.register_category "includes"

  let loaded : (string list * string list, driver) Hashtbl.t =Hashtbl.create 10
  let load_driver () =
    let drivers = Wp_parameters.Drivers.get () in
    let includes = Wp_parameters.get_includes () in
    let key = (drivers,includes) in
    begin try
        let driver = Hashtbl.find loaded key in
        Context.set LogicBuiltins.driver driver
      with Not_found ->
	let driver_basename file =
	  let base = Filename.basename file in
	  try Filename.chop_extension base
	  with Invalid_argument _ -> base in
	let drvs = List.map driver_basename drivers in
        let id = String.concat "_" drvs in
	let descr = String.concat "," drvs in
        let directories =
          let shared =
            try [Wp_parameters.Share.dir ~error:false ()]
            with Wp_parameters.Share.No_dir -> [] in
          let directories = includes @ shared in
          if Wp_parameters.has_dkey "includes" then
            Wp_parameters.debug ~dkey "Included directories:%t"
              (fun fmt ->
                 List.iter
                   (fun d -> Format.fprintf fmt "@\n - '%s'" d)
                   directories
              );
          directories
        in
        LogicBuiltins.new_driver ~includes:directories ~id ~descr ;
	let drivers =
	  List.map (fun file ->
		      if Sys.file_exists file
		      then Sysutil.absolutize_filename (Sys.getcwd ()) file
		      else LogicBuiltins.find_lib file)
            drivers in
        let default = Wp_parameters.Share.file ~error:true "wp.driver" in
        let feedback = Wp_parameters.Share.Dir_name.is_set () in
        load ~feedback default;
        List.iter load drivers;
        Hashtbl.add loaded key (Context.get LogicBuiltins.driver);
        if Wp_parameters.has_dkey "driver" then LogicBuiltins.dump ()
    end ; Context.get LogicBuiltins.driver


# 1576 "src/wp/driver.ml"
