/*
  Copyright 2005, 2006, 2007 David Cad, Damien Stehl.

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; see the file COPYING.  If not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.

  This program implements ideas from the paper "Floating-point LLL Revisited", 
  by Phong Nguyen and Damien Stehl, in the Proceedings of Eurocrypt'2005, 
  Springer-Verlag; and was partly inspired by Shoup's NTL library: 
  http://www.shoup.net/ntl/

*/

#define VERBOSE
//#define DEBUG
#include "nr.h"
#include "matrix.h"
#include "proved.h"
#include "heuristic.h"
#include "fast.h"
#include "util.h"
#include "wrapper.h"

/*********
 * Tests *
 *********/

bool OPTest()
{
  Z_NR<mpz_t> a;
  a.set(10);
  Z_NR<mpz_t> b;
  b.set(15);
  
  Z_NR<mpz_t> c;
  c.mul(a,b);
  FP_NR<dpe_t> d;
  set_fz(d,c);
  return (d.cmp(150.)==0);
}
bool ScalarTest()
{
  Z_NR<mpz_t>*f=new Z_NR<mpz_t>[11];
  for (int i=0;i<10;i++)
    {
      f[i].set(i);
    }
  ScalarProduct(f[0],f,f,10);
  
  FP_NR<dpe_t> d;
  set_fz(d,f[0]);


  delete[] f;
  
  return (d.cmp(385.)==0);
}
bool matrix_test()
{

  ZZ_mat<mpz_t> * dzmat= new ZZ_mat<mpz_t>(10,11);
  dzmat->gen_intrel(10);
  dzmat->print();

  ZZ_mat<mpz_t> * zmat= new ZZ_mat<mpz_t>(8,8);
  zmat->gen_simdioph(15,10);
  zmat->print();

 
  ZZ_mat<mpz_t> * zzmat= new ZZ_mat<mpz_t>(8,8);
  zzmat->gen_ntrulike(15,10);
  zzmat->print();

 
  ZZ_mat<mpz_t> * zzzmat= new ZZ_mat<mpz_t>(8,8);
  zzzmat->gen_ntrulike2(15,10);
  zzzmat->print();


  ZZ_mat<mpz_t> * zzzzmat= new ZZ_mat<mpz_t>(8,8);
  zzzzmat->gen_ajtai(1);
  zzzzmat->print();
  
  delete zmat;
  delete dzmat;
  delete zzmat;
  delete zzzmat;
  delete zzzzmat;
  return true;
}

bool lll_test(int d)
{
  
  ZZ_mat<mpz_t> * dzmat= new ZZ_mat<mpz_t>(d,d+1);
  dzmat->gen_intrel(10);
  dzmat->print();


  wrapper* lll= new wrapper(dzmat);
  
  lll->LLL();
  
  lll->GetBase()->print();
  
  delete lll;
  delete dzmat;
  return true;
}

int main(void)
{
  if (!lll_test(20))
    return 1;
  return 0;

}
