/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * fische-3.1
 * Copyright (C) Marcel Ebmer 2009 <marcel@26elf.at>
 * 
 * fische-3.1 is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * fische-3.1 is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef VECTORFIELD_H
#define VECTORFIELD_H

#include <vector>

class VectorField
{
	public:
		VectorField(int, int);
		~VectorField();
		void change();
		int width();
		int height();
		char* get();
		
	private:
		std::vector<char*> __field;
		char* fillField(int);
		char* __data;
		int __xRes, __yRes;

		void validateX(int x, char* v)
		{
			while(x + *v < 2) (*v)++;
			while(x + *v > __xRes - 3) (*v)--;
		}

		void validateY(int y, char* v)
		{
			while(y + *v < 2) (*v)++;
			while(y + *v > __yRes - 3) (*v)--;
		}
		void randomize(char*, int);

};

#endif // VECTORFIELD_H
