/*
*
*  This software was developed by the Thermal Modeling and Analysis
*  Project(TMAP) of the National Oceanographic and Atmospheric
*  Administration's (NOAA) Pacific Marine Environmental Lab(PMEL),
*  hereafter referred to as NOAA/PMEL/TMAP.
*
*  Access and use of this software shall impose the following
*  obligations and understandings on the user. The user is granted the
*  right, without any fee or cost, to use, copy, modify, alter, enhance
*  and distribute this software, and any derivative works thereof, and
*  its supporting documentation for any purpose whatsoever, provided
*  that this entire notice appears in all copies of the software,
*  derivative works and supporting documentation.  Further, the user
*  agrees to credit NOAA/PMEL/TMAP in any publications that result from
*  the use of this software or in any product that includes this
*  software. The names TMAP, NOAA and/or PMEL, however, may not be used
*  in any advertising or publicity to endorse or promote any products
*  or commercial entity unless specific written permission is obtained
*  from NOAA/PMEL/TMAP. The user also understands that NOAA/PMEL/TMAP
*  is not obligated to provide the user with any support, consulting,
*  training or assistance of any kind with regard to the use, operation
*  and performance of this software nor to provide the user with any
*  updates, revisions, new versions or "bug fixes".
*
*  THIS SOFTWARE IS PROVIDED BY NOAA/PMEL/TMAP "AS IS" AND ANY EXPRESS
*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
*  ARE DISCLAIMED. IN NO EVENT SHALL NOAA/PMEL/TMAP BE LIABLE FOR ANY SPECIAL,
*  INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
*  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
*  CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
*  CONNECTION WITH THE ACCESS, USE OR PERFORMANCE OF THIS SOFTWARE.  
*
*/

/*
 * set_nan.c:
 *
 *  set a float (or double) value to NaN - needed for the command
 *      set variable/bad=nan var_name
 *
 *  kob - 05/03
 * v600  4/06 *acm* - Change set_nan from a float function to void, passing
 *                    back the result as an argument. Needed for port to 64-bit 
 * *acm*  1/12 - Ferret 6.8 ifdef double_p for double-precision ferret,
 *               see the definition of macro DFTYPE in ferret.h 
 */

#include <signal.h>
#include <stdio.h>
#include <math.h>
#include "ferret.h"

void FORTRAN(set_nan) (DFTYPE *val)
{
  sigset_t block_fpe;

  /* initialize the signal mask */
  sigemptyset(&block_fpe);
  sigaddset(&block_fpe, SIGFPE); 

  /* block SIGFPE so we don't have problems generating NaN */
  sigprocmask(SIG_BLOCK, &block_fpe, NULL); 

  /* calculating the inverse hyperbolic cosine of a value less
     than 1 will result in NaN - seems better than doing a divide
     by 0 */
  *val = acosh(.2);  
  /*val = 1./0.; */

  /* unblock SIGFPE */
  sigprocmask(SIG_UNBLOCK, &block_fpe, NULL); 

  return;
}
