/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap.test;

import java.util.Enumeration;
import opendap.dap.BadSemanticsException;
import opendap.dap.BaseType;
import opendap.dap.DDS;
import opendap.dap.DDSException;
import opendap.dap.DefaultFactory;
import opendap.dap.NoSuchVariableException;
import opendap.dap.parser.DDSParserTokenManager;
import opendap.dap.parser.ParseException;
import opendap.dap.parser.SimpleCharStream;
import opendap.dap.parser.Token;
import opendap.util.Getopts;
import opendap.util.InvalidSwitch;

public class dds_test {
    private static final String prompt = "dds-test: ";
    private static final String version = "version 0.1";

    private static void usage() {
        System.err.println("usage: dds-test [s] [pd] [c]");
        System.err.println(" s: Test the scanner.");
        System.err.println(" p: Test the parser; reads from stdin and prints the");
        System.err.println("    internal structure to stdout.");
        System.err.println(" d: Turn on parser debugging.[Broken 11/9/99 jhrg]");
        System.err.println(" c: Test the code for manipulating DDS objects.");
        System.err.println("    Reads from stdin, parses and writes the modified DDS");
        System.err.println("    to stdout.");
    }

    public static void main(String[] args) {
        boolean parser_test = false;
        boolean scanner_test = false;
        boolean class_test = false;
        try {
            Getopts opts = new Getopts("spdc", args);
            if (opts.getSwitch((Character)new Character((char)'p')).set) {
                parser_test = true;
            }
            if (opts.getSwitch((Character)new Character((char)'s')).set) {
                scanner_test = true;
            }
            if (opts.getSwitch((Character)new Character((char)'c')).set) {
                class_test = true;
            }
        }
        catch (InvalidSwitch e) {
            dds_test.usage();
            System.exit(1);
        }
        if (!(parser_test || scanner_test || class_test)) {
            dds_test.usage();
            System.exit(1);
        }
        if (scanner_test) {
            dds_test.test_scanner();
        }
        if (parser_test) {
            dds_test.test_parser();
        }
        if (class_test) {
            dds_test.test_class();
        }
    }

    private static void test_scanner() {
        SimpleCharStream jj_input_stream = new SimpleCharStream(System.in, 1, 1);
        DDSParserTokenManager token_source = new DDSParserTokenManager(jj_input_stream);
        System.out.print(prompt);
        System.out.flush();
        while (true) {
            Token tok = token_source.getNextToken();
            if (tok.kind == 0) break;
            switch (tok.kind) {
                case 6: {
                    System.out.println("DATASET");
                    break;
                }
                case 7: {
                    System.out.println("SEQUENCE");
                    break;
                }
                case 8: {
                    System.out.println("STRUCTURE");
                    break;
                }
                case 9: {
                    System.out.println("GRID");
                    break;
                }
                case 10: {
                    System.out.println("BYTE");
                    break;
                }
                case 13: {
                    System.out.println("INT32");
                    break;
                }
                case 16: {
                    System.out.println("FLOAT64");
                    break;
                }
                case 17: {
                    System.out.println("STRING");
                    break;
                }
                case 18: {
                    System.out.println("Url");
                    break;
                }
                case 19: {
                    System.out.println("WORD: " + tok.image);
                    break;
                }
                default: {
                    System.out.println("Found: " + tok.image);
                }
            }
            System.out.print(prompt);
            System.out.flush();
        }
    }

    private static void test_parser() {
        DDS table = new DDS();
        try {
            table.parse(System.in);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage() + "\n");
            System.out.println("Status from parser: 0");
        }
        catch (DDSException e) {
            System.err.println(e.getMessage() + "\n");
            System.out.println("Status from parser: 0");
        }
        try {
            table.checkSemantics();
            System.out.println("DDS past semantic check");
        }
        catch (BadSemanticsException e) {
            System.out.println("DDS failed semantic check");
        }
        try {
            table.checkSemantics(true);
            System.out.println("DDS past full semantic check");
        }
        catch (BadSemanticsException e) {
            System.out.println("DDS failed full semantic check");
        }
        table.print(System.out);
    }

    private static void test_class() {
        BaseType bt;
        DDS table = new DDS();
        try {
            table.parse(System.in);
            System.out.println("Status from parser: 1");
        }
        catch (ParseException e) {
            System.err.println(e.getMessage() + "\n");
            System.out.println("Status from parser: 0");
        }
        catch (DDSException e) {
            System.err.println(e.getMessage() + "\n");
            System.out.println("Status from parser: 0");
        }
        try {
            table.checkSemantics();
            System.out.println("DDS past semantic check");
        }
        catch (BadSemanticsException e) {
            System.out.println("DDS filed semantic check");
        }
        try {
            table.checkSemantics(true);
            System.out.println("DDS past full semantic check");
        }
        catch (BadSemanticsException e) {
            System.out.println("DDS filed full semantic check");
        }
        table.print(System.out);
        DDS table2 = (DDS)table.clone();
        table2.print(System.out);
        System.out.println("Dataset name: " + table.getName());
        String name = "goofy";
        DefaultFactory factory = new DefaultFactory();
        table.addVariable(factory.newDInt32(name));
        table.print(System.out);
        try {
            bt = table.getVariable(name);
            bt.printDecl(System.out, "");
        }
        catch (NoSuchVariableException e) {
            System.out.println(e.getMessage());
        }
        table.delVariable(name);
        table.print(System.out);
        table.addVariable(factory.newDInt32(name));
        table.print(System.out);
        try {
            bt = table.getVariable(name);
            bt.printDecl(System.out, "");
        }
        catch (NoSuchVariableException e) {
            System.out.println(e.getMessage());
        }
        table.delVariable(name);
        table.print(System.out);
        Enumeration e = table.getVariables();
        while (e.hasMoreElements()) {
            bt = (BaseType)e.nextElement();
            bt.printDecl(System.out, "");
        }
    }
}

