/* $Id: simsetup.h,v 1.19 2011-02-04 15:21:33 potyra Exp $ 
 *
 * Copyright (C) 2005-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef SIMSETUP_H
#define SIMSETUP_H

#include "list.h"

struct simsetup {
	int index;			/* first port which is used */

	struct list_header	comps;	/* component specific simulation setups */

	/* vhdl specific parameters */

	const char *vhdl_model;		/* name of the VHDL file to use */
	const char *base_entity;	/* name of the base component, in case of several setups combined in one */

	/* simulation time/mode specific parameters */
	int deterministic;
	int simplesetup;
	/** interactive mode? (allows input from real mouse/keyboard) */
	int interactive;
	/* use cow files? */
	int cow;
	/* use sparse files? */
	int sparse;
	/* create new image? */
	int create;
	/* which gui to use*/
	const char *gui;
	
};

extern struct simsetup simsetup;

extern struct structure_component *
simsetup_for_component(const char *name);

extern const char *
simsetup_get(const char *node, const char *key);

#endif
