/*
 * $Id: sig_keyboard.c,v 1.10 2009-05-21 16:38:08 vrsieh Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "sig_keyboard.h"

int
sig_keyboard_key_press(
	struct sig_keyboard *b,
	void *s,
	unsigned int key
)
{
	unsigned int nr;

	for (nr = 0; ; nr++) {
		int (*func)(void *, unsigned int);

		if (nr == b->member_count) {
			return -1;
		}
		func = b->member[nr].f->key_press;
		if (func
		 && func(b->member[nr].s, key) == 0) {
			return 0;
		}
	}
}

int
sig_keyboard_key_release(
	struct sig_keyboard *b,
	void *s,
	unsigned int key
)
{
	unsigned int nr;

	for (nr = 0; ; nr++) {
		int (*func)(void *, unsigned int);

		if (nr == b->member_count) {
			return -1;
		}
		func = b->member[nr].f->key_release;
		if (func
		 && func(b->member[nr].s, key) == 0) {
			return 0;
		}
	}
}

int
sig_keyboard_led_on(
	struct sig_keyboard *b,
	void *s,
	unsigned int led
)
{
	unsigned int nr;

	for (nr = 0; ; nr++) {
		int (*func)(void *, unsigned int);

		if (nr == b->member_count) {
			return -1;
		}
		func = b->member[nr].f->led_on;
		if (func
		 && func(b->member[nr].s, led) == 0) {
			return 0;
		}
	}
}

int
sig_keyboard_led_off(
	struct sig_keyboard *b,
	void *s,
	unsigned int led
)
{
	unsigned int nr;

	for (nr = 0; ; nr++) {
		int (*func)(void *, unsigned int);

		if (nr == b->member_count) {
			return -1;
		}
		func = b->member[nr].f->led_off;
		if (func
		 && func(b->member[nr].s, led) == 0) {
			return 0;
		}
	}
}

void
sig_keyboard_connect(
	struct sig_keyboard *b,
	void *s,
	const struct sig_keyboard_funcs *f
)
{
	assert(b);
	assert(b->type == SIG_GEN_KEYBOARD);
	assert(b->member_count < sizeof(b->member) / sizeof(b->member[0]));

	b->member[b->member_count].s = s;
	b->member[b->member_count].f = f;
	b->member_count++;
}

struct sig_keyboard *
sig_keyboard_create(const char *name)
{
	struct sig_keyboard *b;

	b = malloc(sizeof(*b));
	assert(b);

	b->type = SIG_GEN_KEYBOARD;
	b->member_count = 0;

	return b;
}

void
sig_keyboard_destroy(struct sig_keyboard *sig)
{
	assert(sig);
	assert(sig->type == SIG_GEN_KEYBOARD);

	free(sig);
}
