/* $Id: ROffset.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * ROffset: calculate record offset (intermediate opcode)
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */


#ifndef __R_OFFSET_HPP_INCLUDED
#define __R_OFFSET_HPP_INCLUDED

#include <cassert>
#include "intermediate/operands/Register.hpp"
#include "intermediate/container/Type.hpp"


namespace intermediate {

//! Calculate the record offset to a given base pointer and a given type.
/** This class will calculate the record offset for a given base
 *  pointer and a given type.
 *
 *  Read operands: base, offset,
 *  Meta information operand: rtype
 *  Write operands: dst
 *
 *  Operation: dst = b + relative offset(rtype.offset)
 *
 *  FIXME need to know about the kind (signal/variable/driver), in order
 *        to advance to the element.
 */
class ROffset : public OpCode {
public:
	ROffset(
		Operand *b,
		Operand *off,
		Type *t,
		Register *destination
		) :	base(b),
			offset(off),
			rtype(t),
			dst(destination) {

		assert(b->type == OP_TYPE_POINTER);
		assert(off->type == OP_TYPE_INTEGER);
	}

	//! Accept a Visitor.
 	/** All intermediate code nodes need to implement this method.
         *
         *  @param v the Visitor that can visit this node.
         */
	virtual void accept(Visitor& v) {
		v.visit(*this);
	}

	/** base pointer to record */
	Operand *base;
	/** integral record element position (0=first element, 1=second..) */
	Operand *offset;
	/** referred type of the record */
	Type *rtype;
	/** destination operand */
	Register *dst;

protected:
	virtual ~ROffset() {
		util::MiscUtil::terminate(this->base);
		util::MiscUtil::terminate(this->offset);
		util::MiscUtil::terminate(this->rtype);
		util::MiscUtil::terminate(this->dst);
	}
};

}; /* namespace intermediate */

#endif /* __R_OFFSET_HPP_INCLUDED */
