#include <gtk/gtk.h>
#include <ethos/ethos.h>
#include <ethos/ethos-ui.h>

/* This example shows how you can use a widget to turn on and off lugins.
 * However, it doesn't really show the plugins connecting to the user
 * interface in any way.  To do that, you want to create a new interface
 * that provides your UI hooking methods.  Then check to see if the plugin
 * implements that interface, and if so, call its hook methods.
 */

int
main (int   argc,
      char *argv[])
{
	GtkWidget    *window,
		     *manager_widget;
	EthosManager *manager;
	gchar        *plugins[] = { "../../tests/manager-dep/", NULL };

	gtk_init (&argc, &argv);

	manager = ethos_manager_new ();
	ethos_manager_set_app_name (manager, "Test");
	ethos_manager_set_plugin_dirs (manager, plugins);
	ethos_manager_initialize (manager);

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (GTK_WINDOW (window), "Ethos UI");
	gtk_window_set_default_size (GTK_WINDOW (window), 400, 500);
	gtk_container_set_border_width (GTK_CONTAINER (window), 12);
	gtk_widget_show (window);

	manager_widget = ethos_ui_manager_widget_new ();
	ethos_ui_manager_widget_set_manager (
			ETHOS_UI_MANAGER_WIDGET (manager_widget),
			manager);
	gtk_container_add (GTK_CONTAINER (window), manager_widget);
	gtk_widget_show (manager_widget);

	g_signal_connect (G_OBJECT (window),
	                  "destroy",
	                  G_CALLBACK (gtk_main_quit),
	                  NULL);

	gtk_main ();

	return 0;
}
