/* 

   Pascal Ballester (ESO/Garching)           
   Cristian Levin   (ESO/La Silla)          

   nrutil.c
   
   various routines from Numerical Recipes

*/

/*

.VERSION
051021		last modif

*/

/* system includes */

#include <stdio.h>
#include <stdlib.h>

void nrerror
#ifdef __STDC__ 
( 
 char error_text[]
 )
#else
     (
      error_text
      )
     char error_text[];
#endif

{

#ifdef __STDC__
  void exit(int);
#endif

  fprintf(stderr,"Numerical Recipes run-time error...\n");
  return;
}

/* functions of the OSMEMORY module of the Midas system library */

char *osmmget 
(
#ifdef __STDC__
 unsigned int
#endif
 );

void osmmfree
(
#ifdef __STDC__
 char *
#endif
 );

int **imatrix
#ifdef __STDC__
( 
 int nrl, int nrh, int ncl, int nch 
 ) 
#else
     ( 
      nrl, nrh, ncl, nch 
      ) 
     int nrl, nrh, ncl, nch;
#endif
     /* Allocates a int matrix with range [nrl..nrh][ncl..nch] */
{
  int i;
  int **m;

  /* Allocate pointers to rows */
  m = (int **)osmmget( (unsigned) (nrh-nrl+1) * sizeof(int *) );
  m -= nrl;

  /* Allocate rows and set pointers to them */
  for ( i = nrl; i <= nrh; i++ ) {
    m[i] = (int *)osmmget( (unsigned) (nch-ncl+1) * sizeof(int) );
    m[i] -= ncl;
  }
  return (m);
}

void free_imatrix
#ifdef __STDC__
( 
 int **m, int nrl, int nrh, int ncl 
 ) 
#else
     ( 
      m, nrl, nrh, ncl 
      ) 
     int **m,nrl,nrh,ncl;
#endif 
     /* Frees a matrix allocated with imatrix() */

{
  int i;

  for ( i = nrh; i >= nrl; i-- )
    osmmfree( (char *) (m[i] + ncl) );

  osmmfree( (char *) (m + nrl) );
}

int *ivector
#ifdef __STDC__
( 
 int nl, int nh 
 ) 
#else
     (
      nl, nh 
      ) 
     int nl, nh;
#endif
     /* Allocates a int vector with range [nl..nh] */
{
  int *v;

  v = (int *)osmmget( (unsigned) (nh-nl+1) * sizeof(int) );
  return( v - nl );
}

void free_ivector
#ifdef __STDC__
( 
 int *v, int nl 
 ) 
#else
     ( 
      v, nl 
      ) 
     int *v,nl;
#endif
     /* Frees a vector allocated with ivector() */
{
  osmmfree( (char *) (v + nl) );
}

double **dmatrix
#ifdef __STDC__
( 
 int nrl, int nrh, int ncl, int nch 
 ) 
#else
     (
      nrl, nrh, ncl, nch 
      ) 
     int nrl, nrh,ncl,nch;
#endif
     /* Allocates a double matrix with range [nrl..nrh][ncl..nch] */
{
  int i;
  double **m;

  /* Allocate pointers to rows */
  m = (double **)osmmget( (unsigned) (nrh-nrl+1) * sizeof(double *) );
  m -= nrl;

  /* Allocate rows and set pointers to them */
  for ( i = nrl; i <= nrh; i++ ) {
    m[i] = (double *)osmmget( (unsigned) (nch-ncl+1) * sizeof(double) );
    m[i] -= ncl;
  }
  return( m );
}

void free_dmatrix
#ifdef __STDC__
(
 double **m, int nrl, int nrh, int ncl, int nch 
 ) 
#else
     ( 
      m, nrl, nrh, ncl, nch 
      ) 
     double **m;
     int nrl,nrh,ncl,nch;
#endif
     /* Frees a matrix allocated with dmatrix() */
{
  int i;

  for ( i = nrh; i >= nrl; i-- )
    osmmfree( (char *) (m[i] + ncl) );

  osmmfree( (char *) (m + nrl) );
}

double *dvector
#ifdef __STDC__
( 
 int nl, int nh 
 ) 
#else
     (
      nl, nh 
      ) 
     int nl, nh;
#endif
     /* Allocates a double vector with range [nl..nh] */
{
  double *v;

  v = (double *)osmmget( (unsigned) (nh-nl+1) * sizeof(double) );
  return( v - nl );
}

void free_dvector
#ifdef __STDC__
( 
 double *v, int nl, int nh 
 ) 
#else
     (
      v, nl, nh 
      ) 
     double *v;
     int nl, nh;
#endif
     /* Frees a vector allocated with dvector() */
{
  osmmfree( (char *) (v + nl) );
}

float **fmatrix
#ifdef __STDC__
( 
 int nrl, int nrh, int ncl, int nch 
 ) 
#else
     ( 
      nrl, nrh, ncl, nch 
      ) 
     int nrl,nrh,ncl,nch;
#endif
     /* Allocates a float matrix with range [nrl..nrh][ncl..nch] */
{
  int i;
  float **m;

  /* Allocate pointers to rows */
  m = (float **)osmmget( (unsigned) (nrh-nrl+1) * sizeof(float *) );
  m -= nrl;

  /* Allocate rows and set pointers to them */
  for ( i = nrl; i <= nrh; i++ ) {
    m[i] = (float *)osmmget( (unsigned) (nch-ncl+1) * sizeof(float) );
    m[i] -= ncl;
  }
  return( m );
}

void free_fmatrix
#ifdef __STDC__
(
 float **m, int nrl, int nrh, int ncl, int nch 
 ) 
#else
     (
      m, nrl, nrh, ncl, nch 
      ) 
     float **m;
     int nrl,nrh,ncl,nch;
#endif
     /* Frees a matrix allocated with fmatrix() */
{
  int i;

  for ( i = nrh; i >= nrl; i-- )
    osmmfree( (char *) (m[i] + ncl) );

  osmmfree( (char *) (m + nrl) );
}

float *fvector
#ifdef __STDC__
( 
 int nl, int nh 
 ) 
#else
     ( 
      nl, nh 
      ) 
     int nl,nh;
#endif
     /* Allocates a float vector with range [nl..nh] */
{
  float *v;

  v = (float *)osmmget( (unsigned) (nh-nl+1) * sizeof(float) );
  return( v - nl );
}


void free_fvector
#ifdef __STDC__
( 
 float *v, int nl, int nh 
 ) 
#else
     (
      v, nl, nh 
      ) 
     float *v;
     int nl,nh;
#endif
     /* Frees a vector allocated with fvector() */
{
  osmmfree( (char *) (v + nl) );
}

char **cmatrix
#ifdef __STDC__
( 
 int nrl, int nrh, int ncl, int nch 
 ) 
#else
     ( 
      nrl, nrh, ncl, nch 
      ) 
     int nrl,nrh,ncl,nch;
#endif
     /* Allocates a char matrix with range [nrl..nrh][ncl..nch] */
{
  int i;
  char **m;

  /* Allocate pointers to rows */
  m = (char **)osmmget( (unsigned) (nrh-nrl+1) * sizeof(char *) );
  m -= nrl;

  /* Allocate rows and set pointers to them */
  for ( i = nrl; i <= nrh; i++ ) {
    m[i] = (char *)osmmget( (unsigned) (nch-ncl+1) * sizeof(char) );
    m[i] -= ncl;
  }
  return( m );
}

void free_cmatrix
#ifdef __STDC__
( 
 char **m, int nrl, int nrh, int ncl, int nch 
 ) 
#else
     ( 
      m, nrl, nrh, ncl, nch 
      ) 
     char **m;
     int nrl,nrh,ncl,nch;
#endif
     /* Frees a matrix allocated with cmatrix() */
{
  int i;

  for ( i = nrh; i >= nrl; i-- )
    osmmfree( (char *) (m[i] + ncl) );

  osmmfree( (char *) (m + nrl) );
}

char *cvector
#ifdef __STDC__
(
 int nl, int nh 
 ) 
#else
     ( 
      nl, nh 
      ) 
     int nl,nh;
#endif
     /* Allocates a char vector with range [nl..nh] */
{
  char *v;

  v = (char *)osmmget( (unsigned) (nh-nl+1) * sizeof(char) );
  return( v - nl );
}

void free_cvector
#ifdef __STDC__
( 
 char *v, int nl, int nh 
 ) 
#else
     (
      v, nl, nh 
      ) 
     char *v;
     int nl,nh;
#endif
     /* Frees a vector allocated with cvector() */
{
  osmmfree( (char *) (v + nl) );
}


float *vector
#ifdef __STDC__
(
 int nl, int nh
 )
#else
     (
      nl, nh
      )
     int nl, nh;
#endif

{
  float *v;
  
  v=(float *)malloc((size_t) (nh-nl+1)*sizeof(float));
  if (!v) nrerror("allocation failure in vector()");
  return v-nl;
}

void free_vector
#ifdef __STDC__
( 
 float *v, int nl, int nh
 )
#else
     (
      v,nl,nh
      )
     int *v,nl,nh;
#endif

{
  osmmfree((char*) (v+nl));
}

float **matrix
#ifdef __STDC__
(
 int nrl, int nrh, int ncl, int nch
 )
#else
     (
      nrl, nrh, ncl, nch
      )
     int nrl, nrh, ncl, nch;
#endif

{
  int i;
  float **m;

  m=(float **) malloc((size_t) (nrh-nrl+1)*sizeof(float*));
  if (!m) nrerror("allocation failure 1 in matrix()");
  m -= nrl;

  for(i=nrl;i<=nrh;i++) {
    m[i]=(float *) malloc((size_t) (nch-ncl+1)*sizeof(float));
    if (!m[i]) nrerror("allocation failure 2 in matrix()");
    m[i] -= ncl;
  }
  return m;
}

void free_matrix
#ifdef __STDC__
(
 float **m, int nrl, int nrh, int ncl, int nch
 )
#else
     (
      m,nrl,nrh,ncl,nch
      )
     float **m;
     int nrl,nrh,ncl,nch;
#endif

{
  int i;

  for(i=nrh;i>=nrl;i--) free((char*) (m[i]+ncl));
  free((char*) (m+nrl));
}

float **submatrix
#ifdef __STDC__
( 
 float **a, int oldrl, int oldrh, int oldcl,
 int oldch, int newrl, int newcl
 )
#else
     (
      a,oldrl,oldrh,oldcl,oldch,newrl,newcl
      )
     float **a;
     int oldrl,oldrh,oldcl,oldch,newrl,newcl;
#endif

{
  int i,j;
  float **m;

  m=(float **) malloc((size_t) (oldrh-oldrl+1)*sizeof(float*));
  if (!m) nrerror("allocation failure in submatrix()");
  m -= newrl;

  for(i=oldrl,j=newrl;i<=oldrh;i++,j++) m[j]=a[i]+oldcl-newcl;

  return m;
}

void free_submatrix
#ifdef __STDC__
(
 float **b, int nrl, int nrh, int ncl, int nch
 )
#else
     (
      b,nrl,nrh,ncl,nch
      )
     float **b;
     int nrl,nrh,ncl,nch;
#endif

{
  osmmfree((char*) (b+nrl));
}

float **convert_matrix
#ifdef __STDC__
(
 float *a, int nrl, int nrh, int ncl, int nch
 )
#else
     (
      a,nrl,nrh,ncl,nch
      )
     float *a;
     int nrl,nrh,ncl,nch;
#endif

{
  int i,j,nrow,ncol;
  float **m;

  nrow=nrh-nrl+1;
  ncol=nch-ncl+1;
  m = (float **) malloc((size_t) (nrow)*sizeof(float*));
  if (!m) nrerror("allocation failure in convert_matrix()");
  m -= nrl;
  for(i=0,j=nrl;i<=nrow-1;i++,j++) m[j]=a+ncol*i-ncl;
  return m;
}

void free_convert_matrix
#ifdef __STDC__
(
 float **b, int nrl, int nrh, int ncl, int nch
 )
#else
     (
      b,nrl,nrh,ncl,nch
      )
     float **b;
     int nrl,nrh,ncl,nch;
#endif

{
  osmmfree((char*) (b+nrl));
}
