/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import org.apache.regexp.RESyntaxException;
import org.emboss.jemboss.JembossJarUtil;

public class Matrix {
    private int[][] matrix;
    private int idimension;
    private int jdimension;
    private int i = 0;
    private int k = 0;
    private Hashtable residueMatrixPosition;
    private Object[] keys = null;
    private String matrixString = null;
    private String matrixFileName = null;
    public static final String DEFAULT_MATRIX = "EBLOSUM62";
    private String matrixFilesLocation;
    private int locationType;
    private static int LOCATION_JAR_ARCHIVE = 1;
    private static int LOCATION_DATA_DIR = 2;

    public Matrix(File matrixFile) {
        this.matrixFileName = matrixFile.getName();
        this.matrixRead(matrixFile);
    }

    public Matrix(String matrixFilesLocation, String matrixFileName) {
        this.matrixFileName = matrixFileName;
        this.matrixFilesLocation = matrixFilesLocation;
        File mfl = new File(matrixFilesLocation);
        if (mfl.isDirectory()) {
            this.keys = mfl.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith("EPAM") || name.startsWith("EBLOSUM") || name.startsWith("ENUC");
                }
            });
            File m = new File(matrixFilesLocation + "/" + matrixFileName);
            try {
                this.matrixString = this.readFileAsString(m);
                this.matrixReadString(this.matrixString);
                this.locationType = LOCATION_DATA_DIR;
                Arrays.sort(this.keys);
                return;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        String matrixJar = matrixFilesLocation;
        try {
            Hashtable matrixHash = new JembossJarUtil(matrixJar).getHash();
            this.keys = matrixHash.keySet().toArray();
            Arrays.sort(this.keys);
            if (matrixHash.containsKey(matrixFileName)) {
                this.matrixString = new String((byte[])matrixHash.get(matrixFileName));
                this.matrixReadString(this.matrixString);
                this.locationType = LOCATION_JAR_ARCHIVE;
            } else {
                System.err.println("Matrix file " + matrixFileName + " not found in jar file " + matrixJar);
            }
        }
        catch (Exception exp) {
            JOptionPane.showMessageDialog(null, "Failed to read " + matrixFileName + "\nfrom the matrix archive " + matrixJar, "Missing matrix archive", 0);
        }
    }

    public void changeMatrix(String matrixFileName) {
        this.i = 0;
        this.k = 0;
        if (this.locationType == LOCATION_DATA_DIR) {
            File m = new File(this.matrixFilesLocation + "/" + matrixFileName);
            try {
                this.matrixString = this.readFileAsString(m);
                this.matrixReadString(this.matrixString);
            }
            catch (IOException e) {
                // empty catch block
            }
            return;
        }
        String matrixJar = this.matrixFilesLocation;
        try {
            Hashtable matrixHash = new JembossJarUtil(matrixJar).getHash();
            if (matrixHash.containsKey(matrixFileName)) {
                this.matrixString = new String((byte[])matrixHash.get(matrixFileName));
                this.matrixReadString(this.matrixString);
            } else {
                System.err.println("Matrix file " + matrixFileName + " not found in jar file " + matrixJar);
            }
        }
        catch (Exception exp) {
            JOptionPane.showMessageDialog(null, "Failed to read " + matrixFileName + "\nfrom the matrix archive " + matrixJar, "Missing matrix archive", 0);
        }
    }

    final String readFileAsString(File source) throws IOException {
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(source)));
        byte[] buffer = new byte[(int)source.length()];
        dis.readFully(buffer);
        dis.close();
        return new String(buffer);
    }

    public int[][] getMatrix() {
        return this.matrix;
    }

    public String getMatrixTable() {
        return this.matrixString;
    }

    public String getCurrentMatrixName() {
        int index = this.matrixFileName.lastIndexOf("/");
        if (index > -1) {
            return this.matrixFileName.substring(index + 1);
        }
        return this.matrixFileName;
    }

    public Object[] getKeys() {
        return this.keys;
    }

    public Object[] getKeyNames() {
        try {
            int nkeys = this.keys.length;
            Object[] kname = new Object[nkeys];
            for (int i = 0; i < nkeys; ++i) {
                String k = (String)this.keys[i];
                if (k.indexOf("MANIFEST.MF") != -1) continue;
                int pos = k.indexOf("/") + 1;
                kname[i] = k.substring(pos);
            }
            return kname;
        }
        catch (NullPointerException npe) {
            JOptionPane.showMessageDialog(null, "No matrix files found!", "Matrix files missing", 0);
            return null;
        }
    }

    public String getKeyNamesString() {
        try {
            int nkeys = this.keys.length;
            StringBuffer kname = new StringBuffer();
            for (int i = 0; i < nkeys; ++i) {
                String k = (String)this.keys[i];
                if (k.indexOf("MANIFEST.MF") != -1) continue;
                int pos = k.indexOf("/") + 1;
                kname.append(k.substring(pos) + "\n");
            }
            return kname.toString();
        }
        catch (NullPointerException npe) {
            JOptionPane.showMessageDialog(null, "No matrix files found!", "Matrix files missing", 0);
            return null;
        }
    }

    public Hashtable getResidueMatrixPosition() {
        return this.residueMatrixPosition;
    }

    public int getMatrixIndex(String s) {
        s = s.toUpperCase();
        if (this.residueMatrixPosition == null) {
            return -1;
        }
        if (!this.residueMatrixPosition.containsKey(s) && (s.equals(".") || s.equals("-") || s.equals("~"))) {
            s = "X";
        }
        if (!this.residueMatrixPosition.containsKey(s)) {
            return -1;
        }
        return (Integer)this.residueMatrixPosition.get(s);
    }

    public int getIDimension() {
        return this.idimension;
    }

    public int getJDimension() {
        return this.jdimension;
    }

    private RE getRegularExpression() {
        RE regexp = null;
        try {
            RECompiler rec = new RECompiler();
            REProgram rep = rec.compile("[:digit:]");
            regexp = new RE(rep);
        }
        catch (RESyntaxException rese) {
            System.out.println("RESyntaxException ");
        }
        return regexp;
    }

    private void matrixLineCount(String line, RE regexp) {
        String delim = " :\t\n";
        if (!line.startsWith("#") && !line.equals("") && regexp.match(line)) {
            this.jdimension = 0;
            ++this.idimension;
            line = line.trim();
            StringTokenizer st = new StringTokenizer(line, delim);
            while (st.hasMoreTokens()) {
                st.nextToken();
                ++this.jdimension;
            }
        }
    }

    private void matrixLineParse(String line, RE regexp) {
        String delim = " :\t\n";
        int j = 0;
        if (!line.startsWith("#") && !line.equals("")) {
            line = line.trim();
            StringTokenizer st = new StringTokenizer(line, delim);
            if (!regexp.match(line)) {
                while (st.hasMoreTokens()) {
                    this.residueMatrixPosition.put(st.nextToken(), new Integer(this.k));
                    ++this.k;
                }
            } else {
                st.nextToken();
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    this.matrix[this.i][j] = Integer.parseInt(s);
                    ++j;
                }
                ++this.i;
            }
        }
    }

    private int[][] matrixRead(File matrixFile) {
        BufferedReader in;
        String line = "";
        this.residueMatrixPosition = new Hashtable();
        this.idimension = 1;
        RE regexp = this.getRegularExpression();
        try {
            in = new BufferedReader(new FileReader(matrixFile));
            while ((line = in.readLine()) != null) {
                this.matrixLineCount(line, regexp);
            }
            in.close();
        }
        catch (IOException e) {
            System.out.println("Cannot read matrix file in!");
        }
        this.matrix = new int[this.idimension][this.jdimension];
        try {
            in = new BufferedReader(new FileReader(matrixFile));
            while ((line = in.readLine()) != null) {
                this.matrixLineParse(line, regexp);
            }
            in.close();
        }
        catch (IOException e) {
            System.out.println("Cannot read matrix file in!");
        }
        return this.matrix;
    }

    private int[][] matrixReadString(String matrixString) {
        BufferedReader in;
        String line = "";
        this.residueMatrixPosition = new Hashtable();
        this.idimension = 1;
        RE regexp = this.getRegularExpression();
        try {
            in = new BufferedReader(new StringReader(matrixString));
            while ((line = in.readLine()) != null) {
                this.matrixLineCount(line, regexp);
            }
            in.close();
        }
        catch (IOException e) {
            System.out.println("Cannot read matrix file in!");
        }
        this.matrix = new int[this.idimension][this.jdimension];
        try {
            in = new BufferedReader(new StringReader(matrixString));
            while ((line = in.readLine()) != null) {
                this.matrixLineParse(line, regexp);
            }
            in.close();
        }
        catch (IOException e) {
            System.out.println("Cannot read matrix file in!");
        }
        return this.matrix;
    }
}

