package de.lmu.ifi.dbs.elki.visualization.style;

/*
 This file is part of ELKI:
 Environment for Developing KDD-Applications Supported by Index-Structures

 Copyright (C) 2012
 Ludwig-Maximilians-Universität München
 Lehr- und Forschungseinheit für Datenbanksysteme
 ELKI Development Team

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU Affero General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU Affero General Public License for more details.

 You should have received a copy of the GNU Affero General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;

/**
 * Styling policy that is based on <em>classes</em>, for example clusters or
 * labels. This allows for certain optimizations such as marker reuse, and thus
 * is preferred when possible.
 * 
 * @author Erich Schubert
 */
public interface ClassStylingPolicy extends StylingPolicy {
  /**
   * Get the style number for a particular object
   * 
   * @param id Object ID
   * @return Style number
   */
  public int getStyleForDBID(DBIDRef id);

  /**
   * Get the minimum style in use.
   * 
   * @return Style number
   */
  public int getMinStyle();

  /**
   * Get the maximum style in use.
   * 
   * @return Style number
   */
  public int getMaxStyle();
  
  /**
   * Iterate over all objects from a given class.
   * 
   * @param cnum Class number
   * @return Iterator over object IDs
   */
  public DBIDIter iterateClass(int cnum);
}