/*
Copyright (C) 2006 Milosz Tanski

This file is part of Drapes.

Drapes is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

Drapes is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Drapes; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

using System.Reflection;
using System.Runtime.CompilerServices;

// Information about this assembly is defined by the following
// attributes.
//
// change them to the information which is associated with the assembly
// you compile.

[assembly: AssemblyVersion("0.5.2.*")]
[assembly: AssemblyTitle("Drapes")]
[assembly: AssemblyDescription("Desktop Drapes wallpaper manager")]
[assembly: AssemblyProduct("Drapes")]
[assembly: AssemblyCopyright("Copyright (C) Milosz Tanski")]

namespace Drapes
{
	public class CompileOptions {
		private static string data_dir = "/usr/local/share/drapes";
		private static string version = "0.5.2";
		private static string gnome_ui_dir = "/usr/local/share/gnome-2.0/ui";
		private static string gnome_locale_dir = "/usr/local/share/locale";
		private static string prefix_dir = "/usr/local";

		public static string Prefix
		{
			get { return prefix_dir; }
		}
		
		public static string GnomeXmlUiDir
		{
			get { return gnome_ui_dir; }
		}
		
		public static string DataDir
		{	
			get { return data_dir; }
		}
		
		public static string Version
		{
			get { return version; }
		}
		
		public static string GnomeLocaleDir
		{
			get { return gnome_locale_dir; }
		}
	}

}
