/****************************************************************************
** 
**
** Implementation of the QString class and related Unicode functions
**
** Created : 920722
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of the tools module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

// Don't define it while compiling this module, or USERS of Qt will
// not be able to link.
#ifdef QT_NO_CAST_ASCII
#undef QT_NO_CAST_ASCII
#endif

#include "qstring.h"
#include "qregexp.h"
#include "qdatastream.h"
#include "qtextcodec.h"
#include "qstack.h"
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>
#include <limits.h>


/* -------------------------------------------------------------------------
 * unicode information
 * these tables are generated from the unicode reference file
 * ftp://ftp.unicode.org/Public/3.0-Update/UnicodeData-3.0.0.html
 *
 * Lars Knoll <knoll@mpi-hd.mpg.de>
 * -------------------------------------------------------------------------
 */

/* Perl script to generate (run perl -x tools/qstring.cpp)

#!perl

sub numberize
{
    my(%r, $n, $id);
    for $id ( @_ ) {
	$id="" if $id eq "EMPTY";
	$r{$id}=$n++;
    }
    return %r;
}


# Code to integer mappings...
#
%category_code = numberize(qw{
      EMPTY
      Mn Mc Me
      Nd Nl No
      Zs Zl Zp
      Cc Cf Cs Co Cn

      Lu Ll Lt Lm Lo
      Pc Pd Ps Pe Pi Pf Po
      Sm Sc Sk So
});
%bidi_category_code = numberize(qw{
      L R EN ES ET AN CS B S WS ON LRE LRO AL RLE RLO PDF NSM BN});
%character_decomposition_tag = numberize(qw{
      <single> <canonical> <font> <noBreak> <initial> <medial>
      <final> <isolated> <circle> <super> <sub> <vertical>
      <wide> <narrow> <small> <square> <compat> <fraction>
});
%mirrored_code = numberize(qw{N Y});

%joining_code = numberize(qw{U D R C});

# Read data into hashes...
#
open IN, "UnicodeData.txt";
$position = 1;
while (<IN>) {
    @fields = split /;/;
    $code = shift @fields;
    for $n (qw{
      name category combining_class bidi_category
      character_decomposition decimal_digit_value digit_value
      numeric_value mirrored oldname comment
      uppercase lowercase titlecase})
    {
	$id = shift @fields;
	$codes = "${n}_code";
	if ( defined %$codes && defined $$codes{$id} ) {
	    $id = $$codes{$id};
	}
	${$n}{$code}=$id;
    }
    $decomp = $character_decomposition{$code};
    if ( length $decomp == 0 ) {
	$decomp = "<single>";
    }
    if (substr($decomp, 0, 1) ne '<') {
	$decomp = "<canonical> " . $decomp;
    }
    @fields = split(" ", $decomp);
    $tag = shift @fields;
    $tag = $character_decomposition_tag{$tag};
    $decomp = join( ", 0x", @fields );
    $decomp = "0x".$decomp;
    $decomposition{$code} = $decomp;
    $decomposition_tag{$code} = $tag;
    $decomposition_pos{$code} = $position;
    $len = scalar(@fields);
    $decomposition_len{$code} = $len;

#   we use canonical decompositions longer than 1 char
#   and all arabic ligatures for the ligature table
    if(($len > 1 and $tag == 1) or ($tag > 3 and $tag < 8)) {
#      ligature to add...
	$start = shift @fields;
	$ligature{$start} = $ligature{$start}." ".$code;
    }

#   adjust position
    if($len != 0) {
	$position += $len + 3;
    }


}

open IN2, "ArabicShaping.txt";
$position = 1;
while (<IN2>) {
    @fields = split /;/;
    $code = shift @fields;
    $dummy = shift @fields;
    $join = shift @fields;
    $join =~ s/ //g;
    $join = $joining_code{$join};
    $joining{$code}=$join;
}

# Build pages...
#
$rowtable_txt =
    "static const Q_UINT8 * const unicode_info[256] = {";
for $row ( 0..255 ) {
    $nonzero=0;
    $txt = "";
    for $cell ( 0..255 ) {
	$code = sprintf("%02X%02X",$row,$cell);
	$info = $category{$code};
	$info = 0 if !defined $info;
	$txt .= "\n    " if $cell%8 == 0;
	$txt .= "$info, ";
    }
    $therow = $row{$txt};
    if ( !defined $therow ) {
	$size+=256;
	$therow = "ui_".sprintf("%02X",$row);
	$rowtext{$therow} =
	    "static const Q_UINT8 ${therow}[] = {$txt\n};\n\n";
	$row{$txt}=$therow;
    }
    $rowtable_txt .= "\n    " if $row%8 == 0;
    $rowtable_txt .= "$therow, ";
}

print "// START OF GENERATED DATA\n\n";
print "#ifndef QT_NO_UNICODETABLES\n\n";

# Print pages...
#
for $r ( sort keys %rowtext ) {
    print $rowtext{$r};
}
print "$rowtable_txt\n};\n";
$size += 256*4;
print "// $size bytes\n\n";

# Build decomposition tables
#
$rowtable_txt =
    "static const Q_UINT16 * const decomposition_info[256] = {";
$table_txt =
    "static const Q_UINT16 decomposition_map[] = {\n    0,\n";
for $row ( 0..255 ) {
    $nonzero=0;
    $txt = "";
    for $cell ( 0..255 ) {
	$code = sprintf("%02X%02X",$row,$cell);
	$txt .= "\n   " if $cell%8 == 0;
	if( $decomposition_tag{$code} != 0 ) {
	    $txt .= " $decomposition_pos{$code},";
	    $table_txt .= "    $decomposition_tag{$code},";
	    $table_txt .= " 0x$code,";
	    $table_txt .= " $decomposition{$code}, 0,\n";
	    $size += 2 * $decomposition_len{$code} + 6;
	} else {
	    $txt .= " 0,";
	}
    }
    $therow = $row{$txt};
    if ( !defined $therow ) {
	$size+=512;
	$therow = "di_".sprintf("%02X",$row);
	$dec_rowtext{$therow} =
	    "static const Q_UINT16 ${therow}[] = {$txt\n};\n\n";
	$row{$txt}=$therow;
    }
    $rowtable_txt .= "\n    " if $row%8 == 0;
    $rowtable_txt .= "$therow, ";
}

# Print decomposition tables
#
print "$table_txt\n};\n\n";
for $r ( sort keys %dec_rowtext ) {
    print $dec_rowtext{$r};
}
print "$rowtable_txt\n};\n";
$size += 256*4;
print "// $size bytes\n\n";


# build ligature tables
#
$size = 0;
$position = 1;
$rowtable_txt =
    "static const Q_UINT16 * const ligature_info[256] = {";
$table_txt =
    "static const Q_UINT16 ligature_map[] = {\n    0,\n";
for $lig_row ( 0..255 ) {
    $nonzero=0;
    $txt = "";
    for $cell ( 0..255 ) {
	$code = sprintf("%02X%02X",$lig_row,$cell);
	$txt .= "\n   " if $cell%8 == 0;
	if( defined $ligature{$code} ) {
	    $txt .= " $position,";
	    @ligature = split(" ", $ligature{$code});
#           we need to sort ligatures according to their length.
#           long ones have to come first!
	    @ligature_sort = sort { $decomposition_len{$b} <=>  $decomposition_len{$a} } @ligature;
#           now replace each code by it's position in
#           the decomposition map.
	    undef(@lig_pos);
	    for $n (@ligature_sort) {
		push(@lig_pos, $decomposition_pos{$n});
	    }
#           debug info
	    if( 0 ) {
		print "ligatures: $ligature{$code}\n";
		$sort = join(" ", @ligature_sort);
		print "sorted   : $sort\n";
	    }
	    $lig = join(", ", @lig_pos);
	    $table_txt .= "    $lig, 0,\n";
	    $size += 2 * scalar(@ligature) + 2;
	    $position += scalar(@ligature) + 1;
	} else {
	    $txt .= " 0,";
	}
    }
    $therow = $lig_row{$txt};
    if ( !defined $therow ) {
	$size+=512;
	$therow = "li_".sprintf("%02X",$lig_row);
	$lig_rowtext{$therow} =
	    "static const Q_UINT16 ${therow}[] = {$txt\n};\n\n";
	$lig_row{$txt}=$therow;
    }
    $rowtable_txt .= "\n    " if $lig_row%8 == 0;
    $rowtable_txt .= "$therow, ";
}

# Print ligature tables
#
print "$table_txt\n};\n\n";
for $r ( sort keys %lig_rowtext ) {
    print $lig_rowtext{$r};
}
print "$rowtable_txt\n};\n";
$size += 256*4;
print "// $size bytes\n\n";



# Build direction/joining/mirrored pages...
#
$rowtable_txt =
    "static const Q_UINT8 * const direction_info[256] = {";
for $dir_row ( 0..255 ) {
    $nonzero=0;
    $txt = "";
    for $cell ( 0..255 ) {
	$code = sprintf("%02X%02X",$dir_row,$cell);
	$dir = $bidi_category{$code};
	$dir = 0 if !defined $dir;
	$join = $joining{$code};
	$join = 0 if !defined $join;
	$mirr = $mirrored{$code};
	$mirr = 0 if !defined $mirr;
	$info = $dir + 32*$join + 128*$mirr;
	$txt .= "\n    " if $cell%8 == 0;
	$txt .= "$info, ";
    }
    $therow = $dir_row{$txt};
    if ( !defined $therow ) {
	$size+=256;
	$therow = "dir_".sprintf("%02X",$dir_row);
	$dir_rowtext{$therow} =
	    "static const Q_UINT8 ${therow}[] = {$txt\n};\n\n";
	$dir_row{$txt}=$therow;
    }
    $rowtable_txt .= "\n    " if $dir_row%8 == 0;
    $rowtable_txt .= "$therow, ";
}

# Print pages...
#
for $r ( sort keys %dir_rowtext ) {
    print $dir_rowtext{$r};
}
print "$rowtable_txt\n};\n";
$size += 256*4;
print "// $size bytes\n\n";



print "#endif\n\n";
print "// END OF GENERATED DATA\n\n";


__END__

*/


// START OF GENERATED DATA

static const Q_UINT8 ui_00[] = {
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    7, 26, 26, 26, 28, 26, 26, 26,
    22, 23, 26, 27, 26, 21, 26, 26,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 26, 26, 27, 27, 27, 26,
    26, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 22, 26, 23, 29, 20,
    29, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 22, 27, 23, 27, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    7, 26, 28, 28, 28, 28, 30, 30,
    29, 30, 16, 24, 27, 21, 30, 29,
    30, 27, 6, 6, 29, 16, 30, 26,
    29, 6, 16, 25, 6, 6, 6, 26,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 27,
    15, 15, 15, 15, 15, 15, 15, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 27,
    16, 16, 16, 16, 16, 16, 16, 16,
};

#ifndef QT_NO_UNICODETABLES

static const Q_UINT8 ui_01[] = {
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    16, 15, 16, 15, 16, 15, 16, 15,
    16, 15, 16, 15, 16, 15, 16, 15,
    16, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 15, 16, 15, 16, 15, 16, 16,
    16, 15, 15, 16, 15, 16, 15, 15,
    16, 15, 15, 15, 16, 16, 15, 15,
    15, 15, 16, 15, 15, 16, 15, 15,
    15, 16, 16, 16, 15, 15, 16, 15,
    15, 16, 15, 16, 15, 16, 15, 15,
    16, 15, 16, 16, 15, 16, 15, 15,
    16, 15, 15, 15, 16, 15, 16, 15,
    15, 16, 16, 19, 15, 16, 16, 16,
    19, 19, 19, 19, 15, 17, 16, 15,
    17, 16, 15, 17, 16, 15, 16, 15,
    16, 15, 16, 15, 16, 15, 16, 15,
    16, 15, 16, 15, 16, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    16, 15, 17, 16, 15, 16, 15, 15,
    15, 16, 15, 16, 15, 16, 15, 16,
};

static const Q_UINT8 ui_02[] = {
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    0, 0, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 0, 0,
    18, 18, 18, 18, 18, 18, 18, 18,
    18, 29, 29, 18, 18, 18, 18, 18,
    18, 18, 29, 29, 29, 29, 29, 29,
    29, 29, 29, 29, 29, 29, 29, 29,
    18, 18, 29, 29, 29, 29, 29, 29,
    29, 29, 29, 29, 29, 29, 29, 29,
    18, 18, 18, 18, 18, 29, 29, 29,
    29, 29, 29, 29, 29, 29, 18, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_03[] = {
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 29, 29, 0, 0,
    0, 0, 18, 0, 0, 0, 26, 0,
    0, 0, 0, 0, 29, 29, 15, 26,
    15, 15, 15, 0, 15, 0, 15, 15,
    16, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 0, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 0,
    16, 16, 15, 15, 15, 16, 16, 16,
    0, 0, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    16, 16, 16, 16, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_04[] = {
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 30, 1, 1, 1, 1, 0,
    3, 3, 0, 0, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 15, 16, 15, 16, 0, 0, 15,
    16, 0, 0, 15, 16, 0, 0, 0,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 0, 0,
    15, 16, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_05[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 0,
    0, 18, 26, 26, 26, 26, 26, 26,
    0, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    0, 26, 21, 0, 0, 0, 0, 0,
    0, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 0, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 0, 1, 1, 1, 26, 1,
    26, 1, 1, 26, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 0, 0, 0, 0, 0,
    19, 19, 19, 26, 26, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_06[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 26, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 26, 0, 0, 0, 26,
    0, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 0, 0, 0, 0, 0,
    18, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 26, 26, 26, 26, 0, 0,
    1, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 26, 19, 1, 1,
    1, 1, 1, 1, 1, 3, 3, 1,
    1, 1, 1, 1, 1, 18, 18, 1,
    1, 30, 1, 1, 1, 1, 0, 0,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 19, 19, 19, 30, 30, 0,
};

static const Q_UINT8 ui_07[] = {
    26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 0, 11,
    19, 1, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_08[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_09[] = {
    0, 1, 1, 2, 0, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 0, 0, 1, 19, 2, 2,
    2, 1, 1, 1, 1, 1, 1, 1,
    1, 2, 2, 2, 2, 1, 0, 0,
    19, 1, 1, 1, 1, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 1, 1, 26, 26, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    26, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 2, 2, 0, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 0, 19,
    19, 0, 0, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 0, 0, 0, 19, 19,
    19, 19, 0, 0, 1, 0, 2, 2,
    2, 1, 1, 1, 1, 0, 0, 2,
    2, 0, 0, 2, 2, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2,
    0, 0, 0, 0, 19, 19, 0, 19,
    19, 19, 1, 1, 0, 0, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    19, 19, 28, 28, 6, 6, 6, 6,
    6, 6, 30, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_0A[] = {
    0, 0, 1, 0, 0, 19, 19, 19,
    19, 19, 19, 0, 0, 0, 0, 19,
    19, 0, 0, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 0, 19, 19, 0,
    19, 19, 0, 0, 1, 0, 2, 2,
    2, 1, 1, 0, 0, 0, 0, 1,
    1, 0, 0, 1, 1, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 19, 19, 19, 19, 0, 19, 0,
    0, 0, 0, 0, 0, 0, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    1, 1, 19, 19, 19, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 1, 2, 0, 19, 19, 19,
    19, 19, 19, 19, 0, 19, 0, 19,
    19, 19, 0, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 0, 19, 19, 19,
    19, 19, 0, 0, 1, 19, 2, 2,
    2, 1, 1, 1, 1, 1, 0, 1,
    1, 2, 0, 2, 2, 1, 0, 0,
    19, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 0, 0, 0, 0, 0, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_0B[] = {
    0, 1, 2, 2, 0, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 0, 19,
    19, 0, 0, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 0, 0, 19, 19,
    19, 19, 0, 0, 1, 19, 2, 1,
    2, 1, 1, 1, 0, 0, 0, 2,
    2, 0, 0, 2, 2, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 2,
    0, 0, 0, 0, 19, 19, 0, 19,
    19, 19, 0, 0, 0, 0, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    30, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 2, 0, 19, 19, 19,
    19, 19, 19, 0, 0, 0, 19, 19,
    19, 0, 19, 19, 19, 19, 0, 0,
    0, 19, 19, 0, 19, 0, 19, 19,
    0, 0, 0, 19, 19, 0, 0, 0,
    19, 19, 19, 0, 0, 0, 19, 19,
    19, 19, 19, 19, 19, 19, 0, 19,
    19, 19, 0, 0, 0, 0, 2, 2,
    1, 2, 2, 0, 0, 0, 2, 2,
    2, 0, 2, 2, 2, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    6, 6, 6, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_0C[] = {
    0, 2, 2, 2, 0, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 0, 19, 19, 19,
    19, 19, 0, 0, 0, 0, 1, 1,
    1, 2, 2, 2, 2, 0, 1, 1,
    1, 0, 1, 1, 1, 1, 0, 0,
    0, 0, 0, 0, 0, 1, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 0, 0, 0, 0, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2, 2, 0, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 0, 19, 19, 19,
    19, 19, 0, 0, 0, 0, 2, 1,
    2, 2, 2, 2, 2, 0, 1, 2,
    2, 0, 2, 2, 1, 1, 0, 0,
    0, 0, 0, 0, 0, 2, 2, 0,
    0, 0, 0, 0, 0, 0, 19, 0,
    19, 19, 0, 0, 0, 0, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_0D[] = {
    0, 0, 2, 2, 0, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 0, 0, 0, 0, 2, 2,
    2, 1, 1, 1, 0, 0, 2, 2,
    2, 0, 2, 2, 2, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 0, 0, 0, 0, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2, 2, 0, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    0, 0, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 0, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 0, 19, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 0,
    0, 0, 1, 0, 0, 0, 0, 2,
    2, 2, 1, 1, 1, 0, 1, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2, 2, 26, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_0E[] = {
    0, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 1, 19, 19, 1, 1, 1, 1,
    1, 1, 1, 0, 0, 0, 0, 28,
    19, 19, 19, 19, 19, 19, 18, 1,
    1, 1, 1, 1, 1, 1, 1, 26,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 26, 26, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 19, 19, 0, 19, 0, 0, 19,
    19, 0, 19, 0, 0, 19, 0, 0,
    0, 0, 0, 0, 19, 19, 19, 19,
    0, 19, 19, 19, 19, 19, 19, 19,
    0, 19, 19, 19, 0, 19, 0, 19,
    0, 0, 19, 19, 0, 19, 19, 19,
    19, 1, 19, 19, 1, 1, 1, 1,
    1, 1, 0, 1, 1, 19, 0, 0,
    19, 19, 19, 19, 19, 0, 18, 0,
    1, 1, 1, 1, 1, 1, 0, 0,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 0, 0, 19, 19, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_0F[] = {
    19, 30, 30, 30, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 30, 30, 30, 30, 30,
    1, 1, 30, 30, 30, 30, 30, 30,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 30, 1, 30, 1,
    30, 1, 22, 23, 22, 23, 2, 2,
    19, 19, 19, 19, 19, 19, 19, 19,
    0, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 0, 0, 0, 0, 0,
    0, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 2,
    1, 1, 1, 1, 1, 26, 1, 1,
    19, 19, 19, 19, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    0, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 0, 30, 30,
    30, 30, 30, 30, 30, 30, 1, 30,
    30, 30, 30, 30, 30, 0, 0, 30,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_10[] = {
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 0, 19, 19, 19, 19, 19,
    0, 19, 19, 0, 2, 1, 1, 1,
    1, 2, 1, 0, 0, 0, 1, 1,
    2, 1, 0, 0, 0, 0, 0, 0,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 26, 26, 26, 26, 26, 26,
    19, 19, 19, 19, 19, 19, 2, 2,
    1, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    0, 0, 0, 26, 0, 0, 0, 0,
};

static const Q_UINT8 ui_11[] = {
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 0, 0, 0, 0, 0, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_12[] = {
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 0, 19, 19, 19, 19, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 0, 19, 19, 19, 19, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 0, 19, 19, 19, 19, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 0, 19, 19, 19, 19, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 0, 19, 19, 19, 19, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
};

static const Q_UINT8 ui_13[] = {
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 0, 19, 19, 19, 19, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 0, 0, 0, 0, 0,
    0, 26, 26, 26, 26, 26, 26, 26,
    26, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_14[] = {
    0, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
};

static const Q_UINT8 ui_15[] = {
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
};

static const Q_UINT8 ui_16[] = {
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 26, 26, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    7, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 22, 23, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 26, 26, 26, 6, 6,
    6, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_17[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 2, 2, 2, 1,
    1, 1, 1, 1, 1, 1, 2, 2,
    2, 2, 2, 2, 2, 2, 1, 2,
    2, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 26, 26, 26, 26,
    26, 26, 26, 28, 26, 0, 0, 0,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_18[] = {
    26, 26, 26, 26, 26, 26, 21, 26,
    26, 26, 26, 11, 11, 11, 11, 0,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 18, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_1E[] = {
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 16, 16,
    16, 16, 16, 16, 0, 0, 0, 0,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_1F[] = {
    16, 16, 16, 16, 16, 16, 16, 16,
    15, 15, 15, 15, 15, 15, 15, 15,
    16, 16, 16, 16, 16, 16, 0, 0,
    15, 15, 15, 15, 15, 15, 0, 0,
    16, 16, 16, 16, 16, 16, 16, 16,
    15, 15, 15, 15, 15, 15, 15, 15,
    16, 16, 16, 16, 16, 16, 16, 16,
    15, 15, 15, 15, 15, 15, 15, 15,
    16, 16, 16, 16, 16, 16, 0, 0,
    15, 15, 15, 15, 15, 15, 0, 0,
    16, 16, 16, 16, 16, 16, 16, 16,
    0, 15, 0, 15, 0, 15, 0, 15,
    16, 16, 16, 16, 16, 16, 16, 16,
    15, 15, 15, 15, 15, 15, 15, 15,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 0, 0,
    16, 16, 16, 16, 16, 16, 16, 16,
    17, 17, 17, 17, 17, 17, 17, 17,
    16, 16, 16, 16, 16, 16, 16, 16,
    17, 17, 17, 17, 17, 17, 17, 17,
    16, 16, 16, 16, 16, 16, 16, 16,
    17, 17, 17, 17, 17, 17, 17, 17,
    16, 16, 16, 16, 16, 0, 16, 16,
    15, 15, 15, 15, 17, 29, 16, 29,
    29, 29, 16, 16, 16, 0, 16, 16,
    15, 15, 15, 15, 17, 29, 29, 29,
    16, 16, 16, 16, 0, 0, 16, 16,
    15, 15, 15, 15, 0, 29, 29, 29,
    16, 16, 16, 16, 16, 16, 16, 16,
    15, 15, 15, 15, 15, 29, 29, 29,
    0, 0, 16, 16, 16, 0, 16, 16,
    15, 15, 15, 15, 17, 29, 29, 0,
};

static const Q_UINT8 ui_20[] = {
    7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 11, 11, 11, 11,
    21, 21, 21, 21, 21, 21, 26, 26,
    24, 25, 22, 24, 24, 25, 22, 24,
    26, 26, 26, 26, 26, 26, 26, 26,
    8, 9, 11, 11, 11, 11, 11, 7,
    26, 26, 26, 26, 26, 26, 26, 26,
    26, 24, 25, 26, 26, 26, 26, 20,
    20, 26, 26, 26, 27, 22, 23, 0,
    26, 26, 26, 26, 26, 26, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 11, 11, 11, 11, 11, 11,
    6, 0, 0, 0, 6, 6, 6, 6,
    6, 6, 27, 27, 27, 22, 23, 16,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 27, 27, 27, 22, 23, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 28, 28, 28, 28, 28,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 3, 3, 3,
    3, 1, 3, 3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_21[] = {
    30, 30, 15, 30, 30, 30, 30, 15,
    30, 30, 16, 15, 15, 15, 16, 16,
    15, 15, 15, 16, 30, 15, 30, 30,
    30, 15, 15, 15, 15, 15, 30, 30,
    30, 30, 30, 30, 15, 30, 15, 30,
    15, 30, 15, 15, 15, 15, 30, 16,
    15, 15, 30, 15, 16, 19, 19, 19,
    19, 16, 30, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    27, 27, 27, 27, 27, 30, 30, 30,
    30, 30, 27, 27, 30, 30, 30, 30,
    27, 30, 30, 27, 30, 30, 27, 30,
    30, 30, 30, 30, 30, 30, 27, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 27, 27,
    30, 30, 27, 30, 27, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_22[] = {
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_23[] = {
    30, 30, 30, 30, 30, 30, 30, 30,
    27, 27, 27, 27, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    27, 27, 30, 30, 30, 30, 30, 30,
    30, 22, 23, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 0, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_24[] = {
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 6, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_25[] = {
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 27,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 27, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_26[] = {
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 0, 0, 0, 0,
    0, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 27,
    30, 30, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_27[] = {
    0, 30, 30, 30, 30, 0, 30, 30,
    30, 30, 0, 0, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    0, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 0, 30, 0, 30,
    30, 30, 30, 0, 0, 0, 30, 0,
    30, 30, 30, 30, 30, 30, 30, 0,
    0, 30, 30, 30, 30, 30, 30, 30,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 30, 0, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    0, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_28[] = {
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
};

static const Q_UINT8 ui_2E[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 0, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_2F[] = {
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 0, 0, 0, 0,
};

static const Q_UINT8 ui_30[] = {
    7, 26, 26, 26, 30, 18, 19, 5,
    22, 23, 22, 23, 22, 23, 22, 23,
    22, 23, 30, 30, 22, 23, 22, 23,
    22, 23, 22, 23, 21, 22, 23, 23,
    30, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 1, 1, 1, 1, 1, 1,
    21, 18, 18, 18, 18, 18, 30, 30,
    5, 5, 5, 0, 0, 0, 30, 30,
    0, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 0, 0,
    0, 1, 1, 29, 29, 18, 18, 0,
    0, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 20, 18, 18, 18, 0,
};

static const Q_UINT8 ui_31[] = {
    0, 0, 0, 0, 0, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 0, 0,
    0, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    30, 30, 6, 6, 6, 6, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_32[] = {
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 0, 0, 0,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 0, 0, 0, 30,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 0, 0, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 0,
};

static const Q_UINT8 ui_33[] = {
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 0,
    0, 0, 0, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 0,
};

static const Q_UINT8 ui_34[] = {
    19, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_4D[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 19, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_9F[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 19, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_A4[] = {
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 0, 0, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 0, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 0, 30, 30, 30, 0, 30, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_D7[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 19, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_D8[] = {
    12, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_DB[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12,
    12, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12,
};

static const Q_UINT8 ui_DF[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12,
};

static const Q_UINT8 ui_E0[] = {
    13, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_F8[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 13,
};

static const Q_UINT8 ui_FA[] = {
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_FB[] = {
    16, 16, 16, 16, 16, 16, 16, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 16, 16, 16, 16, 16,
    0, 0, 0, 0, 0, 19, 1, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 27, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 19, 19, 19, 19, 0, 19, 0,
    19, 19, 0, 19, 19, 0, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
};

static const Q_UINT8 ui_FD[] = {
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 22, 23,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    0, 0, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 0, 0, 0, 0,
};

static const Q_UINT8 ui_FE[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    26, 21, 21, 20, 20, 22, 23, 22,
    23, 22, 23, 22, 23, 22, 23, 22,
    23, 22, 23, 22, 23, 0, 0, 0,
    0, 26, 26, 26, 26, 20, 20, 20,
    26, 26, 26, 0, 26, 26, 26, 26,
    21, 22, 23, 22, 23, 22, 23, 26,
    26, 26, 27, 21, 27, 27, 27, 0,
    26, 28, 26, 26, 0, 0, 0, 0,
    19, 19, 19, 0, 19, 0, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 0, 11,
};

static const Q_UINT8 ui_FF[] = {
    0, 26, 26, 26, 28, 26, 26, 26,
    22, 23, 26, 27, 26, 21, 26, 26,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 26, 26, 27, 27, 27, 26,
    26, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 22, 26, 23, 29, 20,
    29, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 22, 27, 23, 27, 0,
    0, 26, 22, 23, 26, 20, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    18, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 18, 18,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    0, 0, 19, 19, 19, 19, 19, 19,
    0, 0, 19, 19, 19, 19, 19, 19,
    0, 0, 19, 19, 19, 19, 19, 19,
    0, 0, 19, 19, 19, 0, 0, 0,
    28, 28, 27, 29, 30, 28, 28, 0,
    30, 27, 27, 27, 27, 30, 30, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 11, 11, 11, 30, 30, 0, 0,
};

static const Q_UINT8 * const unicode_info[256] = {
    ui_00, ui_01, ui_02, ui_03, ui_04, ui_05, ui_06, ui_07,
    ui_08, ui_09, ui_0A, ui_0B, ui_0C, ui_0D, ui_0E, ui_0F,
    ui_10, ui_11, ui_12, ui_13, ui_14, ui_15, ui_16, ui_17,
    ui_18, ui_08, ui_08, ui_08, ui_08, ui_08, ui_1E, ui_1F,
    ui_20, ui_21, ui_22, ui_23, ui_24, ui_25, ui_26, ui_27,
    ui_28, ui_08, ui_08, ui_08, ui_08, ui_08, ui_2E, ui_2F,
    ui_30, ui_31, ui_32, ui_33, ui_34, ui_08, ui_08, ui_08,
    ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08,
    ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08,
    ui_08, ui_08, ui_08, ui_08, ui_08, ui_4D, ui_34, ui_08,
    ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08,
    ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08,
    ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08,
    ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08,
    ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08,
    ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08,
    ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08,
    ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08,
    ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08,
    ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_9F,
    ui_15, ui_15, ui_15, ui_15, ui_A4, ui_08, ui_08, ui_08,
    ui_08, ui_08, ui_08, ui_08, ui_34, ui_08, ui_08, ui_08,
    ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08,
    ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08,
    ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08,
    ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08,
    ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_D7,
    ui_D8, ui_08, ui_08, ui_DB, ui_D8, ui_08, ui_08, ui_DF,
    ui_E0, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08,
    ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08,
    ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08, ui_08,
    ui_F8, ui_15, ui_FA, ui_FB, ui_15, ui_FD, ui_FE, ui_FF,
};
// 15616 bytes

static const Q_UINT16 decomposition_map [] = {
    0,
    3, 0x00A0, 0x0020, 0,
    16, 0x00A8, 0x0020, 0x0308, 0,
    9, 0x00AA, 0x0061, 0,
    16, 0x00AF, 0x0020, 0x0304, 0,
    9, 0x00B2, 0x0032, 0,
    9, 0x00B3, 0x0033, 0,
    16, 0x00B4, 0x0020, 0x0301, 0,
    16, 0x00B5, 0x03BC, 0,
    16, 0x00B8, 0x0020, 0x0327, 0,
    9, 0x00B9, 0x0031, 0,
    9, 0x00BA, 0x006F, 0,
    17, 0x00BC, 0x0031, 0x2044, 0x0034, 0,
    17, 0x00BD, 0x0031, 0x2044, 0x0032, 0,
    17, 0x00BE, 0x0033, 0x2044, 0x0034, 0,
    1, 0x00C0, 0x0041, 0x0300, 0,
    1, 0x00C1, 0x0041, 0x0301, 0,
    1, 0x00C2, 0x0041, 0x0302, 0,
    1, 0x00C3, 0x0041, 0x0303, 0,
    1, 0x00C4, 0x0041, 0x0308, 0,
    1, 0x00C5, 0x0041, 0x030A, 0,
    1, 0x00C7, 0x0043, 0x0327, 0,
    1, 0x00C8, 0x0045, 0x0300, 0,
    1, 0x00C9, 0x0045, 0x0301, 0,
    1, 0x00CA, 0x0045, 0x0302, 0,
    1, 0x00CB, 0x0045, 0x0308, 0,
    1, 0x00CC, 0x0049, 0x0300, 0,
    1, 0x00CD, 0x0049, 0x0301, 0,
    1, 0x00CE, 0x0049, 0x0302, 0,
    1, 0x00CF, 0x0049, 0x0308, 0,
    1, 0x00D1, 0x004E, 0x0303, 0,
    1, 0x00D2, 0x004F, 0x0300, 0,
    1, 0x00D3, 0x004F, 0x0301, 0,
    1, 0x00D4, 0x004F, 0x0302, 0,
    1, 0x00D5, 0x004F, 0x0303, 0,
    1, 0x00D6, 0x004F, 0x0308, 0,
    1, 0x00D9, 0x0055, 0x0300, 0,
    1, 0x00DA, 0x0055, 0x0301, 0,
    1, 0x00DB, 0x0055, 0x0302, 0,
    1, 0x00DC, 0x0055, 0x0308, 0,
    1, 0x00DD, 0x0059, 0x0301, 0,
    1, 0x00E0, 0x0061, 0x0300, 0,
    1, 0x00E1, 0x0061, 0x0301, 0,
    1, 0x00E2, 0x0061, 0x0302, 0,
    1, 0x00E3, 0x0061, 0x0303, 0,
    1, 0x00E4, 0x0061, 0x0308, 0,
    1, 0x00E5, 0x0061, 0x030A, 0,
    1, 0x00E7, 0x0063, 0x0327, 0,
    1, 0x00E8, 0x0065, 0x0300, 0,
    1, 0x00E9, 0x0065, 0x0301, 0,
    1, 0x00EA, 0x0065, 0x0302, 0,
    1, 0x00EB, 0x0065, 0x0308, 0,
    1, 0x00EC, 0x0069, 0x0300, 0,
    1, 0x00ED, 0x0069, 0x0301, 0,
    1, 0x00EE, 0x0069, 0x0302, 0,
    1, 0x00EF, 0x0069, 0x0308, 0,
    1, 0x00F1, 0x006E, 0x0303, 0,
    1, 0x00F2, 0x006F, 0x0300, 0,
    1, 0x00F3, 0x006F, 0x0301, 0,
    1, 0x00F4, 0x006F, 0x0302, 0,
    1, 0x00F5, 0x006F, 0x0303, 0,
    1, 0x00F6, 0x006F, 0x0308, 0,
    1, 0x00F9, 0x0075, 0x0300, 0,
    1, 0x00FA, 0x0075, 0x0301, 0,
    1, 0x00FB, 0x0075, 0x0302, 0,
    1, 0x00FC, 0x0075, 0x0308, 0,
    1, 0x00FD, 0x0079, 0x0301, 0,
    1, 0x00FF, 0x0079, 0x0308, 0,
    1, 0x0100, 0x0041, 0x0304, 0,
    1, 0x0101, 0x0061, 0x0304, 0,
    1, 0x0102, 0x0041, 0x0306, 0,
    1, 0x0103, 0x0061, 0x0306, 0,
    1, 0x0104, 0x0041, 0x0328, 0,
    1, 0x0105, 0x0061, 0x0328, 0,
    1, 0x0106, 0x0043, 0x0301, 0,
    1, 0x0107, 0x0063, 0x0301, 0,
    1, 0x0108, 0x0043, 0x0302, 0,
    1, 0x0109, 0x0063, 0x0302, 0,
    1, 0x010A, 0x0043, 0x0307, 0,
    1, 0x010B, 0x0063, 0x0307, 0,
    1, 0x010C, 0x0043, 0x030C, 0,
    1, 0x010D, 0x0063, 0x030C, 0,
    1, 0x010E, 0x0044, 0x030C, 0,
    1, 0x010F, 0x0064, 0x030C, 0,
    1, 0x0112, 0x0045, 0x0304, 0,
    1, 0x0113, 0x0065, 0x0304, 0,
    1, 0x0114, 0x0045, 0x0306, 0,
    1, 0x0115, 0x0065, 0x0306, 0,
    1, 0x0116, 0x0045, 0x0307, 0,
    1, 0x0117, 0x0065, 0x0307, 0,
    1, 0x0118, 0x0045, 0x0328, 0,
    1, 0x0119, 0x0065, 0x0328, 0,
    1, 0x011A, 0x0045, 0x030C, 0,
    1, 0x011B, 0x0065, 0x030C, 0,
    1, 0x011C, 0x0047, 0x0302, 0,
    1, 0x011D, 0x0067, 0x0302, 0,
    1, 0x011E, 0x0047, 0x0306, 0,
    1, 0x011F, 0x0067, 0x0306, 0,
    1, 0x0120, 0x0047, 0x0307, 0,
    1, 0x0121, 0x0067, 0x0307, 0,
    1, 0x0122, 0x0047, 0x0327, 0,
    1, 0x0123, 0x0067, 0x0327, 0,
    1, 0x0124, 0x0048, 0x0302, 0,
    1, 0x0125, 0x0068, 0x0302, 0,
    1, 0x0128, 0x0049, 0x0303, 0,
    1, 0x0129, 0x0069, 0x0303, 0,
    1, 0x012A, 0x0049, 0x0304, 0,
    1, 0x012B, 0x0069, 0x0304, 0,
    1, 0x012C, 0x0049, 0x0306, 0,
    1, 0x012D, 0x0069, 0x0306, 0,
    1, 0x012E, 0x0049, 0x0328, 0,
    1, 0x012F, 0x0069, 0x0328, 0,
    1, 0x0130, 0x0049, 0x0307, 0,
    16, 0x0132, 0x0049, 0x004A, 0,
    16, 0x0133, 0x0069, 0x006A, 0,
    1, 0x0134, 0x004A, 0x0302, 0,
    1, 0x0135, 0x006A, 0x0302, 0,
    1, 0x0136, 0x004B, 0x0327, 0,
    1, 0x0137, 0x006B, 0x0327, 0,
    1, 0x0139, 0x004C, 0x0301, 0,
    1, 0x013A, 0x006C, 0x0301, 0,
    1, 0x013B, 0x004C, 0x0327, 0,
    1, 0x013C, 0x006C, 0x0327, 0,
    1, 0x013D, 0x004C, 0x030C, 0,
    1, 0x013E, 0x006C, 0x030C, 0,
    16, 0x013F, 0x004C, 0x00B7, 0,
    16, 0x0140, 0x006C, 0x00B7, 0,
    1, 0x0143, 0x004E, 0x0301, 0,
    1, 0x0144, 0x006E, 0x0301, 0,
    1, 0x0145, 0x004E, 0x0327, 0,
    1, 0x0146, 0x006E, 0x0327, 0,
    1, 0x0147, 0x004E, 0x030C, 0,
    1, 0x0148, 0x006E, 0x030C, 0,
    16, 0x0149, 0x02BC, 0x006E, 0,
    1, 0x014C, 0x004F, 0x0304, 0,
    1, 0x014D, 0x006F, 0x0304, 0,
    1, 0x014E, 0x004F, 0x0306, 0,
    1, 0x014F, 0x006F, 0x0306, 0,
    1, 0x0150, 0x004F, 0x030B, 0,
    1, 0x0151, 0x006F, 0x030B, 0,
    1, 0x0154, 0x0052, 0x0301, 0,
    1, 0x0155, 0x0072, 0x0301, 0,
    1, 0x0156, 0x0052, 0x0327, 0,
    1, 0x0157, 0x0072, 0x0327, 0,
    1, 0x0158, 0x0052, 0x030C, 0,
    1, 0x0159, 0x0072, 0x030C, 0,
    1, 0x015A, 0x0053, 0x0301, 0,
    1, 0x015B, 0x0073, 0x0301, 0,
    1, 0x015C, 0x0053, 0x0302, 0,
    1, 0x015D, 0x0073, 0x0302, 0,
    1, 0x015E, 0x0053, 0x0327, 0,
    1, 0x015F, 0x0073, 0x0327, 0,
    1, 0x0160, 0x0053, 0x030C, 0,
    1, 0x0161, 0x0073, 0x030C, 0,
    1, 0x0162, 0x0054, 0x0327, 0,
    1, 0x0163, 0x0074, 0x0327, 0,
    1, 0x0164, 0x0054, 0x030C, 0,
    1, 0x0165, 0x0074, 0x030C, 0,
    1, 0x0168, 0x0055, 0x0303, 0,
    1, 0x0169, 0x0075, 0x0303, 0,
    1, 0x016A, 0x0055, 0x0304, 0,
    1, 0x016B, 0x0075, 0x0304, 0,
    1, 0x016C, 0x0055, 0x0306, 0,
    1, 0x016D, 0x0075, 0x0306, 0,
    1, 0x016E, 0x0055, 0x030A, 0,
    1, 0x016F, 0x0075, 0x030A, 0,
    1, 0x0170, 0x0055, 0x030B, 0,
    1, 0x0171, 0x0075, 0x030B, 0,
    1, 0x0172, 0x0055, 0x0328, 0,
    1, 0x0173, 0x0075, 0x0328, 0,
    1, 0x0174, 0x0057, 0x0302, 0,
    1, 0x0175, 0x0077, 0x0302, 0,
    1, 0x0176, 0x0059, 0x0302, 0,
    1, 0x0177, 0x0079, 0x0302, 0,
    1, 0x0178, 0x0059, 0x0308, 0,
    1, 0x0179, 0x005A, 0x0301, 0,
    1, 0x017A, 0x007A, 0x0301, 0,
    1, 0x017B, 0x005A, 0x0307, 0,
    1, 0x017C, 0x007A, 0x0307, 0,
    1, 0x017D, 0x005A, 0x030C, 0,
    1, 0x017E, 0x007A, 0x030C, 0,
    16, 0x017F, 0x0073, 0,
    1, 0x01A0, 0x004F, 0x031B, 0,
    1, 0x01A1, 0x006F, 0x031B, 0,
    1, 0x01AF, 0x0055, 0x031B, 0,
    1, 0x01B0, 0x0075, 0x031B, 0,
    16, 0x01C4, 0x0044, 0x017D, 0,
    16, 0x01C5, 0x0044, 0x017E, 0,
    16, 0x01C6, 0x0064, 0x017E, 0,
    16, 0x01C7, 0x004C, 0x004A, 0,
    16, 0x01C8, 0x004C, 0x006A, 0,
    16, 0x01C9, 0x006C, 0x006A, 0,
    16, 0x01CA, 0x004E, 0x004A, 0,
    16, 0x01CB, 0x004E, 0x006A, 0,
    16, 0x01CC, 0x006E, 0x006A, 0,
    1, 0x01CD, 0x0041, 0x030C, 0,
    1, 0x01CE, 0x0061, 0x030C, 0,
    1, 0x01CF, 0x0049, 0x030C, 0,
    1, 0x01D0, 0x0069, 0x030C, 0,
    1, 0x01D1, 0x004F, 0x030C, 0,
    1, 0x01D2, 0x006F, 0x030C, 0,
    1, 0x01D3, 0x0055, 0x030C, 0,
    1, 0x01D4, 0x0075, 0x030C, 0,
    1, 0x01D5, 0x00DC, 0x0304, 0,
    1, 0x01D6, 0x00FC, 0x0304, 0,
    1, 0x01D7, 0x00DC, 0x0301, 0,
    1, 0x01D8, 0x00FC, 0x0301, 0,
    1, 0x01D9, 0x00DC, 0x030C, 0,
    1, 0x01DA, 0x00FC, 0x030C, 0,
    1, 0x01DB, 0x00DC, 0x0300, 0,
    1, 0x01DC, 0x00FC, 0x0300, 0,
    1, 0x01DE, 0x00C4, 0x0304, 0,
    1, 0x01DF, 0x00E4, 0x0304, 0,
    1, 0x01E0, 0x0226, 0x0304, 0,
    1, 0x01E1, 0x0227, 0x0304, 0,
    1, 0x01E2, 0x00C6, 0x0304, 0,
    1, 0x01E3, 0x00E6, 0x0304, 0,
    1, 0x01E6, 0x0047, 0x030C, 0,
    1, 0x01E7, 0x0067, 0x030C, 0,
    1, 0x01E8, 0x004B, 0x030C, 0,
    1, 0x01E9, 0x006B, 0x030C, 0,
    1, 0x01EA, 0x004F, 0x0328, 0,
    1, 0x01EB, 0x006F, 0x0328, 0,
    1, 0x01EC, 0x01EA, 0x0304, 0,
    1, 0x01ED, 0x01EB, 0x0304, 0,
    1, 0x01EE, 0x01B7, 0x030C, 0,
    1, 0x01EF, 0x0292, 0x030C, 0,
    1, 0x01F0, 0x006A, 0x030C, 0,
    16, 0x01F1, 0x0044, 0x005A, 0,
    16, 0x01F2, 0x0044, 0x007A, 0,
    16, 0x01F3, 0x0064, 0x007A, 0,
    1, 0x01F4, 0x0047, 0x0301, 0,
    1, 0x01F5, 0x0067, 0x0301, 0,
    1, 0x01F8, 0x004E, 0x0300, 0,
    1, 0x01F9, 0x006E, 0x0300, 0,
    1, 0x01FA, 0x00C5, 0x0301, 0,
    1, 0x01FB, 0x00E5, 0x0301, 0,
    1, 0x01FC, 0x00C6, 0x0301, 0,
    1, 0x01FD, 0x00E6, 0x0301, 0,
    1, 0x01FE, 0x00D8, 0x0301, 0,
    1, 0x01FF, 0x00F8, 0x0301, 0,
    1, 0x0200, 0x0041, 0x030F, 0,
    1, 0x0201, 0x0061, 0x030F, 0,
    1, 0x0202, 0x0041, 0x0311, 0,
    1, 0x0203, 0x0061, 0x0311, 0,
    1, 0x0204, 0x0045, 0x030F, 0,
    1, 0x0205, 0x0065, 0x030F, 0,
    1, 0x0206, 0x0045, 0x0311, 0,
    1, 0x0207, 0x0065, 0x0311, 0,
    1, 0x0208, 0x0049, 0x030F, 0,
    1, 0x0209, 0x0069, 0x030F, 0,
    1, 0x020A, 0x0049, 0x0311, 0,
    1, 0x020B, 0x0069, 0x0311, 0,
    1, 0x020C, 0x004F, 0x030F, 0,
    1, 0x020D, 0x006F, 0x030F, 0,
    1, 0x020E, 0x004F, 0x0311, 0,
    1, 0x020F, 0x006F, 0x0311, 0,
    1, 0x0210, 0x0052, 0x030F, 0,
    1, 0x0211, 0x0072, 0x030F, 0,
    1, 0x0212, 0x0052, 0x0311, 0,
    1, 0x0213, 0x0072, 0x0311, 0,
    1, 0x0214, 0x0055, 0x030F, 0,
    1, 0x0215, 0x0075, 0x030F, 0,
    1, 0x0216, 0x0055, 0x0311, 0,
    1, 0x0217, 0x0075, 0x0311, 0,
    1, 0x0218, 0x0053, 0x0326, 0,
    1, 0x0219, 0x0073, 0x0326, 0,
    1, 0x021A, 0x0054, 0x0326, 0,
    1, 0x021B, 0x0074, 0x0326, 0,
    1, 0x021E, 0x0048, 0x030C, 0,
    1, 0x021F, 0x0068, 0x030C, 0,
    1, 0x0226, 0x0041, 0x0307, 0,
    1, 0x0227, 0x0061, 0x0307, 0,
    1, 0x0228, 0x0045, 0x0327, 0,
    1, 0x0229, 0x0065, 0x0327, 0,
    1, 0x022A, 0x00D6, 0x0304, 0,
    1, 0x022B, 0x00F6, 0x0304, 0,
    1, 0x022C, 0x00D5, 0x0304, 0,
    1, 0x022D, 0x00F5, 0x0304, 0,
    1, 0x022E, 0x004F, 0x0307, 0,
    1, 0x022F, 0x006F, 0x0307, 0,
    1, 0x0230, 0x022E, 0x0304, 0,
    1, 0x0231, 0x022F, 0x0304, 0,
    1, 0x0232, 0x0059, 0x0304, 0,
    1, 0x0233, 0x0079, 0x0304, 0,
    9, 0x02B0, 0x0068, 0,
    9, 0x02B1, 0x0266, 0,
    9, 0x02B2, 0x006A, 0,
    9, 0x02B3, 0x0072, 0,
    9, 0x02B4, 0x0279, 0,
    9, 0x02B5, 0x027B, 0,
    9, 0x02B6, 0x0281, 0,
    9, 0x02B7, 0x0077, 0,
    9, 0x02B8, 0x0079, 0,
    16, 0x02D8, 0x0020, 0x0306, 0,
    16, 0x02D9, 0x0020, 0x0307, 0,
    16, 0x02DA, 0x0020, 0x030A, 0,
    16, 0x02DB, 0x0020, 0x0328, 0,
    16, 0x02DC, 0x0020, 0x0303, 0,
    16, 0x02DD, 0x0020, 0x030B, 0,
    9, 0x02E0, 0x0263, 0,
    9, 0x02E1, 0x006C, 0,
    9, 0x02E2, 0x0073, 0,
    9, 0x02E3, 0x0078, 0,
    9, 0x02E4, 0x0295, 0,
    1, 0x0340, 0x0300, 0,
    1, 0x0341, 0x0301, 0,
    1, 0x0343, 0x0313, 0,
    1, 0x0344, 0x0308, 0x0301, 0,
    1, 0x0374, 0x02B9, 0,
    16, 0x037A, 0x0020, 0x0345, 0,
    1, 0x037E, 0x003B, 0,
    16, 0x0384, 0x0020, 0x0301, 0,
    1, 0x0385, 0x00A8, 0x0301, 0,
    1, 0x0386, 0x0391, 0x0301, 0,
    1, 0x0387, 0x00B7, 0,
    1, 0x0388, 0x0395, 0x0301, 0,
    1, 0x0389, 0x0397, 0x0301, 0,
    1, 0x038A, 0x0399, 0x0301, 0,
    1, 0x038C, 0x039F, 0x0301, 0,
    1, 0x038E, 0x03A5, 0x0301, 0,
    1, 0x038F, 0x03A9, 0x0301, 0,
    1, 0x0390, 0x03CA, 0x0301, 0,
    1, 0x03AA, 0x0399, 0x0308, 0,
    1, 0x03AB, 0x03A5, 0x0308, 0,
    1, 0x03AC, 0x03B1, 0x0301, 0,
    1, 0x03AD, 0x03B5, 0x0301, 0,
    1, 0x03AE, 0x03B7, 0x0301, 0,
    1, 0x03AF, 0x03B9, 0x0301, 0,
    1, 0x03B0, 0x03CB, 0x0301, 0,
    1, 0x03CA, 0x03B9, 0x0308, 0,
    1, 0x03CB, 0x03C5, 0x0308, 0,
    1, 0x03CC, 0x03BF, 0x0301, 0,
    1, 0x03CD, 0x03C5, 0x0301, 0,
    1, 0x03CE, 0x03C9, 0x0301, 0,
    16, 0x03D0, 0x03B2, 0,
    16, 0x03D1, 0x03B8, 0,
    16, 0x03D2, 0x03A5, 0,
    1, 0x03D3, 0x03D2, 0x0301, 0,
    1, 0x03D4, 0x03D2, 0x0308, 0,
    16, 0x03D5, 0x03C6, 0,
    16, 0x03D6, 0x03C0, 0,
    16, 0x03F0, 0x03BA, 0,
    16, 0x03F1, 0x03C1, 0,
    16, 0x03F2, 0x03C2, 0,
    1, 0x0400, 0x0415, 0x0300, 0,
    1, 0x0401, 0x0415, 0x0308, 0,
    1, 0x0403, 0x0413, 0x0301, 0,
    1, 0x0407, 0x0406, 0x0308, 0,
    1, 0x040C, 0x041A, 0x0301, 0,
    1, 0x040D, 0x0418, 0x0300, 0,
    1, 0x040E, 0x0423, 0x0306, 0,
    1, 0x0419, 0x0418, 0x0306, 0,
    1, 0x0439, 0x0438, 0x0306, 0,
    1, 0x0450, 0x0435, 0x0300, 0,
    1, 0x0451, 0x0435, 0x0308, 0,
    1, 0x0453, 0x0433, 0x0301, 0,
    1, 0x0457, 0x0456, 0x0308, 0,
    1, 0x045C, 0x043A, 0x0301, 0,
    1, 0x045D, 0x0438, 0x0300, 0,
    1, 0x045E, 0x0443, 0x0306, 0,
    1, 0x0476, 0x0474, 0x030F, 0,
    1, 0x0477, 0x0475, 0x030F, 0,
    1, 0x04C1, 0x0416, 0x0306, 0,
    1, 0x04C2, 0x0436, 0x0306, 0,
    1, 0x04D0, 0x0410, 0x0306, 0,
    1, 0x04D1, 0x0430, 0x0306, 0,
    1, 0x04D2, 0x0410, 0x0308, 0,
    1, 0x04D3, 0x0430, 0x0308, 0,
    1, 0x04D6, 0x0415, 0x0306, 0,
    1, 0x04D7, 0x0435, 0x0306, 0,
    1, 0x04DA, 0x04D8, 0x0308, 0,
    1, 0x04DB, 0x04D9, 0x0308, 0,
    1, 0x04DC, 0x0416, 0x0308, 0,
    1, 0x04DD, 0x0436, 0x0308, 0,
    1, 0x04DE, 0x0417, 0x0308, 0,
    1, 0x04DF, 0x0437, 0x0308, 0,
    1, 0x04E2, 0x0418, 0x0304, 0,
    1, 0x04E3, 0x0438, 0x0304, 0,
    1, 0x04E4, 0x0418, 0x0308, 0,
    1, 0x04E5, 0x0438, 0x0308, 0,
    1, 0x04E6, 0x041E, 0x0308, 0,
    1, 0x04E7, 0x043E, 0x0308, 0,
    1, 0x04EA, 0x04E8, 0x0308, 0,
    1, 0x04EB, 0x04E9, 0x0308, 0,
    1, 0x04EC, 0x042D, 0x0308, 0,
    1, 0x04ED, 0x044D, 0x0308, 0,
    1, 0x04EE, 0x0423, 0x0304, 0,
    1, 0x04EF, 0x0443, 0x0304, 0,
    1, 0x04F0, 0x0423, 0x0308, 0,
    1, 0x04F1, 0x0443, 0x0308, 0,
    1, 0x04F2, 0x0423, 0x030B, 0,
    1, 0x04F3, 0x0443, 0x030B, 0,
    1, 0x04F4, 0x0427, 0x0308, 0,
    1, 0x04F5, 0x0447, 0x0308, 0,
    1, 0x04F8, 0x042B, 0x0308, 0,
    1, 0x04F9, 0x044B, 0x0308, 0,
    16, 0x0587, 0x0565, 0x0582, 0,
    1, 0x0622, 0x0627, 0x0653, 0,
    1, 0x0623, 0x0627, 0x0654, 0,
    1, 0x0624, 0x0648, 0x0654, 0,
    1, 0x0625, 0x0627, 0x0655, 0,
    1, 0x0626, 0x064A, 0x0654, 0,
    16, 0x0675, 0x0627, 0x0674, 0,
    16, 0x0676, 0x0648, 0x0674, 0,
    16, 0x0677, 0x06C7, 0x0674, 0,
    16, 0x0678, 0x064A, 0x0674, 0,
    1, 0x06C0, 0x06D5, 0x0654, 0,
    1, 0x06C2, 0x06C1, 0x0654, 0,
    1, 0x06D3, 0x06D2, 0x0654, 0,
    1, 0x0929, 0x0928, 0x093C, 0,
    1, 0x0931, 0x0930, 0x093C, 0,
    1, 0x0934, 0x0933, 0x093C, 0,
    1, 0x0958, 0x0915, 0x093C, 0,
    1, 0x0959, 0x0916, 0x093C, 0,
    1, 0x095A, 0x0917, 0x093C, 0,
    1, 0x095B, 0x091C, 0x093C, 0,
    1, 0x095C, 0x0921, 0x093C, 0,
    1, 0x095D, 0x0922, 0x093C, 0,
    1, 0x095E, 0x092B, 0x093C, 0,
    1, 0x095F, 0x092F, 0x093C, 0,
    1, 0x09CB, 0x09C7, 0x09BE, 0,
    1, 0x09CC, 0x09C7, 0x09D7, 0,
    1, 0x09DC, 0x09A1, 0x09BC, 0,
    1, 0x09DD, 0x09A2, 0x09BC, 0,
    1, 0x09DF, 0x09AF, 0x09BC, 0,
    1, 0x0A33, 0x0A32, 0x0A3C, 0,
    1, 0x0A36, 0x0A38, 0x0A3C, 0,
    1, 0x0A59, 0x0A16, 0x0A3C, 0,
    1, 0x0A5A, 0x0A17, 0x0A3C, 0,
    1, 0x0A5B, 0x0A1C, 0x0A3C, 0,
    1, 0x0A5E, 0x0A2B, 0x0A3C, 0,
    1, 0x0B48, 0x0B47, 0x0B56, 0,
    1, 0x0B4B, 0x0B47, 0x0B3E, 0,
    1, 0x0B4C, 0x0B47, 0x0B57, 0,
    1, 0x0B5C, 0x0B21, 0x0B3C, 0,
    1, 0x0B5D, 0x0B22, 0x0B3C, 0,
    1, 0x0B94, 0x0B92, 0x0BD7, 0,
    1, 0x0BCA, 0x0BC6, 0x0BBE, 0,
    1, 0x0BCB, 0x0BC7, 0x0BBE, 0,
    1, 0x0BCC, 0x0BC6, 0x0BD7, 0,
    1, 0x0C48, 0x0C46, 0x0C56, 0,
    1, 0x0CC0, 0x0CBF, 0x0CD5, 0,
    1, 0x0CC7, 0x0CC6, 0x0CD5, 0,
    1, 0x0CC8, 0x0CC6, 0x0CD6, 0,
    1, 0x0CCA, 0x0CC6, 0x0CC2, 0,
    1, 0x0CCB, 0x0CCA, 0x0CD5, 0,
    1, 0x0D4A, 0x0D46, 0x0D3E, 0,
    1, 0x0D4B, 0x0D47, 0x0D3E, 0,
    1, 0x0D4C, 0x0D46, 0x0D57, 0,
    1, 0x0DDA, 0x0DD9, 0x0DCA, 0,
    1, 0x0DDC, 0x0DD9, 0x0DCF, 0,
    1, 0x0DDD, 0x0DDC, 0x0DCA, 0,
    1, 0x0DDE, 0x0DD9, 0x0DDF, 0,
    16, 0x0E33, 0x0E4D, 0x0E32, 0,
    16, 0x0EB3, 0x0ECD, 0x0EB2, 0,
    16, 0x0EDC, 0x0EAB, 0x0E99, 0,
    16, 0x0EDD, 0x0EAB, 0x0EA1, 0,
    3, 0x0F0C, 0x0F0B, 0,
    1, 0x0F43, 0x0F42, 0x0FB7, 0,
    1, 0x0F4D, 0x0F4C, 0x0FB7, 0,
    1, 0x0F52, 0x0F51, 0x0FB7, 0,
    1, 0x0F57, 0x0F56, 0x0FB7, 0,
    1, 0x0F5C, 0x0F5B, 0x0FB7, 0,
    1, 0x0F69, 0x0F40, 0x0FB5, 0,
    1, 0x0F73, 0x0F71, 0x0F72, 0,
    1, 0x0F75, 0x0F71, 0x0F74, 0,
    1, 0x0F76, 0x0FB2, 0x0F80, 0,
    16, 0x0F77, 0x0FB2, 0x0F81, 0,
    1, 0x0F78, 0x0FB3, 0x0F80, 0,
    16, 0x0F79, 0x0FB3, 0x0F81, 0,
    1, 0x0F81, 0x0F71, 0x0F80, 0,
    1, 0x0F93, 0x0F92, 0x0FB7, 0,
    1, 0x0F9D, 0x0F9C, 0x0FB7, 0,
    1, 0x0FA2, 0x0FA1, 0x0FB7, 0,
    1, 0x0FA7, 0x0FA6, 0x0FB7, 0,
    1, 0x0FAC, 0x0FAB, 0x0FB7, 0,
    1, 0x0FB9, 0x0F90, 0x0FB5, 0,
    1, 0x1026, 0x1025, 0x102E, 0,
    1, 0x1E00, 0x0041, 0x0325, 0,
    1, 0x1E01, 0x0061, 0x0325, 0,
    1, 0x1E02, 0x0042, 0x0307, 0,
    1, 0x1E03, 0x0062, 0x0307, 0,
    1, 0x1E04, 0x0042, 0x0323, 0,
    1, 0x1E05, 0x0062, 0x0323, 0,
    1, 0x1E06, 0x0042, 0x0331, 0,
    1, 0x1E07, 0x0062, 0x0331, 0,
    1, 0x1E08, 0x00C7, 0x0301, 0,
    1, 0x1E09, 0x00E7, 0x0301, 0,
    1, 0x1E0A, 0x0044, 0x0307, 0,
    1, 0x1E0B, 0x0064, 0x0307, 0,
    1, 0x1E0C, 0x0044, 0x0323, 0,
    1, 0x1E0D, 0x0064, 0x0323, 0,
    1, 0x1E0E, 0x0044, 0x0331, 0,
    1, 0x1E0F, 0x0064, 0x0331, 0,
    1, 0x1E10, 0x0044, 0x0327, 0,
    1, 0x1E11, 0x0064, 0x0327, 0,
    1, 0x1E12, 0x0044, 0x032D, 0,
    1, 0x1E13, 0x0064, 0x032D, 0,
    1, 0x1E14, 0x0112, 0x0300, 0,
    1, 0x1E15, 0x0113, 0x0300, 0,
    1, 0x1E16, 0x0112, 0x0301, 0,
    1, 0x1E17, 0x0113, 0x0301, 0,
    1, 0x1E18, 0x0045, 0x032D, 0,
    1, 0x1E19, 0x0065, 0x032D, 0,
    1, 0x1E1A, 0x0045, 0x0330, 0,
    1, 0x1E1B, 0x0065, 0x0330, 0,
    1, 0x1E1C, 0x0228, 0x0306, 0,
    1, 0x1E1D, 0x0229, 0x0306, 0,
    1, 0x1E1E, 0x0046, 0x0307, 0,
    1, 0x1E1F, 0x0066, 0x0307, 0,
    1, 0x1E20, 0x0047, 0x0304, 0,
    1, 0x1E21, 0x0067, 0x0304, 0,
    1, 0x1E22, 0x0048, 0x0307, 0,
    1, 0x1E23, 0x0068, 0x0307, 0,
    1, 0x1E24, 0x0048, 0x0323, 0,
    1, 0x1E25, 0x0068, 0x0323, 0,
    1, 0x1E26, 0x0048, 0x0308, 0,
    1, 0x1E27, 0x0068, 0x0308, 0,
    1, 0x1E28, 0x0048, 0x0327, 0,
    1, 0x1E29, 0x0068, 0x0327, 0,
    1, 0x1E2A, 0x0048, 0x032E, 0,
    1, 0x1E2B, 0x0068, 0x032E, 0,
    1, 0x1E2C, 0x0049, 0x0330, 0,
    1, 0x1E2D, 0x0069, 0x0330, 0,
    1, 0x1E2E, 0x00CF, 0x0301, 0,
    1, 0x1E2F, 0x00EF, 0x0301, 0,
    1, 0x1E30, 0x004B, 0x0301, 0,
    1, 0x1E31, 0x006B, 0x0301, 0,
    1, 0x1E32, 0x004B, 0x0323, 0,
    1, 0x1E33, 0x006B, 0x0323, 0,
    1, 0x1E34, 0x004B, 0x0331, 0,
    1, 0x1E35, 0x006B, 0x0331, 0,
    1, 0x1E36, 0x004C, 0x0323, 0,
    1, 0x1E37, 0x006C, 0x0323, 0,
    1, 0x1E38, 0x1E36, 0x0304, 0,
    1, 0x1E39, 0x1E37, 0x0304, 0,
    1, 0x1E3A, 0x004C, 0x0331, 0,
    1, 0x1E3B, 0x006C, 0x0331, 0,
    1, 0x1E3C, 0x004C, 0x032D, 0,
    1, 0x1E3D, 0x006C, 0x032D, 0,
    1, 0x1E3E, 0x004D, 0x0301, 0,
    1, 0x1E3F, 0x006D, 0x0301, 0,
    1, 0x1E40, 0x004D, 0x0307, 0,
    1, 0x1E41, 0x006D, 0x0307, 0,
    1, 0x1E42, 0x004D, 0x0323, 0,
    1, 0x1E43, 0x006D, 0x0323, 0,
    1, 0x1E44, 0x004E, 0x0307, 0,
    1, 0x1E45, 0x006E, 0x0307, 0,
    1, 0x1E46, 0x004E, 0x0323, 0,
    1, 0x1E47, 0x006E, 0x0323, 0,
    1, 0x1E48, 0x004E, 0x0331, 0,
    1, 0x1E49, 0x006E, 0x0331, 0,
    1, 0x1E4A, 0x004E, 0x032D, 0,
    1, 0x1E4B, 0x006E, 0x032D, 0,
    1, 0x1E4C, 0x00D5, 0x0301, 0,
    1, 0x1E4D, 0x00F5, 0x0301, 0,
    1, 0x1E4E, 0x00D5, 0x0308, 0,
    1, 0x1E4F, 0x00F5, 0x0308, 0,
    1, 0x1E50, 0x014C, 0x0300, 0,
    1, 0x1E51, 0x014D, 0x0300, 0,
    1, 0x1E52, 0x014C, 0x0301, 0,
    1, 0x1E53, 0x014D, 0x0301, 0,
    1, 0x1E54, 0x0050, 0x0301, 0,
    1, 0x1E55, 0x0070, 0x0301, 0,
    1, 0x1E56, 0x0050, 0x0307, 0,
    1, 0x1E57, 0x0070, 0x0307, 0,
    1, 0x1E58, 0x0052, 0x0307, 0,
    1, 0x1E59, 0x0072, 0x0307, 0,
    1, 0x1E5A, 0x0052, 0x0323, 0,
    1, 0x1E5B, 0x0072, 0x0323, 0,
    1, 0x1E5C, 0x1E5A, 0x0304, 0,
    1, 0x1E5D, 0x1E5B, 0x0304, 0,
    1, 0x1E5E, 0x0052, 0x0331, 0,
    1, 0x1E5F, 0x0072, 0x0331, 0,
    1, 0x1E60, 0x0053, 0x0307, 0,
    1, 0x1E61, 0x0073, 0x0307, 0,
    1, 0x1E62, 0x0053, 0x0323, 0,
    1, 0x1E63, 0x0073, 0x0323, 0,
    1, 0x1E64, 0x015A, 0x0307, 0,
    1, 0x1E65, 0x015B, 0x0307, 0,
    1, 0x1E66, 0x0160, 0x0307, 0,
    1, 0x1E67, 0x0161, 0x0307, 0,
    1, 0x1E68, 0x1E62, 0x0307, 0,
    1, 0x1E69, 0x1E63, 0x0307, 0,
    1, 0x1E6A, 0x0054, 0x0307, 0,
    1, 0x1E6B, 0x0074, 0x0307, 0,
    1, 0x1E6C, 0x0054, 0x0323, 0,
    1, 0x1E6D, 0x0074, 0x0323, 0,
    1, 0x1E6E, 0x0054, 0x0331, 0,
    1, 0x1E6F, 0x0074, 0x0331, 0,
    1, 0x1E70, 0x0054, 0x032D, 0,
    1, 0x1E71, 0x0074, 0x032D, 0,
    1, 0x1E72, 0x0055, 0x0324, 0,
    1, 0x1E73, 0x0075, 0x0324, 0,
    1, 0x1E74, 0x0055, 0x0330, 0,
    1, 0x1E75, 0x0075, 0x0330, 0,
    1, 0x1E76, 0x0055, 0x032D, 0,
    1, 0x1E77, 0x0075, 0x032D, 0,
    1, 0x1E78, 0x0168, 0x0301, 0,
    1, 0x1E79, 0x0169, 0x0301, 0,
    1, 0x1E7A, 0x016A, 0x0308, 0,
    1, 0x1E7B, 0x016B, 0x0308, 0,
    1, 0x1E7C, 0x0056, 0x0303, 0,
    1, 0x1E7D, 0x0076, 0x0303, 0,
    1, 0x1E7E, 0x0056, 0x0323, 0,
    1, 0x1E7F, 0x0076, 0x0323, 0,
    1, 0x1E80, 0x0057, 0x0300, 0,
    1, 0x1E81, 0x0077, 0x0300, 0,
    1, 0x1E82, 0x0057, 0x0301, 0,
    1, 0x1E83, 0x0077, 0x0301, 0,
    1, 0x1E84, 0x0057, 0x0308, 0,
    1, 0x1E85, 0x0077, 0x0308, 0,
    1, 0x1E86, 0x0057, 0x0307, 0,
    1, 0x1E87, 0x0077, 0x0307, 0,
    1, 0x1E88, 0x0057, 0x0323, 0,
    1, 0x1E89, 0x0077, 0x0323, 0,
    1, 0x1E8A, 0x0058, 0x0307, 0,
    1, 0x1E8B, 0x0078, 0x0307, 0,
    1, 0x1E8C, 0x0058, 0x0308, 0,
    1, 0x1E8D, 0x0078, 0x0308, 0,
    1, 0x1E8E, 0x0059, 0x0307, 0,
    1, 0x1E8F, 0x0079, 0x0307, 0,
    1, 0x1E90, 0x005A, 0x0302, 0,
    1, 0x1E91, 0x007A, 0x0302, 0,
    1, 0x1E92, 0x005A, 0x0323, 0,
    1, 0x1E93, 0x007A, 0x0323, 0,
    1, 0x1E94, 0x005A, 0x0331, 0,
    1, 0x1E95, 0x007A, 0x0331, 0,
    1, 0x1E96, 0x0068, 0x0331, 0,
    1, 0x1E97, 0x0074, 0x0308, 0,
    1, 0x1E98, 0x0077, 0x030A, 0,
    1, 0x1E99, 0x0079, 0x030A, 0,
    16, 0x1E9A, 0x0061, 0x02BE, 0,
    1, 0x1E9B, 0x017F, 0x0307, 0,
    1, 0x1EA0, 0x0041, 0x0323, 0,
    1, 0x1EA1, 0x0061, 0x0323, 0,
    1, 0x1EA2, 0x0041, 0x0309, 0,
    1, 0x1EA3, 0x0061, 0x0309, 0,
    1, 0x1EA4, 0x00C2, 0x0301, 0,
    1, 0x1EA5, 0x00E2, 0x0301, 0,
    1, 0x1EA6, 0x00C2, 0x0300, 0,
    1, 0x1EA7, 0x00E2, 0x0300, 0,
    1, 0x1EA8, 0x00C2, 0x0309, 0,
    1, 0x1EA9, 0x00E2, 0x0309, 0,
    1, 0x1EAA, 0x00C2, 0x0303, 0,
    1, 0x1EAB, 0x00E2, 0x0303, 0,
    1, 0x1EAC, 0x1EA0, 0x0302, 0,
    1, 0x1EAD, 0x1EA1, 0x0302, 0,
    1, 0x1EAE, 0x0102, 0x0301, 0,
    1, 0x1EAF, 0x0103, 0x0301, 0,
    1, 0x1EB0, 0x0102, 0x0300, 0,
    1, 0x1EB1, 0x0103, 0x0300, 0,
    1, 0x1EB2, 0x0102, 0x0309, 0,
    1, 0x1EB3, 0x0103, 0x0309, 0,
    1, 0x1EB4, 0x0102, 0x0303, 0,
    1, 0x1EB5, 0x0103, 0x0303, 0,
    1, 0x1EB6, 0x1EA0, 0x0306, 0,
    1, 0x1EB7, 0x1EA1, 0x0306, 0,
    1, 0x1EB8, 0x0045, 0x0323, 0,
    1, 0x1EB9, 0x0065, 0x0323, 0,
    1, 0x1EBA, 0x0045, 0x0309, 0,
    1, 0x1EBB, 0x0065, 0x0309, 0,
    1, 0x1EBC, 0x0045, 0x0303, 0,
    1, 0x1EBD, 0x0065, 0x0303, 0,
    1, 0x1EBE, 0x00CA, 0x0301, 0,
    1, 0x1EBF, 0x00EA, 0x0301, 0,
    1, 0x1EC0, 0x00CA, 0x0300, 0,
    1, 0x1EC1, 0x00EA, 0x0300, 0,
    1, 0x1EC2, 0x00CA, 0x0309, 0,
    1, 0x1EC3, 0x00EA, 0x0309, 0,
    1, 0x1EC4, 0x00CA, 0x0303, 0,
    1, 0x1EC5, 0x00EA, 0x0303, 0,
    1, 0x1EC6, 0x1EB8, 0x0302, 0,
    1, 0x1EC7, 0x1EB9, 0x0302, 0,
    1, 0x1EC8, 0x0049, 0x0309, 0,
    1, 0x1EC9, 0x0069, 0x0309, 0,
    1, 0x1ECA, 0x0049, 0x0323, 0,
    1, 0x1ECB, 0x0069, 0x0323, 0,
    1, 0x1ECC, 0x004F, 0x0323, 0,
    1, 0x1ECD, 0x006F, 0x0323, 0,
    1, 0x1ECE, 0x004F, 0x0309, 0,
    1, 0x1ECF, 0x006F, 0x0309, 0,
    1, 0x1ED0, 0x00D4, 0x0301, 0,
    1, 0x1ED1, 0x00F4, 0x0301, 0,
    1, 0x1ED2, 0x00D4, 0x0300, 0,
    1, 0x1ED3, 0x00F4, 0x0300, 0,
    1, 0x1ED4, 0x00D4, 0x0309, 0,
    1, 0x1ED5, 0x00F4, 0x0309, 0,
    1, 0x1ED6, 0x00D4, 0x0303, 0,
    1, 0x1ED7, 0x00F4, 0x0303, 0,
    1, 0x1ED8, 0x1ECC, 0x0302, 0,
    1, 0x1ED9, 0x1ECD, 0x0302, 0,
    1, 0x1EDA, 0x01A0, 0x0301, 0,
    1, 0x1EDB, 0x01A1, 0x0301, 0,
    1, 0x1EDC, 0x01A0, 0x0300, 0,
    1, 0x1EDD, 0x01A1, 0x0300, 0,
    1, 0x1EDE, 0x01A0, 0x0309, 0,
    1, 0x1EDF, 0x01A1, 0x0309, 0,
    1, 0x1EE0, 0x01A0, 0x0303, 0,
    1, 0x1EE1, 0x01A1, 0x0303, 0,
    1, 0x1EE2, 0x01A0, 0x0323, 0,
    1, 0x1EE3, 0x01A1, 0x0323, 0,
    1, 0x1EE4, 0x0055, 0x0323, 0,
    1, 0x1EE5, 0x0075, 0x0323, 0,
    1, 0x1EE6, 0x0055, 0x0309, 0,
    1, 0x1EE7, 0x0075, 0x0309, 0,
    1, 0x1EE8, 0x01AF, 0x0301, 0,
    1, 0x1EE9, 0x01B0, 0x0301, 0,
    1, 0x1EEA, 0x01AF, 0x0300, 0,
    1, 0x1EEB, 0x01B0, 0x0300, 0,
    1, 0x1EEC, 0x01AF, 0x0309, 0,
    1, 0x1EED, 0x01B0, 0x0309, 0,
    1, 0x1EEE, 0x01AF, 0x0303, 0,
    1, 0x1EEF, 0x01B0, 0x0303, 0,
    1, 0x1EF0, 0x01AF, 0x0323, 0,
    1, 0x1EF1, 0x01B0, 0x0323, 0,
    1, 0x1EF2, 0x0059, 0x0300, 0,
    1, 0x1EF3, 0x0079, 0x0300, 0,
    1, 0x1EF4, 0x0059, 0x0323, 0,
    1, 0x1EF5, 0x0079, 0x0323, 0,
    1, 0x1EF6, 0x0059, 0x0309, 0,
    1, 0x1EF7, 0x0079, 0x0309, 0,
    1, 0x1EF8, 0x0059, 0x0303, 0,
    1, 0x1EF9, 0x0079, 0x0303, 0,
    1, 0x1F00, 0x03B1, 0x0313, 0,
    1, 0x1F01, 0x03B1, 0x0314, 0,
    1, 0x1F02, 0x1F00, 0x0300, 0,
    1, 0x1F03, 0x1F01, 0x0300, 0,
    1, 0x1F04, 0x1F00, 0x0301, 0,
    1, 0x1F05, 0x1F01, 0x0301, 0,
    1, 0x1F06, 0x1F00, 0x0342, 0,
    1, 0x1F07, 0x1F01, 0x0342, 0,
    1, 0x1F08, 0x0391, 0x0313, 0,
    1, 0x1F09, 0x0391, 0x0314, 0,
    1, 0x1F0A, 0x1F08, 0x0300, 0,
    1, 0x1F0B, 0x1F09, 0x0300, 0,
    1, 0x1F0C, 0x1F08, 0x0301, 0,
    1, 0x1F0D, 0x1F09, 0x0301, 0,
    1, 0x1F0E, 0x1F08, 0x0342, 0,
    1, 0x1F0F, 0x1F09, 0x0342, 0,
    1, 0x1F10, 0x03B5, 0x0313, 0,
    1, 0x1F11, 0x03B5, 0x0314, 0,
    1, 0x1F12, 0x1F10, 0x0300, 0,
    1, 0x1F13, 0x1F11, 0x0300, 0,
    1, 0x1F14, 0x1F10, 0x0301, 0,
    1, 0x1F15, 0x1F11, 0x0301, 0,
    1, 0x1F18, 0x0395, 0x0313, 0,
    1, 0x1F19, 0x0395, 0x0314, 0,
    1, 0x1F1A, 0x1F18, 0x0300, 0,
    1, 0x1F1B, 0x1F19, 0x0300, 0,
    1, 0x1F1C, 0x1F18, 0x0301, 0,
    1, 0x1F1D, 0x1F19, 0x0301, 0,
    1, 0x1F20, 0x03B7, 0x0313, 0,
    1, 0x1F21, 0x03B7, 0x0314, 0,
    1, 0x1F22, 0x1F20, 0x0300, 0,
    1, 0x1F23, 0x1F21, 0x0300, 0,
    1, 0x1F24, 0x1F20, 0x0301, 0,
    1, 0x1F25, 0x1F21, 0x0301, 0,
    1, 0x1F26, 0x1F20, 0x0342, 0,
    1, 0x1F27, 0x1F21, 0x0342, 0,
    1, 0x1F28, 0x0397, 0x0313, 0,
    1, 0x1F29, 0x0397, 0x0314, 0,
    1, 0x1F2A, 0x1F28, 0x0300, 0,
    1, 0x1F2B, 0x1F29, 0x0300, 0,
    1, 0x1F2C, 0x1F28, 0x0301, 0,
    1, 0x1F2D, 0x1F29, 0x0301, 0,
    1, 0x1F2E, 0x1F28, 0x0342, 0,
    1, 0x1F2F, 0x1F29, 0x0342, 0,
    1, 0x1F30, 0x03B9, 0x0313, 0,
    1, 0x1F31, 0x03B9, 0x0314, 0,
    1, 0x1F32, 0x1F30, 0x0300, 0,
    1, 0x1F33, 0x1F31, 0x0300, 0,
    1, 0x1F34, 0x1F30, 0x0301, 0,
    1, 0x1F35, 0x1F31, 0x0301, 0,
    1, 0x1F36, 0x1F30, 0x0342, 0,
    1, 0x1F37, 0x1F31, 0x0342, 0,
    1, 0x1F38, 0x0399, 0x0313, 0,
    1, 0x1F39, 0x0399, 0x0314, 0,
    1, 0x1F3A, 0x1F38, 0x0300, 0,
    1, 0x1F3B, 0x1F39, 0x0300, 0,
    1, 0x1F3C, 0x1F38, 0x0301, 0,
    1, 0x1F3D, 0x1F39, 0x0301, 0,
    1, 0x1F3E, 0x1F38, 0x0342, 0,
    1, 0x1F3F, 0x1F39, 0x0342, 0,
    1, 0x1F40, 0x03BF, 0x0313, 0,
    1, 0x1F41, 0x03BF, 0x0314, 0,
    1, 0x1F42, 0x1F40, 0x0300, 0,
    1, 0x1F43, 0x1F41, 0x0300, 0,
    1, 0x1F44, 0x1F40, 0x0301, 0,
    1, 0x1F45, 0x1F41, 0x0301, 0,
    1, 0x1F48, 0x039F, 0x0313, 0,
    1, 0x1F49, 0x039F, 0x0314, 0,
    1, 0x1F4A, 0x1F48, 0x0300, 0,
    1, 0x1F4B, 0x1F49, 0x0300, 0,
    1, 0x1F4C, 0x1F48, 0x0301, 0,
    1, 0x1F4D, 0x1F49, 0x0301, 0,
    1, 0x1F50, 0x03C5, 0x0313, 0,
    1, 0x1F51, 0x03C5, 0x0314, 0,
    1, 0x1F52, 0x1F50, 0x0300, 0,
    1, 0x1F53, 0x1F51, 0x0300, 0,
    1, 0x1F54, 0x1F50, 0x0301, 0,
    1, 0x1F55, 0x1F51, 0x0301, 0,
    1, 0x1F56, 0x1F50, 0x0342, 0,
    1, 0x1F57, 0x1F51, 0x0342, 0,
    1, 0x1F59, 0x03A5, 0x0314, 0,
    1, 0x1F5B, 0x1F59, 0x0300, 0,
    1, 0x1F5D, 0x1F59, 0x0301, 0,
    1, 0x1F5F, 0x1F59, 0x0342, 0,
    1, 0x1F60, 0x03C9, 0x0313, 0,
    1, 0x1F61, 0x03C9, 0x0314, 0,
    1, 0x1F62, 0x1F60, 0x0300, 0,
    1, 0x1F63, 0x1F61, 0x0300, 0,
    1, 0x1F64, 0x1F60, 0x0301, 0,
    1, 0x1F65, 0x1F61, 0x0301, 0,
    1, 0x1F66, 0x1F60, 0x0342, 0,
    1, 0x1F67, 0x1F61, 0x0342, 0,
    1, 0x1F68, 0x03A9, 0x0313, 0,
    1, 0x1F69, 0x03A9, 0x0314, 0,
    1, 0x1F6A, 0x1F68, 0x0300, 0,
    1, 0x1F6B, 0x1F69, 0x0300, 0,
    1, 0x1F6C, 0x1F68, 0x0301, 0,
    1, 0x1F6D, 0x1F69, 0x0301, 0,
    1, 0x1F6E, 0x1F68, 0x0342, 0,
    1, 0x1F6F, 0x1F69, 0x0342, 0,
    1, 0x1F70, 0x03B1, 0x0300, 0,
    1, 0x1F71, 0x03AC, 0,
    1, 0x1F72, 0x03B5, 0x0300, 0,
    1, 0x1F73, 0x03AD, 0,
    1, 0x1F74, 0x03B7, 0x0300, 0,
    1, 0x1F75, 0x03AE, 0,
    1, 0x1F76, 0x03B9, 0x0300, 0,
    1, 0x1F77, 0x03AF, 0,
    1, 0x1F78, 0x03BF, 0x0300, 0,
    1, 0x1F79, 0x03CC, 0,
    1, 0x1F7A, 0x03C5, 0x0300, 0,
    1, 0x1F7B, 0x03CD, 0,
    1, 0x1F7C, 0x03C9, 0x0300, 0,
    1, 0x1F7D, 0x03CE, 0,
    1, 0x1F80, 0x1F00, 0x0345, 0,
    1, 0x1F81, 0x1F01, 0x0345, 0,
    1, 0x1F82, 0x1F02, 0x0345, 0,
    1, 0x1F83, 0x1F03, 0x0345, 0,
    1, 0x1F84, 0x1F04, 0x0345, 0,
    1, 0x1F85, 0x1F05, 0x0345, 0,
    1, 0x1F86, 0x1F06, 0x0345, 0,
    1, 0x1F87, 0x1F07, 0x0345, 0,
    1, 0x1F88, 0x1F08, 0x0345, 0,
    1, 0x1F89, 0x1F09, 0x0345, 0,
    1, 0x1F8A, 0x1F0A, 0x0345, 0,
    1, 0x1F8B, 0x1F0B, 0x0345, 0,
    1, 0x1F8C, 0x1F0C, 0x0345, 0,
    1, 0x1F8D, 0x1F0D, 0x0345, 0,
    1, 0x1F8E, 0x1F0E, 0x0345, 0,
    1, 0x1F8F, 0x1F0F, 0x0345, 0,
    1, 0x1F90, 0x1F20, 0x0345, 0,
    1, 0x1F91, 0x1F21, 0x0345, 0,
    1, 0x1F92, 0x1F22, 0x0345, 0,
    1, 0x1F93, 0x1F23, 0x0345, 0,
    1, 0x1F94, 0x1F24, 0x0345, 0,
    1, 0x1F95, 0x1F25, 0x0345, 0,
    1, 0x1F96, 0x1F26, 0x0345, 0,
    1, 0x1F97, 0x1F27, 0x0345, 0,
    1, 0x1F98, 0x1F28, 0x0345, 0,
    1, 0x1F99, 0x1F29, 0x0345, 0,
    1, 0x1F9A, 0x1F2A, 0x0345, 0,
    1, 0x1F9B, 0x1F2B, 0x0345, 0,
    1, 0x1F9C, 0x1F2C, 0x0345, 0,
    1, 0x1F9D, 0x1F2D, 0x0345, 0,
    1, 0x1F9E, 0x1F2E, 0x0345, 0,
    1, 0x1F9F, 0x1F2F, 0x0345, 0,
    1, 0x1FA0, 0x1F60, 0x0345, 0,
    1, 0x1FA1, 0x1F61, 0x0345, 0,
    1, 0x1FA2, 0x1F62, 0x0345, 0,
    1, 0x1FA3, 0x1F63, 0x0345, 0,
    1, 0x1FA4, 0x1F64, 0x0345, 0,
    1, 0x1FA5, 0x1F65, 0x0345, 0,
    1, 0x1FA6, 0x1F66, 0x0345, 0,
    1, 0x1FA7, 0x1F67, 0x0345, 0,
    1, 0x1FA8, 0x1F68, 0x0345, 0,
    1, 0x1FA9, 0x1F69, 0x0345, 0,
    1, 0x1FAA, 0x1F6A, 0x0345, 0,
    1, 0x1FAB, 0x1F6B, 0x0345, 0,
    1, 0x1FAC, 0x1F6C, 0x0345, 0,
    1, 0x1FAD, 0x1F6D, 0x0345, 0,
    1, 0x1FAE, 0x1F6E, 0x0345, 0,
    1, 0x1FAF, 0x1F6F, 0x0345, 0,
    1, 0x1FB0, 0x03B1, 0x0306, 0,
    1, 0x1FB1, 0x03B1, 0x0304, 0,
    1, 0x1FB2, 0x1F70, 0x0345, 0,
    1, 0x1FB3, 0x03B1, 0x0345, 0,
    1, 0x1FB4, 0x03AC, 0x0345, 0,
    1, 0x1FB6, 0x03B1, 0x0342, 0,
    1, 0x1FB7, 0x1FB6, 0x0345, 0,
    1, 0x1FB8, 0x0391, 0x0306, 0,
    1, 0x1FB9, 0x0391, 0x0304, 0,
    1, 0x1FBA, 0x0391, 0x0300, 0,
    1, 0x1FBB, 0x0386, 0,
    1, 0x1FBC, 0x0391, 0x0345, 0,
    16, 0x1FBD, 0x0020, 0x0313, 0,
    1, 0x1FBE, 0x03B9, 0,
    16, 0x1FBF, 0x0020, 0x0313, 0,
    16, 0x1FC0, 0x0020, 0x0342, 0,
    1, 0x1FC1, 0x00A8, 0x0342, 0,
    1, 0x1FC2, 0x1F74, 0x0345, 0,
    1, 0x1FC3, 0x03B7, 0x0345, 0,
    1, 0x1FC4, 0x03AE, 0x0345, 0,
    1, 0x1FC6, 0x03B7, 0x0342, 0,
    1, 0x1FC7, 0x1FC6, 0x0345, 0,
    1, 0x1FC8, 0x0395, 0x0300, 0,
    1, 0x1FC9, 0x0388, 0,
    1, 0x1FCA, 0x0397, 0x0300, 0,
    1, 0x1FCB, 0x0389, 0,
    1, 0x1FCC, 0x0397, 0x0345, 0,
    1, 0x1FCD, 0x1FBF, 0x0300, 0,
    1, 0x1FCE, 0x1FBF, 0x0301, 0,
    1, 0x1FCF, 0x1FBF, 0x0342, 0,
    1, 0x1FD0, 0x03B9, 0x0306, 0,
    1, 0x1FD1, 0x03B9, 0x0304, 0,
    1, 0x1FD2, 0x03CA, 0x0300, 0,
    1, 0x1FD3, 0x0390, 0,
    1, 0x1FD6, 0x03B9, 0x0342, 0,
    1, 0x1FD7, 0x03CA, 0x0342, 0,
    1, 0x1FD8, 0x0399, 0x0306, 0,
    1, 0x1FD9, 0x0399, 0x0304, 0,
    1, 0x1FDA, 0x0399, 0x0300, 0,
    1, 0x1FDB, 0x038A, 0,
    1, 0x1FDD, 0x1FFE, 0x0300, 0,
    1, 0x1FDE, 0x1FFE, 0x0301, 0,
    1, 0x1FDF, 0x1FFE, 0x0342, 0,
    1, 0x1FE0, 0x03C5, 0x0306, 0,
    1, 0x1FE1, 0x03C5, 0x0304, 0,
    1, 0x1FE2, 0x03CB, 0x0300, 0,
    1, 0x1FE3, 0x03B0, 0,
    1, 0x1FE4, 0x03C1, 0x0313, 0,
    1, 0x1FE5, 0x03C1, 0x0314, 0,
    1, 0x1FE6, 0x03C5, 0x0342, 0,
    1, 0x1FE7, 0x03CB, 0x0342, 0,
    1, 0x1FE8, 0x03A5, 0x0306, 0,
    1, 0x1FE9, 0x03A5, 0x0304, 0,
    1, 0x1FEA, 0x03A5, 0x0300, 0,
    1, 0x1FEB, 0x038E, 0,
    1, 0x1FEC, 0x03A1, 0x0314, 0,
    1, 0x1FED, 0x00A8, 0x0300, 0,
    1, 0x1FEE, 0x0385, 0,
    1, 0x1FEF, 0x0060, 0,
    1, 0x1FF2, 0x1F7C, 0x0345, 0,
    1, 0x1FF3, 0x03C9, 0x0345, 0,
    1, 0x1FF4, 0x03CE, 0x0345, 0,
    1, 0x1FF6, 0x03C9, 0x0342, 0,
    1, 0x1FF7, 0x1FF6, 0x0345, 0,
    1, 0x1FF8, 0x039F, 0x0300, 0,
    1, 0x1FF9, 0x038C, 0,
    1, 0x1FFA, 0x03A9, 0x0300, 0,
    1, 0x1FFB, 0x038F, 0,
    1, 0x1FFC, 0x03A9, 0x0345, 0,
    1, 0x1FFD, 0x00B4, 0,
    16, 0x1FFE, 0x0020, 0x0314, 0,
    1, 0x2000, 0x2002, 0,
    1, 0x2001, 0x2003, 0,
    16, 0x2002, 0x0020, 0,
    16, 0x2003, 0x0020, 0,
    16, 0x2004, 0x0020, 0,
    16, 0x2005, 0x0020, 0,
    16, 0x2006, 0x0020, 0,
    3, 0x2007, 0x0020, 0,
    16, 0x2008, 0x0020, 0,
    16, 0x2009, 0x0020, 0,
    16, 0x200A, 0x0020, 0,
    3, 0x2011, 0x2010, 0,
    16, 0x2017, 0x0020, 0x0333, 0,
    16, 0x2024, 0x002E, 0,
    16, 0x2025, 0x002E, 0x002E, 0,
    16, 0x2026, 0x002E, 0x002E, 0x002E, 0,
    3, 0x202F, 0x0020, 0,
    16, 0x2033, 0x2032, 0x2032, 0,
    16, 0x2034, 0x2032, 0x2032, 0x2032, 0,
    16, 0x2036, 0x2035, 0x2035, 0,
    16, 0x2037, 0x2035, 0x2035, 0x2035, 0,
    16, 0x203C, 0x0021, 0x0021, 0,
    16, 0x203E, 0x0020, 0x0305, 0,
    16, 0x2048, 0x003F, 0x0021, 0,
    16, 0x2049, 0x0021, 0x003F, 0,
    9, 0x2070, 0x0030, 0,
    9, 0x2074, 0x0034, 0,
    9, 0x2075, 0x0035, 0,
    9, 0x2076, 0x0036, 0,
    9, 0x2077, 0x0037, 0,
    9, 0x2078, 0x0038, 0,
    9, 0x2079, 0x0039, 0,
    9, 0x207A, 0x002B, 0,
    9, 0x207B, 0x2212, 0,
    9, 0x207C, 0x003D, 0,
    9, 0x207D, 0x0028, 0,
    9, 0x207E, 0x0029, 0,
    9, 0x207F, 0x006E, 0,
    10, 0x2080, 0x0030, 0,
    10, 0x2081, 0x0031, 0,
    10, 0x2082, 0x0032, 0,
    10, 0x2083, 0x0033, 0,
    10, 0x2084, 0x0034, 0,
    10, 0x2085, 0x0035, 0,
    10, 0x2086, 0x0036, 0,
    10, 0x2087, 0x0037, 0,
    10, 0x2088, 0x0038, 0,
    10, 0x2089, 0x0039, 0,
    10, 0x208A, 0x002B, 0,
    10, 0x208B, 0x2212, 0,
    10, 0x208C, 0x003D, 0,
    10, 0x208D, 0x0028, 0,
    10, 0x208E, 0x0029, 0,
    16, 0x20A8, 0x0052, 0x0073, 0,
    16, 0x2100, 0x0061, 0x002F, 0x0063, 0,
    16, 0x2101, 0x0061, 0x002F, 0x0073, 0,
    2, 0x2102, 0x0043, 0,
    16, 0x2103, 0x00B0, 0x0043, 0,
    16, 0x2105, 0x0063, 0x002F, 0x006F, 0,
    16, 0x2106, 0x0063, 0x002F, 0x0075, 0,
    16, 0x2107, 0x0190, 0,
    16, 0x2109, 0x00B0, 0x0046, 0,
    2, 0x210A, 0x0067, 0,
    2, 0x210B, 0x0048, 0,
    2, 0x210C, 0x0048, 0,
    2, 0x210D, 0x0048, 0,
    2, 0x210E, 0x0068, 0,
    2, 0x210F, 0x0127, 0,
    2, 0x2110, 0x0049, 0,
    2, 0x2111, 0x0049, 0,
    2, 0x2112, 0x004C, 0,
    2, 0x2113, 0x006C, 0,
    2, 0x2115, 0x004E, 0,
    16, 0x2116, 0x004E, 0x006F, 0,
    2, 0x2119, 0x0050, 0,
    2, 0x211A, 0x0051, 0,
    2, 0x211B, 0x0052, 0,
    2, 0x211C, 0x0052, 0,
    2, 0x211D, 0x0052, 0,
    9, 0x2120, 0x0053, 0x004D, 0,
    16, 0x2121, 0x0054, 0x0045, 0x004C, 0,
    9, 0x2122, 0x0054, 0x004D, 0,
    2, 0x2124, 0x005A, 0,
    1, 0x2126, 0x03A9, 0,
    2, 0x2128, 0x005A, 0,
    1, 0x212A, 0x004B, 0,
    1, 0x212B, 0x00C5, 0,
    2, 0x212C, 0x0042, 0,
    2, 0x212D, 0x0043, 0,
    2, 0x212F, 0x0065, 0,
    2, 0x2130, 0x0045, 0,
    2, 0x2131, 0x0046, 0,
    2, 0x2133, 0x004D, 0,
    2, 0x2134, 0x006F, 0,
    16, 0x2135, 0x05D0, 0,
    16, 0x2136, 0x05D1, 0,
    16, 0x2137, 0x05D2, 0,
    16, 0x2138, 0x05D3, 0,
    2, 0x2139, 0x0069, 0,
    17, 0x2153, 0x0031, 0x2044, 0x0033, 0,
    17, 0x2154, 0x0032, 0x2044, 0x0033, 0,
    17, 0x2155, 0x0031, 0x2044, 0x0035, 0,
    17, 0x2156, 0x0032, 0x2044, 0x0035, 0,
    17, 0x2157, 0x0033, 0x2044, 0x0035, 0,
    17, 0x2158, 0x0034, 0x2044, 0x0035, 0,
    17, 0x2159, 0x0031, 0x2044, 0x0036, 0,
    17, 0x215A, 0x0035, 0x2044, 0x0036, 0,
    17, 0x215B, 0x0031, 0x2044, 0x0038, 0,
    17, 0x215C, 0x0033, 0x2044, 0x0038, 0,
    17, 0x215D, 0x0035, 0x2044, 0x0038, 0,
    17, 0x215E, 0x0037, 0x2044, 0x0038, 0,
    17, 0x215F, 0x0031, 0x2044, 0,
    16, 0x2160, 0x0049, 0,
    16, 0x2161, 0x0049, 0x0049, 0,
    16, 0x2162, 0x0049, 0x0049, 0x0049, 0,
    16, 0x2163, 0x0049, 0x0056, 0,
    16, 0x2164, 0x0056, 0,
    16, 0x2165, 0x0056, 0x0049, 0,
    16, 0x2166, 0x0056, 0x0049, 0x0049, 0,
    16, 0x2167, 0x0056, 0x0049, 0x0049, 0x0049, 0,
    16, 0x2168, 0x0049, 0x0058, 0,
    16, 0x2169, 0x0058, 0,
    16, 0x216A, 0x0058, 0x0049, 0,
    16, 0x216B, 0x0058, 0x0049, 0x0049, 0,
    16, 0x216C, 0x004C, 0,
    16, 0x216D, 0x0043, 0,
    16, 0x216E, 0x0044, 0,
    16, 0x216F, 0x004D, 0,
    16, 0x2170, 0x0069, 0,
    16, 0x2171, 0x0069, 0x0069, 0,
    16, 0x2172, 0x0069, 0x0069, 0x0069, 0,
    16, 0x2173, 0x0069, 0x0076, 0,
    16, 0x2174, 0x0076, 0,
    16, 0x2175, 0x0076, 0x0069, 0,
    16, 0x2176, 0x0076, 0x0069, 0x0069, 0,
    16, 0x2177, 0x0076, 0x0069, 0x0069, 0x0069, 0,
    16, 0x2178, 0x0069, 0x0078, 0,
    16, 0x2179, 0x0078, 0,
    16, 0x217A, 0x0078, 0x0069, 0,
    16, 0x217B, 0x0078, 0x0069, 0x0069, 0,
    16, 0x217C, 0x006C, 0,
    16, 0x217D, 0x0063, 0,
    16, 0x217E, 0x0064, 0,
    16, 0x217F, 0x006D, 0,
    1, 0x219A, 0x2190, 0x0338, 0,
    1, 0x219B, 0x2192, 0x0338, 0,
    1, 0x21AE, 0x2194, 0x0338, 0,
    1, 0x21CD, 0x21D0, 0x0338, 0,
    1, 0x21CE, 0x21D4, 0x0338, 0,
    1, 0x21CF, 0x21D2, 0x0338, 0,
    1, 0x2204, 0x2203, 0x0338, 0,
    1, 0x2209, 0x2208, 0x0338, 0,
    1, 0x220C, 0x220B, 0x0338, 0,
    1, 0x2224, 0x2223, 0x0338, 0,
    1, 0x2226, 0x2225, 0x0338, 0,
    16, 0x222C, 0x222B, 0x222B, 0,
    16, 0x222D, 0x222B, 0x222B, 0x222B, 0,
    16, 0x222F, 0x222E, 0x222E, 0,
    16, 0x2230, 0x222E, 0x222E, 0x222E, 0,
    1, 0x2241, 0x223C, 0x0338, 0,
    1, 0x2244, 0x2243, 0x0338, 0,
    1, 0x2247, 0x2245, 0x0338, 0,
    1, 0x2249, 0x2248, 0x0338, 0,
    1, 0x2260, 0x003D, 0x0338, 0,
    1, 0x2262, 0x2261, 0x0338, 0,
    1, 0x226D, 0x224D, 0x0338, 0,
    1, 0x226E, 0x003C, 0x0338, 0,
    1, 0x226F, 0x003E, 0x0338, 0,
    1, 0x2270, 0x2264, 0x0338, 0,
    1, 0x2271, 0x2265, 0x0338, 0,
    1, 0x2274, 0x2272, 0x0338, 0,
    1, 0x2275, 0x2273, 0x0338, 0,
    1, 0x2278, 0x2276, 0x0338, 0,
    1, 0x2279, 0x2277, 0x0338, 0,
    1, 0x2280, 0x227A, 0x0338, 0,
    1, 0x2281, 0x227B, 0x0338, 0,
    1, 0x2284, 0x2282, 0x0338, 0,
    1, 0x2285, 0x2283, 0x0338, 0,
    1, 0x2288, 0x2286, 0x0338, 0,
    1, 0x2289, 0x2287, 0x0338, 0,
    1, 0x22AC, 0x22A2, 0x0338, 0,
    1, 0x22AD, 0x22A8, 0x0338, 0,
    1, 0x22AE, 0x22A9, 0x0338, 0,
    1, 0x22AF, 0x22AB, 0x0338, 0,
    1, 0x22E0, 0x227C, 0x0338, 0,
    1, 0x22E1, 0x227D, 0x0338, 0,
    1, 0x22E2, 0x2291, 0x0338, 0,
    1, 0x22E3, 0x2292, 0x0338, 0,
    1, 0x22EA, 0x22B2, 0x0338, 0,
    1, 0x22EB, 0x22B3, 0x0338, 0,
    1, 0x22EC, 0x22B4, 0x0338, 0,
    1, 0x22ED, 0x22B5, 0x0338, 0,
    1, 0x2329, 0x3008, 0,
    1, 0x232A, 0x3009, 0,
    8, 0x2460, 0x0031, 0,
    8, 0x2461, 0x0032, 0,
    8, 0x2462, 0x0033, 0,
    8, 0x2463, 0x0034, 0,
    8, 0x2464, 0x0035, 0,
    8, 0x2465, 0x0036, 0,
    8, 0x2466, 0x0037, 0,
    8, 0x2467, 0x0038, 0,
    8, 0x2468, 0x0039, 0,
    8, 0x2469, 0x0031, 0x0030, 0,
    8, 0x246A, 0x0031, 0x0031, 0,
    8, 0x246B, 0x0031, 0x0032, 0,
    8, 0x246C, 0x0031, 0x0033, 0,
    8, 0x246D, 0x0031, 0x0034, 0,
    8, 0x246E, 0x0031, 0x0035, 0,
    8, 0x246F, 0x0031, 0x0036, 0,
    8, 0x2470, 0x0031, 0x0037, 0,
    8, 0x2471, 0x0031, 0x0038, 0,
    8, 0x2472, 0x0031, 0x0039, 0,
    8, 0x2473, 0x0032, 0x0030, 0,
    16, 0x2474, 0x0028, 0x0031, 0x0029, 0,
    16, 0x2475, 0x0028, 0x0032, 0x0029, 0,
    16, 0x2476, 0x0028, 0x0033, 0x0029, 0,
    16, 0x2477, 0x0028, 0x0034, 0x0029, 0,
    16, 0x2478, 0x0028, 0x0035, 0x0029, 0,
    16, 0x2479, 0x0028, 0x0036, 0x0029, 0,
    16, 0x247A, 0x0028, 0x0037, 0x0029, 0,
    16, 0x247B, 0x0028, 0x0038, 0x0029, 0,
    16, 0x247C, 0x0028, 0x0039, 0x0029, 0,
    16, 0x247D, 0x0028, 0x0031, 0x0030, 0x0029, 0,
    16, 0x247E, 0x0028, 0x0031, 0x0031, 0x0029, 0,
    16, 0x247F, 0x0028, 0x0031, 0x0032, 0x0029, 0,
    16, 0x2480, 0x0028, 0x0031, 0x0033, 0x0029, 0,
    16, 0x2481, 0x0028, 0x0031, 0x0034, 0x0029, 0,
    16, 0x2482, 0x0028, 0x0031, 0x0035, 0x0029, 0,
    16, 0x2483, 0x0028, 0x0031, 0x0036, 0x0029, 0,
    16, 0x2484, 0x0028, 0x0031, 0x0037, 0x0029, 0,
    16, 0x2485, 0x0028, 0x0031, 0x0038, 0x0029, 0,
    16, 0x2486, 0x0028, 0x0031, 0x0039, 0x0029, 0,
    16, 0x2487, 0x0028, 0x0032, 0x0030, 0x0029, 0,
    16, 0x2488, 0x0031, 0x002E, 0,
    16, 0x2489, 0x0032, 0x002E, 0,
    16, 0x248A, 0x0033, 0x002E, 0,
    16, 0x248B, 0x0034, 0x002E, 0,
    16, 0x248C, 0x0035, 0x002E, 0,
    16, 0x248D, 0x0036, 0x002E, 0,
    16, 0x248E, 0x0037, 0x002E, 0,
    16, 0x248F, 0x0038, 0x002E, 0,
    16, 0x2490, 0x0039, 0x002E, 0,
    16, 0x2491, 0x0031, 0x0030, 0x002E, 0,
    16, 0x2492, 0x0031, 0x0031, 0x002E, 0,
    16, 0x2493, 0x0031, 0x0032, 0x002E, 0,
    16, 0x2494, 0x0031, 0x0033, 0x002E, 0,
    16, 0x2495, 0x0031, 0x0034, 0x002E, 0,
    16, 0x2496, 0x0031, 0x0035, 0x002E, 0,
    16, 0x2497, 0x0031, 0x0036, 0x002E, 0,
    16, 0x2498, 0x0031, 0x0037, 0x002E, 0,
    16, 0x2499, 0x0031, 0x0038, 0x002E, 0,
    16, 0x249A, 0x0031, 0x0039, 0x002E, 0,
    16, 0x249B, 0x0032, 0x0030, 0x002E, 0,
    16, 0x249C, 0x0028, 0x0061, 0x0029, 0,
    16, 0x249D, 0x0028, 0x0062, 0x0029, 0,
    16, 0x249E, 0x0028, 0x0063, 0x0029, 0,
    16, 0x249F, 0x0028, 0x0064, 0x0029, 0,
    16, 0x24A0, 0x0028, 0x0065, 0x0029, 0,
    16, 0x24A1, 0x0028, 0x0066, 0x0029, 0,
    16, 0x24A2, 0x0028, 0x0067, 0x0029, 0,
    16, 0x24A3, 0x0028, 0x0068, 0x0029, 0,
    16, 0x24A4, 0x0028, 0x0069, 0x0029, 0,
    16, 0x24A5, 0x0028, 0x006A, 0x0029, 0,
    16, 0x24A6, 0x0028, 0x006B, 0x0029, 0,
    16, 0x24A7, 0x0028, 0x006C, 0x0029, 0,
    16, 0x24A8, 0x0028, 0x006D, 0x0029, 0,
    16, 0x24A9, 0x0028, 0x006E, 0x0029, 0,
    16, 0x24AA, 0x0028, 0x006F, 0x0029, 0,
    16, 0x24AB, 0x0028, 0x0070, 0x0029, 0,
    16, 0x24AC, 0x0028, 0x0071, 0x0029, 0,
    16, 0x24AD, 0x0028, 0x0072, 0x0029, 0,
    16, 0x24AE, 0x0028, 0x0073, 0x0029, 0,
    16, 0x24AF, 0x0028, 0x0074, 0x0029, 0,
    16, 0x24B0, 0x0028, 0x0075, 0x0029, 0,
    16, 0x24B1, 0x0028, 0x0076, 0x0029, 0,
    16, 0x24B2, 0x0028, 0x0077, 0x0029, 0,
    16, 0x24B3, 0x0028, 0x0078, 0x0029, 0,
    16, 0x24B4, 0x0028, 0x0079, 0x0029, 0,
    16, 0x24B5, 0x0028, 0x007A, 0x0029, 0,
    8, 0x24B6, 0x0041, 0,
    8, 0x24B7, 0x0042, 0,
    8, 0x24B8, 0x0043, 0,
    8, 0x24B9, 0x0044, 0,
    8, 0x24BA, 0x0045, 0,
    8, 0x24BB, 0x0046, 0,
    8, 0x24BC, 0x0047, 0,
    8, 0x24BD, 0x0048, 0,
    8, 0x24BE, 0x0049, 0,
    8, 0x24BF, 0x004A, 0,
    8, 0x24C0, 0x004B, 0,
    8, 0x24C1, 0x004C, 0,
    8, 0x24C2, 0x004D, 0,
    8, 0x24C3, 0x004E, 0,
    8, 0x24C4, 0x004F, 0,
    8, 0x24C5, 0x0050, 0,
    8, 0x24C6, 0x0051, 0,
    8, 0x24C7, 0x0052, 0,
    8, 0x24C8, 0x0053, 0,
    8, 0x24C9, 0x0054, 0,
    8, 0x24CA, 0x0055, 0,
    8, 0x24CB, 0x0056, 0,
    8, 0x24CC, 0x0057, 0,
    8, 0x24CD, 0x0058, 0,
    8, 0x24CE, 0x0059, 0,
    8, 0x24CF, 0x005A, 0,
    8, 0x24D0, 0x0061, 0,
    8, 0x24D1, 0x0062, 0,
    8, 0x24D2, 0x0063, 0,
    8, 0x24D3, 0x0064, 0,
    8, 0x24D4, 0x0065, 0,
    8, 0x24D5, 0x0066, 0,
    8, 0x24D6, 0x0067, 0,
    8, 0x24D7, 0x0068, 0,
    8, 0x24D8, 0x0069, 0,
    8, 0x24D9, 0x006A, 0,
    8, 0x24DA, 0x006B, 0,
    8, 0x24DB, 0x006C, 0,
    8, 0x24DC, 0x006D, 0,
    8, 0x24DD, 0x006E, 0,
    8, 0x24DE, 0x006F, 0,
    8, 0x24DF, 0x0070, 0,
    8, 0x24E0, 0x0071, 0,
    8, 0x24E1, 0x0072, 0,
    8, 0x24E2, 0x0073, 0,
    8, 0x24E3, 0x0074, 0,
    8, 0x24E4, 0x0075, 0,
    8, 0x24E5, 0x0076, 0,
    8, 0x24E6, 0x0077, 0,
    8, 0x24E7, 0x0078, 0,
    8, 0x24E8, 0x0079, 0,
    8, 0x24E9, 0x007A, 0,
    8, 0x24EA, 0x0030, 0,
    16, 0x2E9F, 0x6BCD, 0,
    16, 0x2EF3, 0x9F9F, 0,
    16, 0x2F00, 0x4E00, 0,
    16, 0x2F01, 0x4E28, 0,
    16, 0x2F02, 0x4E36, 0,
    16, 0x2F03, 0x4E3F, 0,
    16, 0x2F04, 0x4E59, 0,
    16, 0x2F05, 0x4E85, 0,
    16, 0x2F06, 0x4E8C, 0,
    16, 0x2F07, 0x4EA0, 0,
    16, 0x2F08, 0x4EBA, 0,
    16, 0x2F09, 0x513F, 0,
    16, 0x2F0A, 0x5165, 0,
    16, 0x2F0B, 0x516B, 0,
    16, 0x2F0C, 0x5182, 0,
    16, 0x2F0D, 0x5196, 0,
    16, 0x2F0E, 0x51AB, 0,
    16, 0x2F0F, 0x51E0, 0,
    16, 0x2F10, 0x51F5, 0,
    16, 0x2F11, 0x5200, 0,
    16, 0x2F12, 0x529B, 0,
    16, 0x2F13, 0x52F9, 0,
    16, 0x2F14, 0x5315, 0,
    16, 0x2F15, 0x531A, 0,
    16, 0x2F16, 0x5338, 0,
    16, 0x2F17, 0x5341, 0,
    16, 0x2F18, 0x535C, 0,
    16, 0x2F19, 0x5369, 0,
    16, 0x2F1A, 0x5382, 0,
    16, 0x2F1B, 0x53B6, 0,
    16, 0x2F1C, 0x53C8, 0,
    16, 0x2F1D, 0x53E3, 0,
    16, 0x2F1E, 0x56D7, 0,
    16, 0x2F1F, 0x571F, 0,
    16, 0x2F20, 0x58EB, 0,
    16, 0x2F21, 0x5902, 0,
    16, 0x2F22, 0x590A, 0,
    16, 0x2F23, 0x5915, 0,
    16, 0x2F24, 0x5927, 0,
    16, 0x2F25, 0x5973, 0,
    16, 0x2F26, 0x5B50, 0,
    16, 0x2F27, 0x5B80, 0,
    16, 0x2F28, 0x5BF8, 0,
    16, 0x2F29, 0x5C0F, 0,
    16, 0x2F2A, 0x5C22, 0,
    16, 0x2F2B, 0x5C38, 0,
    16, 0x2F2C, 0x5C6E, 0,
    16, 0x2F2D, 0x5C71, 0,
    16, 0x2F2E, 0x5DDB, 0,
    16, 0x2F2F, 0x5DE5, 0,
    16, 0x2F30, 0x5DF1, 0,
    16, 0x2F31, 0x5DFE, 0,
    16, 0x2F32, 0x5E72, 0,
    16, 0x2F33, 0x5E7A, 0,
    16, 0x2F34, 0x5E7F, 0,
    16, 0x2F35, 0x5EF4, 0,
    16, 0x2F36, 0x5EFE, 0,
    16, 0x2F37, 0x5F0B, 0,
    16, 0x2F38, 0x5F13, 0,
    16, 0x2F39, 0x5F50, 0,
    16, 0x2F3A, 0x5F61, 0,
    16, 0x2F3B, 0x5F73, 0,
    16, 0x2F3C, 0x5FC3, 0,
    16, 0x2F3D, 0x6208, 0,
    16, 0x2F3E, 0x6236, 0,
    16, 0x2F3F, 0x624B, 0,
    16, 0x2F40, 0x652F, 0,
    16, 0x2F41, 0x6534, 0,
    16, 0x2F42, 0x6587, 0,
    16, 0x2F43, 0x6597, 0,
    16, 0x2F44, 0x65A4, 0,
    16, 0x2F45, 0x65B9, 0,
    16, 0x2F46, 0x65E0, 0,
    16, 0x2F47, 0x65E5, 0,
    16, 0x2F48, 0x66F0, 0,
    16, 0x2F49, 0x6708, 0,
    16, 0x2F4A, 0x6728, 0,
    16, 0x2F4B, 0x6B20, 0,
    16, 0x2F4C, 0x6B62, 0,
    16, 0x2F4D, 0x6B79, 0,
    16, 0x2F4E, 0x6BB3, 0,
    16, 0x2F4F, 0x6BCB, 0,
    16, 0x2F50, 0x6BD4, 0,
    16, 0x2F51, 0x6BDB, 0,
    16, 0x2F52, 0x6C0F, 0,
    16, 0x2F53, 0x6C14, 0,
    16, 0x2F54, 0x6C34, 0,
    16, 0x2F55, 0x706B, 0,
    16, 0x2F56, 0x722A, 0,
    16, 0x2F57, 0x7236, 0,
    16, 0x2F58, 0x723B, 0,
    16, 0x2F59, 0x723F, 0,
    16, 0x2F5A, 0x7247, 0,
    16, 0x2F5B, 0x7259, 0,
    16, 0x2F5C, 0x725B, 0,
    16, 0x2F5D, 0x72AC, 0,
    16, 0x2F5E, 0x7384, 0,
    16, 0x2F5F, 0x7389, 0,
    16, 0x2F60, 0x74DC, 0,
    16, 0x2F61, 0x74E6, 0,
    16, 0x2F62, 0x7518, 0,
    16, 0x2F63, 0x751F, 0,
    16, 0x2F64, 0x7528, 0,
    16, 0x2F65, 0x7530, 0,
    16, 0x2F66, 0x758B, 0,
    16, 0x2F67, 0x7592, 0,
    16, 0x2F68, 0x7676, 0,
    16, 0x2F69, 0x767D, 0,
    16, 0x2F6A, 0x76AE, 0,
    16, 0x2F6B, 0x76BF, 0,
    16, 0x2F6C, 0x76EE, 0,
    16, 0x2F6D, 0x77DB, 0,
    16, 0x2F6E, 0x77E2, 0,
    16, 0x2F6F, 0x77F3, 0,
    16, 0x2F70, 0x793A, 0,
    16, 0x2F71, 0x79B8, 0,
    16, 0x2F72, 0x79BE, 0,
    16, 0x2F73, 0x7A74, 0,
    16, 0x2F74, 0x7ACB, 0,
    16, 0x2F75, 0x7AF9, 0,
    16, 0x2F76, 0x7C73, 0,
    16, 0x2F77, 0x7CF8, 0,
    16, 0x2F78, 0x7F36, 0,
    16, 0x2F79, 0x7F51, 0,
    16, 0x2F7A, 0x7F8A, 0,
    16, 0x2F7B, 0x7FBD, 0,
    16, 0x2F7C, 0x8001, 0,
    16, 0x2F7D, 0x800C, 0,
    16, 0x2F7E, 0x8012, 0,
    16, 0x2F7F, 0x8033, 0,
    16, 0x2F80, 0x807F, 0,
    16, 0x2F81, 0x8089, 0,
    16, 0x2F82, 0x81E3, 0,
    16, 0x2F83, 0x81EA, 0,
    16, 0x2F84, 0x81F3, 0,
    16, 0x2F85, 0x81FC, 0,
    16, 0x2F86, 0x820C, 0,
    16, 0x2F87, 0x821B, 0,
    16, 0x2F88, 0x821F, 0,
    16, 0x2F89, 0x826E, 0,
    16, 0x2F8A, 0x8272, 0,
    16, 0x2F8B, 0x8278, 0,
    16, 0x2F8C, 0x864D, 0,
    16, 0x2F8D, 0x866B, 0,
    16, 0x2F8E, 0x8840, 0,
    16, 0x2F8F, 0x884C, 0,
    16, 0x2F90, 0x8863, 0,
    16, 0x2F91, 0x897E, 0,
    16, 0x2F92, 0x898B, 0,
    16, 0x2F93, 0x89D2, 0,
    16, 0x2F94, 0x8A00, 0,
    16, 0x2F95, 0x8C37, 0,
    16, 0x2F96, 0x8C46, 0,
    16, 0x2F97, 0x8C55, 0,
    16, 0x2F98, 0x8C78, 0,
    16, 0x2F99, 0x8C9D, 0,
    16, 0x2F9A, 0x8D64, 0,
    16, 0x2F9B, 0x8D70, 0,
    16, 0x2F9C, 0x8DB3, 0,
    16, 0x2F9D, 0x8EAB, 0,
    16, 0x2F9E, 0x8ECA, 0,
    16, 0x2F9F, 0x8F9B, 0,
    16, 0x2FA0, 0x8FB0, 0,
    16, 0x2FA1, 0x8FB5, 0,
    16, 0x2FA2, 0x9091, 0,
    16, 0x2FA3, 0x9149, 0,
    16, 0x2FA4, 0x91C6, 0,
    16, 0x2FA5, 0x91CC, 0,
    16, 0x2FA6, 0x91D1, 0,
    16, 0x2FA7, 0x9577, 0,
    16, 0x2FA8, 0x9580, 0,
    16, 0x2FA9, 0x961C, 0,
    16, 0x2FAA, 0x96B6, 0,
    16, 0x2FAB, 0x96B9, 0,
    16, 0x2FAC, 0x96E8, 0,
    16, 0x2FAD, 0x9751, 0,
    16, 0x2FAE, 0x975E, 0,
    16, 0x2FAF, 0x9762, 0,
    16, 0x2FB0, 0x9769, 0,
    16, 0x2FB1, 0x97CB, 0,
    16, 0x2FB2, 0x97ED, 0,
    16, 0x2FB3, 0x97F3, 0,
    16, 0x2FB4, 0x9801, 0,
    16, 0x2FB5, 0x98A8, 0,
    16, 0x2FB6, 0x98DB, 0,
    16, 0x2FB7, 0x98DF, 0,
    16, 0x2FB8, 0x9996, 0,
    16, 0x2FB9, 0x9999, 0,
    16, 0x2FBA, 0x99AC, 0,
    16, 0x2FBB, 0x9AA8, 0,
    16, 0x2FBC, 0x9AD8, 0,
    16, 0x2FBD, 0x9ADF, 0,
    16, 0x2FBE, 0x9B25, 0,
    16, 0x2FBF, 0x9B2F, 0,
    16, 0x2FC0, 0x9B32, 0,
    16, 0x2FC1, 0x9B3C, 0,
    16, 0x2FC2, 0x9B5A, 0,
    16, 0x2FC3, 0x9CE5, 0,
    16, 0x2FC4, 0x9E75, 0,
    16, 0x2FC5, 0x9E7F, 0,
    16, 0x2FC6, 0x9EA5, 0,
    16, 0x2FC7, 0x9EBB, 0,
    16, 0x2FC8, 0x9EC3, 0,
    16, 0x2FC9, 0x9ECD, 0,
    16, 0x2FCA, 0x9ED1, 0,
    16, 0x2FCB, 0x9EF9, 0,
    16, 0x2FCC, 0x9EFD, 0,
    16, 0x2FCD, 0x9F0E, 0,
    16, 0x2FCE, 0x9F13, 0,
    16, 0x2FCF, 0x9F20, 0,
    16, 0x2FD0, 0x9F3B, 0,
    16, 0x2FD1, 0x9F4A, 0,
    16, 0x2FD2, 0x9F52, 0,
    16, 0x2FD3, 0x9F8D, 0,
    16, 0x2FD4, 0x9F9C, 0,
    16, 0x2FD5, 0x9FA0, 0,
    12, 0x3000, 0x0020, 0,
    16, 0x3036, 0x3012, 0,
    16, 0x3038, 0x5341, 0,
    16, 0x3039, 0x5344, 0,
    16, 0x303A, 0x5345, 0,
    1, 0x304C, 0x304B, 0x3099, 0,
    1, 0x304E, 0x304D, 0x3099, 0,
    1, 0x3050, 0x304F, 0x3099, 0,
    1, 0x3052, 0x3051, 0x3099, 0,
    1, 0x3054, 0x3053, 0x3099, 0,
    1, 0x3056, 0x3055, 0x3099, 0,
    1, 0x3058, 0x3057, 0x3099, 0,
    1, 0x305A, 0x3059, 0x3099, 0,
    1, 0x305C, 0x305B, 0x3099, 0,
    1, 0x305E, 0x305D, 0x3099, 0,
    1, 0x3060, 0x305F, 0x3099, 0,
    1, 0x3062, 0x3061, 0x3099, 0,
    1, 0x3065, 0x3064, 0x3099, 0,
    1, 0x3067, 0x3066, 0x3099, 0,
    1, 0x3069, 0x3068, 0x3099, 0,
    1, 0x3070, 0x306F, 0x3099, 0,
    1, 0x3071, 0x306F, 0x309A, 0,
    1, 0x3073, 0x3072, 0x3099, 0,
    1, 0x3074, 0x3072, 0x309A, 0,
    1, 0x3076, 0x3075, 0x3099, 0,
    1, 0x3077, 0x3075, 0x309A, 0,
    1, 0x3079, 0x3078, 0x3099, 0,
    1, 0x307A, 0x3078, 0x309A, 0,
    1, 0x307C, 0x307B, 0x3099, 0,
    1, 0x307D, 0x307B, 0x309A, 0,
    1, 0x3094, 0x3046, 0x3099, 0,
    16, 0x309B, 0x0020, 0x3099, 0,
    16, 0x309C, 0x0020, 0x309A, 0,
    1, 0x309E, 0x309D, 0x3099, 0,
    1, 0x30AC, 0x30AB, 0x3099, 0,
    1, 0x30AE, 0x30AD, 0x3099, 0,
    1, 0x30B0, 0x30AF, 0x3099, 0,
    1, 0x30B2, 0x30B1, 0x3099, 0,
    1, 0x30B4, 0x30B3, 0x3099, 0,
    1, 0x30B6, 0x30B5, 0x3099, 0,
    1, 0x30B8, 0x30B7, 0x3099, 0,
    1, 0x30BA, 0x30B9, 0x3099, 0,
    1, 0x30BC, 0x30BB, 0x3099, 0,
    1, 0x30BE, 0x30BD, 0x3099, 0,
    1, 0x30C0, 0x30BF, 0x3099, 0,
    1, 0x30C2, 0x30C1, 0x3099, 0,
    1, 0x30C5, 0x30C4, 0x3099, 0,
    1, 0x30C7, 0x30C6, 0x3099, 0,
    1, 0x30C9, 0x30C8, 0x3099, 0,
    1, 0x30D0, 0x30CF, 0x3099, 0,
    1, 0x30D1, 0x30CF, 0x309A, 0,
    1, 0x30D3, 0x30D2, 0x3099, 0,
    1, 0x30D4, 0x30D2, 0x309A, 0,
    1, 0x30D6, 0x30D5, 0x3099, 0,
    1, 0x30D7, 0x30D5, 0x309A, 0,
    1, 0x30D9, 0x30D8, 0x3099, 0,
    1, 0x30DA, 0x30D8, 0x309A, 0,
    1, 0x30DC, 0x30DB, 0x3099, 0,
    1, 0x30DD, 0x30DB, 0x309A, 0,
    1, 0x30F4, 0x30A6, 0x3099, 0,
    1, 0x30F7, 0x30EF, 0x3099, 0,
    1, 0x30F8, 0x30F0, 0x3099, 0,
    1, 0x30F9, 0x30F1, 0x3099, 0,
    1, 0x30FA, 0x30F2, 0x3099, 0,
    1, 0x30FE, 0x30FD, 0x3099, 0,
    16, 0x3131, 0x1100, 0,
    16, 0x3132, 0x1101, 0,
    16, 0x3133, 0x11AA, 0,
    16, 0x3134, 0x1102, 0,
    16, 0x3135, 0x11AC, 0,
    16, 0x3136, 0x11AD, 0,
    16, 0x3137, 0x1103, 0,
    16, 0x3138, 0x1104, 0,
    16, 0x3139, 0x1105, 0,
    16, 0x313A, 0x11B0, 0,
    16, 0x313B, 0x11B1, 0,
    16, 0x313C, 0x11B2, 0,
    16, 0x313D, 0x11B3, 0,
    16, 0x313E, 0x11B4, 0,
    16, 0x313F, 0x11B5, 0,
    16, 0x3140, 0x111A, 0,
    16, 0x3141, 0x1106, 0,
    16, 0x3142, 0x1107, 0,
    16, 0x3143, 0x1108, 0,
    16, 0x3144, 0x1121, 0,
    16, 0x3145, 0x1109, 0,
    16, 0x3146, 0x110A, 0,
    16, 0x3147, 0x110B, 0,
    16, 0x3148, 0x110C, 0,
    16, 0x3149, 0x110D, 0,
    16, 0x314A, 0x110E, 0,
    16, 0x314B, 0x110F, 0,
    16, 0x314C, 0x1110, 0,
    16, 0x314D, 0x1111, 0,
    16, 0x314E, 0x1112, 0,
    16, 0x314F, 0x1161, 0,
    16, 0x3150, 0x1162, 0,
    16, 0x3151, 0x1163, 0,
    16, 0x3152, 0x1164, 0,
    16, 0x3153, 0x1165, 0,
    16, 0x3154, 0x1166, 0,
    16, 0x3155, 0x1167, 0,
    16, 0x3156, 0x1168, 0,
    16, 0x3157, 0x1169, 0,
    16, 0x3158, 0x116A, 0,
    16, 0x3159, 0x116B, 0,
    16, 0x315A, 0x116C, 0,
    16, 0x315B, 0x116D, 0,
    16, 0x315C, 0x116E, 0,
    16, 0x315D, 0x116F, 0,
    16, 0x315E, 0x1170, 0,
    16, 0x315F, 0x1171, 0,
    16, 0x3160, 0x1172, 0,
    16, 0x3161, 0x1173, 0,
    16, 0x3162, 0x1174, 0,
    16, 0x3163, 0x1175, 0,
    16, 0x3164, 0x1160, 0,
    16, 0x3165, 0x1114, 0,
    16, 0x3166, 0x1115, 0,
    16, 0x3167, 0x11C7, 0,
    16, 0x3168, 0x11C8, 0,
    16, 0x3169, 0x11CC, 0,
    16, 0x316A, 0x11CE, 0,
    16, 0x316B, 0x11D3, 0,
    16, 0x316C, 0x11D7, 0,
    16, 0x316D, 0x11D9, 0,
    16, 0x316E, 0x111C, 0,
    16, 0x316F, 0x11DD, 0,
    16, 0x3170, 0x11DF, 0,
    16, 0x3171, 0x111D, 0,
    16, 0x3172, 0x111E, 0,
    16, 0x3173, 0x1120, 0,
    16, 0x3174, 0x1122, 0,
    16, 0x3175, 0x1123, 0,
    16, 0x3176, 0x1127, 0,
    16, 0x3177, 0x1129, 0,
    16, 0x3178, 0x112B, 0,
    16, 0x3179, 0x112C, 0,
    16, 0x317A, 0x112D, 0,
    16, 0x317B, 0x112E, 0,
    16, 0x317C, 0x112F, 0,
    16, 0x317D, 0x1132, 0,
    16, 0x317E, 0x1136, 0,
    16, 0x317F, 0x1140, 0,
    16, 0x3180, 0x1147, 0,
    16, 0x3181, 0x114C, 0,
    16, 0x3182, 0x11F1, 0,
    16, 0x3183, 0x11F2, 0,
    16, 0x3184, 0x1157, 0,
    16, 0x3185, 0x1158, 0,
    16, 0x3186, 0x1159, 0,
    16, 0x3187, 0x1184, 0,
    16, 0x3188, 0x1185, 0,
    16, 0x3189, 0x1188, 0,
    16, 0x318A, 0x1191, 0,
    16, 0x318B, 0x1192, 0,
    16, 0x318C, 0x1194, 0,
    16, 0x318D, 0x119E, 0,
    16, 0x318E, 0x11A1, 0,
    9, 0x3192, 0x4E00, 0,
    9, 0x3193, 0x4E8C, 0,
    9, 0x3194, 0x4E09, 0,
    9, 0x3195, 0x56DB, 0,
    9, 0x3196, 0x4E0A, 0,
    9, 0x3197, 0x4E2D, 0,
    9, 0x3198, 0x4E0B, 0,
    9, 0x3199, 0x7532, 0,
    9, 0x319A, 0x4E59, 0,
    9, 0x319B, 0x4E19, 0,
    9, 0x319C, 0x4E01, 0,
    9, 0x319D, 0x5929, 0,
    9, 0x319E, 0x5730, 0,
    9, 0x319F, 0x4EBA, 0,
    16, 0x3200, 0x0028, 0x1100, 0x0029, 0,
    16, 0x3201, 0x0028, 0x1102, 0x0029, 0,
    16, 0x3202, 0x0028, 0x1103, 0x0029, 0,
    16, 0x3203, 0x0028, 0x1105, 0x0029, 0,
    16, 0x3204, 0x0028, 0x1106, 0x0029, 0,
    16, 0x3205, 0x0028, 0x1107, 0x0029, 0,
    16, 0x3206, 0x0028, 0x1109, 0x0029, 0,
    16, 0x3207, 0x0028, 0x110B, 0x0029, 0,
    16, 0x3208, 0x0028, 0x110C, 0x0029, 0,
    16, 0x3209, 0x0028, 0x110E, 0x0029, 0,
    16, 0x320A, 0x0028, 0x110F, 0x0029, 0,
    16, 0x320B, 0x0028, 0x1110, 0x0029, 0,
    16, 0x320C, 0x0028, 0x1111, 0x0029, 0,
    16, 0x320D, 0x0028, 0x1112, 0x0029, 0,
    16, 0x320E, 0x0028, 0x1100, 0x1161, 0x0029, 0,
    16, 0x320F, 0x0028, 0x1102, 0x1161, 0x0029, 0,
    16, 0x3210, 0x0028, 0x1103, 0x1161, 0x0029, 0,
    16, 0x3211, 0x0028, 0x1105, 0x1161, 0x0029, 0,
    16, 0x3212, 0x0028, 0x1106, 0x1161, 0x0029, 0,
    16, 0x3213, 0x0028, 0x1107, 0x1161, 0x0029, 0,
    16, 0x3214, 0x0028, 0x1109, 0x1161, 0x0029, 0,
    16, 0x3215, 0x0028, 0x110B, 0x1161, 0x0029, 0,
    16, 0x3216, 0x0028, 0x110C, 0x1161, 0x0029, 0,
    16, 0x3217, 0x0028, 0x110E, 0x1161, 0x0029, 0,
    16, 0x3218, 0x0028, 0x110F, 0x1161, 0x0029, 0,
    16, 0x3219, 0x0028, 0x1110, 0x1161, 0x0029, 0,
    16, 0x321A, 0x0028, 0x1111, 0x1161, 0x0029, 0,
    16, 0x321B, 0x0028, 0x1112, 0x1161, 0x0029, 0,
    16, 0x321C, 0x0028, 0x110C, 0x116E, 0x0029, 0,
    16, 0x3220, 0x0028, 0x4E00, 0x0029, 0,
    16, 0x3221, 0x0028, 0x4E8C, 0x0029, 0,
    16, 0x3222, 0x0028, 0x4E09, 0x0029, 0,
    16, 0x3223, 0x0028, 0x56DB, 0x0029, 0,
    16, 0x3224, 0x0028, 0x4E94, 0x0029, 0,
    16, 0x3225, 0x0028, 0x516D, 0x0029, 0,
    16, 0x3226, 0x0028, 0x4E03, 0x0029, 0,
    16, 0x3227, 0x0028, 0x516B, 0x0029, 0,
    16, 0x3228, 0x0028, 0x4E5D, 0x0029, 0,
    16, 0x3229, 0x0028, 0x5341, 0x0029, 0,
    16, 0x322A, 0x0028, 0x6708, 0x0029, 0,
    16, 0x322B, 0x0028, 0x706B, 0x0029, 0,
    16, 0x322C, 0x0028, 0x6C34, 0x0029, 0,
    16, 0x322D, 0x0028, 0x6728, 0x0029, 0,
    16, 0x322E, 0x0028, 0x91D1, 0x0029, 0,
    16, 0x322F, 0x0028, 0x571F, 0x0029, 0,
    16, 0x3230, 0x0028, 0x65E5, 0x0029, 0,
    16, 0x3231, 0x0028, 0x682A, 0x0029, 0,
    16, 0x3232, 0x0028, 0x6709, 0x0029, 0,
    16, 0x3233, 0x0028, 0x793E, 0x0029, 0,
    16, 0x3234, 0x0028, 0x540D, 0x0029, 0,
    16, 0x3235, 0x0028, 0x7279, 0x0029, 0,
    16, 0x3236, 0x0028, 0x8CA1, 0x0029, 0,
    16, 0x3237, 0x0028, 0x795D, 0x0029, 0,
    16, 0x3238, 0x0028, 0x52B4, 0x0029, 0,
    16, 0x3239, 0x0028, 0x4EE3, 0x0029, 0,
    16, 0x323A, 0x0028, 0x547C, 0x0029, 0,
    16, 0x323B, 0x0028, 0x5B66, 0x0029, 0,
    16, 0x323C, 0x0028, 0x76E3, 0x0029, 0,
    16, 0x323D, 0x0028, 0x4F01, 0x0029, 0,
    16, 0x323E, 0x0028, 0x8CC7, 0x0029, 0,
    16, 0x323F, 0x0028, 0x5354, 0x0029, 0,
    16, 0x3240, 0x0028, 0x796D, 0x0029, 0,
    16, 0x3241, 0x0028, 0x4F11, 0x0029, 0,
    16, 0x3242, 0x0028, 0x81EA, 0x0029, 0,
    16, 0x3243, 0x0028, 0x81F3, 0x0029, 0,
    8, 0x3260, 0x1100, 0,
    8, 0x3261, 0x1102, 0,
    8, 0x3262, 0x1103, 0,
    8, 0x3263, 0x1105, 0,
    8, 0x3264, 0x1106, 0,
    8, 0x3265, 0x1107, 0,
    8, 0x3266, 0x1109, 0,
    8, 0x3267, 0x110B, 0,
    8, 0x3268, 0x110C, 0,
    8, 0x3269, 0x110E, 0,
    8, 0x326A, 0x110F, 0,
    8, 0x326B, 0x1110, 0,
    8, 0x326C, 0x1111, 0,
    8, 0x326D, 0x1112, 0,
    8, 0x326E, 0x1100, 0x1161, 0,
    8, 0x326F, 0x1102, 0x1161, 0,
    8, 0x3270, 0x1103, 0x1161, 0,
    8, 0x3271, 0x1105, 0x1161, 0,
    8, 0x3272, 0x1106, 0x1161, 0,
    8, 0x3273, 0x1107, 0x1161, 0,
    8, 0x3274, 0x1109, 0x1161, 0,
    8, 0x3275, 0x110B, 0x1161, 0,
    8, 0x3276, 0x110C, 0x1161, 0,
    8, 0x3277, 0x110E, 0x1161, 0,
    8, 0x3278, 0x110F, 0x1161, 0,
    8, 0x3279, 0x1110, 0x1161, 0,
    8, 0x327A, 0x1111, 0x1161, 0,
    8, 0x327B, 0x1112, 0x1161, 0,
    8, 0x3280, 0x4E00, 0,
    8, 0x3281, 0x4E8C, 0,
    8, 0x3282, 0x4E09, 0,
    8, 0x3283, 0x56DB, 0,
    8, 0x3284, 0x4E94, 0,
    8, 0x3285, 0x516D, 0,
    8, 0x3286, 0x4E03, 0,
    8, 0x3287, 0x516B, 0,
    8, 0x3288, 0x4E5D, 0,
    8, 0x3289, 0x5341, 0,
    8, 0x328A, 0x6708, 0,
    8, 0x328B, 0x706B, 0,
    8, 0x328C, 0x6C34, 0,
    8, 0x328D, 0x6728, 0,
    8, 0x328E, 0x91D1, 0,
    8, 0x328F, 0x571F, 0,
    8, 0x3290, 0x65E5, 0,
    8, 0x3291, 0x682A, 0,
    8, 0x3292, 0x6709, 0,
    8, 0x3293, 0x793E, 0,
    8, 0x3294, 0x540D, 0,
    8, 0x3295, 0x7279, 0,
    8, 0x3296, 0x8CA1, 0,
    8, 0x3297, 0x795D, 0,
    8, 0x3298, 0x52B4, 0,
    8, 0x3299, 0x79D8, 0,
    8, 0x329A, 0x7537, 0,
    8, 0x329B, 0x5973, 0,
    8, 0x329C, 0x9069, 0,
    8, 0x329D, 0x512A, 0,
    8, 0x329E, 0x5370, 0,
    8, 0x329F, 0x6CE8, 0,
    8, 0x32A0, 0x9805, 0,
    8, 0x32A1, 0x4F11, 0,
    8, 0x32A2, 0x5199, 0,
    8, 0x32A3, 0x6B63, 0,
    8, 0x32A4, 0x4E0A, 0,
    8, 0x32A5, 0x4E2D, 0,
    8, 0x32A6, 0x4E0B, 0,
    8, 0x32A7, 0x5DE6, 0,
    8, 0x32A8, 0x53F3, 0,
    8, 0x32A9, 0x533B, 0,
    8, 0x32AA, 0x5B97, 0,
    8, 0x32AB, 0x5B66, 0,
    8, 0x32AC, 0x76E3, 0,
    8, 0x32AD, 0x4F01, 0,
    8, 0x32AE, 0x8CC7, 0,
    8, 0x32AF, 0x5354, 0,
    8, 0x32B0, 0x591C, 0,
    16, 0x32C0, 0x0031, 0x6708, 0,
    16, 0x32C1, 0x0032, 0x6708, 0,
    16, 0x32C2, 0x0033, 0x6708, 0,
    16, 0x32C3, 0x0034, 0x6708, 0,
    16, 0x32C4, 0x0035, 0x6708, 0,
    16, 0x32C5, 0x0036, 0x6708, 0,
    16, 0x32C6, 0x0037, 0x6708, 0,
    16, 0x32C7, 0x0038, 0x6708, 0,
    16, 0x32C8, 0x0039, 0x6708, 0,
    16, 0x32C9, 0x0031, 0x0030, 0x6708, 0,
    16, 0x32CA, 0x0031, 0x0031, 0x6708, 0,
    16, 0x32CB, 0x0031, 0x0032, 0x6708, 0,
    8, 0x32D0, 0x30A2, 0,
    8, 0x32D1, 0x30A4, 0,
    8, 0x32D2, 0x30A6, 0,
    8, 0x32D3, 0x30A8, 0,
    8, 0x32D4, 0x30AA, 0,
    8, 0x32D5, 0x30AB, 0,
    8, 0x32D6, 0x30AD, 0,
    8, 0x32D7, 0x30AF, 0,
    8, 0x32D8, 0x30B1, 0,
    8, 0x32D9, 0x30B3, 0,
    8, 0x32DA, 0x30B5, 0,
    8, 0x32DB, 0x30B7, 0,
    8, 0x32DC, 0x30B9, 0,
    8, 0x32DD, 0x30BB, 0,
    8, 0x32DE, 0x30BD, 0,
    8, 0x32DF, 0x30BF, 0,
    8, 0x32E0, 0x30C1, 0,
    8, 0x32E1, 0x30C4, 0,
    8, 0x32E2, 0x30C6, 0,
    8, 0x32E3, 0x30C8, 0,
    8, 0x32E4, 0x30CA, 0,
    8, 0x32E5, 0x30CB, 0,
    8, 0x32E6, 0x30CC, 0,
    8, 0x32E7, 0x30CD, 0,
    8, 0x32E8, 0x30CE, 0,
    8, 0x32E9, 0x30CF, 0,
    8, 0x32EA, 0x30D2, 0,
    8, 0x32EB, 0x30D5, 0,
    8, 0x32EC, 0x30D8, 0,
    8, 0x32ED, 0x30DB, 0,
    8, 0x32EE, 0x30DE, 0,
    8, 0x32EF, 0x30DF, 0,
    8, 0x32F0, 0x30E0, 0,
    8, 0x32F1, 0x30E1, 0,
    8, 0x32F2, 0x30E2, 0,
    8, 0x32F3, 0x30E4, 0,
    8, 0x32F4, 0x30E6, 0,
    8, 0x32F5, 0x30E8, 0,
    8, 0x32F6, 0x30E9, 0,
    8, 0x32F7, 0x30EA, 0,
    8, 0x32F8, 0x30EB, 0,
    8, 0x32F9, 0x30EC, 0,
    8, 0x32FA, 0x30ED, 0,
    8, 0x32FB, 0x30EF, 0,
    8, 0x32FC, 0x30F0, 0,
    8, 0x32FD, 0x30F1, 0,
    8, 0x32FE, 0x30F2, 0,
    15, 0x3300, 0x30A2, 0x30D1, 0x30FC, 0x30C8, 0,
    15, 0x3301, 0x30A2, 0x30EB, 0x30D5, 0x30A1, 0,
    15, 0x3302, 0x30A2, 0x30F3, 0x30DA, 0x30A2, 0,
    15, 0x3303, 0x30A2, 0x30FC, 0x30EB, 0,
    15, 0x3304, 0x30A4, 0x30CB, 0x30F3, 0x30B0, 0,
    15, 0x3305, 0x30A4, 0x30F3, 0x30C1, 0,
    15, 0x3306, 0x30A6, 0x30A9, 0x30F3, 0,
    15, 0x3307, 0x30A8, 0x30B9, 0x30AF, 0x30FC, 0x30C9, 0,
    15, 0x3308, 0x30A8, 0x30FC, 0x30AB, 0x30FC, 0,
    15, 0x3309, 0x30AA, 0x30F3, 0x30B9, 0,
    15, 0x330A, 0x30AA, 0x30FC, 0x30E0, 0,
    15, 0x330B, 0x30AB, 0x30A4, 0x30EA, 0,
    15, 0x330C, 0x30AB, 0x30E9, 0x30C3, 0x30C8, 0,
    15, 0x330D, 0x30AB, 0x30ED, 0x30EA, 0x30FC, 0,
    15, 0x330E, 0x30AC, 0x30ED, 0x30F3, 0,
    15, 0x330F, 0x30AC, 0x30F3, 0x30DE, 0,
    15, 0x3310, 0x30AE, 0x30AC, 0,
    15, 0x3311, 0x30AE, 0x30CB, 0x30FC, 0,
    15, 0x3312, 0x30AD, 0x30E5, 0x30EA, 0x30FC, 0,
    15, 0x3313, 0x30AE, 0x30EB, 0x30C0, 0x30FC, 0,
    15, 0x3314, 0x30AD, 0x30ED, 0,
    15, 0x3315, 0x30AD, 0x30ED, 0x30B0, 0x30E9, 0x30E0, 0,
    15, 0x3316, 0x30AD, 0x30ED, 0x30E1, 0x30FC, 0x30C8, 0x30EB, 0,
    15, 0x3317, 0x30AD, 0x30ED, 0x30EF, 0x30C3, 0x30C8, 0,
    15, 0x3318, 0x30B0, 0x30E9, 0x30E0, 0,
    15, 0x3319, 0x30B0, 0x30E9, 0x30E0, 0x30C8, 0x30F3, 0,
    15, 0x331A, 0x30AF, 0x30EB, 0x30BC, 0x30A4, 0x30ED, 0,
    15, 0x331B, 0x30AF, 0x30ED, 0x30FC, 0x30CD, 0,
    15, 0x331C, 0x30B1, 0x30FC, 0x30B9, 0,
    15, 0x331D, 0x30B3, 0x30EB, 0x30CA, 0,
    15, 0x331E, 0x30B3, 0x30FC, 0x30DD, 0,
    15, 0x331F, 0x30B5, 0x30A4, 0x30AF, 0x30EB, 0,
    15, 0x3320, 0x30B5, 0x30F3, 0x30C1, 0x30FC, 0x30E0, 0,
    15, 0x3321, 0x30B7, 0x30EA, 0x30F3, 0x30B0, 0,
    15, 0x3322, 0x30BB, 0x30F3, 0x30C1, 0,
    15, 0x3323, 0x30BB, 0x30F3, 0x30C8, 0,
    15, 0x3324, 0x30C0, 0x30FC, 0x30B9, 0,
    15, 0x3325, 0x30C7, 0x30B7, 0,
    15, 0x3326, 0x30C9, 0x30EB, 0,
    15, 0x3327, 0x30C8, 0x30F3, 0,
    15, 0x3328, 0x30CA, 0x30CE, 0,
    15, 0x3329, 0x30CE, 0x30C3, 0x30C8, 0,
    15, 0x332A, 0x30CF, 0x30A4, 0x30C4, 0,
    15, 0x332B, 0x30D1, 0x30FC, 0x30BB, 0x30F3, 0x30C8, 0,
    15, 0x332C, 0x30D1, 0x30FC, 0x30C4, 0,
    15, 0x332D, 0x30D0, 0x30FC, 0x30EC, 0x30EB, 0,
    15, 0x332E, 0x30D4, 0x30A2, 0x30B9, 0x30C8, 0x30EB, 0,
    15, 0x332F, 0x30D4, 0x30AF, 0x30EB, 0,
    15, 0x3330, 0x30D4, 0x30B3, 0,
    15, 0x3331, 0x30D3, 0x30EB, 0,
    15, 0x3332, 0x30D5, 0x30A1, 0x30E9, 0x30C3, 0x30C9, 0,
    15, 0x3333, 0x30D5, 0x30A3, 0x30FC, 0x30C8, 0,
    15, 0x3334, 0x30D6, 0x30C3, 0x30B7, 0x30A7, 0x30EB, 0,
    15, 0x3335, 0x30D5, 0x30E9, 0x30F3, 0,
    15, 0x3336, 0x30D8, 0x30AF, 0x30BF, 0x30FC, 0x30EB, 0,
    15, 0x3337, 0x30DA, 0x30BD, 0,
    15, 0x3338, 0x30DA, 0x30CB, 0x30D2, 0,
    15, 0x3339, 0x30D8, 0x30EB, 0x30C4, 0,
    15, 0x333A, 0x30DA, 0x30F3, 0x30B9, 0,
    15, 0x333B, 0x30DA, 0x30FC, 0x30B8, 0,
    15, 0x333C, 0x30D9, 0x30FC, 0x30BF, 0,
    15, 0x333D, 0x30DD, 0x30A4, 0x30F3, 0x30C8, 0,
    15, 0x333E, 0x30DC, 0x30EB, 0x30C8, 0,
    15, 0x333F, 0x30DB, 0x30F3, 0,
    15, 0x3340, 0x30DD, 0x30F3, 0x30C9, 0,
    15, 0x3341, 0x30DB, 0x30FC, 0x30EB, 0,
    15, 0x3342, 0x30DB, 0x30FC, 0x30F3, 0,
    15, 0x3343, 0x30DE, 0x30A4, 0x30AF, 0x30ED, 0,
    15, 0x3344, 0x30DE, 0x30A4, 0x30EB, 0,
    15, 0x3345, 0x30DE, 0x30C3, 0x30CF, 0,
    15, 0x3346, 0x30DE, 0x30EB, 0x30AF, 0,
    15, 0x3347, 0x30DE, 0x30F3, 0x30B7, 0x30E7, 0x30F3, 0,
    15, 0x3348, 0x30DF, 0x30AF, 0x30ED, 0x30F3, 0,
    15, 0x3349, 0x30DF, 0x30EA, 0,
    15, 0x334A, 0x30DF, 0x30EA, 0x30D0, 0x30FC, 0x30EB, 0,
    15, 0x334B, 0x30E1, 0x30AC, 0,
    15, 0x334C, 0x30E1, 0x30AC, 0x30C8, 0x30F3, 0,
    15, 0x334D, 0x30E1, 0x30FC, 0x30C8, 0x30EB, 0,
    15, 0x334E, 0x30E4, 0x30FC, 0x30C9, 0,
    15, 0x334F, 0x30E4, 0x30FC, 0x30EB, 0,
    15, 0x3350, 0x30E6, 0x30A2, 0x30F3, 0,
    15, 0x3351, 0x30EA, 0x30C3, 0x30C8, 0x30EB, 0,
    15, 0x3352, 0x30EA, 0x30E9, 0,
    15, 0x3353, 0x30EB, 0x30D4, 0x30FC, 0,
    15, 0x3354, 0x30EB, 0x30FC, 0x30D6, 0x30EB, 0,
    15, 0x3355, 0x30EC, 0x30E0, 0,
    15, 0x3356, 0x30EC, 0x30F3, 0x30C8, 0x30B2, 0x30F3, 0,
    15, 0x3357, 0x30EF, 0x30C3, 0x30C8, 0,
    16, 0x3358, 0x0030, 0x70B9, 0,
    16, 0x3359, 0x0031, 0x70B9, 0,
    16, 0x335A, 0x0032, 0x70B9, 0,
    16, 0x335B, 0x0033, 0x70B9, 0,
    16, 0x335C, 0x0034, 0x70B9, 0,
    16, 0x335D, 0x0035, 0x70B9, 0,
    16, 0x335E, 0x0036, 0x70B9, 0,
    16, 0x335F, 0x0037, 0x70B9, 0,
    16, 0x3360, 0x0038, 0x70B9, 0,
    16, 0x3361, 0x0039, 0x70B9, 0,
    16, 0x3362, 0x0031, 0x0030, 0x70B9, 0,
    16, 0x3363, 0x0031, 0x0031, 0x70B9, 0,
    16, 0x3364, 0x0031, 0x0032, 0x70B9, 0,
    16, 0x3365, 0x0031, 0x0033, 0x70B9, 0,
    16, 0x3366, 0x0031, 0x0034, 0x70B9, 0,
    16, 0x3367, 0x0031, 0x0035, 0x70B9, 0,
    16, 0x3368, 0x0031, 0x0036, 0x70B9, 0,
    16, 0x3369, 0x0031, 0x0037, 0x70B9, 0,
    16, 0x336A, 0x0031, 0x0038, 0x70B9, 0,
    16, 0x336B, 0x0031, 0x0039, 0x70B9, 0,
    16, 0x336C, 0x0032, 0x0030, 0x70B9, 0,
    16, 0x336D, 0x0032, 0x0031, 0x70B9, 0,
    16, 0x336E, 0x0032, 0x0032, 0x70B9, 0,
    16, 0x336F, 0x0032, 0x0033, 0x70B9, 0,
    16, 0x3370, 0x0032, 0x0034, 0x70B9, 0,
    15, 0x3371, 0x0068, 0x0050, 0x0061, 0,
    15, 0x3372, 0x0064, 0x0061, 0,
    15, 0x3373, 0x0041, 0x0055, 0,
    15, 0x3374, 0x0062, 0x0061, 0x0072, 0,
    15, 0x3375, 0x006F, 0x0056, 0,
    15, 0x3376, 0x0070, 0x0063, 0,
    15, 0x337B, 0x5E73, 0x6210, 0,
    15, 0x337C, 0x662D, 0x548C, 0,
    15, 0x337D, 0x5927, 0x6B63, 0,
    15, 0x337E, 0x660E, 0x6CBB, 0,
    15, 0x337F, 0x682A, 0x5F0F, 0x4F1A, 0x793E, 0,
    15, 0x3380, 0x0070, 0x0041, 0,
    15, 0x3381, 0x006E, 0x0041, 0,
    15, 0x3382, 0x03BC, 0x0041, 0,
    15, 0x3383, 0x006D, 0x0041, 0,
    15, 0x3384, 0x006B, 0x0041, 0,
    15, 0x3385, 0x004B, 0x0042, 0,
    15, 0x3386, 0x004D, 0x0042, 0,
    15, 0x3387, 0x0047, 0x0042, 0,
    15, 0x3388, 0x0063, 0x0061, 0x006C, 0,
    15, 0x3389, 0x006B, 0x0063, 0x0061, 0x006C, 0,
    15, 0x338A, 0x0070, 0x0046, 0,
    15, 0x338B, 0x006E, 0x0046, 0,
    15, 0x338C, 0x03BC, 0x0046, 0,
    15, 0x338D, 0x03BC, 0x0067, 0,
    15, 0x338E, 0x006D, 0x0067, 0,
    15, 0x338F, 0x006B, 0x0067, 0,
    15, 0x3390, 0x0048, 0x007A, 0,
    15, 0x3391, 0x006B, 0x0048, 0x007A, 0,
    15, 0x3392, 0x004D, 0x0048, 0x007A, 0,
    15, 0x3393, 0x0047, 0x0048, 0x007A, 0,
    15, 0x3394, 0x0054, 0x0048, 0x007A, 0,
    15, 0x3395, 0x03BC, 0x2113, 0,
    15, 0x3396, 0x006D, 0x2113, 0,
    15, 0x3397, 0x0064, 0x2113, 0,
    15, 0x3398, 0x006B, 0x2113, 0,
    15, 0x3399, 0x0066, 0x006D, 0,
    15, 0x339A, 0x006E, 0x006D, 0,
    15, 0x339B, 0x03BC, 0x006D, 0,
    15, 0x339C, 0x006D, 0x006D, 0,
    15, 0x339D, 0x0063, 0x006D, 0,
    15, 0x339E, 0x006B, 0x006D, 0,
    15, 0x339F, 0x006D, 0x006D, 0x00B2, 0,
    15, 0x33A0, 0x0063, 0x006D, 0x00B2, 0,
    15, 0x33A1, 0x006D, 0x00B2, 0,
    15, 0x33A2, 0x006B, 0x006D, 0x00B2, 0,
    15, 0x33A3, 0x006D, 0x006D, 0x00B3, 0,
    15, 0x33A4, 0x0063, 0x006D, 0x00B3, 0,
    15, 0x33A5, 0x006D, 0x00B3, 0,
    15, 0x33A6, 0x006B, 0x006D, 0x00B3, 0,
    15, 0x33A7, 0x006D, 0x2215, 0x0073, 0,
    15, 0x33A8, 0x006D, 0x2215, 0x0073, 0x00B2, 0,
    15, 0x33A9, 0x0050, 0x0061, 0,
    15, 0x33AA, 0x006B, 0x0050, 0x0061, 0,
    15, 0x33AB, 0x004D, 0x0050, 0x0061, 0,
    15, 0x33AC, 0x0047, 0x0050, 0x0061, 0,
    15, 0x33AD, 0x0072, 0x0061, 0x0064, 0,
    15, 0x33AE, 0x0072, 0x0061, 0x0064, 0x2215, 0x0073, 0,
    15, 0x33AF, 0x0072, 0x0061, 0x0064, 0x2215, 0x0073, 0x00B2, 0,
    15, 0x33B0, 0x0070, 0x0073, 0,
    15, 0x33B1, 0x006E, 0x0073, 0,
    15, 0x33B2, 0x03BC, 0x0073, 0,
    15, 0x33B3, 0x006D, 0x0073, 0,
    15, 0x33B4, 0x0070, 0x0056, 0,
    15, 0x33B5, 0x006E, 0x0056, 0,
    15, 0x33B6, 0x03BC, 0x0056, 0,
    15, 0x33B7, 0x006D, 0x0056, 0,
    15, 0x33B8, 0x006B, 0x0056, 0,
    15, 0x33B9, 0x004D, 0x0056, 0,
    15, 0x33BA, 0x0070, 0x0057, 0,
    15, 0x33BB, 0x006E, 0x0057, 0,
    15, 0x33BC, 0x03BC, 0x0057, 0,
    15, 0x33BD, 0x006D, 0x0057, 0,
    15, 0x33BE, 0x006B, 0x0057, 0,
    15, 0x33BF, 0x004D, 0x0057, 0,
    15, 0x33C0, 0x006B, 0x03A9, 0,
    15, 0x33C1, 0x004D, 0x03A9, 0,
    15, 0x33C2, 0x0061, 0x002E, 0x006D, 0x002E, 0,
    15, 0x33C3, 0x0042, 0x0071, 0,
    15, 0x33C4, 0x0063, 0x0063, 0,
    15, 0x33C5, 0x0063, 0x0064, 0,
    15, 0x33C6, 0x0043, 0x2215, 0x006B, 0x0067, 0,
    15, 0x33C7, 0x0043, 0x006F, 0x002E, 0,
    15, 0x33C8, 0x0064, 0x0042, 0,
    15, 0x33C9, 0x0047, 0x0079, 0,
    15, 0x33CA, 0x0068, 0x0061, 0,
    15, 0x33CB, 0x0048, 0x0050, 0,
    15, 0x33CC, 0x0069, 0x006E, 0,
    15, 0x33CD, 0x004B, 0x004B, 0,
    15, 0x33CE, 0x004B, 0x004D, 0,
    15, 0x33CF, 0x006B, 0x0074, 0,
    15, 0x33D0, 0x006C, 0x006D, 0,
    15, 0x33D1, 0x006C, 0x006E, 0,
    15, 0x33D2, 0x006C, 0x006F, 0x0067, 0,
    15, 0x33D3, 0x006C, 0x0078, 0,
    15, 0x33D4, 0x006D, 0x0062, 0,
    15, 0x33D5, 0x006D, 0x0069, 0x006C, 0,
    15, 0x33D6, 0x006D, 0x006F, 0x006C, 0,
    15, 0x33D7, 0x0050, 0x0048, 0,
    15, 0x33D8, 0x0070, 0x002E, 0x006D, 0x002E, 0,
    15, 0x33D9, 0x0050, 0x0050, 0x004D, 0,
    15, 0x33DA, 0x0050, 0x0052, 0,
    15, 0x33DB, 0x0073, 0x0072, 0,
    15, 0x33DC, 0x0053, 0x0076, 0,
    15, 0x33DD, 0x0057, 0x0062, 0,
    16, 0x33E0, 0x0031, 0x65E5, 0,
    16, 0x33E1, 0x0032, 0x65E5, 0,
    16, 0x33E2, 0x0033, 0x65E5, 0,
    16, 0x33E3, 0x0034, 0x65E5, 0,
    16, 0x33E4, 0x0035, 0x65E5, 0,
    16, 0x33E5, 0x0036, 0x65E5, 0,
    16, 0x33E6, 0x0037, 0x65E5, 0,
    16, 0x33E7, 0x0038, 0x65E5, 0,
    16, 0x33E8, 0x0039, 0x65E5, 0,
    16, 0x33E9, 0x0031, 0x0030, 0x65E5, 0,
    16, 0x33EA, 0x0031, 0x0031, 0x65E5, 0,
    16, 0x33EB, 0x0031, 0x0032, 0x65E5, 0,
    16, 0x33EC, 0x0031, 0x0033, 0x65E5, 0,
    16, 0x33ED, 0x0031, 0x0034, 0x65E5, 0,
    16, 0x33EE, 0x0031, 0x0035, 0x65E5, 0,
    16, 0x33EF, 0x0031, 0x0036, 0x65E5, 0,
    16, 0x33F0, 0x0031, 0x0037, 0x65E5, 0,
    16, 0x33F1, 0x0031, 0x0038, 0x65E5, 0,
    16, 0x33F2, 0x0031, 0x0039, 0x65E5, 0,
    16, 0x33F3, 0x0032, 0x0030, 0x65E5, 0,
    16, 0x33F4, 0x0032, 0x0031, 0x65E5, 0,
    16, 0x33F5, 0x0032, 0x0032, 0x65E5, 0,
    16, 0x33F6, 0x0032, 0x0033, 0x65E5, 0,
    16, 0x33F7, 0x0032, 0x0034, 0x65E5, 0,
    16, 0x33F8, 0x0032, 0x0035, 0x65E5, 0,
    16, 0x33F9, 0x0032, 0x0036, 0x65E5, 0,
    16, 0x33FA, 0x0032, 0x0037, 0x65E5, 0,
    16, 0x33FB, 0x0032, 0x0038, 0x65E5, 0,
    16, 0x33FC, 0x0032, 0x0039, 0x65E5, 0,
    16, 0x33FD, 0x0033, 0x0030, 0x65E5, 0,
    16, 0x33FE, 0x0033, 0x0031, 0x65E5, 0,
    1, 0xF900, 0x8C48, 0,
    1, 0xF901, 0x66F4, 0,
    1, 0xF902, 0x8ECA, 0,
    1, 0xF903, 0x8CC8, 0,
    1, 0xF904, 0x6ED1, 0,
    1, 0xF905, 0x4E32, 0,
    1, 0xF906, 0x53E5, 0,
    1, 0xF907, 0x9F9C, 0,
    1, 0xF908, 0x9F9C, 0,
    1, 0xF909, 0x5951, 0,
    1, 0xF90A, 0x91D1, 0,
    1, 0xF90B, 0x5587, 0,
    1, 0xF90C, 0x5948, 0,
    1, 0xF90D, 0x61F6, 0,
    1, 0xF90E, 0x7669, 0,
    1, 0xF90F, 0x7F85, 0,
    1, 0xF910, 0x863F, 0,
    1, 0xF911, 0x87BA, 0,
    1, 0xF912, 0x88F8, 0,
    1, 0xF913, 0x908F, 0,
    1, 0xF914, 0x6A02, 0,
    1, 0xF915, 0x6D1B, 0,
    1, 0xF916, 0x70D9, 0,
    1, 0xF917, 0x73DE, 0,
    1, 0xF918, 0x843D, 0,
    1, 0xF919, 0x916A, 0,
    1, 0xF91A, 0x99F1, 0,
    1, 0xF91B, 0x4E82, 0,
    1, 0xF91C, 0x5375, 0,
    1, 0xF91D, 0x6B04, 0,
    1, 0xF91E, 0x721B, 0,
    1, 0xF91F, 0x862D, 0,
    1, 0xF920, 0x9E1E, 0,
    1, 0xF921, 0x5D50, 0,
    1, 0xF922, 0x6FEB, 0,
    1, 0xF923, 0x85CD, 0,
    1, 0xF924, 0x8964, 0,
    1, 0xF925, 0x62C9, 0,
    1, 0xF926, 0x81D8, 0,
    1, 0xF927, 0x881F, 0,
    1, 0xF928, 0x5ECA, 0,
    1, 0xF929, 0x6717, 0,
    1, 0xF92A, 0x6D6A, 0,
    1, 0xF92B, 0x72FC, 0,
    1, 0xF92C, 0x90CE, 0,
    1, 0xF92D, 0x4F86, 0,
    1, 0xF92E, 0x51B7, 0,
    1, 0xF92F, 0x52DE, 0,
    1, 0xF930, 0x64C4, 0,
    1, 0xF931, 0x6AD3, 0,
    1, 0xF932, 0x7210, 0,
    1, 0xF933, 0x76E7, 0,
    1, 0xF934, 0x8001, 0,
    1, 0xF935, 0x8606, 0,
    1, 0xF936, 0x865C, 0,
    1, 0xF937, 0x8DEF, 0,
    1, 0xF938, 0x9732, 0,
    1, 0xF939, 0x9B6F, 0,
    1, 0xF93A, 0x9DFA, 0,
    1, 0xF93B, 0x788C, 0,
    1, 0xF93C, 0x797F, 0,
    1, 0xF93D, 0x7DA0, 0,
    1, 0xF93E, 0x83C9, 0,
    1, 0xF93F, 0x9304, 0,
    1, 0xF940, 0x9E7F, 0,
    1, 0xF941, 0x8AD6, 0,
    1, 0xF942, 0x58DF, 0,
    1, 0xF943, 0x5F04, 0,
    1, 0xF944, 0x7C60, 0,
    1, 0xF945, 0x807E, 0,
    1, 0xF946, 0x7262, 0,
    1, 0xF947, 0x78CA, 0,
    1, 0xF948, 0x8CC2, 0,
    1, 0xF949, 0x96F7, 0,
    1, 0xF94A, 0x58D8, 0,
    1, 0xF94B, 0x5C62, 0,
    1, 0xF94C, 0x6A13, 0,
    1, 0xF94D, 0x6DDA, 0,
    1, 0xF94E, 0x6F0F, 0,
    1, 0xF94F, 0x7D2F, 0,
    1, 0xF950, 0x7E37, 0,
    1, 0xF951, 0x96FB, 0,
    1, 0xF952, 0x52D2, 0,
    1, 0xF953, 0x808B, 0,
    1, 0xF954, 0x51DC, 0,
    1, 0xF955, 0x51CC, 0,
    1, 0xF956, 0x7A1C, 0,
    1, 0xF957, 0x7DBE, 0,
    1, 0xF958, 0x83F1, 0,
    1, 0xF959, 0x9675, 0,
    1, 0xF95A, 0x8B80, 0,
    1, 0xF95B, 0x62CF, 0,
    1, 0xF95C, 0x6A02, 0,
    1, 0xF95D, 0x8AFE, 0,
    1, 0xF95E, 0x4E39, 0,
    1, 0xF95F, 0x5BE7, 0,
    1, 0xF960, 0x6012, 0,
    1, 0xF961, 0x7387, 0,
    1, 0xF962, 0x7570, 0,
    1, 0xF963, 0x5317, 0,
    1, 0xF964, 0x78FB, 0,
    1, 0xF965, 0x4FBF, 0,
    1, 0xF966, 0x5FA9, 0,
    1, 0xF967, 0x4E0D, 0,
    1, 0xF968, 0x6CCC, 0,
    1, 0xF969, 0x6578, 0,
    1, 0xF96A, 0x7D22, 0,
    1, 0xF96B, 0x53C3, 0,
    1, 0xF96C, 0x585E, 0,
    1, 0xF96D, 0x7701, 0,
    1, 0xF96E, 0x8449, 0,
    1, 0xF96F, 0x8AAA, 0,
    1, 0xF970, 0x6BBA, 0,
    1, 0xF971, 0x8FB0, 0,
    1, 0xF972, 0x6C88, 0,
    1, 0xF973, 0x62FE, 0,
    1, 0xF974, 0x82E5, 0,
    1, 0xF975, 0x63A0, 0,
    1, 0xF976, 0x7565, 0,
    1, 0xF977, 0x4EAE, 0,
    1, 0xF978, 0x5169, 0,
    1, 0xF979, 0x51C9, 0,
    1, 0xF97A, 0x6881, 0,
    1, 0xF97B, 0x7CE7, 0,
    1, 0xF97C, 0x826F, 0,
    1, 0xF97D, 0x8AD2, 0,
    1, 0xF97E, 0x91CF, 0,
    1, 0xF97F, 0x52F5, 0,
    1, 0xF980, 0x5442, 0,
    1, 0xF981, 0x5973, 0,
    1, 0xF982, 0x5EEC, 0,
    1, 0xF983, 0x65C5, 0,
    1, 0xF984, 0x6FFE, 0,
    1, 0xF985, 0x792A, 0,
    1, 0xF986, 0x95AD, 0,
    1, 0xF987, 0x9A6A, 0,
    1, 0xF988, 0x9E97, 0,
    1, 0xF989, 0x9ECE, 0,
    1, 0xF98A, 0x529B, 0,
    1, 0xF98B, 0x66C6, 0,
    1, 0xF98C, 0x6B77, 0,
    1, 0xF98D, 0x8F62, 0,
    1, 0xF98E, 0x5E74, 0,
    1, 0xF98F, 0x6190, 0,
    1, 0xF990, 0x6200, 0,
    1, 0xF991, 0x649A, 0,
    1, 0xF992, 0x6F23, 0,
    1, 0xF993, 0x7149, 0,
    1, 0xF994, 0x7489, 0,
    1, 0xF995, 0x79CA, 0,
    1, 0xF996, 0x7DF4, 0,
    1, 0xF997, 0x806F, 0,
    1, 0xF998, 0x8F26, 0,
    1, 0xF999, 0x84EE, 0,
    1, 0xF99A, 0x9023, 0,
    1, 0xF99B, 0x934A, 0,
    1, 0xF99C, 0x5217, 0,
    1, 0xF99D, 0x52A3, 0,
    1, 0xF99E, 0x54BD, 0,
    1, 0xF99F, 0x70C8, 0,
    1, 0xF9A0, 0x88C2, 0,
    1, 0xF9A1, 0x8AAA, 0,
    1, 0xF9A2, 0x5EC9, 0,
    1, 0xF9A3, 0x5FF5, 0,
    1, 0xF9A4, 0x637B, 0,
    1, 0xF9A5, 0x6BAE, 0,
    1, 0xF9A6, 0x7C3E, 0,
    1, 0xF9A7, 0x7375, 0,
    1, 0xF9A8, 0x4EE4, 0,
    1, 0xF9A9, 0x56F9, 0,
    1, 0xF9AA, 0x5BE7, 0,
    1, 0xF9AB, 0x5DBA, 0,
    1, 0xF9AC, 0x601C, 0,
    1, 0xF9AD, 0x73B2, 0,
    1, 0xF9AE, 0x7469, 0,
    1, 0xF9AF, 0x7F9A, 0,
    1, 0xF9B0, 0x8046, 0,
    1, 0xF9B1, 0x9234, 0,
    1, 0xF9B2, 0x96F6, 0,
    1, 0xF9B3, 0x9748, 0,
    1, 0xF9B4, 0x9818, 0,
    1, 0xF9B5, 0x4F8B, 0,
    1, 0xF9B6, 0x79AE, 0,
    1, 0xF9B7, 0x91B4, 0,
    1, 0xF9B8, 0x96B8, 0,
    1, 0xF9B9, 0x60E1, 0,
    1, 0xF9BA, 0x4E86, 0,
    1, 0xF9BB, 0x50DA, 0,
    1, 0xF9BC, 0x5BEE, 0,
    1, 0xF9BD, 0x5C3F, 0,
    1, 0xF9BE, 0x6599, 0,
    1, 0xF9BF, 0x6A02, 0,
    1, 0xF9C0, 0x71CE, 0,
    1, 0xF9C1, 0x7642, 0,
    1, 0xF9C2, 0x84FC, 0,
    1, 0xF9C3, 0x907C, 0,
    1, 0xF9C4, 0x9F8D, 0,
    1, 0xF9C5, 0x6688, 0,
    1, 0xF9C6, 0x962E, 0,
    1, 0xF9C7, 0x5289, 0,
    1, 0xF9C8, 0x677B, 0,
    1, 0xF9C9, 0x67F3, 0,
    1, 0xF9CA, 0x6D41, 0,
    1, 0xF9CB, 0x6E9C, 0,
    1, 0xF9CC, 0x7409, 0,
    1, 0xF9CD, 0x7559, 0,
    1, 0xF9CE, 0x786B, 0,
    1, 0xF9CF, 0x7D10, 0,
    1, 0xF9D0, 0x985E, 0,
    1, 0xF9D1, 0x516D, 0,
    1, 0xF9D2, 0x622E, 0,
    1, 0xF9D3, 0x9678, 0,
    1, 0xF9D4, 0x502B, 0,
    1, 0xF9D5, 0x5D19, 0,
    1, 0xF9D6, 0x6DEA, 0,
    1, 0xF9D7, 0x8F2A, 0,
    1, 0xF9D8, 0x5F8B, 0,
    1, 0xF9D9, 0x6144, 0,
    1, 0xF9DA, 0x6817, 0,
    1, 0xF9DB, 0x7387, 0,
    1, 0xF9DC, 0x9686, 0,
    1, 0xF9DD, 0x5229, 0,
    1, 0xF9DE, 0x540F, 0,
    1, 0xF9DF, 0x5C65, 0,
    1, 0xF9E0, 0x6613, 0,
    1, 0xF9E1, 0x674E, 0,
    1, 0xF9E2, 0x68A8, 0,
    1, 0xF9E3, 0x6CE5, 0,
    1, 0xF9E4, 0x7406, 0,
    1, 0xF9E5, 0x75E2, 0,
    1, 0xF9E6, 0x7F79, 0,
    1, 0xF9E7, 0x88CF, 0,
    1, 0xF9E8, 0x88E1, 0,
    1, 0xF9E9, 0x91CC, 0,
    1, 0xF9EA, 0x96E2, 0,
    1, 0xF9EB, 0x533F, 0,
    1, 0xF9EC, 0x6EBA, 0,
    1, 0xF9ED, 0x541D, 0,
    1, 0xF9EE, 0x71D0, 0,
    1, 0xF9EF, 0x7498, 0,
    1, 0xF9F0, 0x85FA, 0,
    1, 0xF9F1, 0x96A3, 0,
    1, 0xF9F2, 0x9C57, 0,
    1, 0xF9F3, 0x9E9F, 0,
    1, 0xF9F4, 0x6797, 0,
    1, 0xF9F5, 0x6DCB, 0,
    1, 0xF9F6, 0x81E8, 0,
    1, 0xF9F7, 0x7ACB, 0,
    1, 0xF9F8, 0x7B20, 0,
    1, 0xF9F9, 0x7C92, 0,
    1, 0xF9FA, 0x72C0, 0,
    1, 0xF9FB, 0x7099, 0,
    1, 0xF9FC, 0x8B58, 0,
    1, 0xF9FD, 0x4EC0, 0,
    1, 0xF9FE, 0x8336, 0,
    1, 0xF9FF, 0x523A, 0,
    1, 0xFA00, 0x5207, 0,
    1, 0xFA01, 0x5EA6, 0,
    1, 0xFA02, 0x62D3, 0,
    1, 0xFA03, 0x7CD6, 0,
    1, 0xFA04, 0x5B85, 0,
    1, 0xFA05, 0x6D1E, 0,
    1, 0xFA06, 0x66B4, 0,
    1, 0xFA07, 0x8F3B, 0,
    1, 0xFA08, 0x884C, 0,
    1, 0xFA09, 0x964D, 0,
    1, 0xFA0A, 0x898B, 0,
    1, 0xFA0B, 0x5ED3, 0,
    1, 0xFA0C, 0x5140, 0,
    1, 0xFA0D, 0x55C0, 0,
    1, 0xFA10, 0x585A, 0,
    1, 0xFA12, 0x6674, 0,
    1, 0xFA15, 0x51DE, 0,
    1, 0xFA16, 0x732A, 0,
    1, 0xFA17, 0x76CA, 0,
    1, 0xFA18, 0x793C, 0,
    1, 0xFA19, 0x795E, 0,
    1, 0xFA1A, 0x7965, 0,
    1, 0xFA1B, 0x798F, 0,
    1, 0xFA1C, 0x9756, 0,
    1, 0xFA1D, 0x7CBE, 0,
    1, 0xFA1E, 0x7FBD, 0,
    1, 0xFA20, 0x8612, 0,
    1, 0xFA22, 0x8AF8, 0,
    1, 0xFA25, 0x9038, 0,
    1, 0xFA26, 0x90FD, 0,
    1, 0xFA2A, 0x98EF, 0,
    1, 0xFA2B, 0x98FC, 0,
    1, 0xFA2C, 0x9928, 0,
    1, 0xFA2D, 0x9DB4, 0,
    16, 0xFB00, 0x0066, 0x0066, 0,
    16, 0xFB01, 0x0066, 0x0069, 0,
    16, 0xFB02, 0x0066, 0x006C, 0,
    16, 0xFB03, 0x0066, 0x0066, 0x0069, 0,
    16, 0xFB04, 0x0066, 0x0066, 0x006C, 0,
    16, 0xFB05, 0x017F, 0x0074, 0,
    16, 0xFB06, 0x0073, 0x0074, 0,
    16, 0xFB13, 0x0574, 0x0576, 0,
    16, 0xFB14, 0x0574, 0x0565, 0,
    16, 0xFB15, 0x0574, 0x056B, 0,
    16, 0xFB16, 0x057E, 0x0576, 0,
    16, 0xFB17, 0x0574, 0x056D, 0,
    1, 0xFB1D, 0x05D9, 0x05B4, 0,
    1, 0xFB1F, 0x05F2, 0x05B7, 0,
    2, 0xFB20, 0x05E2, 0,
    2, 0xFB21, 0x05D0, 0,
    2, 0xFB22, 0x05D3, 0,
    2, 0xFB23, 0x05D4, 0,
    2, 0xFB24, 0x05DB, 0,
    2, 0xFB25, 0x05DC, 0,
    2, 0xFB26, 0x05DD, 0,
    2, 0xFB27, 0x05E8, 0,
    2, 0xFB28, 0x05EA, 0,
    2, 0xFB29, 0x002B, 0,
    1, 0xFB2A, 0x05E9, 0x05C1, 0,
    1, 0xFB2B, 0x05E9, 0x05C2, 0,
    1, 0xFB2C, 0xFB49, 0x05C1, 0,
    1, 0xFB2D, 0xFB49, 0x05C2, 0,
    1, 0xFB2E, 0x05D0, 0x05B7, 0,
    1, 0xFB2F, 0x05D0, 0x05B8, 0,
    1, 0xFB30, 0x05D0, 0x05BC, 0,
    1, 0xFB31, 0x05D1, 0x05BC, 0,
    1, 0xFB32, 0x05D2, 0x05BC, 0,
    1, 0xFB33, 0x05D3, 0x05BC, 0,
    1, 0xFB34, 0x05D4, 0x05BC, 0,
    1, 0xFB35, 0x05D5, 0x05BC, 0,
    1, 0xFB36, 0x05D6, 0x05BC, 0,
    1, 0xFB38, 0x05D8, 0x05BC, 0,
    1, 0xFB39, 0x05D9, 0x05BC, 0,
    1, 0xFB3A, 0x05DA, 0x05BC, 0,
    1, 0xFB3B, 0x05DB, 0x05BC, 0,
    1, 0xFB3C, 0x05DC, 0x05BC, 0,
    1, 0xFB3E, 0x05DE, 0x05BC, 0,
    1, 0xFB40, 0x05E0, 0x05BC, 0,
    1, 0xFB41, 0x05E1, 0x05BC, 0,
    1, 0xFB43, 0x05E3, 0x05BC, 0,
    1, 0xFB44, 0x05E4, 0x05BC, 0,
    1, 0xFB46, 0x05E6, 0x05BC, 0,
    1, 0xFB47, 0x05E7, 0x05BC, 0,
    1, 0xFB48, 0x05E8, 0x05BC, 0,
    1, 0xFB49, 0x05E9, 0x05BC, 0,
    1, 0xFB4A, 0x05EA, 0x05BC, 0,
    1, 0xFB4B, 0x05D5, 0x05B9, 0,
    1, 0xFB4C, 0x05D1, 0x05BF, 0,
    1, 0xFB4D, 0x05DB, 0x05BF, 0,
    1, 0xFB4E, 0x05E4, 0x05BF, 0,
    16, 0xFB4F, 0x05D0, 0x05DC, 0,
    7, 0xFB50, 0x0671, 0,
    6, 0xFB51, 0x0671, 0,
    7, 0xFB52, 0x067B, 0,
    6, 0xFB53, 0x067B, 0,
    4, 0xFB54, 0x067B, 0,
    5, 0xFB55, 0x067B, 0,
    7, 0xFB56, 0x067E, 0,
    6, 0xFB57, 0x067E, 0,
    4, 0xFB58, 0x067E, 0,
    5, 0xFB59, 0x067E, 0,
    7, 0xFB5A, 0x0680, 0,
    6, 0xFB5B, 0x0680, 0,
    4, 0xFB5C, 0x0680, 0,
    5, 0xFB5D, 0x0680, 0,
    7, 0xFB5E, 0x067A, 0,
    6, 0xFB5F, 0x067A, 0,
    4, 0xFB60, 0x067A, 0,
    5, 0xFB61, 0x067A, 0,
    7, 0xFB62, 0x067F, 0,
    6, 0xFB63, 0x067F, 0,
    4, 0xFB64, 0x067F, 0,
    5, 0xFB65, 0x067F, 0,
    7, 0xFB66, 0x0679, 0,
    6, 0xFB67, 0x0679, 0,
    4, 0xFB68, 0x0679, 0,
    5, 0xFB69, 0x0679, 0,
    7, 0xFB6A, 0x06A4, 0,
    6, 0xFB6B, 0x06A4, 0,
    4, 0xFB6C, 0x06A4, 0,
    5, 0xFB6D, 0x06A4, 0,
    7, 0xFB6E, 0x06A6, 0,
    6, 0xFB6F, 0x06A6, 0,
    4, 0xFB70, 0x06A6, 0,
    5, 0xFB71, 0x06A6, 0,
    7, 0xFB72, 0x0684, 0,
    6, 0xFB73, 0x0684, 0,
    4, 0xFB74, 0x0684, 0,
    5, 0xFB75, 0x0684, 0,
    7, 0xFB76, 0x0683, 0,
    6, 0xFB77, 0x0683, 0,
    4, 0xFB78, 0x0683, 0,
    5, 0xFB79, 0x0683, 0,
    7, 0xFB7A, 0x0686, 0,
    6, 0xFB7B, 0x0686, 0,
    4, 0xFB7C, 0x0686, 0,
    5, 0xFB7D, 0x0686, 0,
    7, 0xFB7E, 0x0687, 0,
    6, 0xFB7F, 0x0687, 0,
    4, 0xFB80, 0x0687, 0,
    5, 0xFB81, 0x0687, 0,
    7, 0xFB82, 0x068D, 0,
    6, 0xFB83, 0x068D, 0,
    7, 0xFB84, 0x068C, 0,
    6, 0xFB85, 0x068C, 0,
    7, 0xFB86, 0x068E, 0,
    6, 0xFB87, 0x068E, 0,
    7, 0xFB88, 0x0688, 0,
    6, 0xFB89, 0x0688, 0,
    7, 0xFB8A, 0x0698, 0,
    6, 0xFB8B, 0x0698, 0,
    7, 0xFB8C, 0x0691, 0,
    6, 0xFB8D, 0x0691, 0,
    7, 0xFB8E, 0x06A9, 0,
    6, 0xFB8F, 0x06A9, 0,
    4, 0xFB90, 0x06A9, 0,
    5, 0xFB91, 0x06A9, 0,
    7, 0xFB92, 0x06AF, 0,
    6, 0xFB93, 0x06AF, 0,
    4, 0xFB94, 0x06AF, 0,
    5, 0xFB95, 0x06AF, 0,
    7, 0xFB96, 0x06B3, 0,
    6, 0xFB97, 0x06B3, 0,
    4, 0xFB98, 0x06B3, 0,
    5, 0xFB99, 0x06B3, 0,
    7, 0xFB9A, 0x06B1, 0,
    6, 0xFB9B, 0x06B1, 0,
    4, 0xFB9C, 0x06B1, 0,
    5, 0xFB9D, 0x06B1, 0,
    7, 0xFB9E, 0x06BA, 0,
    6, 0xFB9F, 0x06BA, 0,
    7, 0xFBA0, 0x06BB, 0,
    6, 0xFBA1, 0x06BB, 0,
    4, 0xFBA2, 0x06BB, 0,
    5, 0xFBA3, 0x06BB, 0,
    7, 0xFBA4, 0x06C0, 0,
    6, 0xFBA5, 0x06C0, 0,
    7, 0xFBA6, 0x06C1, 0,
    6, 0xFBA7, 0x06C1, 0,
    4, 0xFBA8, 0x06C1, 0,
    5, 0xFBA9, 0x06C1, 0,
    7, 0xFBAA, 0x06BE, 0,
    6, 0xFBAB, 0x06BE, 0,
    4, 0xFBAC, 0x06BE, 0,
    5, 0xFBAD, 0x06BE, 0,
    7, 0xFBAE, 0x06D2, 0,
    6, 0xFBAF, 0x06D2, 0,
    7, 0xFBB0, 0x06D3, 0,
    6, 0xFBB1, 0x06D3, 0,
    7, 0xFBD3, 0x06AD, 0,
    6, 0xFBD4, 0x06AD, 0,
    4, 0xFBD5, 0x06AD, 0,
    5, 0xFBD6, 0x06AD, 0,
    7, 0xFBD7, 0x06C7, 0,
    6, 0xFBD8, 0x06C7, 0,
    7, 0xFBD9, 0x06C6, 0,
    6, 0xFBDA, 0x06C6, 0,
    7, 0xFBDB, 0x06C8, 0,
    6, 0xFBDC, 0x06C8, 0,
    7, 0xFBDD, 0x0677, 0,
    7, 0xFBDE, 0x06CB, 0,
    6, 0xFBDF, 0x06CB, 0,
    7, 0xFBE0, 0x06C5, 0,
    6, 0xFBE1, 0x06C5, 0,
    7, 0xFBE2, 0x06C9, 0,
    6, 0xFBE3, 0x06C9, 0,
    7, 0xFBE4, 0x06D0, 0,
    6, 0xFBE5, 0x06D0, 0,
    4, 0xFBE6, 0x06D0, 0,
    5, 0xFBE7, 0x06D0, 0,
    4, 0xFBE8, 0x0649, 0,
    5, 0xFBE9, 0x0649, 0,
    7, 0xFBEA, 0x0626, 0x0627, 0,
    6, 0xFBEB, 0x0626, 0x0627, 0,
    7, 0xFBEC, 0x0626, 0x06D5, 0,
    6, 0xFBED, 0x0626, 0x06D5, 0,
    7, 0xFBEE, 0x0626, 0x0648, 0,
    6, 0xFBEF, 0x0626, 0x0648, 0,
    7, 0xFBF0, 0x0626, 0x06C7, 0,
    6, 0xFBF1, 0x0626, 0x06C7, 0,
    7, 0xFBF2, 0x0626, 0x06C6, 0,
    6, 0xFBF3, 0x0626, 0x06C6, 0,
    7, 0xFBF4, 0x0626, 0x06C8, 0,
    6, 0xFBF5, 0x0626, 0x06C8, 0,
    7, 0xFBF6, 0x0626, 0x06D0, 0,
    6, 0xFBF7, 0x0626, 0x06D0, 0,
    4, 0xFBF8, 0x0626, 0x06D0, 0,
    7, 0xFBF9, 0x0626, 0x0649, 0,
    6, 0xFBFA, 0x0626, 0x0649, 0,
    4, 0xFBFB, 0x0626, 0x0649, 0,
    7, 0xFBFC, 0x06CC, 0,
    6, 0xFBFD, 0x06CC, 0,
    4, 0xFBFE, 0x06CC, 0,
    5, 0xFBFF, 0x06CC, 0,
    7, 0xFC00, 0x0626, 0x062C, 0,
    7, 0xFC01, 0x0626, 0x062D, 0,
    7, 0xFC02, 0x0626, 0x0645, 0,
    7, 0xFC03, 0x0626, 0x0649, 0,
    7, 0xFC04, 0x0626, 0x064A, 0,
    7, 0xFC05, 0x0628, 0x062C, 0,
    7, 0xFC06, 0x0628, 0x062D, 0,
    7, 0xFC07, 0x0628, 0x062E, 0,
    7, 0xFC08, 0x0628, 0x0645, 0,
    7, 0xFC09, 0x0628, 0x0649, 0,
    7, 0xFC0A, 0x0628, 0x064A, 0,
    7, 0xFC0B, 0x062A, 0x062C, 0,
    7, 0xFC0C, 0x062A, 0x062D, 0,
    7, 0xFC0D, 0x062A, 0x062E, 0,
    7, 0xFC0E, 0x062A, 0x0645, 0,
    7, 0xFC0F, 0x062A, 0x0649, 0,
    7, 0xFC10, 0x062A, 0x064A, 0,
    7, 0xFC11, 0x062B, 0x062C, 0,
    7, 0xFC12, 0x062B, 0x0645, 0,
    7, 0xFC13, 0x062B, 0x0649, 0,
    7, 0xFC14, 0x062B, 0x064A, 0,
    7, 0xFC15, 0x062C, 0x062D, 0,
    7, 0xFC16, 0x062C, 0x0645, 0,
    7, 0xFC17, 0x062D, 0x062C, 0,
    7, 0xFC18, 0x062D, 0x0645, 0,
    7, 0xFC19, 0x062E, 0x062C, 0,
    7, 0xFC1A, 0x062E, 0x062D, 0,
    7, 0xFC1B, 0x062E, 0x0645, 0,
    7, 0xFC1C, 0x0633, 0x062C, 0,
    7, 0xFC1D, 0x0633, 0x062D, 0,
    7, 0xFC1E, 0x0633, 0x062E, 0,
    7, 0xFC1F, 0x0633, 0x0645, 0,
    7, 0xFC20, 0x0635, 0x062D, 0,
    7, 0xFC21, 0x0635, 0x0645, 0,
    7, 0xFC22, 0x0636, 0x062C, 0,
    7, 0xFC23, 0x0636, 0x062D, 0,
    7, 0xFC24, 0x0636, 0x062E, 0,
    7, 0xFC25, 0x0636, 0x0645, 0,
    7, 0xFC26, 0x0637, 0x062D, 0,
    7, 0xFC27, 0x0637, 0x0645, 0,
    7, 0xFC28, 0x0638, 0x0645, 0,
    7, 0xFC29, 0x0639, 0x062C, 0,
    7, 0xFC2A, 0x0639, 0x0645, 0,
    7, 0xFC2B, 0x063A, 0x062C, 0,
    7, 0xFC2C, 0x063A, 0x0645, 0,
    7, 0xFC2D, 0x0641, 0x062C, 0,
    7, 0xFC2E, 0x0641, 0x062D, 0,
    7, 0xFC2F, 0x0641, 0x062E, 0,
    7, 0xFC30, 0x0641, 0x0645, 0,
    7, 0xFC31, 0x0641, 0x0649, 0,
    7, 0xFC32, 0x0641, 0x064A, 0,
    7, 0xFC33, 0x0642, 0x062D, 0,
    7, 0xFC34, 0x0642, 0x0645, 0,
    7, 0xFC35, 0x0642, 0x0649, 0,
    7, 0xFC36, 0x0642, 0x064A, 0,
    7, 0xFC37, 0x0643, 0x0627, 0,
    7, 0xFC38, 0x0643, 0x062C, 0,
    7, 0xFC39, 0x0643, 0x062D, 0,
    7, 0xFC3A, 0x0643, 0x062E, 0,
    7, 0xFC3B, 0x0643, 0x0644, 0,
    7, 0xFC3C, 0x0643, 0x0645, 0,
    7, 0xFC3D, 0x0643, 0x0649, 0,
    7, 0xFC3E, 0x0643, 0x064A, 0,
    7, 0xFC3F, 0x0644, 0x062C, 0,
    7, 0xFC40, 0x0644, 0x062D, 0,
    7, 0xFC41, 0x0644, 0x062E, 0,
    7, 0xFC42, 0x0644, 0x0645, 0,
    7, 0xFC43, 0x0644, 0x0649, 0,
    7, 0xFC44, 0x0644, 0x064A, 0,
    7, 0xFC45, 0x0645, 0x062C, 0,
    7, 0xFC46, 0x0645, 0x062D, 0,
    7, 0xFC47, 0x0645, 0x062E, 0,
    7, 0xFC48, 0x0645, 0x0645, 0,
    7, 0xFC49, 0x0645, 0x0649, 0,
    7, 0xFC4A, 0x0645, 0x064A, 0,
    7, 0xFC4B, 0x0646, 0x062C, 0,
    7, 0xFC4C, 0x0646, 0x062D, 0,
    7, 0xFC4D, 0x0646, 0x062E, 0,
    7, 0xFC4E, 0x0646, 0x0645, 0,
    7, 0xFC4F, 0x0646, 0x0649, 0,
    7, 0xFC50, 0x0646, 0x064A, 0,
    7, 0xFC51, 0x0647, 0x062C, 0,
    7, 0xFC52, 0x0647, 0x0645, 0,
    7, 0xFC53, 0x0647, 0x0649, 0,
    7, 0xFC54, 0x0647, 0x064A, 0,
    7, 0xFC55, 0x064A, 0x062C, 0,
    7, 0xFC56, 0x064A, 0x062D, 0,
    7, 0xFC57, 0x064A, 0x062E, 0,
    7, 0xFC58, 0x064A, 0x0645, 0,
    7, 0xFC59, 0x064A, 0x0649, 0,
    7, 0xFC5A, 0x064A, 0x064A, 0,
    7, 0xFC5B, 0x0630, 0x0670, 0,
    7, 0xFC5C, 0x0631, 0x0670, 0,
    7, 0xFC5D, 0x0649, 0x0670, 0,
    7, 0xFC5E, 0x0020, 0x064C, 0x0651, 0,
    7, 0xFC5F, 0x0020, 0x064D, 0x0651, 0,
    7, 0xFC60, 0x0020, 0x064E, 0x0651, 0,
    7, 0xFC61, 0x0020, 0x064F, 0x0651, 0,
    7, 0xFC62, 0x0020, 0x0650, 0x0651, 0,
    7, 0xFC63, 0x0020, 0x0651, 0x0670, 0,
    6, 0xFC64, 0x0626, 0x0631, 0,
    6, 0xFC65, 0x0626, 0x0632, 0,
    6, 0xFC66, 0x0626, 0x0645, 0,
    6, 0xFC67, 0x0626, 0x0646, 0,
    6, 0xFC68, 0x0626, 0x0649, 0,
    6, 0xFC69, 0x0626, 0x064A, 0,
    6, 0xFC6A, 0x0628, 0x0631, 0,
    6, 0xFC6B, 0x0628, 0x0632, 0,
    6, 0xFC6C, 0x0628, 0x0645, 0,
    6, 0xFC6D, 0x0628, 0x0646, 0,
    6, 0xFC6E, 0x0628, 0x0649, 0,
    6, 0xFC6F, 0x0628, 0x064A, 0,
    6, 0xFC70, 0x062A, 0x0631, 0,
    6, 0xFC71, 0x062A, 0x0632, 0,
    6, 0xFC72, 0x062A, 0x0645, 0,
    6, 0xFC73, 0x062A, 0x0646, 0,
    6, 0xFC74, 0x062A, 0x0649, 0,
    6, 0xFC75, 0x062A, 0x064A, 0,
    6, 0xFC76, 0x062B, 0x0631, 0,
    6, 0xFC77, 0x062B, 0x0632, 0,
    6, 0xFC78, 0x062B, 0x0645, 0,
    6, 0xFC79, 0x062B, 0x0646, 0,
    6, 0xFC7A, 0x062B, 0x0649, 0,
    6, 0xFC7B, 0x062B, 0x064A, 0,
    6, 0xFC7C, 0x0641, 0x0649, 0,
    6, 0xFC7D, 0x0641, 0x064A, 0,
    6, 0xFC7E, 0x0642, 0x0649, 0,
    6, 0xFC7F, 0x0642, 0x064A, 0,
    6, 0xFC80, 0x0643, 0x0627, 0,
    6, 0xFC81, 0x0643, 0x0644, 0,
    6, 0xFC82, 0x0643, 0x0645, 0,
    6, 0xFC83, 0x0643, 0x0649, 0,
    6, 0xFC84, 0x0643, 0x064A, 0,
    6, 0xFC85, 0x0644, 0x0645, 0,
    6, 0xFC86, 0x0644, 0x0649, 0,
    6, 0xFC87, 0x0644, 0x064A, 0,
    6, 0xFC88, 0x0645, 0x0627, 0,
    6, 0xFC89, 0x0645, 0x0645, 0,
    6, 0xFC8A, 0x0646, 0x0631, 0,
    6, 0xFC8B, 0x0646, 0x0632, 0,
    6, 0xFC8C, 0x0646, 0x0645, 0,
    6, 0xFC8D, 0x0646, 0x0646, 0,
    6, 0xFC8E, 0x0646, 0x0649, 0,
    6, 0xFC8F, 0x0646, 0x064A, 0,
    6, 0xFC90, 0x0649, 0x0670, 0,
    6, 0xFC91, 0x064A, 0x0631, 0,
    6, 0xFC92, 0x064A, 0x0632, 0,
    6, 0xFC93, 0x064A, 0x0645, 0,
    6, 0xFC94, 0x064A, 0x0646, 0,
    6, 0xFC95, 0x064A, 0x0649, 0,
    6, 0xFC96, 0x064A, 0x064A, 0,
    4, 0xFC97, 0x0626, 0x062C, 0,
    4, 0xFC98, 0x0626, 0x062D, 0,
    4, 0xFC99, 0x0626, 0x062E, 0,
    4, 0xFC9A, 0x0626, 0x0645, 0,
    4, 0xFC9B, 0x0626, 0x0647, 0,
    4, 0xFC9C, 0x0628, 0x062C, 0,
    4, 0xFC9D, 0x0628, 0x062D, 0,
    4, 0xFC9E, 0x0628, 0x062E, 0,
    4, 0xFC9F, 0x0628, 0x0645, 0,
    4, 0xFCA0, 0x0628, 0x0647, 0,
    4, 0xFCA1, 0x062A, 0x062C, 0,
    4, 0xFCA2, 0x062A, 0x062D, 0,
    4, 0xFCA3, 0x062A, 0x062E, 0,
    4, 0xFCA4, 0x062A, 0x0645, 0,
    4, 0xFCA5, 0x062A, 0x0647, 0,
    4, 0xFCA6, 0x062B, 0x0645, 0,
    4, 0xFCA7, 0x062C, 0x062D, 0,
    4, 0xFCA8, 0x062C, 0x0645, 0,
    4, 0xFCA9, 0x062D, 0x062C, 0,
    4, 0xFCAA, 0x062D, 0x0645, 0,
    4, 0xFCAB, 0x062E, 0x062C, 0,
    4, 0xFCAC, 0x062E, 0x0645, 0,
    4, 0xFCAD, 0x0633, 0x062C, 0,
    4, 0xFCAE, 0x0633, 0x062D, 0,
    4, 0xFCAF, 0x0633, 0x062E, 0,
    4, 0xFCB0, 0x0633, 0x0645, 0,
    4, 0xFCB1, 0x0635, 0x062D, 0,
    4, 0xFCB2, 0x0635, 0x062E, 0,
    4, 0xFCB3, 0x0635, 0x0645, 0,
    4, 0xFCB4, 0x0636, 0x062C, 0,
    4, 0xFCB5, 0x0636, 0x062D, 0,
    4, 0xFCB6, 0x0636, 0x062E, 0,
    4, 0xFCB7, 0x0636, 0x0645, 0,
    4, 0xFCB8, 0x0637, 0x062D, 0,
    4, 0xFCB9, 0x0638, 0x0645, 0,
    4, 0xFCBA, 0x0639, 0x062C, 0,
    4, 0xFCBB, 0x0639, 0x0645, 0,
    4, 0xFCBC, 0x063A, 0x062C, 0,
    4, 0xFCBD, 0x063A, 0x0645, 0,
    4, 0xFCBE, 0x0641, 0x062C, 0,
    4, 0xFCBF, 0x0641, 0x062D, 0,
    4, 0xFCC0, 0x0641, 0x062E, 0,
    4, 0xFCC1, 0x0641, 0x0645, 0,
    4, 0xFCC2, 0x0642, 0x062D, 0,
    4, 0xFCC3, 0x0642, 0x0645, 0,
    4, 0xFCC4, 0x0643, 0x062C, 0,
    4, 0xFCC5, 0x0643, 0x062D, 0,
    4, 0xFCC6, 0x0643, 0x062E, 0,
    4, 0xFCC7, 0x0643, 0x0644, 0,
    4, 0xFCC8, 0x0643, 0x0645, 0,
    4, 0xFCC9, 0x0644, 0x062C, 0,
    4, 0xFCCA, 0x0644, 0x062D, 0,
    4, 0xFCCB, 0x0644, 0x062E, 0,
    4, 0xFCCC, 0x0644, 0x0645, 0,
    4, 0xFCCD, 0x0644, 0x0647, 0,
    4, 0xFCCE, 0x0645, 0x062C, 0,
    4, 0xFCCF, 0x0645, 0x062D, 0,
    4, 0xFCD0, 0x0645, 0x062E, 0,
    4, 0xFCD1, 0x0645, 0x0645, 0,
    4, 0xFCD2, 0x0646, 0x062C, 0,
    4, 0xFCD3, 0x0646, 0x062D, 0,
    4, 0xFCD4, 0x0646, 0x062E, 0,
    4, 0xFCD5, 0x0646, 0x0645, 0,
    4, 0xFCD6, 0x0646, 0x0647, 0,
    4, 0xFCD7, 0x0647, 0x062C, 0,
    4, 0xFCD8, 0x0647, 0x0645, 0,
    4, 0xFCD9, 0x0647, 0x0670, 0,
    4, 0xFCDA, 0x064A, 0x062C, 0,
    4, 0xFCDB, 0x064A, 0x062D, 0,
    4, 0xFCDC, 0x064A, 0x062E, 0,
    4, 0xFCDD, 0x064A, 0x0645, 0,
    4, 0xFCDE, 0x064A, 0x0647, 0,
    5, 0xFCDF, 0x0626, 0x0645, 0,
    5, 0xFCE0, 0x0626, 0x0647, 0,
    5, 0xFCE1, 0x0628, 0x0645, 0,
    5, 0xFCE2, 0x0628, 0x0647, 0,
    5, 0xFCE3, 0x062A, 0x0645, 0,
    5, 0xFCE4, 0x062A, 0x0647, 0,
    5, 0xFCE5, 0x062B, 0x0645, 0,
    5, 0xFCE6, 0x062B, 0x0647, 0,
    5, 0xFCE7, 0x0633, 0x0645, 0,
    5, 0xFCE8, 0x0633, 0x0647, 0,
    5, 0xFCE9, 0x0634, 0x0645, 0,
    5, 0xFCEA, 0x0634, 0x0647, 0,
    5, 0xFCEB, 0x0643, 0x0644, 0,
    5, 0xFCEC, 0x0643, 0x0645, 0,
    5, 0xFCED, 0x0644, 0x0645, 0,
    5, 0xFCEE, 0x0646, 0x0645, 0,
    5, 0xFCEF, 0x0646, 0x0647, 0,
    5, 0xFCF0, 0x064A, 0x0645, 0,
    5, 0xFCF1, 0x064A, 0x0647, 0,
    5, 0xFCF2, 0x0640, 0x064E, 0x0651, 0,
    5, 0xFCF3, 0x0640, 0x064F, 0x0651, 0,
    5, 0xFCF4, 0x0640, 0x0650, 0x0651, 0,
    7, 0xFCF5, 0x0637, 0x0649, 0,
    7, 0xFCF6, 0x0637, 0x064A, 0,
    7, 0xFCF7, 0x0639, 0x0649, 0,
    7, 0xFCF8, 0x0639, 0x064A, 0,
    7, 0xFCF9, 0x063A, 0x0649, 0,
    7, 0xFCFA, 0x063A, 0x064A, 0,
    7, 0xFCFB, 0x0633, 0x0649, 0,
    7, 0xFCFC, 0x0633, 0x064A, 0,
    7, 0xFCFD, 0x0634, 0x0649, 0,
    7, 0xFCFE, 0x0634, 0x064A, 0,
    7, 0xFCFF, 0x062D, 0x0649, 0,
    7, 0xFD00, 0x062D, 0x064A, 0,
    7, 0xFD01, 0x062C, 0x0649, 0,
    7, 0xFD02, 0x062C, 0x064A, 0,
    7, 0xFD03, 0x062E, 0x0649, 0,
    7, 0xFD04, 0x062E, 0x064A, 0,
    7, 0xFD05, 0x0635, 0x0649, 0,
    7, 0xFD06, 0x0635, 0x064A, 0,
    7, 0xFD07, 0x0636, 0x0649, 0,
    7, 0xFD08, 0x0636, 0x064A, 0,
    7, 0xFD09, 0x0634, 0x062C, 0,
    7, 0xFD0A, 0x0634, 0x062D, 0,
    7, 0xFD0B, 0x0634, 0x062E, 0,
    7, 0xFD0C, 0x0634, 0x0645, 0,
    7, 0xFD0D, 0x0634, 0x0631, 0,
    7, 0xFD0E, 0x0633, 0x0631, 0,
    7, 0xFD0F, 0x0635, 0x0631, 0,
    7, 0xFD10, 0x0636, 0x0631, 0,
    6, 0xFD11, 0x0637, 0x0649, 0,
    6, 0xFD12, 0x0637, 0x064A, 0,
    6, 0xFD13, 0x0639, 0x0649, 0,
    6, 0xFD14, 0x0639, 0x064A, 0,
    6, 0xFD15, 0x063A, 0x0649, 0,
    6, 0xFD16, 0x063A, 0x064A, 0,
    6, 0xFD17, 0x0633, 0x0649, 0,
    6, 0xFD18, 0x0633, 0x064A, 0,
    6, 0xFD19, 0x0634, 0x0649, 0,
    6, 0xFD1A, 0x0634, 0x064A, 0,
    6, 0xFD1B, 0x062D, 0x0649, 0,
    6, 0xFD1C, 0x062D, 0x064A, 0,
    6, 0xFD1D, 0x062C, 0x0649, 0,
    6, 0xFD1E, 0x062C, 0x064A, 0,
    6, 0xFD1F, 0x062E, 0x0649, 0,
    6, 0xFD20, 0x062E, 0x064A, 0,
    6, 0xFD21, 0x0635, 0x0649, 0,
    6, 0xFD22, 0x0635, 0x064A, 0,
    6, 0xFD23, 0x0636, 0x0649, 0,
    6, 0xFD24, 0x0636, 0x064A, 0,
    6, 0xFD25, 0x0634, 0x062C, 0,
    6, 0xFD26, 0x0634, 0x062D, 0,
    6, 0xFD27, 0x0634, 0x062E, 0,
    6, 0xFD28, 0x0634, 0x0645, 0,
    6, 0xFD29, 0x0634, 0x0631, 0,
    6, 0xFD2A, 0x0633, 0x0631, 0,
    6, 0xFD2B, 0x0635, 0x0631, 0,
    6, 0xFD2C, 0x0636, 0x0631, 0,
    4, 0xFD2D, 0x0634, 0x062C, 0,
    4, 0xFD2E, 0x0634, 0x062D, 0,
    4, 0xFD2F, 0x0634, 0x062E, 0,
    4, 0xFD30, 0x0634, 0x0645, 0,
    4, 0xFD31, 0x0633, 0x0647, 0,
    4, 0xFD32, 0x0634, 0x0647, 0,
    4, 0xFD33, 0x0637, 0x0645, 0,
    5, 0xFD34, 0x0633, 0x062C, 0,
    5, 0xFD35, 0x0633, 0x062D, 0,
    5, 0xFD36, 0x0633, 0x062E, 0,
    5, 0xFD37, 0x0634, 0x062C, 0,
    5, 0xFD38, 0x0634, 0x062D, 0,
    5, 0xFD39, 0x0634, 0x062E, 0,
    5, 0xFD3A, 0x0637, 0x0645, 0,
    5, 0xFD3B, 0x0638, 0x0645, 0,
    6, 0xFD3C, 0x0627, 0x064B, 0,
    7, 0xFD3D, 0x0627, 0x064B, 0,
    4, 0xFD50, 0x062A, 0x062C, 0x0645, 0,
    6, 0xFD51, 0x062A, 0x062D, 0x062C, 0,
    4, 0xFD52, 0x062A, 0x062D, 0x062C, 0,
    4, 0xFD53, 0x062A, 0x062D, 0x0645, 0,
    4, 0xFD54, 0x062A, 0x062E, 0x0645, 0,
    4, 0xFD55, 0x062A, 0x0645, 0x062C, 0,
    4, 0xFD56, 0x062A, 0x0645, 0x062D, 0,
    4, 0xFD57, 0x062A, 0x0645, 0x062E, 0,
    6, 0xFD58, 0x062C, 0x0645, 0x062D, 0,
    4, 0xFD59, 0x062C, 0x0645, 0x062D, 0,
    6, 0xFD5A, 0x062D, 0x0645, 0x064A, 0,
    6, 0xFD5B, 0x062D, 0x0645, 0x0649, 0,
    4, 0xFD5C, 0x0633, 0x062D, 0x062C, 0,
    4, 0xFD5D, 0x0633, 0x062C, 0x062D, 0,
    6, 0xFD5E, 0x0633, 0x062C, 0x0649, 0,
    6, 0xFD5F, 0x0633, 0x0645, 0x062D, 0,
    4, 0xFD60, 0x0633, 0x0645, 0x062D, 0,
    4, 0xFD61, 0x0633, 0x0645, 0x062C, 0,
    6, 0xFD62, 0x0633, 0x0645, 0x0645, 0,
    4, 0xFD63, 0x0633, 0x0645, 0x0645, 0,
    6, 0xFD64, 0x0635, 0x062D, 0x062D, 0,
    4, 0xFD65, 0x0635, 0x062D, 0x062D, 0,
    6, 0xFD66, 0x0635, 0x0645, 0x0645, 0,
    6, 0xFD67, 0x0634, 0x062D, 0x0645, 0,
    4, 0xFD68, 0x0634, 0x062D, 0x0645, 0,
    6, 0xFD69, 0x0634, 0x062C, 0x064A, 0,
    6, 0xFD6A, 0x0634, 0x0645, 0x062E, 0,
    4, 0xFD6B, 0x0634, 0x0645, 0x062E, 0,
    6, 0xFD6C, 0x0634, 0x0645, 0x0645, 0,
    4, 0xFD6D, 0x0634, 0x0645, 0x0645, 0,
    6, 0xFD6E, 0x0636, 0x062D, 0x0649, 0,
    6, 0xFD6F, 0x0636, 0x062E, 0x0645, 0,
    4, 0xFD70, 0x0636, 0x062E, 0x0645, 0,
    6, 0xFD71, 0x0637, 0x0645, 0x062D, 0,
    4, 0xFD72, 0x0637, 0x0645, 0x062D, 0,
    4, 0xFD73, 0x0637, 0x0645, 0x0645, 0,
    6, 0xFD74, 0x0637, 0x0645, 0x064A, 0,
    6, 0xFD75, 0x0639, 0x062C, 0x0645, 0,
    6, 0xFD76, 0x0639, 0x0645, 0x0645, 0,
    4, 0xFD77, 0x0639, 0x0645, 0x0645, 0,
    6, 0xFD78, 0x0639, 0x0645, 0x0649, 0,
    6, 0xFD79, 0x063A, 0x0645, 0x0645, 0,
    6, 0xFD7A, 0x063A, 0x0645, 0x064A, 0,
    6, 0xFD7B, 0x063A, 0x0645, 0x0649, 0,
    6, 0xFD7C, 0x0641, 0x062E, 0x0645, 0,
    4, 0xFD7D, 0x0641, 0x062E, 0x0645, 0,
    6, 0xFD7E, 0x0642, 0x0645, 0x062D, 0,
    6, 0xFD7F, 0x0642, 0x0645, 0x0645, 0,
    6, 0xFD80, 0x0644, 0x062D, 0x0645, 0,
    6, 0xFD81, 0x0644, 0x062D, 0x064A, 0,
    6, 0xFD82, 0x0644, 0x062D, 0x0649, 0,
    4, 0xFD83, 0x0644, 0x062C, 0x062C, 0,
    6, 0xFD84, 0x0644, 0x062C, 0x062C, 0,
    6, 0xFD85, 0x0644, 0x062E, 0x0645, 0,
    4, 0xFD86, 0x0644, 0x062E, 0x0645, 0,
    6, 0xFD87, 0x0644, 0x0645, 0x062D, 0,
    4, 0xFD88, 0x0644, 0x0645, 0x062D, 0,
    4, 0xFD89, 0x0645, 0x062D, 0x062C, 0,
    4, 0xFD8A, 0x0645, 0x062D, 0x0645, 0,
    6, 0xFD8B, 0x0645, 0x062D, 0x064A, 0,
    4, 0xFD8C, 0x0645, 0x062C, 0x062D, 0,
    4, 0xFD8D, 0x0645, 0x062C, 0x0645, 0,
    4, 0xFD8E, 0x0645, 0x062E, 0x062C, 0,
    4, 0xFD8F, 0x0645, 0x062E, 0x0645, 0,
    4, 0xFD92, 0x0645, 0x062C, 0x062E, 0,
    4, 0xFD93, 0x0647, 0x0645, 0x062C, 0,
    4, 0xFD94, 0x0647, 0x0645, 0x0645, 0,
    4, 0xFD95, 0x0646, 0x062D, 0x0645, 0,
    6, 0xFD96, 0x0646, 0x062D, 0x0649, 0,
    6, 0xFD97, 0x0646, 0x062C, 0x0645, 0,
    4, 0xFD98, 0x0646, 0x062C, 0x0645, 0,
    6, 0xFD99, 0x0646, 0x062C, 0x0649, 0,
    6, 0xFD9A, 0x0646, 0x0645, 0x064A, 0,
    6, 0xFD9B, 0x0646, 0x0645, 0x0649, 0,
    6, 0xFD9C, 0x064A, 0x0645, 0x0645, 0,
    4, 0xFD9D, 0x064A, 0x0645, 0x0645, 0,
    6, 0xFD9E, 0x0628, 0x062E, 0x064A, 0,
    6, 0xFD9F, 0x062A, 0x062C, 0x064A, 0,
    6, 0xFDA0, 0x062A, 0x062C, 0x0649, 0,
    6, 0xFDA1, 0x062A, 0x062E, 0x064A, 0,
    6, 0xFDA2, 0x062A, 0x062E, 0x0649, 0,
    6, 0xFDA3, 0x062A, 0x0645, 0x064A, 0,
    6, 0xFDA4, 0x062A, 0x0645, 0x0649, 0,
    6, 0xFDA5, 0x062C, 0x0645, 0x064A, 0,
    6, 0xFDA6, 0x062C, 0x062D, 0x0649, 0,
    6, 0xFDA7, 0x062C, 0x0645, 0x0649, 0,
    6, 0xFDA8, 0x0633, 0x062E, 0x0649, 0,
    6, 0xFDA9, 0x0635, 0x062D, 0x064A, 0,
    6, 0xFDAA, 0x0634, 0x062D, 0x064A, 0,
    6, 0xFDAB, 0x0636, 0x062D, 0x064A, 0,
    6, 0xFDAC, 0x0644, 0x062C, 0x064A, 0,
    6, 0xFDAD, 0x0644, 0x0645, 0x064A, 0,
    6, 0xFDAE, 0x064A, 0x062D, 0x064A, 0,
    6, 0xFDAF, 0x064A, 0x062C, 0x064A, 0,
    6, 0xFDB0, 0x064A, 0x0645, 0x064A, 0,
    6, 0xFDB1, 0x0645, 0x0645, 0x064A, 0,
    6, 0xFDB2, 0x0642, 0x0645, 0x064A, 0,
    6, 0xFDB3, 0x0646, 0x062D, 0x064A, 0,
    4, 0xFDB4, 0x0642, 0x0645, 0x062D, 0,
    4, 0xFDB5, 0x0644, 0x062D, 0x0645, 0,
    6, 0xFDB6, 0x0639, 0x0645, 0x064A, 0,
    6, 0xFDB7, 0x0643, 0x0645, 0x064A, 0,
    4, 0xFDB8, 0x0646, 0x062C, 0x062D, 0,
    6, 0xFDB9, 0x0645, 0x062E, 0x064A, 0,
    4, 0xFDBA, 0x0644, 0x062C, 0x0645, 0,
    6, 0xFDBB, 0x0643, 0x0645, 0x0645, 0,
    6, 0xFDBC, 0x0644, 0x062C, 0x0645, 0,
    6, 0xFDBD, 0x0646, 0x062C, 0x062D, 0,
    6, 0xFDBE, 0x062C, 0x062D, 0x064A, 0,
    6, 0xFDBF, 0x062D, 0x062C, 0x064A, 0,
    6, 0xFDC0, 0x0645, 0x062C, 0x064A, 0,
    6, 0xFDC1, 0x0641, 0x0645, 0x064A, 0,
    6, 0xFDC2, 0x0628, 0x062D, 0x064A, 0,
    4, 0xFDC3, 0x0643, 0x0645, 0x0645, 0,
    4, 0xFDC4, 0x0639, 0x062C, 0x0645, 0,
    4, 0xFDC5, 0x0635, 0x0645, 0x0645, 0,
    6, 0xFDC6, 0x0633, 0x062E, 0x064A, 0,
    6, 0xFDC7, 0x0646, 0x062C, 0x064A, 0,
    7, 0xFDF0, 0x0635, 0x0644, 0x06D2, 0,
    7, 0xFDF1, 0x0642, 0x0644, 0x06D2, 0,
    7, 0xFDF2, 0x0627, 0x0644, 0x0644, 0x0647, 0,
    7, 0xFDF3, 0x0627, 0x0643, 0x0628, 0x0631, 0,
    7, 0xFDF4, 0x0645, 0x062D, 0x0645, 0x062F, 0,
    7, 0xFDF5, 0x0635, 0x0644, 0x0639, 0x0645, 0,
    7, 0xFDF6, 0x0631, 0x0633, 0x0648, 0x0644, 0,
    7, 0xFDF7, 0x0639, 0x0644, 0x064A, 0x0647, 0,
    7, 0xFDF8, 0x0648, 0x0633, 0x0644, 0x0645, 0,
    7, 0xFDF9, 0x0635, 0x0644, 0x0649, 0,
    7, 0xFDFA, 0x0635, 0x0644, 0x0649, 0x0020, 0x0627, 0x0644, 0x0644, 0x0647, 0x0020, 0x0639, 0x0644, 0x064A, 0x0647, 0x0020, 0x0648, 0x0633, 0x0644, 0x0645, 0,
    7, 0xFDFB, 0x062C, 0x0644, 0x0020, 0x062C, 0x0644, 0x0627, 0x0644, 0x0647, 0,
    11, 0xFE30, 0x2025, 0,
    11, 0xFE31, 0x2014, 0,
    11, 0xFE32, 0x2013, 0,
    11, 0xFE33, 0x005F, 0,
    11, 0xFE34, 0x005F, 0,
    11, 0xFE35, 0x0028, 0,
    11, 0xFE36, 0x0029, 0,
    11, 0xFE37, 0x007B, 0,
    11, 0xFE38, 0x007D, 0,
    11, 0xFE39, 0x3014, 0,
    11, 0xFE3A, 0x3015, 0,
    11, 0xFE3B, 0x3010, 0,
    11, 0xFE3C, 0x3011, 0,
    11, 0xFE3D, 0x300A, 0,
    11, 0xFE3E, 0x300B, 0,
    11, 0xFE3F, 0x3008, 0,
    11, 0xFE40, 0x3009, 0,
    11, 0xFE41, 0x300C, 0,
    11, 0xFE42, 0x300D, 0,
    11, 0xFE43, 0x300E, 0,
    11, 0xFE44, 0x300F, 0,
    16, 0xFE49, 0x203E, 0,
    16, 0xFE4A, 0x203E, 0,
    16, 0xFE4B, 0x203E, 0,
    16, 0xFE4C, 0x203E, 0,
    16, 0xFE4D, 0x005F, 0,
    16, 0xFE4E, 0x005F, 0,
    16, 0xFE4F, 0x005F, 0,
    14, 0xFE50, 0x002C, 0,
    14, 0xFE51, 0x3001, 0,
    14, 0xFE52, 0x002E, 0,
    14, 0xFE54, 0x003B, 0,
    14, 0xFE55, 0x003A, 0,
    14, 0xFE56, 0x003F, 0,
    14, 0xFE57, 0x0021, 0,
    14, 0xFE58, 0x2014, 0,
    14, 0xFE59, 0x0028, 0,
    14, 0xFE5A, 0x0029, 0,
    14, 0xFE5B, 0x007B, 0,
    14, 0xFE5C, 0x007D, 0,
    14, 0xFE5D, 0x3014, 0,
    14, 0xFE5E, 0x3015, 0,
    14, 0xFE5F, 0x0023, 0,
    14, 0xFE60, 0x0026, 0,
    14, 0xFE61, 0x002A, 0,
    14, 0xFE62, 0x002B, 0,
    14, 0xFE63, 0x002D, 0,
    14, 0xFE64, 0x003C, 0,
    14, 0xFE65, 0x003E, 0,
    14, 0xFE66, 0x003D, 0,
    14, 0xFE68, 0x005C, 0,
    14, 0xFE69, 0x0024, 0,
    14, 0xFE6A, 0x0025, 0,
    14, 0xFE6B, 0x0040, 0,
    7, 0xFE70, 0x0020, 0x064B, 0,
    5, 0xFE71, 0x0640, 0x064B, 0,
    7, 0xFE72, 0x0020, 0x064C, 0,
    7, 0xFE74, 0x0020, 0x064D, 0,
    7, 0xFE76, 0x0020, 0x064E, 0,
    5, 0xFE77, 0x0640, 0x064E, 0,
    7, 0xFE78, 0x0020, 0x064F, 0,
    5, 0xFE79, 0x0640, 0x064F, 0,
    7, 0xFE7A, 0x0020, 0x0650, 0,
    5, 0xFE7B, 0x0640, 0x0650, 0,
    7, 0xFE7C, 0x0020, 0x0651, 0,
    5, 0xFE7D, 0x0640, 0x0651, 0,
    7, 0xFE7E, 0x0020, 0x0652, 0,
    5, 0xFE7F, 0x0640, 0x0652, 0,
    7, 0xFE80, 0x0621, 0,
    7, 0xFE81, 0x0622, 0,
    6, 0xFE82, 0x0622, 0,
    7, 0xFE83, 0x0623, 0,
    6, 0xFE84, 0x0623, 0,
    7, 0xFE85, 0x0624, 0,
    6, 0xFE86, 0x0624, 0,
    7, 0xFE87, 0x0625, 0,
    6, 0xFE88, 0x0625, 0,
    7, 0xFE89, 0x0626, 0,
    6, 0xFE8A, 0x0626, 0,
    4, 0xFE8B, 0x0626, 0,
    5, 0xFE8C, 0x0626, 0,
    7, 0xFE8D, 0x0627, 0,
    6, 0xFE8E, 0x0627, 0,
    7, 0xFE8F, 0x0628, 0,
    6, 0xFE90, 0x0628, 0,
    4, 0xFE91, 0x0628, 0,
    5, 0xFE92, 0x0628, 0,
    7, 0xFE93, 0x0629, 0,
    6, 0xFE94, 0x0629, 0,
    7, 0xFE95, 0x062A, 0,
    6, 0xFE96, 0x062A, 0,
    4, 0xFE97, 0x062A, 0,
    5, 0xFE98, 0x062A, 0,
    7, 0xFE99, 0x062B, 0,
    6, 0xFE9A, 0x062B, 0,
    4, 0xFE9B, 0x062B, 0,
    5, 0xFE9C, 0x062B, 0,
    7, 0xFE9D, 0x062C, 0,
    6, 0xFE9E, 0x062C, 0,
    4, 0xFE9F, 0x062C, 0,
    5, 0xFEA0, 0x062C, 0,
    7, 0xFEA1, 0x062D, 0,
    6, 0xFEA2, 0x062D, 0,
    4, 0xFEA3, 0x062D, 0,
    5, 0xFEA4, 0x062D, 0,
    7, 0xFEA5, 0x062E, 0,
    6, 0xFEA6, 0x062E, 0,
    4, 0xFEA7, 0x062E, 0,
    5, 0xFEA8, 0x062E, 0,
    7, 0xFEA9, 0x062F, 0,
    6, 0xFEAA, 0x062F, 0,
    7, 0xFEAB, 0x0630, 0,
    6, 0xFEAC, 0x0630, 0,
    7, 0xFEAD, 0x0631, 0,
    6, 0xFEAE, 0x0631, 0,
    7, 0xFEAF, 0x0632, 0,
    6, 0xFEB0, 0x0632, 0,
    7, 0xFEB1, 0x0633, 0,
    6, 0xFEB2, 0x0633, 0,
    4, 0xFEB3, 0x0633, 0,
    5, 0xFEB4, 0x0633, 0,
    7, 0xFEB5, 0x0634, 0,
    6, 0xFEB6, 0x0634, 0,
    4, 0xFEB7, 0x0634, 0,
    5, 0xFEB8, 0x0634, 0,
    7, 0xFEB9, 0x0635, 0,
    6, 0xFEBA, 0x0635, 0,
    4, 0xFEBB, 0x0635, 0,
    5, 0xFEBC, 0x0635, 0,
    7, 0xFEBD, 0x0636, 0,
    6, 0xFEBE, 0x0636, 0,
    4, 0xFEBF, 0x0636, 0,
    5, 0xFEC0, 0x0636, 0,
    7, 0xFEC1, 0x0637, 0,
    6, 0xFEC2, 0x0637, 0,
    4, 0xFEC3, 0x0637, 0,
    5, 0xFEC4, 0x0637, 0,
    7, 0xFEC5, 0x0638, 0,
    6, 0xFEC6, 0x0638, 0,
    4, 0xFEC7, 0x0638, 0,
    5, 0xFEC8, 0x0638, 0,
    7, 0xFEC9, 0x0639, 0,
    6, 0xFECA, 0x0639, 0,
    4, 0xFECB, 0x0639, 0,
    5, 0xFECC, 0x0639, 0,
    7, 0xFECD, 0x063A, 0,
    6, 0xFECE, 0x063A, 0,
    4, 0xFECF, 0x063A, 0,
    5, 0xFED0, 0x063A, 0,
    7, 0xFED1, 0x0641, 0,
    6, 0xFED2, 0x0641, 0,
    4, 0xFED3, 0x0641, 0,
    5, 0xFED4, 0x0641, 0,
    7, 0xFED5, 0x0642, 0,
    6, 0xFED6, 0x0642, 0,
    4, 0xFED7, 0x0642, 0,
    5, 0xFED8, 0x0642, 0,
    7, 0xFED9, 0x0643, 0,
    6, 0xFEDA, 0x0643, 0,
    4, 0xFEDB, 0x0643, 0,
    5, 0xFEDC, 0x0643, 0,
    7, 0xFEDD, 0x0644, 0,
    6, 0xFEDE, 0x0644, 0,
    4, 0xFEDF, 0x0644, 0,
    5, 0xFEE0, 0x0644, 0,
    7, 0xFEE1, 0x0645, 0,
    6, 0xFEE2, 0x0645, 0,
    4, 0xFEE3, 0x0645, 0,
    5, 0xFEE4, 0x0645, 0,
    7, 0xFEE5, 0x0646, 0,
    6, 0xFEE6, 0x0646, 0,
    4, 0xFEE7, 0x0646, 0,
    5, 0xFEE8, 0x0646, 0,
    7, 0xFEE9, 0x0647, 0,
    6, 0xFEEA, 0x0647, 0,
    4, 0xFEEB, 0x0647, 0,
    5, 0xFEEC, 0x0647, 0,
    7, 0xFEED, 0x0648, 0,
    6, 0xFEEE, 0x0648, 0,
    7, 0xFEEF, 0x0649, 0,
    6, 0xFEF0, 0x0649, 0,
    7, 0xFEF1, 0x064A, 0,
    6, 0xFEF2, 0x064A, 0,
    4, 0xFEF3, 0x064A, 0,
    5, 0xFEF4, 0x064A, 0,
    7, 0xFEF5, 0x0644, 0x0622, 0,
    6, 0xFEF6, 0x0644, 0x0622, 0,
    7, 0xFEF7, 0x0644, 0x0623, 0,
    6, 0xFEF8, 0x0644, 0x0623, 0,
    7, 0xFEF9, 0x0644, 0x0625, 0,
    6, 0xFEFA, 0x0644, 0x0625, 0,
    7, 0xFEFB, 0x0644, 0x0627, 0,
    6, 0xFEFC, 0x0644, 0x0627, 0,
    12, 0xFF01, 0x0021, 0,
    12, 0xFF02, 0x0022, 0,
    12, 0xFF03, 0x0023, 0,
    12, 0xFF04, 0x0024, 0,
    12, 0xFF05, 0x0025, 0,
    12, 0xFF06, 0x0026, 0,
    12, 0xFF07, 0x0027, 0,
    12, 0xFF08, 0x0028, 0,
    12, 0xFF09, 0x0029, 0,
    12, 0xFF0A, 0x002A, 0,
    12, 0xFF0B, 0x002B, 0,
    12, 0xFF0C, 0x002C, 0,
    12, 0xFF0D, 0x002D, 0,
    12, 0xFF0E, 0x002E, 0,
    12, 0xFF0F, 0x002F, 0,
    12, 0xFF10, 0x0030, 0,
    12, 0xFF11, 0x0031, 0,
    12, 0xFF12, 0x0032, 0,
    12, 0xFF13, 0x0033, 0,
    12, 0xFF14, 0x0034, 0,
    12, 0xFF15, 0x0035, 0,
    12, 0xFF16, 0x0036, 0,
    12, 0xFF17, 0x0037, 0,
    12, 0xFF18, 0x0038, 0,
    12, 0xFF19, 0x0039, 0,
    12, 0xFF1A, 0x003A, 0,
    12, 0xFF1B, 0x003B, 0,
    12, 0xFF1C, 0x003C, 0,
    12, 0xFF1D, 0x003D, 0,
    12, 0xFF1E, 0x003E, 0,
    12, 0xFF1F, 0x003F, 0,
    12, 0xFF20, 0x0040, 0,
    12, 0xFF21, 0x0041, 0,
    12, 0xFF22, 0x0042, 0,
    12, 0xFF23, 0x0043, 0,
    12, 0xFF24, 0x0044, 0,
    12, 0xFF25, 0x0045, 0,
    12, 0xFF26, 0x0046, 0,
    12, 0xFF27, 0x0047, 0,
    12, 0xFF28, 0x0048, 0,
    12, 0xFF29, 0x0049, 0,
    12, 0xFF2A, 0x004A, 0,
    12, 0xFF2B, 0x004B, 0,
    12, 0xFF2C, 0x004C, 0,
    12, 0xFF2D, 0x004D, 0,
    12, 0xFF2E, 0x004E, 0,
    12, 0xFF2F, 0x004F, 0,
    12, 0xFF30, 0x0050, 0,
    12, 0xFF31, 0x0051, 0,
    12, 0xFF32, 0x0052, 0,
    12, 0xFF33, 0x0053, 0,
    12, 0xFF34, 0x0054, 0,
    12, 0xFF35, 0x0055, 0,
    12, 0xFF36, 0x0056, 0,
    12, 0xFF37, 0x0057, 0,
    12, 0xFF38, 0x0058, 0,
    12, 0xFF39, 0x0059, 0,
    12, 0xFF3A, 0x005A, 0,
    12, 0xFF3B, 0x005B, 0,
    12, 0xFF3C, 0x005C, 0,
    12, 0xFF3D, 0x005D, 0,
    12, 0xFF3E, 0x005E, 0,
    12, 0xFF3F, 0x005F, 0,
    12, 0xFF40, 0x0060, 0,
    12, 0xFF41, 0x0061, 0,
    12, 0xFF42, 0x0062, 0,
    12, 0xFF43, 0x0063, 0,
    12, 0xFF44, 0x0064, 0,
    12, 0xFF45, 0x0065, 0,
    12, 0xFF46, 0x0066, 0,
    12, 0xFF47, 0x0067, 0,
    12, 0xFF48, 0x0068, 0,
    12, 0xFF49, 0x0069, 0,
    12, 0xFF4A, 0x006A, 0,
    12, 0xFF4B, 0x006B, 0,
    12, 0xFF4C, 0x006C, 0,
    12, 0xFF4D, 0x006D, 0,
    12, 0xFF4E, 0x006E, 0,
    12, 0xFF4F, 0x006F, 0,
    12, 0xFF50, 0x0070, 0,
    12, 0xFF51, 0x0071, 0,
    12, 0xFF52, 0x0072, 0,
    12, 0xFF53, 0x0073, 0,
    12, 0xFF54, 0x0074, 0,
    12, 0xFF55, 0x0075, 0,
    12, 0xFF56, 0x0076, 0,
    12, 0xFF57, 0x0077, 0,
    12, 0xFF58, 0x0078, 0,
    12, 0xFF59, 0x0079, 0,
    12, 0xFF5A, 0x007A, 0,
    12, 0xFF5B, 0x007B, 0,
    12, 0xFF5C, 0x007C, 0,
    12, 0xFF5D, 0x007D, 0,
    12, 0xFF5E, 0x007E, 0,
    13, 0xFF61, 0x3002, 0,
    13, 0xFF62, 0x300C, 0,
    13, 0xFF63, 0x300D, 0,
    13, 0xFF64, 0x3001, 0,
    13, 0xFF65, 0x30FB, 0,
    13, 0xFF66, 0x30F2, 0,
    13, 0xFF67, 0x30A1, 0,
    13, 0xFF68, 0x30A3, 0,
    13, 0xFF69, 0x30A5, 0,
    13, 0xFF6A, 0x30A7, 0,
    13, 0xFF6B, 0x30A9, 0,
    13, 0xFF6C, 0x30E3, 0,
    13, 0xFF6D, 0x30E5, 0,
    13, 0xFF6E, 0x30E7, 0,
    13, 0xFF6F, 0x30C3, 0,
    13, 0xFF70, 0x30FC, 0,
    13, 0xFF71, 0x30A2, 0,
    13, 0xFF72, 0x30A4, 0,
    13, 0xFF73, 0x30A6, 0,
    13, 0xFF74, 0x30A8, 0,
    13, 0xFF75, 0x30AA, 0,
    13, 0xFF76, 0x30AB, 0,
    13, 0xFF77, 0x30AD, 0,
    13, 0xFF78, 0x30AF, 0,
    13, 0xFF79, 0x30B1, 0,
    13, 0xFF7A, 0x30B3, 0,
    13, 0xFF7B, 0x30B5, 0,
    13, 0xFF7C, 0x30B7, 0,
    13, 0xFF7D, 0x30B9, 0,
    13, 0xFF7E, 0x30BB, 0,
    13, 0xFF7F, 0x30BD, 0,
    13, 0xFF80, 0x30BF, 0,
    13, 0xFF81, 0x30C1, 0,
    13, 0xFF82, 0x30C4, 0,
    13, 0xFF83, 0x30C6, 0,
    13, 0xFF84, 0x30C8, 0,
    13, 0xFF85, 0x30CA, 0,
    13, 0xFF86, 0x30CB, 0,
    13, 0xFF87, 0x30CC, 0,
    13, 0xFF88, 0x30CD, 0,
    13, 0xFF89, 0x30CE, 0,
    13, 0xFF8A, 0x30CF, 0,
    13, 0xFF8B, 0x30D2, 0,
    13, 0xFF8C, 0x30D5, 0,
    13, 0xFF8D, 0x30D8, 0,
    13, 0xFF8E, 0x30DB, 0,
    13, 0xFF8F, 0x30DE, 0,
    13, 0xFF90, 0x30DF, 0,
    13, 0xFF91, 0x30E0, 0,
    13, 0xFF92, 0x30E1, 0,
    13, 0xFF93, 0x30E2, 0,
    13, 0xFF94, 0x30E4, 0,
    13, 0xFF95, 0x30E6, 0,
    13, 0xFF96, 0x30E8, 0,
    13, 0xFF97, 0x30E9, 0,
    13, 0xFF98, 0x30EA, 0,
    13, 0xFF99, 0x30EB, 0,
    13, 0xFF9A, 0x30EC, 0,
    13, 0xFF9B, 0x30ED, 0,
    13, 0xFF9C, 0x30EF, 0,
    13, 0xFF9D, 0x30F3, 0,
    13, 0xFF9E, 0x3099, 0,
    13, 0xFF9F, 0x309A, 0,
    13, 0xFFA0, 0x3164, 0,
    13, 0xFFA1, 0x3131, 0,
    13, 0xFFA2, 0x3132, 0,
    13, 0xFFA3, 0x3133, 0,
    13, 0xFFA4, 0x3134, 0,
    13, 0xFFA5, 0x3135, 0,
    13, 0xFFA6, 0x3136, 0,
    13, 0xFFA7, 0x3137, 0,
    13, 0xFFA8, 0x3138, 0,
    13, 0xFFA9, 0x3139, 0,
    13, 0xFFAA, 0x313A, 0,
    13, 0xFFAB, 0x313B, 0,
    13, 0xFFAC, 0x313C, 0,
    13, 0xFFAD, 0x313D, 0,
    13, 0xFFAE, 0x313E, 0,
    13, 0xFFAF, 0x313F, 0,
    13, 0xFFB0, 0x3140, 0,
    13, 0xFFB1, 0x3141, 0,
    13, 0xFFB2, 0x3142, 0,
    13, 0xFFB3, 0x3143, 0,
    13, 0xFFB4, 0x3144, 0,
    13, 0xFFB5, 0x3145, 0,
    13, 0xFFB6, 0x3146, 0,
    13, 0xFFB7, 0x3147, 0,
    13, 0xFFB8, 0x3148, 0,
    13, 0xFFB9, 0x3149, 0,
    13, 0xFFBA, 0x314A, 0,
    13, 0xFFBB, 0x314B, 0,
    13, 0xFFBC, 0x314C, 0,
    13, 0xFFBD, 0x314D, 0,
    13, 0xFFBE, 0x314E, 0,
    13, 0xFFC2, 0x314F, 0,
    13, 0xFFC3, 0x3150, 0,
    13, 0xFFC4, 0x3151, 0,
    13, 0xFFC5, 0x3152, 0,
    13, 0xFFC6, 0x3153, 0,
    13, 0xFFC7, 0x3154, 0,
    13, 0xFFCA, 0x3155, 0,
    13, 0xFFCB, 0x3156, 0,
    13, 0xFFCC, 0x3157, 0,
    13, 0xFFCD, 0x3158, 0,
    13, 0xFFCE, 0x3159, 0,
    13, 0xFFCF, 0x315A, 0,
    13, 0xFFD2, 0x315B, 0,
    13, 0xFFD3, 0x315C, 0,
    13, 0xFFD4, 0x315D, 0,
    13, 0xFFD5, 0x315E, 0,
    13, 0xFFD6, 0x315F, 0,
    13, 0xFFD7, 0x3160, 0,
    13, 0xFFDA, 0x3161, 0,
    13, 0xFFDB, 0x3162, 0,
    13, 0xFFDC, 0x3163, 0,
    12, 0xFFE0, 0x00A2, 0,
    12, 0xFFE1, 0x00A3, 0,
    12, 0xFFE2, 0x00AC, 0,
    12, 0xFFE3, 0x00AF, 0,
    12, 0xFFE4, 0x00A6, 0,
    12, 0xFFE5, 0x00A5, 0,
    12, 0xFFE6, 0x20A9, 0,
    13, 0xFFE8, 0x2502, 0,
    13, 0xFFE9, 0x2190, 0,
    13, 0xFFEA, 0x2191, 0,
    13, 0xFFEB, 0x2192, 0,
    13, 0xFFEC, 0x2193, 0,
    13, 0xFFED, 0x25A0, 0,
    13, 0xFFEE, 0x25CB, 0,

};

static const Q_UINT16 di_00[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 0, 0, 0, 0, 0, 0,
    5, 0, 10, 0, 0, 0, 0, 14,
    0, 0, 19, 23, 27, 32, 0, 0,
    36, 41, 45, 0, 49, 55, 61, 0,
    67, 72, 77, 82, 87, 92, 0, 97,
    102, 107, 112, 117, 122, 127, 132, 137,
    0, 142, 147, 152, 157, 162, 167, 0,
    0, 172, 177, 182, 187, 192, 0, 0,
    197, 202, 207, 212, 217, 222, 0, 227,
    232, 237, 242, 247, 252, 257, 262, 267,
    0, 272, 277, 282, 287, 292, 297, 0,
    0, 302, 307, 312, 317, 322, 0, 327,
};

static const Q_UINT16 di_01[] = {
    332, 337, 342, 347, 352, 357, 362, 367,
    372, 377, 382, 387, 392, 397, 402, 407,
    0, 0, 412, 417, 422, 427, 432, 437,
    442, 447, 452, 457, 462, 467, 472, 477,
    482, 487, 492, 497, 502, 507, 0, 0,
    512, 517, 522, 527, 532, 537, 542, 547,
    552, 0, 557, 562, 567, 572, 577, 582,
    0, 587, 592, 597, 602, 607, 612, 617,
    622, 0, 0, 627, 632, 637, 642, 647,
    652, 657, 0, 0, 662, 667, 672, 677,
    682, 687, 0, 0, 692, 697, 702, 707,
    712, 717, 722, 727, 732, 737, 742, 747,
    752, 757, 762, 767, 772, 777, 0, 0,
    782, 787, 792, 797, 802, 807, 812, 817,
    822, 827, 832, 837, 842, 847, 852, 857,
    862, 867, 872, 877, 882, 887, 892, 897,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    901, 906, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 911,
    916, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 921, 926, 931, 936,
    941, 946, 951, 956, 961, 966, 971, 976,
    981, 986, 991, 996, 1001, 1006, 1011, 1016,
    1021, 1026, 1031, 1036, 1041, 0, 1046, 1051,
    1056, 1061, 1066, 1071, 0, 0, 1076, 1081,
    1086, 1091, 1096, 1101, 1106, 1111, 1116, 1121,
    1126, 1131, 1136, 1141, 1146, 1151, 0, 0,
    1156, 1161, 1166, 1171, 1176, 1181, 1186, 1191,
};

static const Q_UINT16 di_02[] = {
    1196, 1201, 1206, 1211, 1216, 1221, 1226, 1231,
    1236, 1241, 1246, 1251, 1256, 1261, 1266, 1271,
    1276, 1281, 1286, 1291, 1296, 1301, 1306, 1311,
    1316, 1321, 1326, 1331, 0, 0, 1336, 1341,
    0, 0, 0, 0, 0, 0, 1346, 1351,
    1356, 1361, 1366, 1371, 1376, 1381, 1386, 1391,
    1396, 1401, 1406, 1411, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1416, 1420, 1424, 1428, 1432, 1436, 1440, 1444,
    1448, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1452, 1457, 1462, 1467, 1472, 1477, 0, 0,
    1482, 1486, 1490, 1494, 1498, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_03[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1502, 1506, 0, 1510, 1514, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1519, 0, 0, 0,
    0, 0, 1523, 0, 0, 0, 1528, 0,
    0, 0, 0, 0, 1532, 1537, 1542, 1547,
    1551, 1556, 1561, 0, 1566, 0, 1571, 1576,
    1581, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1586, 1591, 1596, 1601, 1606, 1611,
    1616, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1621, 1626, 1631, 1636, 1641, 0,
    1646, 1650, 1654, 1658, 1663, 1668, 1672, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1676, 1680, 1684, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_04[] = {
    1688, 1693, 0, 1698, 0, 0, 0, 1703,
    0, 0, 0, 0, 1708, 1713, 1718, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1723, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1728, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1733, 1738, 0, 1743, 0, 0, 0, 1748,
    0, 0, 0, 0, 1753, 1758, 1763, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1768, 1773,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1778, 1783, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1788, 1793, 1798, 1803, 0, 0, 1808, 1813,
    0, 0, 1818, 1823, 1828, 1833, 1838, 1843,
    0, 0, 1848, 1853, 1858, 1863, 1868, 1873,
    0, 0, 1878, 1883, 1888, 1893, 1898, 1903,
    1908, 1913, 1918, 1923, 1928, 1933, 0, 0,
    1938, 1943, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_05[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1948,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_06[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1953, 1958, 1963, 1968, 1973, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1978, 1983, 1988,
    1993, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1998, 0, 2003, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2008, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_07[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_09[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2013, 0, 0, 0, 0, 0, 0,
    0, 2018, 0, 0, 2023, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2028, 2033, 2038, 2043, 2048, 2053, 2058, 2063,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2068, 2073, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2078, 2083, 0, 2088,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_0A[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2093, 0, 0, 2098, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2103, 2108, 2113, 0, 0, 2118, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_0B[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2123, 0, 0, 2128, 2133, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2138, 2143, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2148, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2153, 2158, 2163, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_0C[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2168, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2173, 0, 0, 0, 0, 0, 0, 2178,
    2183, 0, 2188, 2193, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_0D[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2198, 2203, 2208, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2213, 0, 2218, 2223, 2228, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_0E[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2233, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2238, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2243, 2248, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_0F[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2253, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2257, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 2262, 0, 0,
    0, 0, 2267, 0, 0, 0, 0, 2272,
    0, 0, 0, 0, 2277, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2282, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2287, 0, 2292, 2297, 2302,
    2307, 2312, 0, 0, 0, 0, 0, 0,
    0, 2317, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2322, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 2327, 0, 0,
    0, 0, 2332, 0, 0, 0, 0, 2337,
    0, 0, 0, 0, 2342, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2347, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_10[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 2352, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_1E[] = {
    2357, 2362, 2367, 2372, 2377, 2382, 2387, 2392,
    2397, 2402, 2407, 2412, 2417, 2422, 2427, 2432,
    2437, 2442, 2447, 2452, 2457, 2462, 2467, 2472,
    2477, 2482, 2487, 2492, 2497, 2502, 2507, 2512,
    2517, 2522, 2527, 2532, 2537, 2542, 2547, 2552,
    2557, 2562, 2567, 2572, 2577, 2582, 2587, 2592,
    2597, 2602, 2607, 2612, 2617, 2622, 2627, 2632,
    2637, 2642, 2647, 2652, 2657, 2662, 2667, 2672,
    2677, 2682, 2687, 2692, 2697, 2702, 2707, 2712,
    2717, 2722, 2727, 2732, 2737, 2742, 2747, 2752,
    2757, 2762, 2767, 2772, 2777, 2782, 2787, 2792,
    2797, 2802, 2807, 2812, 2817, 2822, 2827, 2832,
    2837, 2842, 2847, 2852, 2857, 2862, 2867, 2872,
    2877, 2882, 2887, 2892, 2897, 2902, 2907, 2912,
    2917, 2922, 2927, 2932, 2937, 2942, 2947, 2952,
    2957, 2962, 2967, 2972, 2977, 2982, 2987, 2992,
    2997, 3002, 3007, 3012, 3017, 3022, 3027, 3032,
    3037, 3042, 3047, 3052, 3057, 3062, 3067, 3072,
    3077, 3082, 3087, 3092, 3097, 3102, 3107, 3112,
    3117, 3122, 3127, 3132, 0, 0, 0, 0,
    3137, 3142, 3147, 3152, 3157, 3162, 3167, 3172,
    3177, 3182, 3187, 3192, 3197, 3202, 3207, 3212,
    3217, 3222, 3227, 3232, 3237, 3242, 3247, 3252,
    3257, 3262, 3267, 3272, 3277, 3282, 3287, 3292,
    3297, 3302, 3307, 3312, 3317, 3322, 3327, 3332,
    3337, 3342, 3347, 3352, 3357, 3362, 3367, 3372,
    3377, 3382, 3387, 3392, 3397, 3402, 3407, 3412,
    3417, 3422, 3427, 3432, 3437, 3442, 3447, 3452,
    3457, 3462, 3467, 3472, 3477, 3482, 3487, 3492,
    3497, 3502, 3507, 3512, 3517, 3522, 3527, 3532,
    3537, 3542, 3547, 3552, 3557, 3562, 3567, 3572,
    3577, 3582, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_1F[] = {
    3587, 3592, 3597, 3602, 3607, 3612, 3617, 3622,
    3627, 3632, 3637, 3642, 3647, 3652, 3657, 3662,
    3667, 3672, 3677, 3682, 3687, 3692, 0, 0,
    3697, 3702, 3707, 3712, 3717, 3722, 0, 0,
    3727, 3732, 3737, 3742, 3747, 3752, 3757, 3762,
    3767, 3772, 3777, 3782, 3787, 3792, 3797, 3802,
    3807, 3812, 3817, 3822, 3827, 3832, 3837, 3842,
    3847, 3852, 3857, 3862, 3867, 3872, 3877, 3882,
    3887, 3892, 3897, 3902, 3907, 3912, 0, 0,
    3917, 3922, 3927, 3932, 3937, 3942, 0, 0,
    3947, 3952, 3957, 3962, 3967, 3972, 3977, 3982,
    0, 3987, 0, 3992, 0, 3997, 0, 4002,
    4007, 4012, 4017, 4022, 4027, 4032, 4037, 4042,
    4047, 4052, 4057, 4062, 4067, 4072, 4077, 4082,
    4087, 4092, 4096, 4101, 4105, 4110, 4114, 4119,
    4123, 4128, 4132, 4137, 4141, 4146, 0, 0,
    4150, 4155, 4160, 4165, 4170, 4175, 4180, 4185,
    4190, 4195, 4200, 4205, 4210, 4215, 4220, 4225,
    4230, 4235, 4240, 4245, 4250, 4255, 4260, 4265,
    4270, 4275, 4280, 4285, 4290, 4295, 4300, 4305,
    4310, 4315, 4320, 4325, 4330, 4335, 4340, 4345,
    4350, 4355, 4360, 4365, 4370, 4375, 4380, 4385,
    4390, 4395, 4400, 4405, 4410, 0, 4415, 4420,
    4425, 4430, 4435, 4440, 4444, 4449, 4454, 4458,
    4463, 4468, 4473, 4478, 4483, 0, 4488, 4493,
    4498, 4503, 4507, 4512, 4516, 4521, 4526, 4531,
    4536, 4541, 4546, 4551, 0, 0, 4555, 4560,
    4565, 4570, 4575, 4580, 0, 4584, 4589, 4594,
    4599, 4604, 4609, 4614, 4618, 4623, 4628, 4633,
    4638, 4643, 4648, 4653, 4657, 4662, 4667, 4671,
    0, 0, 4675, 4680, 4685, 0, 4690, 4695,
    4700, 4705, 4709, 4714, 4718, 4723, 4727, 0,
};

static const Q_UINT16 di_20[] = {
    4732, 4736, 4740, 4744, 4748, 4752, 4756, 4760,
    4764, 4768, 4772, 0, 0, 0, 0, 0,
    0, 4776, 0, 0, 0, 0, 0, 4780,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 4785, 4789, 4794, 0,
    0, 0, 0, 0, 0, 0, 0, 4800,
    0, 0, 0, 4804, 4809, 0, 4815, 4820,
    0, 0, 0, 0, 4826, 0, 4831, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4836, 4841, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4846, 0, 0, 0, 4850, 4854, 4858, 4862,
    4866, 4870, 4874, 4878, 4882, 4886, 4890, 4894,
    4898, 4902, 4906, 4910, 4914, 4918, 4922, 4926,
    4930, 4934, 4938, 4942, 4946, 4950, 4954, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4958, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_21[] = {
    4963, 4969, 4975, 4979, 0, 4984, 4990, 4996,
    0, 5000, 5005, 5009, 5013, 5017, 5021, 5025,
    5029, 5033, 5037, 5041, 0, 5045, 5049, 0,
    0, 5054, 5058, 5062, 5066, 5070, 0, 0,
    5074, 5079, 5085, 0, 5090, 0, 5094, 0,
    5098, 0, 5102, 5106, 5110, 5114, 0, 5118,
    5122, 5126, 0, 5130, 5134, 5138, 5142, 5146,
    5150, 5154, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 5158, 5164, 5170, 5176, 5182,
    5188, 5194, 5200, 5206, 5212, 5218, 5224, 5230,
    5235, 5239, 5244, 5250, 5255, 5259, 5264, 5270,
    5277, 5282, 5286, 5291, 5297, 5301, 5305, 5309,
    5313, 5317, 5322, 5328, 5333, 5337, 5342, 5348,
    5355, 5360, 5364, 5369, 5375, 5379, 5383, 5387,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 5391, 5396, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 5401, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 5406, 5411, 5416,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_22[] = {
    0, 0, 0, 0, 5421, 0, 0, 0,
    0, 5426, 0, 0, 5431, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 5436, 0, 5441, 0,
    0, 0, 0, 0, 5446, 5451, 0, 5457,
    5462, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 5468, 0, 0, 5473, 0, 0, 5478,
    0, 5483, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    5488, 0, 5493, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 5498, 5503, 5508,
    5513, 5518, 0, 0, 5523, 5528, 0, 0,
    5533, 5538, 0, 0, 0, 0, 0, 0,
    5543, 5548, 0, 0, 5553, 5558, 0, 0,
    5563, 5568, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 5573, 5578, 5583, 5588,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    5593, 5598, 5603, 5608, 0, 0, 0, 0,
    0, 0, 5613, 5618, 5623, 5628, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_23[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 5633, 5637, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_24[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    5641, 5645, 5649, 5653, 5657, 5661, 5665, 5669,
    5673, 5677, 5682, 5687, 5692, 5697, 5702, 5707,
    5712, 5717, 5722, 5727, 5732, 5738, 5744, 5750,
    5756, 5762, 5768, 5774, 5780, 5786, 5793, 5800,
    5807, 5814, 5821, 5828, 5835, 5842, 5849, 5856,
    5863, 5868, 5873, 5878, 5883, 5888, 5893, 5898,
    5903, 5908, 5914, 5920, 5926, 5932, 5938, 5944,
    5950, 5956, 5962, 5968, 5974, 5980, 5986, 5992,
    5998, 6004, 6010, 6016, 6022, 6028, 6034, 6040,
    6046, 6052, 6058, 6064, 6070, 6076, 6082, 6088,
    6094, 6100, 6106, 6112, 6118, 6124, 6130, 6134,
    6138, 6142, 6146, 6150, 6154, 6158, 6162, 6166,
    6170, 6174, 6178, 6182, 6186, 6190, 6194, 6198,
    6202, 6206, 6210, 6214, 6218, 6222, 6226, 6230,
    6234, 6238, 6242, 6246, 6250, 6254, 6258, 6262,
    6266, 6270, 6274, 6278, 6282, 6286, 6290, 6294,
    6298, 6302, 6306, 6310, 6314, 6318, 6322, 6326,
    6330, 6334, 6338, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_2E[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 6342,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 6346, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_2F[] = {
    6350, 6354, 6358, 6362, 6366, 6370, 6374, 6378,
    6382, 6386, 6390, 6394, 6398, 6402, 6406, 6410,
    6414, 6418, 6422, 6426, 6430, 6434, 6438, 6442,
    6446, 6450, 6454, 6458, 6462, 6466, 6470, 6474,
    6478, 6482, 6486, 6490, 6494, 6498, 6502, 6506,
    6510, 6514, 6518, 6522, 6526, 6530, 6534, 6538,
    6542, 6546, 6550, 6554, 6558, 6562, 6566, 6570,
    6574, 6578, 6582, 6586, 6590, 6594, 6598, 6602,
    6606, 6610, 6614, 6618, 6622, 6626, 6630, 6634,
    6638, 6642, 6646, 6650, 6654, 6658, 6662, 6666,
    6670, 6674, 6678, 6682, 6686, 6690, 6694, 6698,
    6702, 6706, 6710, 6714, 6718, 6722, 6726, 6730,
    6734, 6738, 6742, 6746, 6750, 6754, 6758, 6762,
    6766, 6770, 6774, 6778, 6782, 6786, 6790, 6794,
    6798, 6802, 6806, 6810, 6814, 6818, 6822, 6826,
    6830, 6834, 6838, 6842, 6846, 6850, 6854, 6858,
    6862, 6866, 6870, 6874, 6878, 6882, 6886, 6890,
    6894, 6898, 6902, 6906, 6910, 6914, 6918, 6922,
    6926, 6930, 6934, 6938, 6942, 6946, 6950, 6954,
    6958, 6962, 6966, 6970, 6974, 6978, 6982, 6986,
    6990, 6994, 6998, 7002, 7006, 7010, 7014, 7018,
    7022, 7026, 7030, 7034, 7038, 7042, 7046, 7050,
    7054, 7058, 7062, 7066, 7070, 7074, 7078, 7082,
    7086, 7090, 7094, 7098, 7102, 7106, 7110, 7114,
    7118, 7122, 7126, 7130, 7134, 7138, 7142, 7146,
    7150, 7154, 7158, 7162, 7166, 7170, 7174, 7178,
    7182, 7186, 7190, 7194, 7198, 7202, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_30[] = {
    7206, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 7210, 0,
    7214, 7218, 7222, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7226, 0, 7231, 0,
    7236, 0, 7241, 0, 7246, 0, 7251, 0,
    7256, 0, 7261, 0, 7266, 0, 7271, 0,
    7276, 0, 7281, 0, 0, 7286, 0, 7291,
    0, 7296, 0, 0, 0, 0, 0, 0,
    7301, 7306, 0, 7311, 7316, 0, 7321, 7326,
    0, 7331, 7336, 0, 7341, 7346, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7351, 0, 0, 0,
    0, 0, 0, 7356, 7361, 0, 7366, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7371, 0, 7376, 0,
    7381, 0, 7386, 0, 7391, 0, 7396, 0,
    7401, 0, 7406, 0, 7411, 0, 7416, 0,
    7421, 0, 7426, 0, 0, 7431, 0, 7436,
    0, 7441, 0, 0, 0, 0, 0, 0,
    7446, 7451, 0, 7456, 7461, 0, 7466, 7471,
    0, 7476, 7481, 0, 7486, 7491, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7496, 0, 0, 7501,
    7506, 7511, 7516, 0, 0, 0, 7521, 0,
};

static const Q_UINT16 di_31[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 7526, 7530, 7534, 7538, 7542, 7546, 7550,
    7554, 7558, 7562, 7566, 7570, 7574, 7578, 7582,
    7586, 7590, 7594, 7598, 7602, 7606, 7610, 7614,
    7618, 7622, 7626, 7630, 7634, 7638, 7642, 7646,
    7650, 7654, 7658, 7662, 7666, 7670, 7674, 7678,
    7682, 7686, 7690, 7694, 7698, 7702, 7706, 7710,
    7714, 7718, 7722, 7726, 7730, 7734, 7738, 7742,
    7746, 7750, 7754, 7758, 7762, 7766, 7770, 7774,
    7778, 7782, 7786, 7790, 7794, 7798, 7802, 7806,
    7810, 7814, 7818, 7822, 7826, 7830, 7834, 7838,
    7842, 7846, 7850, 7854, 7858, 7862, 7866, 7870,
    7874, 7878, 7882, 7886, 7890, 7894, 7898, 0,
    0, 0, 7902, 7906, 7910, 7914, 7918, 7922,
    7926, 7930, 7934, 7938, 7942, 7946, 7950, 7954,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_32[] = {
    7958, 7964, 7970, 7976, 7982, 7988, 7994, 8000,
    8006, 8012, 8018, 8024, 8030, 8036, 8042, 8049,
    8056, 8063, 8070, 8077, 8084, 8091, 8098, 8105,
    8112, 8119, 8126, 8133, 8140, 0, 0, 0,
    8147, 8153, 8159, 8165, 8171, 8177, 8183, 8189,
    8195, 8201, 8207, 8213, 8219, 8225, 8231, 8237,
    8243, 8249, 8255, 8261, 8267, 8273, 8279, 8285,
    8291, 8297, 8303, 8309, 8315, 8321, 8327, 8333,
    8339, 8345, 8351, 8357, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    8363, 8367, 8371, 8375, 8379, 8383, 8387, 8391,
    8395, 8399, 8403, 8407, 8411, 8415, 8419, 8424,
    8429, 8434, 8439, 8444, 8449, 8454, 8459, 8464,
    8469, 8474, 8479, 8484, 0, 0, 0, 0,
    8489, 8493, 8497, 8501, 8505, 8509, 8513, 8517,
    8521, 8525, 8529, 8533, 8537, 8541, 8545, 8549,
    8553, 8557, 8561, 8565, 8569, 8573, 8577, 8581,
    8585, 8589, 8593, 8597, 8601, 8605, 8609, 8613,
    8617, 8621, 8625, 8629, 8633, 8637, 8641, 8645,
    8649, 8653, 8657, 8661, 8665, 8669, 8673, 8677,
    8681, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    8685, 8690, 8695, 8700, 8705, 8710, 8715, 8720,
    8725, 8730, 8736, 8742, 0, 0, 0, 0,
    8748, 8752, 8756, 8760, 8764, 8768, 8772, 8776,
    8780, 8784, 8788, 8792, 8796, 8800, 8804, 8808,
    8812, 8816, 8820, 8824, 8828, 8832, 8836, 8840,
    8844, 8848, 8852, 8856, 8860, 8864, 8868, 8872,
    8876, 8880, 8884, 8888, 8892, 8896, 8900, 8904,
    8908, 8912, 8916, 8920, 8924, 8928, 8932, 0,
};

static const Q_UINT16 di_33[] = {
    8936, 8943, 8950, 8957, 8963, 8970, 8976, 8982,
    8990, 8997, 9003, 9009, 9015, 9022, 9029, 9035,
    9041, 9046, 9052, 9059, 9066, 9071, 9079, 9088,
    9096, 9102, 9110, 9118, 9125, 9131, 9137, 9143,
    9150, 9158, 9165, 9171, 9177, 9183, 9188, 9193,
    9198, 9203, 9209, 9215, 9223, 9229, 9236, 9244,
    9250, 9255, 9260, 9268, 9275, 9283, 9289, 9297,
    9302, 9308, 9314, 9320, 9326, 9332, 9339, 9345,
    9350, 9356, 9362, 9368, 9375, 9381, 9387, 9393,
    9401, 9408, 9413, 9421, 9426, 9433, 9440, 9446,
    9452, 9458, 9465, 9470, 9476, 9483, 9488, 9496,
    9502, 9507, 9512, 9517, 9522, 9527, 9532, 9537,
    9542, 9547, 9552, 9558, 9564, 9570, 9576, 9582,
    9588, 9594, 9600, 9606, 9612, 9618, 9624, 9630,
    9636, 9642, 9648, 9653, 9658, 9664, 9669, 0,
    0, 0, 0, 9674, 9679, 9684, 9689, 9694,
    9701, 9706, 9711, 9716, 9721, 9726, 9731, 9736,
    9741, 9747, 9754, 9759, 9764, 9769, 9774, 9779,
    9784, 9789, 9795, 9801, 9807, 9813, 9818, 9823,
    9828, 9833, 9838, 9843, 9848, 9853, 9858, 9863,
    9869, 9875, 9880, 9886, 9892, 9898, 9903, 9909,
    9915, 9922, 9927, 9933, 9939, 9945, 9951, 9959,
    9968, 9973, 9978, 9983, 9988, 9993, 9998, 10003,
    10008, 10013, 10018, 10023, 10028, 10033, 10038, 10043,
    10048, 10053, 10058, 10065, 10070, 10075, 10080, 10087,
    10093, 10098, 10103, 10108, 10113, 10118, 10123, 10128,
    10133, 10138, 10143, 10149, 10154, 10159, 10165, 10171,
    10176, 10183, 10189, 10194, 10199, 10204, 0, 0,
    10209, 10214, 10219, 10224, 10229, 10234, 10239, 10244,
    10249, 10254, 10260, 10266, 10272, 10278, 10284, 10290,
    10296, 10302, 10308, 10314, 10320, 10326, 10332, 10338,
    10344, 10350, 10356, 10362, 10368, 10374, 10380, 0,
};

static const Q_UINT16 di_F9[] = {
    10386, 10390, 10394, 10398, 10402, 10406, 10410, 10414,
    10418, 10422, 10426, 10430, 10434, 10438, 10442, 10446,
    10450, 10454, 10458, 10462, 10466, 10470, 10474, 10478,
    10482, 10486, 10490, 10494, 10498, 10502, 10506, 10510,
    10514, 10518, 10522, 10526, 10530, 10534, 10538, 10542,
    10546, 10550, 10554, 10558, 10562, 10566, 10570, 10574,
    10578, 10582, 10586, 10590, 10594, 10598, 10602, 10606,
    10610, 10614, 10618, 10622, 10626, 10630, 10634, 10638,
    10642, 10646, 10650, 10654, 10658, 10662, 10666, 10670,
    10674, 10678, 10682, 10686, 10690, 10694, 10698, 10702,
    10706, 10710, 10714, 10718, 10722, 10726, 10730, 10734,
    10738, 10742, 10746, 10750, 10754, 10758, 10762, 10766,
    10770, 10774, 10778, 10782, 10786, 10790, 10794, 10798,
    10802, 10806, 10810, 10814, 10818, 10822, 10826, 10830,
    10834, 10838, 10842, 10846, 10850, 10854, 10858, 10862,
    10866, 10870, 10874, 10878, 10882, 10886, 10890, 10894,
    10898, 10902, 10906, 10910, 10914, 10918, 10922, 10926,
    10930, 10934, 10938, 10942, 10946, 10950, 10954, 10958,
    10962, 10966, 10970, 10974, 10978, 10982, 10986, 10990,
    10994, 10998, 11002, 11006, 11010, 11014, 11018, 11022,
    11026, 11030, 11034, 11038, 11042, 11046, 11050, 11054,
    11058, 11062, 11066, 11070, 11074, 11078, 11082, 11086,
    11090, 11094, 11098, 11102, 11106, 11110, 11114, 11118,
    11122, 11126, 11130, 11134, 11138, 11142, 11146, 11150,
    11154, 11158, 11162, 11166, 11170, 11174, 11178, 11182,
    11186, 11190, 11194, 11198, 11202, 11206, 11210, 11214,
    11218, 11222, 11226, 11230, 11234, 11238, 11242, 11246,
    11250, 11254, 11258, 11262, 11266, 11270, 11274, 11278,
    11282, 11286, 11290, 11294, 11298, 11302, 11306, 11310,
    11314, 11318, 11322, 11326, 11330, 11334, 11338, 11342,
    11346, 11350, 11354, 11358, 11362, 11366, 11370, 11374,
    11378, 11382, 11386, 11390, 11394, 11398, 11402, 11406,
};

static const Q_UINT16 di_FA[] = {
    11410, 11414, 11418, 11422, 11426, 11430, 11434, 11438,
    11442, 11446, 11450, 11454, 11458, 11462, 0, 0,
    11466, 0, 11470, 0, 0, 11474, 11478, 11482,
    11486, 11490, 11494, 11498, 11502, 11506, 11510, 0,
    11514, 0, 11518, 0, 0, 11522, 11526, 0,
    0, 0, 11530, 11534, 11538, 11542, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_FB[] = {
    11546, 11551, 11556, 11561, 11567, 11573, 11578, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 11583, 11588, 11593, 11598, 11603,
    0, 0, 0, 0, 0, 11608, 0, 11613,
    11618, 11622, 11626, 11630, 11634, 11638, 11642, 11646,
    11650, 11654, 11658, 11663, 11668, 11673, 11678, 11683,
    11688, 11693, 11698, 11703, 11708, 11713, 11718, 0,
    11723, 11728, 11733, 11738, 11743, 0, 11748, 0,
    11753, 11758, 0, 11763, 11768, 0, 11773, 11778,
    11783, 11788, 11793, 11798, 11803, 11808, 11813, 11818,
    11823, 11827, 11831, 11835, 11839, 11843, 11847, 11851,
    11855, 11859, 11863, 11867, 11871, 11875, 11879, 11883,
    11887, 11891, 11895, 11899, 11903, 11907, 11911, 11915,
    11919, 11923, 11927, 11931, 11935, 11939, 11943, 11947,
    11951, 11955, 11959, 11963, 11967, 11971, 11975, 11979,
    11983, 11987, 11991, 11995, 11999, 12003, 12007, 12011,
    12015, 12019, 12023, 12027, 12031, 12035, 12039, 12043,
    12047, 12051, 12055, 12059, 12063, 12067, 12071, 12075,
    12079, 12083, 12087, 12091, 12095, 12099, 12103, 12107,
    12111, 12115, 12119, 12123, 12127, 12131, 12135, 12139,
    12143, 12147, 12151, 12155, 12159, 12163, 12167, 12171,
    12175, 12179, 12183, 12187, 12191, 12195, 12199, 12203,
    12207, 12211, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 12215, 12219, 12223, 12227, 12231,
    12235, 12239, 12243, 12247, 12251, 12255, 12259, 12263,
    12267, 12271, 12275, 12279, 12283, 12287, 12291, 12295,
    12299, 12303, 12307, 12312, 12317, 12322, 12327, 12332,
    12337, 12342, 12347, 12352, 12357, 12362, 12367, 12372,
    12377, 12382, 12387, 12392, 12397, 12401, 12405, 12409,
};

static const Q_UINT16 di_FC[] = {
    12413, 12418, 12423, 12428, 12433, 12438, 12443, 12448,
    12453, 12458, 12463, 12468, 12473, 12478, 12483, 12488,
    12493, 12498, 12503, 12508, 12513, 12518, 12523, 12528,
    12533, 12538, 12543, 12548, 12553, 12558, 12563, 12568,
    12573, 12578, 12583, 12588, 12593, 12598, 12603, 12608,
    12613, 12618, 12623, 12628, 12633, 12638, 12643, 12648,
    12653, 12658, 12663, 12668, 12673, 12678, 12683, 12688,
    12693, 12698, 12703, 12708, 12713, 12718, 12723, 12728,
    12733, 12738, 12743, 12748, 12753, 12758, 12763, 12768,
    12773, 12778, 12783, 12788, 12793, 12798, 12803, 12808,
    12813, 12818, 12823, 12828, 12833, 12838, 12843, 12848,
    12853, 12858, 12863, 12868, 12873, 12878, 12883, 12889,
    12895, 12901, 12907, 12913, 12919, 12924, 12929, 12934,
    12939, 12944, 12949, 12954, 12959, 12964, 12969, 12974,
    12979, 12984, 12989, 12994, 12999, 13004, 13009, 13014,
    13019, 13024, 13029, 13034, 13039, 13044, 13049, 13054,
    13059, 13064, 13069, 13074, 13079, 13084, 13089, 13094,
    13099, 13104, 13109, 13114, 13119, 13124, 13129, 13134,
    13139, 13144, 13149, 13154, 13159, 13164, 13169, 13174,
    13179, 13184, 13189, 13194, 13199, 13204, 13209, 13214,
    13219, 13224, 13229, 13234, 13239, 13244, 13249, 13254,
    13259, 13264, 13269, 13274, 13279, 13284, 13289, 13294,
    13299, 13304, 13309, 13314, 13319, 13324, 13329, 13334,
    13339, 13344, 13349, 13354, 13359, 13364, 13369, 13374,
    13379, 13384, 13389, 13394, 13399, 13404, 13409, 13414,
    13419, 13424, 13429, 13434, 13439, 13444, 13449, 13454,
    13459, 13464, 13469, 13474, 13479, 13484, 13489, 13494,
    13499, 13504, 13509, 13514, 13519, 13524, 13529, 13534,
    13539, 13544, 13549, 13554, 13559, 13564, 13569, 13574,
    13579, 13584, 13589, 13594, 13599, 13604, 13609, 13614,
    13619, 13624, 13629, 13635, 13641, 13647, 13652, 13657,
    13662, 13667, 13672, 13677, 13682, 13687, 13692, 13697,
};

static const Q_UINT16 di_FD[] = {
    13702, 13707, 13712, 13717, 13722, 13727, 13732, 13737,
    13742, 13747, 13752, 13757, 13762, 13767, 13772, 13777,
    13782, 13787, 13792, 13797, 13802, 13807, 13812, 13817,
    13822, 13827, 13832, 13837, 13842, 13847, 13852, 13857,
    13862, 13867, 13872, 13877, 13882, 13887, 13892, 13897,
    13902, 13907, 13912, 13917, 13922, 13927, 13932, 13937,
    13942, 13947, 13952, 13957, 13962, 13967, 13972, 13977,
    13982, 13987, 13992, 13997, 14002, 14007, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    14012, 14018, 14024, 14030, 14036, 14042, 14048, 14054,
    14060, 14066, 14072, 14078, 14084, 14090, 14096, 14102,
    14108, 14114, 14120, 14126, 14132, 14138, 14144, 14150,
    14156, 14162, 14168, 14174, 14180, 14186, 14192, 14198,
    14204, 14210, 14216, 14222, 14228, 14234, 14240, 14246,
    14252, 14258, 14264, 14270, 14276, 14282, 14288, 14294,
    14300, 14306, 14312, 14318, 14324, 14330, 14336, 14342,
    14348, 14354, 14360, 14366, 14372, 14378, 14384, 14390,
    0, 0, 14396, 14402, 14408, 14414, 14420, 14426,
    14432, 14438, 14444, 14450, 14456, 14462, 14468, 14474,
    14480, 14486, 14492, 14498, 14504, 14510, 14516, 14522,
    14528, 14534, 14540, 14546, 14552, 14558, 14564, 14570,
    14576, 14582, 14588, 14594, 14600, 14606, 14612, 14618,
    14624, 14630, 14636, 14642, 14648, 14654, 14660, 14666,
    14672, 14678, 14684, 14690, 14696, 14702, 14708, 14714,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    14720, 14726, 14732, 14739, 14746, 14753, 14760, 14767,
    14774, 14781, 14787, 14808, 0, 0, 0, 0,
};

static const Q_UINT16 di_FE[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    14819, 14823, 14827, 14831, 14835, 14839, 14843, 14847,
    14851, 14855, 14859, 14863, 14867, 14871, 14875, 14879,
    14883, 14887, 14891, 14895, 14899, 0, 0, 0,
    0, 14903, 14907, 14911, 14915, 14919, 14923, 14927,
    14931, 14935, 14939, 0, 14943, 14947, 14951, 14955,
    14959, 14963, 14967, 14971, 14975, 14979, 14983, 14987,
    14991, 14995, 14999, 15003, 15007, 15011, 15015, 0,
    15019, 15023, 15027, 15031, 0, 0, 0, 0,
    15035, 15040, 15045, 0, 15050, 0, 15055, 15060,
    15065, 15070, 15075, 15080, 15085, 15090, 15095, 15100,
    15105, 15109, 15113, 15117, 15121, 15125, 15129, 15133,
    15137, 15141, 15145, 15149, 15153, 15157, 15161, 15165,
    15169, 15173, 15177, 15181, 15185, 15189, 15193, 15197,
    15201, 15205, 15209, 15213, 15217, 15221, 15225, 15229,
    15233, 15237, 15241, 15245, 15249, 15253, 15257, 15261,
    15265, 15269, 15273, 15277, 15281, 15285, 15289, 15293,
    15297, 15301, 15305, 15309, 15313, 15317, 15321, 15325,
    15329, 15333, 15337, 15341, 15345, 15349, 15353, 15357,
    15361, 15365, 15369, 15373, 15377, 15381, 15385, 15389,
    15393, 15397, 15401, 15405, 15409, 15413, 15417, 15421,
    15425, 15429, 15433, 15437, 15441, 15445, 15449, 15453,
    15457, 15461, 15465, 15469, 15473, 15477, 15481, 15485,
    15489, 15493, 15497, 15501, 15505, 15509, 15513, 15517,
    15521, 15525, 15529, 15533, 15537, 15541, 15545, 15549,
    15553, 15557, 15561, 15565, 15569, 15573, 15578, 15583,
    15588, 15593, 15598, 15603, 15608, 0, 0, 0,
};

static const Q_UINT16 di_FF[] = {
    0, 15613, 15617, 15621, 15625, 15629, 15633, 15637,
    15641, 15645, 15649, 15653, 15657, 15661, 15665, 15669,
    15673, 15677, 15681, 15685, 15689, 15693, 15697, 15701,
    15705, 15709, 15713, 15717, 15721, 15725, 15729, 15733,
    15737, 15741, 15745, 15749, 15753, 15757, 15761, 15765,
    15769, 15773, 15777, 15781, 15785, 15789, 15793, 15797,
    15801, 15805, 15809, 15813, 15817, 15821, 15825, 15829,
    15833, 15837, 15841, 15845, 15849, 15853, 15857, 15861,
    15865, 15869, 15873, 15877, 15881, 15885, 15889, 15893,
    15897, 15901, 15905, 15909, 15913, 15917, 15921, 15925,
    15929, 15933, 15937, 15941, 15945, 15949, 15953, 15957,
    15961, 15965, 15969, 15973, 15977, 15981, 15985, 0,
    0, 15989, 15993, 15997, 16001, 16005, 16009, 16013,
    16017, 16021, 16025, 16029, 16033, 16037, 16041, 16045,
    16049, 16053, 16057, 16061, 16065, 16069, 16073, 16077,
    16081, 16085, 16089, 16093, 16097, 16101, 16105, 16109,
    16113, 16117, 16121, 16125, 16129, 16133, 16137, 16141,
    16145, 16149, 16153, 16157, 16161, 16165, 16169, 16173,
    16177, 16181, 16185, 16189, 16193, 16197, 16201, 16205,
    16209, 16213, 16217, 16221, 16225, 16229, 16233, 16237,
    16241, 16245, 16249, 16253, 16257, 16261, 16265, 16269,
    16273, 16277, 16281, 16285, 16289, 16293, 16297, 16301,
    16305, 16309, 16313, 16317, 16321, 16325, 16329, 16333,
    16337, 16341, 16345, 16349, 16353, 16357, 16361, 0,
    0, 0, 16365, 16369, 16373, 16377, 16381, 16385,
    0, 0, 16389, 16393, 16397, 16401, 16405, 16409,
    0, 0, 16413, 16417, 16421, 16425, 16429, 16433,
    0, 0, 16437, 16441, 16445, 0, 0, 0,
    16449, 16453, 16457, 16461, 16465, 16469, 16473, 0,
    16477, 16481, 16485, 16489, 16493, 16497, 16501, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 * const decomposition_info[256] = {
    di_00, di_01, di_02, di_03, di_04, di_05, di_06, di_07,
    di_07, di_09, di_0A, di_0B, di_0C, di_0D, di_0E, di_0F,
    di_10, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_1E, di_1F,
    di_20, di_21, di_22, di_23, di_24, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_2E, di_2F,
    di_30, di_31, di_32, di_33, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_07, di_07, di_07, di_07, di_07, di_07, di_07,
    di_07, di_F9, di_FA, di_FB, di_FC, di_FD, di_FE, di_FF,
};
// 68080 bytes

static const Q_UINT16 ligature_map [] = {
    0,
    12883, 12889, 12895, 12901, 12907, 12913, 15035, 15045, 15050, 15055, 15065, 15075, 15085, 15095, 0,
    5503, 0,
    5488, 0,
    5508, 0,
    67, 72, 77, 82, 87, 92, 332, 342, 352, 966, 1196, 1206, 1346, 2357, 3137, 3147, 0,
    2367, 2377, 2387, 0,
    97, 362, 372, 382, 392, 0,
    402, 2407, 2417, 2427, 2437, 2447, 0,
    102, 107, 112, 117, 412, 422, 432, 442, 452, 1216, 1226, 1356, 2477, 2487, 3257, 3267, 3277, 0,
    2507, 0,
    462, 472, 482, 492, 1076, 1146, 2517, 0,
    502, 1336, 2527, 2537, 2547, 2557, 2567, 0,
    122, 127, 132, 137, 512, 522, 532, 542, 552, 976, 1236, 1246, 2577, 3337, 3347, 0,
    567, 0,
    577, 1086, 2597, 2607, 2617, 0,
    587, 597, 607, 2627, 2647, 2657, 0,
    2667, 2677, 2687, 0,
    142, 627, 637, 647, 1156, 2697, 2707, 2717, 2727, 0,
    147, 152, 157, 162, 167, 662, 672, 682, 901, 986, 1096, 1256, 1266, 1386, 3357, 3367, 0,
    2777, 2787, 0,
    692, 702, 712, 1276, 1286, 2797, 2807, 2827, 0,
    722, 732, 742, 752, 1316, 2837, 2847, 0,
    762, 772, 1326, 2887, 2897, 2907, 2917, 0,
    172, 177, 182, 187, 782, 792, 802, 812, 822, 832, 911, 996, 1296, 1306, 2927, 2937, 2947, 3477, 3487, 0,
    2977, 2987, 0,
    842, 2997, 3007, 3017, 3027, 3037, 0,
    3047, 3057, 0,
    192, 852, 862, 1406, 3067, 3547, 3557, 3567, 3577, 0,
    867, 877, 887, 3077, 3087, 3097, 0,
    197, 202, 207, 212, 217, 222, 337, 347, 357, 971, 1201, 1211, 1351, 2362, 3142, 3152, 0,
    2372, 2382, 2392, 0,
    227, 367, 377, 387, 397, 0,
    407, 2412, 2422, 2432, 2442, 2452, 0,
    232, 237, 242, 247, 417, 427, 437, 447, 457, 1221, 1231, 1361, 2482, 2492, 3262, 3272, 3282, 0,
    2512, 0,
    467, 477, 487, 497, 1081, 1151, 2522, 0,
    507, 1341, 2532, 2542, 2552, 2562, 2572, 3107, 0,
    252, 257, 262, 267, 517, 527, 537, 547, 981, 1241, 1251, 2582, 3342, 3352, 0,
    572, 1126, 0,
    582, 1091, 2602, 2612, 2622, 0,
    592, 602, 612, 2632, 2652, 2662, 0,
    2672, 2682, 2692, 0,
    272, 632, 642, 652, 1161, 2702, 2712, 2722, 2732, 0,
    277, 282, 287, 292, 297, 667, 677, 687, 906, 991, 1101, 1261, 1271, 1391, 3362, 3372, 0,
    2782, 2792, 0,
    697, 707, 717, 1281, 1291, 2802, 2812, 2832, 0,
    727, 737, 747, 757, 1321, 2842, 2852, 0,
    767, 777, 1331, 2892, 2902, 2912, 2922, 3112, 0,
    302, 307, 312, 317, 787, 797, 807, 817, 827, 837, 916, 1001, 1301, 1311, 2932, 2942, 2952, 3482, 3492, 0,
    2982, 2992, 0,
    847, 3002, 3012, 3022, 3032, 3042, 3117, 0,
    3052, 3062, 0,
    322, 327, 857, 1411, 3072, 3122, 3552, 3562, 3572, 3582, 0,
    872, 882, 892, 3082, 3092, 3102, 0,
    1537, 4468, 4662, 0,
    3157, 3167, 3177, 3187, 0,
    1046, 0,
    1166, 0,
    1066, 1176, 0,
    2397, 0,
    3287, 3297, 3307, 3317, 0,
    2587, 0,
    3377, 3387, 3397, 3407, 0,
    1376, 2737, 2747, 0,
    1366, 0,
    1186, 0,
    1006, 1016, 1026, 1036, 0,
    3162, 3172, 3182, 3192, 0,
    1051, 0,
    1171, 0,
    1071, 1181, 0,
    2402, 0,
    3292, 3302, 3312, 3322, 0,
    2592, 0,
    3382, 3392, 3402, 3412, 0,
    1381, 2742, 2752, 0,
    1371, 0,
    1191, 0,
    1011, 1021, 1031, 1041, 0,
    3207, 3217, 3227, 3237, 0,
    3212, 3222, 3232, 3242, 0,
    2457, 2467, 0,
    2462, 2472, 0,
    2757, 2767, 0,
    2762, 2772, 0,
    2857, 0,
    2862, 0,
    2867, 0,
    2872, 0,
    2957, 0,
    2962, 0,
    2967, 0,
    2972, 0,
    3132, 0,
    3427, 3437, 3447, 3457, 3467, 0,
    3432, 3442, 3452, 3462, 3472, 0,
    3497, 3507, 3517, 3527, 3537, 0,
    3502, 3512, 3522, 3532, 3542, 0,
    1116, 0,
    1106, 0,
    1111, 0,
    1056, 0,
    1061, 0,
    2497, 0,
    2502, 0,
    1396, 0,
    1401, 0,
    1121, 0,
    1514, 0,
    1542, 3627, 3632, 4425, 4430, 4435, 4444, 0,
    1551, 3697, 3702, 4498, 0,
    1556, 3767, 3772, 4507, 4516, 0,
    1561, 1586, 3847, 3852, 4565, 4570, 4575, 0,
    1566, 3917, 3922, 4700, 0,
    4657, 0,
    1571, 1591, 3987, 4638, 4643, 4648, 0,
    1576, 4047, 4052, 4709, 4718, 0,
    4410, 0,
    4483, 0,
    1596, 3587, 3592, 4087, 4390, 4395, 4405, 4415, 0,
    1601, 3667, 3672, 4096, 0,
    1606, 3727, 3732, 4105, 4478, 4488, 0,
    1611, 1621, 3807, 3812, 4114, 4536, 4541, 4555, 0,
    1631, 3887, 3892, 4123, 0,
    4618, 4623, 0,
    1626, 1636, 3947, 3952, 4132, 4599, 4604, 4628, 0,
    1641, 4007, 4012, 4141, 4680, 4690, 0,
    1581, 4546, 4560, 0,
    1616, 4609, 4633, 0,
    4685, 0,
    1658, 1663, 0,
    1703, 0,
    1788, 1798, 0,
    1698, 0,
    1688, 1693, 1808, 0,
    1778, 1828, 0,
    1838, 0,
    1713, 1723, 1848, 1858, 0,
    1708, 0,
    1868, 0,
    1718, 1898, 1908, 1918, 0,
    1928, 0,
    1938, 0,
    1888, 0,
    1793, 1803, 0,
    1743, 0,
    1733, 1738, 1813, 0,
    1783, 1833, 0,
    1843, 0,
    1728, 1758, 1853, 1863, 0,
    1753, 0,
    1873, 0,
    1763, 1903, 1913, 1923, 0,
    1933, 0,
    1943, 0,
    1893, 0,
    1748, 0,
    1768, 0,
    1773, 0,
    1818, 0,
    1823, 0,
    1878, 0,
    1883, 0,
    11678, 11683, 11688, 0,
    11693, 11803, 0,
    11698, 0,
    11703, 0,
    11708, 0,
    11713, 11798, 0,
    11718, 0,
    11723, 0,
    11608, 11728, 0,
    11733, 0,
    11738, 11808, 0,
    11743, 0,
    11748, 0,
    11753, 0,
    11758, 0,
    11763, 0,
    11768, 11813, 0,
    11773, 0,
    11778, 0,
    11783, 0,
    11658, 11663, 11788, 0,
    11793, 0,
    11613, 0,
    15105, 0,
    15109, 15113, 0,
    15117, 15121, 0,
    15125, 15129, 0,
    15133, 15137, 0,
    12307, 12312, 12317, 12322, 12327, 12332, 12337, 12342, 12347, 12352, 12357, 12362, 12367, 12372, 12377, 12382, 12387, 12392, 12413, 12418, 12423, 12428, 12433, 12919, 12924, 12929, 12934, 12939, 12944, 13174, 13179, 13184, 13189, 13194, 13534, 13539, 15141, 15145, 15149, 15153, 0,
    14732, 14739, 1958, 1968, 14007, 14002, 1953, 15157, 15161, 0,
    14468, 14684, 12448, 12453, 12458, 12463, 12949, 12954, 12959, 12964, 12969, 12974, 13199, 13204, 13209, 13214, 13219, 13544, 13549, 12438, 12443, 15165, 15169, 15173, 15177, 0,
    15181, 15185, 0,
    14012, 14018, 14024, 14030, 14036, 14042, 14048, 14054, 14474, 14480, 14486, 14492, 14498, 14504, 13229, 13234, 13239, 13244, 13559, 13554, 12468, 12473, 12478, 12483, 12488, 12493, 12979, 12984, 12989, 12994, 12999, 13004, 13224, 15189, 15193, 15197, 15201, 0,
    12498, 12503, 12508, 12513, 13009, 13014, 13019, 13024, 13029, 13034, 13249, 13564, 13569, 15205, 15209, 15213, 15217, 0,
    14808, 14660, 14060, 14066, 14510, 14516, 14522, 12518, 12523, 13254, 13259, 13707, 13712, 13847, 13852, 15221, 15225, 15229, 15233, 0,
    14072, 14078, 14666, 13264, 13269, 13697, 13702, 13842, 13837, 12528, 12533, 15237, 15241, 15245, 15249, 0,
    12538, 12543, 12548, 13274, 13279, 13717, 13722, 13857, 13862, 15253, 15257, 15261, 15265, 0,
    15269, 15273, 0,
    12868, 15277, 15281, 0,
    14760, 12873, 15285, 15289, 0,
    15293, 15297, 0,
    14084, 14090, 14096, 14102, 14108, 14114, 14120, 14126, 14528, 14708, 13677, 13682, 13772, 13817, 13822, 13912, 13947, 13962, 13967, 13972, 12553, 12558, 12563, 12568, 13284, 13289, 13294, 13299, 13574, 13579, 15301, 15305, 15309, 15313, 0,
    14150, 14156, 14162, 14168, 14174, 14180, 14186, 14540, 13767, 13827, 13832, 13887, 13892, 13897, 13902, 13907, 13927, 13932, 13937, 13942, 13952, 13977, 13982, 13987, 13584, 13589, 13687, 13692, 13747, 13752, 13757, 13762, 15317, 15321, 15325, 15329, 0,
    14787, 14753, 14781, 14138, 14132, 14144, 14534, 14702, 14720, 12573, 12578, 13304, 13309, 13314, 13727, 13732, 13777, 13872, 13917, 13867, 15333, 15337, 15341, 15345, 0,
    14192, 14198, 14204, 14546, 13319, 13324, 13329, 13334, 13737, 13742, 13782, 13877, 13882, 13922, 12583, 12588, 12593, 12598, 15349, 15353, 15357, 15361, 0,
    14210, 14216, 14222, 14228, 13647, 13652, 13787, 13792, 13992, 13957, 12603, 12608, 13339, 15365, 15369, 15373, 15377, 0,
    12613, 13344, 13997, 15381, 15385, 15389, 15393, 0,
    14767, 14696, 14234, 14240, 14246, 14252, 14612, 12618, 12623, 13349, 13354, 13657, 13662, 13797, 13802, 15397, 15401, 15405, 15409, 0,
    14258, 14264, 14270, 13359, 13364, 13667, 13672, 13812, 13807, 12628, 12633, 15413, 15417, 15421, 15425, 0,
    13629, 13635, 13641, 15040, 15060, 15070, 15080, 15090, 15100, 0,
    14276, 14282, 14678, 12653, 12658, 12663, 13039, 13044, 13369, 13374, 13379, 13384, 12638, 12643, 12648, 15429, 15433, 15437, 15441, 0,
    14600, 14726, 14294, 14288, 14588, 12668, 12673, 12678, 12683, 13049, 13054, 13389, 13394, 15445, 15449, 15453, 15457, 0,
    14618, 14642, 14690, 12703, 12708, 12713, 12718, 12723, 13059, 13064, 13069, 13074, 13079, 13399, 13404, 13409, 13414, 13419, 13594, 13599, 12688, 12693, 12698, 15461, 15465, 15469, 15473, 0,
    14648, 14300, 14306, 14312, 14318, 14324, 14330, 14336, 14342, 14348, 14552, 14558, 14606, 14636, 12728, 12733, 12738, 12743, 12748, 12753, 13084, 13089, 13094, 13424, 13429, 13434, 13439, 13444, 13604, 15573, 15578, 15583, 15588, 15593, 15598, 15603, 15608, 15477, 15481, 15485, 15489, 0,
    14746, 14354, 14360, 14366, 14372, 14378, 14384, 14390, 14396, 14582, 14630, 14672, 12758, 12763, 12768, 12773, 12778, 12783, 13099, 13104, 13449, 13454, 13459, 13464, 15493, 15497, 15501, 15505, 0,
    14414, 14420, 14426, 14432, 14438, 14444, 14450, 14594, 14624, 14654, 14714, 13134, 13469, 13474, 13479, 13484, 13489, 13609, 13614, 12788, 12793, 12798, 12803, 12808, 12813, 13109, 13114, 13119, 13124, 13129, 15509, 15513, 15517, 15521, 0,
    14402, 14408, 12823, 12828, 12833, 13494, 13504, 13499, 12818, 15525, 15529, 15533, 15537, 0,
    14774, 1963, 15541, 15545, 0,
    12878, 13139, 12299, 12303, 15549, 15553, 0,
    14456, 14462, 14564, 14570, 14576, 12858, 12863, 13144, 13149, 13154, 13159, 13164, 13169, 13509, 13514, 13519, 13524, 13529, 13619, 13624, 1973, 12838, 12843, 12848, 12853, 15557, 15561, 15565, 15569, 0,
    11823, 11827, 0,
    12255, 0,
    11911, 11915, 11919, 11923, 0,
    11879, 11883, 11887, 11891, 0,
    11831, 11835, 11839, 11843, 0,
    11847, 11851, 11855, 11859, 0,
    11895, 11899, 11903, 11907, 0,
    11863, 11867, 11871, 11875, 0,
    11975, 11979, 11983, 11987, 0,
    11959, 11963, 11967, 11971, 0,
    11991, 11995, 11999, 12003, 0,
    12007, 12011, 12015, 12019, 0,
    12047, 12051, 0,
    12031, 12035, 0,
    12023, 12027, 0,
    12039, 12043, 0,
    12063, 12067, 0,
    12055, 12059, 0,
    11927, 11931, 11935, 11939, 0,
    11943, 11947, 11951, 11955, 0,
    12071, 12075, 12079, 12083, 0,
    12215, 12219, 12223, 12227, 0,
    12087, 12091, 12095, 12099, 0,
    12119, 12123, 12127, 12131, 0,
    12103, 12107, 12111, 12115, 0,
    12135, 12139, 0,
    12143, 12147, 12151, 12155, 0,
    12183, 12187, 12191, 12195, 0,
    12159, 12163, 0,
    2003, 12167, 12171, 12175, 12179, 0,
    12267, 12271, 0,
    12239, 12243, 0,
    12231, 12235, 0,
    12247, 12251, 0,
    12275, 12279, 0,
    12259, 12263, 0,
    12397, 12401, 12405, 12409, 0,
    12283, 12287, 12291, 12295, 0,
    2008, 12199, 12203, 0,
    12207, 12211, 0,
    1998, 0,
    2028, 0,
    2033, 0,
    2038, 0,
    2043, 0,
    2048, 0,
    2053, 0,
    2013, 0,
    2058, 0,
    2063, 0,
    2018, 0,
    2023, 0,
    2078, 0,
    2083, 0,
    2088, 0,
    2068, 2073, 0,
    2103, 0,
    2108, 0,
    2113, 0,
    2118, 0,
    2093, 0,
    2098, 0,
    2138, 0,
    2143, 0,
    2123, 2128, 2133, 0,
    2148, 0,
    2153, 2163, 0,
    2158, 0,
    2168, 0,
    2173, 0,
    2178, 2183, 2188, 0,
    2193, 0,
    2198, 2208, 0,
    2203, 0,
    2213, 2218, 2228, 0,
    2223, 0,
    2282, 0,
    2257, 0,
    2262, 0,
    2267, 0,
    2272, 0,
    2277, 0,
    2287, 2292, 2317, 0,
    2347, 0,
    2322, 0,
    2327, 0,
    2332, 0,
    2337, 0,
    2342, 0,
    2297, 0,
    2307, 0,
    2352, 0,
    2637, 0,
    2642, 0,
    2817, 0,
    2822, 0,
    2877, 0,
    2882, 0,
    3197, 3247, 0,
    3202, 3252, 0,
    3327, 0,
    3332, 0,
    3417, 0,
    3422, 0,
    3597, 3607, 3617, 4150, 0,
    3602, 3612, 3622, 4155, 0,
    4160, 0,
    4165, 0,
    4170, 0,
    4175, 0,
    4180, 0,
    4185, 0,
    3637, 3647, 3657, 4190, 0,
    3642, 3652, 3662, 4195, 0,
    4200, 0,
    4205, 0,
    4210, 0,
    4215, 0,
    4220, 0,
    4225, 0,
    3677, 3687, 0,
    3682, 3692, 0,
    3707, 3717, 0,
    3712, 3722, 0,
    3737, 3747, 3757, 4230, 0,
    3742, 3752, 3762, 4235, 0,
    4240, 0,
    4245, 0,
    4250, 0,
    4255, 0,
    4260, 0,
    4265, 0,
    3777, 3787, 3797, 4270, 0,
    3782, 3792, 3802, 4275, 0,
    4280, 0,
    4285, 0,
    4290, 0,
    4295, 0,
    4300, 0,
    4305, 0,
    3817, 3827, 3837, 0,
    3822, 3832, 3842, 0,
    3857, 3867, 3877, 0,
    3862, 3872, 3882, 0,
    3897, 3907, 0,
    3902, 3912, 0,
    3927, 3937, 0,
    3932, 3942, 0,
    3957, 3967, 3977, 0,
    3962, 3972, 3982, 0,
    3992, 3997, 4002, 0,
    4017, 4027, 4037, 4310, 0,
    4022, 4032, 4042, 4315, 0,
    4320, 0,
    4325, 0,
    4330, 0,
    4335, 0,
    4340, 0,
    4345, 0,
    4057, 4067, 4077, 4350, 0,
    4062, 4072, 4082, 4355, 0,
    4360, 0,
    4365, 0,
    4370, 0,
    4375, 0,
    4380, 0,
    4385, 0,
    4400, 0,
    4473, 0,
    4675, 0,
    4420, 0,
    4521, 4526, 4531, 0,
    4493, 0,
    4695, 0,
    4584, 4589, 4594, 0,
    5391, 0,
    5396, 0,
    5401, 0,
    5406, 0,
    5416, 0,
    5411, 0,
    5421, 0,
    5426, 0,
    5431, 0,
    5436, 0,
    5441, 0,
    5468, 0,
    5473, 0,
    5478, 0,
    5483, 0,
    5498, 0,
    5493, 0,
    5513, 0,
    5518, 0,
    5523, 0,
    5528, 0,
    5533, 0,
    5538, 0,
    5543, 0,
    5548, 0,
    5593, 0,
    5598, 0,
    5553, 0,
    5558, 0,
    5563, 0,
    5568, 0,
    5603, 0,
    5608, 0,
    5573, 0,
    5578, 0,
    5583, 0,
    5588, 0,
    5613, 0,
    5618, 0,
    5623, 0,
    5628, 0,
    7351, 0,
    7226, 0,
    7231, 0,
    7236, 0,
    7241, 0,
    7246, 0,
    7251, 0,
    7256, 0,
    7261, 0,
    7266, 0,
    7271, 0,
    7276, 0,
    7281, 0,
    7286, 0,
    7291, 0,
    7296, 0,
    7301, 7306, 0,
    7311, 7316, 0,
    7321, 7326, 0,
    7331, 7336, 0,
    7341, 7346, 0,
    7366, 0,
    7496, 0,
    7371, 0,
    7376, 0,
    7381, 0,
    7386, 0,
    7391, 0,
    7396, 0,
    7401, 0,
    7406, 0,
    7411, 0,
    7416, 0,
    7421, 0,
    7426, 0,
    7431, 0,
    7436, 0,
    7441, 0,
    7446, 7451, 0,
    7456, 7461, 0,
    7466, 7471, 0,
    7476, 7481, 0,
    7486, 7491, 0,
    7501, 0,
    7506, 0,
    7511, 0,
    7516, 0,
    7521, 0,
    11668, 11673, 0,

};

static const Q_UINT16 li_00[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 16, 18, 20, 0,
    0, 22, 39, 43, 49, 56, 74, 76,
    84, 92, 108, 110, 116, 123, 127, 137,
    154, 0, 157, 166, 174, 182, 202, 205,
    212, 215, 225, 0, 0, 0, 0, 0,
    0, 232, 249, 253, 259, 266, 284, 286,
    294, 303, 318, 321, 327, 334, 338, 348,
    365, 0, 368, 377, 385, 394, 414, 417,
    425, 428, 439, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    446, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 450, 0, 455, 457, 459, 462,
    0, 0, 464, 0, 0, 0, 0, 469,
    0, 0, 0, 0, 471, 476, 480, 0,
    482, 0, 0, 0, 484, 0, 0, 0,
    0, 0, 489, 0, 494, 496, 498, 501,
    0, 0, 503, 0, 0, 0, 0, 508,
    0, 0, 0, 0, 510, 515, 519, 0,
    521, 0, 0, 0, 523, 0, 0, 0,
};

static const Q_UINT16 li_01[] = {
    0, 0, 528, 533, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 538, 541, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 544, 547, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 550, 552, 0, 0, 0, 0,
    554, 556, 0, 0, 0, 0, 0, 0,
    558, 560, 562, 564, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 566,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    568, 574, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 580,
    586, 0, 0, 0, 0, 0, 0, 592,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 594, 596, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_02[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 598, 600,
    602, 604, 0, 0, 0, 0, 606, 608,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 610, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_03[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    612, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 614, 0, 0, 0, 622, 0, 627,
    0, 633, 0, 0, 0, 0, 0, 641,
    0, 646, 0, 0, 0, 648, 0, 0,
    0, 655, 0, 0, 661, 0, 663, 0,
    0, 665, 0, 0, 0, 674, 0, 679,
    0, 686, 0, 0, 0, 0, 0, 695,
    0, 700, 0, 0, 0, 703, 0, 0,
    0, 712, 719, 723, 0, 0, 727, 0,
    0, 0, 729, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_04[] = {
    0, 0, 0, 0, 0, 0, 732, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    734, 0, 0, 737, 0, 739, 743, 746,
    748, 0, 753, 0, 0, 0, 755, 0,
    0, 0, 0, 757, 0, 0, 0, 762,
    0, 0, 0, 764, 0, 766, 0, 0,
    768, 0, 0, 771, 0, 773, 777, 780,
    782, 0, 787, 0, 0, 0, 789, 0,
    0, 0, 0, 791, 0, 0, 0, 796,
    0, 0, 0, 798, 0, 800, 0, 0,
    0, 0, 0, 0, 0, 0, 802, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 804, 806, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    808, 810, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    812, 814, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_05[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    816, 820, 823, 825, 827, 829, 832, 0,
    834, 836, 839, 841, 844, 0, 846, 0,
    848, 850, 0, 852, 854, 0, 857, 859,
    861, 863, 867, 0, 0, 0, 0, 0,
    0, 0, 869, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_06[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 871, 873, 876, 879, 882, 885, 926,
    936, 962, 965, 1003, 1021, 1041, 1057, 1071,
    1074, 1078, 1083, 1086, 1121, 1158, 1183, 1206,
    1224, 1232, 1252, 0, 0, 0, 0, 0,
    1268, 1278, 1298, 1316, 1344, 1386, 1415, 1450,
    1464, 1469, 1476, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1506, 0, 0, 0, 0, 0, 1509,
    0, 1511, 1516, 1521, 0, 0, 1526, 1531,
    1536, 0, 0, 1541, 1546, 0, 1551, 1556,
    1561, 0, 0, 0, 1564, 1567, 1570, 0,
    0, 1573, 0, 0, 0, 0, 0, 0,
    1576, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1579, 0, 1584, 0,
    0, 1589, 0, 0, 0, 1594, 0, 1599,
    0, 1604, 0, 1609, 0, 0, 0, 0,
    0, 0, 1614, 1617, 0, 0, 1622, 0,
    1627, 1630, 0, 0, 0, 1636, 1639, 1642,
    1645, 1648, 0, 1651, 1654, 0, 0, 0,
    1659, 0, 1664, 1668, 0, 1671, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_07[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_09[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1673, 1675, 1677,
    0, 0, 0, 0, 1679, 0, 0, 0,
    0, 1681, 1683, 0, 0, 0, 0, 0,
    1685, 0, 0, 1687, 0, 0, 0, 1689,
    1691, 0, 0, 1693, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1695, 1697, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1699,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1701,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_0A[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1704, 1706,
    0, 0, 0, 0, 1708, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1710, 0, 0, 0, 0,
    0, 0, 1712, 0, 0, 0, 0, 0,
    1714, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_0B[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1716, 1718, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1720,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1724, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1726, 1729,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_0C[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1731, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1733,
    0, 0, 0, 0, 0, 0, 1735, 0,
    0, 0, 1739, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_0D[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1741, 1744,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1746, 0, 0, 1750, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_0F[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1752, 0, 1754, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1756, 0, 0, 0,
    0, 1758, 0, 0, 0, 0, 1760, 0,
    0, 0, 0, 1762, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1764, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1768, 0, 1770, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1772, 0, 0, 0,
    0, 1774, 0, 0, 0, 0, 1776, 0,
    0, 0, 0, 1778, 0, 0, 0, 0,
    0, 0, 1780, 1782, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_10[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1784, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_1E[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1786, 1788,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1790, 1792, 0, 0, 0, 0,
    0, 0, 1794, 1796, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1798, 1801, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1804, 1806, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1808, 1810, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_1F[] = {
    1812, 1817, 1822, 1824, 1826, 1828, 1830, 1832,
    1834, 1839, 1844, 1846, 1848, 1850, 1852, 1854,
    1856, 1859, 0, 0, 0, 0, 0, 0,
    1862, 1865, 0, 0, 0, 0, 0, 0,
    1868, 1873, 1878, 1880, 1882, 1884, 1886, 1888,
    1890, 1895, 1900, 1902, 1904, 1906, 1908, 1910,
    1912, 1916, 0, 0, 0, 0, 0, 0,
    1920, 1924, 0, 0, 0, 0, 0, 0,
    1928, 1931, 0, 0, 0, 0, 0, 0,
    1934, 1937, 0, 0, 0, 0, 0, 0,
    1940, 1944, 0, 0, 0, 0, 0, 0,
    0, 1948, 0, 0, 0, 0, 0, 0,
    1952, 1957, 1962, 1964, 1966, 1968, 1970, 1972,
    1974, 1979, 1984, 1986, 1988, 1990, 1992, 1994,
    1996, 0, 0, 0, 1998, 0, 0, 0,
    0, 0, 0, 0, 2000, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 2002, 0,
    0, 0, 0, 0, 0, 0, 0, 2004,
    0, 0, 0, 0, 0, 0, 2008, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 2010, 0,
    0, 0, 0, 0, 0, 0, 2012, 0,
};

static const Q_UINT16 li_21[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2016, 0, 2018, 0, 2020, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2022, 0, 2024, 0, 2026, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_22[] = {
    0, 0, 0, 2028, 0, 0, 0, 0,
    2030, 0, 0, 2032, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2034, 0, 2036, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2038, 0, 0, 0,
    0, 0, 0, 2040, 0, 2042, 0, 0,
    2044, 0, 0, 0, 0, 2046, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2048, 0, 0, 2050, 2052, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2054, 2056, 0, 0, 2058, 2060,
    0, 0, 2062, 2064, 2066, 2068, 0, 0,
    0, 0, 2070, 2072, 0, 0, 2074, 2076,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2078, 2080, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2082, 0, 0, 0, 0, 0,
    2084, 2086, 0, 2088, 0, 0, 0, 0,
    0, 0, 2090, 2092, 2094, 2096, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_30[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 2098, 0,
    0, 0, 0, 2100, 0, 2102, 0, 2104,
    0, 2106, 0, 2108, 0, 2110, 0, 2112,
    0, 2114, 0, 2116, 0, 2118, 0, 2120,
    0, 2122, 0, 0, 2124, 0, 2126, 0,
    2128, 0, 0, 0, 0, 0, 0, 2130,
    0, 0, 2133, 0, 0, 2136, 0, 0,
    2139, 0, 0, 2142, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 2145, 0, 0,
    0, 0, 0, 0, 0, 0, 2147, 0,
    0, 0, 0, 2149, 0, 2151, 0, 2153,
    0, 2155, 0, 2157, 0, 2159, 0, 2161,
    0, 2163, 0, 2165, 0, 2167, 0, 2169,
    0, 2171, 0, 0, 2173, 0, 2175, 0,
    2177, 0, 0, 0, 0, 0, 0, 2179,
    0, 0, 2182, 0, 0, 2185, 0, 0,
    2188, 0, 0, 2191, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2194,
    2196, 2198, 2200, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 2202, 0, 0,
};

static const Q_UINT16 li_FB[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2204, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 * const ligature_info[256] = {
    li_00, li_01, li_02, li_03, li_04, li_05, li_06, li_07,
    li_07, li_09, li_0A, li_0B, li_0C, li_0D, li_07, li_0F,
    li_10, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_1E, li_1F,
    li_07, li_21, li_22, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_30, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_07, li_07, li_07, li_07, li_07,
    li_07, li_07, li_07, li_FB, li_07, li_07, li_07, li_07,
};
// 16188 bytes

static const Q_UINT8 dir_00[] = {
    18, 18, 18, 18, 18, 18, 18, 18,
    18, 8, 7, 8, 9, 7, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 7, 7, 7, 8,
    9, 10, 10, 4, 4, 4, 10, 10,
    138, 138, 10, 4, 6, 4, 6, 3,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 6, 10, 138, 10, 138, 10,
    10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 138, 10, 138, 10, 10,
    10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 138, 10, 138, 10, 18,
    18, 18, 18, 18, 18, 7, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18,
    6, 10, 4, 4, 4, 4, 10, 10,
    10, 10, 0, 138, 10, 10, 10, 10,
    4, 4, 2, 2, 10, 0, 10, 10,
    10, 2, 0, 138, 10, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_01[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_02[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 10, 10, 0, 0, 0, 0, 0,
    0, 0, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    0, 0, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    0, 0, 0, 0, 0, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_03[] = {
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    17, 17, 17, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 10, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 10, 0,
    0, 0, 0, 0, 10, 10, 0, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_04[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 17, 17, 17, 17, 0,
    17, 17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_05[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 10, 0, 0, 0, 0, 0,
    0, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 0, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 0, 17, 17, 17, 1, 17,
    1, 17, 17, 1, 17, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_06[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 6, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 13, 0, 0, 0, 13,
    0, 13, 77, 77, 77, 77, 45, 77,
    45, 77, 45, 45, 45, 45, 45, 77,
    77, 77, 77, 45, 45, 45, 45, 45,
    45, 45, 45, 0, 0, 0, 0, 0,
    109, 45, 45, 45, 45, 45, 45, 45,
    77, 77, 45, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 4, 5, 5, 13, 0, 0,
    17, 13, 77, 77, 13, 77, 77, 77,
    45, 45, 45, 45, 45, 45, 45, 45,
    45, 45, 45, 45, 45, 45, 45, 45,
    77, 77, 77, 77, 77, 77, 77, 77,
    77, 77, 77, 77, 77, 77, 77, 77,
    77, 77, 45, 45, 45, 45, 45, 45,
    45, 45, 45, 45, 45, 45, 45, 45,
    45, 45, 45, 45, 45, 45, 45, 45,
    45, 45, 45, 45, 45, 45, 45, 45,
    45, 45, 45, 45, 45, 45, 45, 45,
    77, 45, 77, 77, 77, 77, 77, 77,
    77, 77, 77, 77, 45, 77, 45, 77,
    45, 45, 77, 77, 13, 13, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 13, 13, 17,
    17, 10, 17, 17, 17, 17, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 45, 45, 45, 13, 13, 0,
};

static const Q_UINT8 dir_07[] = {
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 0, 18,
    77, 17, 45, 45, 45, 77, 77, 77,
    77, 77, 45, 45, 45, 45, 77, 45,
    45, 45, 45, 45, 45, 45, 45, 45,
    77, 45, 77, 45, 77, 0, 0, 0,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_09[] = {
    0, 17, 17, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 17, 0, 0, 0,
    0, 17, 17, 17, 17, 17, 17, 17,
    17, 0, 0, 0, 0, 17, 0, 0,
    0, 17, 17, 17, 17, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 17, 17, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 17, 0, 0, 0,
    0, 17, 17, 17, 17, 0, 0, 0,
    0, 0, 0, 0, 0, 17, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 17, 17, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 4, 4, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_0A[] = {
    0, 0, 17, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 17, 0, 0, 0,
    0, 17, 17, 0, 0, 0, 0, 17,
    17, 0, 0, 17, 17, 17, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    17, 17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 17, 17, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 17, 0, 0, 0,
    0, 17, 17, 17, 17, 17, 0, 17,
    17, 0, 0, 0, 0, 17, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_0B[] = {
    0, 17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 17, 0, 0, 17,
    0, 17, 17, 17, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 17, 0, 0,
    0, 0, 0, 0, 0, 0, 17, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 17, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    17, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 17, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_0C[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 17, 17,
    17, 0, 0, 0, 0, 0, 17, 17,
    17, 0, 17, 17, 17, 17, 0, 0,
    0, 0, 0, 0, 0, 17, 17, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 17,
    0, 0, 0, 0, 0, 0, 17, 0,
    0, 0, 0, 0, 17, 17, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_0D[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 17, 17, 17, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 17, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 17, 0, 0, 0, 0, 0,
    0, 0, 17, 17, 17, 0, 17, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_0E[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 17, 0, 0, 17, 17, 17, 17,
    17, 17, 17, 0, 0, 0, 0, 4,
    0, 0, 0, 0, 0, 0, 0, 17,
    17, 17, 17, 17, 17, 17, 17, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 17, 0, 0, 17, 17, 17, 17,
    17, 17, 0, 17, 17, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    17, 17, 17, 17, 17, 17, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_0F[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    17, 17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 17, 0, 17,
    0, 17, 10, 10, 10, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 0,
    17, 17, 17, 17, 17, 0, 17, 17,
    0, 0, 0, 0, 0, 0, 0, 0,
    17, 17, 17, 17, 17, 17, 17, 17,
    0, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 17, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_10[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 17, 17, 17,
    17, 0, 17, 0, 0, 0, 17, 17,
    0, 17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    17, 17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_16[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    9, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 10, 10, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_17[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 17,
    17, 17, 17, 17, 17, 17, 0, 0,
    0, 0, 0, 0, 0, 0, 17, 0,
    0, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 0, 0, 0, 0,
    0, 0, 0, 4, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_18[] = {
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 18, 18, 18, 18, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_1F[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 10, 0, 10,
    10, 10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 10, 10, 0,
};

static const Q_UINT8 dir_20[] = {
    9, 9, 9, 9, 9, 9, 9, 9,
    9, 9, 9, 18, 18, 18, 0, 1,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    9, 7, 11, 14, 16, 12, 15, 9,
    4, 4, 4, 4, 4, 10, 10, 10,
    10, 138, 138, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 138, 138, 0,
    10, 10, 10, 10, 10, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 18, 18, 18, 18, 18, 18,
    2, 0, 0, 0, 2, 2, 2, 2,
    2, 2, 4, 4, 10, 138, 138, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 4, 4, 10, 138, 138, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_21[] = {
    10, 10, 0, 10, 10, 10, 10, 0,
    10, 10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 10, 0, 10, 10,
    10, 0, 0, 0, 0, 0, 10, 10,
    10, 10, 10, 10, 0, 10, 0, 10,
    0, 10, 0, 0, 0, 0, 4, 0,
    0, 0, 10, 0, 0, 0, 0, 0,
    0, 0, 10, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_22[] = {
    10, 138, 138, 138, 138, 10, 10, 10,
    138, 138, 138, 138, 138, 138, 10, 10,
    10, 138, 4, 4, 10, 138, 138, 10,
    10, 10, 138, 138, 138, 138, 10, 138,
    138, 138, 138, 10, 138, 10, 138, 10,
    10, 10, 10, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 10, 10, 10, 10,
    10, 138, 10, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 10, 10, 10,
    10, 10, 138, 138, 138, 138, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 138,
    138, 10, 138, 10, 138, 138, 138, 138,
    138, 138, 138, 138, 10, 10, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 10, 10, 138,
    138, 138, 138, 10, 10, 10, 10, 10,
    138, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 138, 138, 10, 10, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 10, 10, 10, 10, 10, 138, 138,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 138, 138, 138, 138, 138, 10, 10,
    138, 138, 10, 10, 10, 10, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 10, 10,
    138, 138, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_23[] = {
    10, 10, 10, 10, 10, 10, 10, 10,
    138, 138, 138, 138, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    138, 138, 10, 10, 10, 10, 10, 10,
    10, 138, 138, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 10, 0, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 0, 10, 10,
    10, 10, 10, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_24[] = {
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_25[] = {
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_26[] = {
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 0, 0, 0, 0,
    0, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_27[] = {
    0, 10, 10, 10, 10, 0, 10, 10,
    10, 10, 0, 0, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    0, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 0, 10, 0, 10,
    10, 10, 10, 0, 0, 0, 10, 0,
    10, 10, 10, 10, 10, 10, 10, 0,
    0, 10, 10, 10, 10, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    0, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_28[] = {
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
};

static const Q_UINT8 dir_2E[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 0, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_2F[] = {
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 0, 0, 0, 0,
};

static const Q_UINT8 dir_30[] = {
    9, 10, 10, 10, 10, 0, 0, 0,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 10, 10, 138, 138, 138, 138,
    138, 138, 138, 138, 10, 10, 10, 10,
    10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 17, 17, 17, 17, 17, 17,
    10, 0, 0, 0, 0, 0, 10, 10,
    0, 0, 0, 0, 0, 0, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 17, 17, 10, 10, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 10, 0, 0, 0, 0,
};

static const Q_UINT8 dir_A4[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 0, 0, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 0, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 0, 10, 10, 10, 0, 10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_FB[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1, 17, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 4, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 0, 1, 0,
    1, 1, 0, 1, 1, 0, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
};

static const Q_UINT8 dir_FC[] = {
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
};

static const Q_UINT8 dir_FD[] = {
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    0, 0, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 0, 0, 0, 0,
};

static const Q_UINT8 dir_FE[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    17, 17, 17, 17, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 0, 0, 0,
    0, 10, 10, 10, 10, 10, 10, 10,
    6, 10, 6, 0, 10, 6, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 4,
    10, 10, 4, 4, 10, 10, 10, 0,
    10, 4, 4, 10, 0, 0, 0, 0,
    13, 13, 13, 0, 13, 0, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 0, 0, 18,
};

static const Q_UINT8 dir_FF[] = {
    0, 10, 10, 4, 4, 4, 10, 10,
    10, 10, 10, 4, 6, 4, 6, 3,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 6, 10, 10, 10, 10, 10,
    10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 10, 10, 10, 10, 10,
    10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 10, 10, 10, 10, 0,
    0, 10, 10, 10, 10, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4, 4, 10, 10, 10, 4, 4, 0,
    10, 10, 10, 10, 10, 10, 10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 18, 18, 18, 10, 10, 0, 0,
};

static const Q_UINT8 * const direction_info[256] = {
    dir_00, dir_01, dir_02, dir_03, dir_04, dir_05, dir_06, dir_07,
    dir_01, dir_09, dir_0A, dir_0B, dir_0C, dir_0D, dir_0E, dir_0F,
    dir_10, dir_01, dir_01, dir_01, dir_01, dir_01, dir_16, dir_17,
    dir_18, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_1F,
    dir_20, dir_21, dir_22, dir_23, dir_24, dir_25, dir_26, dir_27,
    dir_28, dir_01, dir_01, dir_01, dir_01, dir_01, dir_2E, dir_2F,
    dir_30, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_A4, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01, dir_01,
    dir_01, dir_01, dir_01, dir_FB, dir_FC, dir_FD, dir_FE, dir_FF,
};
// 26940 bytes

#endif

// END OF GENERATED DATA

// This is generated too. Script?

#ifndef QT_NO_UNICODETABLES

static const Q_UINT16 case_0 [] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
    0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
    0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
    0x78, 0x79, 0x7a, 0, 0, 0, 0, 0,
    0, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
    0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
    0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
    0x58, 0x59, 0x5a, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0x0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0x0, 0, 0,
    0, 0, 0x0, 0, 0, 0, 0, 0,
    0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
    0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
    0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0,
    0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0x0,
    0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
    0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
    0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0,
    0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0x178,
};

static const Q_UINT16 case_1 [] = {
    0x101, 0x100, 0x103, 0x102, 0x105, 0x104, 0x107, 0x106,
    0x109, 0x108, 0x10b, 0x10a, 0x10d, 0x10c, 0x10f, 0x10e,
    0x111, 0x110, 0x113, 0x112, 0x115, 0x114, 0x117, 0x116,
    0x119, 0x118, 0x11b, 0x11a, 0x11d, 0x11c, 0x11f, 0x11e,
    0x121, 0x120, 0x123, 0x122, 0x125, 0x124, 0x127, 0x126,
    0x129, 0x128, 0x12b, 0x12a, 0x12d, 0x12c, 0x12f, 0x12e,
    0x69, 0x49, 0x133, 0x132, 0x135, 0x134, 0x137, 0x136,
    0x0, 0x13a, 0x139, 0x13c, 0x13b, 0x13e, 0x13d, 0x140,
    0x13f, 0x142, 0x141, 0x144, 0x143, 0x146, 0x145, 0x148,
    0x147, 0x0, 0x14b, 0x14a, 0x14d, 0x14c, 0x14f, 0x14e,
    0x151, 0x150, 0x153, 0x152, 0x155, 0x154, 0x157, 0x156,
    0x159, 0x158, 0x15b, 0x15a, 0x15d, 0x15c, 0x15f, 0x15e,
    0x161, 0x160, 0x163, 0x162, 0x165, 0x164, 0x167, 0x166,
    0x169, 0x168, 0x16b, 0x16a, 0x16d, 0x16c, 0x16f, 0x16e,
    0x171, 0x170, 0x173, 0x172, 0x175, 0x174, 0x177, 0x176,
    0xff, 0x17a, 0x179, 0x17c, 0x17b, 0x17e, 0x17d, 0x53,
    0x0, 0x253, 0x183, 0x182, 0x185, 0x184, 0x254, 0x188,
    0x187, 0x256, 0x257, 0x18c, 0x18b, 0x0, 0x1dd, 0x259,
    0x25b, 0x192, 0x191, 0x260, 0x263, 0x3d9, 0x269, 0x268,
    0x199, 0x198, 0x51, 0x0, 0x26f, 0x272, 0x0, 0x275,
    0x1a1, 0x1a0, 0x1a3, 0x1a2, 0x1a5, 0x1a4, 0x280, 0x1a8,
    0x1a7, 0x283, 0, 0x0, 0x1ad, 0x1ac, 0x288, 0x1b0,
    0x1af, 0x28a, 0x28b, 0x1b4, 0x1b3, 0x1b6, 0x1b5, 0x292,
    0x1b9, 0x1b8, 0x0, 0, 0x1bd, 0x1bc, 0, 0,
    0, 0, 0, 0, 0x1c6, 0, 0x1c4, 0x1c9,
    0, 0x1c7, 0x1cc, 0, 0x1ca, 0x1ce, 0x1cd, 0x1d0,
    0x1cf, 0x1d2, 0x1d1, 0x1d4, 0x1d3, 0x1d6, 0x1d5, 0x1d8,
    0x1d7, 0x1da, 0x1d9, 0x1dc, 0x1db, 0x18e, 0x1df, 0x1de,
    0x1e1, 0x1e0, 0x1e3, 0x1e2, 0x1e5, 0x1e4, 0x1e7, 0x1e6,
    0x1e9, 0x1e8, 0x1eb, 0x1ea, 0x1ed, 0x1ec, 0x1ef, 0x1ee,
    0x0, 0x1f3, 0, 0x1f1, 0x1f5, 0x1f4, 0, 0,
    0, 0, 0x1fb, 0x1fa, 0x1fd, 0x1fc, 0x1ff, 0x1fe,
};

static const Q_UINT16 case_2 [] = {
    0x201, 0x200, 0x203, 0x202, 0x205, 0x204, 0x207, 0x206,
    0x209, 0x208, 0x20b, 0x20a, 0x20d, 0x20c, 0x20f, 0x20e,
    0x211, 0x210, 0x213, 0x212, 0x215, 0x214, 0x217, 0x216,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0x0, 0x0, 0x0, 0x181, 0x186, 0x0, 0x189, 0x18a,
    0x0, 0x18f, 0x0, 0x190, 0x0, 0x0, 0x0, 0x0,
    0x193, 0x0, 0x0, 0x194, 0x0, 0x0, 0x631, 0x579,
    0x197, 0x196, 0x0, 0x0, 0x0, 0x0, 0x0, 0x19c,
    0x0, 0x0, 0x19d, 0x0, 0x0, 0x19f, 0x0, 0x0,
    0x0, 0x0, 0x7e1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1a6, 0x0, 0x0, 0x1a9, 0x0, 0x0, 0x0, 0x0,
    0x1ae, 0x0, 0x1b1, 0x1b2, 0x0, 0xa21, 0x971, 0x0,
    0x0, 0x0, 0x1b7, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 case_3 [] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0x3ac, 0,
    0x3ad, 0x3ae, 0x3af, 0, 0x3cc, 0, 0x3cd, 0x3ce,
    0x0, 0x3b1, 0x3b2, 0x3b3, 0x3b4, 0x3b5, 0x3b6, 0x3b7,
    0x3b8, 0x3b9, 0x3ba, 0x3bb, 0x3bc, 0x3bd, 0x3be, 0x3bf,
    0x3c0, 0x3c1, 0, 0x3c3, 0x3c4, 0x3c5, 0x3c6, 0x3c7,
    0x3c8, 0x3c9, 0x3ca, 0x3cb, 0x386, 0x388, 0x389, 0x38a,
    0x0, 0x391, 0x392, 0x393, 0x394, 0x395, 0x396, 0x397,
    0x398, 0x399, 0x39a, 0x39b, 0x39c, 0x39d, 0x39e, 0x39f,
    0x3a0, 0x3a1, 0x3a3, 0x3a3, 0x3a4, 0x3a5, 0x3a6, 0x3a7,
    0x3a8, 0x3a9, 0x3aa, 0x3ab, 0x38c, 0x38e, 0x38f, 0,
    0x392, 0x398, 0x0, 0x0, 0x0, 0x3a6, 0x3a0, 0,
    0, 0, 0x0, 0, 0x0, 0, 0x0, 0,
    0x0, 0, 0x3e3, 0x3e2, 0x3e5, 0x3e4, 0x3e7, 0x3e6,
    0x3e9, 0x3e8, 0x3eb, 0x3ea, 0x3ed, 0x3ec, 0x3ef, 0x3ee,
    0x39a, 0x3a1, 0x3a3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 case_4 [] = {
    0, 0x451, 0x452, 0x453, 0x454, 0x455, 0x456, 0x457,
    0x458, 0x459, 0x45a, 0x45b, 0x45c, 0, 0x45e, 0x45f,
    0x430, 0x431, 0x432, 0x433, 0x434, 0x435, 0x436, 0x437,
    0x438, 0x439, 0x43a, 0x43b, 0x43c, 0x43d, 0x43e, 0x43f,
    0x440, 0x441, 0x442, 0x443, 0x444, 0x445, 0x446, 0x447,
    0x448, 0x449, 0x44a, 0x44b, 0x44c, 0x44d, 0x44e, 0x44f,
    0x410, 0x411, 0x412, 0x413, 0x414, 0x415, 0x416, 0x417,
    0x418, 0x419, 0x41a, 0x41b, 0x41c, 0x41d, 0x41e, 0x41f,
    0x420, 0x421, 0x422, 0x423, 0x424, 0x425, 0x426, 0x427,
    0x428, 0x429, 0x42a, 0x42b, 0x42c, 0x42d, 0x42e, 0x42f,
    0, 0x401, 0x402, 0x403, 0x404, 0x405, 0x406, 0x407,
    0x408, 0x409, 0x40a, 0x40b, 0x40c, 0, 0x40e, 0x40f,
    0x461, 0x460, 0x463, 0x462, 0x465, 0x464, 0x467, 0x466,
    0x469, 0x468, 0x46b, 0x46a, 0x46d, 0x46c, 0x46f, 0x46e,
    0x471, 0x470, 0x473, 0x472, 0x475, 0x474, 0x477, 0x476,
    0x479, 0x478, 0x47b, 0x47a, 0x47d, 0x47c, 0x47f, 0x47e,
    0x481, 0x480, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0x491, 0x490, 0x493, 0x492, 0x495, 0x494, 0x497, 0x496,
    0x499, 0x498, 0x49b, 0x49a, 0x49d, 0x49c, 0x49f, 0x49e,
    0x4a1, 0x4a0, 0x4a3, 0x4a2, 0x4a5, 0x4a4, 0x4a7, 0x4a6,
    0x4a9, 0x4a8, 0x4ab, 0x4aa, 0x4ad, 0x4ac, 0x4af, 0x4ae,
    0x4b1, 0x4b0, 0x4b3, 0x4b2, 0x4b5, 0x4b4, 0x4b7, 0x4b6,
    0x4b9, 0x4b8, 0x4bb, 0x4ba, 0x4bd, 0x4bc, 0x4bf, 0x4be,
    0, 0x4c2, 0x4c1, 0x4c4, 0x4c3, 0, 0, 0x4c8,
    0x4c7, 0, 0, 0x4cc, 0x4cb, 0, 0, 0,
    0x4d1, 0x4d0, 0x4d3, 0x4d2, 0x4d5, 0x4d4, 0x4d7, 0x4d6,
    0x4d9, 0x4d8, 0x4db, 0x4da, 0x4dd, 0x4dc, 0x4df, 0x4de,
    0x4e1, 0x4e0, 0x4e3, 0x4e2, 0x4e5, 0x4e4, 0x4e7, 0x4e6,
    0x4e9, 0x4e8, 0x4eb, 0x4ea, 0, 0, 0x4ef, 0x4ee,
    0x4f1, 0x4f0, 0x4f3, 0x4f2, 0x4f5, 0x4f4, 0, 0,
    0x4f9, 0x4f8, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 case_5 [] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x561, 0x562, 0x563, 0x564, 0x565, 0x566, 0x567,
    0x568, 0x569, 0x56a, 0x56b, 0x56c, 0x56d, 0x56e, 0x56f,
    0x570, 0x571, 0x572, 0x573, 0x574, 0x575, 0x576, 0x577,
    0x578, 0x579, 0x57a, 0x57b, 0x57c, 0x57d, 0x57e, 0x57f,
    0x580, 0x581, 0x582, 0x583, 0x584, 0x585, 0x586, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x531, 0x532, 0x533, 0x534, 0x535, 0x536, 0x537,
    0x538, 0x539, 0x53a, 0x53b, 0x53c, 0x53d, 0x53e, 0x53f,
    0x540, 0x541, 0x542, 0x543, 0x544, 0x545, 0x546, 0x547,
    0x548, 0x549, 0x54a, 0x54b, 0x54c, 0x54d, 0x54e, 0x54f,
    0x550, 0x551, 0x552, 0x553, 0x554, 0x555, 0x556, 0x0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 case_10 [] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0x10d0, 0x10d1, 0x10d2, 0x10d3, 0x10d4, 0x10d5, 0x10d6, 0x10d7,
    0x10d8, 0x10d9, 0x10da, 0x10db, 0x10dc, 0x10dd, 0x10de, 0x10df,
    0x10e0, 0x10e1, 0x10e2, 0x10e3, 0x10e4, 0x10e5, 0x10e6, 0x10e7,
    0x10e8, 0x10e9, 0x10ea, 0x10eb, 0x10ec, 0x10ed, 0x10ee, 0x10ef,
    0x10f0, 0x10f1, 0x10f2, 0x10f3, 0x10f4, 0x10f5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 case_1e [] = {
    0x1e01, 0x1e00, 0x1e03, 0x1e02, 0x1e05, 0x1e04, 0x1e07, 0x1e06,
    0x1e09, 0x1e08, 0x1e0b, 0x1e0a, 0x1e0d, 0x1e0c, 0x1e0f, 0x1e0e,
    0x1e11, 0x1e10, 0x1e13, 0x1e12, 0x1e15, 0x1e14, 0x1e17, 0x1e16,
    0x1e19, 0x1e18, 0x1e1b, 0x1e1a, 0x1e1d, 0x1e1c, 0x1e1f, 0x1e1e,
    0x1e21, 0x1e20, 0x1e23, 0x1e22, 0x1e25, 0x1e24, 0x1e27, 0x1e26,
    0x1e29, 0x1e28, 0x1e2b, 0x1e2a, 0x1e2d, 0x1e2c, 0x1e2f, 0x1e2e,
    0x1e31, 0x1e30, 0x1e33, 0x1e32, 0x1e35, 0x1e34, 0x1e37, 0x1e36,
    0x1e39, 0x1e38, 0x1e3b, 0x1e3a, 0x1e3d, 0x1e3c, 0x1e3f, 0x1e3e,
    0x1e41, 0x1e40, 0x1e43, 0x1e42, 0x1e45, 0x1e44, 0x1e47, 0x1e46,
    0x1e49, 0x1e48, 0x1e4b, 0x1e4a, 0x1e4d, 0x1e4c, 0x1e4f, 0x1e4e,
    0x1e51, 0x1e50, 0x1e53, 0x1e52, 0x1e55, 0x1e54, 0x1e57, 0x1e56,
    0x1e59, 0x1e58, 0x1e5b, 0x1e5a, 0x1e5d, 0x1e5c, 0x1e5f, 0x1e5e,
    0x1e61, 0x1e60, 0x1e63, 0x1e62, 0x1e65, 0x1e64, 0x1e67, 0x1e66,
    0x1e69, 0x1e68, 0x1e6b, 0x1e6a, 0x1e6d, 0x1e6c, 0x1e6f, 0x1e6e,
    0x1e71, 0x1e70, 0x1e73, 0x1e72, 0x1e75, 0x1e74, 0x1e77, 0x1e76,
    0x1e79, 0x1e78, 0x1e7b, 0x1e7a, 0x1e7d, 0x1e7c, 0x1e7f, 0x1e7e,
    0x1e81, 0x1e80, 0x1e83, 0x1e82, 0x1e85, 0x1e84, 0x1e87, 0x1e86,
    0x1e89, 0x1e88, 0x1e8b, 0x1e8a, 0x1e8d, 0x1e8c, 0x1e8f, 0x1e8e,
    0x1e91, 0x1e90, 0x1e93, 0x1e92, 0x1e95, 0x1e94, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1e60, 0, 0, 0, 0,
    0x1ea1, 0x1ea0, 0x1ea3, 0x1ea2, 0x1ea5, 0x1ea4, 0x1ea7, 0x1ea6,
    0x1ea9, 0x1ea8, 0x1eab, 0x1eaa, 0x1ead, 0x1eac, 0x1eaf, 0x1eae,
    0x1eb1, 0x1eb0, 0x1eb3, 0x1eb2, 0x1eb5, 0x1eb4, 0x1eb7, 0x1eb6,
    0x1eb9, 0x1eb8, 0x1ebb, 0x1eba, 0x1ebd, 0x1ebc, 0x1ebf, 0x1ebe,
    0x1ec1, 0x1ec0, 0x1ec3, 0x1ec2, 0x1ec5, 0x1ec4, 0x1ec7, 0x1ec6,
    0x1ec9, 0x1ec8, 0x1ecb, 0x1eca, 0x1ecd, 0x1ecc, 0x1ecf, 0x1ece,
    0x1ed1, 0x1ed0, 0x1ed3, 0x1ed2, 0x1ed5, 0x1ed4, 0x1ed7, 0x1ed6,
    0x1ed9, 0x1ed8, 0x1edb, 0x1eda, 0x1edd, 0x1edc, 0x1edf, 0x1ede,
    0x1ee1, 0x1ee0, 0x1ee3, 0x1ee2, 0x1ee5, 0x1ee4, 0x1ee7, 0x1ee6,
    0x1ee9, 0x1ee8, 0x1eeb, 0x1eea, 0x1eed, 0x1eec, 0x1eef, 0x1eee,
    0x1ef1, 0x1ef0, 0x1ef3, 0x1ef2, 0x1ef5, 0x1ef4, 0x1ef7, 0x1ef6,
    0x1ef9, 0x1ef8, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 case_1f [] = {
    0x1f08, 0x1f09, 0x1f0a, 0x1f0b, 0x1f0c, 0x1f0d, 0x1f0e, 0x1f0f,
    0x1f00, 0x1f01, 0x1f02, 0x1f03, 0x1f04, 0x1f05, 0x1f06, 0x1f07,
    0x1f18, 0x1f19, 0x1f1a, 0x1f1b, 0x1f1c, 0x1f1d, 0, 0,
    0x1f10, 0x1f11, 0x1f12, 0x1f13, 0x1f14, 0x1f15, 0, 0,
    0x1f28, 0x1f29, 0x1f2a, 0x1f2b, 0x1f2c, 0x1f2d, 0x1f2e, 0x1f2f,
    0x1f20, 0x1f21, 0x1f22, 0x1f23, 0x1f24, 0x1f25, 0x1f26, 0x1f27,
    0x1f38, 0x1f39, 0x1f3a, 0x1f3b, 0x1f3c, 0x1f3d, 0x1f3e, 0x1f3f,
    0x1f30, 0x1f31, 0x1f32, 0x1f33, 0x1f34, 0x1f35, 0x1f36, 0x1f37,
    0x1f48, 0x1f49, 0x1f4a, 0x1f4b, 0x1f4c, 0x1f4d, 0, 0,
    0x1f40, 0x1f41, 0x1f42, 0x1f43, 0x1f44, 0x1f45, 0, 0,
    0x0, 0x1f59, 0x0, 0x1f5b, 0x0, 0x1f5d, 0x0, 0x1f5f,
    0, 0x1f51, 0, 0x1f53, 0, 0x1f55, 0, 0x1f57,
    0x1f68, 0x1f69, 0x1f6a, 0x1f6b, 0x1f6c, 0x1f6d, 0x1f6e, 0x1f6f,
    0x1f60, 0x1f61, 0x1f62, 0x1f63, 0x1f64, 0x1f65, 0x1f66, 0x1f67,
    0x1fba, 0x1fbb, 0x1fc8, 0x1fc9, 0x1fca, 0x1fcb, 0x1fda, 0x1fdb,
    0x1ff8, 0x1ff9, 0x1fea, 0x1feb, 0x1ffa, 0x1ffb, 0, 0,
    0x1f88, 0x1f89, 0x1f8a, 0x1f8b, 0x1f8c, 0x1f8d, 0x1f8e, 0x1f8f,
    0x1f80, 0x1f81, 0x1f82, 0x1f83, 0x1f84, 0x1f85, 0x1f86, 0x1f87,
    0x1f98, 0x1f99, 0x1f9a, 0x1f9b, 0x1f9c, 0x1f9d, 0x1f9e, 0x1f9f,
    0x1f90, 0x1f91, 0x1f92, 0x1f93, 0x1f94, 0x1f95, 0x1f96, 0x1f97,
    0x1fa8, 0x1fa9, 0x1faa, 0x1fab, 0x1fac, 0x1fad, 0x1fae, 0x1faf,
    0x1fa0, 0x1fa1, 0x1fa2, 0x1fa3, 0x1fa4, 0x1fa5, 0x1fa6, 0x1fa7,
    0x1fb8, 0x1fb9, 0x0, 0x1fbc, 0x0, 0, 0x0, 0x0,
    0x1fb0, 0x1fb1, 0x1f70, 0x1f71, 0x1fb3, 0, 0x399, 0,
    0, 0, 0x0, 0x1fcc, 0x0, 0, 0x0, 0x0,
    0x1f72, 0x1f73, 0x1f74, 0x1f75, 0x1fc3, 0, 0, 0,
    0x1fd8, 0x1fd9, 0x0, 0x0, 0, 0, 0x0, 0x0,
    0x1fd0, 0x1fd1, 0x1f76, 0x1f77, 0, 0, 0, 0,
    0x1fe8, 0x1fe9, 0x0, 0x0, 0x0, 0x1fec, 0x0, 0x0,
    0x1fe0, 0x1fe1, 0x1f7a, 0x1f7b, 0x1fe5, 0, 0, 0,
    0, 0, 0x0, 0x1ffc, 0x0, 0, 0x0, 0x0,
    0x1f78, 0x1f79, 0x1f7c, 0x1f7d, 0x1ff3, 0, 0, 0,
};

static const Q_UINT16 case_20 [] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0x0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 case_21 [] = {
    0, 0, 0x0, 0, 0, 0, 0, 0x0,
    0, 0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0, 0x0, 0, 0,
    0x761, 0x0, 0x0, 0x0, 0x0, 0x0, 0, 0,
    0, 0, 0, 0, 0x0, 0, 0x0, 0,
    0x0, 0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0, 0x0, 0x0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 case_fb [] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 case_ff [] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0xff41, 0xff42, 0xff43, 0xff44, 0xff45, 0xff46, 0xff47,
    0xff48, 0xff49, 0xff4a, 0xff4b, 0xff4c, 0xff4d, 0xff4e, 0xff4f,
    0xff50, 0xff51, 0xff52, 0xff53, 0xff54, 0xff55, 0xff56, 0xff57,
    0xff58, 0xff59, 0xff5a, 0, 0, 0, 0, 0,
    0, 0xff21, 0xff22, 0xff23, 0xff24, 0xff25, 0xff26, 0xff27,
    0xff28, 0xff29, 0xff2a, 0xff2b, 0xff2c, 0xff2d, 0xff2e, 0xff2f,
    0xff30, 0xff31, 0xff32, 0xff33, 0xff34, 0xff35, 0xff36, 0xff37,
    0xff38, 0xff39, 0xff3a, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 * const case_info[256] = {

    case_0, case_1, case_2, case_3, case_4, case_5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    case_10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, case_1e, case_1f,
    case_20, case_21, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, case_fb, 0, 0, 0, case_ff,
};

static const Q_INT8 num_0 [] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, 2, 3, -1, -1, -1, -1,
    -1, 1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static const Q_INT8 num_6 [] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
};

static const Q_INT8 num_9 [] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static const Q_INT8 num_b [] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, 1,
    2, 3, 4, 5, 6, 7, 8, 9,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static const Q_INT8 num_d [] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static const Q_INT8 num_e [] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static const Q_INT8 num_f [] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static const Q_INT8 num_20 [] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, -1, -1, -1, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static const Q_INT8 num_ff [] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static const Q_INT8 * const decimal_info[256] = {
     num_0, 0, 0, 0, 0, 0, num_6, 0,
     0, num_9, num_9, num_b, num_9, num_d, num_e, num_f,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     num_20, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, num_ff,
};

static const Q_UINT16 symmetricPairs[] = {
    0x0028, 0x0029, 0x0029, 0x0028, 0x003C, 0x003E, 0x003E, 0x003C,
    0x005B, 0x005D, 0x005D, 0x005B, 0x007B, 0x007D, 0x007D, 0x007B,
    0x2045, 0x2046, 0x2046, 0x2045, 0x207D, 0x207E, 0x207E, 0x207D,
    0x208D, 0x208E, 0x208E, 0x208D, 0x3008, 0x3009, 0x3009, 0x3008,
    0x300A, 0x300B, 0x300B, 0x300A, 0x300C, 0x300D, 0x300D, 0x300C,
    0x300E, 0x300F, 0x300F, 0x300E, 0x3010, 0x3011, 0x3011, 0x3010,
    0x3014, 0x3015, 0x3015, 0x3014, 0x3016, 0x3017, 0x3017, 0x3016,
    0x3018, 0x3019, 0x3019, 0x3018, 0x301A, 0x301B, 0x301B, 0x301A,
    0xFD3E, 0xFD3F, 0xFD3F, 0xFD3E, 0xFE59, 0xFE5A, 0xFE5A, 0xFE59,
    0xFE5B, 0xFE5C, 0xFE5C, 0xFE5B, 0xFE5D, 0xFE5E, 0xFE5E, 0xFE5D,
    0xFF08, 0xFF09, 0xFF09, 0xFF08, 0xFF3B, 0xFF3D, 0xFF3D, 0xFF3B,
    0xFF5B, 0xFF5D, 0xFF5D, 0xFF5B, 0xFF62, 0xFF63, 0xFF63, 0xFF62,
};

static int symmetricPairsSize =
   sizeof(symmetricPairs)/sizeof(symmetricPairs[0]);

/*
 * ----------------------------------------------------------------------
 * End of unicode tables
 * ----------------------------------------------------------------------
 */

#endif


static int ucstrcmp( const QString &as, const QString &bs )
{
    const QChar *a = as.unicode();
    const QChar *b = bs.unicode();
    if ( a == b )
	return 0;
    if ( a == 0 )
	return 1;
    if ( b == 0 )
	return -1;
    int l=QMIN(as.length(),bs.length());
    while ( l-- && *a == *b )
	a++,b++;
    if ( l==-1 )
	return ( as.length()-bs.length() );
    return a->unicode() - b->unicode();
}

static int ucstrncmp( const QChar *a, const QChar *b, int l )
{
    while ( l-- && *a == *b )
	a++,b++;
    if ( l==-1 )
	return 0;
    return a->unicode() - b->unicode();
}

static int ucstrnicmp( const QChar *a, const QChar *b, int l )
{
    while ( l-- && a->lower() == b->lower() )
	a++,b++;
    if ( l==-1 )
	return 0;
    QChar al = a->lower();
    QChar bl = b->lower();
    return al.unicode() - bl.unicode();
}

// NOT REVISED
/*! \class QCharRef qstring.h
  \brief The QCharRef class is a helper class for QString.

  It provides the ability to work on characters in a QString in a natural
  fashion.

  When you get an object of type QCharRef, you can assign to it, which
  will operate on the string from which you got it.  That is its whole
  purpose in life.  It becomes invalid once further modifications are
  made to the string: If you want to keep it, copy it into a QChar.

  Most of the QChar member functions also exist in QCharRef.  However,
  they are not explicitly documented here.

  \sa QString::operator[]() QString::at() QChar
*/

/*! \class QChar qstring.h

\brief The QChar class provides a light-weight Unicode character.

Unicode characters are (so far) 16-bit entities without any markup or
structure.  This class represents such an entity.  It is rather
light-weight, so it can be used everywhere.  Most compilers treat it
approximately like "short int".  (In a few years, it may be necessary
to make QChar 32-bit, once more than 65536 Unicode code points have
been defined and come into use.)

QChar provides a full complement of testing/classification functions,
conversion to and from other formats, from composed to decomposed
unicode, and will try to compare and case-convert if you ask it to.

The classification functions include functions like those in ctype.h,
but operating on the full range of unicode characters.  They all
return TRUE if the character is a certain type of character, and FALSE
otherwise.

These functions are: isNull() (returns TRUE if the character is
U+0000), isPrint() (TRUE if the character is any sort of printable
character, including whitespace), isPunct() (any sort of punctation),
isMark() (Unicode Marks), isLetter (letters), isNumber() (any sort of
numeric characters), isLetterOrNumber(),  and isDigit() (decimal digits).
All of these are wrappers around category(), which returns the
unicode-defined category of each character.

QChar further provides direction(), which indicates the "natural"
writing direction of this character, joining(), which indicates how
this character joins with its neighbors (needed mostly for Arabic)
and finally mirrored(), which indicates whether this character needs
to be mirrored when it is printed in its unnatural writing
direction.

Composed Unicode characters (like &aring;) can be converted to
decomposed Unicode ("a" followed by "ring above") using
decomposition().

In Unicode, comparison is not necessarily possible, and case
conversion is at best very hard.  Unicode, covering the "entire"
globe, also includes a globe-sized collection of case and sorting
problems.  Qt tries, but not very hard: operator== and friends will do
comparison based purely on the numeric Unicode value (code point) of
the characters, and upper() and lower() will do case changes when the
character has a well-defined upper/lower-case equivalent. There is no
provision for locale-dependent case folding rules or comparison: These
functions are meant to be fast, so they can be used unambiguously in
data structures.

The conversion functions include unicode() (to a scalar), latin1() (to
scalar, but converts all non-Latin1 characters to 0), row() (gives the
Unicode row), cell() (gives the unicode cell), digitValue() (gives the
integer value of any of the numerous digit characters), and a host of
constructors.

\sa QString QCharRef \link unicode.html About Unicode \endlink
*/

/*! \enum QChar::Category

This enum maps the Unicode character categories.  The currently known
categories are: <ul>

<li> \c NoCategory - used when Qt is dazed and confused and cannot
make sense of anything.

<li> \c Mark_NonSpacing - (Mn) -

<li> \c Mark_SpacingCombining - (Mc) -

<li> \c Mark_Enclosing - (Me) -

<li> \c Number_DecimalDigit - (Nd) -

<li> \c Number_Letter - (Nl) -

<li> \c Number_Other - (No) -

<li> \c Separator_Space - (Zs) -

<li> \c Separator_Line - (Zl) -

<li> \c Separator_Paragraph - (Zp) -

<li> \c Other_Control - (Cc) -

<li> \c Other_Format - (Cf) -

<li> \c Other_Surrogate - (Cs) -

<li> \c Other_PrivateUse - (Co) -

<li> \c Other_NotAssigned - (Cn) -

<li> \c Letter_Uppercase - (Lu) -

<li> \c Letter_Lowercase - (Ll) -

<li> \c Letter_Titlecase - (Lt) -

<li> \c Letter_Modifier - (Lm) -

<li> \c Letter_Other - (Lo) -

<li> \c Punctuation_Connector - (Pc) -

<li> \c Punctuation_Dask - (Pd) -

<li> \c Punctuation_Open - (Ps) -

<li> \c Punctuation_Close - (Pe) -

<li> \c Punctuation_InitialQuote - (Pi) -

<li> \c Punctuation_FinalQuote - (Pf) -

<li> \c Punctuation_Other - (Po) -

<li> \c Symbol_Math - (Sm) -

<li> \c Symbol_Currency - (Sc) -

<li> \c Symbol_Modifier - (Sk) -

<li> \c Symbol_Other - (So) -

</ul>
*/

/*! \enum QChar::Direction

  This enum type defines the Unicode direction attributes.
  See <a href="http://www.unicode.org">the Unicode Standard</a>
  for a description of the values.

  In order to conform to C/C++ naming conventions "Dir" is
  prepended to the codes used in The Unicode Standard.
*/

/*! \enum QChar::Decomposition

  This enum type defines the Unicode decomposition attributes.
  See <a href="http://www.unicode.org">the Unicode Standard</a>
  for a description of the values.
*/

/*! \enum QChar::Joining

  This enum type defines the Unicode decomposition attributes.
  See <a href="http://www.unicode.org">the Unicode Standard</a>
  for a description of the values.
*/



/*! \fn QChar::QChar()

Constructs a null QChar (one that isNull()).
*/


/*! \fn QChar::QChar( char c )

Constructs a QChar corresponding to ASCII/Latin1 character \a c.
*/


/*! \fn QChar::QChar( uchar c )

Constructs a QChar corresponding to ASCII/Latin1 character \a c.
*/


/*! \fn QChar::QChar( uchar c, uchar r )

Constructs a QChar for Unicode cell \a c in row \a r.
*/


/*! \fn QChar::QChar( const QChar& c )

Constructs a copy of \a c.  This is a deep copy, if such a
light-weight object can be said to have deep copies.
*/


/*! \fn QChar::QChar( ushort rc )

Constructs a QChar for the character with Unicode code point \a rc.
*/


/*! \fn QChar::QChar( short rc )

Constructs a QChar for the character with Unicode code point \a rc.
*/


/*! \fn QChar::QChar( uint rc )

Constructs a QChar for the character with Unicode code point \a rc.
*/


/*! \fn QChar::QChar( int rc )

Constructs a QChar for the character with Unicode code point \a rc.
*/


/*! \fn bool  QChar::networkOrdered ()

  Returns TRUE if this character is in network byte order (MSB first),
  and FALSE if it is not.  This is a platform-dependent property, so
  we strongly advise against using this function in portable code.
*/


/*!
  \fn bool QChar::isNull() const
  Returns TRUE if the characters is the unicode character 0x0000,
  ie. ASCII NUL.
*/

/*!
  \fn uchar QChar::cell () const
  Returns the cell (least significant byte) of the Unicode character.
*/
/*!
  \fn uchar QChar::row () const
  Returns the row (most significant byte) of the Unicode character.
*/
/*!
  \fn uchar& QChar::cell ()
  Returns a reference to the cell (least significant byte) of the Unicode character.
*/
/*!
  \fn uchar& QChar::row ()
  Returns a reference to the row (most significant byte) of the Unicode character.
*/

/*!
  Returns whether the character is a printable character.  This is
  any character not of category Cc or Cn.  Note that this gives no indication
  of whether the character is available in some font.
*/
bool QChar::isPrint() const
{
    Category c = category();
    return !(c == Other_Control || c == Other_NotAssigned);
}

/*!
  Returns whether the character is a separator
  character (Separator_* categories).
*/
bool QChar::isSpace() const
{
    if( !row() )
	if( cell() >= 9 && cell() <=13 ) return TRUE;
    Category c = category();
    return c >= Separator_Space && c <= Separator_Paragraph;
}

/*!
  Returns whether the character is a mark (Mark_* categories).
*/
bool QChar::isMark() const
{
    Category c = category();
    return c >= Mark_NonSpacing && c <= Mark_Enclosing;
}

/*!
  Returns whether the character is punctuation (Punctuation_* categories).
*/
bool QChar::isPunct() const
{
    Category c = category();
    return (c >= Punctuation_Connector && c <= Punctuation_Other);
}

/*!
  Returns whether the character is a letter (Letter_* categories).
*/
bool QChar::isLetter() const
{
    Category c = category();
    return (c >= Letter_Uppercase && c <= Letter_Other);
}

/*!
  Returns whether the character is a number (of any sort - Number_* categories).

  \sa isDigit()
*/
bool QChar::isNumber() const
{
    Category c = category();
    return c >= Number_DecimalDigit && c <= Number_Other;
}

/*!
  Returns whether the character is a letter or number (Letter_* or Number_* categories).
*/
bool QChar::isLetterOrNumber() const
{
    Category c = category();
    return (c >= Letter_Uppercase && c <= Letter_Other)
	|| (c >= Number_DecimalDigit && c <= Number_Other);
}


/*!
  Returns whether the character is a decimal digit (Number_DecimalDigit).
  */
bool QChar::isDigit() const
{
    return (category() == Number_DecimalDigit);
}

/*!
  Returns the numeric value of the digit, or -1 if the character is not
  a digit.
*/
int QChar::digitValue() const
{
#ifndef QT_NO_UNICODETABLES
    const Q_INT8 *dec_row = decimal_info[row()];
    if( !dec_row )
	return -1;
    return decimal_info[row()][cell()];
#else
    // ##### just latin1
    if ( rw != 0 || cl < '0' || cl > '9' )
	return -1;
    else
	return cl - '0';
#endif
}

/*!
  Returns the character category.

  \sa Category
*/
QChar::Category QChar::category() const
{
#ifndef QT_NO_UNICODETABLES
    return (Category)(unicode_info[row()][cell()]);
#else
// ### just ASCII
    if ( rw == 0 ) {
	return (Category)(ui_00[cell()]);
    }
    return Letter_Uppercase; //#######
#endif
}

/*!
  Returns the characters directionality.

  \sa Direction
*/
QChar::Direction QChar::direction() const
{
#ifndef QT_NO_UNICODETABLES
    const Q_UINT8 *rowp = direction_info[row()];
    if(!rowp) return QChar::DirL;
    return (Direction) ( *(rowp+cell()) &0x1f );
#else
    return DirL;
#endif
}

/*!
  This function is not supported (it may change to use Unicode
  character classes).

  Returns information about the joining properties of the
  character (needed for arabic).
*/
QChar::Joining QChar::joining() const
{
#ifndef QT_NO_UNICODETABLES
    const Q_UINT8 *rowp = direction_info[row()];
    if ( !rowp )
	return QChar::OtherJoining;
    return (Joining) ((*(rowp+cell()) >> 5) &0x3);
#else
    return OtherJoining;
#endif
}


/*!
  Returns whether the character is a mirrored character (one that
  should be reversed if the text direction is reversed).
*/
bool QChar::mirrored() const
{
#ifndef QT_NO_UNICODETABLES
    const Q_UINT8 *rowp = direction_info[row()];
    if ( !rowp )
	return FALSE;
    return *(rowp+cell())>128;
#else
    return FALSE;
#endif
}

/*!
  Returns the mirrored char if this character is a mirrored char, the char
  itself otherwise
*/
QChar QChar::mirroredChar() const
{
#ifndef QT_NO_UNICODETABLES
    if(!mirrored()) return *this;

    int i;
    int c = unicode();
    for (i = 0; i < symmetricPairsSize; i += 2) {
        if (symmetricPairs[i] == c)
          return symmetricPairs[i+1];
    }
    return 0;
#else
    return *this;
#endif
}

/*!
  Decomposes a character into its parts. Returns QString::null if
  no decomposition exists.
*/
QString QChar::decomposition() const
{
#ifndef QT_NO_UNICODETABLES
    const Q_UINT16 *r = decomposition_info[row()];
    if(!r) return QString::null;

    Q_UINT16 pos = r[cell()];
    if(!pos) return QString::null;
    pos+=2;

    QString s;
    Q_UINT16 c;
    while((c = decomposition_map[pos++]) != 0) s += QChar(c);

    return s;
#else
    return null;
#endif
}

/*!
  Returns the tag defining the composition of the character.
  Returns QChar::Single if no decomposition exists.
*/
QChar::Decomposition QChar::decompositionTag() const
{
#ifndef QT_NO_UNICODETABLES
    const Q_UINT16 *r = decomposition_info[row()];
    if(!r) return QChar::Single;

    Q_UINT16 pos = r[cell()];
    if(!pos) return QChar::Single;

    return (QChar::Decomposition) decomposition_map[pos];
#else
    return Single; // ########### FIX eg. just latin1
#endif
}

/*!
  Returns the lowercase equivalent if the character is uppercase,
  or the character itself otherwise.
*/
QChar QChar::lower() const
{
#ifndef QT_NO_UNICODETABLES
    if(category() != Letter_Uppercase) return *this;
    Q_UINT16 lower = *(case_info[row()]+cell());
    if(lower == 0) return *this;
    return lower;
#else
    if (row())
	return *this;
    else
	return QChar(tolower(latin1()));
#endif
}

/*!
  Returns the uppercase equivalent if the character is lowercase,
  or the character itself otherwise.
*/
QChar QChar::upper() const
{
#ifndef QT_NO_UNICODETABLES
    if(category() != Letter_Lowercase) return *this;
    Q_UINT16 upper = *(case_info[row()]+cell());
    if(upper == 0) return *this;
    return upper;
#else
    if (row())
	return *this;
    else
	return QChar(toupper(latin1()));
#endif
}

/*!
  \fn QChar::operator char() const

  Returns the Latin1 character equivalent to the QChar,
  or 0.  This is mainly useful for non-internationalized software.

  \sa unicode()
*/

/*!
  \fn ushort QChar::unicode() const

  Returns the numeric Unicode value equal to the QChar.  Normally, you
  should use QChar objects as they are equivalent, but for some low-level
  tasks (eg. indexing into an array of Unicode information), this function
  is useful.
*/

/*****************************************************************************
  Documentation of QChar related functions
 *****************************************************************************/

/*!
  \fn int operator==( QChar c1, QChar c2 )
  \relates QChar

  Returns TRUE if \a c1 and \a c2 are the same Unicode character.
*/

/*!
  \fn int operator==( char ch, QChar c )
  \relates QChar

  Returns TRUE if \a c is the ASCII/Latin1 character \a ch.
*/

/*!
  \fn int operator==( QChar c, char ch )
  \relates QChar

  Returns TRUE if \a c is the ASCII/Latin1 character \a ch.
*/

/*!
  \fn int operator!=( QChar c1, QChar c2 )
  \relates QChar

  Returns TRUE if \a c1 and \a c2 are not the same Unicode character.
*/

/*!
  \fn int operator!=( char ch, QChar c )
  \relates QChar

  Returns TRUE if \a c is not the ASCII/Latin1 character \a ch.
*/

/*!
  \fn int operator!=( QChar c, char ch )
  \relates QChar

  Returns TRUE if \a c is not the ASCII/Latin1 character \a ch.
*/

/*!
  \fn int operator<=( QChar c1, QChar c2 )
  \relates QChar

  Returns TRUE if the numeric Unicode value of \a c1 is less than that
  of \a c2, or they are the same Unicode character.
*/

/*!
  \fn int operator<=( QChar c, char ch )
  \relates QChar

  Returns TRUE if the numeric Unicode value of \a c is less than or
  equal to that of the ASCII/Latin1 character \a ch.
*/

/*!
  \fn int operator<=( char ch, QChar c )
  \relates QChar

  Returns TRUE if the numeric Unicode value of the ASCII/Latin1
  character \a ch is less than or equal to that of \a c.
*/

/*!
  \fn int operator>=( QChar c1, QChar c2 )
  \relates QChar

  Returns TRUE if the numeric Unicode value of \a c1 is greater than that
  of \a c2, or they are the same Unicode character.
*/

/*!
  \fn int operator>=( QChar c, char ch )
  \relates QChar

  Returns TRUE if the numeric Unicode value of \a c is greater than or
  equal to that of the ASCII/Latin1 character \a ch.
*/

/*!
  \fn int operator>=( char ch, QChar c )
  \relates QChar

  Returns TRUE if the numeric Unicode value of the ASCII/Latin1
  character \a ch is greater than or equal to that of \a c.
*/

/*!
  \fn int operator<( QChar c1, QChar c2 )
  \relates QChar

  Returns TRUE if the numeric Unicode value of \a c1 is less than that
  of \a c2.
*/

/*!
  \fn int operator<( QChar c, char ch )
  \relates QChar

  Returns TRUE if the numeric Unicode value of \a c is less than that
  of the ASCII/Latin1 character \a ch.
*/

/*!
  \fn int operator<( char ch, QChar c )
  \relates QChar

  Returns TRUE if the numeric Unicode value of the ASCII/Latin1
  character \a ch is less than that of \a c.
*/

/*!
  \fn int operator>( QChar c1, QChar c2 )
  \relates QChar

  Returns TRUE if the numeric Unicode value of \a c1 is greater than
  that of \a c2.
*/

/*!
  \fn int operator>( QChar c, char ch )
  \relates QChar

  Returns TRUE if the numeric Unicode value of \a c is greater than
  that of the ASCII/Latin1 character \a ch.
*/

/*!
  \fn int operator>( char ch, QChar c )
  \relates QChar

  Returns TRUE if the numeric Unicode value of the ASCII/Latin1
  character \a ch is greater than that of \a c.
*/

#ifndef QT_NO_UNICODETABLES

// small class used internally in QString::Compose()
class QLigature
{
public:
    QLigature( QChar c );

    Q_UINT16 first() { cur = ligatures; return cur ? *cur : 0; }
    Q_UINT16 next() { return cur && *cur ? *(cur++) : 0; }
    Q_UINT16 current() { return cur ? *cur : 0; }

    int match(QString & str, unsigned int index);
    QChar head();
    QChar::Decomposition tag();

private:
    Q_UINT16 *ligatures;
    Q_UINT16 *cur;
};

QLigature::QLigature( QChar c )
{
    const Q_UINT16 *r = ligature_info[c.row()];
    if( !r )
	ligatures = 0;
    else
    {
	const Q_UINT16 pos = r[c.cell()];
	ligatures = (Q_UINT16 *)&(ligature_map[pos]);
    }
    cur = ligatures;
}

QChar QLigature::head()
{
    if(current())
	return QChar(decomposition_map[current()+1]);

    return QChar::null;
}

QChar::Decomposition QLigature::tag()
{
    if(current())
	return (QChar::Decomposition) decomposition_map[current()];

    return QChar::Canonical;
}

int QLigature::match(QString & str, unsigned int index)
{
    unsigned int i=index;

    if(!current()) return 0;

    Q_UINT16 lig = current() + 2;
    Q_UINT16 ch;

    while ((i < str.length()) && (ch = decomposition_map[lig])) {
	if (str[(int)i] != QChar(ch))
	    return 0;
	i++; lig++;
    }

    if (!decomposition_map[lig])
    {
	return i-index;
    }
    return 0;
}

#endif

// this function is just used in QString::compose()
static inline bool format(QChar::Decomposition tag, QString & str,
			  int index, int len)
{
    unsigned int l = index + len;
    unsigned int r = index;

    bool left = FALSE, right = FALSE;

    left = ((l < str.length()) &&
	    ((str[(int)l].joining() == QChar::Dual) ||
	     (str[(int)l].joining() == QChar::Right)));
    if (r > 0) {
	r--;
	//printf("joining(right) = %d\n", str[(int)r].joining());
	right = (str[(int)r].joining() == QChar::Dual);
    }


    switch (tag) {
    case QChar::Medial:
	return (left & right);
    case QChar::Initial:
	return (left && !right);
    case QChar::Final:
	return (right);// && !left);
    case QChar::Isolated:
    default:
	return (!right && !left);
    }
} // format()

/*
  QString::compose() and visual() were developed by Gordon Tisher
  <tisher@uniserve.ca>, with input from Lars Knoll <knoll@mpi-hd.mpg.de>,
  who developed the unicode data tables.
*/
/*!
  Note that this function is not supported in Qt 2.0, and is merely
  for experimental and illustrative purposes.  It is mainly of interest
  to those experimenting with Arabic and other composition-rich texts.

  Applies possible ligatures to a QString, useful when composition-rich
  text requires rendering with glyph-poor fonts, but also
  makes compositions such as QChar(0x0041) ('A') and QChar(0x0308)
  (Unicode accent diaresis) giving QChar(0x00c4) (German A Umlaut).
*/
void QString::compose()
{
#ifndef QT_NO_UNICODETABLES
    unsigned int index=0, len;
    unsigned int cindex = 0;

    QChar code, head;

    QArray<QChar> dia;

    QString composed = *this;

    while (index < length()) {
	code = at(index);
	//printf("\n\nligature for 0x%x:\n", code.unicode());
	QLigature ligature(code);
	ligature.first();
	while(ligature.current()) {
	    if ((len = ligature.match(*this, index)) != 0) {
		head = ligature.head();
		unsigned short code = head.unicode();
		// we exclude Arabic presentation forms A and a few
		// other ligatures, which are undefined in most fonts
		if(!(code > 0xfb50 && code < 0xfe80) &&
		   !(code > 0xfb00 && code < 0xfb2a)) {
				// joining info is only needed for arabic
		    if (format(ligature.tag(), *this, index, len)) {
			//printf("using ligature 0x%x, len=%d\n",code,len);
			// replace letter
			composed.replace(cindex, len, QChar(head));
			index += len-1;
			// we continue searching in case we have a final
			// form because medial ones are preferred.
			if ( len != 1 || ligature.tag() !=QChar::Final )
			    break;
		    }
		}
	    }
	    ligature.next();
	}
	cindex++;
	index++;
    }
    *this = composed;
#endif
}

static QChar LRM ((ushort)0x200e);
static QChar RLM ((ushort)0x200f);
static QChar LRE ((ushort)0x202a);
static QChar RLE ((ushort)0x202b);
static QChar RLO ((ushort)0x202e);
static QChar LRO ((ushort)0x202d);
static QChar PDF ((ushort)0x202c);

#if 0
static inline bool is_arabic(unsigned short x) {
    return (((x >= 0x0600) && (x <= 0x07bf)) ||
	    ((x >= 0xfb50) && (x <= 0xfdff)) ||
	    ((x >= 0xfe70) && (x <= 0xfeff)));
}
#endif

static inline bool is_neutral(unsigned short dir) {
  return ((dir == QChar::DirB) ||
		  (dir == QChar::DirS) ||
		  (dir == QChar::DirWS) ||
		  (dir == QChar::DirON) ||
	          (dir == QChar::DirNSM));
}

/*!
  This function returns the basic directionality of the string (QChar::DirR for
  right to left and QChar::DirL for left to right). Useful to find the right
  alignment.
  */
QChar::Direction QString::basicDirection()
{
#ifndef QT_NO_UNICODETABLES
    // find base direction
    unsigned int pos = 0;
    while ((pos < length()) &&
	   (at(pos) != RLE) &&
	   (at(pos) != LRE) &&
	   (at(pos) != RLO) &&
	   (at(pos) != LRO) &&
	   (at(pos).direction() > 1) &&
	   (at(pos).direction() != QChar::DirAL)) // not R and not L
	pos++;

    if ((at(pos).direction() == QChar::DirR) ||
	(at(pos).direction() == QChar::DirAL) ||
	(at(pos) == RLE) ||
	(at(pos) == RLO))
	return QChar::DirR;
#endif

    return QChar::DirL;
}

#ifndef QT_NO_UNICODETABLES
// reverses part of the QChar array to get visual ordering
// called from QString::visual()
//
static unsigned int reverse( QString &chars, unsigned char *level,
			     unsigned int a, unsigned int b)
{
    unsigned int c = a;
    unsigned char lev = level[c];

    while ((c < b) && (level[c] >= lev)) {
	if (level[c] > lev)
	    c = reverse(chars, level, c, b);
	c++;
    }

    if (lev > 0) {
	QChar temp;
	unsigned int d = a, e = c-1;
	while (d < e) {
	    temp = chars[(int)d];
	    chars[(int)d] = chars[(int)e];
	    chars[(int)e] = temp;

	    d++; e--;
	}
    }

    return c;
}

// small class used for the ordering algorithm in QString::visual()
class QBidiState {
public:
    unsigned char level;
    signed   char override;

    QBidiState(unsigned char l, signed char o) : level(l), override(o) {};
};

// matrix for resolving neutral types

#define NEG1 (QChar::Direction)(-1)

static QChar::Direction resolv[5][5] =
{
	{ NEG1,         QChar::DirR, QChar::DirL, QChar::DirEN, QChar::DirAN },
	{ QChar::DirR,  QChar::DirR, NEG1,        QChar::DirR,  QChar::DirR  },
	{ QChar::DirL,  NEG1,        QChar::DirL, QChar::DirL,  NEG1         },
	{ QChar::DirEN, QChar::DirR, QChar::DirL, QChar::DirEN, QChar::DirR  },
	{ QChar::DirAN, QChar::DirR, NEG1,        NEG1,         QChar::DirAN }
};

#endif

/*!
  This function returns the QString ordered visually. Useful for
  painting the string or when transforming to a visually ordered
  encoding.
*/
QString QString::visual(int index, int len)
{
#ifndef QT_NO_UNICODETABLES
    // #### This needs much more optimizing - it is called for
    // #### every text operation.

    unsigned char *level;
    QChar::Direction *dir;
    unsigned char base = 0;

    unsigned int l = length();

    // check bounds
    if (len == -1)
	len = length()-index;
    if ((uint)index > l)
	return QString::null;

    // find base direction
    unsigned int pos = 0;
    while ((pos < length()) &&
	   (at(pos) != RLE) &&
	   (at(pos) != LRE) &&
	   (at(pos) != RLO) &&
	   (at(pos) != LRO) &&
	   (at(pos).direction() > 1) &&
	   (at(pos).direction() != QChar::DirAL)
	   ) // not R and not L
	pos++;

    if ((pos < length()) &&
	    ((at(pos).direction() == QChar::DirR) ||
	     (at(pos).direction() == QChar::DirAL) ||
	    (at(pos) == RLE) ||
	    (at(pos) == RLO)))
	base = 1;

    // is there any BiDi char at all?
    if ( base == 0 && pos == l ) {
	return mid(index, len);
    }


    level = new uchar[l];
    dir   = new QChar::Direction[l];

    // explicit override pass
    //unsigned int code_count = 0;

    QStack<QBidiState> stack;
    stack.setAutoDelete(TRUE);

    unsigned char    clevel   = base;
    signed char      override = -1;

    for (pos = 0; pos < l; pos++) {

	if (at(pos) == RLE) {
	    //code_count++;
	    stack.push(new QBidiState(clevel, override));
	    if (clevel < 254)
		clevel += 1 + clevel % 2;
	    override = -1;
	}
	else if (at(pos) == LRE) {
	    //code_count++;
	    stack.push(new QBidiState(clevel, override));
	    if (clevel < 254)
		clevel += 2 - clevel % 2;
	    override = -1;
	}
	else if (at(pos) == RLO) {
	    //code_count++;
	    stack.push(new QBidiState(clevel, override));
	    if (clevel < 254)
		clevel += 1 + clevel % 2;
	    override = QChar::DirR;
	}
	else if (at(pos) == LRO) {
	    //code_count++;
	    stack.push(new QBidiState(clevel, override));
	    if (clevel < 254)
		clevel += 2 - clevel % 2;
	    override = QChar::DirL;
	}
	else if (at(pos) == PDF) {
	    //code_count++;
	    if (!stack.isEmpty()) {
		override = stack.top()->override;
		clevel   = stack.top()->level;
		stack.remove();
	    }
	}

	// TODO: catch block separators (newlines, paras, etc.)

	level[pos] = clevel;
	if (override != -1)
	    dir[pos] = (QChar::Direction) override;
	else
	    dir[pos] = at(pos).direction();
    }

    // weak type pass
    for (pos = 0; pos < l; pos++) {

	int i;

	switch (at(pos).direction()) {
	case QChar::DirEN:
	    i   = pos-1;
	    while ((i >= 0) &&
		   !(at(i).direction() == QChar::DirAN) &&
		   !(at(i).direction() == QChar::DirAL) &&
		   !(at(i).direction() == QChar::DirB))
		i--;

	    if ((i >= 0) &&
		((at(i).direction() == QChar::DirAN) ||
		 (at(i).direction() == QChar::DirAL)))
		dir[pos] = QChar::DirAN;

	    break;
	case QChar::DirES:
	case QChar::DirCS:
	    if ((pos > 0) && (pos < l-1) &&
		(dir[pos-1] == dir[pos+1]))
		dir[pos] = dir[pos-1];
	    else
		dir[pos] = QChar::DirON;

	    break;
	case QChar::DirET:
	    if (((pos > 0) && (dir[pos-1] == QChar::DirEN)) ||
		((pos < l-1) && (dir[pos+1] == QChar::DirEN)))
		dir[pos] = QChar::DirEN;
	    else
		dir[pos] = QChar::DirON;

	    break;
	case QChar::DirAL:
	    dir[pos] = QChar::DirR;
	    break;
	default:
	    break;
	}
    }

    // neutral type pass
    for (pos = 0; pos < l; pos++) {
	  QChar::Direction left,right; // declaring l here shadowed previous l

	if (is_neutral(dir[pos])) {
	    if (pos > 0)
		left = dir[pos-1];
	    else
		left = (base == 0 ? QChar::DirL : QChar::DirR);

	    int i = pos;

	    while ((i < (int)l-1) && is_neutral(dir[i+1]))
		i++;

	    if (i < (int)l-1)
		right = dir[i+1];
	    else
		right = (base == 0 ? QChar::DirL : QChar::DirR);

	    for (int j=pos; j <= i; j++) {
		  int a = 1, b = 1;
		  while ((a < 5) && (left != resolv[0][a]))
			a++;
		  while ((b < 5) && (right != resolv[0][b]))
			b++;
		  if ((a == 5) || (b == 5))
			dir[j] = (base == 0 ? QChar::DirL : QChar::DirR);
		  else
			dir[j] = resolv[a][b];

		  if (dir[j] == (QChar::Direction)(-1))
			dir[j] = (base == 0 ? QChar::DirL : QChar::DirR);
	    }
	}
    }

    // implicit level pass
    QChar::Direction prec = (base == 0 ? QChar::DirL : QChar::DirR);

    for (pos = 0; pos < l; pos++) {
	if (level[pos] % 2) {
	    switch (dir[pos]) {
	    case QChar::DirL:
	    case QChar::DirAN:
	    case QChar::DirEN:
		level[pos] += 1;
		break;
	    default:
		break;
	    }
	} else {
	    switch (dir[pos]) {
	    case QChar::DirL:
				// do nothing
		break;
	    case QChar::DirR:
		level[pos] += 1;
		break;
	    case QChar::DirEN:
		if (prec == QChar::DirL)
		    continue;
				// fall through
	    case QChar::DirAN:
		level[pos] += 2;
		break;
	    default:
		break;
	    }
	}

	prec = dir[pos];
    }

	// now do the work!
	QString ret(*this);
    reverse(ret, level, index, index+len);

    delete [] level;
    delete [] dir;

    return ret;
#else
    return mid(index,len);
#endif
}



// These macros are used for efficient allocation of QChar strings.
// IMPORTANT! If you change these, make sure you also change the
// "delete unicode" statement in ~QStringData() in qstring.h correspondingly!

#define QT_ALLOC_QCHAR_VEC( N ) (QChar*) new char[ sizeof(QChar)*( N ) ]
#define QT_DELETE_QCHAR_VEC( P ) delete[] ((char*)( P ))


/*!
  This utility function converts the 8-bit string
  \a ba to Unicode, returning the result.

  The caller is responsible for deleting the return value with delete[].
*/

QChar* QString::asciiToUnicode( const QByteArray& ba, uint* len )
{
    if ( ba.isNull() ) {
	*len = 0;
	return 0;
    }
    int l = 0;
    while ( l < (int)ba.size() && ba[l] )
	l++;
    char* str = ba.data();
    QChar *uc = new QChar[ l ];	  // Can't use macro, since function is public
    QChar *result = uc;
    if ( len )
	*len = l;
    while (l--)
	*uc++ = *str++;
    return result;
}

static QChar* internalAsciiToUnicode( const QByteArray& ba, uint* len )
{
    if ( ba.isNull() ) {
	*len = 0;
	return 0;
    }
    int l = 0;
    while ( l < (int)ba.size() && ba[l] )
	l++;
    char* str = ba.data();
    QChar *uc = QT_ALLOC_QCHAR_VEC( l );
    QChar *result = uc;
    if ( len )
	*len = l;
    while (l--)
	*uc++ = *str++;
    return result;
}

/*!
  This utility function converts the NUL-terminated 8-bit string
  \a str to Unicode, returning the result and setting \a len to
  the length of the Unicode string.

  The caller is responsible for deleting the return value with delete[].
*/

QChar* QString::asciiToUnicode( const char *str, uint* len, uint maxlen )
{
    QChar* result = 0;
    uint l = 0;
    if ( str ) {
	if ( maxlen != (uint)-1 ) {
	    while ( l < maxlen && str[l] )
		l++;
	} else {
	    // Faster?
	    l = qstrlen(str);
	}
	QChar *uc = new QChar[ l ]; // Can't use macro since function is public
	result = uc;
	uint i = l;
	while ( i-- )
	    *uc++ = *str++;
    }
    if ( len )
	*len = l;
    return result;
}

static QChar* internalAsciiToUnicode( const char *str, uint* len,
				      uint maxlen = (uint)-1 )
{
    QChar* result = 0;
    uint l = 0;
    if ( str ) {
	if ( maxlen != (uint)-1 ) {
	    while ( l < maxlen && str[l] )
		l++;
	} else {
	    // Faster?
	    l = qstrlen(str);
	}
	QChar *uc = QT_ALLOC_QCHAR_VEC( l );
	result = uc;
	uint i = l;
	while ( i-- )
	    *uc++ = *str++;
    }
    if ( len )
	*len = l;
    return result;
}

/*!
  This utility function converts \a l 16-bit characters from
  \a uc to ASCII, returning a NUL-terminated string.

  The caller is responsible for deleting the string with delete[].
*/
char* QString::unicodeToAscii(const QChar *uc, uint l)
{
    if (!uc) {
	return 0;
    }
    char *a = new char[l+1];
    char *result = a;
    while (l--)
	*a++ = *uc++;
    *a = '\0';
    return result;
}

static uint computeNewMax( uint len )
{
  if (len >= 0x80000000)
    return len;

  uint newMax = 4;
  while ( newMax < len )
    newMax *= 2;
  // try to save some memory
  if ( newMax >= 1024 * 1024 && len <= newMax - (newMax >> 2) )
    newMax -= newMax >> 2;
  return newMax;
}

/*!
  Returns the QString as a zero terminated array of unsigned shorts
  if the string is not null; otherwise returns zero.

  The result remains valid so long as one unmodified
  copy of the source string exists.
 */
const unsigned short *QString::ucs2() const
{
  if ( ! d->unicode )
    return 0;
  unsigned int len = d->len;
  if ( d->maxl < len + 1 ) {
    // detach, grow or shrink
    uint newMax = computeNewMax( len + 1 );
    QChar* nd = QT_ALLOC_QCHAR_VEC( newMax );
    if ( nd ) {
      if ( d->unicode )
        memcpy( nd, d->unicode, sizeof(QChar)*len );
      ((QString *)this)->deref();
      ((QString *)this)->d = new QStringData( nd, len, newMax );
    }
  }
  d->unicode[len] = 0;
  return (unsigned short *) d->unicode;
}

/*!
    Constructs a string that is a deep copy of \a str, interpreted as a
    UCS2 encoded, zero terminated, Unicode string.

    If \a str is 0, then a null string is created.
    \sa isNull()
 */
QString QString::fromUcs2( const unsigned short *str )
{
  if ( !str ) {
    return QString::null;
  } else {
    int length = 0;
    while ( str[length] != 0 )
      length++;
    QChar* uc = QT_ALLOC_QCHAR_VEC( length );
    memcpy( uc, str, length*sizeof(QChar) );
    return QString( new QStringData( uc, length, length ), TRUE );
  }
}


/*****************************************************************************
  QString member functions
 *****************************************************************************/

/*!
  \class QString qstring.h

  \brief The QString class provides an abstraction of Unicode text and
	  the classic C null-terminated char array (<var>char*</var>).

  \ingroup tools
  \ingroup shared

  QString uses \link shclass.html implicit sharing\endlink, and so it
  is very efficient and easy to use.

  In all QString methods that take <var>const char*</var> parameters,
  the <var>const char*</var> is interpreted as a classic C-style
  0-terminated ASCII string. It is legal for the <var>const
  char*</var> parameter to be 0. The results are undefined if the
  <var>const char*</var> string is not 0-terminated. Functions that
  copy classic C strings into a QString will not copy the terminating
  0-character. The QChar array of the QString (as returned by
  unicode()) is not terminated by a null.

  A QString that has not been assigned to anything is \a null, i.e. both
  the length and data pointer is 0. A QString that references the empty
  string ("", a single '\0' char) is \a empty.	Both null and empty
  QStrings are legal parameters to the methods. Assigning <var>const char
  * 0</var> to QString gives a null QString.

  Note that if you find that you are mixing usage of QCString, QString,
  and QByteArray, this causes lots of unnecessary copying and might
  indicate that the true nature of the data you are dealing with is
  uncertain.  If the data is NUL-terminated 8-bit data, use QCString;
  if it is unterminated (ie. contains NULs) 8-bit data, use QByteArray;
  if it is text, use QString.

  \sa QChar \link shclass.html Shared classes\endlink
*/

Q_EXPORT QStringData *QString::shared_null = 0;
QT_STATIC_CONST_IMPL QString QString::null;
QT_STATIC_CONST_IMPL QChar QChar::null;
QT_STATIC_CONST_IMPL QChar QChar::replacement((ushort)0xfffd);
QT_STATIC_CONST_IMPL QChar QChar::byteOrderMark((ushort)0xfeff);
QT_STATIC_CONST_IMPL QChar QChar::byteOrderSwapped((ushort)0xfffe);
QT_STATIC_CONST_IMPL QChar QChar::nbsp((ushort)0x00a0);

QStringData* QString::makeSharedNull()
{
    return shared_null=new QStringData;
}

// Uncomment this to get some useful statistics.
// #define Q2HELPER(x) x

#ifdef Q2HELPER
static int stat_construct_charstar=0;
static int stat_construct_charstar_size=0;
static int stat_construct_null=0;
static int stat_construct_int=0;
static int stat_construct_int_size=0;
static int stat_construct_ba=0;
static int stat_get_ascii=0;
static int stat_get_ascii_size=0;
static int stat_copy_on_write=0;
static int stat_copy_on_write_size=0;
static int stat_fast_copy=0;
Q_EXPORT void qt_qstring_stats()
{
	qDebug("construct_charstar = %d (%d chars)", stat_construct_charstar, stat_construct_charstar_size);
	qDebug("construct_null = %d", stat_construct_null);
	qDebug("construct_int = %d (%d chars)", stat_construct_int, stat_construct_int_size);
	qDebug("construct_ba = %d", stat_construct_ba);
	qDebug("get_ascii = %d (%d chars)", stat_get_ascii, stat_get_ascii_size);
	qDebug("copy_on_write = %d (%d chars)", stat_copy_on_write, stat_copy_on_write_size);
	qDebug("fast_copy = %d", stat_fast_copy);
}
#else
#define Q2HELPER(x)
#endif

/*!
  \fn QString::QString()

  Constructs a null string.
  \sa isNull()
*/

/*!
  Constructs a string containing the one character \a ch.
*/
QString::QString( QChar ch )
{
    d = new QStringData( QT_ALLOC_QCHAR_VEC( 1 ), 1, 1 );
    d->unicode[0] = ch;
}

/*!
  Constructs an implicitly-shared copy of \a s.
*/
QString::QString( const QString &s ) :
    d(s.d)
{
    Q2HELPER(stat_fast_copy++)
    d->ref();
}

/*!
  Private function.

  Constructs a string with preallocated space for \a size characters.

  The string is empty.

  \sa isNull()
*/

QString::QString( int size, bool /*dummy*/ )
{
    if ( size ) {
	Q2HELPER(stat_construct_int++)
	int l = size;
	Q2HELPER(stat_construct_int_size+=l)
	QChar* uc = QT_ALLOC_QCHAR_VEC( l );
	d = new QStringData( uc, 0, l );
    } else {
	Q2HELPER(stat_construct_null++)
	d = shared_null ? shared_null : (shared_null=new QStringData);
	d->ref();
    }
}

/*!
  Constructs a string that is a deep copy of \a ba interpreted as
  a classic C string.
*/

QString::QString( const QByteArray& ba )
{
    Q2HELPER(stat_construct_ba++)
    uint l;
    QChar *uc = internalAsciiToUnicode(ba,&l);
    d = new QStringData(uc,l,l);
}

QString::QString( const QCString& ba )
{
    //Q2HELPER(stat_construct_ba++)
    //uint l;
    //QChar *uc = internalAsciiToUnicode(ba,&l);
    //d = new QStringData(uc,l,l);
    Q2HELPER(stat_fast_copy++)
    QString s = QString::fromUtf8(ba.data(),ba.length());
    d = s.d;
    d->ref();
}

/*!
  Constructs a string that is a deep copy of the
  first \a length QChar in the array \a unicode.

  If \a unicode and \a length are 0, a null string is created.

  If only \a unicode is 0, the string is empty, but has
  \a length characters of space preallocated - QString expands
  automatically anyway, but this may speed some cases up a little.

  \sa isNull()
*/

QString::QString( const QChar* unicode, uint length )
{
    if ( !unicode && !length ) {
	d = shared_null ? shared_null : makeSharedNull();
	d->ref();
    } else {
	QChar* uc = QT_ALLOC_QCHAR_VEC( length );
	if ( unicode )
	    memcpy(uc, unicode, length*sizeof(QChar));
	d = new QStringData(uc,unicode ? length : 0,length);
    }
}

/*!
  Constructs a string that is a deep copy of \a str, interpreted as a
  classic C string.

  If \a str is 0 a null string is created.

  This is a cast constructor, but it is perfectly safe: converting a Latin1
  const char* to QString preserves all the information.
  You can disable this constructor by
  defining QT_NO_CAST_ASCII when you compile your applications.
  You can also make QString objects by using setLatin1()/fromLatin1(), or
  fromLocal8Bit(), fromUtf8(), or whatever encoding is appropriate for
  the 8-bit data you have.

  \sa isNull()
*/

QString::QString( const char *str )
{
    //Q2HELPER(stat_construct_charstar++)
    //uint l;
    //QChar *uc = internalAsciiToUnicode(str,&l);
    //Q2HELPER(stat_construct_charstar_size+=l)
    //d = new QStringData(uc,l,l);
    Q2HELPER(stat_fast_copy++)
    QString s = QString::fromUtf8(str);
    d = s.d;
    d->ref();
}


/*! \fn QString::~QString()

Destroys the string and frees the "real" string, if this was the last
copy of that string.
*/


/*!
  Deallocates any space reserved solely by this QString.
*/

void QString::real_detach()
{
    setLength( length() );
}

void QString::deref()
{
    if ( d->deref() ) {
	if ( d == shared_null )
	    shared_null = 0;
	delete d;
	d = 0; // helps debugging
    }
}

void QStringData::deleteSelf()
{
    delete this;
}

/*!
  \fn QString& QString::operator=( QChar c )
  Sets the string to contain just the single character \a c.
*/

/*!
  \fn QString& QString::operator=( char c )
  Sets the string to contain just the single character \a c.
*/

/*!
  Assigns a shallow copy of \a s to this string and returns a
  reference to this string.
*/
QString &QString::operator=( const QString &s )
{
    Q2HELPER(stat_fast_copy++)
    s.d->ref();
    deref();
    d = s.d;
    return *this;
}

/*!
  Assigns a deep copy of \a cs, interpreted as a classic C string, to
  this string and returns a reference to this string.
*/
QString &QString::operator=( const QCString& cs )
{
    return setLatin1(cs);
}


/*!
  Assigns a deep copy of \a str, interpreted as a classic C string,
  to this string and returns a reference to this string.

  If \a str is 0 a null string is created.

  \sa isNull()
*/
QString &QString::operator=( const char *str )
{
    return setLatin1(str);
}


/*!
  \fn bool QString::isNull() const

  Returns TRUE if the string is null.
  A null string is also an empty string.

  Example:
  \code
    QString a;		// a.unicode() == 0,  a.length() == 0
    QString b = "";	// b.unicode() == "", b.length() == 0
    a.isNull();		// TRUE, because a.unicode() == 0
    a.isEmpty();	// TRUE, because a.length() == 0
    b.isNull();		// FALSE, because b.unicode() != 0
    b.isEmpty();	// TRUE, because b.length() == 0
  \endcode

  \sa isEmpty(), length()
*/

/*!
  \fn bool QString::isEmpty() const

  Returns TRUE if the string is empty, i.e. if length() == 0.
  An empty string is not always a null string.

  See example in isNull().

  \sa isNull(), length()
*/

/*!
  \fn uint QString::length() const

  Returns the length of the string.

  Null strings and empty strings have zero length.

  \sa isNull(), isEmpty()
*/

/*!
  Truncates the string at position \a newLen if newLen is less than the
  current length . Otherwise, nothing happens.

  Example:
  \code
    QString s = "truncate this string";
    s.truncate( 5 );				// s == "trunc"
  \endcode

  In Qt 1.x, it was possible to "truncate" a string to a longer
  length.  This is no longer possible.

*/

void QString::truncate( uint newLen )
{
    if ( newLen < d->len )
	setLength( newLen );
}

/*### Make this public in 3.0
  Ensures that at least \a newLen characters are allocated, and
  sets the length to \a newLen.  This function always detaches the
  string from other references to the same data.  Any new space
  allocated is \e not defined.

  If \a newLen is 0, this string becomes empty, unless this string is
  null, in which case it remains null.

  \sa truncate(), isNull(), isEmpty()
*/

void QString::setLength( uint newLen )
{
    if ( d->count != 1 || newLen > d->maxl || 		// detach, grow, or
	 ( newLen*4 < d->maxl && d->maxl > 4 ) ) {	// shrink
	Q2HELPER(stat_copy_on_write++)
	Q2HELPER(stat_copy_on_write_size+=d->len)
	uint newMax = 4;
	while ( newMax < newLen )
	    newMax *= 2;
	QChar* nd = QT_ALLOC_QCHAR_VEC( newMax );
	uint len = QMIN( d->len, newLen );
	if ( d->unicode )
	    memcpy( nd, d->unicode, sizeof(QChar)*len );
	deref();
	d = new QStringData( nd, newLen, newMax );
    } else {
	d->len = newLen;
	d->dirtyascii = 1;
    }
}

/*!  Returns a string equal to this one, but with the lowest-numbered
  occurrence of \c %i (for a positive integer i) replaced by \a a.

  \code
    label.setText( tr("Rename %1 to %2?").arg(oldName).arg(newName) );
  \endcode

  \a fieldwidth is the minimum amount of space \a a is padded to.  A
  positive value produces right-aligned text, while a negative value
  produces left aligned text.

  \warning Using arg() for constructing "real" sentences
  programmatically is likely to lead to translation problems.
  Inserting objects like numbers or file names is fairly safe.

  \warning Relying on spaces to create alignment is prone to lead to
  translation problems.

  If there is no \c %i pattern, a warning message (qWarning()) is
  printed and the text as appended at the end of the string.  This is
  error recovery and should not occur in correct code.

  \sa QObject::tr()
*/
QString QString::arg(const QString& a, int fieldwidth) const
{
    int pos, len;
    QString r = *this;

    if ( !findArg( pos, len ) ) {
	qWarning( "QString::arg(): Argument missing: %s, %s",
		  (const char *)this, (const char *)a );
	// Make sure the text at least appears SOMEWHERE
	r += ' ';
	pos = r.length();
	len = 0;
    }

    r.replace( pos, len, a );
    if ( fieldwidth < 0 ) {
	QString s;
	while ( (uint)-fieldwidth > a.length() ) {
	    s += ' ';
	    fieldwidth++;
	}
	r.insert( pos + a.length(), s );
    } else if ( fieldwidth ) {
	QString s;
	while ( (uint)fieldwidth > a.length() ) {
	    s += ' ';
	    fieldwidth--;
	}
	r.insert( pos, s );
    }

    return r;
}


/*! \overload

  \a a is expressed in to \a base notation, which is decimal by
  default and must be in the range 2-36 inclusive.
*/
QString QString::arg(long a, int fieldwidth, int base) const
{
    return arg( QString::number( a, base ), fieldwidth );
}

/*! \overload

  \a a is expressed in to \a base notation, which is decimal by
  default and must be in the range 2-36 inclusive.
*/
QString QString::arg(ulong a, int fieldwidth, int base) const
{
    return arg( QString::number( a, base ), fieldwidth );
}

/*!
  \overload QString QString::arg(int a, int fieldwidth, int base) const

  \a a is expressed in to \a base notation, which is decimal by
  default and must be in the range 2-36 inclusive.

*/

/*!
  \overload QString QString::arg(uint a, int fieldwidth, int base) const

  \a a is expressed in to \a base notation, which is decimal by
  default and must be in the range 2-36 inclusive.
*/

/*!
  \overload QString QString::arg(short a, int fieldwidth, int base) const

  \a a is expressed in to \a base notation, which is decimal by
  default and must be in the range 2-36 inclusive.
*/

/*!
  \overload QString QString::arg(ushort a, int fieldwidth, int base) const

  \a a is expressed in to \a base notation, which is decimal by
  default and must be in the range 2-36 inclusive.
*/


/*! \overload

  \a a is assumed to be in the Latin1 character set.
*/
QString QString::arg(char a, int fieldwidth) const
{
    QString c;
    c += a;
    return arg( c, fieldwidth );
}

/*! \overload
*/
QString QString::arg(QChar a, int fieldwidth) const
{
    QString c;
    c += a;
    return arg( c, fieldwidth );
}

/*! \overload

  \a is formatted according to the \a fmt format specified, which is
  'g' by default and can be any of 'f', 'F', 'e', 'E', 'g' or 'G', all
  of which have the same meaning as for sprintf().  \a prec determines
  the precision, just as for number() and sprintf().
*/
QString QString::arg(double a, int fieldwidth, char fmt, int prec) const
{
    return arg( QString::number( a, fmt, prec ), fieldwidth );
}


/*!
  Just 1-digit arguments.
*/
bool QString::findArg(int& pos, int& len) const
{
    char lowest=0;
    for (uint i=0; i<length(); i++) {
	if ( at(i) == '%' && i+1<length() ) {
	    char dig = at(i+1);
	    if ( dig >= '0' && dig <= '9' ) {
		if ( !lowest || dig < lowest ) {
		    lowest = dig;
		    pos = i;
		    len = 2;
		}
	    }
	}
    }
    return lowest != 0;
}

/*!
  Safely builds a formatted string from a format string and an
  arbitrary list of arguments.  The format string supports all
  the escape sequences of printf() in the standard C library.

  The %s escape sequence expects a utf8() encoded string. 
  The format string \e cformat is expected to be in latin1. If you need a unicode
  format string, use QString::arg() instead. For typesafe
  string building, with full Unicode support, you can use QTextOStream
  like this:

  \code
    QString str;
    QString s = ...;
    int x = ...;
    QTextOStream(&str) << s << " : " << x;
  \endcode

  For \link QObject::tr() translations,\endlink especially if the
  strings contains more than one escape sequence, you should consider
  using the arg() function instead.  This allows the order of the
  replacements to be controlled by the translator, and has Unicode
  support.

  \sa arg()
*/

QString &QString::sprintf( const char* cformat, ... )
{
    va_list ap;
    va_start( ap, cformat );

    if ( !cformat || !*cformat ) {
	// Qt 1.x compat
	*this = QString::fromLatin1( "" );
	return *this;
    }
    QString format = QString::fromLatin1( cformat );

    static QRegExp *escape = 0;
    if (!escape)
	escape = new QRegExp( "%#?0?-? ?\\+?'?[0-9*]*\\.?[0-9*]*h?l?L?q?Z?" );

    QString result;
    uint last = 0;

    int len = 0;
    int pos;
    while ( 1 ) {
	pos = escape->match( cformat, last, &len );
	// Non-escaped text
	if ( pos > (int)last )
	    result += format.mid(last,pos-last);
	if ( pos < 0 ) {
	    // The rest
	    if ( last < format.length() )
		result += format.mid(last);
	    break;
	}
	last = pos + len + 1;

	// Escape
	QString f = format.mid( pos, len );
	uint width, decimals;
	int params = 0;
	int wpos = f.find('*');
	if ( wpos >= 0 ) {
	    params++;
	    width = va_arg( ap, int );
	    if ( f.find('*', wpos + 1) >= 0 ) {
		decimals = va_arg( ap, int );
		params++;
	    } else {
		decimals = 0;
	    }
	} else {
	    decimals = width = 0;
	}
	QString replacement;
	if ( format[pos+len] == 's' ||
	     format[pos+len] == 'S' ||
	     format[pos+len] == 'c' )
	{
	    bool rightjust = ( f.find('-') < 0 );
	    // Yes, %-5s really means left adjust in sprintf

	    if ( wpos < 0 ) {
		QRegExp num( "[0-9]+" );
		QRegExp dot( "\\." );
		int nlen;
		int p = num.match( f.data(), 0, &nlen );
		int q = dot.match( f.data(), 0 );
		if ( q < 0 || (p < q && p >= 0) )
		    width = f.mid( p, nlen ).toInt();
		if ( q >= 0 ) {
		    p = num.match( f.data(), q );
		    // "decimals" is used to specify string truncation
		    if ( p >= 0 )
			decimals = f.mid( p, nlen ).toInt();
		}
	    }

	    if ( format[pos+len] == 's' ) {
#ifndef QT_NO_TEXTCODEC
		QString s = QString::fromUtf8(va_arg(ap, char*));
#else
		QString s = QString::fromLatin1(va_arg(ap, char*));
#endif
		if ( decimals <= 0 )
		    replacement = s;
		else
		    replacement = s.left(decimals);
	    } else {
		int ch = va_arg(ap, int);
		replacement = QChar((ushort)ch);
	    }
	    if ( replacement.length() < width ) {
		replacement = rightjust
		    ? replacement.rightJustify(width)
		    : replacement.leftJustify(width);
	    }
	} else if ( format[pos+len] == '%' ) {
	    replacement = '%';
	} else if ( format[pos+len] == 'n' ) {
	    int* n = va_arg(ap, int*);
	    *n = result.length();
	} else {
	    char in[64], out[330] = "";
	    strncpy(in,f.latin1(),63);
	    char fch = format[pos+len].latin1();
	    in[f.length()] = fch;
	    switch ( fch ) {
	      case 'd': case 'i': case 'o': case 'u': case 'x': case 'X': {
		int value = va_arg(ap, int);
		switch (params) {
		  case 0: ::sprintf( out, in, value ); break;
		  case 1: ::sprintf( out, in, width, value ); break;
		  case 2: ::sprintf( out, in, width, decimals, value ); break;
		}
	      } break;
	      case 'e': case 'E': case 'f': case 'g': case 'G': {
		double value = va_arg(ap, double);
		switch (params) {
		  case 0: ::sprintf( out, in, value ); break;
		  case 1: ::sprintf( out, in, width, value ); break;
		  case 2: ::sprintf( out, in, width, decimals, value ); break;
		}
	      } break;
	      case 'p': {
		void* value = va_arg(ap, void*);
		switch (params) {
		  case 0: ::sprintf( out, in, value ); break;
		  case 1: ::sprintf( out, in, width, value ); break;
		  case 2: ::sprintf( out, in, width, decimals, value ); break;
		}
	      } break;
	    }
	    replacement = QString::fromLatin1(out);
	}
	result += replacement;
    }
    *this = result;

    va_end( ap );
    return *this;
}

/*!
  Fills the string with \a len characters of value \a c.

  If \a len is negative, the current string length is used.
*/

void QString::fill( QChar c, int len )
{
    if ( len < 0 )
	len = length();
    if ( len == 0 ) {
	*this = "";
    } else {
	deref();
	QChar * nd = QT_ALLOC_QCHAR_VEC( len );
	d = new QStringData(nd,len,len);
	while (len--) *nd++ = c;
    }
}


/*!
  \fn QString QString::copy() const

  \obsolete

  Returns a deep copy of this string.

  Doing this is redundant in Qt 2.x, since QString is implicitly
  shared, and so will automatically be deeply copied as necessary.
*/

/*!
  Finds the first occurrence of the character \a c, starting at
  position \a index. If \a index is -1, the search starts at the
  last character; if -2, at the next to last character; etc.

  The search is case sensitive if \a cs is TRUE, or case insensitive
  if \a cs is FALSE.

  Returns the position of \a c, or -1 if \a c could not be found.
*/

int QString::find( QChar c, int index, bool cs ) const
{
    if ( index < 0 )
	index += length();
    if ( (uint)index >= length() )		// index outside string
	return -1;
    register const QChar *uc;
    uc = unicode()+index;
    int n = length()-index;
    if ( cs ) {
	while ( n-- && *uc != c )
	    uc++;
    } else {
	c = c.lower();
	while ( n-- && uc->lower() != c )
	    uc++;
    }
    if ( uint(uc - unicode()) >= length() )
	return -1;
    return (int)(uc - unicode());
}

/*!
  Finds the first occurrence of the string \a str, starting at position
  \a index. If \a index is -1, the search starts at the last character;
  if -2, at the next to last character; etc.

  The search is case sensitive if \a cs is TRUE, or case insensitive if
  \a cs is FALSE.

  Returns the position of \a str, or -1 if \a str could not be found.
*/

int QString::find( const QString& str, int index, bool cs ) const
{
    /*
      We use some weird hashing for efficiency's sake.  Instead of
      comparing strings, we compare the hash value of str with that of
      a part of this QString.  Only if that matches, we call ucstrncmp
      or ucstrnicmp.

      The hash value of a string is the sum of the cells of its
      QChars.
    */
    if ( index < 0 )
	index += length();
    int lstr = str.length();
    int lthis = length() - index;
    if ( (uint)lthis > length() )
	return -1;
    int delta = lthis - lstr;
    if ( delta < 0 )
	return -1;

    const QChar *uthis = unicode() + index;
    const QChar *ustr = str.unicode();
    uint hthis = 0;
    uint hstr = 0;
    int i;
    if ( cs ) {
	for ( i = 0; i < lstr; i++ ) {
	    hthis += uthis[i].cell();
	    hstr += ustr[i].cell();
	}
	i = 0;
	while ( TRUE ) {
	    if ( hthis == hstr && ucstrncmp(uthis + i, ustr, lstr) == 0 )
		return index + i;
	    if ( i == delta )
		return -1;
	    hthis += uthis[i + lstr].cell();
	    hthis -= uthis[i].cell();
	    i++;
	}
    } else {
	for ( i = 0; i < lstr; i++ ) {
	    hthis += uthis[i].lower().cell();
	    hstr += ustr[i].lower().cell();
	}
	i = 0;
	while ( TRUE ) {
	    if ( hthis == hstr && ucstrnicmp(uthis + i, ustr, lstr) == 0 )
		return index + i;
	    if ( i == delta )
		return -1;
	    hthis += uthis[i + lstr].lower().cell();
	    hthis -= uthis[i].lower().cell();
	    i++;
	}
    }
#if defined(Q_SPURIOUS_NON_VOID_WARNING)
    return -1;
#endif
}

/*!
  \fn int QString::findRev( const char* str, int index ) const

  Equivalent to findRev(QString(str), index).
*/

/*!
  \fn int QString::find( const char* str, int index ) const

  Equivalent to find(QString(str), index).
*/

/*!
  Finds the first occurrence of the character \a c, starting at
  position \a index and searching backwards. If \a index is -1,
  the search starts at the last character; if -2, at the next to
  last character; etc.

  The search is case sensitive if \a cs is TRUE, or case insensitive if \a
  cs is FALSE.

  Returns the position of \a c, or -1 if \a c could not be found.
*/

int QString::findRev( QChar c, int index, bool cs ) const
{
    QString t( c );
    return findRev( t, index, cs );
}

/*!
  Finds the first occurrence of the string \a str, starting at
  position \a index and searching backwards. If \a index is -1,
  the search starts at the last character; -2, at the next to last
  character; etc.

  The search is case sensitive if \a cs is TRUE, or case insensitive if \e
  cs is FALSE.

  Returns the position of \a str, or -1 if \a str could not be found.
*/

int QString::findRev( const QString& str, int index, bool cs ) const
{
    /*
      See QString::find() for explanations.
    */
    int lthis = length();
    if ( index < 0 )
	index += lthis;

    int lstr = str.length();
    int delta = lthis - lstr;
    if ( index < 0 || index > lthis || delta < 0 )
	return -1;
    if ( index > delta )
	index = delta;

    const QChar *uthis = unicode();
    const QChar *ustr = str.unicode();
    uint hthis = 0;
    uint hstr = 0;
    int i;
    if ( cs ) {
	for ( i = 0; i < lstr; i++ ) {
	    hthis += uthis[index + i].cell();
	    hstr += ustr[i].cell();
	}
	i = index;
	while ( TRUE ) {
	    if ( hthis == hstr && ucstrncmp(uthis + i, ustr, lstr) == 0 )
		return i;
	    if ( i == 0 )
		return -1;
	    i--;
	    hthis -= uthis[i + lstr].cell();
	    hthis += uthis[i].cell();
	}
    } else {
	for ( i = 0; i < lstr; i++ ) {
	    hthis += uthis[index + i].lower().cell();
	    hstr += ustr[i].lower().cell();
	}
	i = index;
	while ( TRUE ) {
	    if ( hthis == hstr && ucstrnicmp(uthis + i, ustr, lstr) == 0 )
		return i;
	    if ( i == 0 )
		return -1;
	    i--;
	    hthis -= uthis[i + lstr].lower().cell();
	    hthis += uthis[i].lower().cell();
	}
    }
#if defined(Q_SPURIOUS_NON_VOID_WARNING)
    return -1;
#endif
}


/*!
  Returns the number of times the character \a c occurs in the string.

  The match is case sensitive if \a cs is TRUE, or case insensitive if \a cs
  is FALSE.
*/

int QString::contains( QChar c, bool cs ) const
{
    int count = 0;
    const QChar *uc = unicode();
    if ( !uc )
	return 0;
    int n = length();
    if ( cs ) {					// case sensitive
	while ( n-- )
	    if ( *uc++ == c )
		count++;
    } else {					// case insensitive
	c = c.lower();
	while ( n-- ) {
	    if ( uc->lower() == c )
		count++;
	    uc++;
	}
    }
    return count;
}

/*!
  \overload
*/
int QString::contains( const char* str, bool cs ) const
{
    return contains(QString(str),cs);
}

/*!
  \overload int QString::contains (char c, bool cs) const
*/

/*!
  \overload int QString::find (char c, int index, bool cs) const

*/

/*!
  \overload int QString::findRev (char c, int index, bool cs) const

*/

/*!
  Returns the number of times \a str occurs in the string.

  The match is case sensitive if \a cs is TRUE, or case insensitive if \e
  cs is FALSE.

  This function counts overlapping substrings, for example, "banana"
  contains two occurrences of "ana".

  \sa findRev()
*/

int QString::contains( const QString &str, bool cs ) const
{
    int count = 0;
    const QChar *uc = unicode();
    if ( !uc )
	return 0;
    int len = str.length();
    int n = length();
    while ( n-- ) {				// counts overlapping strings
	// ### Doesn't account for length of this - searches over "end"
	if ( cs ) {
	    if ( ucstrncmp( uc, str.unicode(), len ) == 0 )
		count++;
	} else {
	    if ( ucstrnicmp(uc, str.unicode(), len) == 0 )
		count++;
	}
	uc++;
    }
    return count;
}

/*!
  Returns a substring that contains the \a len leftmost characters
  of the string.

  The whole string is returned if \a len exceeds the length of the
  string.


  Example:
  \code
    QString s = "Pineapple";
    QString t = s.left( 4 );	// t == "Pine"
  \endcode

  \sa right(), mid(), isEmpty()
*/

QString QString::left( uint len ) const
{
    if ( isEmpty() ) {
	return QString();
    } else if ( len == 0 ) {			// ## just for 1.x compat:
	return QString::fromLatin1("");
    } else if ( len > length() ) {
	return *this;
    } else {
	QString s( len, TRUE );
	memcpy( s.d->unicode, d->unicode, len*sizeof(QChar) );
	s.d->len = len;
	return s;
    }
}

/*!
  Returns a substring that contains the \a len rightmost characters
  of the string.

  The whole string is returned if \a len exceeds the length of the
  string.

  Example:
  \code
    QString s = "Pineapple";
    QString t = s.right( 5 );	// t == "apple"
  \endcode

  \sa left(), mid(), isEmpty()
*/

QString QString::right( uint len ) const
{
    if ( isEmpty() ) {
	return QString();
    } else if ( len == 0 ) {			// ## just for 1.x compat:
	return QString::fromLatin1("");
    } else {
	uint l = length();
	if ( len > l )
	    len = l;
	QString s( len, TRUE );
	memcpy( s.d->unicode, d->unicode+(l-len), len*sizeof(QChar) );
	s.d->len = len;
	return s;
    }
}

/*!
  Returns a substring that contains the \a len characters of this
  string, starting at position \a index.

  Returns a null string if the string is empty or \a index is out
  of range.  Returns the whole string from \a index if \a index+len exceeds
  the length of the string.

  Example:
  \code
    QString s = "Five pineapples";
    QString t = s.mid( 5, 4 );			// t == "pine"
  \endcode

  \sa left(), right()
*/

QString QString::mid( uint index, uint len ) const
{
    uint slen = length();
    if ( isEmpty() || index >= slen ) {
	return QString();
    } else if ( len == 0 ) {			// ## just for 1.x compat:
	return QString::fromLatin1("");
    } else {
	if ( len > slen-index )
	    len = slen - index;
	if ( index == 0 && len == length() )
	    return *this;
	register const QChar *p = unicode()+index;
	QString s( len, TRUE );
	memcpy( s.d->unicode, p, len*sizeof(QChar) );
	s.d->len = len;
	return s;
    }
}

/*!
  Returns a string of length \a width that contains this
  string and padded by the \a fill character.

  If the length of the string exceeds \a width and \a truncate is FALSE,
  then the returned string is a copy of the string.
  If the length of the string exceeds \a width and \a truncate is TRUE,
  then the returned string is a left(\a width).

  Example:
  \code
    QString s("apple");
    QString t = s.leftJustify(8, '.');		// t == "apple..."
  \endcode

  \sa rightJustify()
*/

QString QString::leftJustify( uint width, QChar fill, bool truncate ) const
{
    QString result;
    int len = length();
    int padlen = width - len;
    if ( padlen > 0 ) {
	result.setLength(len+padlen);
	if ( len )
	    memcpy( result.d->unicode, unicode(), sizeof(QChar)*len );
	QChar* uc = result.d->unicode + len;
	while (padlen--)
	    *uc++ = fill;
    } else {
	if ( truncate )
	    result = left( width );
	else
	    result = *this;
    }
    return result;
}

/*!
  Returns a string of length \a width that contains pad
  characters followed by the string.

  If the length of the string exceeds \a width and \a truncate is FALSE,
  then the returned string is a copy of the string.
  If the length of the string exceeds \a width and \a truncate is TRUE,
  then the returned string is a left(\a width).

  Example:
  \code
    QString s("pie");
    QString t = s.rightJustify(8, '.');		// t == ".....pie"
  \endcode

  \sa leftJustify()
*/

QString QString::rightJustify( uint width, QChar fill, bool truncate ) const
{
    QString result;
    int len = length();
    int padlen = width - len;
    if ( padlen > 0 ) {
	result.setLength( len+padlen );
	QChar* uc = result.d->unicode;
	while (padlen--)
	    *uc++ = fill;
	if ( len )
	    memcpy( uc, unicode(), sizeof(QChar)*len );
    } else {
	if ( truncate )
	    result = left( width );
	else
	    result = *this;
    }
    return result;
}

/*!
  Returns a new string that is the string converted to lower case.

  Example:
  \code
    QString s("TeX");
    QString t = s.lower();	// t == "tex"
  \endcode

  \sa upper()
*/

QString QString::lower() const
{
    QString s(*this);
    int l=length();
    if ( l ) {
	s.real_detach(); // could do this only when we find a change
	register QChar *p=s.d->unicode;
	if ( p ) {
	    while ( l-- ) {
		*p = p->lower();
		p++;
	    }
	}
    }
    return s;
}

/*!
  Returns a new string that is the string converted to upper case.

  Example:
  \code
    QString s("TeX");
    QString t = s.upper();			// t == "TEX"
  \endcode

  \sa lower()
*/

QString QString::upper() const
{
    QString s(*this);
    int l=length();
    if ( l ) {
	s.real_detach(); // could do this only when we find a change
	register QChar *p=s.d->unicode;
	if ( p ) {
	    while ( l-- ) {
		*p = p->upper();
		p++;
	    }
	}
    }
    return s;
}


/*!
  Returns a new string that has white space removed from the start and the end.

  White space means any character for which QChar::isSpace() returns
  TRUE. This includes ASCII characters 9 (TAB), 10 (LF), 11 (VT), 12
  (FF), 13 (CR), and 32 (Space).

  Example:
  \code
    QString s = " space ";
    QString t = s.stripWhiteSpace();		// t == "space"
  \endcode

  \sa simplifyWhiteSpace()
*/

QString QString::stripWhiteSpace() const
{
    if ( isEmpty() )				// nothing to do
	return *this;
    if ( !at(0).isSpace() && !at(length()-1).isSpace() )
	return *this;

    register const QChar *s = unicode();
    QString result = fromLatin1("");

    int start = 0;
    int end = length() - 1;
    while ( start<=end && s[start].isSpace() )	// skip white space from start
	start++;
    if ( start > end ) {			// only white space
	return result;
    }
    while ( end && s[end].isSpace() )		// skip white space from end
	end--;
    int l = end - start + 1;
    result.setLength( l );
    if ( l )
	memcpy( result.d->unicode, &s[start], sizeof(QChar)*l );
    return result;
}


/*!
  Returns a new string that has white space removed from the start and the end,
  plus any sequence of internal white space replaced with a single space
  (ASCII 32).

  White space means any character for which QChar::isSpace() returns
  TRUE. This includes ASCII characters 9 (TAB), 10 (LF), 11 (VT), 12
  (FF), 13 (CR), and 32 (Space).

  \code
    QString s = "  lots\t of\nwhite    space ";
    QString t = s.simplifyWhiteSpace();		// t == "lots of white space"
  \endcode

  \sa stripWhiteSpace()
*/

QString QString::simplifyWhiteSpace() const
{
    if ( isEmpty() )				// nothing to do
	return *this;
    QString result;
    result.setLength( length() );
    const QChar *from = unicode();
    const QChar *fromend = from+length();
    int outc=0;
    QChar *to	= result.d->unicode;
    while ( TRUE ) {
	while ( from!=fromend && from->isSpace() )
	    from++;
	while ( from!=fromend && !from->isSpace() )
	    to[outc++] = *from++;
	if ( from!=fromend )
	    to[outc++] = ' ';
	else
	    break;
    }
    if ( outc > 0 && to[outc-1] == ' ' )
	outc--;
    result.truncate( outc );
    return result;
}


/*!
  Insert \a s into the string before position \a index.

  If \a index is beyond the end of the string, the string is extended with
  spaces (ASCII 32) to length \a index and \a s is then appended.

  \code
    QString s = "I like fish";
    s.insert( 2, "don't ");	// s == "I don't like fish"
    s = "x";
    s.insert( 3, "yz" );	// s == "x  yz"
  \endcode
*/

QString &QString::insert( uint index, const QString &s )
{
    // the sub function takes care of &s == this case.
    return insert( index, s.unicode(), s.length() );
}

/*!
  Insert \a len units of QChar data from \a s into the string before
  position \a index.
*/

QString &QString::insert( uint index, const QChar* s, uint len )
{
    if ( len == 0 )
	return *this;
    uint olen = length();
    int nlen = olen + len;

    int df = s - d->unicode; // ### pointer subtraction, cast down to int
    if ( df >= 0 && (uint)df < d->maxl ) {
	// Part of me - take a copy.
	QChar *tmp = QT_ALLOC_QCHAR_VEC( len );
	memcpy(tmp,s,len*sizeof(QChar));
	insert(index,tmp,len);
	QT_DELETE_QCHAR_VEC( tmp );
	return *this;
    }

    if ( index >= olen ) {			// insert after end of string
	setLength( len+index );
	int n = index-olen;
	QChar* uc = d->unicode+olen;
	while (n--)
	    *uc++ = ' ';
	memcpy( d->unicode+index, s, sizeof(QChar)*len );
    } else {					// normal insert
	setLength( nlen );
	memmove( d->unicode+index+len, unicode()+index,
		 sizeof(QChar)*(olen-index) );
	memcpy( d->unicode+index, s, sizeof(QChar)*len );
    }
    return *this;
}

/*!
  Insert \a c into the string at (before) position \a index and returns
  a reference to the string.

  If \a index is beyond the end of the string, the string is extended with
  spaces (ASCII 32) to length \a index and \a c is then appended.

  Example:
  \code
    QString s = "Ys";
    s.insert( 1, 'e' );		// s == "Yes"
    s.insert( 3, '!');		// s == "Yes!"
  \endcode

  \sa remove(), replace()
*/

QString &QString::insert( uint index, QChar c )	// insert char
{
    QString s( c );
    return insert( index, s );
}

/*!
  \overload QString& QString::insert( uint index, char c )
*/

/*!
  \fn QString &QString::prepend( const QString &s )

  Prepend \a s to the string. Equivalent to insert(0,s).

  \sa insert()
*/

/*!
  \fn QString& QString::prepend( char ch )
  Prepends \a ch to the string and returns a reference to the result.

  \sa insert()
 */

/*!
  \fn QString& QString::prepend( QChar ch )
  Prepends \a ch to the string and returns a reference to the result.

  \sa insert()
 */


/*!
  Removes \a len characters starting at position \a index from the
  string and returns a reference to the string.

  If \a index is too big, nothing happens.  If \a index is valid, but
  \a len is too large, the rest of the string is removed.

  \code
    QString s = "Montreal";
    s.remove( 1, 4 );
    // s == "Meal"
  \endcode

  \sa insert(), replace()
*/

QString &QString::remove( uint index, uint len )
{
    uint olen = length();
    if ( index + len >= olen ) {		// range problems
	if ( index < olen ) {			// index ok
	    setLength( index );
	}
    } else if ( len != 0 ) {
	real_detach();
	memmove( d->unicode+index, d->unicode+index+len,
		 sizeof(QChar)*(olen-index-len) );
	setLength( olen-len );
    }
    return *this;
}

/*!
  Replaces \a len characters starting at position \a index from the
  string with \a s, and returns a reference to the string.

  If \a index is too big, nothing is deleted and \a s is inserted at the
  end of the string.  If \a index is valid, but \a len is too large, \e
  str replaces the rest of the string.

  \code
    QString s = "Say yes!";
    s.replace( 4, 3, "NO" );			// s == "Say NO!"
  \endcode

  \sa insert(), remove()
*/

QString &QString::replace( uint index, uint len, const QString &s )
{
    return replace( index, len, s.unicode(), s.length() );
}


/*!
  Replaces \a len characters starting at position \a index by
  \a slen units ot QChar data from \a s, and returns a reference to the string.

  \sa insert(), remove()
*/

QString &QString::replace( uint index, uint len, const QChar* s, uint slen )
{
    if ( len == slen && index + len <= length() ) {
	// Optimized common case: replace without size change
	real_detach();
	memcpy( d->unicode+index, s, len*sizeof(QChar) );
    } else {
	int df = s - d->unicode; // ### pointer subtraction, cast down to int
	if ( df >= 0 && (uint)df < d->maxl ) {
	    // Part of me - take a copy.
	    QChar *tmp = QT_ALLOC_QCHAR_VEC( slen );
	    memcpy(tmp,s,slen*sizeof(QChar));
	    replace(index,len,tmp,slen);
	    QT_DELETE_QCHAR_VEC( tmp );
	    return *this;
	}

	remove( index, len );
	insert( index, s, slen );
    }
    return *this;
}



/*!
  Finds the first occurrence of the regular expression \a rx, starting at
  position \a index. If \a index is -1, the search starts at the last
  character; if -2, at the next to last character; etc.

  Returns the position of the next match, or -1 if \a rx was not found.

  \sa findRev() replace() contains()
*/

int QString::find( const QRegExp &rx, int index ) const
{
    if ( index < 0 )
	index += length();
    return rx.match( data(), index );
}

/*!
  Finds the first occurrence of the regular expression \a rx, starting at
  position \a index and searching backwards. If \a index is -1, the
  search starts at the last character; if -2, at the next to last
  character; etc.

  Returns the position of the next match (backwards), or -1 if \a rx was not
  found.

  \sa find()
*/

int QString::findRev( const QRegExp &rx, int index ) const
{
    if ( index < 0 )				// neg index ==> start from end
	index += length();
    if ( (uint)index > length() )		// bad index
	return -1;
    while( index >= 0 ) {
	if ( rx.match( data(), index ) == index )
	    return index;
	index--;
    }
    return -1;
}

/*!
  Counts the number of overlapping occurrences of \a rx in the string.

  Example:
  \code
    QString s = "banana and panama";
    QRegExp r = QRegExp("a[nm]a", TRUE, FALSE);
    s.contains( r );				// 4 matches
  \endcode

  \sa find() findRev()
*/

int QString::contains( const QRegExp &rx ) const
{
    if ( isEmpty() )
	return rx.match( data() ) < 0 ? 0 : 1;
    int count = 0;
    int index = -1;
    int len = length();
    while ( index < len-1 ) {			// count overlapping matches
	index = rx.match( data(), index+1 );
	if ( index < 0 )
	    break;
	count++;
    }
    return count;
}


/*!
  Replaces every occurrence of \a rx in the string with \a str.
  Returns a reference to the string.

  Examples:
  \code
    QString s = "banana";
    s.replace( QRegExp("a.*a"), "" );		// becomes "b"

    QString s = "banana";
    s.replace( QRegExp("^[bn]a"), " " );	// becomes " nana"

    QString s = "banana";
    s.replace( QRegExp("^[bn]a"), "" );		// NOTE! becomes ""
  \endcode

  \sa find() findRev()
*/

QString &QString::replace( const QRegExp &rx, const QString &str )
{
    if ( isEmpty() )
	return *this;
    int index = 0;
    int slen  = str.length();
    int len;
    while ( index < (int)length() ) {
	index = rx.match( data(), index, &len, FALSE );
	if ( index >= 0 ) {
	    replace( index, len, str );
	    index += slen;
	    if ( !len )
		break;	// Avoid infinite loop on 0-length matches, e.g. [a-z]*
	}
	else
	    break;
    }
    return *this;
}

static bool
ok_in_base( QChar c, int base )
{
    if ( base <= 10 )
	return c.isDigit() && c.digitValue() < base;
    else
	return c.isDigit() || (c >= 'a' && c < char('a'+base-10))
			   || (c >= 'A' && c < char('A'+base-10));
}

/*!
  Returns the string converted to a <code>long</code> value.

  If \a ok is non-null, \a *ok is set to TRUE if there are no
  conceivable errors, and FALSE if the string is not a number at all, or if
  it has trailing garbage.
*/

long QString::toLong( bool *ok, int base ) const
{
    const QChar *p = unicode();
    long val=0;
    int l = length();
    const long max_mult = INT_MAX / base;
    bool is_ok = FALSE;
    int neg = 0;
    if ( !p )
	goto bye;
    while ( l && p->isSpace() )			// skip leading space
	l--,p++;
    if ( l && *p == '-' ) {
	l--;
	p++;
	neg = 1;
    } else if ( *p == '+' ) {
	l--;
	p++;
    }

    // NOTE: toULong() code is similar
    if ( !l || !ok_in_base(*p,base) )
	goto bye;
    while ( l && ok_in_base(*p,base) ) {
	l--;
	int dv;
	if ( p->isDigit() ) {
	    dv = p->digitValue();
	} else {
	    if ( *p >= 'a' && *p <= 'z' )
		dv = *p - 'a' + 10;
	    else
		dv = *p - 'A' + 10;
	}
	if ( val > max_mult || (val == max_mult && dv > (INT_MAX%base)+neg) )
	    goto bye;
	val = base*val + dv;
	p++;
    }
    if ( neg )
	val = -val;
    while ( l && p->isSpace() )			// skip trailing space
	l--,p++;
    if ( !l )
	is_ok = TRUE;
bye:
    if ( ok )
	*ok = is_ok;
    return is_ok ? val : 0;
}

/*!
  Returns the string converted to an <code>unsigned long</code>
  value.

  If \a ok is non-null, \a *ok is set to TRUE if there are no
  conceivable errors, and FALSE if the string is not a number at all,
  or if it has trailing garbage.
*/

ulong QString::toULong( bool *ok, int base ) const
{
    const QChar *p = unicode();
    ulong val=0;
    int l = length();
    const ulong max_mult = 429496729;		// UINT_MAX/10, rounded down
    bool is_ok = FALSE;
    if ( !p )
	goto bye;
    while ( l && p->isSpace() )			// skip leading space
	l--,p++;
    if ( *p == '+' )
	l--,p++;

    // NOTE: toLong() code is similar
    if ( !l || !ok_in_base(*p,base) )
	goto bye;
    while ( l && ok_in_base(*p,base) ) {
	l--;
	uint dv;
	if ( p->isDigit() ) {
	    dv = p->digitValue();
	} else {
	    if ( *p >= 'a' && *p <= 'z' )
		dv = *p - 'a' + 10;
	    else
		dv = *p - 'A' + 10;
	}
	if ( val > max_mult || (val == max_mult && dv > (UINT_MAX%base)) )
	    goto bye;
	val = base*val + dv;
	p++;
    }

    while ( l && p->isSpace() )			// skip trailing space
	l--,p++;
    if ( !l )
	is_ok = TRUE;
bye:
    if ( ok )
	*ok = is_ok;
    return is_ok ? val : 0;
}

/*!
  Returns the string converted to a <code>short</code> value.

  If \a ok is non-null, \a *ok is set to TRUE if there are no
  conceivable errors, and FALSE if the string is not a number at all, or if
  it has trailing garbage.
*/

short QString::toShort( bool *ok, int base ) const
{
    long v = toLong( ok, base );
    if ( ok && *ok && (v < -32768 || v > 32767) ) {
	*ok = FALSE;
	v = 0;
    }
    return (short)v;
}

/*!
  Returns the string converted to an <code>unsigned short</code> value.

  If \a ok is non-null, \a *ok is set to TRUE if there are no
  conceivable errors, and FALSE if the string is not a number at all, or if
  it has trailing garbage.
*/

ushort QString::toUShort( bool *ok, int base ) const
{
    ulong v = toULong( ok, base );
    if ( ok && *ok && (v > 65535) ) {
	*ok = FALSE;
	v = 0;
    }
    return (ushort)v;
}


/*!
  Returns the string converted to a <code>int</code> value.

  \code
  QString str("FF");
  bool ok;
  int hex = str.toInt( &ok, 16 ); // will return 255, and ok set to TRUE
  int dec = str.toInt( &ok, 10 ); // will return 0, and ok set to FALSE
  \endcode

  If \a ok is non-null, \a *ok is set to TRUE if there are no
  conceivable errors, and FALSE if the string is not a number at all,
  or if it has trailing garbage.
*/

int QString::toInt( bool *ok, int base ) const
{
    return (int)toLong( ok, base );
}

/*!
  Returns the string converted to an <code>unsigned int</code> value.

  If \a ok is non-null, \a *ok is set to TRUE if there are no
  conceivable errors, and FALSE if the string is not a number at all,
  or if it has trailing garbage.
*/

uint QString::toUInt( bool *ok, int base ) const
{
    return (uint)toULong( ok, base );
}

/*!
  Returns the string converted to a <code>double</code> value.

  If \a ok is non-null, \a *ok is set to TRUE if there are no conceivable
  errors, and FALSE if the string is not a number at all, or if it has
  trailing garbage.
*/

double QString::toDouble( bool *ok ) const
{
    char *end;

    QCString a = latin1();
    // Just latin1() is not sufficient, since U0131 would look like '1'.
    for (uint i=0; i<d->len; i++)
	if ( d->unicode[i].row() )
	    a[(int)i]='z';

    double val = strtod( a.data() ? a.data() : "", &end );
    if ( ok )
	*ok = ( a && *a && ( end == 0 || *end == '\0' ) );
    return val;
}

/*!
  Returns the string converted to a <code>float</code> value.

  If \a ok is non-null, \a *ok is set to TRUE if there are no
  conceivable errors, and FALSE if the string is not a number at all,
  or if it has trailing garbage.
*/

float QString::toFloat( bool *ok ) const
{
    return (float)toDouble( ok );
}


/*!
  Sets the string to the printed value of \a n and returns a
  reference to the string.

  The value is converted to \a base notation (default is decimal).
  The base must be a value from 2 to 36.
*/

QString &QString::setNum( long n, int base )
{
#if defined(CHECK_RANGE)
    if ( base < 2 || base > 36 ) {
	qWarning( "QString::setNum: Invalid base %d", base );
	base = 10;
    }
#endif
    char   charbuf[65*sizeof(QChar)];
    QChar *buf = (QChar*)charbuf;
    QChar *p = &buf[64];
    int  len = 0;
    bool neg;
    if ( n < 0 ) {
	neg = TRUE;
	if ( n == INT_MIN ) {
	    // Cannot always negate this special case
	    QString s1, s2;
	    s1.setNum(n/base);
	    s2.setNum((-(n+base))%base);
	    *this = s1 + s2;
	    return *this;
	}
	n = -n;
    } else {
	neg = FALSE;
    }
    do {
	*--p = "0123456789abcdefghijklmnopqrstuvwxyz"[((int)(n%base))];
	n /= base;
	len++;
    } while ( n );
    if ( neg ) {
	*--p = '-';
	len++;
    }
    return setUnicode( p, len );
}

/*!
  Sets the string to the printed unsigned value of \a n and
  returns a reference to the string.

  The value is converted to \a base notation (default is decimal).
  The base must be a value from 2 to 36.
*/

QString &QString::setNum( ulong n, int base )
{
#if defined(CHECK_RANGE)
    if ( base < 2 || base > 36 ) {
	qWarning( "QString::setNum: Invalid base %d", base );
	base = 10;
    }
#endif
    char   charbuf[65*sizeof(QChar)];
    QChar *buf = (QChar*)charbuf;
    QChar *p = &buf[64];
    int len = 0;
    do {
	*--p = "0123456789abcdefghijklmnopqrstuvwxyz"[((int)(n%base))];
	n /= base;
	len++;
    } while ( n );
    return setUnicode(p,len);
}

/*!
  \fn QString &QString::setNum( int n, int base )
  Sets the string to the printed value of \a n and returns a reference
  to the string.
*/

/*!
  \fn QString &QString::setNum( uint n, int base )
  Sets the string to the printed unsigned value of \a n and returns a
  reference to the string.
*/

/*!
  \fn QString &QString::setNum( short n, int base )
  Sets the string to the printed value of \a n and returns a reference
  to the string.
*/

/*!
  \fn QString &QString::setNum( ushort n, int base )
  Sets the string to the printed unsigned value of \a n and returns a
  reference to the string.
*/

/*!  Sets the string to the printed value of \a n, formatted in the \a f
  format with \a prec precision, and returns a reference to the
  string.

  \a f can be 'f', 'F', 'e', 'E', 'g' or 'G', all of which have the
  same meaning as for sprintf().
*/

QString &QString::setNum( double n, char f, int prec )
{
#if defined(CHECK_RANGE)
    if ( !(f=='f' || f=='F' || f=='e' || f=='E' || f=='g' || f=='G') ) {
	qWarning( "QString::setNum: Invalid format char '%c'", f );
	f = 'f';
    }
#endif
    char format[20];
    char buf[120];				// enough for 99 precision?
    char *fs = format;				// generate format string
    *fs++ = '%';				//   "%.<prec>l<f>"
    if ( prec >= 0 ) {
	if ( prec > 99 )			// buf big enough for precision?
	    prec = 99;
	*fs++ = '.';
	if ( prec >= 10 ) {
	    *fs++ = prec / 10 + '0';
	    *fs++ = prec % 10 + '0';
	} else {
	    *fs++ = prec + '0';
	}
    }
    *fs++ = 'l';
    *fs++ = f;
    *fs = '\0';
    ::sprintf( buf, format, n );
    return setLatin1(buf);
}

/*!
  \overload QString &QString::setNum( float n, char f, int prec )
*/


/*!
  A convenience factory function that returns a string representation
  of the number \a n.

  \sa setNum()
 */
QString QString::number( long n, int base )
{
    QString s;
    s.setNum( n, base );
    return s;
}

/*!
  A convenience factory function that returns a string representation
  of the number \a n.

  \sa setNum()
 */
QString QString::number( ulong n, int base )
{
    QString s;
    s.setNum( n, base );
    return s;
}

/*!
  A convenience factory function that returns a string representation
  of the number \a n.

  \sa setNum()
 */
QString QString::number( int n, int base )
{
    QString s;
    s.setNum( n, base );
    return s;
}

/*!
  A convenience factory function that returns a string representation
  of the number \a n.

  \sa setNum()
 */
QString QString::number( uint n, int base )
{
    QString s;
    s.setNum( n, base );
    return s;
}

/*!
  This static function returns the printed value of \a n, formatted in the
  \a f format with \a prec precision.

  \a f can be 'f', 'F', 'e', 'E', 'g' or 'G', all of which have the
  same meaning as for sprintf().

  \sa setNum()
 */
QString QString::number( double n, char f, int prec )
{
    QString s;
    s.setNum( n, f, prec );
    return s;
}


/*! \obsolete

  Sets the character at position \a index to \a c and expands the
  string if necessary, filling with spaces.

  This method is redundant in Qt 2.x, because operator[] will expand
  the string as necessary.
*/

void QString::setExpand( uint index, QChar c )
{
    int spaces = index - d->len;
    at(index) = c;
    while (spaces-->0)
	d->unicode[--index]=' ';
}


/*!
  \fn const char* QString::data() const

  \obsolete

  Returns a pointer to a 0-terminated classic C string.

  In Qt 1.x, this returned a char* allowing direct manipulation of the
  string as a sequence of bytes.  In Qt 2.x where QString is a Unicode
  string, char* conversion constructs a temporary string, and hence
  direct character operations are meaningless.
*/

/*!
  \fn bool QString::operator!() const
  Returns TRUE if it is a null string, otherwise FALSE.  Thus
  you can write:

\code
  QString name = getName();
  if ( !name )
    name = "Rodney";
\endcode

  Note that if you say:

\code
  QString name = getName();
  if ( name )
    doSomethingWith(name);
\endcode

  Then this will call <tt>operator const char*()</tt>, which will do what
  you want, but rather inefficiently - you may wish to define the macro
  QT_NO_ASCII_CAST when writing code which you wish to strictly remain
  Unicode-clean.

  When you want the above semantics, use <tt>!isNull()</tt>
  or even <tt>!!</tt>:

\code
  QString name = getName();
  if ( !!name )
    doSomethingWith(name);
\endcode
*/


/*!
  \fn QString& QString::append( const QString& str )
  Appends \a str to the string and returns a reference to the result.
  Equivalent to operator+=().
 */

/*!
  \fn QString& QString::append( char ch )
  Appends \a ch to the string and returns a reference to the result.
  Equivalent to operator+=().
 */

/*!
  \fn QString& QString::append( QChar ch )
  Appends \a ch to the string and returns a reference to the result.
  Equivalent to operator+=().
 */

/*!
  Appends \a str to the string and returns a reference to the string.
*/
QString& QString::operator+=( const QString &str )
{
    uint len1 = length();
    uint len2 = str.length();
    if ( len2 ) {
	setLength(len1+len2);
	memcpy( d->unicode+len1, str.unicode(), sizeof(QChar)*len2 );
    } else if ( isNull() && !str.isNull() ) {	// ## just for 1.x compat:
	*this = fromLatin1("");
    }
    return *this;
}

/*!
  Appends \a c to the string and returns a reference to the string.
*/

QString &QString::operator+=( QChar c )
{
    setLength(length()+1);
    d->unicode[length()-1] = c;
    return *this;
}

/*!
  Appends \a c to the string and returns a reference to the string.
*/

QString &QString::operator+=( char c )
{
    setLength(length()+1);
    d->unicode[length()-1] = c;
    return *this;
}



/*! \fn char QChar::latin1() const

  Returns a latin-1 copy of this character, if this character is in
  the latin-1 character set.  If not, this function returns 0.
*/


/*!
  Returns a Latin-1 representation of the string. Note that the returned
  value is undefined if the string contains non-Latin-1 characters.  If you
  want to convert strings into formats other than Unicode, see the
  QTextCodec classes.

  This function is mainly useful for boot-strapping legacy code to
  use Unicode.

  The result remains valid so long as one unmodified
  copy of the source string exists.

  \sa utf8(), local8Bit()
*/
const char* QString::latin1() const
{
    if ( d->ascii ) {
	if ( d->dirtyascii )
	    delete [] d->ascii;
	else
	    return d->ascii;
    }
    Q2HELPER(stat_get_ascii++)
    Q2HELPER(stat_get_ascii_size+=d->len)
    static QTextCodec* codec = QTextCodec::codecForMib(106);
    if (codec) // we use utf8 coding also for latin1 if possible
    {
      QCString utf8str(codec->fromUnicode(*this));
      d->ascii = new char[utf8str.length()+1];
      if (utf8str.isEmpty())
      {
        d->ascii[0]='\0'; // make empty string
      }
      else // copy string
      {
        qstrcpy(d->ascii,utf8str.data());
      }
    }
    else // fall back to latin1
    {
      d->ascii = unicodeToAscii( d->unicode, d->len );
    }
    QCString utf8str(utf8());
    d->dirtyascii = 0;
    return d->ascii;
}

/*! \obsolete

  This functions simply calls latin1() and returns the result.
*/
const char* QString::ascii() const
{
    return latin1();
}

#ifndef QT_NO_TEXTCODEC
/*!
  Returns the string encoded in UTF8 format.

  See QTextCodec for more diverse coding/decoding of Unicode strings.

  \sa QString::fromUtf8(), local8Bit(), latin1()
*/
QCString QString::utf8() const
{
    static QTextCodec* codec = QTextCodec::codecForMib(106);
    return codec
	    ? codec->fromUnicode(*this)
	    : QCString(latin1());
}

/*!
  Returns the unicode string decoded from the
  first \a len bytes of \a utf8.  If \a len is -1 (the default), the
  length of \a utf8 is used.  If trailing partial characters are in
  \a utf8, they are ignored.

  See QTextCodec for more diverse coding/decoding of Unicode strings.
*/
QString QString::fromUtf8(const char* utf8, int len)
{
    static QTextCodec* codec = QTextCodec::codecForMib(106);
    if ( len < 0 ) len = qstrlen(utf8);
    return codec
	    ? codec->toUnicode(utf8, len)
	    : QString::fromLatin1(utf8, len);
}
#endif // QT_NO_TEXTCODEC
/*!
  Creates a QString from Latin1 text.  This is the same as the
  QString(const char*) constructor, but you can make that constructor
  invisible if you compile with the define QT_NO_CAST_ASCII, in which
  case you can explicitly create a QString from Latin-1 text using
  this function.
*/
QString QString::fromLatin1(const char* chars, int len)
{
    uint l;
    QChar *uc;
    if ( len < 0 ) {
	uc = internalAsciiToUnicode(chars,&l);
    } else {
	uc = internalAsciiToUnicode(chars,&l,len);
    }
    return QString(new QStringData(uc,l,l), TRUE);
}

/*!
  \fn const QChar* QString::unicode() const

  Returns the Unicode representation of the string.  The result
  remains valid until the string is modified.
*/

/*!
  Returns the string encoded in a locale-specific format.  On X11, this
  is the QTextCodec::codecForLocale().  On Windows, it is a system-defined
  encoding.

  See QTextCodec for more diverse coding/decoding of Unicode strings.

  \sa QString::fromLocal8Bit(), latin1(), utf8()
*/


QCString QString::local8Bit() const
{
#ifdef QT_NO_TEXTCODEC
    return latin1();
#else
#ifdef _WS_X11_
    static QTextCodec* codec = QTextCodec::codecForLocale();
    return codec
	    ? codec->fromUnicode(*this)
	    : QCString(latin1());
#endif
#ifdef _WS_MAC_
    static QTextCodec* codec = QTextCodec::codecForLocale();
    return codec
	    ? codec->fromUnicode(*this)
	    : QCString(latin1());
#endif
#ifdef _WS_WIN_
    return qt_winQString2MB( *this );
#endif
#ifdef _WS_QWS_
    return utf8(); // ##### if there is ANY 8 bit format supported?
#endif
#endif
}

/*!
  Returns the unicode string decoded from the
  first \a len bytes of \a local8Bit.  If \a len is -1 (the default), the
  length of \a local8Bit is used.  If trailing partial characters are in
  \a local8Bit, they are ignored.

  \a local8Bit is assumed to be encoded in a locale-specific format.

  See QTextCodec for more diverse coding/decoding of Unicode strings.
*/
QString QString::fromLocal8Bit(const char* local8Bit, int len)
{
#ifdef QT_NO_TEXTCODEC
    return fromLatin1( local8Bit, len );
#else

    if ( !local8Bit )
	return QString::null;
#ifdef _WS_X11_
    static QTextCodec* codec = QTextCodec::codecForLocale();
    if ( len < 0 ) len = qstrlen(local8Bit);
    return codec
	    ? codec->toUnicode(local8Bit, len)
	    : QString::fromLatin1(local8Bit,len);
#endif
#ifdef _WS_MAC_
    static QTextCodec* codec = QTextCodec::codecForLocale();
    if ( len < 0 ) len = qstrlen(local8Bit);
    return codec
	    ? codec->toUnicode(local8Bit, len)
	    : QString::fromLatin1(local8Bit,len);
#endif
// Should this be OS_WIN32?
#ifdef _WS_WIN_
    if ( len >= 0 ) {
	QCString s(local8Bit,len+1);
	return qt_winMB2QString(s);
    }
    return qt_winMB2QString( local8Bit );
#endif
#ifdef _WS_QWS_
    return fromUtf8(local8Bit,len);
#endif
#endif // QT_NO_TEXTCODEC
}

/*!
  \fn QString::operator const char *() const

  Returns latin1().  Be sure to see the warnings documented there.
  Note that for new code which you wish to be strictly Unicode-clean,
  you can define the macro QT_NO_ASCII_CAST when compiling your code
  to hide this function so that automatic casts are not done.  This
  has the added advantage that you catch the programming error
  described under operator!().
*/

/*!
  \fn QChar QString::at( uint ) const

  Returns the character at \a i, or 0 if \a i is beyond the length
  of the string.

  Note: If this QString is not const or const&, the non-const at()
  will be used instead, which will expand the string if \a i is beyond
  the length of the string.
*/

/*!
  \fn QChar QString::constref(uint i) const
  Equivalent to at(i), this returns the QChar at \a i by value.

  \sa ref()
*/

/*!
  \fn QChar& QString::ref(uint i)
  Returns the QChar at \a i by reference.

  \sa constref()
*/

/*!
  \fn QChar QString::operator[](int) const

  Returns the character at \a i, or QChar::null if \a i is beyond the
  length of the string.

  Note: If this QString is not const or const&, the non-const operator[]
  will be used instead, which will expand the string if \a i is beyond
  the length of the string.
*/

/*!
  \fn QCharRef QString::operator[](int)

  Returns an object that references the character at \a i.
  This reference
  can then be assigned to, or otherwise used immediately, but
  becomes invalid once further modifications are made to the string.
  The QCharRef internal class can be used much like a constant QChar, but
  if you assign to it, you change the original string (which enlarges
  and detaches itself). You will get compilation errors if you try to
  use the result as anything but a QChar.
*/

/*!
  \fn QCharRef QString::at( uint i )
  Returns a reference to the character at \a i, expanding
  the string with QChar::null if necessary.  The resulting reference
  can then be assigned to, or otherwise used immediately, but
  becomes invalid once further modifications are made to the string.
*/

/*!
  Internal chunk of code to handle the
  uncommon cases of at() above.
*/
void QString::subat( uint i )
{
    uint olen = d->len;
    if ( i >= olen ) {
	setLength( i+1 );		// i is index; i+1 is needed length
	for ( uint j=olen; j<=i; j++ )
	    d->unicode[j] = QChar::null;
    } else {
	// Just be sure to detach
	real_detach();
    }
}


/*!
  Resizes the string to \a len unicode characters and copies \a unicode
  into the string.  If \a unicode is null, nothing is copied, but the
  string is resized to \a len anyway. If \a len is zero, the string
  becomes a \link isNull() null\endlink string.

  \sa setLatin1(), isNull()
*/

QString& QString::setUnicode( const QChar *unicode, uint len )
{
    if ( len == 0 ) {				// set to null string
	if ( d != shared_null ) {		// beware of nullstring being set to nullstring
	    deref();
	    d = shared_null ? shared_null : makeSharedNull();
	    d->ref();
	}
    } else if ( d->count != 1 || len > d->maxl ||
	 ( len*4 < d->maxl && d->maxl > 4 ) ) {	// detach, grown or shrink
	Q2HELPER(stat_copy_on_write++)
	Q2HELPER(stat_copy_on_write_size+=d->len)
	uint newMax = 4;
	while ( newMax < len )
	    newMax *= 2;
	QChar* nd = QT_ALLOC_QCHAR_VEC( newMax );
	if ( unicode )
	    memcpy( nd, unicode, sizeof(QChar)*len );
	deref();
	d = new QStringData( nd, len, newMax );
    } else {
	d->len = len;
	d->dirtyascii = 1;
	if ( unicode )
	    memcpy( d->unicode, unicode, sizeof(QChar)*len );
    }
    return *this;
}

/*!
  Resizes the string to \a len unicode characters and copies
  \a unicode_as_ushorts into the string (on some X11 client
  platforms this will involve a byte-swapping pass).

  If \a unicode is null, nothing is copied, but the
  string is resized to \a len anyway. If \a len is zero, the string
  becomes a \link isNull() null\endlink string.

  \sa setLatin1(), isNull()
*/
QString& QString::setUnicodeCodes( const ushort* unicode_as_ushorts, uint len )
{
    setUnicode((const QChar*)unicode_as_ushorts, len);
    QChar t(0x1234);
    if ( unicode_as_ushorts && *((ushort*)&t) == 0x3412 ) {
	// Need to byteswap
	char* b = (char*)d->unicode;
	while ( len-- ) {
	    char c = b[0];
	    b[0] = b[1];
	    b[1] = c;
	    b += sizeof(QChar);
	}
    }
    return *this;
}


/*!
  Sets this string to \a str, interpreted as a classic Latin 1 C string.
  If the \a len argument is negative (default), it is set to strlen(str).

  If \a str is 0 a null string is created.  If \a str is "" an empty
  string is created.

  \sa isNull(), isEmpty()
*/

QString &QString::setLatin1( const char *str, int len )
{
    if ( str == 0 )
	return setUnicode(0,0);
    if ( len < 0 )
	len = qstrlen(str);
    if ( len == 0 ) {				// won't make a null string
	deref();
	uint l;
	QChar *uc = internalAsciiToUnicode(str,&l);
	d = new QStringData(uc,l,l);
    } else {
	setUnicode( 0, len );			// resize but not copy
	QChar *p = d->unicode;
	while ( len-- )
	    *p++ = *str++;
    }
    return *this;
}


/*!
  \fn int QString::compare (const QString & s1, const QString & s2)

  Compare \a s1 to \a s2 returning an integer less than, equal to, or
  greater than zero if s1 is, respectively, lexically less than, equal to,
  or greater than s2.
*/

/*!
  Compares this string to \a s, returning an integer less than, equal to, or
  greater than zero if it is, respectively, lexically less than, equal to,
  or greater than \a s.
*/
int QString::compare( const QString& s ) const
{
    return ucstrcmp(*this,s);
}

bool operator==( const QString &s1, const QString &s2 )
{
    return (s1.length() == s2.length()) && s1.isNull() == s2.isNull() &&
	   (memcmp((char*)s1.unicode(),(char*)s2.unicode(),
		   s1.length()*sizeof(QChar)) ==0);
}

bool operator!=( const QString &s1, const QString &s2 )
{ return !(s1==s2); }

bool operator<( const QString &s1, const QString &s2 )
{ return ucstrcmp(s1,s2) < 0; }

bool operator<=( const QString &s1, const QString &s2 )
{ return ucstrcmp(s1,s2) <= 0; }

bool operator>( const QString &s1, const QString &s2 )
{ return ucstrcmp(s1,s2) > 0; }

bool operator>=( const QString &s1, const QString &s2 )
{ return ucstrcmp(s1,s2) >= 0; }


bool operator==( const QString &s1, const char *s2 )
{ return s1==QString(s2); }

bool operator==( const char *s1, const QString &s2 )
{ return QString(s1)==s2; }

bool operator!=( const QString &s1, const char *s2 )
{ return !(s1==s2); }

bool operator!=( const char *s1, const QString &s2 )
{ return !(s1==s2); }

bool operator<( const QString &s1, const char *s2 )
{ return ucstrcmp(s1,s2) < 0; }

bool operator<( const char *s1, const QString &s2 )
{ return ucstrcmp(s1,s2) < 0; }

bool operator<=( const QString &s1, const char *s2 )
{ return ucstrcmp(s1,s2) <= 0; }

bool operator<=( const char *s1, const QString &s2 )
{ return ucstrcmp(s1,s2) <= 0; }

bool operator>( const QString &s1, const char *s2 )
{ return ucstrcmp(s1,s2) > 0; }

bool operator>( const char *s1, const QString &s2 )
{ return ucstrcmp(s1,s2) > 0; }

bool operator>=( const QString &s1, const char *s2 )
{ return ucstrcmp(s1,s2) >= 0; }

bool operator>=( const char *s1, const QString &s2 )
{ return ucstrcmp(s1,s2) >= 0; }


/*****************************************************************************
  Documentation for QString related functions
 *****************************************************************************/

/*!
  \fn bool operator==( const QString &s1, const QString &s2 )
  \relates QString
  Returns TRUE if the two strings are equal, or FALSE if they are different.
  A null string is different from an empty, non-null string.

  Equivalent to <code>qstrcmp(s1,s2) == 0</code>.
*/

/*!
  \fn bool operator==( const QString &s1, const char *s2 )
  \relates QString
  Returns TRUE if the two strings are equal, or FALSE if they are different.

  Equivalent to <code>qstrcmp(s1,s2) == 0</code>.
*/

/*!
  \fn bool operator==( const char *s1, const QString &s2 )
  \relates QString
  Returns TRUE if the two strings are equal, or FALSE if they are different.

  Equivalent to <code>qstrcmp(s1,s2) == 0</code>.
*/

/*!
  \fn bool operator!=( const QString &s1, const QString &s2 )
  \relates QString
  Returns TRUE if the two strings are different, or FALSE if they are equal.

  Equivalent to <code>qstrcmp(s1,s2) != 0</code>.
*/

/*!
  \fn bool operator!=( const QString &s1, const char *s2 )
  \relates QString
  Returns TRUE if the two strings are different, or FALSE if they are equal.

  Equivalent to <code>qstrcmp(s1,s2) != 0</code>.
*/

/*!
  \fn bool operator!=( const char *s1, const QString &s2 )
  \relates QString
  Returns TRUE if the two strings are different, or FALSE if they are equal.

  Equivalent to <code>qstrcmp(s1,s2) != 0</code>.
*/

/*!
  \fn bool operator<( const QString &s1, const char *s2 )
  \relates QString
  Returns TRUE if \a s1 is alphabetically less than \a s2, otherwise FALSE.

  Equivalent to <code>qstrcmp(s1,s2) \< 0</code>.
*/

/*!
  \fn bool operator<( const char *s1, const QString &s2 )
  \relates QString
  Returns TRUE if \a s1 is alphabetically less than \a s2, otherwise FALSE.

  Equivalent to <code>qstrcmp(s1,s2) \< 0</code>.
*/

/*!
  \fn bool operator<=( const QString &s1, const char *s2 )
  \relates QString
  Returns TRUE if \a s1 is alphabetically less than or equal to \a s2,
  otherwise FALSE.

  Equivalent to <code>qstrcmp(s1,s2) \<= 0</code>.
*/

/*!
  \fn bool operator<=( const char *s1, const QString &s2 )
  \relates QString
  Returns TRUE if \a s1 is alphabetically less than or equal to \a s2,
  otherwise FALSE.

  Equivalent to <code>qstrcmp(s1,s2) \<= 0</code>.
*/

/*!
  \fn bool operator>( const QString &s1, const char *s2 )
  \relates QString
  Returns TRUE if \a s1 is alphabetically greater than \a s2, otherwise FALSE.

  Equivalent to <code>qstrcmp(s1,s2) \> 0</code>.
*/

/*!
  \fn bool operator>( const char *s1, const QString &s2 )
  \relates QString
  Returns TRUE if \a s1 is alphabetically greater than \a s2, otherwise FALSE.

  Equivalent to <code>qstrcmp(s1,s2) \> 0</code>.
*/

/*!
  \fn bool operator>=( const QString &s1, const char *s2 )
  \relates QString
  Returns TRUE if \a s1 is alphabetically greater than or equal to \a s2,
  otherwise FALSE.

  Equivalent to <code>qstrcmp(s1,s2) \>= 0</code>.
*/

/*!
  \fn bool operator>=( const char *s1, const QString &s2 )
  \relates QString
  Returns TRUE if \a s1 is alphabetically greater than or equal to \a s2,
  otherwise FALSE.

  Equivalent to <code>qstrcmp(s1,s2) \>= 0</code>.
*/

/*!
  \fn QString operator+( const QString &s1, const QString &s2 )
  \relates QString
  Returns the concatenated string of s1 and s2.
*/

/*!
  \fn QString operator+( const QString &s1, const char *s2 )
  \relates QString
  Returns the concatenated string of s1 and s2.
*/

/*!
  \fn QString operator+( const char *s1, const QString &s2 )
  \relates QString
  Returns the concatenated string of s1 and s2.
*/

/*!
  \fn QString operator+( const QString &s, char c )
  \relates QString
  Returns the concatenated string of s and c.
*/

/*!
  \fn QString operator+( char c, const QString &s )
  \relates QString
  Returns the concatenated string of c and s.
*/


/*****************************************************************************
  QString stream functions
 *****************************************************************************/
#ifndef QT_NO_DATASTREAM
/*!
  \relates QString
  Writes a string to the stream.

  \sa \link datastreamformat.html Format of the QDataStream operators \endlink
*/

QDataStream &operator<<( QDataStream &s, const QString &str )
{
    if ( s.version() == 1 ) {
	QCString l( str.latin1() );
	s << l;
    }
    else {
	const char* ub = (const char*)str.unicode();
	if ( ub || s.version() < 3 ) {
	    if ( QChar::networkOrdered() ==
		    (s.byteOrder()==QDataStream::BigEndian) ) {
		s.writeBytes( ub, sizeof(QChar)*str.length() );
	    } else {
		static const uint auto_size = 1024;
		char t[auto_size];
		char *b;
		if ( str.length()*sizeof(QChar) > auto_size ) {
		    b = new char[str.length()*sizeof(QChar)];
		} else {
		    b = t;
		}
		int l = str.length();
		char *c=b;
		while ( l-- ) {
		    *c++ = ub[1];
		    *c++ = ub[0];
		    ub+=sizeof(QChar);
		}
		s.writeBytes( b, sizeof(QChar)*str.length() );
		if ( str.length()*sizeof(QChar) > auto_size )
		    delete [] b;
	    }
	} else {
	    // write null marker
	    s << (Q_UINT32)0xffffffff;
	}
    }
    return s;
}

/*!
  \relates QString
  Reads a string from the stream.

  \sa \link datastreamformat.html Format of the QDataStream operators \endlink
*/

QDataStream &operator>>( QDataStream &s, QString &str )
{
#ifdef QT_QSTRING_UCS_4
#if defined(_CC_GNU_)
#warning "operator>> not working properly"
#endif
#endif
    if ( s.version() == 1 ) {
	QCString l;
	s >> l;
	str = QString( l );
    }
    else {
	Q_UINT32 bytes;
	s >> bytes;					// read size of string
	if ( bytes == 0xffffffff ) {			// null string
	    str = QString::null;
	} else if ( bytes > 0 ) {			// not empty
	    str.setLength( bytes/2 );
	    char* b = (char*)str.d->unicode;
	    s.readRawBytes( b, bytes );
	    if ( QChar::networkOrdered() !=
		    (s.byteOrder()==QDataStream::BigEndian) ) {
		bytes /= 2;
		while ( bytes-- ) {
		    char c = b[0];
		    b[0] = b[1];
		    b[1] = c;
		    b += 2;
		}
	    }
	} else {
	    str = "";
	}
    }
    return s;
}
#endif // QT_NO_DATASTREAM

/*****************************************************************************
  QConstString member functions
 *****************************************************************************/

/*!
  \class QConstString qstring.h
  \brief A QString which uses constant Unicode data.

  In order to minimize copying, highly optimized applications can use
  QConstString to provide a QString-compatible object from existing
  Unicode data.  It is then the user's responsibility to make sure
  that the Unicode data must exist for the entire lifetime of the
  QConstString object.
*/

/*!
  Constructs a QConstString that uses the first \a length Unicode
  characters in the array \a unicode.  Any attempt to modify
  copies of the string will cause it to create a copy of the
  data, thus it remains forever unmodified.

  Note that \a unicode is \e not \e copied.  The caller \e must be
  able to guarantee that \a unicode will not be deleted or
  modified. Since that is generally not the case with \c const strings
  (they are references), this constructor demands a non-const pointer
  even though it never modifies \a unicode.
*/
QConstString::QConstString( QChar* unicode, uint length ) :
    QString(new QStringData(unicode, length, length),TRUE)
{
}

/*!
  Destroys the QConstString, creating a copy of the data if
  other strings are still using it.
*/
QConstString::~QConstString()
{
    if ( d->count > 1 ) {
	QChar* cp = QT_ALLOC_QCHAR_VEC( d->len );
	memcpy( cp, d->unicode, d->len*sizeof(QChar) );
	d->unicode = cp;
    } else {
	d->unicode = 0;
    }

    // The original d->unicode is now unlinked.
}

/*!
  \fn const QString& QConstString::string() const

  Returns a constant string referencing the data passed during
  construction.
*/

/*!
  Returns whether the strings starts with \a s, or not.
 */
bool QString::startsWith( const QString& s ) const
{
    for ( int i =0; i < (int) s.length(); i++ ) {
	if ( i >= (int) length() || d->unicode[i] != s[i] )
	    return FALSE;
    }
    return TRUE;
}



#if defined(_OS_WIN32_)

#include <windows.h>

/*!
  Returns a static Windows TCHAR* from a QString, possibly adding NUL.

  The lifetime of the return value is until the next call to this function.
*/
const void* qt_winTchar(const QString& str_in, bool addnul)
{
    // So that the return value lives long enough.
    static QString str;
    str = str_in;

#ifdef UNICODE
    static uint buflen = 256;
    static TCHAR *buf = new TCHAR[buflen];

    const QChar* uc = str.unicode();

#define EXTEND if (str.length() > buflen) { delete buf; buf = new TCHAR[buflen=str.length()+1]; }

#if defined(_WS_X11_) || defined(_OS_WIN32_BYTESWAP_)
    EXTEND
    for ( int i=str.length(); i--; )
	buf[i] = uc[i].row() << 8 | uc[i].cell();
    if ( addnul )
	buf[str.length()] = 0;
#else
    // Same endianness of TCHAR
    if ( addnul ) {
	EXTEND
	memcpy(buf,uc,sizeof(TCHAR)*str.length());
	buf[str.length()] = 0;
    } else {
	return uc;
    }
#endif
    return buf;
#undef EXTEND

#else
    return str.latin1();
#endif
}

/*!
  Makes a new null terminated Windows TCHAR* from a QString.
*/
void* qt_winTchar_new(const QString& str)
{
    TCHAR* result = new TCHAR[str.length()+1];
    memcpy(result, qt_winTchar(str,FALSE), sizeof(TCHAR)*str.length());
    result[str.length()] = 0;
    return result;
}

/*!
  Makes a QString from a Windows TCHAR*.
*/
QString qt_winQString(void* tc)
{
#ifdef UNICODE

    int len=0;
    while ( ((TCHAR*)tc)[len] )
	len++;
#if defined(_WS_X11_) || defined(_OS_WIN32_BYTESWAP_)
    QString r;
    for ( int i=0; i<len; i++ )
	r += QChar(((TCHAR*)tc)[i]&0xff,((TCHAR*)tc)[i]>>8);
    return r;
#else
    // Same endianness of TCHAR
    return QString((QChar*)tc,len);
#endif
#undef EXTEND
#else
    return (TCHAR*)tc;
#endif
}

QCString qt_winQString2MB( const QString& s, int uclen )
{
    if ( uclen < 0 )
	uclen = s.length();
    if ( uclen == 0 )
	return QCString();
    BOOL used_def;
    int bufSize=4096;
    QCString mb(bufSize);
    int len;
    while ( !(len=WideCharToMultiByte(CP_ACP, 0, (const WCHAR*)s.unicode(), uclen,
		mb.data(), bufSize-1, 0, &used_def)) )
    {
	int r = GetLastError();
	if ( r == ERROR_INSUFFICIENT_BUFFER ) {
            bufSize=1+WideCharToMultiByte( CP_ACP, 0,
			(const WCHAR*)s.unicode(), uclen,
			0, 0, 0, &used_def);
            mb.resize(bufSize);
		// and try again...
	} else {
	    // Fail.
	    qWarning("WideCharToMultiByte cannot convert multibyte text (error %d): %s (UTF8)",
		r, s.utf8().data());
	    break;
	}
    }
    mb[len]='\0';
    return mb;
}

// WATCH OUT: mblen must include the NUL (or just use -1)
QString qt_winMB2QString( const char* mb, int mblen )
{
    if ( !mb || !mblen )
	return QString::null;
    const int wclen_auto = 4096;
    WCHAR wc_auto[wclen_auto];
    int wclen = wclen_auto;
    WCHAR *wc = wc_auto;
    int len;
    while ( !(len=MultiByteToWideChar( CP_ACP, MB_PRECOMPOSED,
		mb, mblen, wc, wclen )) )
    {
	int r = GetLastError();
	if ( r == ERROR_INSUFFICIENT_BUFFER ) {
	    if ( wc != wc_auto ) {
		qWarning("Size changed in MultiByteToWideChar");
		break;
	    } else {
		wclen = MultiByteToWideChar( CP_ACP, MB_PRECOMPOSED,
				    mb, mblen, 0, 0 );
		wc = new WCHAR[wclen];
		// and try again...
	    }
	} else {
	    // Fail.
	    qWarning("MultiByteToWideChar cannot convert multibyte text");
	    break;
	}
    }
    if ( len <= 0 )
	return QString::null;
    QString s( (QChar*)wc, len-1 ); // len-1: we don't want terminator
    if ( wc != wc_auto )
	delete [] wc;
    return s;
}


#endif // _OS_WIN32_
