from re import compile, IGNORECASE

from dosage.helpers import BasicScraper


class KernelPanic(BasicScraper):
    latestUrl = 'http://www.ubersoft.net/kpanic/'
    imageUrl = 'http://www.ubersoft.net/kpanic/d/%s'
    imageSearch = compile(r'"(/.+?comics/.+?)" ')
    prevSearch = compile(r'</a>.+?"(.+?)".+?Previous')
    help = 'Index format: yyyymmdd.html'


class Krakow(BasicScraper):
    latestUrl = 'http://www.krakowstudios.com/'
    imageUrl = 'http://www.krakowstudios.com/archive.php?date=%s'
    imageSearch = compile(r'<img src="(comics/.+?)"')
    prevSearch = compile(r'<a href="(archive\.php\?date=.+?)"><img border=0 name=previous_day')
    help = 'Index format: yyyymmdd'


class KevinAndKell(BasicScraper):
    latestUrl = 'http://www.kevinandkell.com/'
    imageUrl = 'http://www.kevinandkell.com/%s/kk%s%s.html'
    imageSearch = compile(r'<img.+?src="(/?(\d+/)?strips/kk\d+.gif)"', IGNORECASE)
    prevSearch = compile(r'<a.+?href="(/?(\.\./)?\d+/kk\d+\.html)"[^>]*><span>Previous Strip', IGNORECASE)
    help = 'Index format: yyyy-mm-dd'

    def setStrip(self, index):
        self.currentUrl = self.imageUrl % tuple(map(int, index.split('-')))
