from re import compile

from dosage.helpers import BasicScraper


class Jack(BasicScraper):
    latestUrl = 'http://www.pholph.com/'
    imageUrl = 'http://www.pholph.com/index.php?Strip=%s'
    imageSearch = compile(r'<img src="(strips/Jack\d{8}\..+?)"')
    prevSearch = compile(r'<a href="(index\.php\?Strip=\d+)">Previous Strip</a>')
    help = 'Index format: n (unpadded)'


class JerkCity(BasicScraper):
    latestUrl = 'http://www.jerkcity.com/'
    imageUrl = 'http://www.jerkcity.com/jerkcity%s'
    imageSearch = compile(r'"jerkcity.+?">.+?"(/jerkcity.+?)"')
    prevSearch = compile(r'"(jerkcity.+?)">.+?"/jerkcity.+?"')
    help = 'Index format: unknown'


class JoeAndMonkey(BasicScraper):
    latestUrl = 'http://www.joeandmonkey.com/'
    imageUrl = 'http://www.joeandmonkey.com/index.php?pageNum_Recordset2=%s'
    imageSearch = compile(r'"(comic/.+?)"')
    prevSearch = compile(r'"(/index.php\?.+?)">Previous')
    help = 'Index format: nnn'


class JoyOfTech(BasicScraper):
    latestUrl = 'http://www.geekculture.com/joyoftech/index.html'
    imageUrl = 'http://www.geekculture.com/joyoftech/joyarchives/%s.html'
    imageSearch = compile(r'<img src="((?:\.\./)?joyimages/.+?)" alt="The Joy of tech comic"')
    prevSearch = compile(r'<a href="((?:joyarchives/)?\d+\.html)">(?:<font[^>]*>)?<img[^>]*><br>[\s\n]*Previous Joy')
    help = 'Index format: nnn'
