from re import compile, IGNORECASE

from dosage.helpers import BasicScraper


class ElsieHooper(BasicScraper):
    latestUrl = 'http://www.elsiehooper.com/todaysserial.htm'
    imageUrl = 'http://www.elsiehooper.com/comics/comic%s.htm'
    imageSearch = compile(r'<img\s+?src="(/comics/elsieh\d{3}\w+\.\w{3}|/images/.+?_cover.+?)"')
    prevSearch = compile(r'<a href="(.+?)"><img.+?src="/images/previous.gif"')
    help = 'Index format: nnn'


class EntertainDome(BasicScraper):
    latestUrl = 'http://entertain-dome.com/comic.php'
    imageUrl = 'http://entertain-dome.com/comic.php?strip_id=%s'
    imageSearch = compile(r'<img src="(img/comics/.+?)"')
    prevSearch = compile(r'<a href="(\?strip_id=\d+?)"><img src="img/nav/ed_prev.gif"')
    help = 'Index format: nnn (unpadded)'


class ErrantStory(BasicScraper):
    latestUrl = 'http://www.errantstory.com/'
    imageUrl = 'http://www.errantstory.com/archive.php?date=%s'
    imageSearch = compile(r'<img[^>]+?src="([^"]*?comics/.+?)"')
    prevSearch = compile(r'<a href="(archive.php\?[^"]+?)"[^>]*><img src="[^"]*previous_day[^"]*" alt="[^"]*Previous Day[^"]*"')
    help = 'Index format: yyyy-mm-dd'


class EternalVenture(BasicScraper):
    latestUrl = 'http://pulledpunches.com/index2.php'
    imageUrl = 'http://pulledpunches.com/archive.php?date=%s.jpg'
    imageSearch = compile(r'<img src="(buzzNav/comics/\d{8}\..+?)"')
    prevSearch = compile(r'</a></td>[^>].*<td>[^>].+?<a href="(.*?date=.+?)".*?previous')
    help = 'Index format: yyyymmdd'


class Evercrest(BasicScraper):
    latestUrl = 'http://www.evercrest.com/archives/20030308'
    imageUrl = 'http://www.evercrest.com/archives/%s'
    imageSearch = compile(r'<img.+?src="([^"]*/(images/oldstrips|archives/i)/[^"]*)"')
    prevSearch = compile(r'<a.+?href="(http://www.evercrest.com/archives/\d+)">&lt; Previous')
    help = 'Index format: yyyymmdd'


class EverybodyLovesEricRaymond(BasicScraper):
    latestUrl = 'http://geekz.co.uk/lovesraymond/'
    imageUrl = 'http://geekz.co.uk/lovesraymond/archive/%s'
    imageSearch = compile(r'<img src="((?:http://geekz.co.uk)?/lovesraymond/wp-content(?:/images)/ep\d+\w?\.jpg)"', IGNORECASE)
    prevSearch = compile(r'&laquo; <a href="(http://geekz.co.uk/lovesraymond/archive/[^/"]*)">')
    help = 'Index format: name-of-old-comic'


class ExtraLife(BasicScraper):
    latestUrl = 'http://www.myextralife.com/'
    imageUrl = 'http://www.myextralife.com/archive.php?date=%s'
    imageSearch = compile(r'"(strips/.+?)"')
    prevSearch = compile(r'"(archive.+?)">.+?back')
    help = 'Index format: yyyy-mm-dd'


class EarthsongSaga(BasicScraper):
    latestUrl = 'http://www.earthsongsaga.com/'
    imageUrl = None
    imageSearch = compile(r'<img src="((?:\.\./)?images/vol\d+/ch\d+/\d+\.\w+)"')
    prevSearch = compile(r'<a href="([^"]+\.html)"[^>]*><img src="(?:(?:\.\.)?/)?images/testing/prev')

    def namer(cls, imageUrl, pageUrl):
        imgmatch = compile(r'images/vol(\d+)/ch(\d+)/(\d+)\.\w+$', IGNORECASE).search(imageUrl)
        return 'vol%02d_ch%02d_%02d' % (int(imgmatch.group(1)), int(imgmatch.group(2)), int(imgmatch.group(3)))
