// Auto generated SWIG file for Python interface of DOLFIN
//
// Copyright (C) 2012 Kristian B. Oelgaard
//
// This file is part of DOLFIN.
//
// DOLFIN is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// DOLFIN is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with DOLFIN. If not, see <http://www.gnu.org/licenses/>.
//

// Autogenerated docstrings file, extracted from the DOLFIN source C++ files.

// Documentation extracted from: (module=mesh, header=CellType.h)
%feature("docstring")  dolfin::CellType "
This class provides a common interface for different cell types.
Each cell type implements mesh functionality that is specific to
a certain type of cell.
";

%feature("docstring")  dolfin::CellType::CellType "
Constructor
";

%feature("docstring")  dolfin::CellType::create "
**Overloaded versions**

* create\ (type)

  Create cell type from type (factory function)

* create\ (type)

  Create cell type from string (factory function)
";

%feature("docstring")  dolfin::CellType::string2type "
Convert from string to cell type
";

%feature("docstring")  dolfin::CellType::type2string "
Convert from cell type to string
";

%feature("docstring")  dolfin::CellType::cell_type "
Return type of cell
";

%feature("docstring")  dolfin::CellType::facet_type "
Return type of cell for facets
";

%feature("docstring")  dolfin::CellType::dim "
Return topological dimension of cell
";

%feature("docstring")  dolfin::CellType::num_entities "
Return number of entitites of given topological dimension
";

%feature("docstring")  dolfin::CellType::num_vertices "
Return number of vertices for entity of given topological dimension
";

%feature("docstring")  dolfin::CellType::orientation "
**Overloaded versions**

* orientation\ (cell)

  Return orientation of the cell (assuming flat space)

* orientation\ (cell, up)

  Return orientation of the cell relative to given up direction
";

%feature("docstring")  dolfin::CellType::create_entities "
Create entities e of given topological dimension from vertices v
";

%feature("docstring")  dolfin::CellType::refine_cell "
Refine cell uniformly
";

%feature("docstring")  dolfin::CellType::volume "
Compute (generalized) volume of mesh entity
";

%feature("docstring")  dolfin::CellType::diameter "
Compute diameter of mesh entity
";

%feature("docstring")  dolfin::CellType::inradius "
Compute inradius of cell
";

%feature("docstring")  dolfin::CellType::radius_ratio "
Compute dim*inradius/circumradius for given cell
";

%feature("docstring")  dolfin::CellType::squared_distance "
Compute squared distance to given point
";

%feature("docstring")  dolfin::CellType::normal "
**Overloaded versions**

* normal\ (cell, facet, i)

  Compute component i of normal of given facet with respect to the cell

* normal\ (cell, facet)

  Compute of given facet with respect to the cell
";

%feature("docstring")  dolfin::CellType::cell_normal "
Compute normal to given cell (viewed as embedded in 3D)
";

%feature("docstring")  dolfin::CellType::facet_area "
Compute the area/length of given facet with respect to the cell
";

%feature("docstring")  dolfin::CellType::order "
Order entities locally
";

%feature("docstring")  dolfin::CellType::ordered "
Check if entities are ordered
";

%feature("docstring")  dolfin::CellType::collides "
**Overloaded versions**

* collides\ (cell, point)

  Check whether given point collides with cell

* collides\ (cell, entity)

  Check whether given entity collides with cell
";

%feature("docstring")  dolfin::CellType::triangulate_intersection "
Compute triangulation of intersection of two cells
";

%feature("docstring")  dolfin::CellType::description "
Return description of cell type
";

// Documentation extracted from: (module=mesh, header=MeshTopology.h)
%feature("docstring")  dolfin::MeshTopology "
MeshTopology stores the topology of a mesh, consisting of mesh
entities and connectivity (incidence relations for the mesh
entities). Note that the mesh entities don't need to be stored,
only the number of entities and the connectivity. Any numbering
scheme for the mesh entities is stored separately in a
MeshFunction over the entities.

A mesh entity e may be identified globally as a pair e = (dim,
i), where dim is the topological dimension and i is the index of
the entity within that topological dimension.
";

%feature("docstring")  dolfin::MeshTopology::MeshTopology "
**Overloaded versions**

* MeshTopology\ ()

  Create empty mesh topology

* MeshTopology\ (topology)

  Copy constructor
";

%feature("docstring")  dolfin::MeshTopology::operator= "
Assignment
";

%feature("docstring")  dolfin::MeshTopology::dim "
Return topological dimension
";

%feature("docstring")  dolfin::MeshTopology::size "
Return number of entities for given dimension
";

%feature("docstring")  dolfin::MeshTopology::size_global "
Return global number of entities for given dimension
";

%feature("docstring")  dolfin::MeshTopology::clear "
**Overloaded versions**

* clear\ ()

  Clear all data

* clear\ (d0, d1)

  Clear data for given pair of topological dimensions
";

%feature("docstring")  dolfin::MeshTopology::init "
**Overloaded versions**

* init\ (dim)

  Initialize topology of given maximum dimension

* init\ (dim, local_size, global_size)

  Set number of local entities (local_size) and global entities
  (global_size) for given topological dimension dim
";

%feature("docstring")  dolfin::MeshTopology::init_global_indices "
Initialize storage for global entity numbering for entities of
dimension dim
";

%feature("docstring")  dolfin::MeshTopology::set_global_index "
Set global index for entity of dimension dim and with local
index
";

%feature("docstring")  dolfin::MeshTopology::global_indices "
Get local-to-global index map for entities of topological
dimension d
";

%feature("docstring")  dolfin::MeshTopology::have_global_indices "
Check if global indices are available for entiries of
dimension dim
";

%feature("docstring")  dolfin::MeshTopology::shared_entities "
**Overloaded versions**

* shared_entities\ (dim)

  Return map from shared entities (local index) to processes
  that share the entity

* shared_entities\ (dim)

  Return map from shared entiies (local index) to process that
  share the entity (const version)
";

%feature("docstring")  dolfin::MeshTopology::operator "
**Overloaded versions**

* operator\ (d0, d1)

  Return connectivity for given pair of topological dimensions

* operator\ (d0, d1)

  Return connectivity for given pair of topological dimensions
";

%feature("docstring")  dolfin::MeshTopology::hash "
Return hash based on the hash of cell-vertex connectivity
";

%feature("docstring")  dolfin::MeshTopology::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=mesh, header=MeshGeometry.h)
%feature("docstring")  dolfin::MeshGeometry::MeshGeometry "
**Overloaded versions**

* MeshGeometry\ ()

  Create empty set of coordinates

* MeshGeometry\ (geometry)

  Copy constructor
";

%feature("docstring")  dolfin::MeshGeometry::operator= "
Assignment
";

%feature("docstring")  dolfin::MeshGeometry::dim "
Return Euclidean dimension of coordinate system
";

%feature("docstring")  dolfin::MeshGeometry::size "
Return number of coordinates
";

%feature("docstring")  dolfin::MeshGeometry::x "
**Overloaded versions**

* x\ (n, i)

  Return value of coordinate with local index n in direction i

* x\ (n, i)

  Return value of coordinate with local index n in direction i

* x\ (n)

  Return array of values for coordinate with local index n

* x\ (n)

  Return array of values for coordinate with local index n

* x\ ()

  Return array of values for all coordinates

* x\ ()

  Return array of values for all coordinates
";

%feature("docstring")  dolfin::MeshGeometry::point "
Return coordinate with local index n as a 3D point value
";

%feature("docstring")  dolfin::MeshGeometry::clear "
Clear all data
";

%feature("docstring")  dolfin::MeshGeometry::init "
Initialize coordinate list to given dimension and size
";

%feature("docstring")  dolfin::MeshGeometry::hash "
Hash of coordinate values

*Returns*
    int
        A tree-hashed value of the coordinates over all MPI processes

";

%feature("docstring")  dolfin::MeshGeometry::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=mesh, header=MeshDomains.h)
%feature("docstring")  dolfin::MeshDomains "
The class :py:class:`MeshDomains` stores the division of a :py:class:`Mesh` into
subdomains. For each topological dimension 0 <= d <= D, where D
is the topological dimension of the :py:class:`Mesh`, a set of integer
markers are stored for a subset of the entities of dimension d,
indicating for each entity in the subset the number of the
subdomain. It should be noted that the subset does not need to
contain all entities of any given dimension; entities not
contained in the subset are \"unmarked\".
";

%feature("docstring")  dolfin::MeshDomains::MeshDomains "
Create empty mesh domains
";

%feature("docstring")  dolfin::MeshDomains::max_dim "
Return maximum topological dimension of stored markers
";

%feature("docstring")  dolfin::MeshDomains::num_marked "
Return number of marked entities of given dimension
";

%feature("docstring")  dolfin::MeshDomains::is_empty "
Check whether domain data is empty
";

%feature("docstring")  dolfin::MeshDomains::markers "
**Overloaded versions**

* markers\ (dim)

  Get subdomain markers for given dimension (shared pointer
  version)

* markers\ (dim)

  Get subdomain markers for given dimension (const shared
  pointer version)
";

%feature("docstring")  dolfin::MeshDomains::set_marker "
Set marker (entity index, marker value) of a given dimension
d. Returns true if a new key is inserted, false otherwise.
";

%feature("docstring")  dolfin::MeshDomains::get_marker "
Get marker (entity index, marker value) of a given dimension
d. Throws an error if marker does not exist.
";

%feature("docstring")  dolfin::MeshDomains::operator= "
Assignment operator
";

%feature("docstring")  dolfin::MeshDomains::init "
Initialize mesh domains for given topological dimension
";

%feature("docstring")  dolfin::MeshDomains::clear "
Clear all data
";

// Documentation extracted from: (module=mesh, header=MeshData.h)
%feature("docstring")  dolfin::MeshData "
The class MeshData is a container for auxiliary mesh data,
represented either as arrays or maps. Each dataset is identified
by a unique user-specified string. Only std::size_t-valued data
are currently supported.

Auxiliary mesh data may be attached to a mesh by users as a
convenient way to store data associated with a mesh. It is also
used internally by DOLFIN to communicate data associated with
meshes. The following named mesh data are recognized by DOLFIN:

Facet orientation (used for assembly over interior facets)

  * \"facet_orientation\"  - _std:vector_ <std::size_t> of dimension D - 1

Sub meshes (used by the class SubMesh)

  * \"parent_vertex_indices\" - _std::vector_ <std::size_t> of dimension 0

Note to developers: use underscore in names in place of spaces.
";

%feature("docstring")  dolfin::MeshData::MeshData "
Constructor
";

%feature("docstring")  dolfin::MeshData::operator= "
Assignment operator

*Arguments*
    data (:py:class:`MeshData`)
        Another MeshData object.
";

%feature("docstring")  dolfin::MeshData::clear "
Clear all data
";

%feature("docstring")  dolfin::MeshData::exists "
Check is array exists

*Arguments*
    name (str)
        The name of the array.

*Returns*
    bool
        True is array exists, false otherwise.
";

%feature("docstring")  dolfin::MeshData::create_mesh_function "
**Overloaded versions**

* create_mesh_function\ (name)

  This function is no longer supported. It is retained to print
  an informative error message. It will be removed in the
  future.

* create_mesh_function\ (name, dim)

  This function is no longer supported. It is retained to print
  an informative error message. It will be removed in the
  future.
";

%feature("docstring")  dolfin::MeshData::mesh_function "
This function is no longer supported. It is retained to print
an informative error message. It will be removed in the
future.
";

%feature("docstring")  dolfin::MeshData::array "
**Overloaded versions**

* array\ (name, dim)

  Return array with given name (returning zero if data is not
  available)
  
  *Arguments*
      name (str)
          The name of the array.
  
  *Returns*
      numpy.array(int)
          The array.

* array\ (name, dim)

  Return array with given name (returning zero if data is not
  available)
  
  *Arguments*
      name (str)
          The name of the array.
  
  *Returns*
      numpy.array(int)
          The array.
";

%feature("docstring")  dolfin::MeshData::erase_array "
Erase array with given name

*Arguments*
    name (str)
        The name of the array.
";

%feature("docstring")  dolfin::MeshData::str "
Return informal string representation (pretty-print)

*Arguments*
    verbose (bool)
        Flag to turn on additional output.

*Returns*
    str
        An informal representation.
";

// Documentation extracted from: (module=mesh, header=Mesh.h)
%feature("docstring")  dolfin::Mesh "
A :py:class:`Mesh` consists of a set of connected and numbered mesh entities.

Both the representation and the interface are
dimension-independent, but a concrete interface is also provided
for standard named mesh entities:

.. tabularcolumns:: |c|c|c|

+--------+-----------+-------------+
| Entity | Dimension | Codimension |
+========+===========+=============+
| Vertex |  0        |             |
+--------+-----------+-------------+
| Edge   |  1        |             |
+--------+-----------+-------------+
| Face   |  2        |             |
+--------+-----------+-------------+
| Facet  |           |      1      |
+--------+-----------+-------------+
| Cell   |           |      0      |
+--------+-----------+-------------+

When working with mesh iterators, all entities and connectivity
are precomputed automatically the first time an iterator is
created over any given topological dimension or connectivity.

Note that for efficiency, only entities of dimension zero
(vertices) and entities of the maximal dimension (cells) exist
when creating a :py:class:`Mesh`. Other entities must be explicitly created
by calling init(). For example, all edges in a mesh may be
created by a call to mesh.init(1). Similarly, connectivities
such as all edges connected to a given vertex must also be
explicitly created (in this case by a call to mesh.init(0, 1)).
";

%feature("docstring")  dolfin::Mesh::Mesh "
**Overloaded versions**

* Mesh\ ()

  Create empty mesh

* Mesh\ (comm)

  Create empty mesh

* Mesh\ (mesh)

  Copy constructor.
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          Object to be copied.

* Mesh\ (filename)

  Create mesh from data file.
  
  *Arguments*
      filename (str)
          Name of file to load.

* Mesh\ (comm, filename)

  Create mesh from data file.
  
  *Arguments*
      comm (:py:class:`MPI`)
          The MPI communicator
      filename (str)
          Name of file to load.

* Mesh\ (comm, local_mesh_data)

  Create a distributed mesh from local (per process) data.
  
  *Arguments*
      comm (:py:class:`MPI`)
          MPI communicator for the mesh.
      local_mesh_data (:py:class:`LocalMeshData`)
          Data from which to build the mesh.

* Mesh\ (geometry, resolution)

  Create mesh defined by Constructive Solid Geometry (CSG)
  
  *Arguments*
      geometry (:py:class:`CSGGeometry`)
          The CSG geometry
      resolution (int)
          An integer specifying the mesh resolution

* Mesh\ (geometry, resolution)

  Create mesh defined by Constructive Solid Geometry (CSG)
  
  *Arguments*
      geometry (:py:class:`CSGGeometry`)
          The CSG geometry
      resolution (int)
          An integer specifying the mesh resolution
";

%feature("docstring")  dolfin::Mesh::operator= "
Assignment operator

*Arguments*
    mesh (:py:class:`Mesh`)
        Another :py:class:`Mesh` object.
";

%feature("docstring")  dolfin::Mesh::num_vertices "
Get number of vertices in mesh.

*Returns*
    int
        Number of vertices.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::Mesh::num_edges "
Get number of edges in mesh.

*Returns*
    int
        Number of edges.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::Mesh::num_faces "
Get number of faces in mesh.

*Returns*
    int
        Number of faces.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::Mesh::num_facets "
Get number of facets in mesh.

*Returns*
    int
        Number of facets.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::Mesh::num_cells "
Get number of cells in mesh.

*Returns*
    int
        Number of cells.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::Mesh::num_entities "
Get number of entities of given topological dimension.

*Arguments*
    d (int)
        Topological dimension.

*Returns*
    int
        Number of entities of topological dimension d.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::Mesh::coordinates "
**Overloaded versions**

* coordinates\ ()

  Get vertex coordinates.
  
  *Returns*
      numpy.array(float)
          Coordinates of all vertices.
  
  *Example*
      .. note::
      
          No example code available for this function.

* coordinates\ ()

  Return coordinates of all vertices (const version).
";

%feature("docstring")  dolfin::Mesh::cells "
Get cell connectivity.

*Returns*
    numpy.array(int)
        Connectivity for all cells.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::Mesh::size "
Get number of local entities of given topological dimension.

*Arguments*
    dim (int)
        Topological dimension.

*Returns*
    int
        Number of local entities of topological dimension d.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::Mesh::size_global "
Get global number of entities of given topological dimension.

*Arguments*
    dim (int)
        Topological dimension.

*Returns*
    int
        Global number of entities of topological dimension d.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::Mesh::topology "
**Overloaded versions**

* topology\ ()

  Get mesh topology.
  
  *Returns*
      :py:class:`MeshTopology`
          The topology object associated with the mesh.

* topology\ ()

  Get mesh topology (const version).
";

%feature("docstring")  dolfin::Mesh::geometry "
**Overloaded versions**

* geometry\ ()

  Get mesh geometry.
  
  *Returns*
      :py:class:`MeshGeometry`
          The geometry object associated with the mesh.

* geometry\ ()

  Get mesh geometry (const version).
";

%feature("docstring")  dolfin::Mesh::domains "
**Overloaded versions**

* domains\ ()

  Get mesh (sub)domains.
  
  *Returns*
      :py:class:`MeshDomains`
          The (sub)domains associated with the mesh.

* domains\ ()

  Get mesh (sub)domains.
";

%feature("docstring")  dolfin::Mesh::bounding_box_tree "
Get bounding box tree for mesh. The bounding box tree is
initialized and built upon the first call to this
function. The bounding box tree can be used to compute
collisions between the mesh and other objects. It is the
responsibility of the caller to use (and possibly rebuild) the
tree. It is stored as a (mutable) member of the mesh to enable
sharing of the bounding box tree data structure.
";

%feature("docstring")  dolfin::Mesh::data "
**Overloaded versions**

* data\ ()

  Get mesh data.
  
  *Returns*
      :py:class:`MeshData`
          The mesh data object associated with the mesh.

* data\ ()

  Get mesh data (const version).
";

%feature("docstring")  dolfin::Mesh::type "
**Overloaded versions**

* type\ ()

  Get mesh cell type.
  
  *Returns*
      :py:class:`CellType`
          The cell type object associated with the mesh.

* type\ ()

  Get mesh cell type (const version).
";

%feature("docstring")  dolfin::Mesh::init "
**Overloaded versions**

* init\ (dim)

  Compute entities of given topological dimension.
  
  *Arguments*
      dim (int)
          Topological dimension.
  
  *Returns*
      int
          Number of created entities.

* init\ (d0, d1)

  Compute connectivity between given pair of dimensions.
  
  *Arguments*
      d0 (int)
          Topological dimension.
  
      d1 (int)
          Topological dimension.

* init\ ()

  Compute all entities and connectivity.
";

%feature("docstring")  dolfin::Mesh::clear "
Clear all mesh data.
";

%feature("docstring")  dolfin::Mesh::clean "
Clean out all auxiliary topology data. This clears all
topological data, except the connectivity between cells and
vertices.
";

%feature("docstring")  dolfin::Mesh::order "
Order all mesh entities.

.. seealso::

    UFC documentation (put link here!)
";

%feature("docstring")  dolfin::Mesh::ordered "
Check if mesh is ordered according to the UFC numbering convention.

*Returns*
    bool
        The return values is true iff the mesh is ordered.
";

%feature("docstring")  dolfin::Mesh::translate "
Translate mesh according to a given vector.

*Arguments*
    point (Point)
        The vector defining the translation.
";

%feature("docstring")  dolfin::Mesh::rotate "
**Overloaded versions**

* rotate\ (angle, axis=2)

  Rotate mesh around a coordinate axis through center of mass
  of all mesh vertices
  
  *Arguments*
      angle (float)
          The number of degrees (0-360) of rotation.
      axis (int)
          The coordinate axis around which to rotate the mesh.

* rotate\ (angle, axis, point)

  Rotate mesh around a coordinate axis through a given point
  
  *Arguments*
      angle (float)
          The number of degrees (0-360) of rotation.
      axis (int)
          The coordinate axis around which to rotate the mesh.
      point (:py:class:`Point`)
          The point around which to rotate the mesh.
";

%feature("docstring")  dolfin::Mesh::move "
**Overloaded versions**

* move\ (boundary)

  Move coordinates of mesh according to new boundary coordinates.
  
  *Arguments*
      boundary (:py:class:`BoundaryMesh`)
          A mesh containing just the boundary cells.
  
  *Returns*
      MeshDisplacement
          Displacement encapsulated in Expression subclass
          MeshDisplacement.

* move\ (mesh)

  Move coordinates of mesh according to adjacent mesh with
  common global vertices.
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          A :py:class:`Mesh` object.
  
  *Returns*
      MeshDisplacement
          Displacement encapsulated in Expression subclass
          MeshDisplacement.

* move\ (displacement)

  Move coordinates of mesh according to displacement function.
  
  *Arguments*
      displacement (:py:class:`GenericFunction`)
          A :py:class:`GenericFunction` object.
";

%feature("docstring")  dolfin::Mesh::smooth "
Smooth internal vertices of mesh by local averaging.

*Arguments*
    num_iterations (int)
        Number of iterations to perform smoothing,
        default value is 1.
";

%feature("docstring")  dolfin::Mesh::smooth_boundary "
Smooth boundary vertices of mesh by local averaging.

*Arguments*
    num_iterations (int)
        Number of iterations to perform smoothing,
        default value is 1.

    harmonic_smoothing (bool)
        Flag to turn on harmonics smoothing, default
        value is true.
";

%feature("docstring")  dolfin::Mesh::snap_boundary "
Snap boundary vertices of mesh to match given sub domain.

*Arguments*
    sub_domain (:py:class:`SubDomain`)
        A :py:class:`SubDomain` object.

    harmonic_smoothing (bool)
        Flag to turn on harmonics smoothing, default
        value is true.
";

%feature("docstring")  dolfin::Mesh::color "
**Overloaded versions**

* color\ (coloring_type)

  Color the cells of the mesh such that no two neighboring cells
  share the same color. A colored mesh keeps a
  CellFunction<std::size_t> named \"cell colors\" as mesh data which
  holds the colors of the mesh.
  
  *Arguments*
      coloring_type (str)
          Coloring type, specifying what relation makes two
          cells neighbors, can be one of \"vertex\", \"edge\" or
          \"facet\".
  
  *Returns*
      numpy.array(int)
          The colors as a mesh function over the cells of the mesh.

* color\ (coloring_type)

  Color the cells of the mesh such that no two neighboring cells
  share the same color. A colored mesh keeps a
  CellFunction<std::size_t> named \"cell colors\" as mesh data which
  holds the colors of the mesh.
  
  *Arguments*
      coloring_type (numpy.array(int))
          Coloring type given as list of topological dimensions,
          specifying what relation makes two mesh entinties neighbors.
  
  *Returns*
      numpy.array(int)
          The colors as a mesh function over entities of the mesh.
";

%feature("docstring")  dolfin::Mesh::hmin "
Compute minimum cell diameter.

*Returns*
    float
        The minimum cell diameter, the diameter is computed as
        two times the circumradius
        (http://mathworld.wolfram.com).

*Example*
    .. code-block:: python
    
        >>> mesh = dolfin.UnitSquare(2,2)
        >>> mesh.hmin()
        0.70710678118654757
";

%feature("docstring")  dolfin::Mesh::hmax "
Compute maximum cell diameter.

*Returns*
    float
        The maximum cell diameter, the diameter is computed as
        two times the circumradius
        (http://mathworld.wolfram.com).

*Example*
    .. code-block:: python
    
        >>> mesh = dolfin.UnitSquare(2,2)
        >>> mesh.hmax()
        0.70710678118654757
";

%feature("docstring")  dolfin::Mesh::rmin "
Compute minimum cell inradius.

*Returns*
    float
        The minimum of cells' inscribed sphere radii

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::Mesh::rmax "
Compute maximum cell inradius.

*Returns*
    float
        The maximum of cells' inscribed sphere radii

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::Mesh::hash "
Compute hash of mesh, currently based on the has of the mesh
geometry and mesh topology.

*Returns*
    int
        A tree-hashed value of the coordinates over all MPI processes

";

%feature("docstring")  dolfin::Mesh::str "
Informal string representation.

*Arguments*
    verbose (bool)
        Flag to turn on additional output.

*Returns*
    str
        An informal representation of the mesh.

*Example*
    .. code-block:: python
    
        >>> mesh = dolfin.UnitSquare(2,2)
        >>> mesh.str(False)
        '<Mesh of topological dimension 2 (triangles) with 9 vertices and 8 cells, ordered>'
";

%feature("docstring")  dolfin::Mesh::cell_orientations "
**Overloaded versions**

* cell_orientations\ ()

  Return cell_orientations
  
  *Returns*
      numpy.array(int)
          Map from cell index to orientation of cell

* cell_orientations\ ()

  Return cell_orientations (const version)
  
  *Returns*
      numpy.array(int)
          Map from cell index to orientation of cell
";

%feature("docstring")  dolfin::Mesh::init_cell_orientations "
Compute and initialize cell_orientations relative to a given
global outward direction/normal/orientation. Only defined if
mesh is orientable.

*Arguments*
    global_normal (Expression)
        A global normal direction to the mesh
";

%feature("docstring")  dolfin::Mesh::mpi_comm "
Mesh MPI communicator
";

// Documentation extracted from: (module=mesh, header=MeshEntity.h)
%feature("docstring")  dolfin::MeshEntity "
A MeshEntity represents a mesh entity associated with
a specific topological dimension of some :py:class:`Mesh`.
";

%feature("docstring")  dolfin::MeshEntity::MeshEntity "
**Overloaded versions**

* MeshEntity\ ()

  Default Constructor

* MeshEntity\ (mesh, dim, index)

  Constructor
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh.
      dim (int)
          The topological dimension.
      index (int)
          The index.
";

%feature("docstring")  dolfin::MeshEntity::init "
Initialize mesh entity with given data

*Arguments*
    mesh (:py:class:`Mesh`)
        The mesh.
    dim (int)
        The topological dimension.
    index (int)
        The index.
";

%feature("docstring")  dolfin::MeshEntity::operator== "
Comparision Operator

*Arguments*
    another (:py:class:`MeshEntity`)
        Another mesh entity

*Returns*
    bool
        True if the two mesh entities are equal.
";

%feature("docstring")  dolfin::MeshEntity::operator!= "
Comparision Operator

*Arguments*
    another (MeshEntity)
        Another mesh entity.

*Returns*
    bool
        True if the two mesh entities are NOT equal.
";

%feature("docstring")  dolfin::MeshEntity::mesh "
Return mesh associated with mesh entity

*Returns*
    :py:class:`Mesh`
        The mesh.
";

%feature("docstring")  dolfin::MeshEntity::dim "
Return topological dimension

*Returns*
    int
        The dimension.
";

%feature("docstring")  dolfin::MeshEntity::index "
**Overloaded versions**

* index\ ()

  Return index of mesh entity
  
  *Returns*
      int
          The index.

* index\ (entity)

  Compute local index of given incident entity (error if not
  found)
  
  *Arguments*
      entity (:py:class:`MeshEntity`)
          The mesh entity.
  
  *Returns*
      int
          The local index of given entity.
";

%feature("docstring")  dolfin::MeshEntity::global_index "
Return global index of mesh entity

*Returns*
    int
        The global index. Set to
        std::numerical_limits<std::size_t>::max() if global index
        has not been computed
";

%feature("docstring")  dolfin::MeshEntity::num_entities "
Return local number of incident mesh entities of given
topological dimension

*Arguments*
    dim (int)
        The topological dimension.

*Returns*
    int
The number of local incident MeshEntity objects of given
dimension.
";

%feature("docstring")  dolfin::MeshEntity::num_global_entities "
Return global number of incident mesh entities of given
topological dimension

*Arguments*
    dim (int)
        The topological dimension.

*Returns*
    int
        The number of global incident MeshEntity objects of given
        dimension.
";

%feature("docstring")  dolfin::MeshEntity::entities "
Return array of indices for incident mesh entitites of given
topological dimension

*Arguments*
    dim (int)
        The topological dimension.

*Returns*
    int
        The index for incident mesh entities of given dimension.
";

%feature("docstring")  dolfin::MeshEntity::mesh_id "
Return unique mesh ID

*Returns*
    int
        The unique mesh ID.
";

%feature("docstring")  dolfin::MeshEntity::incident "
Check if given entity is incident

*Arguments*
    entity (:py:class:`MeshEntity`)
        The entity.

*Returns*
    bool
        True if the given entity is incident
";

%feature("docstring")  dolfin::MeshEntity::midpoint "
Compute midpoint of cell

*Returns*
    :py:class:`Point`
        The midpoint of the cell.
";

%feature("docstring")  dolfin::MeshEntity::str "
Return informal string representation (pretty-print)

*Arguments*
    verbose (bool)
        Flag to turn on additional output.

*Returns*
    str
        An informal representation of the function space.
";

// Documentation extracted from: (module=mesh, header=MeshEntityIterator.h)
%feature("docstring")  dolfin::MeshEntityIterator "
MeshEntityIterator provides a common iterator for mesh entities
over meshes, boundaries and incidence relations. The basic use
is illustrated below.

*Example*
    The following example shows how to iterate over all mesh entities
    of a mesh of topological dimension dim:
    
    .. code-block:: python
    
        >>> for e in dolfin.cpp.entities(mesh, 1):
        ...     print e.index()
    
    The following example shows how to iterate over mesh entities of
    topological dimension dim connected (incident) to some mesh entity f:
    
    .. code-block:: python
    
        >>> f = dolfin.cpp.MeshEntity(mesh, 0, 0)
        >>> for e in dolfin.cpp.entities(f, 1):
        ...     print e.index()
In addition to the general iterator, a set of specific named iterators
are provided for entities of type :py:class:`Vertex`, :py:class:`Edge`, :py:class:`Face`, :py:class:`Facet`
and :py:class:`Cell`. These iterators are defined along with their respective
classes.
";

%feature("docstring")  dolfin::MeshEntityIterator::MeshEntityIterator "
**Overloaded versions**

* MeshEntityIterator\ ()

  Default constructor

* MeshEntityIterator\ (mesh, dim)

  Create iterator for mesh entities over given topological dimension

* MeshEntityIterator\ (entity, dim)

  Create iterator for entities of given dimension connected to
  given entity

* MeshEntityIterator\ (it)

  Copy constructor
";

%feature("docstring")  dolfin::MeshEntityIterator::operator++ "
Step to next mesh entity (prefix increment)
";

%feature("docstring")  dolfin::MeshEntityIterator::operator-- "
Step to the previous mesh entity (prefix decrease)
";

%feature("docstring")  dolfin::MeshEntityIterator::pos "
Return current position
";

%feature("docstring")  dolfin::MeshEntityIterator::operator== "
Comparison operator
";

%feature("docstring")  dolfin::MeshEntityIterator::operator!= "
Comparison operator
";

%feature("docstring")  dolfin::MeshEntityIterator::operator* "
Dereference operator
";

%feature("docstring")  dolfin::MeshEntityIterator::operator-> "
Member access operator
";

%feature("docstring")  dolfin::MeshEntityIterator::end "
Check if iterator has reached the end
";

%feature("docstring")  dolfin::MeshEntityIterator::end_iterator "
Provide a safeguard iterator pointing beyond the end of an
iteration process, either iterating over the mesh /or incident
entities. Added to be bit more like STL iterators, since many
algorithms rely on a kind of beyond iterator.
";

// Documentation extracted from: (module=mesh, header=MeshEntityIteratorBase.h)
%feature("docstring")  dolfin::MeshEntityIteratorBase::MeshEntityIteratorBase "
**Overloaded versions**

* MeshEntityIteratorBase\ (mesh)

  Create iterator for mesh entities over given topological dimension

* MeshEntityIteratorBase\ (entity)

  Create iterator for entities of given dimension connected to given entity

* MeshEntityIteratorBase\ (it)

  Copy constructor
";

%feature("docstring")  dolfin::MeshEntityIteratorBase::operator++ "
Step to next mesh entity (prefix increment)
";

%feature("docstring")  dolfin::MeshEntityIteratorBase::operator-- "
Step to the previous mesh entity (prefix decrease)
";

%feature("docstring")  dolfin::MeshEntityIteratorBase::pos "
Return current position
";

%feature("docstring")  dolfin::MeshEntityIteratorBase::operator== "
Comparison operator.
";

%feature("docstring")  dolfin::MeshEntityIteratorBase::operator!= "
Comparison operator
";

%feature("docstring")  dolfin::MeshEntityIteratorBase::operator* "
Dereference operator
";

%feature("docstring")  dolfin::MeshEntityIteratorBase::operator-> "
Member access operator
";

%feature("docstring")  dolfin::MeshEntityIteratorBase::operator[] "
Random access operator
";

%feature("docstring")  dolfin::MeshEntityIteratorBase::end "
Check if iterator has reached the end
";

%feature("docstring")  dolfin::MeshEntityIteratorBase::end_iterator "
Provide a safeguard iterator pointing beyond the end of an iteration
process, either iterating over the mesh /or incident entities. Added to
be bit more like STL iterators, since many algorithms rely on a kind of
beyond iterator.
";

%feature("docstring")  dolfin::MeshEntityIteratorBase::set_end "
Set pos to end position. To create a kind of mesh.end() iterator.
";

// Documentation extracted from: (module=mesh, header=SubsetIterator.h)
%feature("docstring")  dolfin::SubsetIterator "
A :py:class:`SubsetIterator` is similar to a :py:class:`MeshEntityIterator` but
iterates over a specified subset of the range of entities as
specified by a :py:class:`MeshFunction` that labels the entites.
";

%feature("docstring")  dolfin::SubsetIterator::SubsetIterator "
**Overloaded versions**

* SubsetIterator\ (labels, label)

  Create iterator for given mesh function. The iterator visits
  all entities that match the given label.

* SubsetIterator\ (subset_iter)

  Copy Constructor
";

%feature("docstring")  dolfin::SubsetIterator::operator++ "
Step to next mesh entity (prefix increment)
";

%feature("docstring")  dolfin::SubsetIterator::operator== "
Comparison operator
";

%feature("docstring")  dolfin::SubsetIterator::operator!= "
Comparison operator
";

%feature("docstring")  dolfin::SubsetIterator::operator* "
Dereference operator
";

%feature("docstring")  dolfin::SubsetIterator::operator-> "
Member access operator
";

%feature("docstring")  dolfin::SubsetIterator::end "
Check if iterator has reached the end
";

%feature("docstring")  dolfin::SubsetIterator::set_end "
Set pos to end position. To create a kind of mesh.end() iterator.
";

// Documentation extracted from: (module=mesh, header=Vertex.h)
%feature("docstring")  dolfin::Vertex "
A Vertex is a MeshEntity of topological dimension 0.
";

%feature("docstring")  dolfin::Vertex::Vertex "
**Overloaded versions**

* Vertex\ (mesh, index)

  Create vertex on given mesh

* Vertex\ (entity)

  Create vertex from mesh entity
";

%feature("docstring")  dolfin::Vertex::x "
**Overloaded versions**

* x\ (i)

  Return value of vertex coordinate i

* x\ ()

  Return array of vertex coordinates (const version)
";

%feature("docstring")  dolfin::Vertex::point "
Return vertex coordinates as a 3D point value
";

%feature("docstring")  dolfin::VertexFunction "
A VertexFunction is a MeshFunction of topological dimension 0.
";

// Documentation extracted from: (module=mesh, header=Edge.h)
%feature("docstring")  dolfin::Edge "
An Edge is a :py:class:`MeshEntity` of topological dimension 1.
";

%feature("docstring")  dolfin::Edge::Edge "
**Overloaded versions**

* Edge\ (mesh, index)

  Create edge on given mesh
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh.
      index (int)
          Index of the edge.

* Edge\ (entity)

  Create edge from mesh entity
  
  *Arguments*
      entity (:py:class:`MeshEntity`)
          The mesh entity to create an edge from.
";

%feature("docstring")  dolfin::Edge::length "
Compute Euclidean length of edge

*Returns*
    float
        Euclidean length of edge.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::Edge::dot "
Compute dot product between edge and other edge

*Arguments*
    edge (:py:class:`Edge`)
        Another edge.

*Returns*
    float
        The dot product.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::EdgeFunction "
An EdgeFunction is a :py:class:`MeshFunction` of topological dimension 1.
";

// Documentation extracted from: (module=mesh, header=Face.h)
%feature("docstring")  dolfin::Face "
A Face is a MeshEntity of topological dimension 2.
";

%feature("docstring")  dolfin::Face::Face "
Constructor
";

%feature("docstring")  dolfin::Face::area "
Calculate the area of the face (triangle)
";

%feature("docstring")  dolfin::Face::normal "
**Overloaded versions**

* normal\ (i)

  Compute component i of the normal to the face

* normal\ ()

  Compute normal to the face
";

%feature("docstring")  dolfin::FaceFunction "
A FaceFunction is a MeshFunction of topological dimension 2.
";

// Documentation extracted from: (module=mesh, header=Facet.h)
%feature("docstring")  dolfin::Facet "
A Facet is a MeshEntity of topological codimension 1.
";

%feature("docstring")  dolfin::Facet::Facet "
Constructor
";

%feature("docstring")  dolfin::Facet::normal "
**Overloaded versions**

* normal\ (i)

  Compute component i of the normal to the facet

* normal\ ()

  Compute normal to the facet
";

%feature("docstring")  dolfin::Facet::exterior "
Return true if facet is an exterior facet (relative to global mesh,
so this function will return false for facets on partition
boundaries). Facet connectivity must be initialized before
calling this function.
";

%feature("docstring")  dolfin::Facet::adjacent_cells "
Return adjacent cells. An optional argument that lists for
each facet the index of the first cell may be given to specify
the ordering of the two cells. If not specified, the ordering
will depend on the (arbitrary) ordering of the mesh
connectivity.
";

%feature("docstring")  dolfin::FacetFunction "
A FacetFunction is a MeshFunction of topological codimension 1.
";

// Documentation extracted from: (module=mesh, header=Cell.h)
%feature("docstring")  dolfin::Cell "
A Cell is a :py:class:`MeshEntity` of topological codimension 0.
";

%feature("docstring")  dolfin::Cell::Cell "
**Overloaded versions**

* Cell\ ()

  Create empty cell

* Cell\ (mesh, index)

  Create cell on given mesh with given index
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh.
      index (int)
          The index.
";

%feature("docstring")  dolfin::Cell::type "
Return type of cell
";

%feature("docstring")  dolfin::Cell::orientation "
**Overloaded versions**

* orientation\ ()

  Compute orientation of cell
  
  *Returns*
      int
          Orientation of the cell (0 is 'up'/'right', 1 is 'down'/'left')

* orientation\ (up)

  Compute orientation of cell relative to given 'up' direction
  
  *Arguments*
      up (:py:class:`Point`)
          The direction defined as 'up'
  
  *Returns*
      int
          Orientation of the cell (0 is 'same', 1 is 'opposite')
";

%feature("docstring")  dolfin::Cell::volume "
Compute (generalized) volume of cell

*Returns*
    float
        The volume of the cell.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::Cell::diameter "
Compute diameter of cell

*Returns*
    float
        The diameter of the cell.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::Cell::inradius "
Compute inradius of cell

*Returns*
    float
        Radius of the sphere inscribed in the cell.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::Cell::radius_ratio "
Compute ratio of inradius to circumradius times dim for cell.
Useful as cell quality measure. Returns 1. for equilateral
and 0. for degenerate cell.
See Jonathan Richard Shewchuk: What Is a Good Linear Finite Element?,
online: http://www.cs.berkeley.edu/~jrs/papers/elemj.pdf

*Returns*
    float
        cell_dimension * inradius / circumradius

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::Cell::squared_distance "
Compute squared distance to given point.

*Arguments*
    point (:py:class:`Point`)
        The point.
*Returns*
    float
        The squared distance to the point.
";

%feature("docstring")  dolfin::Cell::distance "
Compute distance to given point.

*Arguments*
    point (:py:class:`Point`)
        The point.
*Returns*
    float
        The distance to the point.
";

%feature("docstring")  dolfin::Cell::normal "
**Overloaded versions**

* normal\ (facet, i)

  Compute component i of normal of given facet with respect to the cell
  
  *Arguments*
      facet (int)
          Index of facet.
      i (int)
          Component.
  
  *Returns*
      float
          Component i of the normal of the facet.

* normal\ (facet)

  Compute normal of given facet with respect to the cell
  
  *Arguments*
      facet (int)
          Index of facet.
  
  *Returns*
      :py:class:`Point`
          Normal of the facet.
";

%feature("docstring")  dolfin::Cell::cell_normal "
Compute normal to cell itself (viewed as embedded in 3D)

*Returns*
    :py:class:`Point`
        Normal of the cell
";

%feature("docstring")  dolfin::Cell::facet_area "
Compute the area/length of given facet with respect to the cell

*Arguments*
    facet (int)
        Index of the facet.

*Returns*
    float
        Area/length of the facet.
";

%feature("docstring")  dolfin::Cell::order "
Order entities locally

*Arguments*
    global_vertex_indices (numpy.array(int))
        The global vertex indices.
";

%feature("docstring")  dolfin::Cell::ordered "
Check if entities are ordered

*Arguments*
    global_vertex_indices (numpy.array(int))
        The global vertex indices.

*Returns*
    bool
        True iff ordered.
";

%feature("docstring")  dolfin::Cell::contains "
Check whether given point is contained in cell. This function is
identical to the function collides(point).

*Arguments*
    point (:py:class:`Point`)
        The point to be checked.

*Returns*
    bool
        True iff point is contained in cell.
";

%feature("docstring")  dolfin::Cell::collides "
**Overloaded versions**

* collides\ (point)

  Check whether given point collides with cell
  
  *Arguments*
      point (:py:class:`Point`)
          The point to be checked.
  
  *Returns*
      bool
          True iff point collides with cell.

* collides\ (entity)

  Check whether given entity collides with cell
  
  *Arguments*
      entity (:py:class:`MeshEntity`)
          The cell to be checked.
  
  *Returns*
      bool
          True iff entity collides with cell.
";

%feature("docstring")  dolfin::Cell::triangulate_intersection "
Compute triangulation of intersection with given entity

*Arguments*
    entity (:py:class:`MeshEntity`)
        The entity with which to intersect.

*Returns*
    numpy.array(float)
        A flattened array of simplices of dimension
        num_simplices x num_vertices x gdim =
        num_simplices x (tdim + 1) x gdim
";

%feature("docstring")  dolfin::Cell::get_vertex_coordinates "
Get cell vertex coordinates
";

%feature("docstring")  dolfin::Cell::get_cell_data "
Fill UFC cell with miscellaneous data
";

%feature("docstring")  dolfin::Cell::get_cell_topology "
Fill UFC cell with topology data
";

%feature("docstring")  dolfin::CellFunction "
A CellFunction is a MeshFunction of topological codimension 0.
";

// Documentation extracted from: (module=mesh, header=FacetCell.h)
%feature("docstring")  dolfin::FacetCell "
This class represents a cell in a mesh incident to a facet on
the boundary. It is useful in cases where one needs to iterate
over a boundary mesh and access the corresponding cells in the
original mesh.
";

%feature("docstring")  dolfin::FacetCell::FacetCell "
Create cell on mesh corresponding to given facet (cell) on boundary
";

%feature("docstring")  dolfin::FacetCell::facet_index "
Return local index of facet with respect to the cell
";

// Documentation extracted from: (module=mesh, header=MeshConnectivity.h)
%feature("docstring")  dolfin::MeshConnectivity "
Mesh connectivity stores a sparse data structure of connections
(incidence relations) between mesh entities for a fixed pair of
topological dimensions.

The connectivity can be specified either by first giving the
number of entities and the number of connections for each entity,
which may either be equal for all entities or different, or by
giving the entire (sparse) connectivity pattern.
";

%feature("docstring")  dolfin::MeshConnectivity::MeshConnectivity "
**Overloaded versions**

* MeshConnectivity\ (d0, d1)

  Create empty connectivity between given dimensions (d0 -- d1)

* MeshConnectivity\ (connectivity)

  Copy constructor
";

%feature("docstring")  dolfin::MeshConnectivity::operator= "
Assignment
";

%feature("docstring")  dolfin::MeshConnectivity::empty "
Return true if the total number of connections is equal to zero
";

%feature("docstring")  dolfin::MeshConnectivity::size "
**Overloaded versions**

* size\ ()

  Return total number of connections

* size\ (entity)

  Return number of connections for given entity
";

%feature("docstring")  dolfin::MeshConnectivity::size_global "
Return global number of connections for given entity
";

%feature("docstring")  dolfin::MeshConnectivity::operator "
**Overloaded versions**

* operator\ (entity)

  Return array of connections for given entity

* operator\ ()

  Return contiguous array of connections for all entities
";

%feature("docstring")  dolfin::MeshConnectivity::clear "
Clear all data
";

%feature("docstring")  dolfin::MeshConnectivity::init "
**Overloaded versions**

* init\ (num_entities, num_connections)

  Initialize number of entities and number of connections (equal
  for all)

* init\ (num_connections)

  Initialize number of entities and number of connections
  (individually)
";

%feature("docstring")  dolfin::MeshConnectivity::set "
**Overloaded versions**

* set\ (entity, connection, pos)

  Set given connection for given entity

* set\ (entity, connections)

  Set all connections for given entity

* set\ (entity, connections)

  Set all connections for given entity

* set\ (connections)

  Set all connections for all entities (T is a container, e.g.
  a std::vector<std::size_t>, std::set<std::size_t>, etc)
";

%feature("docstring")  dolfin::MeshConnectivity::set_global_size "
Set global number of connections for all local entities
";

%feature("docstring")  dolfin::MeshConnectivity::hash "
Hash of connections
";

%feature("docstring")  dolfin::MeshConnectivity::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=mesh, header=MeshEditor.h)
%feature("docstring")  dolfin::MeshEditor "
A simple mesh editor for creating simplicial meshes in 1D, 2D
and 3D.
";

%feature("docstring")  dolfin::MeshEditor::MeshEditor "
Constructor
";

%feature("docstring")  dolfin::MeshEditor::open "
**Overloaded versions**

* open\ (mesh, tdim, gdim)

  Open mesh of given topological and geometrical dimension
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh to open.
      tdim (int)
          The topological dimension.
      gdim (int)
          The geometrical dimension.
  
  *Example*
      .. note::
      
          No example code available for this function.

* open\ (mesh, type, tdim, gdim)

  Open mesh of given cell type, topological and geometrical dimension
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh to open.
      type (CellType::Type)
          Cell type.
      tdim (int)
          The topological dimension.
      gdim (int)
          The geometrical dimension.

* open\ (mesh, type, tdim, gdim)

  Open mesh of given cell type, topological and geometrical dimension
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh to open.
      type (str)
          Cell type.
      tdim (int)
          The topological dimension.
      gdim (int)
          The geometrical dimension.
";

%feature("docstring")  dolfin::MeshEditor::init_vertices "
Specify number of vertices (serial version)

*Arguments*
    num_vertices (int)
        The number of vertices.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::MeshEditor::init_vertices_global "
Specify number of vertices (distributed version)

*Arguments*
    num_local_vertices (int)
        The number of vertices on this process.
    num_global_vertices (int)
        The number of vertices in distributed mesh.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::MeshEditor::init_cells "
Specify number of cells (serial version)

*Arguments*
    num_cells (int)
        The number of cells.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::MeshEditor::init_cells_global "
Specify number of cells (distributed version)

*Arguments*
    num_local_cells (int)
        The number of local cells.
    num_global_cells (int)
        The number of cells in distributed mesh.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::MeshEditor::add_vertex "
**Overloaded versions**

* add_vertex\ (index, p)

  Add vertex v at given point p
  
  *Arguments*
      index (int)
          The vertex (index).
      p (:py:class:`Point`)
          The point.

* add_vertex\ (index, x)

  Add vertex v at given coordinate x
  
  *Arguments*
      index (int)
          The vertex (index).
      x (numpy.array(float))
          The x-coordinates.

* add_vertex\ (index, x)

  Add vertex v at given point x (for a 1D mesh)
  
  *Arguments*
      index (int)
          The vertex (index).
      x (float)
          The x-coordinate.

* add_vertex\ (index, x, y)

  Add vertex v at given point (x, y) (for a 2D mesh)
  
  *Arguments*
      index (int)
          The vertex (index).
      x (float)
          The x-coordinate.
      y (float)
          The y-coordinate.

* add_vertex\ (index, x, y, z)

  Add vertex v at given point (x, y, z) (for a 3D mesh)
  
  *Arguments*
      index (int)
          The vertex (index).
      x (float)
          The x-coordinate.
      y (float)
          The y-coordinate.
      z (float)
          The z-coordinate.
";

%feature("docstring")  dolfin::MeshEditor::add_vertex_global "
**Overloaded versions**

* add_vertex_global\ (local_index, global_index, p)

  Add vertex v at given point p
  
  *Arguments*
      local_index (int)
          The vertex (local index).
      global_index (int)
          The vertex (global_index).
      p (:py:class:`Point`)
          The point.

* add_vertex_global\ (local_index, global_index, x)

  Add vertex v at given coordinate x
  
  *Arguments*
      local_index (int)
          The vertex (local index).
      global_index (int)
          The vertex (global_index).
      x (numpy.array(float))
          The x-coordinates.
";

%feature("docstring")  dolfin::MeshEditor::add_cell "
**Overloaded versions**

* add_cell\ (c, v0, v1)

  Add cell with given vertices (1D)
  
  *Arguments*
      c (int)
          The cell (index).
      v0 (numpy.array(int))
          The first vertex (local index).
      v1 (numpy.array(int))
          The second vertex (local index).

* add_cell\ (c, v0, v1, v2)

  Add cell with given vertices (2D)
  
  *Arguments*
      c (int)
          The cell (index).
      v0 (numpy.array(int))
          The first vertex (local index).
      v1 (numpy.array(int))
          The second vertex (local index).
      v2 (numpy.array(int))
          The third vertex (local index).

* add_cell\ (c, v0, v1, v2, v3)

  Add cell with given vertices (3D)
  
  *Arguments*
      c (int)
          The cell (index).
      v0 (numpy.array(int))
          The first vertex (local index).
      v1 (numpy.array(int))
          The second vertex (local index).
      v2 (numpy.array(int))
          The third vertex (local index).
      v3 (numpy.array(int))
          The fourth vertex (local index).

* add_cell\ (c, v)

  Add cell with given vertices
  
  *Arguments*
      c (int)
          The cell (index).
      v (numpy.array(int))
          The vertex indices (local indices)

* add_cell\ (local_index, global_index, v)

  Add cell with given vertices
  
  *Arguments*
      local_index (int)
          The cell (index).
      global_index (int)
          The global (user) cell index.
      v (numpy.array(int))
          The vertex indices (local indices)
";

%feature("docstring")  dolfin::MeshEditor::close "
Close mesh, finish editing, and order entities locally

*Arguments*
    order (bool)
        Order entities locally if true. Default values is true.

*Example*
    .. note::
    
        No example code available for this function.
";

// Documentation extracted from: (module=mesh, header=DynamicMeshEditor.h)
%feature("docstring")  dolfin::DynamicMeshEditor "
This class provides an interface for dynamic editing of meshes,
that is, when the number of vertices and cells are not known
a priori. If the number of vertices and cells are known a priori,
it is more efficient to use the default editor MeshEditor.
";

%feature("docstring")  dolfin::DynamicMeshEditor::DynamicMeshEditor "
Constructor
";

%feature("docstring")  dolfin::DynamicMeshEditor::open "
**Overloaded versions**

* open\ (mesh, type, tdim, gdim, num_global_vertices, num_global_cells)

  Open mesh of given cell type, topological and geometrical dimension

* open\ (mesh, type, tdim, gdim, num_global_vertices, num_global_cells)

  Open mesh of given cell type, topological and geometrical dimension
";

%feature("docstring")  dolfin::DynamicMeshEditor::add_vertex "
**Overloaded versions**

* add_vertex\ (v, p)

  Add vertex v at given point p

* add_vertex\ (v, x)

  Add vertex v at given coordinate x

* add_vertex\ (v, x, y)

  Add vertex v at given coordinate (x, y)

* add_vertex\ (v, x, y, z)

  Add vertex v at given coordinate (x, y, z)
";

%feature("docstring")  dolfin::DynamicMeshEditor::add_cell "
**Overloaded versions**

* add_cell\ (c, v)

  Add cell with given vertices

* add_cell\ (c, v0, v1)

  Add cell (interval) with given vertices

* add_cell\ (c, v0, v1, v2)

  Add cell (triangle) with given vertices

* add_cell\ (c, v0, v1, v2, v3)

  Add cell (tetrahedron) with given vertices
";

%feature("docstring")  dolfin::DynamicMeshEditor::close "
Close mesh, finish editing, and order entities locally
";

// Documentation extracted from: (module=mesh, header=LocalMeshValueCollection.h)
%feature("docstring")  dolfin::LocalMeshValueCollection "
This class stores mesh data on a local processor corresponding
to a portion of a MeshValueCollection.
";

%feature("docstring")  dolfin::LocalMeshValueCollection::LocalMeshValueCollection "
Create local mesh data for given LocalMeshValueCollection
";

%feature("docstring")  dolfin::LocalMeshValueCollection::dim "
Return dimension of cell entity
";

%feature("docstring")  dolfin::LocalMeshValueCollection::values "
Return data
";

// Documentation extracted from: (module=mesh, header=MeshFunction.h)
%feature("docstring")  dolfin::MeshFunction "
A MeshFunction is a function that can be evaluated at a set of
mesh entities. A MeshFunction is discrete and is only defined
at the set of mesh entities of a fixed topological dimension.
A MeshFunction may for example be used to store a global
numbering scheme for the entities of a (parallel) mesh, marking
sub domains or boolean markers for mesh refinement.
";

%feature("docstring")  dolfin::MeshFunction::MeshFunction "
**Overloaded versions**

* MeshFunction\ ()

  Create empty mesh function

* MeshFunction\ (mesh)

  Create empty mesh function on given mesh
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh to create mesh function on.

* MeshFunction\ (mesh)

  Create empty mesh function on given mesh (shared_ptr version)
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh to create mesh function on.

* MeshFunction\ (mesh, dim)

  Create mesh function of given dimension on given mesh
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh to create mesh function on.
      dim (int)
          The mesh entity dimension for the mesh function.

* MeshFunction\ (mesh, dim)

  Create mesh function of given dimension on given mesh
  (shared_ptr version)
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh to create mesh function on.
      dim (int)
          The mesh entity dimension for the mesh function.

* MeshFunction\ (mesh, dim, value)

  Create mesh of given dimension on given mesh and initialize
  to a value
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh to create mesh function on.
      dim (int)
          The mesh entity dimension.
      value (T)
          The value.

* MeshFunction\ (mesh, dim, value)

  Create mesh of given dimension on given mesh and initialize
  to a value (shared_ptr version)
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh to create mesh function on.
      dim (int)
          The mesh entity dimension.
      value (T)
          The value.

* MeshFunction\ (mesh, filename)

  Create function from data file
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh to create mesh function on.
      filename (str)
          The filename to create mesh function from.

* MeshFunction\ (mesh, filename)

  Create function from data file (shared_ptr version)
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh to create mesh function on.
      filename (str)
          The filename to create mesh function from.

* MeshFunction\ (mesh, value_collection)

  Create function from a MeshValueCollecion
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh to create mesh function on.
      value_collection (:py:class:`MeshValueCollection`)
          The mesh value collection for the mesh function data.

* MeshFunction\ (mesh, value_collection)

  Create function from a MeshValueCollecion (shared_ptr version)
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh to create mesh function on.
      value_collection (:py:class:`MeshValueCollection`)
          The mesh value collection for the mesh function data.

* MeshFunction\ (mesh, dim, domains)

  Create function from MeshDomains
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh to create mesh function on.
      dim (int)
          The dimension of the MeshFunction
      domains (:py:class:`MeshDomains`)
          The domains from which to extratc the domain markers

* MeshFunction\ (f)

  Copy constructor
  
  *Arguments*
      f (:py:class:`MeshFunction`)
          The object to be copied.
";

%feature("docstring")  dolfin::MeshFunction::operator= "
**Overloaded versions**

* operator=\ (f)

  Assign mesh function to other mesh function
  Assignment operator
  
  *Arguments*
      f (:py:class:`MeshFunction`)
          A :py:class:`MeshFunction` object to asssign to another MeshFunction.

* operator=\ (mesh)

  Assignment operator
  
  *Arguments*
      mesh (:py:class:`MeshValueCollection`)
          A :py:class:`MeshValueCollection` object used to construct a MeshFunction.

* operator=\ (value)

  Set all values to given value
";

%feature("docstring")  dolfin::MeshFunction::mesh "
Return mesh associated with mesh function

*Returns*
    :py:class:`Mesh`
        The mesh.
";

%feature("docstring")  dolfin::MeshFunction::dim "
Return topological dimension

*Returns*
    int
        The dimension.
";

%feature("docstring")  dolfin::MeshFunction::empty "
Return true if empty

*Returns*
    bool
        True if empty.
";

%feature("docstring")  dolfin::MeshFunction::size "
Return size (number of entities)

*Returns*
    int
        The size.
";

%feature("docstring")  dolfin::MeshFunction::values "
**Overloaded versions**

* values\ ()

  Return array of values (const. version)
  
  *Returns*
      T
          The values.

* values\ ()

  Return array of values
  
  *Returns*
      T
          The values.
";

%feature("docstring")  dolfin::MeshFunction::operator[] "
**Overloaded versions**

* operator[]\ (entity)

  Return value at given mesh entity
  
  *Arguments*
      entity (:py:class:`MeshEntity`)
          The mesh entity.
  
  *Returns*
      T
          The value at the given entity.

* operator[]\ (entity)

  Return value at given mesh entity (const version)
  
  *Arguments*
      entity (:py:class:`MeshEntity`)
          The mesh entity.
  
  *Returns*
      T
          The value at the given entity.

* operator[]\ (index)

  Return value at given index
  
  *Arguments*
      index (int)
          The index.
  
  *Returns*
      T
          The value at the given index.

* operator[]\ (index)

  Return value at given index  (const version)
  
  *Arguments*
      index (int)
          The index.
  
  *Returns*
      T
          The value at the given index.
";

%feature("docstring")  dolfin::MeshFunction::init "
**Overloaded versions**

* init\ (dim)

  Initialize mesh function for given topological dimension
  
  *Arguments*
      dim (int)
          The dimension.

* init\ (dim, size)

  Initialize mesh function for given topological dimension of
  given size
  
  *Arguments*
      dim (int)
          The dimension.
      size (int)
          The size.

* init\ (mesh, dim)

  Initialize mesh function for given topological dimension
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh.
      dim (int)
          The dimension.

* init\ (mesh, dim)

  Initialize mesh function for given topological dimension
  (shared_ptr version)
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh.
      dim (int)
          The dimension.

* init\ (mesh, dim, size)

  Initialize mesh function for given topological dimension of
  given size
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh.
      dim (int)
          The dimension.
      size (int)
          The size.

* init\ (mesh, dim, size)

  Initialize mesh function for given topological dimension of
  given size (shared_ptr version)
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh.
      dim (int)
          The dimension.
      size (int)
          The size.
";

%feature("docstring")  dolfin::MeshFunction::set_value "
**Overloaded versions**

* set_value\ (index, value)

  Set value at given index
  
  *Arguments*
      index (int)
          The index.
      value (T)
          The value.

* set_value\ (index, value, mesh)

  Compatibility function for use in SubDomains
";

%feature("docstring")  dolfin::MeshFunction::set_values "
Set values

*Arguments*
    values (std::vector<T>)
        The values.
";

%feature("docstring")  dolfin::MeshFunction::set_all "
Set all values to given value

*Arguments*
    value (T)
        The value to set all values to.
";

%feature("docstring")  dolfin::MeshFunction::str "
Return informal string representation (pretty-print)

*Arguments*
    verbose (bool)
        Flag to turn on additional output.

*Returns*
    str
        An informal representation.
";

// Documentation extracted from: (module=mesh, header=MeshValueCollection.h)
%feature("docstring")  dolfin::MeshValueCollection "
The MeshValueCollection class can be used to store data
associated with a subset of the entities of a mesh of a given
topological dimension. It differs from the MeshFunction class in
two ways. First, data does not need to be associated with all
entities (only a subset). Second, data is associated with
entities through the corresponding cell index and local entity
number (relative to the cell), not by global entity index, which
means that data may be stored robustly to file.
";

%feature("docstring")  dolfin::MeshValueCollection::MeshValueCollection "
**Overloaded versions**

* MeshValueCollection\ ()

  Create empty mesh value collection
  

* MeshValueCollection\ (mesh)

  Create an empty mesh value collection on a given mesh
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh.

* MeshValueCollection\ (mesh_function)

  Create a mesh value collection from a MeshFunction
  
  *Arguments*
      mesh_function (:py:class:`MeshFunction`)
          The mesh function for creating a MeshValueCollection.

* MeshValueCollection\ (mesh, dim)

  Create a mesh value collection of entities of given dimension
  on a given mesh
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh associated with the collection.
      dim (int)
          The mesh entity dimension for the mesh value collection.

* MeshValueCollection\ (mesh, dim)

  Create a mesh value collection of entities of given dimension
  on a given mesh (shared_ptr version)
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh associated with the collection.
      dim (int)
          The mesh entity dimension for the mesh value collection.

* MeshValueCollection\ (mesh, filename)

  Create a mesh value collection from a file.
  
  *Arguments*
      mesh (Mesh)
          A mesh associated with the collection. The mesh is used to
          map collection values to the appropriate process.
      filename (str)
          The XML file name.
      dim (int)
          The mesh entity dimension for the mesh value collection.
";

%feature("docstring")  dolfin::MeshValueCollection::operator= "
**Overloaded versions**

* operator=\ (mesh_function)

  Assignment operator
  
  *Arguments*
      mesh_function (:py:class:`MeshFunction`)
          A :py:class:`MeshFunction` object used to construct a
          MeshValueCollection.

* operator=\ (mesh_value_collection)

  Assignment operator
  
  *Arguments*
      mesh_value_collection (:py:class:`MeshValueCollection`)
          A :py:class:`MeshValueCollection` object used to construct a
          MeshValueCollection.
";

%feature("docstring")  dolfin::MeshValueCollection::init "
**Overloaded versions**

* init\ (mesh, dim)

  Initialise MeshValueCollection wirth mesh and dimension
  
  *Arguments*
      mesh (_mesh)
          The mesh on which the value collection is defined
      dim (int)
          The mesh entity dimension for the mesh value collection.

* init\ (mesh, dim)

  Initialise MeshValueCollection wirth mesh and dimension
  (shared_ptr version)
  
  *Arguments*
      mesh (_mesh)
          The mesh on which the value collection is defined
      dim (int)
          The mesh entity dimension for the mesh value collection.

* init\ (dim)

  Set dimension. This function should not generally be used. It is
  for reading MeshValueCollections as the dimension is not
  generally known at construction.
  
  *Arguments*
      dim (int)
          The mesh entity dimension for the mesh value collection.
";

%feature("docstring")  dolfin::MeshValueCollection::dim "
Return topological dimension

*Returns*
    int
        The dimension.
";

%feature("docstring")  dolfin::MeshValueCollection::mesh "
Return associated mesh

*Returns*
    :py:class:`Mesh`
        The mesh.
";

%feature("docstring")  dolfin::MeshValueCollection::empty "
Return true if the subset is empty

*Returns*
    bool
        True if the subset is empty.
";

%feature("docstring")  dolfin::MeshValueCollection::size "
Return size (number of entities in subset)

*Returns*
    int
        The size.
";

%feature("docstring")  dolfin::MeshValueCollection::set_value "
**Overloaded versions**

* set_value\ (cell_index, local_entity, value)

  Set marker value for given entity defined by a cell index and
  a local entity index
  
  *Arguments*
      cell_index (int)
          The index of the cell.
      local_entity (int)
          The local index of the entity relative to the cell.
      marker_value (T)
          The value of the marker.
  
  *Returns*
      bool
          True is a new value is inserted, false if overwriting
          an existing value.

* set_value\ (entity_index, value)

  Set value for given entity index
  
  *Arguments*
      entity_index (int)
          Index of the entity.
      value (T)
          The value of the marker.
      mesh (:py:class:`Mesh`)
          The mesh.
  
  *Returns*
      bool
          True is a new value is inserted, false if overwriting
          an existing value.
";

%feature("docstring")  dolfin::MeshValueCollection::get_value "
Get marker value for given entity defined by a cell index and
a local entity index

*Arguments*
    cell_index (int)
        The index of the cell.
    local_entity (int)
        The local index of the entity relative to the cell.

*Returns*
    marker_value (T)
        The value of the marker.
";

%feature("docstring")  dolfin::MeshValueCollection::values "
**Overloaded versions**

* values\ ()

  Get all values
  
  *Returns*
      std::map<std::pair<std::size_t, std::size_t>, T>
          A map from positions to values.

* values\ ()

  Get all values (const version)
  
  *Returns*
      std::map<std::pair<std::size_t, std::size_t>, T>
          A map from positions to values.
";

%feature("docstring")  dolfin::MeshValueCollection::clear "
Clear all values
";

%feature("docstring")  dolfin::MeshValueCollection::str "
Return informal string representation (pretty-print)

*Arguments*
    verbose (bool)
        Flag to turn on additional output.

*Returns*
    str
        An informal representation.
";

// Documentation extracted from: (module=mesh, header=MeshColoring.h)
%feature("docstring")  dolfin::MeshColoring "
This class computes colorings for a local mesh. It supports
vertex, edge, and facet-based colorings.
";

%feature("docstring")  dolfin::MeshColoring::color_cells "
Color the cells of a mesh for given coloring type, which can
be one of \"vertex\", \"edge\" or \"facet\". Coloring is saved in the
mesh topology
";

%feature("docstring")  dolfin::MeshColoring::color "
Color the cells of a mesh for given coloring type specified by
topological dimension, which can be one of 0, 1 or D - 1. Coloring
is saved in the mesh topology
";

%feature("docstring")  dolfin::MeshColoring::compute_colors "
Compute cell colors for given coloring type specified by
topological dimension, which can be one of 0, 1 or D - 1.
";

%feature("docstring")  dolfin::MeshColoring::cell_colors "
**Overloaded versions**

* cell_colors\ (mesh, coloring_type)

  Return a MeshFunction with the cell colors (used for visualisation)

* cell_colors\ (mesh, coloring_type)

  Return a MeshFunction with the cell colors (used for visualisation)
";

%feature("docstring")  dolfin::MeshColoring::type_to_dim "
Convert coloring type to topological dimension
";

// Documentation extracted from: (module=mesh, header=MeshRenumbering.h)
%feature("docstring")  dolfin::MeshRenumbering "
This class implements renumbering algorithms for meshes.
";

// Documentation extracted from: (module=mesh, header=MeshTransformation.h)
%feature("docstring")  dolfin::MeshTransformation "
This class implements various transformations of the coordinates
of a mesh.
";

%feature("docstring")  dolfin::MeshTransformation::translate "
Translate mesh according to a given vector.

*Arguments*
    mesh (:py:class:`Mesh`)
        The mesh
    point (Point)
        The vector defining the translation.
";

%feature("docstring")  dolfin::MeshTransformation::rotate "
**Overloaded versions**

* rotate\ (mesh, angle, axis)

  Rotate mesh around a coordinate axis through center of mass
  of all mesh vertices
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh.
      angle (float)
          The number of degrees (0-360) of rotation.
      axis (int)
          The coordinate axis around which to rotate the mesh.

* rotate\ (mesh, angle, axis, p)

  Rotate mesh around a coordinate axis through a given point
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh.
      angle (float)
          The number of degrees (0-360) of rotation.
      axis (int)
          The coordinate axis around which to rotate the mesh.
      point (:py:class:`Point`)
          The point around which to rotate the mesh.
";

// Documentation extracted from: (module=mesh, header=LocalMeshData.h)
%feature("docstring")  dolfin::LocalMeshData "
This class stores mesh data on a local processor corresponding
to a portion of a (larger) global mesh.

Note that the data stored in this class does typically not
correspond to a topologically connected mesh; it merely stores a
list of vertex coordinates, a list of cell-vertex mappings and a
list of global vertex numbers for the locally stored vertices.

It is typically used for parsing meshes in parallel from mesh
XML files. After local mesh data has been parsed on each
processor, a subsequent repartitioning takes place: first a
geometric partitioning of the vertices followed by a
redistribution of vertex and cell data, and then a topological
partitioning again followed by redistribution of vertex and cell
data, at that point corresponding to topologically connected
meshes instead of local mesh data.
";

%feature("docstring")  dolfin::LocalMeshData::LocalMeshData "
**Overloaded versions**

* LocalMeshData\ (mpi_comm)

  Create empty local mesh data

* LocalMeshData\ (mesh)

  Create local mesh data for given mesh
";

%feature("docstring")  dolfin::LocalMeshData::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=mesh, header=SubDomain.h)
%feature("docstring")  dolfin::SubDomain "
This class defines the interface for definition of subdomains.
Alternatively, subdomains may be defined by a :py:class:`Mesh` and a
:py:class:`MeshFunction` <std::size_t> over the mesh.
";

%feature("docstring")  dolfin::SubDomain::SubDomain "
Constructor

*Arguments*
    map_tol (float)
        The tolerance used when identifying mapped points using
        the function SubDomain::map.
";

%feature("docstring")  dolfin::SubDomain::inside "
Return true for points inside the subdomain

*Arguments*
    x (numpy.array(float))
        The coordinates of the point.
    on_boundary (bool)
        True for points on the boundary.

*Returns*
    bool
        True for points inside the subdomain.
";

%feature("docstring")  dolfin::SubDomain::map "
Map coordinate x in domain H to coordinate y in domain G (used for
periodic boundary conditions)

*Arguments*
    x (numpy.array(float))
        The coordinates in domain H.
    y (numpy.array(float))
        The coordinates in domain G.
";

%feature("docstring")  dolfin::SubDomain::snap "
Snap coordinate to boundary of subdomain

*Arguments*
    x (numpy.array(float))
        The coordinates.
";

%feature("docstring")  dolfin::SubDomain::mark_cells "
Set subdomain markers (std::size_t) on cells for given subdomain number

*Arguments*
    mesh (:py:class:`Mesh`)
        The mesh to be marked.
    sub_domain (int)
        The subdomain number.
    check_midpoint (bool)
        Flag for whether midpoint of cell should be checked (default).
";

%feature("docstring")  dolfin::SubDomain::mark_facets "
Set subdomain markers (std::size_t) on facets for given subdomain number

*Arguments*
    mesh (:py:class:`Mesh`)
        The mesh to be marked.
    sub_domain (int)
        The subdomain number.
    check_midpoint (bool)
        Flag for whether midpoint of cell should be checked (default).
";

%feature("docstring")  dolfin::SubDomain::mark "
**Overloaded versions**

* mark\ (mesh, dim, sub_domain, check_midpoint=true)

  Set subdomain markers (std::size_t) for given topological dimension
  and subdomain number
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh to be marked.
      dim (int)
          The topological dimension of entities to be marked.
      sub_domain (int)
          The subdomain number.
      check_midpoint (bool)
          Flag for whether midpoint of cell should be checked (default).

* mark\ (sub_domains, sub_domain, check_midpoint=true)

  Set subdomain markers (std::size_t) for given subdomain number
  
  *Arguments*
      sub_domains (:py:class:`MeshFunction`)
          The subdomain markers.
      sub_domain (int)
          The subdomain number.
      check_midpoint (bool)
          Flag for whether midpoint of cell should be checked (default).

* mark\ (sub_domains, sub_domain, check_midpoint=true)

  Set subdomain markers (int) for given subdomain number
  
  *Arguments*
      sub_domains (:py:class:`MeshFunction`)
          The subdomain markers.
      sub_domain (int)
          The subdomain number.
      check_midpoint (bool)
          Flag for whether midpoint of cell should be checked (default).

* mark\ (sub_domains, sub_domain, check_midpoint=true)

  Set subdomain markers (double) for given subdomain number
  
  *Arguments*
      sub_domains (:py:class:`MeshFunction`)
          The subdomain markers.
      sub_domain (float)
          The subdomain number.
      check_midpoint (bool)
          Flag for whether midpoint of cell should be checked (default).

* mark\ (sub_domains, sub_domain, check_midpoint=true)

  Set subdomain markers (bool) for given subdomain
  
  *Arguments*
      sub_domains (:py:class:`MeshFunction`)
          The subdomain markers.
      sub_domain (bool)
          The subdomain number.
      check_midpoint (bool)
          Flag for whether midpoint of cell should be checked (default).

* mark\ (sub_domains, sub_domain, mesh, check_midpoint=true)

  Set subdomain markers (std::size_t) for given subdomain number
  
  *Arguments*
      sub_domains (:py:class:`MeshValueCollection`)
          The subdomain markers.
      sub_domain (int)
          The subdomain number.
      mesn (:py:class:`Mesh`)
          The mesh.
      check_midpoint (bool)
          Flag for whether midpoint of cell should be checked (default).

* mark\ (sub_domains, sub_domain, mesh, check_midpoint=true)

  Set subdomain markers (int) for given subdomain number
  
  *Arguments*
      sub_domains (:py:class:`MeshValueCollection`)
          The subdomain markers
      sub_domain (int)
          The subdomain number
      check_midpoint (bool)
          Flag for whether midpoint of cell should be checked (default).

* mark\ (sub_domains, sub_domain, mesh, check_midpoint=true)

  Set subdomain markers (double) for given subdomain number
  
  *Arguments*
      sub_domains (:py:class:`MeshValueCollection`)
          The subdomain markers.
      sub_domain (float)
          The subdomain number
      check_midpoint (bool)
          Flag for whether midpoint of cell should be checked (default).

* mark\ (sub_domains, sub_domain, mesh, check_midpoint=true)

  Set subdomain markers (bool) for given subdomain
  
  *Arguments*
      sub_domains (:py:class:`MeshValueCollection`)
          The subdomain markers
      sub_domain (bool)
          The subdomain number
      check_midpoint (bool)
          Flag for whether midpoint of cell should be checked (default).
";

%feature("docstring")  dolfin::SubDomain::geometric_dimension "
Return geometric dimension

*Returns*
    int
        The geometric dimension.
";

%feature("docstring")  dolfin::SubDomain::apply_markers "
Apply marker of type T (most likely an std::size_t) to object of class
S (most likely MeshFunction or MeshValueCollection)
";

// Documentation extracted from: (module=mesh, header=SubMesh.h)
%feature("docstring")  dolfin::SubMesh "
A SubMesh is a mesh defined as a subset of a given mesh. It
provides a convenient way to create matching meshes for
multiphysics applications by creating meshes for subdomains as
subsets of a single global mesh. A mapping from the vertices of
the sub mesh to the vertices of the parent mesh is stored as the
mesh data named \"parent_vertex_indices\".
";

%feature("docstring")  dolfin::SubMesh::SubMesh "
**Overloaded versions**

* SubMesh\ (mesh, sub_domain)

  Create subset of given mesh marked by sub domain

* SubMesh\ (mesh, sub_domains, sub_domain)

  Create subset of given mesh marked by mesh function

* SubMesh\ (mesh, sub_domain)

  Create subset of given mesh from stored MeshValueCollection
";

%feature("docstring")  dolfin::SubMesh::init "
Create sub mesh
";

// Documentation extracted from: (module=mesh, header=Restriction.h)
%feature("docstring")  dolfin::Restriction "
This class represents a restriction of a mesh to a subdomain,
which can be defined as a subset of all the cells, the facets,
or possibly lower dimensional entities of the mesh.
";

%feature("docstring")  dolfin::Restriction::Restriction "
**Overloaded versions**

* Restriction\ (mesh, sub_domain)

  Create cell-based restriction from subdomain
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh
      sub_domain (:py:class:`SubDomain`)
          Sub domain defining the restriction

* Restriction\ (mesh, sub_domain, dim)

  Create restriction from subdomain to entities of arbitrary dimension
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh
      sub_domain (:py:class:`SubDomain`)
          Sub domain defining the restriction
      dim (int)
          Dimension of restriction

* Restriction\ (domain_markers, domain_number)

  Create restriction from domain markers
  
  *Arguments*
      domain_markers (:py:class:`MeshFunction`)
          Domain markers for the cells of the mesh.
      domain_number (int)
          Identifier for domain.

* Restriction\ (domain_markers, domain_number)

  Create restriction from domain markers (shared pointer version)
  
  *Arguments*
      domain_markers (:py:class:`MeshFunction`)
          Domain markers for the cells of the mesh.
      domain_number (int)
          Identifier for domain.
";

%feature("docstring")  dolfin::Restriction::mesh "
Return the full unrestricted mesh
";

%feature("docstring")  dolfin::Restriction::dim "
Return topological dimension of restriction
";

%feature("docstring")  dolfin::Restriction::contains "
**Overloaded versions**

* contains\ (entity)

  Check whether restriction contains entity

* contains\ (d, i)

  Check whether restriction contains entity (d, i)
";

// Documentation extracted from: (module=mesh, header=DomainBoundary.h)
%feature("docstring")  dolfin::DomainBoundary "
This class provides a SubDomain which picks out the boundary of
a mesh, and provides a convenient way to specify boundary
conditions on the entire boundary of a mesh.
";

%feature("docstring")  dolfin::DomainBoundary::DomainBoundary "
Constructor
";

%feature("docstring")  dolfin::DomainBoundary::inside "
Return true for points on the boundary
";

// Documentation extracted from: (module=mesh, header=BoundaryMesh.h)
%feature("docstring")  dolfin::BoundaryMesh "
A BoundaryMesh is a mesh over the boundary of some given mesh.
The cells of the boundary mesh (facets of the original mesh) are
oriented to produce outward pointing normals relative to the
original mesh.
";

%feature("docstring")  dolfin::BoundaryMesh::BoundaryMesh "
Create boundary mesh from given mesh.

*Arguments*
    mesh (:py:class:`Mesh`)
        Another :py:class:`Mesh` object.
    type (_std::string_)
        The type of BoundaryMesh, which can be \"exterior\",
        \"interior\" or \"local\". \"exterior\" is the globally
        external boundary, \"interior\" is the inter-process mesh
        and \"local\" is the boudary of the local (this process)
        mesh.
    order (bool)
        Optional argument which can be used to control whether
        or not the boundary mesh should be ordered according
        to the UFC ordering convention. If set to false, the
        boundary mesh will be ordered with right-oriented
        facets (outward-pointing unit normals). The default
        value is true.
";

%feature("docstring")  dolfin::BoundaryMesh::entity_map "
**Overloaded versions**

* entity_map\ (d)

  Get index map for entities of dimension d in the boundary mesh
  to the entity in the original full mesh

* entity_map\ (d)

  Get index map for entities of dimension d in the boundary mesh
  to the entity in the original full mesh (const version)
";

// Documentation extracted from: (module=mesh, header=PeriodicBoundaryComputation.h)
%feature("docstring")  dolfin::PeriodicBoundaryComputation "
This class computes map from slave entity to master entity
";

%feature("docstring")  dolfin::PeriodicBoundaryComputation::compute_periodic_pairs "
For entities of dimension dim, compute map from a slave entity
on this process (local index) to its master entity (owning
process, local index on owner). If a master entity is shared
by processes, only one of the owning processes is returned.
";

%feature("docstring")  dolfin::PeriodicBoundaryComputation::masters_slaves "
This function returns a MeshFunction which marks mesh entities
of dimension dim according to:

    2: slave entities
    1: master entities
    0: all other entities

It is useful for visualising and debugging the Expression::map
function that is used to apply periodic boundary conditions.
";

// Documentation extracted from: (module=mesh, header=MeshQuality.h)
%feature("docstring")  dolfin::MeshQuality "
The class provides functions to quantify mesh quality
";

%feature("docstring")  dolfin::MeshQuality::radius_ratios "
Compute the radius ratio for all cells.

*Returns*
    CellFunction<double>
        The cell radius ratio radius ratio geometric_dimension *
        * inradius / circumradius (geometric_dimension
        is normalization factor). It has range zero to one.
        Zero indicates a degenerate element.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::MeshQuality::radius_ratio_min_max "
Compute the minimum and maximum radius ratio of cells
(across all processes)

*Returns*
    (float, float)
        The [minimum, maximum] cell radii ratio (geometric_dimension *
        * inradius / circumradius, geometric_dimension
        is normalization factor). It has range zero to one.
        Zero indicates a degenerate element.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::MeshQuality::radius_ratio_histogram_data "
Create (ratio, number of cells) data for creating a histogram
of cell quality
";

%feature("docstring")  dolfin::MeshQuality::radius_ratio_matplotlib_histogram "
Create Matplotlib string to plot cell quality histogram
";

