/* WidgetUtils.c generated by valac 0.12.1, the Vala compiler
 * generated from WidgetUtils.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <whacks.h>
#include <libnotify/notify.h>
#include <common.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DEJA_DUP_TYPE_SHELL_ENV (deja_dup_shell_env_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block4Data Block4Data;

typedef enum  {
	DEJA_DUP_SHELL_ENV_NONE,
	DEJA_DUP_SHELL_ENV_GNOME,
	DEJA_DUP_SHELL_ENV_UNITY,
	DEJA_DUP_SHELL_ENV_LEGACY
} DejaDupShellEnv;

struct _Block4Data {
	int _ref_count_;
	GtkWidget* w;
};


extern DejaDupShellEnv deja_dup_shell;
DejaDupShellEnv deja_dup_shell = DEJA_DUP_SHELL_ENV_NONE;

void deja_dup_show_uri (GtkWindow* parent, const gchar* link);
void deja_dup_destroy_widget (GtkWidget* w);
GType deja_dup_shell_env_get_type (void) G_GNUC_CONST;
DejaDupShellEnv deja_dup_get_shell (void);
gboolean deja_dup_user_focused (GtkWidget* win, GdkEventFocus* e);
static gboolean _deja_dup_user_focused_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
void deja_dup_show_background_window_for_shell (GtkWindow* win);
void deja_dup_hide_background_window_for_shell (GtkWindow* win);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static gboolean _lambda0_ (Block4Data* _data4_);
static gboolean __lambda0__gsource_func (gpointer self);
gboolean deja_dup_gui_initialize (GtkWindow* parent, gboolean show_error);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void deja_dup_show_uri (GtkWindow* parent, const gchar* link) {
	GdkScreen* _tmp0_ = NULL;
	GdkScreen* _tmp1_;
	GdkScreen* screen;
	guint32 _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (parent != NULL);
	g_return_if_fail (link != NULL);
	_tmp0_ = gtk_window_get_screen (parent);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	screen = _tmp1_;
	_tmp2_ = gtk_get_current_event_time ();
	gtk_show_uri (screen, link, _tmp2_, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (screen);
		goto __catch6_g_error;
	}
	_g_object_unref0 (screen);
	goto __finally6;
	__catch6_g_error:
	{
		GError * e;
		const gchar* _tmp3_ = NULL;
		GtkMessageDialog* _tmp4_ = NULL;
		GtkMessageDialog* dlg;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = _ ("Could not display %s");
		_tmp4_ = (GtkMessageDialog*) gtk_message_dialog_new (parent, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _tmp3_, link);
		dlg = g_object_ref_sink (_tmp4_);
		gtk_message_dialog_format_secondary_text (dlg, "%s", e->message, NULL);
		gtk_dialog_run ((GtkDialog*) dlg);
		deja_dup_destroy_widget ((GtkWidget*) dlg);
		_g_object_unref0 (dlg);
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


GType deja_dup_shell_env_get_type (void) {
	static volatile gsize deja_dup_shell_env_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_shell_env_type_id__volatile)) {
		static const GEnumValue values[] = {{DEJA_DUP_SHELL_ENV_NONE, "DEJA_DUP_SHELL_ENV_NONE", "none"}, {DEJA_DUP_SHELL_ENV_GNOME, "DEJA_DUP_SHELL_ENV_GNOME", "gnome"}, {DEJA_DUP_SHELL_ENV_UNITY, "DEJA_DUP_SHELL_ENV_UNITY", "unity"}, {DEJA_DUP_SHELL_ENV_LEGACY, "DEJA_DUP_SHELL_ENV_LEGACY", "legacy"}, {0, NULL, NULL}};
		GType deja_dup_shell_env_type_id;
		deja_dup_shell_env_type_id = g_enum_register_static ("DejaDupShellEnv", values);
		g_once_init_leave (&deja_dup_shell_env_type_id__volatile, deja_dup_shell_env_type_id);
	}
	return deja_dup_shell_env_type_id__volatile;
}


DejaDupShellEnv deja_dup_get_shell (void) {
	DejaDupShellEnv result = 0;
	if (deja_dup_shell == DEJA_DUP_SHELL_ENV_NONE) {
		gboolean _tmp0_;
		_tmp0_ = hacks_unity_present ();
		if (_tmp0_) {
			deja_dup_shell = DEJA_DUP_SHELL_ENV_UNITY;
		} else {
			GList* _tmp1_ = NULL;
			GList* caps;
			gboolean persistence;
			gboolean actions;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = notify_get_server_caps ();
			caps = _tmp1_;
			persistence = FALSE;
			actions = FALSE;
			{
				GList* cap_collection;
				GList* cap_it;
				cap_collection = caps;
				for (cap_it = cap_collection; cap_it != NULL; cap_it = cap_it->next) {
					gchar* _tmp2_;
					gchar* cap;
					_tmp2_ = g_strdup ((const gchar*) cap_it->data);
					cap = _tmp2_;
					{
						if (g_strcmp0 (cap, "persistence") == 0) {
							persistence = TRUE;
						} else {
							if (g_strcmp0 (cap, "actions") == 0) {
								actions = TRUE;
							}
						}
						_g_free0 (cap);
					}
				}
			}
			if (persistence) {
				_tmp3_ = actions;
			} else {
				_tmp3_ = FALSE;
			}
			if (_tmp3_) {
				deja_dup_shell = DEJA_DUP_SHELL_ENV_GNOME;
			} else {
				deja_dup_shell = DEJA_DUP_SHELL_ENV_LEGACY;
			}
		}
	}
	result = deja_dup_shell;
	return result;
}


static gboolean _deja_dup_user_focused_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = deja_dup_user_focused (_sender, event);
	return result;
}


gboolean deja_dup_user_focused (GtkWidget* win, GdkEventFocus* e) {
	gboolean result = FALSE;
	guint _tmp0_;
	g_return_val_if_fail (win != NULL, FALSE);
	gtk_window_set_urgency_hint (GTK_WINDOW (win), FALSE);
	g_signal_parse_name ("focus-in-event", GTK_TYPE_WIDGET, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (win, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _deja_dup_user_focused_gtk_widget_focus_in_event, NULL);
	result = FALSE;
	return result;
}


void deja_dup_show_background_window_for_shell (GtkWindow* win) {
	DejaDupShellEnv _tmp0_;
	g_return_if_fail (win != NULL);
	gtk_window_set_focus_on_map (win, FALSE);
	gtk_window_set_urgency_hint (win, TRUE);
	g_signal_connect ((GtkWidget*) win, "focus-in-event", (GCallback) _deja_dup_user_focused_gtk_widget_focus_in_event, NULL);
	_tmp0_ = deja_dup_get_shell ();
	if (_tmp0_ == DEJA_DUP_SHELL_ENV_UNITY) {
		gtk_window_iconify (win);
		gtk_widget_show ((GtkWidget*) win);
		gtk_window_iconify (win);
	} else {
		gtk_widget_show ((GtkWidget*) win);
	}
}


void deja_dup_hide_background_window_for_shell (GtkWindow* win) {
	DejaDupShellEnv _tmp0_;
	g_return_if_fail (win != NULL);
	_tmp0_ = deja_dup_get_shell ();
	if (_tmp0_ == DEJA_DUP_SHELL_ENV_UNITY) {
		gtk_window_iconify (win);
		gtk_widget_show ((GtkWidget*) win);
		gtk_window_iconify (win);
	} else {
		gtk_widget_hide ((GtkWidget*) win);
	}
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->w);
		g_slice_free (Block4Data, _data4_);
	}
}


static gboolean _lambda0_ (Block4Data* _data4_) {
	gboolean result = FALSE;
	gtk_widget_destroy (_data4_->w);
	result = FALSE;
	return result;
}


static gboolean __lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda0_ (self);
	return result;
}


void deja_dup_destroy_widget (GtkWidget* w) {
	Block4Data* _data4_;
	g_return_if_fail (w != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->w = _g_object_ref0 (w);
	gtk_widget_hide (_data4_->w);
	g_object_ref ((GObject*) _data4_->w);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda0__gsource_func, block4_data_ref (_data4_), block4_data_unref);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


gboolean deja_dup_gui_initialize (GtkWindow* parent, gboolean show_error) {
	gboolean result = FALSE;
	gchar* header = NULL;
	gchar* msg = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	gboolean rv;
	gboolean _tmp3_ = FALSE;
	_tmp2_ = deja_dup_initialize (&_tmp0_, &_tmp1_);
	_g_free0 (header);
	header = _tmp0_;
	_g_free0 (msg);
	msg = _tmp1_;
	rv = _tmp2_;
	if (!rv) {
		_tmp3_ = show_error;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GtkMessageDialog* _tmp4_ = NULL;
		GtkMessageDialog* dlg;
		_tmp4_ = (GtkMessageDialog*) gtk_message_dialog_new (parent, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "%s", header);
		dlg = g_object_ref_sink (_tmp4_);
		gtk_message_dialog_format_secondary_text (dlg, "%s", msg, NULL);
		gtk_dialog_run ((GtkDialog*) dlg);
		deja_dup_destroy_widget ((GtkWidget*) dlg);
		_g_object_unref0 (dlg);
	}
	result = rv;
	_g_free0 (msg);
	_g_free0 (header);
	return result;
}



