/* ConfigList.c generated by valac 0.12.1, the Vala compiler
 * generated from ConfigList.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <common.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <atk/atk.h>


#define DEJA_DUP_TYPE_CONFIG_LIST_STORE (deja_dup_config_list_store_get_type ())
#define DEJA_DUP_CONFIG_LIST_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CONFIG_LIST_STORE, DejaDupConfigListStore))
#define DEJA_DUP_CONFIG_LIST_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CONFIG_LIST_STORE, DejaDupConfigListStoreClass))
#define DEJA_DUP_IS_CONFIG_LIST_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CONFIG_LIST_STORE))
#define DEJA_DUP_IS_CONFIG_LIST_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CONFIG_LIST_STORE))
#define DEJA_DUP_CONFIG_LIST_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CONFIG_LIST_STORE, DejaDupConfigListStoreClass))

typedef struct _DejaDupConfigListStore DejaDupConfigListStore;
typedef struct _DejaDupConfigListStoreClass DejaDupConfigListStoreClass;
typedef struct _DejaDupConfigListStorePrivate DejaDupConfigListStorePrivate;

#define DEJA_DUP_TYPE_CONFIG_WIDGET (deja_dup_config_widget_get_type ())
#define DEJA_DUP_CONFIG_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CONFIG_WIDGET, DejaDupConfigWidget))
#define DEJA_DUP_CONFIG_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CONFIG_WIDGET, DejaDupConfigWidgetClass))
#define DEJA_DUP_IS_CONFIG_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CONFIG_WIDGET))
#define DEJA_DUP_IS_CONFIG_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CONFIG_WIDGET))
#define DEJA_DUP_CONFIG_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CONFIG_WIDGET, DejaDupConfigWidgetClass))

typedef struct _DejaDupConfigWidget DejaDupConfigWidget;
typedef struct _DejaDupConfigWidgetClass DejaDupConfigWidgetClass;

#define DEJA_DUP_TYPE_CONFIG_LIST (deja_dup_config_list_get_type ())
#define DEJA_DUP_CONFIG_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CONFIG_LIST, DejaDupConfigList))
#define DEJA_DUP_CONFIG_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CONFIG_LIST, DejaDupConfigListClass))
#define DEJA_DUP_IS_CONFIG_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CONFIG_LIST))
#define DEJA_DUP_IS_CONFIG_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CONFIG_LIST))
#define DEJA_DUP_CONFIG_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CONFIG_LIST, DejaDupConfigListClass))

typedef struct _DejaDupConfigList DejaDupConfigList;
typedef struct _DejaDupConfigListClass DejaDupConfigListClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_slist_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_free0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DejaDupConfigWidgetPrivate DejaDupConfigWidgetPrivate;
typedef struct _DejaDupConfigListPrivate DejaDupConfigListPrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _DejaDupConfigListSetFromConfigData DejaDupConfigListSetFromConfigData;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define __g_list_free__gtk_tree_path_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_tree_path_free0_ (var), NULL)))

struct _DejaDupConfigListStore {
	GtkListStore parent_instance;
	DejaDupConfigListStorePrivate * priv;
};

struct _DejaDupConfigListStoreClass {
	GtkListStoreClass parent_class;
};

struct _DejaDupConfigListStorePrivate {
	DejaDupConfigList* _list;
};

struct _DejaDupConfigWidget {
	GtkEventBox parent_instance;
	DejaDupConfigWidgetPrivate * priv;
	gboolean syncing;
	DejaDupSimpleSettings* settings;
	GList* all_settings;
};

struct _DejaDupConfigWidgetClass {
	GtkEventBoxClass parent_class;
	void (*set_from_config) (DejaDupConfigWidget* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_from_config_finish) (DejaDupConfigWidget* self, GAsyncResult* _res_);
};

struct _DejaDupConfigList {
	DejaDupConfigWidget parent_instance;
	DejaDupConfigListPrivate * priv;
};

struct _DejaDupConfigListClass {
	DejaDupConfigWidgetClass parent_class;
};

struct _DejaDupConfigListPrivate {
	GtkTreeView* tree;
	GtkToolButton* add_button;
	GtkToolButton* remove_button;
};

struct _DejaDupConfigListSetFromConfigData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupConfigList* self;
	const gchar* _tmp0_;
	GVariant* _tmp1_;
	GVariant* slist_val;
	size_t _tmp2_;
	const gchar** _tmp3_;
	const gchar** slist;
	gint slist_length1;
	gint _slist_size_;
	gint _tmp4_;
	GFile** _tmp5_;
	GFile** list;
	gint list_length1;
	gint _list_size_;
	GtkListStore* model;
	guint _tmp6_;
	gint i;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	GFile* trash;
	GFile** f_collection;
	int f_collection_length1;
	int f_it;
	GFile* _tmp11_;
	GFile* f;
	gchar* _tmp12_;
	gchar* s;
	GtkTreeIter iter;
	gint _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GtkTreeIter _tmp16_;
	GIcon* icon;
	gboolean _tmp17_;
	GThemedIcon* _tmp18_;
	GFileInfo* _tmp19_;
	GFileInfo* info;
	GIcon* _tmp20_;
	GIcon* _tmp21_;
	GError * err;
	GError * _inner_error_;
};


static gpointer deja_dup_config_list_store_parent_class = NULL;
static GtkTreeDragDestIface* deja_dup_config_list_store_gtk_tree_drag_dest_parent_iface = NULL;
static GtkTreeDragSourceIface* deja_dup_config_list_store_gtk_tree_drag_source_parent_iface = NULL;
static gpointer deja_dup_config_list_parent_class = NULL;

GType deja_dup_config_list_store_get_type (void) G_GNUC_CONST;
GType deja_dup_config_widget_get_type (void) G_GNUC_CONST;
GType deja_dup_config_list_get_type (void) G_GNUC_CONST;
#define DEJA_DUP_CONFIG_LIST_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_CONFIG_LIST_STORE, DejaDupConfigListStorePrivate))
enum  {
	DEJA_DUP_CONFIG_LIST_STORE_DUMMY_PROPERTY,
	DEJA_DUP_CONFIG_LIST_STORE_LIST
};
DejaDupConfigListStore* deja_dup_config_list_store_new (DejaDupConfigList* list);
DejaDupConfigListStore* deja_dup_config_list_store_construct (GType object_type, DejaDupConfigList* list);
static gboolean deja_dup_config_list_store_real_drag_data_received (GtkTreeDragDest* base, GtkTreePath* dest, GtkSelectionData* selection_data);
static void _g_free0_ (gpointer var);
static void _g_slist_free__g_free0_ (GSList* self);
DejaDupConfigList* deja_dup_config_list_store_get_list (DejaDupConfigListStore* self);
gboolean deja_dup_config_list_add_files (DejaDupConfigList* self, GSList* files);
static gboolean deja_dup_config_list_store_real_drag_data_get (GtkTreeDragSource* base, GtkTreePath* path, GtkSelectionData* selection_data);
static void deja_dup_config_list_store_set_list (DejaDupConfigListStore* self, DejaDupConfigList* value);
static GObject * deja_dup_config_list_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void deja_dup_config_list_store_finalize (GObject* obj);
static void _vala_deja_dup_config_list_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_deja_dup_config_list_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define DEJA_DUP_CONFIG_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_CONFIG_LIST, DejaDupConfigListPrivate))
enum  {
	DEJA_DUP_CONFIG_LIST_DUMMY_PROPERTY
};
DejaDupConfigList* deja_dup_config_list_new (const gchar* key, const gchar* ns);
DejaDupConfigList* deja_dup_config_list_construct (GType object_type, const gchar* key, const gchar* ns);
static gchar* deja_dup_config_list_convert_key_to_a11y_name (const gchar* key);
static gboolean deja_dup_config_list_on_key_press_event (DejaDupConfigList* self, GtkWidget* w, GdkEventKey* e);
static void deja_dup_config_list_handle_remove (DejaDupConfigList* self);
static void deja_dup_config_list_real_set_from_config_data_free (gpointer _data);
static void deja_dup_config_list_real_set_from_config (DejaDupConfigWidget* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean deja_dup_config_list_real_set_from_config_co (DejaDupConfigListSetFromConfigData* data);
const gchar* deja_dup_config_widget_get_key (DejaDupConfigWidget* self);
void deja_dup_config_list_write_to_config (DejaDupConfigList* self, GtkTreeModel* model, GtkTreePath* path);
static void _deja_dup_config_list_write_to_config_gtk_tree_model_row_deleted (GtkTreeModel* _sender, GtkTreePath* path, gpointer self);
static void deja_dup_config_list_set_from_config_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void deja_dup_config_list_handle_selection_change (DejaDupConfigList* self, GtkTreeSelection* sel);
static void deja_dup_config_list_handle_add (DejaDupConfigList* self);
void deja_dup_destroy_widget (GtkWidget* w);
static void _vala_array_add1 (const gchar*** array, int* length, int* size, const gchar* value);
gchar** deja_dup_config_list_get_files (DejaDupConfigList* self, int* result_length1);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self);
static void _g_list_free__g_free0_ (GList* self);
static void _gtk_tree_path_free0_ (gpointer var);
static void _g_list_free__gtk_tree_path_free0_ (GList* self);
static GObject * deja_dup_config_list_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void deja_dup_config_widget_set_mnemonic_widget (DejaDupConfigWidget* self, GtkWidget* value);
static void _deja_dup_config_list_handle_add_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void _deja_dup_config_list_handle_remove_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static gboolean _deja_dup_config_list_on_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
void deja_dup_config_widget_set_from_config (DejaDupConfigWidget* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_config_widget_set_from_config_finish (DejaDupConfigWidget* self, GAsyncResult* _res_);
static void _deja_dup_config_list_handle_selection_change_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void deja_dup_config_list_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


DejaDupConfigListStore* deja_dup_config_list_store_construct (GType object_type, DejaDupConfigList* list) {
	DejaDupConfigListStore * self = NULL;
	g_return_val_if_fail (list != NULL, NULL);
	self = (DejaDupConfigListStore*) g_object_new (object_type, "list", list, NULL);
	return self;
}


DejaDupConfigListStore* deja_dup_config_list_store_new (DejaDupConfigList* list) {
	return deja_dup_config_list_store_construct (DEJA_DUP_TYPE_CONFIG_LIST_STORE, list);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_slist_free__g_free0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_free0_, NULL);
	g_slist_free (self);
}


static gboolean deja_dup_config_list_store_real_drag_data_received (GtkTreeDragDest* base, GtkTreePath* dest, GtkSelectionData* selection_data) {
	DejaDupConfigListStore * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** uris;
	gint uris_length1;
	gint _uris_size_;
	GSList* files;
	gboolean _tmp10_;
	GError * _inner_error_ = NULL;
	self = (DejaDupConfigListStore*) base;
	g_return_val_if_fail (dest != NULL, FALSE);
	g_return_val_if_fail (selection_data != NULL, FALSE);
	_tmp0_ = deja_dup_config_list_store_gtk_tree_drag_dest_parent_iface->drag_data_received ((GtkTreeDragDest*) GTK_LIST_STORE (self), dest, selection_data);
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp2_ = _tmp1_ = gtk_selection_data_get_uris (selection_data);
	uris = _tmp2_;
	uris_length1 = _vala_array_length (_tmp1_);
	_uris_size_ = _vala_array_length (_tmp1_);
	if (uris == NULL) {
		result = FALSE;
		uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	files = NULL;
	{
		gchar** uri_collection;
		int uri_collection_length1;
		int uri_it;
		uri_collection = uris;
		uri_collection_length1 = uris_length1;
		for (uri_it = 0; uri_it < uris_length1; uri_it = uri_it + 1) {
			const gchar* uri;
			uri = uri_collection[uri_it];
			{
				gchar* _tmp3_ = NULL;
				gchar* _tmp4_;
				gboolean _tmp5_;
				gchar* _tmp6_ = NULL;
				gchar* file;
				GFile* _tmp7_ = NULL;
				GFile* gfile;
				GFileType _tmp8_;
				_tmp3_ = g_uri_parse_scheme (uri);
				_tmp4_ = _tmp3_;
				_tmp5_ = g_strcmp0 (_tmp4_, "file") != 0;
				_g_free0 (_tmp4_);
				if (_tmp5_) {
					continue;
				}
				_tmp6_ = g_filename_from_uri (uri, NULL, &_inner_error_);
				file = _tmp6_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_CONVERT_ERROR) {
						goto __catch1_g_convert_error;
					}
					__g_slist_free__g_free0_0 (files);
					uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
				if (file == NULL) {
					_g_free0 (file);
					continue;
				}
				_tmp7_ = g_file_new_for_path (file);
				gfile = _tmp7_;
				_tmp8_ = g_file_query_file_type (gfile, G_FILE_QUERY_INFO_NONE, NULL);
				if (_tmp8_ == G_FILE_TYPE_DIRECTORY) {
					gchar* _tmp9_;
					_tmp9_ = g_strdup (file);
					files = g_slist_append (files, _tmp9_);
				}
				_g_object_unref0 (gfile);
				_g_free0 (file);
				goto __finally1;
				__catch1_g_convert_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					g_warning ("ConfigList.vala:65: %s", e->message);
					_g_error_free0 (e);
				}
				__finally1:
				if (_inner_error_ != NULL) {
					__g_slist_free__g_free0_0 (files);
					uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
		}
	}
	_tmp10_ = deja_dup_config_list_add_files (self->priv->_list, files);
	result = _tmp10_;
	__g_slist_free__g_free0_0 (files);
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gboolean deja_dup_config_list_store_real_drag_data_get (GtkTreeDragSource* base, GtkTreePath* path, GtkSelectionData* selection_data) {
	DejaDupConfigListStore * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	gchar* file = NULL;
	gchar* uri = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_ = NULL;
	gchar** uris;
	gint uris_length1;
	gint _uris_size_;
	gboolean _tmp7_;
	GError * _inner_error_ = NULL;
	self = (DejaDupConfigListStore*) base;
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (selection_data != NULL, FALSE);
	_tmp0_ = deja_dup_config_list_store_gtk_tree_drag_source_parent_iface->drag_data_get ((GtkTreeDragSource*) GTK_LIST_STORE (self), path, selection_data);
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp2_ = gtk_tree_model_get_iter ((GtkTreeModel*) self, &_tmp1_, path);
	iter = _tmp1_;
	if (!_tmp2_) {
		result = FALSE;
		return result;
	}
	gtk_tree_model_get ((GtkTreeModel*) self, &iter, 0, &file, -1);
	_tmp3_ = g_filename_to_uri (file, NULL, &_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_CONVERT_ERROR) {
			goto __catch2_g_convert_error;
		}
		_g_free0 (uri);
		_g_free0 (file);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_g_free0 (uri);
	uri = _tmp4_;
	goto __finally2;
	__catch2_g_convert_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("ConfigList.vala:90: %s", e->message);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (uri);
		_g_free0 (file);
		return result;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_free0 (uri);
		_g_free0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp5_ = g_strdup (uri);
	_tmp6_ = g_new0 (gchar*, 1 + 1);
	_tmp6_[0] = _tmp5_;
	uris = _tmp6_;
	uris_length1 = 1;
	_uris_size_ = 1;
	_tmp7_ = gtk_selection_data_set_uris (selection_data, uris);
	result = _tmp7_;
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (uri);
	_g_free0 (file);
	return result;
}


DejaDupConfigList* deja_dup_config_list_store_get_list (DejaDupConfigListStore* self) {
	DejaDupConfigList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_list;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void deja_dup_config_list_store_set_list (DejaDupConfigListStore* self, DejaDupConfigList* value) {
	DejaDupConfigList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_list);
	self->priv->_list = _tmp0_;
	g_object_notify ((GObject *) self, "list");
}


static GObject * deja_dup_config_list_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DejaDupConfigListStore * self;
	GType* _tmp0_ = NULL;
	GType* types;
	gint types_length1;
	gint _types_size_;
	parent_class = G_OBJECT_CLASS (deja_dup_config_list_store_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DEJA_DUP_CONFIG_LIST_STORE (obj);
	_tmp0_ = g_new0 (GType, 3);
	_tmp0_[0] = G_TYPE_STRING;
	_tmp0_[1] = G_TYPE_STRING;
	_tmp0_[2] = G_TYPE_ICON;
	types = _tmp0_;
	types_length1 = 3;
	_types_size_ = 3;
	gtk_list_store_set_column_types ((GtkListStore*) self, types_length1, types);
	types = (g_free (types), NULL);
	return obj;
}


static void deja_dup_config_list_store_class_init (DejaDupConfigListStoreClass * klass) {
	deja_dup_config_list_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupConfigListStorePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_deja_dup_config_list_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_deja_dup_config_list_store_set_property;
	G_OBJECT_CLASS (klass)->constructor = deja_dup_config_list_store_constructor;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_config_list_store_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_CONFIG_LIST_STORE_LIST, g_param_spec_object ("list", "list", "list", DEJA_DUP_TYPE_CONFIG_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void deja_dup_config_list_store_gtk_tree_drag_dest_interface_init (GtkTreeDragDestIface * iface) {
	deja_dup_config_list_store_gtk_tree_drag_dest_parent_iface = g_type_interface_peek_parent (iface);
	iface->drag_data_received = (gboolean (*)(GtkTreeDragDest* ,GtkTreePath* ,GtkSelectionData*)) deja_dup_config_list_store_real_drag_data_received;
}


static void deja_dup_config_list_store_gtk_tree_drag_source_interface_init (GtkTreeDragSourceIface * iface) {
	deja_dup_config_list_store_gtk_tree_drag_source_parent_iface = g_type_interface_peek_parent (iface);
	iface->drag_data_get = (gboolean (*)(GtkTreeDragSource* ,GtkTreePath* ,GtkSelectionData*)) deja_dup_config_list_store_real_drag_data_get;
}


static void deja_dup_config_list_store_instance_init (DejaDupConfigListStore * self) {
	self->priv = DEJA_DUP_CONFIG_LIST_STORE_GET_PRIVATE (self);
}


static void deja_dup_config_list_store_finalize (GObject* obj) {
	DejaDupConfigListStore * self;
	self = DEJA_DUP_CONFIG_LIST_STORE (obj);
	_g_object_unref0 (self->priv->_list);
	G_OBJECT_CLASS (deja_dup_config_list_store_parent_class)->finalize (obj);
}


GType deja_dup_config_list_store_get_type (void) {
	static volatile gsize deja_dup_config_list_store_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_config_list_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupConfigListStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_config_list_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupConfigListStore), 0, (GInstanceInitFunc) deja_dup_config_list_store_instance_init, NULL };
		static const GInterfaceInfo gtk_tree_drag_dest_info = { (GInterfaceInitFunc) deja_dup_config_list_store_gtk_tree_drag_dest_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gtk_tree_drag_source_info = { (GInterfaceInitFunc) deja_dup_config_list_store_gtk_tree_drag_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType deja_dup_config_list_store_type_id;
		deja_dup_config_list_store_type_id = g_type_register_static (GTK_TYPE_LIST_STORE, "DejaDupConfigListStore", &g_define_type_info, 0);
		g_type_add_interface_static (deja_dup_config_list_store_type_id, GTK_TYPE_TREE_DRAG_DEST, &gtk_tree_drag_dest_info);
		g_type_add_interface_static (deja_dup_config_list_store_type_id, GTK_TYPE_TREE_DRAG_SOURCE, &gtk_tree_drag_source_info);
		g_once_init_leave (&deja_dup_config_list_store_type_id__volatile, deja_dup_config_list_store_type_id);
	}
	return deja_dup_config_list_store_type_id__volatile;
}


static void _vala_deja_dup_config_list_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DejaDupConfigListStore * self;
	self = DEJA_DUP_CONFIG_LIST_STORE (object);
	switch (property_id) {
		case DEJA_DUP_CONFIG_LIST_STORE_LIST:
		g_value_set_object (value, deja_dup_config_list_store_get_list (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_deja_dup_config_list_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DejaDupConfigListStore * self;
	self = DEJA_DUP_CONFIG_LIST_STORE (object);
	switch (property_id) {
		case DEJA_DUP_CONFIG_LIST_STORE_LIST:
		deja_dup_config_list_store_set_list (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


DejaDupConfigList* deja_dup_config_list_construct (GType object_type, const gchar* key, const gchar* ns) {
	DejaDupConfigList * self = NULL;
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (ns != NULL, NULL);
	self = (DejaDupConfigList*) g_object_new (object_type, "key", key, "ns", ns, NULL);
	return self;
}


DejaDupConfigList* deja_dup_config_list_new (const gchar* key, const gchar* ns) {
	return deja_dup_config_list_construct (DEJA_DUP_TYPE_CONFIG_LIST, key, ns);
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = g_utf8_get_char (((gchar*) self) + index);
	result = _tmp0_;
	return result;
}


static gchar* deja_dup_config_list_convert_key_to_a11y_name (const gchar* key) {
	gchar* result = NULL;
	GString* _tmp0_ = NULL;
	GString* name;
	gboolean next_upper;
	gint i;
	gunichar ch = 0U;
	gchar* _tmp4_;
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = g_string_new ("");
	name = _tmp0_;
	next_upper = TRUE;
	i = 0;
	while (TRUE) {
		gint _tmp1_;
		gunichar _tmp2_;
		_tmp1_ = i;
		i = _tmp1_ + 1;
		_tmp2_ = string_get_char (key, (glong) _tmp1_);
		ch = _tmp2_;
		if (!(ch != 0)) {
			break;
		}
		if (ch == '-') {
			next_upper = TRUE;
			continue;
		}
		if (next_upper) {
			gunichar _tmp3_;
			_tmp3_ = g_unichar_toupper (ch);
			ch = _tmp3_;
			next_upper = FALSE;
		}
		g_string_append_unichar (name, ch);
	}
	_tmp4_ = g_strdup (name->str);
	result = _tmp4_;
	_g_string_free0 (name);
	return result;
}


static gboolean deja_dup_config_list_on_key_press_event (DejaDupConfigList* self, GtkWidget* w, GdkEventKey* e) {
	gboolean result = FALSE;
	GdkModifierType _tmp0_;
	guint modifiers;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (w != NULL, FALSE);
	_tmp0_ = gtk_accelerator_get_default_mod_mask ();
	modifiers = (guint) _tmp0_;
	if ((*e).keyval == 0xffff) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = (*e).keyval == 0xff9f;
	}
	if (_tmp2_) {
		_tmp1_ = ((*e).state & modifiers) == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		deja_dup_config_list_handle_remove (self);
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static void deja_dup_config_list_real_set_from_config_data_free (gpointer _data) {
	DejaDupConfigListSetFromConfigData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (DejaDupConfigListSetFromConfigData, data);
}


static void deja_dup_config_list_real_set_from_config (DejaDupConfigWidget* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupConfigList * self;
	DejaDupConfigListSetFromConfigData* _data_;
	self = (DejaDupConfigList*) base;
	_data_ = g_slice_new0 (DejaDupConfigListSetFromConfigData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_config_list_real_set_from_config);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_config_list_real_set_from_config_data_free);
	_data_->self = _g_object_ref0 (self);
	deja_dup_config_list_real_set_from_config_co (_data_);
}


static void deja_dup_config_list_real_set_from_config_finish (DejaDupConfigWidget* base, GAsyncResult* _res_) {
	DejaDupConfigListSetFromConfigData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _deja_dup_config_list_write_to_config_gtk_tree_model_row_deleted (GtkTreeModel* _sender, GtkTreePath* path, gpointer self) {
	deja_dup_config_list_write_to_config (self, _sender, path);
}


static void deja_dup_config_list_set_from_config_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupConfigListSetFromConfigData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	deja_dup_config_list_real_set_from_config_co (data);
}


static gboolean deja_dup_config_list_real_set_from_config_co (DejaDupConfigListSetFromConfigData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = deja_dup_config_widget_get_key ((DejaDupConfigWidget*) data->self);
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_settings_get_value ((GSettings*) ((DejaDupConfigWidget*) data->self)->settings, data->_tmp0_);
	data->slist_val = data->_tmp1_;
	data->_tmp3_ = NULL;
	data->_tmp3_ = g_variant_get_strv (data->slist_val, &data->_tmp2_);
	data->slist = data->_tmp3_;
	data->slist_length1 = data->_tmp2_;
	data->_slist_size_ = data->_tmp2_;
	data->_tmp5_ = NULL;
	data->_tmp5_ = deja_dup_parse_dir_list (data->slist, data->slist_length1, &data->_tmp4_);
	data->list = data->_tmp5_;
	data->list_length1 = data->_tmp4_;
	data->_list_size_ = data->_tmp4_;
	g_object_get ((GObject*) data->self->priv->tree, "model", &data->model, NULL);
	g_signal_parse_name ("row-deleted", GTK_TYPE_TREE_MODEL, &data->_tmp6_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkTreeModel*) data->model, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, data->_tmp6_, 0, NULL, (GCallback) _deja_dup_config_list_write_to_config_gtk_tree_model_row_deleted, data->self);
	gtk_list_store_clear (data->model);
	g_signal_connect_object ((GtkTreeModel*) data->model, "row-deleted", (GCallback) _deja_dup_config_list_write_to_config_gtk_tree_model_row_deleted, data->self, 0);
	data->i = 0;
	data->_tmp7_ = NULL;
	data->_tmp7_ = deja_dup_get_trash_path ();
	data->_tmp8_ = data->_tmp7_;
	data->_tmp9_ = NULL;
	data->_tmp9_ = g_file_new_for_path (data->_tmp8_);
	data->_tmp10_ = data->_tmp9_;
	_g_free0 (data->_tmp8_);
	data->trash = data->_tmp10_;
	{
		data->f_collection = data->list;
		data->f_collection_length1 = data->list_length1;
		for (data->f_it = 0; data->f_it < data->list_length1; data->f_it = data->f_it + 1) {
			data->_tmp11_ = _g_object_ref0 (data->f_collection[data->f_it]);
			data->f = data->_tmp11_;
			{
				data->_state_ = 1;
				deja_dup_get_nickname (data->f, deja_dup_config_list_set_from_config_ready, data);
				return FALSE;
				_state_1:
				data->_tmp12_ = NULL;
				data->_tmp12_ = deja_dup_get_nickname_finish (data->_res_);
				data->s = data->_tmp12_;
				data->_tmp13_ = data->i;
				data->i = data->_tmp13_ + 1;
				data->_tmp14_ = NULL;
				data->_tmp14_ = g_file_get_path (data->f);
				data->_tmp15_ = data->_tmp14_;
				memset (&data->_tmp16_, 0, sizeof (GtkTreeIter));
				gtk_list_store_insert_with_values (data->model, &data->_tmp16_, data->_tmp13_, 0, data->_tmp15_, 1, data->s, -1);
				data->iter = data->_tmp16_;
				_g_free0 (data->_tmp15_);
				data->icon = NULL;
				data->_tmp17_ = g_file_equal (data->f, data->trash);
				if (data->_tmp17_) {
					data->_tmp18_ = NULL;
					data->_tmp18_ = (GThemedIcon*) g_themed_icon_new ("user-trash");
					_g_object_unref0 (data->icon);
					data->icon = (GIcon*) data->_tmp18_;
					g_themed_icon_append_name (G_THEMED_ICON (data->icon), "folder");
				} else {
					data->_tmp19_ = NULL;
					data->_tmp19_ = g_file_query_info (data->f, G_FILE_ATTRIBUTE_STANDARD_ICON, G_FILE_QUERY_INFO_NONE, NULL, &data->_inner_error_);
					data->info = data->_tmp19_;
					if (data->_inner_error_ != NULL) {
						goto __catch3_g_error;
					}
					data->_tmp20_ = NULL;
					data->_tmp20_ = g_file_info_get_icon (data->info);
					data->_tmp21_ = _g_object_ref0 (data->_tmp20_);
					_g_object_unref0 (data->icon);
					data->icon = data->_tmp21_;
					_g_object_unref0 (data->info);
					goto __finally3;
					__catch3_g_error:
					{
						data->err = data->_inner_error_;
						data->_inner_error_ = NULL;
						g_warning ("ConfigList.vala:260: %s\n", data->err->message);
						_g_error_free0 (data->err);
					}
					__finally3:
					if (data->_inner_error_ != NULL) {
						_g_object_unref0 (data->icon);
						_g_free0 (data->s);
						_g_object_unref0 (data->f);
						_g_object_unref0 (data->trash);
						_g_object_unref0 (data->model);
						data->list = (_vala_array_free (data->list, data->list_length1, (GDestroyNotify) g_object_unref), NULL);
						data->slist = (g_free (data->slist), NULL);
						_g_variant_unref0 (data->slist_val);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
						g_clear_error (&data->_inner_error_);
						return FALSE;
					}
				}
				if (data->icon != NULL) {
					gtk_list_store_set (data->model, &data->iter, 2, data->icon, -1);
				}
				_g_object_unref0 (data->icon);
				_g_free0 (data->s);
				_g_object_unref0 (data->f);
			}
		}
	}
	_g_object_unref0 (data->trash);
	_g_object_unref0 (data->model);
	data->list = (_vala_array_free (data->list, data->list_length1, (GDestroyNotify) g_object_unref), NULL);
	data->slist = (g_free (data->slist), NULL);
	_g_variant_unref0 (data->slist_val);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void deja_dup_config_list_handle_selection_change (DejaDupConfigList* self, GtkTreeSelection* sel) {
	gint _tmp0_;
	gboolean empty;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sel != NULL);
	_tmp0_ = gtk_tree_selection_count_selected_rows (sel);
	empty = _tmp0_ == 0;
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->remove_button, !empty);
}


static void deja_dup_config_list_handle_add (DejaDupConfigList* self) {
	const gchar* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_;
	GtkFileChooserDialog* _tmp3_ = NULL;
	GtkFileChooserDialog* dlg;
	gint _tmp4_;
	GSList* _tmp5_ = NULL;
	GSList* files;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Choose folders");
	_tmp1_ = gtk_widget_get_ancestor ((GtkWidget*) self, GTK_TYPE_WINDOW);
	_tmp2_ = _tmp1_;
	_tmp3_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp0_, GTK_IS_WINDOW (_tmp2_) ? ((GtkWindow*) _tmp2_) : NULL, GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL);
	dlg = g_object_ref_sink (_tmp3_);
	gtk_file_chooser_set_select_multiple ((GtkFileChooser*) dlg, TRUE);
	_tmp4_ = gtk_dialog_run ((GtkDialog*) dlg);
	if (_tmp4_ != GTK_RESPONSE_ACCEPT) {
		deja_dup_destroy_widget ((GtkWidget*) dlg);
		_g_object_unref0 (dlg);
		return;
	}
	_tmp5_ = gtk_file_chooser_get_filenames ((GtkFileChooser*) dlg);
	files = _tmp5_;
	deja_dup_destroy_widget ((GtkWidget*) dlg);
	deja_dup_config_list_add_files (self, files);
	__g_slist_free__g_free0_0 (files);
	_g_object_unref0 (dlg);
}


static void _vala_array_add1 (const gchar*** array, int* length, int* size, const gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (const gchar*, *array, *size);
	}
	(*array)[(*length)++] = value;
}


gboolean deja_dup_config_list_add_files (DejaDupConfigList* self, GSList* files) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	GVariant* slist_val;
	size_t _tmp2_;
	const gchar** _tmp3_ = NULL;
	const gchar** slist;
	gint slist_length1;
	gint _slist_size_;
	gboolean rv;
	g_return_val_if_fail (self != NULL, FALSE);
	if (files == NULL) {
		result = FALSE;
		return result;
	}
	_tmp0_ = deja_dup_config_widget_get_key ((DejaDupConfigWidget*) self);
	_tmp1_ = g_settings_get_value ((GSettings*) ((DejaDupConfigWidget*) self)->settings, _tmp0_);
	slist_val = _tmp1_;
	_tmp3_ = g_variant_get_strv (slist_val, &_tmp2_);
	slist = _tmp3_;
	slist_length1 = _tmp2_;
	_slist_size_ = _tmp2_;
	rv = FALSE;
	{
		GSList* file_collection;
		GSList* file_it;
		file_collection = files;
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
			gchar* _tmp4_;
			gchar* file;
			_tmp4_ = g_strdup ((const gchar*) file_it->data);
			file = _tmp4_;
			{
				GFile* _tmp5_ = NULL;
				GFile* folder;
				gboolean found;
				_tmp5_ = g_file_new_for_path (file);
				folder = _tmp5_;
				found = FALSE;
				{
					const gchar** s_collection;
					int s_collection_length1;
					int s_it;
					s_collection = slist;
					s_collection_length1 = slist_length1;
					for (s_it = 0; s_it < slist_length1; s_it = s_it + 1) {
						gchar* _tmp6_;
						gchar* s;
						_tmp6_ = g_strdup ((gchar*) s_collection[s_it]);
						s = _tmp6_;
						{
							GFile* _tmp7_ = NULL;
							GFile* sfile;
							gboolean _tmp8_ = FALSE;
							_tmp7_ = deja_dup_parse_dir (s);
							sfile = _tmp7_;
							if (sfile != NULL) {
								gboolean _tmp9_;
								_tmp9_ = g_file_equal (sfile, folder);
								_tmp8_ = _tmp9_;
							} else {
								_tmp8_ = FALSE;
							}
							if (_tmp8_) {
								found = TRUE;
								_g_object_unref0 (sfile);
								_g_free0 (s);
								break;
							}
							_g_object_unref0 (sfile);
							_g_free0 (s);
						}
					}
				}
				if (!found) {
					gchar* _tmp10_ = NULL;
					_tmp10_ = g_file_get_parse_name (folder);
					_vala_array_add1 (&slist, &slist_length1, &_slist_size_, _tmp10_);
					rv = TRUE;
				}
				_g_object_unref0 (folder);
				_g_free0 (file);
			}
		}
	}
	if (rv) {
		const gchar* _tmp11_ = NULL;
		GVariant* _tmp12_ = NULL;
		GVariant* _tmp13_;
		_tmp11_ = deja_dup_config_widget_get_key ((DejaDupConfigWidget*) self);
		_tmp12_ = g_variant_new_strv (slist, slist_length1);
		_tmp13_ = g_variant_ref_sink (_tmp12_);
		deja_dup_simple_settings_set_value (((DejaDupConfigWidget*) self)->settings, _tmp11_, _tmp13_);
		_g_variant_unref0 (_tmp13_);
	}
	result = rv;
	slist = (g_free (slist), NULL);
	_g_variant_unref0 (slist_val);
	return result;
}


gchar** deja_dup_config_list_get_files (DejaDupConfigList* self, int* result_length1) {
	gchar** result = NULL;
	const gchar* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	GVariant* slist_val;
	size_t _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = deja_dup_config_widget_get_key ((DejaDupConfigWidget*) self);
	_tmp1_ = g_settings_get_value ((GSettings*) ((DejaDupConfigWidget*) self)->settings, _tmp0_);
	slist_val = _tmp1_;
	_tmp3_ = g_variant_dup_strv (slist_val, &_tmp2_);
	_tmp4_ = _tmp3_;
	if (result_length1) {
		*result_length1 = _tmp2_;
	}
	result = _tmp4_;
	_g_variant_unref0 (slist_val);
	return result;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void deja_dup_config_list_write_to_config (DejaDupConfigList* self, GtkTreeModel* model, GtkTreePath* path) {
	GtkTreeIter iter = {0};
	gchar** _tmp0_ = NULL;
	gchar** paths;
	gint paths_length1;
	gint _paths_size_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	const gchar* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	GVariant* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	paths = _tmp0_;
	paths_length1 = 0;
	_paths_size_ = 0;
	_tmp2_ = gtk_tree_model_get_iter_first (model, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gchar* current = NULL;
				gchar* _tmp5_;
				if (!_tmp3_) {
					gboolean _tmp4_;
					_tmp4_ = gtk_tree_model_iter_next (model, &iter);
					if (!_tmp4_) {
						break;
					}
				}
				_tmp3_ = FALSE;
				gtk_tree_model_get (model, &iter, 0, &current, -1);
				_tmp5_ = g_strdup (current);
				_vala_array_add2 (&paths, &paths_length1, &_paths_size_, _tmp5_);
				_g_free0 (current);
			}
		}
	}
	_tmp6_ = deja_dup_config_widget_get_key ((DejaDupConfigWidget*) self);
	_tmp7_ = g_variant_new_strv ((const gchar**) paths, paths_length1);
	_tmp8_ = g_variant_ref_sink (_tmp7_);
	deja_dup_simple_settings_set_value (((DejaDupConfigWidget*) self)->settings, _tmp6_, _tmp8_);
	_g_variant_unref0 (_tmp8_);
	paths = (_vala_array_free (paths, paths_length1, (GDestroyNotify) g_free), NULL);
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self) {
	GtkTreeIter* dup;
	dup = g_new0 (GtkTreeIter, 1);
	memcpy (dup, self, sizeof (GtkTreeIter));
	return dup;
}


static gpointer __gtk_tree_iter_dup0 (gpointer self) {
	return self ? _gtk_tree_iter_dup (self) : NULL;
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void _gtk_tree_path_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL));
}


static void _g_list_free__gtk_tree_path_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gtk_tree_path_free0_, NULL);
	g_list_free (self);
}


static void deja_dup_config_list_handle_remove (DejaDupConfigList* self) {
	GtkTreeSelection* _tmp0_ = NULL;
	GtkTreeSelection* _tmp1_;
	GtkTreeSelection* sel;
	GtkTreeModel* model = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GList* paths;
	GList* iters;
	guint _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_tree_view_get_selection (self->priv->tree);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	sel = _tmp1_;
	_tmp3_ = gtk_tree_selection_get_selected_rows (sel, &_tmp2_);
	model = _tmp2_;
	paths = _tmp3_;
	iters = NULL;
	{
		GList* path_collection;
		GList* path_it;
		path_collection = paths;
		for (path_it = path_collection; path_it != NULL; path_it = path_it->next) {
			GtkTreePath* _tmp4_;
			GtkTreePath* path;
			_tmp4_ = _gtk_tree_path_copy0 ((GtkTreePath*) path_it->data);
			path = _tmp4_;
			{
				GtkTreeIter iter = {0};
				GtkTreeIter _tmp5_ = {0};
				gboolean _tmp6_;
				_tmp6_ = gtk_tree_model_get_iter (model, &_tmp5_, path);
				iter = _tmp5_;
				if (_tmp6_) {
					GtkTreeIter* _tmp7_;
					_tmp7_ = __gtk_tree_iter_dup0 (&iter);
					iters = g_list_prepend (iters, _tmp7_);
				}
				_gtk_tree_path_free0 (path);
			}
		}
	}
	g_signal_parse_name ("row-deleted", GTK_TYPE_TREE_MODEL, &_tmp8_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (model, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _deja_dup_config_list_write_to_config_gtk_tree_model_row_deleted, self);
	{
		GList* iter_collection;
		GList* iter_it;
		iter_collection = iters;
		for (iter_it = iter_collection; iter_it != NULL; iter_it = iter_it->next) {
			GtkTreeIter iter;
			iter = *((GtkTreeIter*) iter_it->data);
			{
				GtkTreeModel* _tmp9_;
				_tmp9_ = model;
				gtk_list_store_remove (GTK_IS_LIST_STORE (_tmp9_) ? ((GtkListStore*) _tmp9_) : NULL, &iter);
			}
		}
	}
	g_signal_connect_object (model, "row-deleted", (GCallback) _deja_dup_config_list_write_to_config_gtk_tree_model_row_deleted, self, 0);
	deja_dup_config_list_write_to_config (self, model, NULL);
	__g_list_free__g_free0_0 (iters);
	__g_list_free__gtk_tree_path_free0_0 (paths);
	_g_object_unref0 (sel);
}


static void _deja_dup_config_list_handle_add_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	deja_dup_config_list_handle_add (self);
}


static void _deja_dup_config_list_handle_remove_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	deja_dup_config_list_handle_remove (self);
}


static gboolean _deja_dup_config_list_on_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = deja_dup_config_list_on_key_press_event (self, _sender, event);
	return result;
}


static void _deja_dup_config_list_handle_selection_change_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	deja_dup_config_list_handle_selection_change (self, _sender);
}


static GObject * deja_dup_config_list_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DejaDupConfigList * self;
	DejaDupConfigListStore* _tmp0_ = NULL;
	DejaDupConfigListStore* model;
	GtkTreeView* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* a11y_name;
	AtkObject* _tmp4_ = NULL;
	AtkObject* _tmp5_;
	AtkObject* accessible;
	GtkCellRendererPixbuf* _tmp6_ = NULL;
	GtkCellRendererPixbuf* _tmp7_;
	GtkCellRendererText* _tmp8_ = NULL;
	GtkCellRendererText* renderer;
	GtkTargetEntry* _tmp9_ = NULL;
	GtkTargetEntry* targets;
	gint targets_length1;
	gint _targets_size_;
	const gchar* _tmp10_ = NULL;
	GQuark _tmp11_;
	GtkScrolledWindow* _tmp12_ = NULL;
	GtkScrolledWindow* scroll;
	GtkToolbar* _tmp13_ = NULL;
	GtkToolbar* tbar;
	GtkStyleContext* _tmp14_ = NULL;
	GtkStyleContext* _tmp15_ = NULL;
	GtkStyleContext* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	GtkToolButton* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	AtkObject* _tmp20_ = NULL;
	AtkObject* _tmp21_;
	const gchar* _tmp24_ = NULL;
	GtkToolButton* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	AtkObject* _tmp27_ = NULL;
	AtkObject* _tmp28_;
	GtkBox* _tmp31_ = NULL;
	GtkBox* vbox;
	GtkTreeSelection* _tmp32_ = NULL;
	GtkTreeSelection* _tmp33_;
	GtkTreeSelection* selection;
	parent_class = G_OBJECT_CLASS (deja_dup_config_list_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DEJA_DUP_CONFIG_LIST (obj);
	_tmp0_ = deja_dup_config_list_store_new (self);
	model = _tmp0_;
	_tmp1_ = (GtkTreeView*) gtk_tree_view_new ();
	_g_object_unref0 (self->priv->tree);
	self->priv->tree = g_object_ref_sink (_tmp1_);
	g_object_set ((GObject*) self->priv->tree, "model", model, "headers-visible", FALSE, NULL);
	deja_dup_config_widget_set_mnemonic_widget ((DejaDupConfigWidget*) self, (GtkWidget*) self->priv->tree);
	_tmp2_ = deja_dup_config_widget_get_key ((DejaDupConfigWidget*) self);
	_tmp3_ = deja_dup_config_list_convert_key_to_a11y_name (_tmp2_);
	a11y_name = _tmp3_;
	_tmp4_ = gtk_widget_get_accessible ((GtkWidget*) self->priv->tree);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	accessible = _tmp5_;
	if (accessible != NULL) {
		atk_object_set_name (accessible, a11y_name);
	}
	_tmp6_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	_tmp7_ = g_object_ref_sink (_tmp6_);
	gtk_tree_view_insert_column_with_attributes (self->priv->tree, -1, NULL, (GtkCellRenderer*) _tmp7_, "gicon", 2, NULL);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	renderer = g_object_ref_sink (_tmp8_);
	gtk_tree_view_insert_column_with_attributes (self->priv->tree, -1, NULL, (GtkCellRenderer*) renderer, "text", 1, NULL);
	_tmp9_ = g_new0 (GtkTargetEntry, 1);
	targets = _tmp9_;
	targets_length1 = 1;
	_targets_size_ = 1;
	targets[0].target = "text/uri-list";
	targets[0].flags = (guint) GTK_TARGET_OTHER_WIDGET;
	_tmp10_ = deja_dup_config_widget_get_key ((DejaDupConfigWidget*) self);
	_tmp11_ = g_quark_from_string (_tmp10_);
	targets[0].info = (guint) _tmp11_;
	gtk_tree_view_enable_model_drag_dest (self->priv->tree, targets, targets_length1, GDK_ACTION_COPY);
	targets[0].flags = (guint) GTK_TARGET_SAME_APP;
	gtk_tree_view_enable_model_drag_source (self->priv->tree, GDK_BUTTON1_MASK, targets, targets_length1, GDK_ACTION_MOVE);
	g_signal_connect_object ((GtkTreeModel*) model, "row-deleted", (GCallback) _deja_dup_config_list_write_to_config_gtk_tree_model_row_deleted, self, 0);
	_tmp12_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	scroll = g_object_ref_sink (_tmp12_);
	g_object_set (scroll, "hscrollbar-policy", GTK_POLICY_AUTOMATIC, NULL);
	g_object_set (scroll, "vscrollbar-policy", GTK_POLICY_AUTOMATIC, NULL);
	gtk_scrolled_window_set_shadow_type (scroll, GTK_SHADOW_IN);
	gtk_container_add ((GtkContainer*) scroll, (GtkWidget*) self->priv->tree);
	_tmp13_ = (GtkToolbar*) gtk_toolbar_new ();
	tbar = g_object_ref_sink (_tmp13_);
	gtk_toolbar_set_style (tbar, GTK_TOOLBAR_ICONS);
	gtk_toolbar_set_icon_size (tbar, GTK_ICON_SIZE_SMALL_TOOLBAR);
	gtk_toolbar_set_show_arrow (tbar, FALSE);
	_tmp14_ = gtk_widget_get_style_context ((GtkWidget*) scroll);
	gtk_style_context_set_junction_sides (_tmp14_, GTK_JUNCTION_BOTTOM);
	_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) tbar);
	gtk_style_context_add_class (_tmp15_, GTK_STYLE_CLASS_INLINE_TOOLBAR);
	_tmp16_ = gtk_widget_get_style_context ((GtkWidget*) tbar);
	gtk_style_context_set_junction_sides (_tmp16_, GTK_JUNCTION_TOP);
	_tmp17_ = _ ("_Add");
	_tmp18_ = (GtkToolButton*) gtk_tool_button_new (NULL, _tmp17_);
	_g_object_unref0 (self->priv->add_button);
	self->priv->add_button = g_object_ref_sink (_tmp18_);
	_tmp19_ = _ ("Add");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) self->priv->add_button, _tmp19_);
	gtk_tool_button_set_icon_name (self->priv->add_button, "list-add-symbolic");
	g_signal_connect_object (self->priv->add_button, "clicked", (GCallback) _deja_dup_config_list_handle_add_gtk_tool_button_clicked, self, 0);
	_tmp20_ = gtk_widget_get_accessible ((GtkWidget*) self->priv->add_button);
	_tmp21_ = _g_object_ref0 (_tmp20_);
	_g_object_unref0 (accessible);
	accessible = _tmp21_;
	if (accessible != NULL) {
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp22_ = g_strconcat (a11y_name, "Add", NULL);
		_tmp23_ = _tmp22_;
		atk_object_set_name (accessible, _tmp23_);
		_g_free0 (_tmp23_);
	}
	gtk_toolbar_insert (tbar, (GtkToolItem*) self->priv->add_button, -1);
	_tmp24_ = _ ("_Remove");
	_tmp25_ = (GtkToolButton*) gtk_tool_button_new (NULL, _tmp24_);
	_g_object_unref0 (self->priv->remove_button);
	self->priv->remove_button = g_object_ref_sink (_tmp25_);
	_tmp26_ = _ ("Remove");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) self->priv->remove_button, _tmp26_);
	gtk_tool_button_set_icon_name (self->priv->remove_button, "list-remove-symbolic");
	g_signal_connect_object (self->priv->remove_button, "clicked", (GCallback) _deja_dup_config_list_handle_remove_gtk_tool_button_clicked, self, 0);
	_tmp27_ = gtk_widget_get_accessible ((GtkWidget*) self->priv->remove_button);
	_tmp28_ = _g_object_ref0 (_tmp27_);
	_g_object_unref0 (accessible);
	accessible = _tmp28_;
	if (accessible != NULL) {
		gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp29_ = g_strconcat (a11y_name, "Remove", NULL);
		_tmp30_ = _tmp29_;
		atk_object_set_name (accessible, _tmp30_);
		_g_free0 (_tmp30_);
	}
	gtk_toolbar_insert (tbar, (GtkToolItem*) self->priv->remove_button, -1);
	_tmp31_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	vbox = g_object_ref_sink (_tmp31_);
	gtk_box_pack_start (vbox, (GtkWidget*) scroll, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start (vbox, (GtkWidget*) tbar, FALSE, TRUE, (guint) 0);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) vbox);
	_tmp32_ = gtk_tree_view_get_selection (self->priv->tree);
	_tmp33_ = _g_object_ref0 (_tmp32_);
	selection = _tmp33_;
	gtk_tree_selection_set_mode (selection, GTK_SELECTION_MULTIPLE);
	g_signal_connect_object ((GtkWidget*) self, "key-press-event", (GCallback) _deja_dup_config_list_on_key_press_event_gtk_widget_key_press_event, self, 0);
	deja_dup_config_widget_set_from_config ((DejaDupConfigWidget*) self, NULL, NULL);
	deja_dup_config_list_handle_selection_change (self, selection);
	g_signal_connect_object (selection, "changed", (GCallback) _deja_dup_config_list_handle_selection_change_gtk_tree_selection_changed, self, 0);
	_g_object_unref0 (selection);
	_g_object_unref0 (vbox);
	_g_object_unref0 (tbar);
	_g_object_unref0 (scroll);
	targets = (g_free (targets), NULL);
	_g_object_unref0 (renderer);
	_g_object_unref0 (accessible);
	_g_free0 (a11y_name);
	_g_object_unref0 (model);
	return obj;
}


static void deja_dup_config_list_class_init (DejaDupConfigListClass * klass) {
	deja_dup_config_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupConfigListPrivate));
	DEJA_DUP_CONFIG_WIDGET_CLASS (klass)->set_from_config = deja_dup_config_list_real_set_from_config;
	DEJA_DUP_CONFIG_WIDGET_CLASS (klass)->set_from_config_finish = deja_dup_config_list_real_set_from_config_finish;
	G_OBJECT_CLASS (klass)->constructor = deja_dup_config_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_config_list_finalize;
}


static void deja_dup_config_list_instance_init (DejaDupConfigList * self) {
	self->priv = DEJA_DUP_CONFIG_LIST_GET_PRIVATE (self);
}


static void deja_dup_config_list_finalize (GObject* obj) {
	DejaDupConfigList * self;
	self = DEJA_DUP_CONFIG_LIST (obj);
	_g_object_unref0 (self->priv->tree);
	_g_object_unref0 (self->priv->add_button);
	_g_object_unref0 (self->priv->remove_button);
	G_OBJECT_CLASS (deja_dup_config_list_parent_class)->finalize (obj);
}


GType deja_dup_config_list_get_type (void) {
	static volatile gsize deja_dup_config_list_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_config_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupConfigListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_config_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupConfigList), 0, (GInstanceInitFunc) deja_dup_config_list_instance_init, NULL };
		GType deja_dup_config_list_type_id;
		deja_dup_config_list_type_id = g_type_register_static (DEJA_DUP_TYPE_CONFIG_WIDGET, "DejaDupConfigList", &g_define_type_info, 0);
		g_once_init_leave (&deja_dup_config_list_type_id__volatile, deja_dup_config_list_type_id);
	}
	return deja_dup_config_list_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



