/* AssistantOperation.c generated by valac 0.12.1, the Vala compiler
 * generated from AssistantOperation.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <common.h>
#include <stdlib.h>
#include <string.h>
#include <widgets.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <gdk/gdk.h>
#include <gnome-keyring.h>
#include <chacks.h>
#include <config.h>


#define TYPE_ASSISTANT (assistant_get_type ())
#define ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT, Assistant))
#define ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT, AssistantClass))
#define IS_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT))
#define IS_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT))
#define ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT, AssistantClass))

typedef struct _Assistant Assistant;
typedef struct _AssistantClass AssistantClass;
typedef struct _AssistantPrivate AssistantPrivate;

#define ASSISTANT_TYPE_PAGE_INFO (assistant_page_info_get_type ())
#define ASSISTANT_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfo))
#define ASSISTANT_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfoClass))
#define ASSISTANT_IS_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ASSISTANT_TYPE_PAGE_INFO))
#define ASSISTANT_IS_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ASSISTANT_TYPE_PAGE_INFO))
#define ASSISTANT_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfoClass))

typedef struct _AssistantPageInfo AssistantPageInfo;
typedef struct _AssistantPageInfoClass AssistantPageInfoClass;

#define TYPE_ASSISTANT_OPERATION (assistant_operation_get_type ())
#define ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperation))
#define ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))
#define IS_ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_OPERATION))
#define IS_ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_OPERATION))
#define ASSISTANT_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))

typedef struct _AssistantOperation AssistantOperation;
typedef struct _AssistantOperationClass AssistantOperationClass;
typedef struct _AssistantOperationPrivate AssistantOperationPrivate;

#define TYPE_STATUS_ICON (status_icon_get_type ())
#define STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATUS_ICON, StatusIcon))
#define STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATUS_ICON, StatusIconClass))
#define IS_STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATUS_ICON))
#define IS_STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATUS_ICON))
#define STATUS_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATUS_ICON, StatusIconClass))

typedef struct _StatusIcon StatusIcon;
typedef struct _StatusIconClass StatusIconClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define ASSISTANT_TYPE_TYPE (assistant_type_get_type ())

#define TYPE_MOUNT_OPERATION_ASSISTANT (mount_operation_assistant_get_type ())
#define MOUNT_OPERATION_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistant))
#define MOUNT_OPERATION_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistantClass))
#define IS_MOUNT_OPERATION_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_OPERATION_ASSISTANT))
#define IS_MOUNT_OPERATION_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_OPERATION_ASSISTANT))
#define MOUNT_OPERATION_ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistantClass))

typedef struct _MountOperationAssistant MountOperationAssistant;
typedef struct _MountOperationAssistantClass MountOperationAssistantClass;
typedef struct _AssistantOperationDoApplyData AssistantOperationDoApplyData;
typedef struct _Block2Data Block2Data;

struct _Assistant {
	GtkWindow parent_instance;
	AssistantPrivate * priv;
	GtkImage* header_icon;
	GtkEventBox* page_box;
	GList* current;
};

struct _AssistantClass {
	GtkWindowClass parent_class;
};

struct _AssistantOperation {
	Assistant parent_instance;
	AssistantOperationPrivate * priv;
	StatusIcon* status_icon;
	gboolean succeeded;
	GtkLabel* summary_label;
	DejaDupOperation* op;
};

struct _AssistantOperationClass {
	AssistantClass parent_class;
	GtkWidget* (*make_confirm_page) (AssistantOperation* self);
	void (*add_setup_pages) (AssistantOperation* self);
	void (*add_custom_config_pages) (AssistantOperation* self);
	DejaDupOperation* (*create_op) (AssistantOperation* self);
	gchar* (*get_progress_file_prefix) (AssistantOperation* self);
	GtkWidget* (*make_progress_page) (AssistantOperation* self);
	void (*show_error) (AssistantOperation* self, const gchar* _error_, const gchar* detail);
	GtkWidget* (*make_summary_page) (AssistantOperation* self);
	void (*apply_finished) (AssistantOperation* self, DejaDupOperation* op, gboolean success, gboolean cancelled);
	void (*do_prepare) (AssistantOperation* self, Assistant* assist, GtkWidget* page);
	void (*do_cancel) (AssistantOperation* self);
	void (*do_close) (AssistantOperation* self);
};

struct _AssistantOperationPrivate {
	GtkWidget* _confirm_page;
	gboolean _automatic;
	GtkEntry* encrypt_entry;
	GtkEntry* encrypt_confirm_entry;
	GtkRadioButton* encrypt_enabled;
	GtkCheckButton* encrypt_remember;
	GtkWidget* _password_page;
	GList* first_password_widgets;
	GMainLoop* password_ask_loop;
	GMainLoop* password_find_loop;
	DejaDupToggleGroup* password_toggles;
	GtkLabel* question_label;
	GtkWidget* _question_page;
	GtkLabel* progress_label;
	GtkLabel* progress_file_label;
	GtkLabel* secondary_label;
	GtkProgressBar* progress_bar;
	GtkTextView* progress_text;
	GtkScrolledWindow* progress_scroll;
	GtkExpander* progress_expander;
	GtkWidget* _progress_page;
	GtkWidget* error_widget;
	GtkTextView* error_text_view;
	GtkWidget* _summary_page;
	GdkPixbuf* _op_icon;
	guint timeout_id;
	gboolean _error_occurred;
	gboolean gives_progress;
	gboolean searched_for_passphrase;
	gboolean saved_pos;
	gint saved_x;
	gint saved_y;
};

typedef enum  {
	ASSISTANT_TYPE_NORMAL,
	ASSISTANT_TYPE_INTERRUPT,
	ASSISTANT_TYPE_SUMMARY,
	ASSISTANT_TYPE_PROGRESS,
	ASSISTANT_TYPE_FINISH
} AssistantType;

struct _AssistantOperationDoApplyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	AssistantOperation* self;
	DejaDupOperation* _tmp0_;
	const gchar* _tmp1_;
	DejaDupBackend* _tmp2_;
	MountOperationAssistant* _tmp3_;
	MountOperationAssistant* _tmp4_;
	DejaDupBackend* _tmp5_;
};

struct _Block2Data {
	int _ref_count_;
	AssistantOperation * self;
	GtkWindow* win;
};


static gpointer assistant_operation_parent_class = NULL;

GType assistant_get_type (void) G_GNUC_CONST;
static gpointer assistant_page_info_ref (gpointer instance);
static void assistant_page_info_unref (gpointer instance);
static GParamSpec* assistant_param_spec_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void assistant_value_set_page_info (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void assistant_value_take_page_info (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer assistant_value_get_page_info (const GValue* value) G_GNUC_UNUSED;
static GType assistant_page_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType assistant_operation_get_type (void) G_GNUC_CONST;
GType status_icon_get_type (void) G_GNUC_CONST;
#define ASSISTANT_OPERATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ASSISTANT_OPERATION, AssistantOperationPrivate))
enum  {
	ASSISTANT_OPERATION_DUMMY_PROPERTY,
	ASSISTANT_OPERATION_CONFIRM_PAGE,
	ASSISTANT_OPERATION_AUTOMATIC,
	ASSISTANT_OPERATION_PASSWORD_PAGE,
	ASSISTANT_OPERATION_QUESTION_PAGE,
	ASSISTANT_OPERATION_PROGRESS_PAGE,
	ASSISTANT_OPERATION_SUMMARY_PAGE,
	ASSISTANT_OPERATION_OP_ICON,
	ASSISTANT_OPERATION_ERROR_OCCURRED
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
GtkWidget* assistant_operation_make_confirm_page (AssistantOperation* self);
static GtkWidget* assistant_operation_real_make_confirm_page (AssistantOperation* self);
void assistant_operation_add_setup_pages (AssistantOperation* self);
static void assistant_operation_real_add_setup_pages (AssistantOperation* self);
void assistant_operation_add_custom_config_pages (AssistantOperation* self);
static void assistant_operation_real_add_custom_config_pages (AssistantOperation* self);
DejaDupOperation* assistant_operation_create_op (AssistantOperation* self);
static DejaDupOperation* assistant_operation_real_create_op (AssistantOperation* self);
gchar* assistant_operation_get_progress_file_prefix (AssistantOperation* self);
static gchar* assistant_operation_real_get_progress_file_prefix (AssistantOperation* self);
GdkPixbuf* assistant_operation_make_op_icon (AssistantOperation* self);
static gboolean assistant_operation_pulse (AssistantOperation* self);
static void assistant_operation_show_progress (AssistantOperation* self, DejaDupOperation* op, gdouble percent);
static void assistant_operation_set_progress_label (AssistantOperation* self, DejaDupOperation* op, const gchar* label);
static void assistant_operation_set_progress_label_file (AssistantOperation* self, DejaDupOperation* op, GFile* file, gboolean actual);
void assistant_operation_set_secondary_label (AssistantOperation* self, const gchar* text);
GtkWidget* assistant_operation_make_progress_page (AssistantOperation* self);
static GtkWidget* assistant_operation_real_make_progress_page (AssistantOperation* self);
void assistant_operation_show_error (AssistantOperation* self, const gchar* _error_, const gchar* detail);
static void assistant_operation_real_show_error (AssistantOperation* self, const gchar* _error_, const gchar* detail);
static void assistant_operation_set_error_occurred (AssistantOperation* self, gboolean value);
void assistant_go_to_page (Assistant* self, GtkWidget* page);
GtkWidget* assistant_operation_get_summary_page (AssistantOperation* self);
void assistant_set_header_icon (Assistant* self, const gchar* name);
GtkWidget* assistant_operation_make_password_page (AssistantOperation* self);
static void _lambda8_ (AssistantOperation* self);
static void assistant_operation_check_password_validity (AssistantOperation* self);
static void __lambda8__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _lambda9_ (AssistantOperation* self);
static void __lambda9__gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void _lambda10_ (AssistantOperation* self);
static void __lambda10__gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void _lambda11_ (GtkToggleButton* button, AssistantOperation* self);
static void __lambda11__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
GtkWidget* assistant_operation_make_question_page (AssistantOperation* self);
GtkWidget* assistant_operation_make_summary_page (AssistantOperation* self);
static GtkWidget* assistant_operation_real_make_summary_page (AssistantOperation* self);
static void assistant_operation_add_confirm_page (AssistantOperation* self);
GType assistant_type_get_type (void) G_GNUC_CONST;
void assistant_append_page (Assistant* self, GtkWidget* page, AssistantType type);
void assistant_set_page_title (Assistant* self, GtkWidget* page, const gchar* title);
static void assistant_operation_set_confirm_page (AssistantOperation* self, GtkWidget* value);
static void assistant_operation_add_progress_page (AssistantOperation* self);
static void assistant_operation_set_progress_page (AssistantOperation* self, GtkWidget* value);
static void assistant_operation_add_password_page (AssistantOperation* self);
static void assistant_operation_set_password_page (AssistantOperation* self, GtkWidget* value);
static void assistant_operation_add_question_page (AssistantOperation* self);
static void assistant_operation_set_question_page (AssistantOperation* self, GtkWidget* value);
static void assistant_operation_add_summary_page (AssistantOperation* self);
static void assistant_operation_set_summary_page (AssistantOperation* self, GtkWidget* value);
void assistant_operation_apply_finished (AssistantOperation* self, DejaDupOperation* op, gboolean success, gboolean cancelled);
static void assistant_operation_real_apply_finished (AssistantOperation* self, DejaDupOperation* op, gboolean success, gboolean cancelled);
void status_icon_done (StatusIcon* self, gboolean success, gboolean cancelled);
void assistant_operation_do_close (AssistantOperation* self);
void assistant_operation_force_visible (AssistantOperation* self, gboolean user_click);
void assistant_operation_ensure_status_icon (AssistantOperation* self, DejaDupOperation* o);
StatusIcon* status_icon_create (GtkWindow* window, DejaDupOperation* op, gboolean automatic);
gboolean assistant_operation_get_automatic (AssistantOperation* self);
static void _lambda13_ (StatusIcon* s, AssistantOperation* self);
static void __lambda13__status_icon_show_window (StatusIcon* _sender, gpointer self);
static void _lambda14_ (StatusIcon* s, AssistantOperation* self);
void assistant_operation_hide_everything (AssistantOperation* self);
static void __lambda14__status_icon_hide_all (StatusIcon* _sender, gpointer self);
static void assistant_operation_do_apply_data_free (gpointer _data);
void assistant_operation_do_apply (AssistantOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void assistant_operation_do_apply_finish (AssistantOperation* self, GAsyncResult* _res_);
static gboolean assistant_operation_do_apply_co (AssistantOperationDoApplyData* data);
static void _assistant_operation_apply_finished_deja_dup_operation_done (DejaDupOperation* _sender, gboolean success, gboolean cancelled, gpointer self);
static void _lambda15_ (DejaDupOperation* o, const gchar* e, const gchar* d, AssistantOperation* self);
static void __lambda15__deja_dup_operation_raise_error (DejaDupOperation* _sender, const gchar* errstr, const gchar* detail, gpointer self);
void assistant_operation_get_passphrase (AssistantOperation* self);
static void _assistant_operation_get_passphrase_deja_dup_operation_passphrase_required (DejaDupOperation* _sender, gpointer self);
static void _assistant_operation_set_progress_label_deja_dup_operation_action_desc_changed (DejaDupOperation* _sender, const gchar* action, gpointer self);
static void _assistant_operation_set_progress_label_file_deja_dup_operation_action_file_changed (DejaDupOperation* _sender, GFile* file, gboolean actual, gpointer self);
static void _assistant_operation_show_progress_deja_dup_operation_progress (DejaDupOperation* _sender, gdouble percent, gpointer self);
static void assistant_operation_show_question (AssistantOperation* self, DejaDupOperation* op, const gchar* title, const gchar* message);
static void _assistant_operation_show_question_deja_dup_operation_question (DejaDupOperation* _sender, const gchar* title, const gchar* msg, gpointer self);
MountOperationAssistant* mount_operation_assistant_new (AssistantOperation* assist);
MountOperationAssistant* mount_operation_assistant_construct (GType object_type, AssistantOperation* assist);
GType mount_operation_assistant_get_type (void) G_GNUC_CONST;
void assistant_operation_pause_op (AssistantOperation* self, DejaDupBackend* back, const gchar* header, const gchar* msg);
static void _assistant_operation_pause_op_deja_dup_backend_pause_op (DejaDupBackend* _sender, const gchar* header, const gchar* msg, gpointer self);
void assistant_operation_do_prepare (AssistantOperation* self, Assistant* assist, GtkWidget* page);
static void assistant_operation_real_do_prepare (AssistantOperation* self, Assistant* assist, GtkWidget* page);
GtkWidget* assistant_operation_get_confirm_page (AssistantOperation* self);
GtkWidget* assistant_operation_get_progress_page (AssistantOperation* self);
static gboolean _assistant_operation_pulse_gsource_func (gpointer self);
void assistant_operation_provide_password (AssistantOperation* self);
GtkWidget* assistant_operation_get_password_page (AssistantOperation* self);
void assistant_operation_do_cancel (AssistantOperation* self);
static void assistant_operation_real_do_cancel (AssistantOperation* self);
static gboolean assistant_operation_do_minimize_to_tray (AssistantOperation* self, GdkEvent* event);
gboolean assistant_is_interrupted (Assistant* self);
void assistant_hide_for_now (Assistant* self);
static void assistant_operation_real_do_close (AssistantOperation* self);
static void assistant_operation_show_to_user (AssistantOperation* self, GtkWindow* win, guint time, gboolean user_click);
static gboolean assistant_operation_user_focused (AssistantOperation* self, GtkWidget* win, GdkEventFocus* e);
static gboolean _assistant_operation_user_focused_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static gboolean _lambda12_ (Block2Data* _data2_);
static gboolean __lambda12__gsource_func (gpointer self);
static void assistant_operation_found_passphrase (AssistantOperation* self, GnomeKeyringResult _result_, const gchar* str);
void assistant_operation_ask_passphrase (AssistantOperation* self, gboolean first);
static void _assistant_operation_found_passphrase_gnome_keyring_operation_get_string_callback (GnomeKeyringResult _result_, const gchar* str, gpointer self);
static void assistant_operation_save_password_callback (AssistantOperation* self, GnomeKeyringResult _result_);
void assistant_allow_forward (Assistant* self, gboolean allow);
static void assistant_operation_configure_password_page (AssistantOperation* self, gboolean first);
static void assistant_operation_stop_password_loop (AssistantOperation* self, Assistant* dlg, gint resp);
static gboolean _lambda16_ (AssistantOperation* self);
static gboolean __lambda16__gsource_func (gpointer self);
static void _assistant_operation_stop_password_loop_assistant_response (Assistant* _sender, gint response, gpointer self);
void assistant_interrupt (Assistant* self, GtkWidget* page, gboolean can_continue);
static void _assistant_operation_save_password_callback_gnome_keyring_operation_done_callback (GnomeKeyringResult _result_, gpointer self);
static void assistant_operation_stop_question (AssistantOperation* self, Assistant* dlg, gint resp);
static void _assistant_operation_stop_question_assistant_response (Assistant* _sender, gint response, gpointer self);
GtkWidget* assistant_operation_get_question_page (AssistantOperation* self);
void assistant_go_forward (Assistant* self);
AssistantOperation* assistant_operation_construct (GType object_type);
Assistant* assistant_construct (GType object_type);
static void assistant_operation_set_automatic (AssistantOperation* self, gboolean value);
GdkPixbuf* assistant_operation_get_op_icon (AssistantOperation* self);
static void assistant_operation_set_op_icon (AssistantOperation* self, GdkPixbuf* value);
gboolean assistant_operation_get_error_occurred (AssistantOperation* self);
static GObject * assistant_operation_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _assistant_operation_do_cancel_assistant_canceled (Assistant* _sender, gpointer self);
static void _assistant_operation_do_close_assistant_closed (Assistant* _sender, gpointer self);
static void _assistant_operation_do_prepare_assistant_prepare (Assistant* _sender, GtkWidget* page, gpointer self);
static gboolean _assistant_operation_do_minimize_to_tray_gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self);
static void assistant_operation_finalize (GObject* obj);
static void _vala_assistant_operation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_assistant_operation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static GtkWidget* assistant_operation_real_make_confirm_page (AssistantOperation* self) {
	GtkWidget* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}


GtkWidget* assistant_operation_make_confirm_page (AssistantOperation* self) {
	return ASSISTANT_OPERATION_GET_CLASS (self)->make_confirm_page (self);
}


static void assistant_operation_real_add_setup_pages (AssistantOperation* self) {
	g_return_if_fail (self != NULL);
}


void assistant_operation_add_setup_pages (AssistantOperation* self) {
	ASSISTANT_OPERATION_GET_CLASS (self)->add_setup_pages (self);
}


static void assistant_operation_real_add_custom_config_pages (AssistantOperation* self) {
	g_return_if_fail (self != NULL);
}


void assistant_operation_add_custom_config_pages (AssistantOperation* self) {
	ASSISTANT_OPERATION_GET_CLASS (self)->add_custom_config_pages (self);
}


static DejaDupOperation* assistant_operation_real_create_op (AssistantOperation* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `assistant_operation_create_op'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


DejaDupOperation* assistant_operation_create_op (AssistantOperation* self) {
	return ASSISTANT_OPERATION_GET_CLASS (self)->create_op (self);
}


static gchar* assistant_operation_real_get_progress_file_prefix (AssistantOperation* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `assistant_operation_get_progress_file_prefix'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gchar* assistant_operation_get_progress_file_prefix (AssistantOperation* self) {
	return ASSISTANT_OPERATION_GET_CLASS (self)->get_progress_file_prefix (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GdkPixbuf* assistant_operation_make_op_icon (AssistantOperation* self) {
	GdkPixbuf* result = NULL;
	const gchar* _tmp0_ = NULL;
	GdkScreen* _tmp1_ = NULL;
	GtkIconTheme* _tmp2_ = NULL;
	GtkIconTheme* _tmp3_;
	GtkIconTheme* theme;
	const gchar* _tmp4_ = NULL;
	GdkPixbuf* _tmp5_ = NULL;
	GdkPixbuf* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_window_get_icon_name ((GtkWindow*) self);
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp2_ = gtk_icon_theme_get_for_screen (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	theme = _tmp3_;
	_tmp4_ = gtk_window_get_icon_name ((GtkWindow*) self);
	_tmp5_ = gtk_icon_theme_load_icon (theme, _tmp4_, 48, GTK_ICON_LOOKUP_FORCE_SIZE, &_inner_error_);
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (theme);
		goto __catch1_g_error;
	}
	result = _tmp6_;
	_g_object_unref0 (theme);
	return result;
	_g_object_unref0 (theme);
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("AssistantOperation.vala:136: %s\n", e->message);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally1:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static gboolean assistant_operation_pulse (AssistantOperation* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->gives_progress) {
		gtk_progress_bar_pulse (self->priv->progress_bar);
	}
	result = TRUE;
	return result;
}


static void assistant_operation_show_progress (AssistantOperation* self, DejaDupOperation* op, gdouble percent) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	gtk_progress_bar_set_fraction (self->priv->progress_bar, percent);
	self->priv->gives_progress = TRUE;
}


static void assistant_operation_set_progress_label (AssistantOperation* self, DejaDupOperation* op, const gchar* label) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (label != NULL);
	gtk_label_set_label (self->priv->progress_label, label);
	gtk_label_set_label (self->priv->progress_file_label, "");
}


static void assistant_operation_set_progress_label_file (AssistantOperation* self, DejaDupOperation* op, GFile* file, gboolean actual) {
	gchar* prefix = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* log_line;
	gboolean adjustment_at_end;
	GtkAdjustment* _tmp14_ = NULL;
	GtkAdjustment* _tmp15_;
	GtkAdjustment* adjust;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gdouble _tmp18_;
	gdouble _tmp19_;
	gdouble _tmp20_;
	GtkTextBuffer* _tmp23_ = NULL;
	GtkTextBuffer* _tmp24_;
	GtkTextBuffer* buffer;
	gint _tmp25_;
	gboolean _tmp27_ = FALSE;
	gint _tmp28_;
	GtkTextIter iter = {0};
	GtkTextIter _tmp32_ = {0};
	gint _tmp33_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (file != NULL);
	if (actual) {
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp0_ = assistant_operation_get_progress_file_prefix (self);
		_g_free0 (prefix);
		prefix = _tmp0_;
		_tmp1_ = g_strconcat (prefix, " ", NULL);
		_tmp2_ = _tmp1_;
		gtk_label_set_label (self->priv->progress_label, _tmp2_);
		_g_free0 (_tmp2_);
		_tmp3_ = deja_dup_get_display_name (file);
		_tmp4_ = _tmp3_;
		gtk_label_set_label (self->priv->progress_file_label, _tmp4_);
		_g_free0 (_tmp4_);
	} else {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		const gchar* _tmp7_ = NULL;
		_tmp5_ = _ ("Scanning:");
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (prefix);
		prefix = _tmp6_;
		_tmp7_ = _ ("Scanning…");
		gtk_label_set_label (self->priv->progress_label, _tmp7_);
		gtk_label_set_label (self->priv->progress_file_label, "");
	}
	_tmp8_ = g_strconcat (prefix, " ", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_file_get_parse_name (file);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp9_, _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	log_line = _tmp13_;
	adjustment_at_end = FALSE;
	_tmp14_ = gtk_scrolled_window_get_vadjustment (self->priv->progress_scroll);
	_tmp15_ = _g_object_ref0 (_tmp14_);
	adjust = _tmp15_;
	_tmp18_ = gtk_adjustment_get_value (adjust);
	_tmp19_ = gtk_adjustment_get_upper (adjust);
	_tmp20_ = gtk_adjustment_get_page_size (adjust);
	if (_tmp18_ >= (_tmp19_ - _tmp20_)) {
		_tmp17_ = TRUE;
	} else {
		gdouble _tmp21_;
		_tmp21_ = gtk_adjustment_get_page_size (adjust);
		_tmp17_ = _tmp21_ == 0;
	}
	if (_tmp17_) {
		_tmp16_ = TRUE;
	} else {
		gboolean _tmp22_;
		_tmp22_ = gtk_expander_get_expanded (self->priv->progress_expander);
		_tmp16_ = !_tmp22_;
	}
	if (_tmp16_) {
		adjustment_at_end = TRUE;
	}
	_tmp23_ = gtk_text_view_get_buffer (self->priv->progress_text);
	_tmp24_ = _g_object_ref0 (_tmp23_);
	buffer = _tmp24_;
	_tmp25_ = gtk_text_buffer_get_char_count (buffer);
	if (_tmp25_ > 0) {
		gchar* _tmp26_;
		_tmp26_ = g_strconcat ("\n", log_line, NULL);
		_g_free0 (log_line);
		log_line = _tmp26_;
	}
	_tmp28_ = gtk_text_buffer_get_line_count (buffer);
	if (_tmp28_ >= 100) {
		_tmp27_ = adjustment_at_end;
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		GtkTextIter start = {0};
		GtkTextIter line100 = {0};
		GtkTextIter _tmp29_ = {0};
		gint _tmp30_;
		GtkTextIter _tmp31_ = {0};
		gtk_text_buffer_get_start_iter (buffer, &_tmp29_);
		start = _tmp29_;
		_tmp30_ = gtk_text_buffer_get_line_count (buffer);
		gtk_text_buffer_get_iter_at_line (buffer, &_tmp31_, _tmp30_ - 100);
		line100 = _tmp31_;
		gtk_text_buffer_delete (buffer, &start, &line100);
	}
	gtk_text_buffer_get_end_iter (buffer, &_tmp32_);
	iter = _tmp32_;
	_tmp33_ = strlen (log_line);
	g_signal_emit_by_name (buffer, "insert-text", &iter, log_line, (gint) _tmp33_);
	if (adjustment_at_end) {
		gdouble _tmp34_;
		_tmp34_ = gtk_adjustment_get_upper (adjust);
		gtk_adjustment_set_value (adjust, _tmp34_);
	}
	_g_object_unref0 (buffer);
	_g_object_unref0 (adjust);
	_g_free0 (log_line);
	_g_free0 (prefix);
}


void assistant_operation_set_secondary_label (AssistantOperation* self, const gchar* text) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	if (text != NULL) {
		_tmp0_ = g_strcmp0 (text, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = g_strconcat ("<i>", text, NULL);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strconcat (_tmp2_, "</i>", NULL);
		_tmp4_ = _tmp3_;
		gtk_label_set_label (self->priv->secondary_label, _tmp4_);
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
		gtk_widget_show ((GtkWidget*) self->priv->secondary_label);
	} else {
		gtk_widget_hide ((GtkWidget*) self->priv->secondary_label);
	}
}


static GtkWidget* assistant_operation_real_make_progress_page (AssistantOperation* self) {
	GtkWidget* result = NULL;
	GtkGrid* _tmp0_ = NULL;
	GtkGrid* page;
	gint row;
	GtkLabel* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	GtkProgressBar* _tmp4_ = NULL;
	GtkTextView* _tmp5_ = NULL;
	GtkScrolledWindow* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkExpander* _tmp8_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	page = g_object_ref_sink (_tmp0_);
	gtk_orientable_set_orientation ((GtkOrientable*) page, GTK_ORIENTATION_VERTICAL);
	gtk_grid_set_row_spacing (page, 6);
	row = 0;
	_tmp1_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->progress_label);
	self->priv->progress_label = g_object_ref_sink (_tmp1_);
	g_object_set ((GtkMisc*) self->priv->progress_label, "xalign", 0.0f, NULL);
	_tmp2_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->progress_file_label);
	self->priv->progress_file_label = g_object_ref_sink (_tmp2_);
	g_object_set ((GtkMisc*) self->priv->progress_file_label, "xalign", 0.0f, NULL);
	gtk_label_set_ellipsize (self->priv->progress_file_label, PANGO_ELLIPSIZE_MIDDLE);
	gtk_widget_set_hexpand ((GtkWidget*) self->priv->progress_file_label, TRUE);
	gtk_grid_attach (page, (GtkWidget*) self->priv->progress_label, 0, row, 1, 1);
	gtk_grid_attach (page, (GtkWidget*) self->priv->progress_file_label, 1, row, 1, 1);
	row = row + 1;
	_tmp3_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->secondary_label);
	self->priv->secondary_label = g_object_ref_sink (_tmp3_);
	g_object_set ((GtkMisc*) self->priv->secondary_label, "xalign", 0.0f, NULL);
	g_object_set (self->priv->secondary_label, "wrap", TRUE, NULL);
	gtk_label_set_max_width_chars (self->priv->secondary_label, 30);
	gtk_widget_set_no_show_all ((GtkWidget*) self->priv->secondary_label, TRUE);
	gtk_label_set_use_markup (self->priv->secondary_label, TRUE);
	gtk_grid_attach (page, (GtkWidget*) self->priv->secondary_label, 0, row, 2, 1);
	row = row + 1;
	_tmp4_ = (GtkProgressBar*) gtk_progress_bar_new ();
	_g_object_unref0 (self->priv->progress_bar);
	self->priv->progress_bar = g_object_ref_sink (_tmp4_);
	gtk_grid_attach (page, (GtkWidget*) self->priv->progress_bar, 0, row, 2, 1);
	row = row + 1;
	_tmp5_ = (GtkTextView*) gtk_text_view_new ();
	_g_object_unref0 (self->priv->progress_text);
	self->priv->progress_text = g_object_ref_sink (_tmp5_);
	gtk_text_view_set_editable (self->priv->progress_text, FALSE);
	_tmp6_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	_g_object_unref0 (self->priv->progress_scroll);
	self->priv->progress_scroll = g_object_ref_sink (_tmp6_);
	g_object_set ((GObject*) self->priv->progress_scroll, "child", self->priv->progress_text, "hscrollbar-policy", GTK_POLICY_AUTOMATIC, "vscrollbar-policy", GTK_POLICY_AUTOMATIC, "border-width", 0, NULL);
	_tmp7_ = _ ("_Details");
	_tmp8_ = (GtkExpander*) gtk_expander_new_with_mnemonic (_tmp7_);
	_g_object_unref0 (self->priv->progress_expander);
	self->priv->progress_expander = g_object_ref_sink (_tmp8_);
	g_object_set ((GObject*) self->priv->progress_expander, "child", self->priv->progress_scroll, NULL);
	g_object_set ((GtkWidget*) self->priv->progress_expander, "expand", TRUE, NULL);
	gtk_grid_attach (page, (GtkWidget*) self->priv->progress_expander, 0, row, 2, 1);
	row = row + 1;
	gtk_container_set_border_width ((GtkContainer*) page, (guint) 12);
	gtk_widget_set_size_request ((GtkWidget*) page, -1, 200);
	result = (GtkWidget*) page;
	return result;
}


GtkWidget* assistant_operation_make_progress_page (AssistantOperation* self) {
	return ASSISTANT_OPERATION_GET_CLASS (self)->make_progress_page (self);
}


static void assistant_operation_real_show_error (AssistantOperation* self, const gchar* _error_, const gchar* detail) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (_error_ != NULL);
	assistant_operation_set_error_occurred (self, TRUE);
	gtk_label_set_label (self->summary_label, _error_);
	g_object_set (self->summary_label, "wrap", TRUE, NULL);
	gtk_label_set_selectable (self->summary_label, TRUE);
	gtk_label_set_max_width_chars (self->summary_label, 25);
	if (detail != NULL) {
		GtkTextBuffer* _tmp0_ = NULL;
		gtk_widget_set_size_request ((GtkWidget*) ((Assistant*) self)->page_box, 300, 200);
		gtk_widget_set_no_show_all (self->priv->error_widget, FALSE);
		gtk_widget_show_all (self->priv->error_widget);
		_tmp0_ = gtk_text_view_get_buffer (self->priv->error_text_view);
		gtk_text_buffer_set_text (_tmp0_, detail, -1);
	}
	assistant_go_to_page ((Assistant*) self, self->priv->_summary_page);
	assistant_set_header_icon ((Assistant*) self, GTK_STOCK_DIALOG_ERROR);
	gtk_widget_queue_resize ((GtkWidget*) ((Assistant*) self)->page_box);
}


void assistant_operation_show_error (AssistantOperation* self, const gchar* _error_, const gchar* detail) {
	ASSISTANT_OPERATION_GET_CLASS (self)->show_error (self, _error_, detail);
}


static void _lambda8_ (AssistantOperation* self) {
	assistant_operation_check_password_validity (self);
}


static void __lambda8__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_lambda8_ (self);
}


static void _lambda9_ (AssistantOperation* self) {
	assistant_operation_check_password_validity (self);
}


static void __lambda9__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	_lambda9_ (self);
}


static void _lambda10_ (AssistantOperation* self) {
	assistant_operation_check_password_validity (self);
}


static void __lambda10__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	_lambda10_ (self);
}


static void _lambda11_ (GtkToggleButton* button, AssistantOperation* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (button != NULL);
	_tmp0_ = gtk_toggle_button_get_active (button);
	gtk_entry_set_visibility (self->priv->encrypt_entry, _tmp0_);
	_tmp1_ = gtk_toggle_button_get_active (button);
	gtk_entry_set_visibility (self->priv->encrypt_confirm_entry, _tmp1_);
}


static void __lambda11__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_lambda11_ (_sender, self);
}


GtkWidget* assistant_operation_make_password_page (AssistantOperation* self) {
	GtkWidget* result = NULL;
	gint rows;
	GtkWidget* w = NULL;
	GtkWidget* label = NULL;
	GtkGrid* _tmp0_ = NULL;
	GtkGrid* page;
	const gchar* _tmp1_ = NULL;
	GtkRadioButton* _tmp2_ = NULL;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	const gchar* _tmp5_ = NULL;
	GtkRadioButton* _tmp6_ = NULL;
	GtkWidget* _tmp7_;
	DejaDupToggleGroup* _tmp8_ = NULL;
	GtkLabel* _tmp9_ = NULL;
	GtkWidget* _tmp10_;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	GtkLabel* _tmp14_ = NULL;
	GtkWidget* _tmp15_;
	GtkEntry* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	GtkLabel* _tmp18_ = NULL;
	GtkEntry* _tmp19_;
	GtkEntry* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	GtkLabel* _tmp22_ = NULL;
	GtkEntry* _tmp23_;
	GtkWidget* _tmp24_;
	GtkWidget* _tmp25_;
	const gchar* _tmp26_ = NULL;
	GtkCheckButton* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	GtkCheckButton* _tmp29_ = NULL;
	GtkCheckButton* _tmp30_;
	g_return_val_if_fail (self != NULL, NULL);
	rows = 0;
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	page = g_object_ref_sink (_tmp0_);
	g_object_set ((GObject*) page, "row-spacing", 6, "column-spacing", 6, "border-width", 12, NULL);
	_tmp1_ = _ ("_Allow restoring without a password");
	_tmp2_ = (GtkRadioButton*) gtk_radio_button_new_with_mnemonic (NULL, _tmp1_);
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp2_);
	gtk_grid_attach (page, w, 0, rows, 3, 1);
	_tmp3_ = _g_object_ref0 (w);
	self->priv->first_password_widgets = g_list_append (self->priv->first_password_widgets, _tmp3_);
	rows = rows + 1;
	_tmp4_ = w;
	_tmp5_ = _ ("_Password-protect your backup");
	_tmp6_ = (GtkRadioButton*) gtk_radio_button_new_with_mnemonic_from_widget (GTK_IS_RADIO_BUTTON (_tmp4_) ? ((GtkRadioButton*) _tmp4_) : NULL, _tmp5_);
	_g_object_unref0 (self->priv->encrypt_enabled);
	self->priv->encrypt_enabled = g_object_ref_sink (_tmp6_);
	gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->encrypt_enabled, TRUE);
	gtk_grid_attach (page, (GtkWidget*) self->priv->encrypt_enabled, 0, rows, 3, 1);
	_tmp7_ = _g_object_ref0 ((GtkWidget*) self->priv->encrypt_enabled);
	self->priv->first_password_widgets = g_list_append (self->priv->first_password_widgets, _tmp7_);
	g_signal_connect_object ((GtkToggleButton*) self->priv->encrypt_enabled, "toggled", (GCallback) __lambda8__gtk_toggle_button_toggled, self, 0);
	rows = rows + 1;
	_tmp8_ = deja_dup_toggle_group_new_with_button ((GtkToggleButton*) self->priv->encrypt_enabled);
	_g_object_unref0 (self->priv->password_toggles);
	self->priv->password_toggles = _tmp8_;
	_tmp9_ = (GtkLabel*) gtk_label_new ("    ");
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp9_);
	gtk_grid_attach (page, w, 0, rows, 1, 1);
	_tmp10_ = _g_object_ref0 (w);
	self->priv->first_password_widgets = g_list_append (self->priv->first_password_widgets, _tmp10_);
	_tmp11_ = _ ("You will need your password to restore your files. You might want to w" \
"rite it down.");
	_tmp12_ = g_strdup_printf ("<i>%s</i>", _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = (GtkLabel*) gtk_label_new (_tmp13_);
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp14_);
	_g_free0 (_tmp13_);
	g_object_set ((GObject*) w, "xalign", 0.0f, "use-markup", TRUE, "max-width-chars", 25, "wrap", TRUE, NULL);
	gtk_grid_attach (page, w, 1, rows, 2, 1);
	deja_dup_toggle_group_add_dependent (self->priv->password_toggles, w);
	_tmp15_ = _g_object_ref0 (w);
	self->priv->first_password_widgets = g_list_append (self->priv->first_password_widgets, _tmp15_);
	rows = rows + 1;
	_tmp16_ = (GtkEntry*) gtk_entry_new ();
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp16_);
	g_object_set ((GObject*) w, "visibility", FALSE, "hexpand", TRUE, "activates-default", TRUE, NULL);
	g_signal_connect_object ((GtkEditable*) GTK_ENTRY (w), "changed", (GCallback) __lambda9__gtk_editable_changed, self, 0);
	_tmp17_ = _ ("E_ncryption password");
	_tmp18_ = (GtkLabel*) gtk_label_new (_tmp17_);
	_g_object_unref0 (label);
	label = (GtkWidget*) g_object_ref_sink (_tmp18_);
	g_object_set ((GObject*) label, "mnemonic-widget", w, "use-underline", TRUE, "xalign", 1.0f, NULL);
	gtk_grid_attach (page, label, 1, rows, 1, 1);
	gtk_grid_attach (page, w, 2, rows, 1, 1);
	deja_dup_toggle_group_add_dependent (self->priv->password_toggles, label);
	deja_dup_toggle_group_add_dependent (self->priv->password_toggles, w);
	rows = rows + 1;
	_tmp19_ = _g_object_ref0 (GTK_ENTRY (w));
	_g_object_unref0 (self->priv->encrypt_entry);
	self->priv->encrypt_entry = _tmp19_;
	_tmp20_ = (GtkEntry*) gtk_entry_new ();
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp20_);
	g_object_set ((GObject*) w, "visibility", FALSE, "hexpand", TRUE, "activates-default", TRUE, NULL);
	g_signal_connect_object ((GtkEditable*) GTK_ENTRY (w), "changed", (GCallback) __lambda10__gtk_editable_changed, self, 0);
	_tmp21_ = _ ("Confir_m password");
	_tmp22_ = (GtkLabel*) gtk_label_new (_tmp21_);
	_g_object_unref0 (label);
	label = (GtkWidget*) g_object_ref_sink (_tmp22_);
	g_object_set ((GObject*) label, "mnemonic-widget", w, "use-underline", TRUE, "xalign", 1.0f, NULL);
	gtk_grid_attach (page, label, 1, rows, 1, 1);
	gtk_grid_attach (page, w, 2, rows, 1, 1);
	deja_dup_toggle_group_add_dependent (self->priv->password_toggles, w);
	deja_dup_toggle_group_add_dependent (self->priv->password_toggles, label);
	rows = rows + 1;
	_tmp23_ = _g_object_ref0 (GTK_ENTRY (w));
	_g_object_unref0 (self->priv->encrypt_confirm_entry);
	self->priv->encrypt_confirm_entry = _tmp23_;
	_tmp24_ = _g_object_ref0 (w);
	self->priv->first_password_widgets = g_list_append (self->priv->first_password_widgets, _tmp24_);
	_tmp25_ = _g_object_ref0 (label);
	self->priv->first_password_widgets = g_list_append (self->priv->first_password_widgets, _tmp25_);
	_tmp26_ = _ ("_Show password");
	_tmp27_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp26_);
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp27_);
	g_signal_connect_object ((GtkToggleButton*) GTK_CHECK_BUTTON (w), "toggled", (GCallback) __lambda11__gtk_toggle_button_toggled, self, 0);
	gtk_grid_attach (page, w, 2, rows, 1, 1);
	deja_dup_toggle_group_add_dependent (self->priv->password_toggles, w);
	rows = rows + 1;
	_tmp28_ = _ ("_Remember password");
	_tmp29_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp28_);
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp29_);
	gtk_grid_attach (page, w, 2, rows, 1, 1);
	deja_dup_toggle_group_add_dependent (self->priv->password_toggles, w);
	rows = rows + 1;
	_tmp30_ = _g_object_ref0 (GTK_CHECK_BUTTON (w));
	_g_object_unref0 (self->priv->encrypt_remember);
	self->priv->encrypt_remember = _tmp30_;
	result = (GtkWidget*) page;
	_g_object_unref0 (label);
	_g_object_unref0 (w);
	return result;
}


GtkWidget* assistant_operation_make_question_page (AssistantOperation* self) {
	GtkWidget* result = NULL;
	gint rows;
	GtkGrid* _tmp0_ = NULL;
	GtkGrid* page;
	GtkLabel* _tmp1_ = NULL;
	GtkLabel* label;
	GtkLabel* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	rows = 0;
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	page = g_object_ref_sink (_tmp0_);
	g_object_set ((GObject*) page, "row-spacing", 6, "column-spacing", 6, "border-width", 12, NULL);
	_tmp1_ = (GtkLabel*) gtk_label_new ("");
	label = g_object_ref_sink (_tmp1_);
	g_object_set ((GObject*) label, "use-underline", TRUE, "wrap", TRUE, "max-width-chars", 25, "hexpand", TRUE, "xalign", 0.0f, NULL);
	gtk_grid_attach (page, (GtkWidget*) label, 0, rows, 1, 1);
	rows = rows + 1;
	_tmp2_ = _g_object_ref0 (label);
	_g_object_unref0 (self->priv->question_label);
	self->priv->question_label = _tmp2_;
	result = (GtkWidget*) page;
	_g_object_unref0 (label);
	return result;
}


static GtkWidget* assistant_operation_real_make_summary_page (AssistantOperation* self) {
	GtkWidget* result = NULL;
	GtkLabel* _tmp0_ = NULL;
	GtkTextView* _tmp1_ = NULL;
	GtkScrolledWindow* _tmp2_ = NULL;
	GtkScrolledWindow* scroll;
	GtkWidget* _tmp3_;
	GtkBox* _tmp4_ = NULL;
	GtkBox* page;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->summary_label);
	self->summary_label = g_object_ref_sink (_tmp0_);
	g_object_set ((GObject*) self->summary_label, "xalign", 0.0f, NULL);
	_tmp1_ = (GtkTextView*) gtk_text_view_new ();
	_g_object_unref0 (self->priv->error_text_view);
	self->priv->error_text_view = g_object_ref_sink (_tmp1_);
	gtk_text_view_set_editable (self->priv->error_text_view, FALSE);
	gtk_text_view_set_wrap_mode (self->priv->error_text_view, GTK_WRAP_WORD);
	g_object_set ((GtkWidget*) self->priv->error_text_view, "height-request", 150, NULL);
	_tmp2_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	scroll = g_object_ref_sink (_tmp2_);
	gtk_container_add ((GtkContainer*) scroll, (GtkWidget*) self->priv->error_text_view);
	gtk_widget_set_no_show_all ((GtkWidget*) scroll, TRUE);
	_tmp3_ = _g_object_ref0 ((GtkWidget*) scroll);
	_g_object_unref0 (self->priv->error_widget);
	self->priv->error_widget = _tmp3_;
	_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	page = g_object_ref_sink (_tmp4_);
	g_object_set ((GObject*) page, "child", self->summary_label, "child", self->priv->error_widget, "border-width", 12, NULL);
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) self->summary_label, "expand", FALSE, NULL);
	gtk_container_child_set ((GtkContainer*) page, self->priv->error_widget, "expand", TRUE, NULL);
	result = (GtkWidget*) page;
	_g_object_unref0 (scroll);
	return result;
}


GtkWidget* assistant_operation_make_summary_page (AssistantOperation* self) {
	return ASSISTANT_OPERATION_GET_CLASS (self)->make_summary_page (self);
}


static void assistant_operation_add_confirm_page (AssistantOperation* self) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* page;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_operation_make_confirm_page (self);
	page = _tmp0_;
	if (page == NULL) {
		_g_object_unref0 (page);
		return;
	}
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_SUMMARY);
	_tmp1_ = _ ("Summary");
	assistant_set_page_title ((Assistant*) self, page, _tmp1_);
	assistant_operation_set_confirm_page (self, page);
	_g_object_unref0 (page);
}


static void assistant_operation_add_progress_page (AssistantOperation* self) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* page;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_operation_make_progress_page (self);
	page = _tmp0_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_PROGRESS);
	assistant_operation_set_progress_page (self, page);
	_g_object_unref0 (page);
}


static void assistant_operation_add_password_page (AssistantOperation* self) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* page;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_operation_make_password_page (self);
	page = _tmp0_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_INTERRUPT);
	assistant_operation_set_password_page (self, page);
	_g_object_unref0 (page);
}


static void assistant_operation_add_question_page (AssistantOperation* self) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* page;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_operation_make_question_page (self);
	page = _tmp0_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_INTERRUPT);
	assistant_operation_set_question_page (self, page);
	_g_object_unref0 (page);
}


static void assistant_operation_add_summary_page (AssistantOperation* self) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* page;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_operation_make_summary_page (self);
	page = _tmp0_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_FINISH);
	assistant_operation_set_summary_page (self, page);
	_g_object_unref0 (page);
}


static void assistant_operation_real_apply_finished (AssistantOperation* self, DejaDupOperation* op, gboolean success, gboolean cancelled) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	if (self->status_icon != NULL) {
		status_icon_done (self->status_icon, success, cancelled);
		_g_object_unref0 (self->status_icon);
		self->status_icon = NULL;
	}
	_g_object_unref0 (self->op);
	self->op = NULL;
	if (cancelled) {
		if (success) {
			gtk_main_quit ();
		} else {
			assistant_operation_do_close (self);
		}
	} else {
		if (success) {
			self->succeeded = TRUE;
			assistant_go_to_page ((Assistant*) self, self->priv->_summary_page);
		} else {
			assistant_operation_force_visible (self, FALSE);
		}
	}
}


void assistant_operation_apply_finished (AssistantOperation* self, DejaDupOperation* op, gboolean success, gboolean cancelled) {
	ASSISTANT_OPERATION_GET_CLASS (self)->apply_finished (self, op, success, cancelled);
}


static void _lambda13_ (StatusIcon* s, AssistantOperation* self) {
	g_return_if_fail (s != NULL);
	assistant_operation_force_visible (self, TRUE);
}


static void __lambda13__status_icon_show_window (StatusIcon* _sender, gpointer self) {
	_lambda13_ (_sender, self);
}


static void _lambda14_ (StatusIcon* s, AssistantOperation* self) {
	g_return_if_fail (s != NULL);
	assistant_operation_hide_everything (self);
}


static void __lambda14__status_icon_hide_all (StatusIcon* _sender, gpointer self) {
	_lambda14_ (_sender, self);
}


void assistant_operation_ensure_status_icon (AssistantOperation* self, DejaDupOperation* o) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	if (self->status_icon == NULL) {
		StatusIcon* _tmp0_ = NULL;
		_tmp0_ = status_icon_create ((GtkWindow*) self, o, self->priv->_automatic);
		_g_object_unref0 (self->status_icon);
		self->status_icon = _tmp0_;
		g_signal_connect_object (self->status_icon, "show-window", (GCallback) __lambda13__status_icon_show_window, self, 0);
		g_signal_connect_object (self->status_icon, "hide-all", (GCallback) __lambda14__status_icon_hide_all, self, 0);
	}
}


static void assistant_operation_do_apply_data_free (gpointer _data) {
	AssistantOperationDoApplyData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (AssistantOperationDoApplyData, data);
}


void assistant_operation_do_apply (AssistantOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AssistantOperationDoApplyData* _data_;
	_data_ = g_slice_new0 (AssistantOperationDoApplyData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, assistant_operation_do_apply);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, assistant_operation_do_apply_data_free);
	_data_->self = _g_object_ref0 (self);
	assistant_operation_do_apply_co (_data_);
}


void assistant_operation_do_apply_finish (AssistantOperation* self, GAsyncResult* _res_) {
	AssistantOperationDoApplyData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _assistant_operation_apply_finished_deja_dup_operation_done (DejaDupOperation* _sender, gboolean success, gboolean cancelled, gpointer self) {
	assistant_operation_apply_finished (self, _sender, success, cancelled);
}


static void _lambda15_ (DejaDupOperation* o, const gchar* e, const gchar* d, AssistantOperation* self) {
	g_return_if_fail (o != NULL);
	g_return_if_fail (e != NULL);
	assistant_operation_show_error (self, e, d);
}


static void __lambda15__deja_dup_operation_raise_error (DejaDupOperation* _sender, const gchar* errstr, const gchar* detail, gpointer self) {
	_lambda15_ (_sender, errstr, detail, self);
}


static void _assistant_operation_get_passphrase_deja_dup_operation_passphrase_required (DejaDupOperation* _sender, gpointer self) {
	assistant_operation_get_passphrase (self);
}


static void _assistant_operation_set_progress_label_deja_dup_operation_action_desc_changed (DejaDupOperation* _sender, const gchar* action, gpointer self) {
	assistant_operation_set_progress_label (self, _sender, action);
}


static void _assistant_operation_set_progress_label_file_deja_dup_operation_action_file_changed (DejaDupOperation* _sender, GFile* file, gboolean actual, gpointer self) {
	assistant_operation_set_progress_label_file (self, _sender, file, actual);
}


static void _assistant_operation_show_progress_deja_dup_operation_progress (DejaDupOperation* _sender, gdouble percent, gpointer self) {
	assistant_operation_show_progress (self, _sender, percent);
}


static void _assistant_operation_show_question_deja_dup_operation_question (DejaDupOperation* _sender, const gchar* title, const gchar* msg, gpointer self) {
	assistant_operation_show_question (self, _sender, title, msg);
}


static void _assistant_operation_pause_op_deja_dup_backend_pause_op (DejaDupBackend* _sender, const gchar* header, const gchar* msg, gpointer self) {
	assistant_operation_pause_op (self, _sender, header, msg);
}


static gboolean assistant_operation_do_apply_co (AssistantOperationDoApplyData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = assistant_operation_create_op (data->self);
	_g_object_unref0 (data->self->op);
	data->self->op = data->_tmp0_;
	if (data->self->op == NULL) {
		data->_tmp1_ = NULL;
		data->_tmp1_ = _ ("Failed with an unknown error.");
		assistant_operation_show_error (data->self, data->_tmp1_, NULL);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	g_signal_connect_object (data->self->op, "done", (GCallback) _assistant_operation_apply_finished_deja_dup_operation_done, data->self, 0);
	g_signal_connect_object (data->self->op, "raise-error", (GCallback) __lambda15__deja_dup_operation_raise_error, data->self, 0);
	g_signal_connect_object (data->self->op, "passphrase-required", (GCallback) _assistant_operation_get_passphrase_deja_dup_operation_passphrase_required, data->self, 0);
	g_signal_connect_object (data->self->op, "action-desc-changed", (GCallback) _assistant_operation_set_progress_label_deja_dup_operation_action_desc_changed, data->self, 0);
	g_signal_connect_object (data->self->op, "action-file-changed", (GCallback) _assistant_operation_set_progress_label_file_deja_dup_operation_action_file_changed, data->self, 0);
	g_signal_connect_object (data->self->op, "progress", (GCallback) _assistant_operation_show_progress_deja_dup_operation_progress, data->self, 0);
	g_signal_connect_object (data->self->op, "question", (GCallback) _assistant_operation_show_question_deja_dup_operation_question, data->self, 0);
	data->_tmp2_ = NULL;
	data->_tmp2_ = deja_dup_operation_get_backend (data->self->op);
	data->_tmp3_ = NULL;
	data->_tmp3_ = mount_operation_assistant_new (data->self);
	data->_tmp4_ = data->_tmp3_;
	deja_dup_backend_set_mount_op (data->_tmp2_, (GMountOperation*) data->_tmp4_);
	_g_object_unref0 (data->_tmp4_);
	data->_tmp5_ = NULL;
	data->_tmp5_ = deja_dup_operation_get_backend (data->self->op);
	g_signal_connect_object (data->_tmp5_, "pause-op", (GCallback) _assistant_operation_pause_op_deja_dup_backend_pause_op, data->self, 0);
	assistant_operation_ensure_status_icon (data->self, data->self->op);
	deja_dup_operation_start (data->self->op, NULL, NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gboolean _assistant_operation_pulse_gsource_func (gpointer self) {
	gboolean result;
	result = assistant_operation_pulse (self);
	return result;
}


static void assistant_operation_real_do_prepare (AssistantOperation* self, Assistant* assist, GtkWidget* page) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (assist != NULL);
	g_return_if_fail (page != NULL);
	if (self->priv->timeout_id > 0) {
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
	}
	if (page == self->priv->_confirm_page) {
		if (self->op != NULL) {
			guint _tmp0_;
			g_signal_parse_name ("done", DEJA_DUP_TYPE_OPERATION, &_tmp0_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (self->op, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _assistant_operation_apply_finished_deja_dup_operation_done, self);
			deja_dup_operation_cancel (self->op);
			_g_object_unref0 (self->op);
			self->op = NULL;
		}
	} else {
		if (page == self->priv->_progress_page) {
			guint _tmp1_;
			gboolean _tmp2_ = FALSE;
			gtk_progress_bar_set_fraction (self->priv->progress_bar, (gdouble) 0);
			_tmp1_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 250, _assistant_operation_pulse_gsource_func, g_object_ref (self), g_object_unref);
			self->priv->timeout_id = _tmp1_;
			if (self->op != NULL) {
				gboolean _tmp3_;
				_tmp3_ = deja_dup_operation_get_needs_password (self->op);
				_tmp2_ = _tmp3_;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				assistant_operation_provide_password (self);
			} else {
				if (self->op == NULL) {
					assistant_operation_do_apply (self, NULL, NULL);
				}
			}
		} else {
			if (page == self->priv->_password_page) {
				assistant_set_header_icon ((Assistant*) self, GTK_STOCK_DIALOG_AUTHENTICATION);
			}
		}
	}
}


void assistant_operation_do_prepare (AssistantOperation* self, Assistant* assist, GtkWidget* page) {
	ASSISTANT_OPERATION_GET_CLASS (self)->do_prepare (self, assist, page);
}


void assistant_operation_hide_everything (AssistantOperation* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	if (self->status_icon != NULL) {
		status_icon_done (self->status_icon, FALSE, TRUE);
		_g_object_unref0 (self->status_icon);
		self->status_icon = NULL;
	}
}


static void assistant_operation_real_do_cancel (AssistantOperation* self) {
	g_return_if_fail (self != NULL);
	assistant_operation_hide_everything (self);
	if (self->op != NULL) {
		deja_dup_operation_cancel (self->op);
	} else {
		assistant_operation_do_close (self);
	}
}


void assistant_operation_do_cancel (AssistantOperation* self) {
	ASSISTANT_OPERATION_GET_CLASS (self)->do_cancel (self);
}


static gboolean assistant_operation_do_minimize_to_tray (AssistantOperation* self, GdkEvent* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = assistant_is_interrupted ((Assistant*) self);
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->op == NULL;
	}
	if (_tmp0_) {
		assistant_operation_do_cancel (self);
	} else {
		assistant_hide_for_now ((Assistant*) self);
	}
	result = TRUE;
	return result;
}


static void assistant_operation_real_do_close (AssistantOperation* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->timeout_id > 0) {
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
	}
	g_signal_emit_by_name (self, "closing", self->succeeded);
	deja_dup_destroy_widget ((GtkWidget*) self);
}


void assistant_operation_do_close (AssistantOperation* self) {
	ASSISTANT_OPERATION_GET_CLASS (self)->do_close (self);
}


void assistant_operation_force_visible (AssistantOperation* self, gboolean user_click) {
	guint32 _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_get_current_event_time ();
	assistant_operation_show_to_user (self, (GtkWindow*) self, (guint) _tmp0_, user_click);
}


static gboolean _assistant_operation_user_focused_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = assistant_operation_user_focused (self, _sender, event);
	return result;
}


static gboolean assistant_operation_user_focused (AssistantOperation* self, GtkWidget* win, GdkEventFocus* e) {
	gboolean result = FALSE;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (win != NULL, FALSE);
	gtk_window_set_urgency_hint (GTK_WINDOW (win), FALSE);
	g_signal_parse_name ("focus-in-event", GTK_TYPE_WIDGET, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (win, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _assistant_operation_user_focused_gtk_widget_focus_in_event, self);
	result = FALSE;
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_object_unref0 (_data2_->win);
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean _lambda12_ (Block2Data* _data2_) {
	AssistantOperation * self;
	gboolean result = FALSE;
	self = _data2_->self;
	g_signal_connect_object ((GtkWidget*) _data2_->win, "focus-in-event", (GCallback) _assistant_operation_user_focused_gtk_widget_focus_in_event, self, 0);
	result = FALSE;
	return result;
}


static gboolean __lambda12__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda12_ (self);
	return result;
}


static void assistant_operation_show_to_user (AssistantOperation* self, GtkWindow* win, guint time, gboolean user_click) {
	Block2Data* _data2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (win != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_data2_->win = _g_object_ref0 (win);
	gtk_window_set_focus_on_map (_data2_->win, user_click);
	if (self->priv->saved_pos) {
		gtk_window_move (_data2_->win, self->priv->saved_x, self->priv->saved_y);
	}
	if (user_click) {
		gtk_window_present_with_time (_data2_->win, (guint32) time);
	} else {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_;
		g_object_get (_data2_->win, "is-active", &_tmp1_, NULL);
		if (!_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			gboolean _tmp2_;
			_tmp2_ = gtk_widget_get_visible ((GtkWidget*) _data2_->win);
			_tmp0_ = !_tmp2_;
		}
		if (_tmp0_) {
			gtk_window_set_urgency_hint (_data2_->win, TRUE);
			gtk_widget_show ((GtkWidget*) _data2_->win);
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda12__gsource_func, block2_data_ref (_data2_), block2_data_unref);
		}
	}
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static void assistant_operation_found_passphrase (AssistantOperation* self, GnomeKeyringResult _result_, const gchar* str) {
	g_return_if_fail (self != NULL);
	if (str != NULL) {
		deja_dup_operation_set_passphrase (self->op, str);
	} else {
		assistant_operation_ask_passphrase (self, FALSE);
	}
	g_main_loop_quit (self->priv->password_find_loop);
	_g_main_loop_unref0 (self->priv->password_find_loop);
	self->priv->password_find_loop = NULL;
}


static void _assistant_operation_found_passphrase_gnome_keyring_operation_get_string_callback (GnomeKeyringResult _result_, const gchar* str, gpointer self) {
	assistant_operation_found_passphrase (self, _result_, str);
}


void assistant_operation_get_passphrase (AssistantOperation* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (!self->priv->searched_for_passphrase) {
		gboolean _tmp1_;
		_tmp1_ = deja_dup_in_testing_mode ();
		_tmp0_ = !_tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GMainLoop* _tmp2_ = NULL;
		gnome_keyring_find_password (PASSPHRASE_SCHEMA, _assistant_operation_found_passphrase_gnome_keyring_operation_get_string_callback, g_object_ref (self), g_object_unref, "owner", PACKAGE, "type", "passphrase", NULL);
		self->priv->searched_for_passphrase = TRUE;
		_tmp2_ = g_main_loop_new (NULL, FALSE);
		_g_main_loop_unref0 (self->priv->password_find_loop);
		self->priv->password_find_loop = _tmp2_;
		g_main_loop_run (self->priv->password_find_loop);
	} else {
		assistant_operation_ask_passphrase (self, FALSE);
	}
}


static void assistant_operation_save_password_callback (AssistantOperation* self, GnomeKeyringResult _result_) {
	g_return_if_fail (self != NULL);
}


static void assistant_operation_check_password_validity (AssistantOperation* self) {
	gboolean _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* passphrase;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->encrypt_enabled);
	if (!_tmp0_) {
		assistant_allow_forward ((Assistant*) self, TRUE);
		return;
	}
	_tmp1_ = gtk_entry_get_text (self->priv->encrypt_entry);
	_tmp2_ = g_strdup (_tmp1_);
	passphrase = _tmp2_;
	if (g_strcmp0 (passphrase, "") == 0) {
		assistant_allow_forward ((Assistant*) self, FALSE);
		_g_free0 (passphrase);
		return;
	}
	_tmp3_ = gtk_widget_get_visible ((GtkWidget*) self->priv->encrypt_confirm_entry);
	if (_tmp3_) {
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* passphrase2;
		gboolean valid;
		_tmp4_ = gtk_entry_get_text (self->priv->encrypt_confirm_entry);
		_tmp5_ = g_strdup (_tmp4_);
		passphrase2 = _tmp5_;
		valid = g_strcmp0 (passphrase, passphrase2) == 0;
		assistant_allow_forward ((Assistant*) self, valid);
		_g_free0 (passphrase2);
	} else {
		assistant_allow_forward ((Assistant*) self, TRUE);
	}
	_g_free0 (passphrase);
}


static void assistant_operation_configure_password_page (AssistantOperation* self, gboolean first) {
	g_return_if_fail (self != NULL);
	if (first) {
		const gchar* _tmp0_ = NULL;
		_tmp0_ = _ ("Require Password?");
		assistant_set_page_title ((Assistant*) self, self->priv->_password_page, _tmp0_);
	} else {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = _ ("Encryption Password Needed");
		assistant_set_page_title ((Assistant*) self, self->priv->_password_page, _tmp1_);
	}
	{
		GList* w_collection;
		GList* w_it;
		w_collection = self->priv->first_password_widgets;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* _tmp2_;
			GtkWidget* w;
			_tmp2_ = _g_object_ref0 ((GtkWidget*) w_it->data);
			w = _tmp2_;
			{
				gtk_widget_set_visible (w, first);
				_g_object_unref0 (w);
			}
		}
	}
	assistant_operation_check_password_validity (self);
	gtk_editable_select_region ((GtkEditable*) self->priv->encrypt_entry, 0, -1);
	gtk_widget_grab_focus ((GtkWidget*) self->priv->encrypt_entry);
}


static gboolean _lambda16_ (AssistantOperation* self) {
	gboolean result = FALSE;
	g_main_loop_quit (self->priv->password_ask_loop);
	_g_main_loop_unref0 (self->priv->password_ask_loop);
	self->priv->password_ask_loop = NULL;
	result = FALSE;
	return result;
}


static gboolean __lambda16__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda16_ (self);
	return result;
}


static void _assistant_operation_stop_password_loop_assistant_response (Assistant* _sender, gint response, gpointer self) {
	assistant_operation_stop_password_loop (self, _sender, response);
}


static void assistant_operation_stop_password_loop (AssistantOperation* self, Assistant* dlg, gint resp) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dlg != NULL);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda16__gsource_func, g_object_ref (self), g_object_unref);
	g_signal_parse_name ("response", TYPE_ASSISTANT, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((Assistant*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _assistant_operation_stop_password_loop_assistant_response, self);
}


void assistant_operation_ask_passphrase (AssistantOperation* self, gboolean first) {
	GMainLoop* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	deja_dup_operation_set_needs_password (self->op, TRUE);
	assistant_interrupt ((Assistant*) self, self->priv->_password_page, TRUE);
	assistant_operation_configure_password_page (self, first);
	assistant_operation_force_visible (self, FALSE);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->password_ask_loop);
	self->priv->password_ask_loop = _tmp0_;
	g_signal_connect_object ((Assistant*) self, "response", (GCallback) _assistant_operation_stop_password_loop_assistant_response, self, 0);
	g_main_loop_run (self->priv->password_ask_loop);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static void _assistant_operation_save_password_callback_gnome_keyring_operation_done_callback (GnomeKeyringResult _result_, gpointer self) {
	assistant_operation_save_password_callback (self, _result_);
}


void assistant_operation_provide_password (AssistantOperation* self) {
	gchar* _tmp0_;
	gchar* passphrase;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	passphrase = _tmp0_;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->encrypt_enabled);
	if (_tmp1_) {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp2_ = gtk_entry_get_text (self->priv->encrypt_entry);
		_tmp3_ = string_strip (_tmp2_);
		_g_free0 (passphrase);
		passphrase = _tmp3_;
	}
	if (g_strcmp0 (passphrase, "") != 0) {
		gboolean _tmp4_;
		_tmp4_ = gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->encrypt_remember);
		if (_tmp4_) {
			const gchar* _tmp5_ = NULL;
			_tmp5_ = _ ("Backup encryption password");
			gnome_keyring_store_password (PASSPHRASE_SCHEMA, GNOME_KEYRING_DEFAULT, _tmp5_, passphrase, _assistant_operation_save_password_callback_gnome_keyring_operation_done_callback, g_object_ref (self), g_object_unref, "owner", PACKAGE, "type", "passphrase", NULL);
		}
	}
	deja_dup_operation_set_passphrase (self->op, passphrase);
	_g_free0 (passphrase);
}


static void _assistant_operation_stop_question_assistant_response (Assistant* _sender, gint response, gpointer self) {
	assistant_operation_stop_question (self, _sender, response);
}


static void assistant_operation_stop_question (AssistantOperation* self, Assistant* dlg, gint resp) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dlg != NULL);
	gtk_main_quit ();
	g_signal_parse_name ("response", TYPE_ASSISTANT, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((Assistant*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _assistant_operation_stop_question_assistant_response, self);
}


static void assistant_operation_show_question (AssistantOperation* self, DejaDupOperation* op, const gchar* title, const gchar* message) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (title != NULL);
	g_return_if_fail (message != NULL);
	assistant_set_page_title ((Assistant*) self, self->priv->_question_page, title);
	gtk_label_set_label (self->priv->question_label, message);
	assistant_interrupt ((Assistant*) self, self->priv->_question_page, TRUE);
	assistant_operation_force_visible (self, FALSE);
	g_signal_connect_object ((Assistant*) self, "response", (GCallback) _assistant_operation_stop_question_assistant_response, self, 0);
	gtk_main ();
}


void assistant_operation_pause_op (AssistantOperation* self, DejaDupBackend* back, const gchar* header, const gchar* msg) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (back != NULL);
	if (header == NULL) {
		assistant_go_forward ((Assistant*) self);
	} else {
		assistant_set_page_title ((Assistant*) self, self->priv->_question_page, header);
		gtk_label_set_label (self->priv->question_label, msg);
		assistant_interrupt ((Assistant*) self, self->priv->_question_page, FALSE);
		assistant_operation_force_visible (self, FALSE);
	}
}


AssistantOperation* assistant_operation_construct (GType object_type) {
	AssistantOperation * self = NULL;
	self = (AssistantOperation*) assistant_construct (object_type);
	return self;
}


GtkWidget* assistant_operation_get_confirm_page (AssistantOperation* self) {
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_confirm_page;
	return result;
}


static void assistant_operation_set_confirm_page (AssistantOperation* self, GtkWidget* value) {
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_confirm_page);
	self->priv->_confirm_page = _tmp0_;
	g_object_notify ((GObject *) self, "confirm-page");
}


gboolean assistant_operation_get_automatic (AssistantOperation* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_automatic;
	return result;
}


static void assistant_operation_set_automatic (AssistantOperation* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_automatic = value;
	g_object_notify ((GObject *) self, "automatic");
}


GtkWidget* assistant_operation_get_password_page (AssistantOperation* self) {
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_password_page;
	return result;
}


static void assistant_operation_set_password_page (AssistantOperation* self, GtkWidget* value) {
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_password_page);
	self->priv->_password_page = _tmp0_;
	g_object_notify ((GObject *) self, "password-page");
}


GtkWidget* assistant_operation_get_question_page (AssistantOperation* self) {
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_question_page;
	return result;
}


static void assistant_operation_set_question_page (AssistantOperation* self, GtkWidget* value) {
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_question_page);
	self->priv->_question_page = _tmp0_;
	g_object_notify ((GObject *) self, "question-page");
}


GtkWidget* assistant_operation_get_progress_page (AssistantOperation* self) {
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_progress_page;
	return result;
}


static void assistant_operation_set_progress_page (AssistantOperation* self, GtkWidget* value) {
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_progress_page);
	self->priv->_progress_page = _tmp0_;
	g_object_notify ((GObject *) self, "progress-page");
}


GtkWidget* assistant_operation_get_summary_page (AssistantOperation* self) {
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_summary_page;
	return result;
}


static void assistant_operation_set_summary_page (AssistantOperation* self, GtkWidget* value) {
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_summary_page);
	self->priv->_summary_page = _tmp0_;
	g_object_notify ((GObject *) self, "summary-page");
}


GdkPixbuf* assistant_operation_get_op_icon (AssistantOperation* self) {
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_op_icon;
	return result;
}


static void assistant_operation_set_op_icon (AssistantOperation* self, GdkPixbuf* value) {
	GdkPixbuf* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_op_icon);
	self->priv->_op_icon = _tmp0_;
	g_object_notify ((GObject *) self, "op-icon");
}


gboolean assistant_operation_get_error_occurred (AssistantOperation* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_error_occurred;
	return result;
}


static void assistant_operation_set_error_occurred (AssistantOperation* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_error_occurred = value;
	g_object_notify ((GObject *) self, "error-occurred");
}


static void _assistant_operation_do_cancel_assistant_canceled (Assistant* _sender, gpointer self) {
	assistant_operation_do_cancel (self);
}


static void _assistant_operation_do_close_assistant_closed (Assistant* _sender, gpointer self) {
	assistant_operation_do_close (self);
}


static void _assistant_operation_do_prepare_assistant_prepare (Assistant* _sender, GtkWidget* page, gpointer self) {
	assistant_operation_do_prepare (self, _sender, page);
}


static gboolean _assistant_operation_do_minimize_to_tray_gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self) {
	gboolean result;
	result = assistant_operation_do_minimize_to_tray (self, event);
	return result;
}


static GObject * assistant_operation_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	AssistantOperation * self;
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_;
	parent_class = G_OBJECT_CLASS (assistant_operation_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = ASSISTANT_OPERATION (obj);
	gtk_window_set_icon_name ((GtkWindow*) self, "deja-dup");
	_tmp0_ = assistant_operation_make_op_icon (self);
	_tmp1_ = _tmp0_;
	assistant_operation_set_op_icon (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	g_object_set (((Assistant*) self)->header_icon, "pixbuf", self->priv->_op_icon, NULL);
	assistant_operation_add_custom_config_pages (self);
	assistant_operation_add_setup_pages (self);
	assistant_operation_add_confirm_page (self);
	assistant_operation_add_password_page (self);
	assistant_operation_add_question_page (self);
	assistant_operation_add_progress_page (self);
	assistant_operation_add_summary_page (self);
	g_signal_connect_object ((Assistant*) self, "canceled", (GCallback) _assistant_operation_do_cancel_assistant_canceled, self, 0);
	g_signal_connect_object ((Assistant*) self, "closed", (GCallback) _assistant_operation_do_close_assistant_closed, self, 0);
	g_signal_connect_object ((Assistant*) self, "prepare", (GCallback) _assistant_operation_do_prepare_assistant_prepare, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) _assistant_operation_do_minimize_to_tray_gtk_widget_delete_event, self, 0);
	return obj;
}


static void assistant_operation_class_init (AssistantOperationClass * klass) {
	assistant_operation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AssistantOperationPrivate));
	ASSISTANT_OPERATION_CLASS (klass)->make_confirm_page = assistant_operation_real_make_confirm_page;
	ASSISTANT_OPERATION_CLASS (klass)->add_setup_pages = assistant_operation_real_add_setup_pages;
	ASSISTANT_OPERATION_CLASS (klass)->add_custom_config_pages = assistant_operation_real_add_custom_config_pages;
	ASSISTANT_OPERATION_CLASS (klass)->create_op = assistant_operation_real_create_op;
	ASSISTANT_OPERATION_CLASS (klass)->get_progress_file_prefix = assistant_operation_real_get_progress_file_prefix;
	ASSISTANT_OPERATION_CLASS (klass)->make_progress_page = assistant_operation_real_make_progress_page;
	ASSISTANT_OPERATION_CLASS (klass)->show_error = assistant_operation_real_show_error;
	ASSISTANT_OPERATION_CLASS (klass)->make_summary_page = assistant_operation_real_make_summary_page;
	ASSISTANT_OPERATION_CLASS (klass)->apply_finished = assistant_operation_real_apply_finished;
	ASSISTANT_OPERATION_CLASS (klass)->do_prepare = assistant_operation_real_do_prepare;
	ASSISTANT_OPERATION_CLASS (klass)->do_cancel = assistant_operation_real_do_cancel;
	ASSISTANT_OPERATION_CLASS (klass)->do_close = assistant_operation_real_do_close;
	G_OBJECT_CLASS (klass)->get_property = _vala_assistant_operation_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_assistant_operation_set_property;
	G_OBJECT_CLASS (klass)->constructor = assistant_operation_constructor;
	G_OBJECT_CLASS (klass)->finalize = assistant_operation_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_CONFIRM_PAGE, g_param_spec_object ("confirm-page", "confirm-page", "confirm-page", GTK_TYPE_WIDGET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_AUTOMATIC, g_param_spec_boolean ("automatic", "automatic", "automatic", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_PASSWORD_PAGE, g_param_spec_object ("password-page", "password-page", "password-page", GTK_TYPE_WIDGET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_QUESTION_PAGE, g_param_spec_object ("question-page", "question-page", "question-page", GTK_TYPE_WIDGET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_PROGRESS_PAGE, g_param_spec_object ("progress-page", "progress-page", "progress-page", GTK_TYPE_WIDGET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_SUMMARY_PAGE, g_param_spec_object ("summary-page", "summary-page", "summary-page", GTK_TYPE_WIDGET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_OP_ICON, g_param_spec_object ("op-icon", "op-icon", "op-icon", GDK_TYPE_PIXBUF, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_ERROR_OCCURRED, g_param_spec_boolean ("error-occurred", "error-occurred", "error-occurred", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("closing", TYPE_ASSISTANT_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}


static void assistant_operation_instance_init (AssistantOperation * self) {
	self->priv = ASSISTANT_OPERATION_GET_PRIVATE (self);
	self->priv->_automatic = FALSE;
	self->succeeded = FALSE;
	self->priv->searched_for_passphrase = FALSE;
}


static void assistant_operation_finalize (GObject* obj) {
	AssistantOperation * self;
	self = ASSISTANT_OPERATION (obj);
	_g_object_unref0 (self->priv->_confirm_page);
	_g_object_unref0 (self->status_icon);
	_g_object_unref0 (self->priv->encrypt_entry);
	_g_object_unref0 (self->priv->encrypt_confirm_entry);
	_g_object_unref0 (self->priv->encrypt_enabled);
	_g_object_unref0 (self->priv->encrypt_remember);
	_g_object_unref0 (self->priv->_password_page);
	__g_list_free__g_object_unref0_0 (self->priv->first_password_widgets);
	_g_main_loop_unref0 (self->priv->password_ask_loop);
	_g_main_loop_unref0 (self->priv->password_find_loop);
	_g_object_unref0 (self->priv->password_toggles);
	_g_object_unref0 (self->priv->question_label);
	_g_object_unref0 (self->priv->_question_page);
	_g_object_unref0 (self->priv->progress_label);
	_g_object_unref0 (self->priv->progress_file_label);
	_g_object_unref0 (self->priv->secondary_label);
	_g_object_unref0 (self->priv->progress_bar);
	_g_object_unref0 (self->priv->progress_text);
	_g_object_unref0 (self->priv->progress_scroll);
	_g_object_unref0 (self->priv->progress_expander);
	_g_object_unref0 (self->priv->_progress_page);
	_g_object_unref0 (self->summary_label);
	_g_object_unref0 (self->priv->error_widget);
	_g_object_unref0 (self->priv->error_text_view);
	_g_object_unref0 (self->priv->_summary_page);
	_g_object_unref0 (self->priv->_op_icon);
	_g_object_unref0 (self->op);
	G_OBJECT_CLASS (assistant_operation_parent_class)->finalize (obj);
}


GType assistant_operation_get_type (void) {
	static volatile gsize assistant_operation_type_id__volatile = 0;
	if (g_once_init_enter (&assistant_operation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AssistantOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) assistant_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AssistantOperation), 0, (GInstanceInitFunc) assistant_operation_instance_init, NULL };
		GType assistant_operation_type_id;
		assistant_operation_type_id = g_type_register_static (TYPE_ASSISTANT, "AssistantOperation", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&assistant_operation_type_id__volatile, assistant_operation_type_id);
	}
	return assistant_operation_type_id__volatile;
}


static void _vala_assistant_operation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AssistantOperation * self;
	self = ASSISTANT_OPERATION (object);
	switch (property_id) {
		case ASSISTANT_OPERATION_CONFIRM_PAGE:
		g_value_set_object (value, assistant_operation_get_confirm_page (self));
		break;
		case ASSISTANT_OPERATION_AUTOMATIC:
		g_value_set_boolean (value, assistant_operation_get_automatic (self));
		break;
		case ASSISTANT_OPERATION_PASSWORD_PAGE:
		g_value_set_object (value, assistant_operation_get_password_page (self));
		break;
		case ASSISTANT_OPERATION_QUESTION_PAGE:
		g_value_set_object (value, assistant_operation_get_question_page (self));
		break;
		case ASSISTANT_OPERATION_PROGRESS_PAGE:
		g_value_set_object (value, assistant_operation_get_progress_page (self));
		break;
		case ASSISTANT_OPERATION_SUMMARY_PAGE:
		g_value_set_object (value, assistant_operation_get_summary_page (self));
		break;
		case ASSISTANT_OPERATION_OP_ICON:
		g_value_set_object (value, assistant_operation_get_op_icon (self));
		break;
		case ASSISTANT_OPERATION_ERROR_OCCURRED:
		g_value_set_boolean (value, assistant_operation_get_error_occurred (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_assistant_operation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AssistantOperation * self;
	self = ASSISTANT_OPERATION (object);
	switch (property_id) {
		case ASSISTANT_OPERATION_CONFIRM_PAGE:
		assistant_operation_set_confirm_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_AUTOMATIC:
		assistant_operation_set_automatic (self, g_value_get_boolean (value));
		break;
		case ASSISTANT_OPERATION_PASSWORD_PAGE:
		assistant_operation_set_password_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_QUESTION_PAGE:
		assistant_operation_set_question_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_PROGRESS_PAGE:
		assistant_operation_set_progress_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_SUMMARY_PAGE:
		assistant_operation_set_summary_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_OP_ICON:
		assistant_operation_set_op_icon (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_ERROR_OCCURRED:
		assistant_operation_set_error_occurred (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



