/* BackendAuto.c generated by valac 0.12.1, the Vala compiler
 * generated from BackendAuto.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define DEJA_DUP_TYPE_BACKEND (deja_dup_backend_get_type ())
#define DEJA_DUP_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackend))
#define DEJA_DUP_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))
#define DEJA_DUP_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))

typedef struct _DejaDupBackend DejaDupBackend;
typedef struct _DejaDupBackendClass DejaDupBackendClass;
typedef struct _DejaDupBackendPrivate DejaDupBackendPrivate;

#define DEJA_DUP_OPERATION_TYPE_MODE (deja_dup_operation_mode_get_type ())

#define DEJA_DUP_TYPE_BACKEND_AUTO (deja_dup_backend_auto_get_type ())
#define DEJA_DUP_BACKEND_AUTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND_AUTO, DejaDupBackendAuto))
#define DEJA_DUP_BACKEND_AUTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND_AUTO, DejaDupBackendAutoClass))
#define DEJA_DUP_IS_BACKEND_AUTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND_AUTO))
#define DEJA_DUP_IS_BACKEND_AUTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND_AUTO))
#define DEJA_DUP_BACKEND_AUTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND_AUTO, DejaDupBackendAutoClass))

typedef struct _DejaDupBackendAuto DejaDupBackendAuto;
typedef struct _DejaDupBackendAutoClass DejaDupBackendAutoClass;
typedef struct _DejaDupBackendAutoPrivate DejaDupBackendAutoPrivate;

#define DEJA_DUP_TYPE_CHECKER (deja_dup_checker_get_type ())
#define DEJA_DUP_CHECKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CHECKER, DejaDupChecker))
#define DEJA_DUP_CHECKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CHECKER, DejaDupCheckerClass))
#define DEJA_DUP_IS_CHECKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CHECKER))
#define DEJA_DUP_IS_CHECKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CHECKER))
#define DEJA_DUP_CHECKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CHECKER, DejaDupCheckerClass))

typedef struct _DejaDupChecker DejaDupChecker;
typedef struct _DejaDupCheckerClass DejaDupCheckerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define DEJA_DUP_TYPE_SIMPLE_SETTINGS (deja_dup_simple_settings_get_type ())
#define DEJA_DUP_SIMPLE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_SIMPLE_SETTINGS, DejaDupSimpleSettings))
#define DEJA_DUP_SIMPLE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_SIMPLE_SETTINGS, DejaDupSimpleSettingsClass))
#define DEJA_DUP_IS_SIMPLE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_SIMPLE_SETTINGS))
#define DEJA_DUP_IS_SIMPLE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_SIMPLE_SETTINGS))
#define DEJA_DUP_SIMPLE_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_SIMPLE_SETTINGS, DejaDupSimpleSettingsClass))

typedef struct _DejaDupSimpleSettings DejaDupSimpleSettings;
typedef struct _DejaDupSimpleSettingsClass DejaDupSimpleSettingsClass;

typedef enum  {
	DEJA_DUP_OPERATION_MODE_INVALID,
	DEJA_DUP_OPERATION_MODE_BACKUP,
	DEJA_DUP_OPERATION_MODE_RESTORE,
	DEJA_DUP_OPERATION_MODE_STATUS,
	DEJA_DUP_OPERATION_MODE_LIST,
	DEJA_DUP_OPERATION_MODE_FILEHISTORY
} DejaDupOperationMode;

struct _DejaDupBackend {
	GObject parent_instance;
	DejaDupBackendPrivate * priv;
};

struct _DejaDupBackendClass {
	GObjectClass parent_class;
	gboolean (*is_native) (DejaDupBackend* self);
	GIcon* (*get_icon) (DejaDupBackend* self);
	gchar* (*get_location) (DejaDupBackend* self, GError** error);
	gchar* (*get_location_pretty) (DejaDupBackend* self, GError** error);
	gboolean (*is_ready) (DejaDupBackend* self, gchar** when);
	void (*get_envp) (DejaDupBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*get_envp_finish) (DejaDupBackend* self, GAsyncResult* _res_, GError** error);
	void (*get_space) (DejaDupBackend* self, gboolean free, GAsyncReadyCallback _callback_, gpointer _user_data_);
	guint64 (*get_space_finish) (DejaDupBackend* self, GAsyncResult* _res_);
	gboolean (*space_can_be_infinite) (DejaDupBackend* self);
	void (*add_argv) (DejaDupBackend* self, DejaDupOperationMode mode, GList** argv);
	DejaDupBackend* (*clone) (DejaDupBackend* self);
};

struct _DejaDupBackendAuto {
	DejaDupBackend parent_instance;
	DejaDupBackendAutoPrivate * priv;
};

struct _DejaDupBackendAutoClass {
	DejaDupBackendClass parent_class;
};

struct _DejaDupBackendAutoPrivate {
	DejaDupChecker* u1checker;
	DejaDupChecker* s3checker;
};


static gpointer deja_dup_backend_auto_parent_class = NULL;
static gboolean deja_dup_backend_auto_started;
static gboolean deja_dup_backend_auto_started = FALSE;
static gboolean deja_dup_backend_auto_done;
static gboolean deja_dup_backend_auto_done = FALSE;

GType deja_dup_backend_get_type (void) G_GNUC_CONST;
GType deja_dup_operation_mode_get_type (void) G_GNUC_CONST;
GType deja_dup_backend_auto_get_type (void) G_GNUC_CONST;
GType deja_dup_checker_get_type (void) G_GNUC_CONST;
#define DEJA_DUP_BACKEND_AUTO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_BACKEND_AUTO, DejaDupBackendAutoPrivate))
enum  {
	DEJA_DUP_BACKEND_AUTO_DUMMY_PROPERTY
};
static DejaDupBackend* deja_dup_backend_auto_real_clone (DejaDupBackend* base);
DejaDupBackendAuto* deja_dup_backend_auto_new (void);
DejaDupBackendAuto* deja_dup_backend_auto_construct (GType object_type);
static gboolean deja_dup_backend_auto_real_is_native (DejaDupBackend* base);
static GIcon* deja_dup_backend_auto_real_get_icon (DejaDupBackend* base);
static gboolean deja_dup_backend_auto_real_is_ready (DejaDupBackend* base, gchar** when);
static gchar* deja_dup_backend_auto_real_get_location (DejaDupBackend* base, GError** error);
static gchar* deja_dup_backend_auto_real_get_location_pretty (DejaDupBackend* base, GError** error);
static void deja_dup_backend_auto_examine_checkers (DejaDupBackendAuto* self);
gboolean deja_dup_checker_get_complete (DejaDupChecker* self);
gboolean deja_dup_checker_get_available (DejaDupChecker* self);
static void deja_dup_backend_auto_finish (DejaDupBackendAuto* self, const gchar* mode);
GType deja_dup_simple_settings_get_type (void) G_GNUC_CONST;
DejaDupSimpleSettings* deja_dup_get_settings (const gchar* subdir);
#define DEJA_DUP_FILE_ROOT "File"
void deja_dup_simple_settings_set_string (DejaDupSimpleSettings* self, const gchar* k, const gchar* v);
#define DEJA_DUP_FILE_TYPE_KEY "type"
#define DEJA_DUP_FILE_PATH_KEY "path"
void deja_dup_simple_settings_apply (DejaDupSimpleSettings* self);
#define DEJA_DUP_BACKEND_KEY "backend"
DejaDupBackend* deja_dup_backend_construct (GType object_type);
static GObject * deja_dup_backend_auto_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
DejaDupChecker* deja_dup_backend_u1_get_checker (void);
static void _deja_dup_backend_auto_examine_checkers_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
DejaDupChecker* deja_dup_backend_s3_get_checker (void);
static void deja_dup_backend_auto_finalize (GObject* obj);


static DejaDupBackend* deja_dup_backend_auto_real_clone (DejaDupBackend* base) {
	DejaDupBackendAuto * self;
	DejaDupBackend* result = NULL;
	DejaDupBackendAuto* _tmp0_ = NULL;
	self = (DejaDupBackendAuto*) base;
	_tmp0_ = deja_dup_backend_auto_new ();
	result = (DejaDupBackend*) _tmp0_;
	return result;
}


static gboolean deja_dup_backend_auto_real_is_native (DejaDupBackend* base) {
	DejaDupBackendAuto * self;
	gboolean result = FALSE;
	self = (DejaDupBackendAuto*) base;
	result = FALSE;
	return result;
}


static GIcon* deja_dup_backend_auto_real_get_icon (DejaDupBackend* base) {
	DejaDupBackendAuto * self;
	GIcon* result = NULL;
	self = (DejaDupBackendAuto*) base;
	result = NULL;
	return result;
}


static gboolean deja_dup_backend_auto_real_is_ready (DejaDupBackend* base, gchar** when) {
	DejaDupBackendAuto * self;
	gchar* _when = NULL;
	gboolean result = FALSE;
	self = (DejaDupBackendAuto*) base;
	_g_free0 (_when);
	_when = NULL;
	result = FALSE;
	if (when) {
		*when = _when;
	} else {
		_g_free0 (_when);
	}
	return result;
}


static gchar* deja_dup_backend_auto_real_get_location (DejaDupBackend* base, GError** error) {
	DejaDupBackendAuto * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (DejaDupBackendAuto*) base;
	_tmp0_ = g_strdup ("invalid");
	result = _tmp0_;
	return result;
}


static gchar* deja_dup_backend_auto_real_get_location_pretty (DejaDupBackend* base, GError** error) {
	DejaDupBackendAuto * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (DejaDupBackendAuto*) base;
	_tmp0_ = g_strdup ("");
	result = _tmp0_;
	return result;
}


static void deja_dup_backend_auto_examine_checkers (DejaDupBackendAuto* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	if (deja_dup_backend_auto_done) {
		return;
	}
	_tmp0_ = deja_dup_checker_get_complete (self->priv->u1checker);
	if (_tmp0_) {
		gboolean _tmp1_;
		_tmp1_ = deja_dup_checker_get_available (self->priv->u1checker);
		if (_tmp1_) {
			deja_dup_backend_auto_finish (self, "u1");
		} else {
			gboolean _tmp2_;
			_tmp2_ = deja_dup_checker_get_complete (self->priv->s3checker);
			if (_tmp2_) {
				gboolean _tmp3_;
				_tmp3_ = deja_dup_checker_get_available (self->priv->s3checker);
				if (_tmp3_) {
					deja_dup_backend_auto_finish (self, "s3");
				} else {
					deja_dup_backend_auto_finish (self, "file");
				}
			}
		}
	}
}


static void deja_dup_backend_auto_finish (DejaDupBackendAuto* self, const gchar* mode) {
	DejaDupSimpleSettings* _tmp3_ = NULL;
	DejaDupSimpleSettings* settings;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mode != NULL);
	if (g_strcmp0 (mode, "file") == 0) {
		DejaDupSimpleSettings* _tmp0_ = NULL;
		DejaDupSimpleSettings* file_settings;
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* path;
		_tmp0_ = deja_dup_get_settings (DEJA_DUP_FILE_ROOT);
		file_settings = _tmp0_;
		g_settings_delay ((GSettings*) file_settings);
		deja_dup_simple_settings_set_string (file_settings, DEJA_DUP_FILE_TYPE_KEY, "normal");
		_tmp1_ = g_get_home_dir ();
		_tmp2_ = g_build_filename (_tmp1_, "deja-dup", NULL);
		path = _tmp2_;
		deja_dup_simple_settings_set_string (file_settings, DEJA_DUP_FILE_PATH_KEY, path);
		deja_dup_simple_settings_apply (file_settings);
		_g_free0 (path);
		_g_object_unref0 (file_settings);
	}
	_tmp3_ = deja_dup_get_settings (NULL);
	settings = _tmp3_;
	deja_dup_simple_settings_set_string (settings, DEJA_DUP_BACKEND_KEY, mode);
	deja_dup_backend_auto_done = TRUE;
	g_object_unref ((GObject*) self);
	_g_object_unref0 (settings);
}


DejaDupBackendAuto* deja_dup_backend_auto_construct (GType object_type) {
	DejaDupBackendAuto * self = NULL;
	self = (DejaDupBackendAuto*) deja_dup_backend_construct (object_type);
	return self;
}


DejaDupBackendAuto* deja_dup_backend_auto_new (void) {
	return deja_dup_backend_auto_construct (DEJA_DUP_TYPE_BACKEND_AUTO);
}


static void _deja_dup_backend_auto_examine_checkers_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	deja_dup_backend_auto_examine_checkers (self);
}


static GObject * deja_dup_backend_auto_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DejaDupBackendAuto * self;
	parent_class = G_OBJECT_CLASS (deja_dup_backend_auto_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DEJA_DUP_BACKEND_AUTO (obj);
	if (!deja_dup_backend_auto_started) {
		DejaDupChecker* _tmp0_ = NULL;
		DejaDupChecker* _tmp1_ = NULL;
		deja_dup_backend_auto_started = TRUE;
		g_object_ref ((GObject*) self);
		_tmp0_ = deja_dup_backend_u1_get_checker ();
		_g_object_unref0 (self->priv->u1checker);
		self->priv->u1checker = _tmp0_;
		g_signal_connect_object ((GObject*) self->priv->u1checker, "notify::complete", (GCallback) _deja_dup_backend_auto_examine_checkers_g_object_notify, self, 0);
		_tmp1_ = deja_dup_backend_s3_get_checker ();
		_g_object_unref0 (self->priv->s3checker);
		self->priv->s3checker = _tmp1_;
		g_signal_connect_object ((GObject*) self->priv->s3checker, "notify::complete", (GCallback) _deja_dup_backend_auto_examine_checkers_g_object_notify, self, 0);
		deja_dup_backend_auto_examine_checkers (self);
	}
	return obj;
}


static void deja_dup_backend_auto_class_init (DejaDupBackendAutoClass * klass) {
	deja_dup_backend_auto_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupBackendAutoPrivate));
	DEJA_DUP_BACKEND_CLASS (klass)->clone = deja_dup_backend_auto_real_clone;
	DEJA_DUP_BACKEND_CLASS (klass)->is_native = deja_dup_backend_auto_real_is_native;
	DEJA_DUP_BACKEND_CLASS (klass)->get_icon = deja_dup_backend_auto_real_get_icon;
	DEJA_DUP_BACKEND_CLASS (klass)->is_ready = deja_dup_backend_auto_real_is_ready;
	DEJA_DUP_BACKEND_CLASS (klass)->get_location = deja_dup_backend_auto_real_get_location;
	DEJA_DUP_BACKEND_CLASS (klass)->get_location_pretty = deja_dup_backend_auto_real_get_location_pretty;
	G_OBJECT_CLASS (klass)->constructor = deja_dup_backend_auto_constructor;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_backend_auto_finalize;
}


static void deja_dup_backend_auto_instance_init (DejaDupBackendAuto * self) {
	self->priv = DEJA_DUP_BACKEND_AUTO_GET_PRIVATE (self);
}


static void deja_dup_backend_auto_finalize (GObject* obj) {
	DejaDupBackendAuto * self;
	self = DEJA_DUP_BACKEND_AUTO (obj);
	_g_object_unref0 (self->priv->u1checker);
	_g_object_unref0 (self->priv->s3checker);
	G_OBJECT_CLASS (deja_dup_backend_auto_parent_class)->finalize (obj);
}


GType deja_dup_backend_auto_get_type (void) {
	static volatile gsize deja_dup_backend_auto_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_backend_auto_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupBackendAutoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_backend_auto_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupBackendAuto), 0, (GInstanceInitFunc) deja_dup_backend_auto_instance_init, NULL };
		GType deja_dup_backend_auto_type_id;
		deja_dup_backend_auto_type_id = g_type_register_static (DEJA_DUP_TYPE_BACKEND, "DejaDupBackendAuto", &g_define_type_info, 0);
		g_once_init_leave (&deja_dup_backend_auto_type_id__volatile, deja_dup_backend_auto_type_id);
	}
	return deja_dup_backend_auto_type_id__volatile;
}



