/* MountOperationAssistant.c generated by valac, the Vala compiler
 * generated from MountOperationAssistant.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2009 Michael Terry <mike@mterry.name>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <whacks.h>


#define TYPE_MOUNT_OPERATION_ASSISTANT (mount_operation_assistant_get_type ())
#define MOUNT_OPERATION_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistant))
#define MOUNT_OPERATION_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistantClass))
#define IS_MOUNT_OPERATION_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_OPERATION_ASSISTANT))
#define IS_MOUNT_OPERATION_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_OPERATION_ASSISTANT))
#define MOUNT_OPERATION_ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistantClass))

typedef struct _MountOperationAssistant MountOperationAssistant;
typedef struct _MountOperationAssistantClass MountOperationAssistantClass;
typedef struct _MountOperationAssistantPrivate MountOperationAssistantPrivate;

#define TYPE_ASSISTANT (assistant_get_type ())
#define ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT, Assistant))
#define ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT, AssistantClass))
#define IS_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT))
#define IS_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT))
#define ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT, AssistantClass))

typedef struct _Assistant Assistant;
typedef struct _AssistantClass AssistantClass;

#define TYPE_ASSISTANT_OPERATION (assistant_operation_get_type ())
#define ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperation))
#define ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))
#define IS_ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_OPERATION))
#define IS_ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_OPERATION))
#define ASSISTANT_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))

typedef struct _AssistantOperation AssistantOperation;
typedef struct _AssistantOperationClass AssistantOperationClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define ASSISTANT_TYPE_TYPE (assistant_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

struct _MountOperationAssistant {
	GMountOperation parent_instance;
	MountOperationAssistantPrivate * priv;
};

struct _MountOperationAssistantClass {
	GMountOperationClass parent_class;
};

struct _MountOperationAssistantPrivate {
	gboolean _s3_mode;
	AssistantOperation* _assist;
	GtkBin* password_page;
	GtkVBox* layout;
	GtkTable* table;
	GtkRadioButton* anonymous_w;
	GtkCheckButton* remember_w;
	GtkEntry* username_w;
	GtkEntry* domain_w;
	GtkEntry* password_w;
	gboolean looping;
};

typedef enum  {
	ASSISTANT_TYPE_NORMAL,
	ASSISTANT_TYPE_INTERRUPT,
	ASSISTANT_TYPE_SUMMARY,
	ASSISTANT_TYPE_PROGRESS,
	ASSISTANT_TYPE_FINISH
} AssistantType;


static gpointer mount_operation_assistant_parent_class = NULL;

GType mount_operation_assistant_get_type (void);
GType assistant_get_type (void);
GType assistant_operation_get_type (void);
#define MOUNT_OPERATION_ASSISTANT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistantPrivate))
enum  {
	MOUNT_OPERATION_ASSISTANT_DUMMY_PROPERTY,
	MOUNT_OPERATION_ASSISTANT_S3_MODE,
	MOUNT_OPERATION_ASSISTANT_ASSIST
};
static void mount_operation_assistant_do_prepare (MountOperationAssistant* self, Assistant* assist, GtkWidget* page);
static void _mount_operation_assistant_do_prepare_assistant_prepare (Assistant* _sender, GtkWidget* page, gpointer self);
static void mount_operation_assistant_do_backward (MountOperationAssistant* self, Assistant* assist);
static void _mount_operation_assistant_do_backward_assistant_backward (Assistant* _sender, gpointer self);
static void mount_operation_assistant_do_forward (MountOperationAssistant* self, Assistant* assist);
static void _mount_operation_assistant_do_forward_assistant_forward (Assistant* _sender, gpointer self);
static void mount_operation_assistant_do_close (MountOperationAssistant* self, AssistantOperation* op, gboolean success);
static void _mount_operation_assistant_do_close_assistant_operation_closing (AssistantOperation* _sender, gboolean success, gpointer self);
static void mount_operation_assistant_add_password_page (MountOperationAssistant* self);
MountOperationAssistant* mount_operation_assistant_new (AssistantOperation* assist);
MountOperationAssistant* mount_operation_assistant_construct (GType object_type, AssistantOperation* assist);
AssistantOperation* mount_operation_assistant_get_assist (MountOperationAssistant* self);
void assistant_operation_show_error (AssistantOperation* self, const char* _error_, const char* detail);
static void mount_operation_assistant_real_aborted (GMountOperation* base);
static void mount_operation_assistant_flesh_out_password_page (MountOperationAssistant* self, const char* message, const char* default_user, const char* default_domain, GAskPasswordFlags flags);
void assistant_interrupt (Assistant* self, GtkWidget* page, gboolean can_continue);
static void mount_operation_assistant_check_valid_inputs (MountOperationAssistant* self);
void assistant_set_header_icon (Assistant* self, const char* name);
void assistant_operation_force_visible (AssistantOperation* self, gboolean user_click);
static void mount_operation_assistant_real_ask_password (GMountOperation* base, const char* message, const char* default_user, const char* default_domain, GAskPasswordFlags flags);
static void mount_operation_assistant_send_reply (MountOperationAssistant* self, GMountOperationResult _result_);
static void _lambda12_ (GMountOperation* t, GMountOperationResult r, MountOperationAssistant* self);
static void __lambda12__g_mount_operation_reply (GMountOperation* _sender, GMountOperationResult _result_, gpointer self);
static void mount_operation_assistant_real_ask_question (GMountOperation* base, const char* message, char** choices);
GType assistant_type_get_type (void);
void assistant_append_page (Assistant* self, GtkWidget* page, AssistantType type);
void assistant_set_page_title (Assistant* self, GtkWidget* page, const char* title);
gboolean mount_operation_assistant_get_s3_mode (MountOperationAssistant* self);
static void _lambda7_ (GtkToggleButton* b, MountOperationAssistant* self);
static void __lambda7__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _lambda8_ (GtkToggleButton* b, MountOperationAssistant* self);
static void __lambda8__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _lambda9_ (GtkEditable* e, MountOperationAssistant* self);
static void __lambda9__gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void _lambda10_ (GtkEditable* e, MountOperationAssistant* self);
static void __lambda10__gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void _lambda11_ (GtkToggleButton* button, MountOperationAssistant* self);
static void __lambda11__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static gboolean mount_operation_assistant_is_valid_entry (MountOperationAssistant* self, GtkEntry* e);
static gboolean mount_operation_assistant_is_anonymous (MountOperationAssistant* self);
void assistant_allow_forward (Assistant* self, gboolean allow);
void mount_operation_assistant_set_s3_mode (MountOperationAssistant* self, gboolean value);
static void mount_operation_assistant_set_assist (MountOperationAssistant* self, AssistantOperation* value);
static void mount_operation_assistant_finalize (GObject* obj);
static void mount_operation_assistant_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void mount_operation_assistant_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _mount_operation_assistant_do_prepare_assistant_prepare (Assistant* _sender, GtkWidget* page, gpointer self) {
	mount_operation_assistant_do_prepare (self, _sender, page);
}


static void _mount_operation_assistant_do_backward_assistant_backward (Assistant* _sender, gpointer self) {
	mount_operation_assistant_do_backward (self, _sender);
}


static void _mount_operation_assistant_do_forward_assistant_forward (Assistant* _sender, gpointer self) {
	mount_operation_assistant_do_forward (self, _sender);
}


static void _mount_operation_assistant_do_close_assistant_operation_closing (AssistantOperation* _sender, gboolean success, gpointer self) {
	mount_operation_assistant_do_close (self, _sender, success);
}


MountOperationAssistant* mount_operation_assistant_construct (GType object_type, AssistantOperation* assist) {
	MountOperationAssistant * self;
	g_return_val_if_fail (assist != NULL, NULL);
	self = (MountOperationAssistant*) g_object_new (object_type, "assist", assist, NULL);
	g_signal_connect_object ((Assistant*) assist, "prepare", (GCallback) _mount_operation_assistant_do_prepare_assistant_prepare, self, 0);
	g_signal_connect_object ((Assistant*) assist, "backward", (GCallback) _mount_operation_assistant_do_backward_assistant_backward, self, 0);
	g_signal_connect_object ((Assistant*) assist, "forward", (GCallback) _mount_operation_assistant_do_forward_assistant_forward, self, 0);
	g_signal_connect_object (assist, "closing", (GCallback) _mount_operation_assistant_do_close_assistant_operation_closing, self, 0);
	mount_operation_assistant_add_password_page (self);
	return self;
}


MountOperationAssistant* mount_operation_assistant_new (AssistantOperation* assist) {
	return mount_operation_assistant_construct (TYPE_MOUNT_OPERATION_ASSISTANT, assist);
}


static void mount_operation_assistant_real_aborted (GMountOperation* base) {
	MountOperationAssistant * self;
	self = (MountOperationAssistant*) base;
	assistant_operation_show_error (self->priv->_assist, _ ("Location not available"), NULL);
}


static void mount_operation_assistant_real_ask_password (GMountOperation* base, const char* message, const char* default_user, const char* default_domain, GAskPasswordFlags flags) {
	MountOperationAssistant * self;
	self = (MountOperationAssistant*) base;
	g_return_if_fail (message != NULL);
	g_return_if_fail (default_user != NULL);
	g_return_if_fail (default_domain != NULL);
	mount_operation_assistant_flesh_out_password_page (self, message, default_user, default_domain, flags);
	assistant_interrupt ((Assistant*) self->priv->_assist, (GtkWidget*) self->priv->password_page, TRUE);
	self->priv->looping = TRUE;
	mount_operation_assistant_check_valid_inputs (self);
	assistant_set_header_icon ((Assistant*) self->priv->_assist, GTK_STOCK_DIALOG_AUTHENTICATION);
	assistant_operation_force_visible (self->priv->_assist, FALSE);
	gtk_main ();
}


static void _lambda12_ (GMountOperation* t, GMountOperationResult r, MountOperationAssistant* self) {
	g_return_if_fail (t != NULL);
	g_mount_operation_set_choice ((GMountOperation*) self, g_mount_operation_get_choice (t));
	mount_operation_assistant_send_reply (self, r);
}


static void __lambda12__g_mount_operation_reply (GMountOperation* _sender, GMountOperationResult _result_, gpointer self) {
	_lambda12_ (_sender, _result_, self);
}


static void mount_operation_assistant_real_ask_question (GMountOperation* base, const char* message, char** choices) {
	MountOperationAssistant * self;
	GtkMountOperation* t;
	self = (MountOperationAssistant*) base;
	g_return_if_fail (message != NULL);
	t = (GtkMountOperation*) gtk_mount_operation_new ((GtkWindow*) self->priv->_assist);
	g_signal_connect_object ((GMountOperation*) t, "reply", (GCallback) __lambda12__g_mount_operation_reply, self, 0);
	self->priv->looping = TRUE;
	g_signal_emit_by_name ((GMountOperation*) t, "ask-question", message, choices, -1);
	gtk_main ();
	_g_object_unref0 (t);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void mount_operation_assistant_add_password_page (MountOperationAssistant* self) {
	GtkEventBox* page;
	GtkBin* _tmp0_;
	g_return_if_fail (self != NULL);
	page = g_object_ref_sink ((GtkEventBox*) gtk_event_box_new ());
	assistant_append_page ((Assistant*) self->priv->_assist, (GtkWidget*) page, ASSISTANT_TYPE_INTERRUPT);
	self->priv->password_page = (_tmp0_ = _g_object_ref0 ((GtkBin*) page), _g_object_unref0 (self->priv->password_page), _tmp0_);
	_g_object_unref0 (page);
}


static void _lambda7_ (GtkToggleButton* b, MountOperationAssistant* self) {
	g_return_if_fail (b != NULL);
	mount_operation_assistant_check_valid_inputs (self);
}


static void __lambda7__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_lambda7_ (_sender, self);
}


static void _lambda8_ (GtkToggleButton* b, MountOperationAssistant* self) {
	g_return_if_fail (b != NULL);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->table, !gtk_toggle_button_get_active (b));
}


static void __lambda8__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_lambda8_ (_sender, self);
}


static void _lambda9_ (GtkEditable* e, MountOperationAssistant* self) {
	g_return_if_fail (e != NULL);
	mount_operation_assistant_check_valid_inputs (self);
}


static void __lambda9__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	_lambda9_ (_sender, self);
}


static void _lambda10_ (GtkEditable* e, MountOperationAssistant* self) {
	g_return_if_fail (e != NULL);
	mount_operation_assistant_check_valid_inputs (self);
}


static void __lambda10__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	_lambda10_ (_sender, self);
}


static void _lambda11_ (GtkToggleButton* button, MountOperationAssistant* self) {
	g_return_if_fail (button != NULL);
	gtk_entry_set_visibility (self->priv->password_w, gtk_toggle_button_get_active (button));
}


static void __lambda11__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_lambda11_ (_sender, self);
}


static void mount_operation_assistant_flesh_out_password_page (MountOperationAssistant* self, const char* message, const char* default_user, const char* default_domain, GAskPasswordFlags flags) {
	GtkVBox* _tmp0_;
	GtkTable* _tmp1_;
	gint rows;
	gint ucol;
	GtkLabel* label;
	char** _tmp3_;
	gint _tokens_size_;
	gint tokens_length1;
	char** _tmp2_;
	char** tokens;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp8_;
	const char* _tmp23_;
	GtkCheckButton* w;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	g_return_if_fail (default_user != NULL);
	g_return_if_fail (default_domain != NULL);
	if (self->priv->layout != NULL) {
		gtk_object_destroy ((GtkObject*) self->priv->layout);
	}
	self->priv->layout = (_tmp0_ = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6)), _g_object_unref0 (self->priv->layout), _tmp0_);
	g_object_set ((GObject*) self->priv->layout, "border-width", 12, NULL);
	self->priv->table = (_tmp1_ = g_object_ref_sink ((GtkTable*) gtk_table_new ((guint) 0, (guint) 2, FALSE)), _g_object_unref0 (self->priv->table), _tmp1_);
	g_object_set ((GObject*) self->priv->table, "row-spacing", 6, "column-spacing", 6, NULL);
	gtk_container_add ((GtkContainer*) self->priv->password_page, (GtkWidget*) self->priv->layout);
	rows = 0;
	ucol = 0;
	label = NULL;
	tokens = (_tmp3_ = _tmp2_ = g_strsplit (message, "\n", 2), tokens_length1 = _vala_array_length (_tmp2_), _tokens_size_ = tokens_length1, _tmp3_);
	assistant_set_page_title ((Assistant*) self->priv->_assist, (GtkWidget*) self->priv->password_page, tokens[0]);
	label = (_tmp4_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("This backup location requires authentication."))), _g_object_unref0 (label), _tmp4_);
	g_object_set ((GObject*) label, "xalign", 0.f, NULL);
	gtk_box_pack_start ((GtkBox*) self->priv->layout, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	if (tokens[1] != NULL) {
		GtkLabel* _tmp5_;
		label = (_tmp5_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (tokens[1])), _g_object_unref0 (label), _tmp5_);
		g_object_set ((GObject*) label, "xalign", 0.f, NULL);
		gtk_box_pack_start ((GtkBox*) self->priv->layout, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	}
	if (self->priv->_s3_mode) {
		GtkLabel* _tmp7_;
		char* _tmp6_;
		label = (_tmp7_ = hacks_make_link_label (_tmp6_ = g_strdup_printf (_ ("You can sign up for an Amazon S3 account <a href=\"%s\">online</a>."), "http://aws.amazon.com/s3/")), _g_object_unref0 (label), _tmp7_);
		_g_free0 (_tmp6_);
		if (label != NULL) {
			g_object_set ((GObject*) label, "xalign", 0.f, NULL);
			gtk_box_pack_start ((GtkBox*) self->priv->layout, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
		}
	}
	label = (_tmp8_ = g_object_ref_sink ((GtkLabel*) gtk_label_new ("")), _g_object_unref0 (label), _tmp8_);
	gtk_box_pack_start ((GtkBox*) self->priv->layout, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	if ((flags & G_ASK_PASSWORD_ANONYMOUS_SUPPORTED) != 0) {
		GtkRadioButton* _tmp9_;
		GtkRadioButton* w;
		GtkHBox* hbox;
		GtkLabel* _tmp10_;
		self->priv->anonymous_w = (_tmp9_ = g_object_ref_sink ((GtkRadioButton*) gtk_radio_button_new_with_mnemonic (NULL, _ ("Connect _anonymously"))), _g_object_unref0 (self->priv->anonymous_w), _tmp9_);
		g_signal_connect_object ((GtkToggleButton*) self->priv->anonymous_w, "toggled", (GCallback) __lambda7__gtk_toggle_button_toggled, self, 0);
		gtk_box_pack_start ((GtkBox*) self->priv->layout, (GtkWidget*) self->priv->anonymous_w, FALSE, FALSE, (guint) 0);
		w = g_object_ref_sink ((GtkRadioButton*) gtk_radio_button_new_with_mnemonic_from_widget (self->priv->anonymous_w, _ ("Connect as u_ser:")));
		g_signal_connect_object ((GtkToggleButton*) self->priv->anonymous_w, "toggled", (GCallback) __lambda8__gtk_toggle_button_toggled, self, 0);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->table, FALSE);
		gtk_box_pack_start ((GtkBox*) self->priv->layout, (GtkWidget*) w, FALSE, FALSE, (guint) 0);
		hbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 0));
		gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) (_tmp10_ = g_object_ref_sink ((GtkLabel*) gtk_label_new ("    "))), FALSE, FALSE, (guint) 0);
		_g_object_unref0 (_tmp10_);
		gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) self->priv->table, TRUE, TRUE, (guint) 0);
		gtk_box_pack_start ((GtkBox*) self->priv->layout, (GtkWidget*) hbox, FALSE, FALSE, (guint) 0);
		ucol = 1;
		_g_object_unref0 (w);
		_g_object_unref0 (hbox);
	} else {
		GtkRadioButton* _tmp11_;
		self->priv->anonymous_w = (_tmp11_ = NULL, _g_object_unref0 (self->priv->anonymous_w), _tmp11_);
		gtk_box_pack_start ((GtkBox*) self->priv->layout, (GtkWidget*) self->priv->table, FALSE, FALSE, (guint) 0);
	}
	if ((flags & G_ASK_PASSWORD_NEED_USERNAME) != 0) {
		GtkEntry* _tmp12_;
		const char* _tmp13_;
		char* label_txt;
		GtkLabel* _tmp14_;
		self->priv->username_w = (_tmp12_ = g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), _g_object_unref0 (self->priv->username_w), _tmp12_);
		g_object_set ((GObject*) self->priv->username_w, "activates-default", TRUE, "text", default_user, NULL);
		g_signal_connect_object ((GtkEditable*) self->priv->username_w, "changed", (GCallback) __lambda9__gtk_editable_changed, self, 0);
		_tmp13_ = NULL;
		if (self->priv->_s3_mode) {
			_tmp13_ = _ ("_Access key ID:");
		} else {
			_tmp13_ = _ ("_Username:");
		}
		label_txt = g_strdup (_tmp13_);
		label = (_tmp14_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (label_txt)), _g_object_unref0 (label), _tmp14_);
		g_object_set ((GObject*) label, "mnemonic-widget", self->priv->username_w, "use-underline", TRUE, "xalign", 0.0f, NULL);
		gtk_table_attach (self->priv->table, (GtkWidget*) label, (guint) ucol, (guint) (ucol + 1), (guint) rows, (guint) (rows + 1), GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
		gtk_table_attach (self->priv->table, (GtkWidget*) self->priv->username_w, (guint) (ucol + 1), (guint) 3, (guint) rows, (guint) (rows + 1), GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 0, (guint) 0);
		rows = rows + 1;
		_g_free0 (label_txt);
	} else {
		GtkEntry* _tmp15_;
		self->priv->username_w = (_tmp15_ = NULL, _g_object_unref0 (self->priv->username_w), _tmp15_);
	}
	if ((flags & G_ASK_PASSWORD_NEED_DOMAIN) != 0) {
		GtkEntry* _tmp16_;
		GtkLabel* _tmp17_;
		self->priv->domain_w = (_tmp16_ = g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), _g_object_unref0 (self->priv->domain_w), _tmp16_);
		g_object_set ((GObject*) self->priv->domain_w, "activates-default", TRUE, "text", default_domain, NULL);
		g_signal_connect_object ((GtkEditable*) self->priv->domain_w, "changed", (GCallback) __lambda10__gtk_editable_changed, self, 0);
		label = (_tmp17_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("_Domain:"))), _g_object_unref0 (label), _tmp17_);
		g_object_set ((GObject*) label, "mnemonic-widget", self->priv->domain_w, "use-underline", TRUE, "xalign", 0.0f, NULL);
		gtk_table_attach (self->priv->table, (GtkWidget*) label, (guint) ucol, (guint) (ucol + 1), (guint) rows, (guint) (rows + 1), GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
		gtk_table_attach (self->priv->table, (GtkWidget*) self->priv->domain_w, (guint) (ucol + 1), (guint) 3, (guint) rows, (guint) (rows + 1), GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 0, (guint) 0);
		rows = rows + 1;
	} else {
		GtkEntry* _tmp18_;
		self->priv->domain_w = (_tmp18_ = NULL, _g_object_unref0 (self->priv->domain_w), _tmp18_);
	}
	if ((flags & G_ASK_PASSWORD_NEED_PASSWORD) != 0) {
		GtkEntry* _tmp19_;
		const char* _tmp20_;
		char* label_txt;
		GtkLabel* _tmp21_;
		self->priv->password_w = (_tmp19_ = g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), _g_object_unref0 (self->priv->password_w), _tmp19_);
		g_object_set ((GObject*) self->priv->password_w, "visibility", FALSE, "activates-default", TRUE, NULL);
		_tmp20_ = NULL;
		if (self->priv->_s3_mode) {
			_tmp20_ = _ ("_Secret access key:");
		} else {
			_tmp20_ = _ ("_Password:");
		}
		label_txt = g_strdup (_tmp20_);
		label = (_tmp21_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (label_txt)), _g_object_unref0 (label), _tmp21_);
		g_object_set ((GObject*) label, "mnemonic-widget", self->priv->password_w, "use-underline", TRUE, "xalign", 0.0f, NULL);
		gtk_table_attach (self->priv->table, (GtkWidget*) label, (guint) ucol, (guint) (ucol + 1), (guint) rows, (guint) (rows + 1), GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
		gtk_table_attach (self->priv->table, (GtkWidget*) self->priv->password_w, (guint) (ucol + 1), (guint) 3, (guint) rows, (guint) (rows + 1), GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 0, (guint) 0);
		rows = rows + 1;
		_g_free0 (label_txt);
	} else {
		GtkEntry* _tmp22_;
		self->priv->password_w = (_tmp22_ = NULL, _g_object_unref0 (self->priv->password_w), _tmp22_);
	}
	_tmp23_ = NULL;
	if (self->priv->_s3_mode) {
		_tmp23_ = _ ("S_how secret access key");
	} else {
		_tmp23_ = _ ("S_how password");
	}
	w = g_object_ref_sink ((GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp23_));
	g_signal_connect_object ((GtkToggleButton*) GTK_CHECK_BUTTON (w), "toggled", (GCallback) __lambda11__gtk_toggle_button_toggled, self, 0);
	gtk_box_pack_start ((GtkBox*) self->priv->layout, (GtkWidget*) w, FALSE, FALSE, (guint) 0);
	if ((flags & G_ASK_PASSWORD_SAVING_SUPPORTED) != 0) {
		const char* _tmp24_;
		char* label_txt;
		GtkCheckButton* _tmp25_;
		_tmp24_ = NULL;
		if (self->priv->_s3_mode) {
			_tmp24_ = _ ("_Remember secret access key");
		} else {
			_tmp24_ = _ ("_Remember password");
		}
		label_txt = g_strdup (_tmp24_);
		self->priv->remember_w = (_tmp25_ = g_object_ref_sink ((GtkCheckButton*) gtk_check_button_new_with_mnemonic (label_txt)), _g_object_unref0 (self->priv->remember_w), _tmp25_);
		gtk_box_pack_start ((GtkBox*) self->priv->layout, (GtkWidget*) self->priv->remember_w, FALSE, FALSE, (guint) 0);
		_g_free0 (label_txt);
	} else {
		GtkCheckButton* _tmp26_;
		self->priv->remember_w = (_tmp26_ = NULL, _g_object_unref0 (self->priv->remember_w), _tmp26_);
	}
	gtk_widget_show_all ((GtkWidget*) self->priv->password_page);
	_g_object_unref0 (label);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (w);
}


static gboolean mount_operation_assistant_is_valid_entry (MountOperationAssistant* self, GtkEntry* e) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (e == NULL) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_ = FALSE;
		if (gtk_entry_get_text (e) != NULL) {
			_tmp1_ = _vala_strcmp0 (gtk_entry_get_text (e), "") != 0;
		} else {
			_tmp1_ = FALSE;
		}
		_tmp0_ = _tmp1_;
	}
	result = _tmp0_;
	return result;
}


static gboolean mount_operation_assistant_is_anonymous (MountOperationAssistant* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->anonymous_w != NULL) {
		_tmp0_ = gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->anonymous_w);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static void mount_operation_assistant_check_valid_inputs (MountOperationAssistant* self) {
	gboolean _tmp0_ = FALSE;
	gboolean valid;
	g_return_if_fail (self != NULL);
	if (mount_operation_assistant_is_anonymous (self)) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_ = FALSE;
		if (mount_operation_assistant_is_valid_entry (self, self->priv->username_w)) {
			_tmp1_ = mount_operation_assistant_is_valid_entry (self, self->priv->domain_w);
		} else {
			_tmp1_ = FALSE;
		}
		_tmp0_ = _tmp1_;
	}
	valid = _tmp0_;
	assistant_allow_forward ((Assistant*) self->priv->_assist, valid);
}


static void mount_operation_assistant_send_reply (MountOperationAssistant* self, GMountOperationResult _result_) {
	g_return_if_fail (self != NULL);
	if (self->priv->looping) {
		gtk_main_quit ();
		self->priv->looping = FALSE;
		g_mount_operation_reply ((GMountOperation*) self, _result_);
	}
}


static void mount_operation_assistant_do_close (MountOperationAssistant* self, AssistantOperation* op, gboolean success) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	mount_operation_assistant_send_reply (self, G_MOUNT_OPERATION_ABORTED);
}


static void mount_operation_assistant_do_backward (MountOperationAssistant* self, Assistant* assist) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (assist != NULL);
	mount_operation_assistant_send_reply (self, G_MOUNT_OPERATION_ABORTED);
}


static void mount_operation_assistant_do_forward (MountOperationAssistant* self, Assistant* assist) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (assist != NULL);
}


static char* string_strip (const char* self) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static void mount_operation_assistant_do_prepare (MountOperationAssistant* self, Assistant* assist, GtkWidget* page) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (assist != NULL);
	g_return_if_fail (page != NULL);
	if (self->priv->looping) {
		if (self->priv->username_w != NULL) {
			char* txt;
			char* _tmp0_;
			txt = g_strdup (gtk_entry_get_text (self->priv->username_w));
			g_mount_operation_set_username ((GMountOperation*) self, _tmp0_ = string_strip (txt));
			_g_free0 (_tmp0_);
			_g_free0 (txt);
		}
		if (self->priv->domain_w != NULL) {
			char* txt;
			char* _tmp1_;
			txt = g_strdup (gtk_entry_get_text (self->priv->domain_w));
			g_mount_operation_set_domain ((GMountOperation*) self, _tmp1_ = string_strip (txt));
			_g_free0 (_tmp1_);
			_g_free0 (txt);
		}
		if (self->priv->password_w != NULL) {
			char* txt;
			char* _tmp2_;
			txt = g_strdup (gtk_entry_get_text (self->priv->password_w));
			g_mount_operation_set_password ((GMountOperation*) self, _tmp2_ = string_strip (txt));
			_g_free0 (_tmp2_);
			_g_free0 (txt);
		}
		if (self->priv->anonymous_w != NULL) {
			g_mount_operation_set_anonymous ((GMountOperation*) self, gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->anonymous_w));
		}
		if (self->priv->remember_w != NULL) {
			GPasswordSave _tmp3_ = 0;
			if (gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->remember_w)) {
				_tmp3_ = G_PASSWORD_SAVE_PERMANENTLY;
			} else {
				_tmp3_ = G_PASSWORD_SAVE_NEVER;
			}
			g_mount_operation_set_password_save ((GMountOperation*) self, _tmp3_);
		}
		g_print ("sending reply\n");
		mount_operation_assistant_send_reply (self, G_MOUNT_OPERATION_HANDLED);
	}
}


gboolean mount_operation_assistant_get_s3_mode (MountOperationAssistant* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_s3_mode;
	return result;
}


void mount_operation_assistant_set_s3_mode (MountOperationAssistant* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_s3_mode = value;
	g_object_notify ((GObject *) self, "s3-mode");
}


AssistantOperation* mount_operation_assistant_get_assist (MountOperationAssistant* self) {
	AssistantOperation* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_assist;
	return result;
}


static void mount_operation_assistant_set_assist (MountOperationAssistant* self, AssistantOperation* value) {
	AssistantOperation* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_assist = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_assist), _tmp0_);
	g_object_notify ((GObject *) self, "assist");
}


static void mount_operation_assistant_class_init (MountOperationAssistantClass * klass) {
	mount_operation_assistant_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MountOperationAssistantPrivate));
	G_MOUNT_OPERATION_CLASS (klass)->aborted = mount_operation_assistant_real_aborted;
	G_MOUNT_OPERATION_CLASS (klass)->ask_password = mount_operation_assistant_real_ask_password;
	G_MOUNT_OPERATION_CLASS (klass)->ask_question = mount_operation_assistant_real_ask_question;
	G_OBJECT_CLASS (klass)->get_property = mount_operation_assistant_get_property;
	G_OBJECT_CLASS (klass)->set_property = mount_operation_assistant_set_property;
	G_OBJECT_CLASS (klass)->finalize = mount_operation_assistant_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOUNT_OPERATION_ASSISTANT_S3_MODE, g_param_spec_boolean ("s3-mode", "s3-mode", "s3-mode", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOUNT_OPERATION_ASSISTANT_ASSIST, g_param_spec_object ("assist", "assist", "assist", TYPE_ASSISTANT_OPERATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void mount_operation_assistant_instance_init (MountOperationAssistant * self) {
	self->priv = MOUNT_OPERATION_ASSISTANT_GET_PRIVATE (self);
	self->priv->looping = FALSE;
}


static void mount_operation_assistant_finalize (GObject* obj) {
	MountOperationAssistant * self;
	self = MOUNT_OPERATION_ASSISTANT (obj);
	_g_object_unref0 (self->priv->_assist);
	_g_object_unref0 (self->priv->password_page);
	_g_object_unref0 (self->priv->layout);
	_g_object_unref0 (self->priv->table);
	_g_object_unref0 (self->priv->anonymous_w);
	_g_object_unref0 (self->priv->remember_w);
	_g_object_unref0 (self->priv->username_w);
	_g_object_unref0 (self->priv->domain_w);
	_g_object_unref0 (self->priv->password_w);
	G_OBJECT_CLASS (mount_operation_assistant_parent_class)->finalize (obj);
}


GType mount_operation_assistant_get_type (void) {
	static volatile gsize mount_operation_assistant_type_id__volatile = 0;
	if (g_once_init_enter (&mount_operation_assistant_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MountOperationAssistantClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mount_operation_assistant_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MountOperationAssistant), 0, (GInstanceInitFunc) mount_operation_assistant_instance_init, NULL };
		GType mount_operation_assistant_type_id;
		mount_operation_assistant_type_id = g_type_register_static (G_TYPE_MOUNT_OPERATION, "MountOperationAssistant", &g_define_type_info, 0);
		g_once_init_leave (&mount_operation_assistant_type_id__volatile, mount_operation_assistant_type_id);
	}
	return mount_operation_assistant_type_id__volatile;
}


static void mount_operation_assistant_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MountOperationAssistant * self;
	self = MOUNT_OPERATION_ASSISTANT (object);
	switch (property_id) {
		case MOUNT_OPERATION_ASSISTANT_S3_MODE:
		g_value_set_boolean (value, mount_operation_assistant_get_s3_mode (self));
		break;
		case MOUNT_OPERATION_ASSISTANT_ASSIST:
		g_value_set_object (value, mount_operation_assistant_get_assist (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void mount_operation_assistant_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MountOperationAssistant * self;
	self = MOUNT_OPERATION_ASSISTANT (object);
	switch (property_id) {
		case MOUNT_OPERATION_ASSISTANT_S3_MODE:
		mount_operation_assistant_set_s3_mode (self, g_value_get_boolean (value));
		break;
		case MOUNT_OPERATION_ASSISTANT_ASSIST:
		mount_operation_assistant_set_assist (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




