/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */


#ifndef _P11_SESSION_HH_
#define _P11_SESSION_HH_

#include "pkcs11/pkcs11_util.h"

#include "P11Error.hh"
#include "PasswordManager.hh"

#ifndef LIBP11CRYPTONIT_MAX_PASS_LENGTH
#define LIBP11CRYPTONIT_MAX_PASS_LENGTH 1024
#endif


namespace Cryptonit
{

/** Class responsible for managing a session to a PKCS#11 slot.
 * It is mainly used by P11Slot. You should refer to the PKCS#11 Standard, 
 * section 6.6 .
 */
class P11Session
{
public:
	P11Session(P11Error * em, 
			PasswordManager * pm, 
			CK_FUNCTION_LIST_PTR functions,
			CK_SLOT_ID slotid,
			CK_STATE state = CKS_RO_PUBLIC_SESSION);
	~P11Session();
	
	bool live() { return alive; } //!< Is the session active ?
	bool logged() { return logged_in; } //!< Is the user logged in the token ?
	
	CK_STATE getState() { return infos.state; }
	CK_SESSION_INFO getInfo() { return infos; }
	CK_SESSION_HANDLE handle() { return h_session; }
	
	/** Open a session.
	 * @param session_type : Must be one of :
	 * - CKS_RO_PUBLIC_SESSION (this is the default)
	 * - CKS_RO_USER_FUNCTIONS
	 * - CKS_RW_PUBLIC_SESSION
	 * - CKS_RW_USER_FUNCTIONS
	 * - CKS_RW_SO_FUNCTIONS
	 *
	 * See figures 3 and 4 in section 6.6 of PKCS#11 v2.11 .
	 */
	CK_RV open(CK_STATE session_type = CKS_RO_PUBLIC_SESSION);
	
	CK_RV close();
	
	/** Logging allows to transform a public session into a user (or SO) session. */
	CK_RV login(CK_USER_TYPE user_type = CKU_USER);
	
	CK_RV logout();
	
	enum PIN_REQUEST_TYPE {REQUEST_PIN, REQUEST_SO_PIN};
	
	void setPasswordManager(PasswordManager * pm) { passMan = pm; }
	

private:
	P11Error * err;
	PasswordManager * passMan;
	CK_FUNCTION_LIST_PTR funcs;
	CK_SESSION_HANDLE h_session;
	CK_SESSION_INFO infos;
	CK_SLOT_ID slotId; //!< the slot that this session allows access to.
	bool alive; //!< is the session active or not ?
	bool logged_in; //!< is the user logged in the token ?
	
	CK_RV updateInfos();

}; // class P11Session

} // namespace Cryptonit

#endif // _P11_SESSION_HH_
