/*
 * libcolorblind - Pixel Filter for colorblind accessibility
 *
 * This is in Public Domain
 * Original Author: Daniel Ruoso <daniel@ruoso.com>
 *
 * This library provides an unified way to recalculate colors
 * in order to present alternative views on images for colorblind
 * people.
 *
 */
#include <stdio.h>
#include "colorblind.h"
#include "filters.h"
#include "utils.h"

enum whichcolor {whichcolor_red,whichcolor_green,whichcolor_blue};
int _colorblind_filter_selective_saturate_x_check(COLORBLIND_RUNTIME* cbr, COLORBLIND_XCOLOR* color, enum whichcolor which);
int _colorblind_filter_selective_saturate_x(COLORBLIND_RUNTIME* cbr, COLORBLIND_XCOLOR* color, enum whichcolor which);
int _colorblind_filter_selective_dessaturate_x(COLORBLIND_RUNTIME* cbr, COLORBLIND_XCOLOR* color, enum whichcolor which);
/*
 * colorblind_filter_selective_saturate_red
 *
 * A = get_num_equalized
 * B = get_num_main
 * C = red_is_main
 * | A | B | C | ? |
 * | 1 | * | 1 | 1 |
 * | 1 | * | 0 | 0 |
 * | 2 | 1 | * | 0 |
 * | 2 | 2 | 1 | 1 |
 * | 2 | 2 | 0 | 0 |
 * | 3 | * | * | 0 |
 */
int colorblind_filter_selective_saturate_red(COLORBLIND_RUNTIME* cbr, COLORBLIND_XCOLOR* color) {
        return _colorblind_filter_selective_saturate_x(cbr,color,whichcolor_red);
}

int colorblind_filter_selective_saturate_green(COLORBLIND_RUNTIME* cbr, COLORBLIND_XCOLOR* color) {
        return _colorblind_filter_selective_saturate_x(cbr,color,whichcolor_green);
}

int colorblind_filter_selective_saturate_blue(COLORBLIND_RUNTIME* cbr, COLORBLIND_XCOLOR* color) {
        return _colorblind_filter_selective_saturate_x(cbr,color,whichcolor_blue);
}

int colorblind_filter_selective_dessaturate_red(COLORBLIND_RUNTIME* cbr, COLORBLIND_XCOLOR* color) {
        return _colorblind_filter_selective_dessaturate_x(cbr,color,whichcolor_red);
}

int colorblind_filter_selective_dessaturate_green(COLORBLIND_RUNTIME* cbr, COLORBLIND_XCOLOR* color) {
        return _colorblind_filter_selective_dessaturate_x(cbr,color,whichcolor_green);
}

int colorblind_filter_selective_dessaturate_blue(COLORBLIND_RUNTIME* cbr, COLORBLIND_XCOLOR* color) {
        return _colorblind_filter_selective_dessaturate_x(cbr,color,whichcolor_blue);
}

int _colorblind_filter_selective_saturate_x_check(COLORBLIND_RUNTIME* cbr, COLORBLIND_XCOLOR* color, enum whichcolor which) {
        int equalized = colorblind_get_num_equalized(cbr,color);
        int touch = 0;
        if (equalized == 1) {
                if (which == whichcolor_red) {
                        touch = colorblind_red_is_main(cbr,color);
                } else if (which == whichcolor_green) {
                        touch = colorblind_green_is_main(cbr,color);
                } else if (which == whichcolor_blue) {
                        touch = colorblind_blue_is_main(cbr,color);
                }
        } else if (equalized == 2) {
                int num_main = colorblind_get_num_main(cbr,color);
                if (num_main == 1) {
                        touch = 0;
                } else {
                        if (which == whichcolor_red) {
                                touch = colorblind_red_is_main(cbr,color);
                        } else if (which == whichcolor_green) {
                                touch = colorblind_green_is_main(cbr,color);
                        } else if (which == whichcolor_blue) {
                                touch = colorblind_blue_is_main(cbr,color);
                        }
                }
        } else {
                touch = 0;
        }
        return touch;
}

int _colorblind_filter_selective_saturate_x(COLORBLIND_RUNTIME* cbr, COLORBLIND_XCOLOR* color, enum whichcolor which) {
        int touch = _colorblind_filter_selective_saturate_x_check(cbr,color,which);
        if (touch) {
                if (which == whichcolor_red) {
                        color->red = 255;
                } else if (which == whichcolor_green) {
                        color->green = 255;
                } else if (which == whichcolor_blue) {
                        color->blue = 255;
                }
                return 1;
        } else {
                return 0;
        }
        
}

int _colorblind_filter_selective_dessaturate_x(COLORBLIND_RUNTIME* cbr, COLORBLIND_XCOLOR* color, enum whichcolor which) {
        int touch = _colorblind_filter_selective_saturate_x_check(cbr,color,which);
        if (touch) {
                if (which == whichcolor_red) {
                        color->red = 0;
                } else if (which == whichcolor_green) {
                        color->green = 0;
                } else if (which == whichcolor_blue) {
                        color->blue = 0;
                }
                return 1;
        } else {
                return 0;
        }
        
}
