//
// <%=$cur_coll.name%>.cs
//
// Author:
//   Jb Evain (jbevain@gmail.com)
//
// Generated by /CodeGen/cecil-gen.rb do not edit
// <%=Time.now%>
//
// (C) 2005 Jb Evain
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
<%
def member_visibility()
	return $cur_coll.type == "Instruction" ? "internal" : "public"
end

def use_event?()
	case $cur_coll.name
		when "NestedTypeCollection", "MethodDefinitionCollection", "ConstructorCollection", "FieldDefinitionCollection", "EventDefinitionCollection", "PropertyDefinitionCollection"
			return true
	end

	return false
end

%>
namespace <%=$cur_coll.target%> {

	using System;
	using System.Collections;

	using Mono.Cecil.Cil;

	public sealed class <%=$cur_coll.name%> : CollectionBase<% if (!$cur_coll.visitable.nil?) then %>, <%=$cur_coll.visitable%><% end %> {

		<%=$cur_coll.container_impl%> m_container;<%
		if $cur_coll.type == "Instruction" %>
		public readonly Instruction Outside = new Instruction (int.MaxValue, OpCodes.Nop);<% end %>

		public <%=$cur_coll.type%> this [int index] {
			get { return List [index] as <%=$cur_coll.type%>; }
			set { List [index] = value; }
		}

		public <%=$cur_coll.container%> Container {
			get { return m_container; }
		}

		public <%=$cur_coll.name%> (<%=$cur_coll.container_impl%> container)
		{
			m_container = container;
		}

		<%= member_visibility() %> void Add (<%=$cur_coll.type%> value)
		{<%
if use_event?() %>
			Attach (value);
<% end %>
			List.Add (value);
		}
<%
if use_event?() %>

		public new void Clear ()
		{
			foreach (<%=$cur_coll.type%> item in this)
				Detach (item);

			base.Clear ();
		}
<% end %>
		public bool Contains (<%=$cur_coll.type%> value)
		{
			return List.Contains (value);
		}

		public int IndexOf (<%=$cur_coll.type%> value)
		{
			return List.IndexOf (value);
		}

		<%= member_visibility() %> void Insert (int index, <%=$cur_coll.type%> value)
		{<%
if use_event?() %>
			Attach (value);
<% end %>
			List.Insert (index, value);
		}

		<%= member_visibility() %> void Remove (<%=$cur_coll.type%> value)
		{
			List.Remove (value);
<% if use_event?() %>
			Detach (value);
<% end %>		}
<%
if use_event?() %>

		<%= member_visibility() %> new void RemoveAt (int index)
		{
			<%=$cur_coll.type%> item = this [index];
			Remove (item);
		}
<% end %>
		protected override void OnValidate (object o)
		{
			if (! (o is <%=$cur_coll.type%>))
				throw new ArgumentException ("Must be of type " + typeof (<%=$cur_coll.type%>).FullName);
		}
<%
	case $cur_coll.item_name
		when "MethodDefinition"
%>
		public MethodDefinition [] GetMethod (string name)
		{
			ArrayList ret = new ArrayList ();
			foreach (MethodDefinition meth in this)
				if (meth.Name == name)
					ret.Add (meth);

			return ret.ToArray (typeof (MethodDefinition)) as MethodDefinition [];
		}

		internal MethodDefinition GetMethodInternal (string name, IList parameters)
		{
			foreach (MethodDefinition meth in this) {
				if (meth.Name != name || meth.Parameters.Count != parameters.Count)
					continue;

				bool match = true;
				for (int i = 0; i < parameters.Count; i++) {
					string pname;
					object param = parameters [i];
					if (param is Type)
						pname = ReflectionHelper.GetTypeSignature (param as Type);
					else if (param is TypeReference)
						pname = (param as TypeReference).FullName;
					else if (param is ParameterDefinition)
						pname = (param as ParameterDefinition).ParameterType.FullName;
					else
						throw new NotSupportedException ();

					if (meth.Parameters [i].ParameterType.FullName != pname) {
						match = false;
						break;
					}
				}

				if (match)
					return meth;
			}

			return null;
		}

		public MethodDefinition GetMethod (string name, Type [] parameters)
		{
			return GetMethodInternal (name, parameters);
		}

		public MethodDefinition GetMethod (string name, TypeReference [] parameters)
		{
			return GetMethodInternal (name, parameters);
		}

		public MethodDefinition GetMethod (string name, ParameterDefinitionCollection parameters)
		{
			return GetMethodInternal (name, parameters);
		}
<%
		when "FieldDefinition"
%>
		public FieldDefinition GetField (string name)
		{
			foreach (FieldDefinition field in this)
				if (field.Name == name)
					return field;

			return null;
		}
<%
		when "Constructor"
%>
		internal MethodDefinition GetConstructorInternal (bool isStatic, IList parameters)
		{
			foreach (MethodDefinition ctor in this) {
				if (ctor.IsStatic != isStatic || ctor.Parameters.Count != parameters.Count)
					continue;

				bool match = true;
				for (int i = 0; i < parameters.Count; i++) {
					string pname;
					object param = parameters [i];
					if (param is Type)
						pname = ReflectionHelper.GetTypeSignature (param as Type);
					else if (param is TypeReference)
						pname = (param as TypeReference).FullName;
					else if (param is ParameterDefinition)
						pname = (param as ParameterDefinition).ParameterType.FullName;
					else
						throw new NotSupportedException ();

					if (ctor.Parameters [i].ParameterType.FullName != pname) {
						match = false;
						break;
					}
				}

				if (match)
					return ctor;
			}

			return null;
		}

		public MethodDefinition GetConstructor (bool isStatic, Type [] parameters)
		{
			return GetConstructorInternal (isStatic, parameters);
		}

		public MethodDefinition GetConstructor (bool isStatic, TypeReference [] parameters)
		{
			return GetConstructorInternal (isStatic, parameters);
		}

		public MethodDefinition GetConstructor (bool isStatic, ParameterDefinitionCollection parameters)
		{
			return GetConstructorInternal (isStatic, parameters);
		}
<%
		when "EventDefinition"
%>
		public EventDefinition GetEvent (string name)
		{
			foreach (EventDefinition evt in this)
				if (evt.Name == name)
					return evt;

			return null;
		}
<%
		when "PropertyDefinition"
%>
		public PropertyDefinition [] GetProperties (string name)
		{
			ArrayList ret = new ArrayList ();
			foreach (PropertyDefinition prop in this)
				if (prop.Name == name)
					ret.Add (prop);

			return ret.ToArray (typeof (PropertyDefinition)) as PropertyDefinition [];
		}
<%
	end

	if use_event?()
%>
		void Attach (MemberReference member)
		{
			if (member.DeclaringType != null)
				throw new ReflectionException ("Member already attached, clone it instead");

			member.DeclaringType = m_container;
		}

		void Detach (MemberReference member)
		{
			member.DeclaringType = null;
		}
<% end
  if !$cur_coll.visitor.nil? then %>
		public void Accept (<%=$cur_coll.visitor%> visitor)
		{
			visitor.<%=$cur_coll.visitThis%> (this);
		}
<% end %>	}
}
