/* cdw
 * Copyright (C) 2002 Varkonyi Balazs
 * Copyright (C) 2007 - 2014 Kamil Ignacak
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */


#include "cdw_widgets.h"
#include "cdw_debug.h"


/* Indexed with values of enum from header file. */
static const char *widget_type_labels[] = {
	"NONE",                      /* Right now the IDs in header file start with 1. */
	"STATIC_LABEL",
	"CHECKBOX",
	"DROPDOWN",
	"BUTTON",
	"TEXT",
	"SAFE_INPUT_LINE",
	"DYNAMIC_LABEL"
};


const char *cdw_widgets_widget_type_label(cdw_id_t widget_type)
{
	return widget_type_labels[widget_type];
}





bool cdw_widget_is_valid_widget_id(cdw_id_t widget_type)
{
	/* This assert is used to make sure that declarations in
	   header file are consistent with contents of *.c file. */
	cdw_assert (CDW_WIDGET_ID_STATIC_LABEL        == 1
		    && CDW_WIDGET_ID_CHECKBOX         == 2
		    && CDW_WIDGET_ID_DROPDOWN         == 3
		    && CDW_WIDGET_ID_BUTTON           == 4
		    && CDW_WIDGET_ID_TEXT             == 5
		    && CDW_WIDGET_ID_SAFE_INPUT_LINE  == 6
		    && CDW_WIDGET_ID_DYNAMIC_LABEL    == 7,

		    "ERROR: changed order of widget IDs, check code that uses this function as the code may depend on order of the IDs\n");


	if (widget_type == CDW_WIDGET_ID_STATIC_LABEL
	    || widget_type == CDW_WIDGET_ID_CHECKBOX
	    || widget_type == CDW_WIDGET_ID_DROPDOWN
	    || widget_type == CDW_WIDGET_ID_BUTTON
	    || widget_type == CDW_WIDGET_ID_TEXT
	    || widget_type == CDW_WIDGET_ID_SAFE_INPUT_LINE
	    || widget_type == CDW_WIDGET_ID_DYNAMIC_LABEL) {

		return true;

	} else {
		return false;
	}
}
