/* 
 
Copyright 2006 Rene Grothmann, modified by Eric Hakenholz

This file is part of C.a.R. software.

    C.a.R. is a free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, version 3 of the License.

    C.a.R. is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 
 */
 
 
 package rene.gui;

import java.awt.List;

/**
 * A List class with a specified font and background. Designed for
 * DoActionListener objects.
 */

public class ListAction extends List {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public ListAction(final DoActionListener c, final String name) {
		addActionListener(new ActionTranslator(c, name));
		if (Global.NormalFont != null)
			setFont(Global.NormalFont);
	}

	public ListAction(final DoActionListener c, final String name, final int n) {
		super(n);
		addActionListener(new ActionTranslator(c, name));
		if (Global.NormalFont != null)
			setFont(Global.NormalFont);
	}
}
