/* 
 
Copyright 2006 Eric Hakenholz

This file is part of C.a.R. software.

    C.a.R. is a free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, version 3 of the License.

    C.a.R. is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 
 */
 
 
 package eric;

import java.awt.Point;
import java.awt.Toolkit;

import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import rene.zirkel.Zirkel;

public class JPalette extends JDialog {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private final JZirkelFrame MW;
	JPanel Content;
	boolean MainPalette;
	JToolTip ToolTip;

	public void FollowWindow() {
		final Point MWloc = MW.getLocation();

        if (MWloc.y+getPreferredSize().height>Zirkel.SCREEN.y+Zirkel.SCREEN.height){
//            x=location.x;
//            y=Zirkel.SCREEN.y+Zirkel.SCREEN.height-JPM.MainPalette.getPreferredSize().height;
//            pressed=me;
            MW.JPM.CollapseToFitScreenHeight(null);
        }

        
		this.setLocation(MWloc.x + MW.getSize().width + 3, MWloc.y);
		Toolkit.getDefaultToolkit().sync();
	}

	public JPalette(final rene.zirkel.ZirkelFrame zf, final JZirkelFrame mywin,
			final boolean mainpal) {
		super(mywin, false);
		MW = mywin;
		MainPalette = mainpal;
		setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
		setTitle("Palette");
		setBackground(new java.awt.Color(240, 240, 240));
		setFocusable(false);
		// setFocusableWindowState(false);
		FollowWindow();
		this.setUndecorated(true);
		Content = new JPaletteContainer();
		this.setContentPane(Content);

		ToolTip = new JToolTip(this);

	}

	public void paintImmediately() {
		Content.paintImmediately(0, 0, Content.getWidth(), Content.getHeight());
	}

	public void addzone(final JPaletteZone myzone) {
		if (myzone.ZoneContent.getComponentCount() > 0)
			Content.add(myzone);
	}

	private class JPaletteContainer extends JPanel {
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;

		public JPaletteContainer() {
			this.setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		}
	}

}
