/*  CamStream: a collection of GUI webcam tools
    Copyright (C) 2002 Nemosoft Unv.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    For questions, remarks, patches, etc. for this program, the author can be
    reached at camstream@smcc.demon.nl.
*/

#ifndef VIDEOFRAME_H
#define VIDEOFRAME_H

#include <qimage.h>
#include <qshared.h>

class CVideoFrame
{
friend class CVideoDevice;
private:
   struct VideoDataShared: public QShared
   {
      const QImage *RGB;
      const QImage *Y, *U, *V;

      unsigned long sequence;
      unsigned long time_stamp;
   } *data;

   uint m_Number;

private:
   uint GetRefCount() const;

protected:
   CVideoFrame(uint number, const QImage *rgb, const QImage *y, const QImage *u, const QImage *v);

public:
   CVideoFrame(const CVideoFrame &);
   virtual ~CVideoFrame();

   CVideoFrame &operator =(const CVideoFrame &);

   const QImage *GetRGB() const;
   const QImage *GetY() const;
   const QImage *GetU() const;
   const QImage *GetV() const;

   uint GetNumber() const ;
   void SetSequence(unsigned long seq);
   unsigned long GetSequence() const;
   void SetTimeStamp(unsigned long stamp);
   unsigned long GetTimeStamp() const;
};

#endif
