#ifndef CHANNELEDITORDLG_H
#define CHANNELEDITORDLG_H

#include <qdom.h>
#include <qlist.h>
#include <qlistview.h>
#include <qstring.h>
#include <qvector.h>

#include "ChannelEditor.h"
#include "TVChannel.h"

class CChannelEditorDlg: public CChannelEditor
{
   Q_OBJECT
private:
   QList<TVChannel> *m_pTVChannels;
   QMap<const TVChannel *, QListViewItem *> m_Channel2ListView;
   QMap<const QListViewItem *, TVChannel *> m_ListView2Channel;

   TVChannel::FrequencyGrid m_CurrentFrequencySystem;
   //TVChannel *m_pCurrentChannel;
   TVChannel m_Backup;
   bool m_CurrentIsNew; ///< True if the current item is a new entry ('cancel' will delete)
   bool m_UpdatingGUI;

   void SetNewCurrent(TVChannel *channel);
   void SetDialogControls(const TVChannel *channel);
   void SetListEntry(const TVChannel *channel);
   void SetFrequencySystem(TVChannel::FrequencyGrid system);

   void RemoveChannel(TVChannel *channel);
   void AddChannel(TVChannel *channel, int index = -1);

protected slots:
   /* overloaded slots */
   void NameChanged(const QString &new_name);
   void FrequencySystemChanged(int);
   void SystemChannelClicked(int);
   void FinetuningMoved(int);
   void ColorSystemChanged(int);

   void NewClicked();
   void DeleteClicked();
   void UpClicked();
   void DownClicked();
   void PresetClicked(QListViewItem *);

public:
   CChannelEditorDlg(QWidget *parent = 0, const char *name = 0);
   void SetTVChannels(QList<TVChannel> *tv_channels);

signals:
   void NewCurrentChannel();
   /**
     \brief Signal that emits a newly set frequency
     \param frequency Tuned frequency, in Hz

     When a new preset is selected, or the system channel or finetuning is adjusted,
     a new frequency is emitted. This allows decoupling of the ChannelEditorDialog
     from the real device.

     The frequency is emitted as a float, in Hz. So for MHz, divide by 1,000,000
   */
   void NewFrequency(float frequency);
   void NewColorSystem(TVChannel::TunerNorms norm);
};

#endif
