/*  audiodevs: Abstraction layer for audio hardware & samples
    Copyright (C) 2003-2004 Nemosoft Unv.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    For questions, remarks, patches, etc. for this program, the author can be
    reached at camstream@smcc.demon.nl.
*/
#ifndef AUDIODEVICELINUX_HPP
#define AUDIODEVICELINUX_HPP

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#define ALSA_PCM_NEW_HW_PARAMS_API
#define ALSA_PCM_NEW_SW_PARAMS_API
#include <alsa/asoundlib.h>

#include <qstring.h>

#include "AudioDevice.h"

class CAudioControlLinux;

class CAudioDeviceLinux: public CAudioDevice
{
   Q_OBJECT
private:
   int m_CardNumber;
   bool m_StopCapture, m_StopPlayback;
   //QWaitCondition m_CaptureFinished, m_PlaybackFinished;
   QMutex m_ResetBusy;

   snd_pcm_t *m_pSndPcm;
   snd_pcm_hw_params_t *m_pHWParams;
   snd_pcm_sw_params_t *m_pSWParams;
   snd_pcm_channel_area_t m_ChannelArea[32];
   snd_pcm_format_t m_Format;
   snd_pcm_uframes_t m_SamplesWritten, m_SamplesRead;
   snd_pcm_uframes_t m_MinBufferSize, m_MaxBufferSize, m_CurrentBufferSize;

   CAudioControlLinux *m_pControl;

   int GetHWParameters();
   int SetHWParameters();
   void DumpHWParameters();
   int SetSWParamaters();

private slots:
   void ResetStream();

protected:
   void run();

   virtual bool Init();
   virtual void Exit();

   virtual int StartCapture();
   virtual void StopCapture();
   virtual int StartPlayback();
   virtual void StopPlayback();

public:
   CAudioDeviceLinux(int card_number);
   virtual ~CAudioDeviceLinux();

   virtual unsigned long GetPlaybackPointer() const;

   virtual void SetBufferLength(unsigned int len, unsigned int chunk_length = 0);
   virtual void SetBufferTime(unsigned int ms, unsigned int chunk_length = 0);
   //virtual int WriteDirectly(const void *, unsigned int len) = 0;

   virtual void GetMixerSettings(QDomNode &) const;
   virtual void SetMixerSettings(const QDomNode &) const;

public slots:
   ///void ShowSettingsDialog();
   void ShowMixerControls();
};

#endif
