# bug-triage -- bug triage and forward tool.
# Copyright (C) 2007  Gustavo R. Montesino
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

import pygtk
pygtk.require("2.0")
import gtk
import gtk.glade

from bt_exceptions import *
from msg_exception import errorhandler

class dlg_qbuilder:
    """Query builder dialog related callbacks and functions"""

    response_CANCEL = 0
    response_REPLACE = 1
    response_PLUS = 2
    response_LESS = 3
    response_AND = 4

    @errorhandler
    def __init__(self, glade_path):
        self.xml = gtk.glade.XML(glade_path + "dlg_qbuilder.glade")
        self.dialog = self.xml.get_widget("dlg_qbuilder")
         
    @errorhandler
    def get(self):
        """Returns the current query"""

        bug = self.xml.get_widget("entryBug").get_text()
        src = self.xml.get_widget("entrySrc").get_text()
        pkg = self.xml.get_widget("entryPkg").get_text()
        maintainer = self.xml.get_widget("entryMaint").get_text()
        submitter = self.xml.get_widget("entryFrom").get_text()


        if bug != "":
            return "(bug: %s)" % bug

        else:
            arguments = []

            if src != "":
                arguments.append("src: %s" % src)

            if pkg != "":
                arguments.append("pkg: %s" % pkg)

            if maintainer != "":
                arguments.append("maint: %s" % maintainer)

            if submitter != "":
                arguments.append("from: %s" % submitter)

            if arguments == []:
                raise InvalidQueryError

            return "(%s)" % "&".join(arguments)
    
    @errorhandler
    def run(self):
        """Show the dialog

        Shows the dialog to the user, and returns the response ID
        
        Returns the value of one of the response_ constants declared above."""

        response = self.dialog.run()
        self.dialog.hide()

        return response
        
# vim: tabstop=4 expandtab shiftwidth=4
