/***************************************************************************
                          dlghelp.h  -  description
                             -------------------
    begin                : Mon Dec 30 2002
    copyright            : (C) 2002 by Ken Schenke
    email                : kschenke at users dot sourceforge dot net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA         *
 *   02110-1301, USA                                                       *
 *                                                                         *
 ***************************************************************************/

#ifndef DLGHELP_H
#define DLGHELP_H

#include <QDialog>

#include "ui_dlghelp.h"
#include "bridgecfg.h"

/***************************************************************************
 *                                                                         *
 *   This class implements the online help dialog box.                     *
 *                                                                         *
 ***************************************************************************/

class DlgHelp : public QDialog, public Ui::DlgHelp
{
	Q_OBJECT;

public:
	DlgHelp(const BridgeCfg &cfg, QWidget *parent=0);
		
	void	setSource(const QString &source);

public slots:
	void	on_browserHelp_backwardAvailable(bool);
	void	on_browserHelp_forwardAvailable(bool);
	void	on_buttonBack_clicked(void);
	void	on_buttonForward_clicked(void);
	void	on_buttonHome_clicked(void);
	
private:
	BridgeCfg	m_cfg;
};

#endif	// end of DLGHELP_H
