/***************************************************************************
                          dlgbrowsers.cpp  -  description
                             -------------------
    begin                : Sat Nov 16 2002
    copyright            : (C) 2002 by Ken Schenke
    email                : kschenke at users dot sourceforge dot net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA         *
 *   02110-1301, USA                                                       *
 *                                                                         *
 ***************************************************************************/

#include "dlgbrowsers.h"
#include "browserlist.h"

#include <QListWidget>

extern BROWSERLIST BrowserList[];

/***************************************************************************
 *                                                                         *
 *   The BrowserItem class (derived from QListWidgetItem) represents an    *
 *   item in the listbox of browsers supported by BookmarkBridge.  All it  *
 *   does is store the BrowserNum of the browser it represents.            *
 *                                                                         *
 ***************************************************************************/
 
class BrowserItem : public QListWidgetItem
{
public:
	BrowserItem(const QString &text, QListWidget *listwidget=0) :
		QListWidgetItem(text,listwidget) { };

	BRWSTYPE browser;
};

/***************************************************************************
 *                                                                         *
 *   DlgBrowsers::DlgBrowsers()                                            *
 *                                                                         *
 *   Parameters:                                                           *
 *      QWidget *parent                                                    *
 *   Return:                                                               *
 *      None                                                               *
 *   Description:                                                          *
 *      Class constructor                                                  *
 *                                                                         *
 ***************************************************************************/

DlgBrowsers::DlgBrowsers(QWidget* parent)
	: QDialog(parent)
{
	setupUi(this);

	browser = 0;
	RefreshList();
}

/***************************************************************************
 *                                                                         *
 *   DlgBrowsers::~DlgBrowsers()                                           *
 *                                                                         *
 *   Parameters:                                                           *
 *      None                                                               *
 *   Return:                                                               *
 *      None                                                               *
 *   Description:                                                          *
 *      Class destructor                                                   *
 *                                                                         *
 ***************************************************************************/

DlgBrowsers::~DlgBrowsers()
{
}

/***************************************************************************
 *                                                                         *
 *   DlgBrowsers::RefreshList()                                            *
 *                                                                         *
 *   Parameters:                                                           *
 *      None                                                               *
 *   Return:                                                               *
 *      None                                                               *
 *   Description:                                                          *
 *      This function is called to populate the list of browsers supported *
 *      by BookmarkBridge in a listbox.                                    *
 *                                                                         *
 ***************************************************************************/

void DlgBrowsers::RefreshList(void)
{
	int i;

	listBrowsers->clear();

	BrowserItem *item;

	for(i=0; ; i++)
	{
		if(BrowserList[i].Name==NULL || BrowserList[i].Factory==NULL)
			break;

		item = new BrowserItem(BrowserList[i].Name, listBrowsers);
		item->browser = i+1;
	}

	Q_ASSERT(i > 0);
	listBrowsers->setCurrentRow(0);
}

/***************************************************************************
 *                                                                         *
 *   DlgBrowsers::on_listBrowsers_currentItemChanged()                     *
 *                                                                         *
 *   Parameters:                                                           *
 *      QListWidgetItem *                                                  *
 *   Return:                                                               *
 *      None                                                               *
 *   Description:                                                          *
 *      This function (actually a slot) is called by the Qt framework when *
 *      the user clicks somewhere in the browsers listbox.  It stores the  *
 *      BrowserNum of the selected item (or 0 if none selected).           *
 *                                                                         *
 ***************************************************************************/

void DlgBrowsers::on_listBrowsers_currentItemChanged(QListWidgetItem *pItem)
{
	BrowserItem *item = static_cast<BrowserItem *>(pItem);
	browser = item->browser;
}
