/*
replay.cpp
Copyright (C) 2005 Poul Sander

    This program is free software; you can redistribute it and/or modify        
    it under the terms of the GNU General Public License as published by        
    the Free Software Foundation; either version 2 of the License, or           
    (at your option) any later version.                                         
                                                                                
    This program is distributed in the hope that it will be useful,       
    but WITHOUT ANY WARRANTY; without even the implied warranty of              
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
    GNU General Public License for more details.                
                                                                               
    You should have received a copy of the GNU General Public License           
    along with this program; if not, write to the Free Software                 
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   
                                                                                
    Poul Sander
    Rvehjvej 36, V. 1111                                                    
    2800 Kgs. Lyngby
    DENMARK
    poul.sander@tdcadsl.dk       
*/

/*
Handles replay
*/

#include "replay.h"

void Replay::newReplay()
{
	nrOfFrames=0;
}

Uint32 Replay::getNumberOfFrames()
{
	return nrOfFrames;
}

void Replay::setFrameSecTo(Uint32 miliseconds, boardPackage bp)
{
	int framesToSet = (miliseconds*FRAMESPERSEC)/1000;
	if(!(framesToSet<TOTALFRAMES))
		framesToSet = TOTALFRAMES;
	for(int i=nrOfFrames;i<framesToSet;i++)
	{
		bps[i]=bp;
	}
	nrOfFrames=framesToSet;
}

void Replay::setFinalFrame(boardPackage bp,int theStatus)
{
	finalPack = bp;
	switch(theStatus)
	{
	case 1:
		theResult = winner;
		break;
	case 2:
		theResult = looser;
		break;
	case 3:
		theResult = draw;
		break;
	default:
		theResult = gameOver;
	};
	
}

//Returns the frame to the current time, if time too high the final frame is returned
boardPackage Replay::getFrameSec(Uint32 miliseconds)
{
	int frameToGet = (miliseconds*FRAMESPERSEC)/1000;
	//cout << "got frame: " << frameToGet << endl;
	if(!(frameToGet<nrOfFrames))
		return getFinalFrame();
	return bps[frameToGet];
}

bool Replay::isFinnished(Uint32 miliseconds)
{
	int frameToGet = (miliseconds*FRAMESPERSEC)/1000;
	if(!(frameToGet<nrOfFrames))
		return true;
	return false;
}

boardPackage Replay::getFinalFrame()
{
	return finalPack;
}

int Replay::getFinalStatus()
{
	return theResult;
}

/*

bool Replay::saveReplay(char* filename)
{
	//Saving as fileversion 1
	ofstream saveFile;
	saveFile.open(filename,ios::binary|ios::trunc);
	if(saveFile)
	{
		Uint32 version = 1;
		saveFile.write(reinterpret_cast<char*>(&version),sizeof(Uint32)); //Fileversion
		Uin8 nrOfReplays = 1;
		saveFile.write(reinterpret_cast<char*>(&nrOfReplays),sizeof(Uint8)); //nrOfReplaysIn File
		saveFile.write(reinterpret_cast<char*>(&nrOfFrames),sizeof(Uint32)); //Nr of frames in file
		for(int i=0; (i<nrOfFrames)&&(i<TOTALFRAMES);i++)
		{ //Writing frames
			saveFile.write(reinterpret_cast<char*>(bps[i].time),sizeof(Uint32));
            for(int k=0;k<6;k++)
            for(int g=0;g<13;g++)	
                saveFile.write(reinterpret_cast<char*>(bps[i].brick[k][g]),sizeof(Uint8));
            saveFile.write(reinterpret_cast<char*>(bps[i].pixels),sizeof(Uint8));
            saveFile.write(reinterpret_cast<char*>(bps[i].cursorX),sizeof(Uint8));
            saveFile.write(reinterpret_cast<char*>(bps[i].cursorY),sizeof(Uint8));
            saveFile.write(reinterpret_cast<char*>(bps[i].score),sizeof(Uint32));
            saveFile.write(reinterpret_cast<char*>(bps[i].speed),sizeof(Uint8));
            saveFile.write(reinterpret_cast<char*>(bps[i].chain),sizeof(Uint8));
		}
		saveFile.close(); 	
		return true;
	}
	else
	{
		return false;
	}
}

bool Replay::saveReplay(char* filename,Replay p2)
{
	//Saving as fileversion 1
	ofstream saveFile;
	saveFile.open(filename,ios::binary|ios::trunc);
	if(saveFile)
	{
		Uint32 version = 1;
		saveFile.write(reinterpret_cast<char*>(&version),sizeof(Uint32)); //Fileversion
		Uin8 nrOfReplays = 2;
		saveFile.write(reinterpret_cast<char*>(&nrOfReplays),sizeof(Uint8)); //nrOfReplaysIn File
		saveFile.write(reinterpret_cast<char*>(&nrOfFrames),sizeof(Uint32)); //Nr of frames in file
		for(int i=0; (i<nrOfFrames)&&(i<TOTALFRAMES);i++)
		{ //Writing frames
			saveFile.write(reinterpret_cast<char*>(bps[i].time),sizeof(Uint32));
            for(int k=0;k<6;k++)
            for(int g=0;g<13;g++)	
                saveFile.write(reinterpret_cast<char*>(bps[i].brick[k][g]),sizeof(Uint8));
            saveFile.write(reinterpret_cast<char*>(bps[i].pixels),sizeof(Uint8));
            saveFile.write(reinterpret_cast<char*>(bps[i].cursorX),sizeof(Uint8));
            saveFile.write(reinterpret_cast<char*>(bps[i].cursorY),sizeof(Uint8));
            saveFile.write(reinterpret_cast<char*>(bps[i].score),sizeof(Uint32));
            saveFile.write(reinterpret_cast<char*>(bps[i].speed),sizeof(Uint8));
            saveFile.write(reinterpret_cast<char*>(bps[i].chain),sizeof(Uint8));
		}
	///Player 2 starts here!!!!!!!!!!!!!!!!!!!!!!
		saveFile.write(reinterpret_cast<char*>(&p2.nrOfFrames),sizeof(Uint32)); //Nr of frames in file
		for(int i=0; (i<p2.nrOfFrames)&&(i<TOTALFRAMES);i++)
		{ //Writing frames
			saveFile.write(reinterpret_cast<char*>(p2.bps[i].time),sizeof(Uint32));
            for(int k=0;k<6;k++)
            for(int g=0;g<13;g++)	
                saveFile.write(reinterpret_cast<char*>(p2.bps[i].brick[k][g]),sizeof(Uint8));
            saveFile.write(reinterpret_cast<char*>(p2.bps[i].pixels),sizeof(Uint8));
            saveFile.write(reinterpret_cast<char*>(p2.bps[i].cursorX),sizeof(Uint8));
            saveFile.write(reinterpret_cast<char*>(p2.bps[i].cursorY),sizeof(Uint8));
            saveFile.write(reinterpret_cast<char*>(p2.bps[i].score),sizeof(Uint32));
            saveFile.write(reinterpret_cast<char*>(p2.bps[i].speed),sizeof(Uint8));
            saveFile.write(reinterpret_cast<char*>(p2.bps[i].chain),sizeof(Uint8));
		}
		saveFile.close(); 	
		return true;
	}
	else
	{
		return false;
	}
}

bool Replay::loadReplay(char* filename)
{
	ifstream loadFile;
	loadFile.open(filename,ios::binary);
	if(loadFile)
	{
		Uint32 version;
		loadFile.read(reinterpret_cast<char*>(&version),sizeof(Uint32));
		switch(version)
		{
		case 1:
		Uint8 nrOfPlayers;
		loadFile.read(reinterpret_cast<char*>(&nrOfPlayers),sizeof(Uint8));
		loadFile.read(reinterpret_cast<char*>(&nrOfFrames),sizeof(Uint32));
		for(int i=0; (i<nrOfFrames)&&(i<TOTALFRAMES);i++)
		{
			loadFile.read(reinterpret_cast<char*>(bps[i].time),sizeof(Uint32));	//Writing frames
			for(int k=0;k<6;k++)
            for(int g=0;g<13;g++)
                loadFile.read(reinterpret_cast<char*>(bps[i].brick[k][g]),sizeof(Uint8));
            loadFile.read(reinterpret_cast<char*>(bps[i].pixels),sizeof(Uint8));
            loadFile.read(reinterpret_cast<char*>(bps[i].cursorX),sizeof(Uint8));
            loadFile.read(reinterpret_cast<char*>(bps[i].cursorY),sizeof(Uint8));
            loadFile.read(reinterpret_cast<char*>(bps[i].score),sizeof(Uint32));
            loadFile.read(reinterpret_cast<char*>(bps[i].speed),sizeof(Uint8));
            loadFile.read(reinterpret_cast<char*>(bps[i].chain),sizeof(Uint8));
		}
		break;
		default:
			cout << "Unknown version" << endl;
			return false;
		};
		loadFile.close();
	}
	else
	{
		cout << "File not found or couldn't open: " << filename << endl;
		return false;
	}

}
*/
