/*
 * Copyright (c) 2003, 2006 Matteo Frigo
 * Copyright (c) 2003, 2006 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Jul  1 14:02:12 EDT 2006 */

#include "codelet-dft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_twiddle -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -n 64 -name t1_64 -include t.h */

/*
 * This function contains 1038 FP additions, 644 FP multiplications,
 * (or, 520 additions, 126 multiplications, 518 fused multiply/add),
 * 228 stack variables, and 256 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_twiddle.ml,v 1.24 2006-02-12 23:34:12 athena Exp $
 */

#include "t.h"

static const R *t1_64(R *ri, R *ii, const R *W, stride ios, INT m, INT dist)
{
     DK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DK(KP820678790, +0.820678790828660330972281985331011598767386482);
     DK(KP098491403, +0.098491403357164253077197521291327432293052451);
     DK(KP534511135, +0.534511135950791641089685961295362908582039528);
     DK(KP303346683, +0.303346683607342391675883946941299872384187453);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP668178637, +0.668178637919298919997757686523080761552472251);
     DK(KP198912367, +0.198912367379658006911597622644676228597850501);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     DK(KP414213562, +0.414213562373095048801688724209698078569671875);
     INT i;
     for (i = m; i > 0; i = i - 1, ri = ri + dist, ii = ii + dist, W = W + 126, MAKE_VOLATILE_STRIDE(ios)) {
	  E TeI, Tkk, Tkj, TeL;
	  {
	       E TiV, Tjm, T7e, TcA, TjR, Tkl, Tm, TeM, TeZ, Ths, T7Q, TcJ, T1G, TeW, TcI;
	       E T7X, Tf5, Thv, T87, TcN, T29, Tf8, TcQ, T8u, TfU, ThS, Taq, Tdm, T5K, Tg9;
	       E Tdx, Tbj, TcB, T7l, TiP, TeP, Tjl, TN, TcC, T7s, T7I, TcF, TeU, Thr, T7B;
	       E TcG, T1f, TeR, Tfg, ThB, T8G, TcU, T32, Tfj, TcX, T93, Tft, ThH, T9h, Td3;
	       E T3X, TfI, Tde, Taa, Thw, Tfb, Tf6, T2A, T8x, TcO, T8m, TcR, Tfm, ThC, T3t;
	       E Tfh, T96, TcV, T8V, TcY, ThI, TfL, Tfu, T4o, Tad, Td4, T9w, Tdf, Tgc, ThT;
	       E T6b, TfV, Tbm, Tdn, TaF, Tdy, ThN, T4Q, TfN, TfA, Taf, Ta1, Td8, Tdh, ThO;
	       E T5h, TfO, TfF, Tag, T9M, Tdb, Tdi, ThY, T6D, Tge, Tg1, Tbo, Tba, Tdr, TdA;
	       E TaN, Tdt, Tg5, ThZ, Tg2, T74, Tds, TaU;
	       {
		    E T7a, Te, T78, T8, TjP, TiU, T7c, Tk;
		    {
			 E T1, TiT, TiS, T7, Tg, Tj, Tf, Ti, T7b, Th;
			 T1 = ri[0];
			 TiT = ii[0];
			 {
			      E T3, T6, T2, T5;
			      T3 = ri[WS(ios, 32)];
			      T6 = ii[WS(ios, 32)];
			      T2 = W[62];
			      T5 = W[63];
			      {
				   E Ta, Td, Tc, T79, Tb, TiR, T4, T9;
				   Ta = ri[WS(ios, 16)];
				   Td = ii[WS(ios, 16)];
				   TiR = T2 * T6;
				   T4 = T2 * T3;
				   T9 = W[30];
				   Tc = W[31];
				   TiS = FNMS(T5, T3, TiR);
				   T7 = FMA(T5, T6, T4);
				   T79 = T9 * Td;
				   Tb = T9 * Ta;
				   Tg = ri[WS(ios, 48)];
				   Tj = ii[WS(ios, 48)];
				   T7a = FNMS(Tc, Ta, T79);
				   Te = FMA(Tc, Td, Tb);
				   Tf = W[94];
				   Ti = W[95];
			      }
			 }
			 T78 = T1 - T7;
			 T8 = T1 + T7;
			 TjP = TiT - TiS;
			 TiU = TiS + TiT;
			 T7b = Tf * Tj;
			 Th = Tf * Tg;
			 T7c = FNMS(Ti, Tg, T7b);
			 Tk = FMA(Ti, Tj, Th);
		    }
		    {
			 E T7L, T1l, T7V, T1E, T1u, T1x, T1w, T7N, T1r, T7S, T1v;
			 {
			      E T1A, T1D, T1C, T7U, T1B;
			      {
				   E T1h, T1k, T1g, T1j, T7K, T1i, T1z;
				   T1h = ri[WS(ios, 60)];
				   T1k = ii[WS(ios, 60)];
				   {
					E T7d, TiQ, Tl, TjQ;
					T7d = T7a - T7c;
					TiQ = T7a + T7c;
					Tl = Te + Tk;
					TjQ = Te - Tk;
					TiV = TiQ + TiU;
					Tjm = TiU - TiQ;
					T7e = T78 - T7d;
					TcA = T78 + T7d;
					TjR = TjP - TjQ;
					Tkl = TjQ + TjP;
					Tm = T8 + Tl;
					TeM = T8 - Tl;
					T1g = W[118];
				   }
				   T1j = W[119];
				   T1A = ri[WS(ios, 44)];
				   T1D = ii[WS(ios, 44)];
				   T7K = T1g * T1k;
				   T1i = T1g * T1h;
				   T1z = W[86];
				   T1C = W[87];
				   T7L = FNMS(T1j, T1h, T7K);
				   T1l = FMA(T1j, T1k, T1i);
				   T7U = T1z * T1D;
				   T1B = T1z * T1A;
			      }
			      {
				   E T1n, T1q, T1m, T1p, T7M, T1o, T1t;
				   T1n = ri[WS(ios, 28)];
				   T1q = ii[WS(ios, 28)];
				   T7V = FNMS(T1C, T1A, T7U);
				   T1E = FMA(T1C, T1D, T1B);
				   T1m = W[54];
				   T1p = W[55];
				   T1u = ri[WS(ios, 12)];
				   T1x = ii[WS(ios, 12)];
				   T7M = T1m * T1q;
				   T1o = T1m * T1n;
				   T1t = W[22];
				   T1w = W[23];
				   T7N = FNMS(T1p, T1n, T7M);
				   T1r = FMA(T1p, T1q, T1o);
				   T7S = T1t * T1x;
				   T1v = T1t * T1u;
			      }
			 }
			 {
			      E T7O, TeX, T1s, T7R, T7T, T1y;
			      T7O = T7L - T7N;
			      TeX = T7L + T7N;
			      T1s = T1l + T1r;
			      T7R = T1l - T1r;
			      T7T = FNMS(T1w, T1u, T7S);
			      T1y = FMA(T1w, T1x, T1v);
			      {
				   E T7W, TeY, T7P, T1F;
				   T7W = T7T - T7V;
				   TeY = T7T + T7V;
				   T7P = T1y - T1E;
				   T1F = T1y + T1E;
				   TeZ = TeX - TeY;
				   Ths = TeX + TeY;
				   T7Q = T7O + T7P;
				   TcJ = T7O - T7P;
				   T1G = T1s + T1F;
				   TeW = T1s - T1F;
				   TcI = T7R + T7W;
				   T7X = T7R - T7W;
			      }
			 }
		    }
	       }
	       {
		    E T82, T1O, T8s, T27, T1X, T20, T1Z, T84, T1U, T8p, T1Y;
		    {
			 E T23, T26, T25, T8r, T24;
			 {
			      E T1K, T1N, T1J, T1M, T81, T1L, T22;
			      T1K = ri[WS(ios, 2)];
			      T1N = ii[WS(ios, 2)];
			      T1J = W[2];
			      T1M = W[3];
			      T23 = ri[WS(ios, 50)];
			      T26 = ii[WS(ios, 50)];
			      T81 = T1J * T1N;
			      T1L = T1J * T1K;
			      T22 = W[98];
			      T25 = W[99];
			      T82 = FNMS(T1M, T1K, T81);
			      T1O = FMA(T1M, T1N, T1L);
			      T8r = T22 * T26;
			      T24 = T22 * T23;
			 }
			 {
			      E T1Q, T1T, T1P, T1S, T83, T1R, T1W;
			      T1Q = ri[WS(ios, 34)];
			      T1T = ii[WS(ios, 34)];
			      T8s = FNMS(T25, T23, T8r);
			      T27 = FMA(T25, T26, T24);
			      T1P = W[66];
			      T1S = W[67];
			      T1X = ri[WS(ios, 18)];
			      T20 = ii[WS(ios, 18)];
			      T83 = T1P * T1T;
			      T1R = T1P * T1Q;
			      T1W = W[34];
			      T1Z = W[35];
			      T84 = FNMS(T1S, T1Q, T83);
			      T1U = FMA(T1S, T1T, T1R);
			      T8p = T1W * T20;
			      T1Y = T1W * T1X;
			 }
		    }
		    {
			 E T85, Tf3, T1V, T8o, T8q, T21;
			 T85 = T82 - T84;
			 Tf3 = T82 + T84;
			 T1V = T1O + T1U;
			 T8o = T1O - T1U;
			 T8q = FNMS(T1Z, T1X, T8p);
			 T21 = FMA(T1Z, T20, T1Y);
			 {
			      E T8t, Tf4, T86, T28;
			      T8t = T8q - T8s;
			      Tf4 = T8q + T8s;
			      T86 = T21 - T27;
			      T28 = T21 + T27;
			      Tf5 = Tf3 - Tf4;
			      Thv = Tf3 + Tf4;
			      T87 = T85 + T86;
			      TcN = T85 - T86;
			      T29 = T1V + T28;
			      Tf8 = T1V - T28;
			      TcQ = T8o + T8t;
			      T8u = T8o - T8t;
			 }
		    }
	       }
	       {
		    E Tal, T5p, Tbh, T5I, T5y, T5B, T5A, Tan, T5v, Tbe, T5z;
		    {
			 E T5E, T5H, T5G, Tbg, T5F;
			 {
			      E T5l, T5o, T5k, T5n, Tak, T5m, T5D;
			      T5l = ri[WS(ios, 63)];
			      T5o = ii[WS(ios, 63)];
			      T5k = W[124];
			      T5n = W[125];
			      T5E = ri[WS(ios, 47)];
			      T5H = ii[WS(ios, 47)];
			      Tak = T5k * T5o;
			      T5m = T5k * T5l;
			      T5D = W[92];
			      T5G = W[93];
			      Tal = FNMS(T5n, T5l, Tak);
			      T5p = FMA(T5n, T5o, T5m);
			      Tbg = T5D * T5H;
			      T5F = T5D * T5E;
			 }
			 {
			      E T5r, T5u, T5q, T5t, Tam, T5s, T5x;
			      T5r = ri[WS(ios, 31)];
			      T5u = ii[WS(ios, 31)];
			      Tbh = FNMS(T5G, T5E, Tbg);
			      T5I = FMA(T5G, T5H, T5F);
			      T5q = W[60];
			      T5t = W[61];
			      T5y = ri[WS(ios, 15)];
			      T5B = ii[WS(ios, 15)];
			      Tam = T5q * T5u;
			      T5s = T5q * T5r;
			      T5x = W[28];
			      T5A = W[29];
			      Tan = FNMS(T5t, T5r, Tam);
			      T5v = FMA(T5t, T5u, T5s);
			      Tbe = T5x * T5B;
			      T5z = T5x * T5y;
			 }
		    }
		    {
			 E Tao, TfS, T5w, Tbd, Tbf, T5C;
			 Tao = Tal - Tan;
			 TfS = Tal + Tan;
			 T5w = T5p + T5v;
			 Tbd = T5p - T5v;
			 Tbf = FNMS(T5A, T5y, Tbe);
			 T5C = FMA(T5A, T5B, T5z);
			 {
			      E Tbi, TfT, Tap, T5J;
			      Tbi = Tbf - Tbh;
			      TfT = Tbf + Tbh;
			      Tap = T5C - T5I;
			      T5J = T5C + T5I;
			      TfU = TfS - TfT;
			      ThS = TfS + TfT;
			      Taq = Tao + Tap;
			      Tdm = Tao - Tap;
			      T5K = T5w + T5J;
			      Tg9 = T5w - T5J;
			      Tdx = Tbd + Tbi;
			      Tbj = Tbd - Tbi;
			 }
		    }
	       }
	       {
		    E T7G, T1d, T7z, TeS, T11, T7C, T7E, T17, T7r, T7m;
		    {
			 E T7g, Ts, T7q, TL, TB, TE, TD, T7i, Ty, T7n, TC;
			 {
			      E TH, TK, TJ, T7p, TI;
			      {
				   E To, Tr, Tn, Tq, T7f, Tp, TG;
				   To = ri[WS(ios, 8)];
				   Tr = ii[WS(ios, 8)];
				   Tn = W[14];
				   Tq = W[15];
				   TH = ri[WS(ios, 24)];
				   TK = ii[WS(ios, 24)];
				   T7f = Tn * Tr;
				   Tp = Tn * To;
				   TG = W[46];
				   TJ = W[47];
				   T7g = FNMS(Tq, To, T7f);
				   Ts = FMA(Tq, Tr, Tp);
				   T7p = TG * TK;
				   TI = TG * TH;
			      }
			      {
				   E Tu, Tx, Tt, Tw, T7h, Tv, TA;
				   Tu = ri[WS(ios, 40)];
				   Tx = ii[WS(ios, 40)];
				   T7q = FNMS(TJ, TH, T7p);
				   TL = FMA(TJ, TK, TI);
				   Tt = W[78];
				   Tw = W[79];
				   TB = ri[WS(ios, 56)];
				   TE = ii[WS(ios, 56)];
				   T7h = Tt * Tx;
				   Tv = Tt * Tu;
				   TA = W[110];
				   TD = W[111];
				   T7i = FNMS(Tw, Tu, T7h);
				   Ty = FMA(Tw, Tx, Tv);
				   T7n = TA * TE;
				   TC = TA * TB;
			      }
			 }
			 {
			      E T7j, TeN, Tz, T7k, T7o, TF, TeO, TM;
			      T7j = T7g - T7i;
			      TeN = T7g + T7i;
			      Tz = Ts + Ty;
			      T7k = Ts - Ty;
			      T7o = FNMS(TD, TB, T7n);
			      TF = FMA(TD, TE, TC);
			      T7r = T7o - T7q;
			      TeO = T7o + T7q;
			      TM = TF + TL;
			      T7m = TF - TL;
			      TcB = T7k + T7j;
			      T7l = T7j - T7k;
			      TiP = TeN + TeO;
			      TeP = TeN - TeO;
			      Tjl = TM - Tz;
			      TN = Tz + TM;
			 }
		    }
		    {
			 E T7w, TU, T13, T16, T7y, T10, T12, T15, T7D, T14;
			 {
			      E T19, T1c, T18, T1b;
			      {
				   E TQ, TT, TS, T7v, TR, TP;
				   TQ = ri[WS(ios, 4)];
				   TT = ii[WS(ios, 4)];
				   TP = W[6];
				   TcC = T7m - T7r;
				   T7s = T7m + T7r;
				   TS = W[7];
				   T7v = TP * TT;
				   TR = TP * TQ;
				   T19 = ri[WS(ios, 52)];
				   T1c = ii[WS(ios, 52)];
				   T7w = FNMS(TS, TQ, T7v);
				   TU = FMA(TS, TT, TR);
				   T18 = W[102];
				   T1b = W[103];
			      }
			      {
				   E TW, TZ, TY, T7x, TX, T7F, T1a, TV;
				   TW = ri[WS(ios, 36)];
				   TZ = ii[WS(ios, 36)];
				   T7F = T18 * T1c;
				   T1a = T18 * T19;
				   TV = W[70];
				   TY = W[71];
				   T7G = FNMS(T1b, T19, T7F);
				   T1d = FMA(T1b, T1c, T1a);
				   T7x = TV * TZ;
				   TX = TV * TW;
				   T13 = ri[WS(ios, 20)];
				   T16 = ii[WS(ios, 20)];
				   T7y = FNMS(TY, TW, T7x);
				   T10 = FMA(TY, TZ, TX);
				   T12 = W[38];
				   T15 = W[39];
			      }
			 }
			 T7z = T7w - T7y;
			 TeS = T7w + T7y;
			 T11 = TU + T10;
			 T7C = TU - T10;
			 T7D = T12 * T16;
			 T14 = T12 * T13;
			 T7E = FNMS(T15, T13, T7D);
			 T17 = FMA(T15, T16, T14);
		    }
		    {
			 E T8B, T2H, T91, T30, T2Q, T2T, T2S, T8D, T2N, T8Y, T2R;
			 {
			      E T2W, T2Z, T2Y, T90, T2X;
			      {
				   E T2D, T2G, T2C, T2F, T8A, T2E, T2V;
				   T2D = ri[WS(ios, 62)];
				   T2G = ii[WS(ios, 62)];
				   {
					E TeT, T7H, T1e, T7A;
					TeT = T7E + T7G;
					T7H = T7E - T7G;
					T1e = T17 + T1d;
					T7A = T17 - T1d;
					T7I = T7C - T7H;
					TcF = T7C + T7H;
					TeU = TeS - TeT;
					Thr = TeS + TeT;
					T7B = T7z + T7A;
					TcG = T7z - T7A;
					T1f = T11 + T1e;
					TeR = T11 - T1e;
					T2C = W[122];
				   }
				   T2F = W[123];
				   T2W = ri[WS(ios, 46)];
				   T2Z = ii[WS(ios, 46)];
				   T8A = T2C * T2G;
				   T2E = T2C * T2D;
				   T2V = W[90];
				   T2Y = W[91];
				   T8B = FNMS(T2F, T2D, T8A);
				   T2H = FMA(T2F, T2G, T2E);
				   T90 = T2V * T2Z;
				   T2X = T2V * T2W;
			      }
			      {
				   E T2J, T2M, T2I, T2L, T8C, T2K, T2P;
				   T2J = ri[WS(ios, 30)];
				   T2M = ii[WS(ios, 30)];
				   T91 = FNMS(T2Y, T2W, T90);
				   T30 = FMA(T2Y, T2Z, T2X);
				   T2I = W[58];
				   T2L = W[59];
				   T2Q = ri[WS(ios, 14)];
				   T2T = ii[WS(ios, 14)];
				   T8C = T2I * T2M;
				   T2K = T2I * T2J;
				   T2P = W[26];
				   T2S = W[27];
				   T8D = FNMS(T2L, T2J, T8C);
				   T2N = FMA(T2L, T2M, T2K);
				   T8Y = T2P * T2T;
				   T2R = T2P * T2Q;
			      }
			 }
			 {
			      E T8E, Tfe, T2O, T8X, T8Z, T2U;
			      T8E = T8B - T8D;
			      Tfe = T8B + T8D;
			      T2O = T2H + T2N;
			      T8X = T2H - T2N;
			      T8Z = FNMS(T2S, T2Q, T8Y);
			      T2U = FMA(T2S, T2T, T2R);
			      {
				   E T92, Tff, T8F, T31;
				   T92 = T8Z - T91;
				   Tff = T8Z + T91;
				   T8F = T2U - T30;
				   T31 = T2U + T30;
				   Tfg = Tfe - Tff;
				   ThB = Tfe + Tff;
				   T8G = T8E + T8F;
				   TcU = T8E - T8F;
				   T32 = T2O + T31;
				   Tfj = T2O - T31;
				   TcX = T8X + T92;
				   T93 = T8X - T92;
			      }
			 }
		    }
		    {
			 E T9c, T3C, Ta8, T3V, T3L, T3O, T3N, T9e, T3I, Ta5, T3M;
			 {
			      E T3R, T3U, T3T, Ta7, T3S;
			      {
				   E T3y, T3B, T3x, T3A, T9b, T3z, T3Q;
				   T3y = ri[WS(ios, 1)];
				   T3B = ii[WS(ios, 1)];
				   T3x = W[0];
				   T3A = W[1];
				   T3R = ri[WS(ios, 49)];
				   T3U = ii[WS(ios, 49)];
				   T9b = T3x * T3B;
				   T3z = T3x * T3y;
				   T3Q = W[96];
				   T3T = W[97];
				   T9c = FNMS(T3A, T3y, T9b);
				   T3C = FMA(T3A, T3B, T3z);
				   Ta7 = T3Q * T3U;
				   T3S = T3Q * T3R;
			      }
			      {
				   E T3E, T3H, T3D, T3G, T9d, T3F, T3K;
				   T3E = ri[WS(ios, 33)];
				   T3H = ii[WS(ios, 33)];
				   Ta8 = FNMS(T3T, T3R, Ta7);
				   T3V = FMA(T3T, T3U, T3S);
				   T3D = W[64];
				   T3G = W[65];
				   T3L = ri[WS(ios, 17)];
				   T3O = ii[WS(ios, 17)];
				   T9d = T3D * T3H;
				   T3F = T3D * T3E;
				   T3K = W[32];
				   T3N = W[33];
				   T9e = FNMS(T3G, T3E, T9d);
				   T3I = FMA(T3G, T3H, T3F);
				   Ta5 = T3K * T3O;
				   T3M = T3K * T3L;
			      }
			 }
			 {
			      E T9f, Tfr, T3J, Ta4, Ta6, T3P;
			      T9f = T9c - T9e;
			      Tfr = T9c + T9e;
			      T3J = T3C + T3I;
			      Ta4 = T3C - T3I;
			      Ta6 = FNMS(T3N, T3L, Ta5);
			      T3P = FMA(T3N, T3O, T3M);
			      {
				   E Ta9, Tfs, T9g, T3W;
				   Ta9 = Ta6 - Ta8;
				   Tfs = Ta6 + Ta8;
				   T9g = T3P - T3V;
				   T3W = T3P + T3V;
				   Tft = Tfr - Tfs;
				   ThH = Tfr + Tfs;
				   T9h = T9f + T9g;
				   Td3 = T9f - T9g;
				   T3X = T3J + T3W;
				   TfI = T3J - T3W;
				   Tde = Ta4 + Ta9;
				   Taa = Ta4 - Ta9;
			      }
			 }
		    }
	       }
	       {
		    E TaC, T69, Taw, Tga, T5X, Tar, TaA, T63;
		    {
			 E T8S, T3r, T8M, Tfk, T3f, T8H, T8Q, T3l;
			 {
			      E T8k, T8f, T8w, T8e;
			      {
				   E T8a, T2f, T8j, T2y, T2o, T2r, T2q, T8c, T2l, T8g, T2p;
				   {
					E T2u, T2x, T2w, T8i, T2v;
					{
					     E T2b, T2e, T2a, T2d, T89, T2c, T2t;
					     T2b = ri[WS(ios, 10)];
					     T2e = ii[WS(ios, 10)];
					     T2a = W[18];
					     T2d = W[19];
					     T2u = ri[WS(ios, 26)];
					     T2x = ii[WS(ios, 26)];
					     T89 = T2a * T2e;
					     T2c = T2a * T2b;
					     T2t = W[50];
					     T2w = W[51];
					     T8a = FNMS(T2d, T2b, T89);
					     T2f = FMA(T2d, T2e, T2c);
					     T8i = T2t * T2x;
					     T2v = T2t * T2u;
					}
					{
					     E T2h, T2k, T2g, T2j, T8b, T2i, T2n;
					     T2h = ri[WS(ios, 42)];
					     T2k = ii[WS(ios, 42)];
					     T8j = FNMS(T2w, T2u, T8i);
					     T2y = FMA(T2w, T2x, T2v);
					     T2g = W[82];
					     T2j = W[83];
					     T2o = ri[WS(ios, 58)];
					     T2r = ii[WS(ios, 58)];
					     T8b = T2g * T2k;
					     T2i = T2g * T2h;
					     T2n = W[114];
					     T2q = W[115];
					     T8c = FNMS(T2j, T2h, T8b);
					     T2l = FMA(T2j, T2k, T2i);
					     T8g = T2n * T2r;
					     T2p = T2n * T2o;
					}
				   }
				   {
					E T8d, Tf9, T2m, T88, T8h, T2s, Tfa, T2z;
					T8d = T8a - T8c;
					Tf9 = T8a + T8c;
					T2m = T2f + T2l;
					T88 = T2f - T2l;
					T8h = FNMS(T2q, T2o, T8g);
					T2s = FMA(T2q, T2r, T2p);
					T8k = T8h - T8j;
					Tfa = T8h + T8j;
					T2z = T2s + T2y;
					T8f = T2s - T2y;
					T8w = T8d - T88;
					T8e = T88 + T8d;
					Thw = Tf9 + Tfa;
					Tfb = Tf9 - Tfa;
					Tf6 = T2z - T2m;
					T2A = T2m + T2z;
				   }
			      }
			      {
				   E T38, T8J, T3h, T3k, T8L, T3e, T3g, T3j, T8P, T3i;
				   {
					E T3n, T3q, T3m, T3p;
					{
					     E T34, T37, T33, T8v, T8l, T36, T8I, T35;
					     T34 = ri[WS(ios, 6)];
					     T37 = ii[WS(ios, 6)];
					     T33 = W[10];
					     T8v = T8f + T8k;
					     T8l = T8f - T8k;
					     T36 = W[11];
					     T8I = T33 * T37;
					     T35 = T33 * T34;
					     T8x = T8v - T8w;
					     TcO = T8w + T8v;
					     T8m = T8e - T8l;
					     TcR = T8e + T8l;
					     T38 = FMA(T36, T37, T35);
					     T8J = FNMS(T36, T34, T8I);
					}
					T3n = ri[WS(ios, 22)];
					T3q = ii[WS(ios, 22)];
					T3m = W[42];
					T3p = W[43];
					{
					     E T3a, T3d, T3c, T8K, T3b, T8R, T3o, T39;
					     T3a = ri[WS(ios, 38)];
					     T3d = ii[WS(ios, 38)];
					     T8R = T3m * T3q;
					     T3o = T3m * T3n;
					     T39 = W[74];
					     T3c = W[75];
					     T8S = FNMS(T3p, T3n, T8R);
					     T3r = FMA(T3p, T3q, T3o);
					     T8K = T39 * T3d;
					     T3b = T39 * T3a;
					     T3h = ri[WS(ios, 54)];
					     T3k = ii[WS(ios, 54)];
					     T8L = FNMS(T3c, T3a, T8K);
					     T3e = FMA(T3c, T3d, T3b);
					     T3g = W[106];
					     T3j = W[107];
					}
				   }
				   T8M = T8J - T8L;
				   Tfk = T8J + T8L;
				   T3f = T38 + T3e;
				   T8H = T38 - T3e;
				   T8P = T3g * T3k;
				   T3i = T3g * T3h;
				   T8Q = FNMS(T3j, T3h, T8P);
				   T3l = FMA(T3j, T3k, T3i);
			      }
			 }
			 {
			      E T9u, T9p, Tac, T9o;
			      {
				   E T9k, T43, T9t, T4m, T4c, T4f, T4e, T9m, T49, T9q, T4d;
				   {
					E T4i, T4l, T4k, T9s, T4j;
					{
					     E T3Z, T42, T3Y, T41, T9j, T40, T4h;
					     {
						  E T95, T8N, T8T, Tfl, T8O, T3s, T8U, T94;
						  T3Z = ri[WS(ios, 9)];
						  T95 = T8M - T8H;
						  T8N = T8H + T8M;
						  T8T = T8Q - T8S;
						  Tfl = T8Q + T8S;
						  T8O = T3l - T3r;
						  T3s = T3l + T3r;
						  T42 = ii[WS(ios, 9)];
						  Tfm = Tfk - Tfl;
						  ThC = Tfk + Tfl;
						  T8U = T8O - T8T;
						  T94 = T8O + T8T;
						  T3t = T3f + T3s;
						  Tfh = T3s - T3f;
						  T96 = T94 - T95;
						  TcV = T95 + T94;
						  T8V = T8N - T8U;
						  TcY = T8N + T8U;
						  T3Y = W[16];
					     }
					     T41 = W[17];
					     T4i = ri[WS(ios, 25)];
					     T4l = ii[WS(ios, 25)];
					     T9j = T3Y * T42;
					     T40 = T3Y * T3Z;
					     T4h = W[48];
					     T4k = W[49];
					     T9k = FNMS(T41, T3Z, T9j);
					     T43 = FMA(T41, T42, T40);
					     T9s = T4h * T4l;
					     T4j = T4h * T4i;
					}
					{
					     E T45, T48, T44, T47, T9l, T46, T4b;
					     T45 = ri[WS(ios, 41)];
					     T48 = ii[WS(ios, 41)];
					     T9t = FNMS(T4k, T4i, T9s);
					     T4m = FMA(T4k, T4l, T4j);
					     T44 = W[80];
					     T47 = W[81];
					     T4c = ri[WS(ios, 57)];
					     T4f = ii[WS(ios, 57)];
					     T9l = T44 * T48;
					     T46 = T44 * T45;
					     T4b = W[112];
					     T4e = W[113];
					     T9m = FNMS(T47, T45, T9l);
					     T49 = FMA(T47, T48, T46);
					     T9q = T4b * T4f;
					     T4d = T4b * T4c;
					}
				   }
				   {
					E T9n, TfJ, T4a, T9i, T9r, T4g, TfK, T4n;
					T9n = T9k - T9m;
					TfJ = T9k + T9m;
					T4a = T43 + T49;
					T9i = T43 - T49;
					T9r = FNMS(T4e, T4c, T9q);
					T4g = FMA(T4e, T4f, T4d);
					T9u = T9r - T9t;
					TfK = T9r + T9t;
					T4n = T4g + T4m;
					T9p = T4g - T4m;
					Tac = T9n - T9i;
					T9o = T9i + T9n;
					ThI = TfJ + TfK;
					TfL = TfJ - TfK;
					Tfu = T4n - T4a;
					T4o = T4a + T4n;
				   }
			      }
			      {
				   E T5Q, Tat, T5Z, T62, Tav, T5W, T5Y, T61, Taz, T60;
				   {
					E T65, T68, T64, T67;
					{
					     E T5M, T5P, T5L, Tab, T9v, T5O, Tas, T5N;
					     T5M = ri[WS(ios, 7)];
					     T5P = ii[WS(ios, 7)];
					     T5L = W[12];
					     Tab = T9p + T9u;
					     T9v = T9p - T9u;
					     T5O = W[13];
					     Tas = T5L * T5P;
					     T5N = T5L * T5M;
					     Tad = Tab - Tac;
					     Td4 = Tac + Tab;
					     T9w = T9o - T9v;
					     Tdf = T9o + T9v;
					     T5Q = FMA(T5O, T5P, T5N);
					     Tat = FNMS(T5O, T5M, Tas);
					}
					T65 = ri[WS(ios, 23)];
					T68 = ii[WS(ios, 23)];
					T64 = W[44];
					T67 = W[45];
					{
					     E T5S, T5V, T5U, Tau, T5T, TaB, T66, T5R;
					     T5S = ri[WS(ios, 39)];
					     T5V = ii[WS(ios, 39)];
					     TaB = T64 * T68;
					     T66 = T64 * T65;
					     T5R = W[76];
					     T5U = W[77];
					     TaC = FNMS(T67, T65, TaB);
					     T69 = FMA(T67, T68, T66);
					     Tau = T5R * T5V;
					     T5T = T5R * T5S;
					     T5Z = ri[WS(ios, 55)];
					     T62 = ii[WS(ios, 55)];
					     Tav = FNMS(T5U, T5S, Tau);
					     T5W = FMA(T5U, T5V, T5T);
					     T5Y = W[108];
					     T61 = W[109];
					}
				   }
				   Taw = Tat - Tav;
				   Tga = Tat + Tav;
				   T5X = T5Q + T5W;
				   Tar = T5Q - T5W;
				   Taz = T5Y * T62;
				   T60 = T5Y * T5Z;
				   TaA = FNMS(T61, T5Z, Taz);
				   T63 = FMA(T61, T62, T60);
			      }
			 }
		    }
		    {
			 E T9E, Tda, TfE, TfB, Td9, T9L;
			 {
			      E T9T, Td7, Tfy, Tfz, Td6, Ta0;
			      {
				   E T9V, T4v, T9R, T4O, T4E, T4H, T4G, T9X, T4B, T9O, T4F;
				   {
					E T4K, T4N, T4M, T9Q, T4L;
					{
					     E T4r, T4u, T4q, T4t, T9U, T4s, T4J;
					     {
						  E Tbl, Tax, TaD, Tgb, Tay, T6a, TaE, Tbk;
						  T4r = ri[WS(ios, 5)];
						  Tbl = Taw - Tar;
						  Tax = Tar + Taw;
						  TaD = TaA - TaC;
						  Tgb = TaA + TaC;
						  Tay = T63 - T69;
						  T6a = T63 + T69;
						  T4u = ii[WS(ios, 5)];
						  Tgc = Tga - Tgb;
						  ThT = Tga + Tgb;
						  TaE = Tay - TaD;
						  Tbk = Tay + TaD;
						  T6b = T5X + T6a;
						  TfV = T6a - T5X;
						  Tbm = Tbk - Tbl;
						  Tdn = Tbl + Tbk;
						  TaF = Tax - TaE;
						  Tdy = Tax + TaE;
						  T4q = W[8];
					     }
					     T4t = W[9];
					     T4K = ri[WS(ios, 53)];
					     T4N = ii[WS(ios, 53)];
					     T9U = T4q * T4u;
					     T4s = T4q * T4r;
					     T4J = W[104];
					     T4M = W[105];
					     T9V = FNMS(T4t, T4r, T9U);
					     T4v = FMA(T4t, T4u, T4s);
					     T9Q = T4J * T4N;
					     T4L = T4J * T4K;
					}
					{
					     E T4x, T4A, T4w, T4z, T9W, T4y, T4D;
					     T4x = ri[WS(ios, 37)];
					     T4A = ii[WS(ios, 37)];
					     T9R = FNMS(T4M, T4K, T9Q);
					     T4O = FMA(T4M, T4N, T4L);
					     T4w = W[72];
					     T4z = W[73];
					     T4E = ri[WS(ios, 21)];
					     T4H = ii[WS(ios, 21)];
					     T9W = T4w * T4A;
					     T4y = T4w * T4x;
					     T4D = W[40];
					     T4G = W[41];
					     T9X = FNMS(T4z, T4x, T9W);
					     T4B = FMA(T4z, T4A, T4y);
					     T9O = T4D * T4H;
					     T4F = T4D * T4E;
					}
				   }
				   {
					E T9Y, Tfw, T4C, T9N, T9P, T4I;
					T9Y = T9V - T9X;
					Tfw = T9V + T9X;
					T4C = T4v + T4B;
					T9N = T4v - T4B;
					T9P = FNMS(T4G, T4E, T9O);
					T4I = FMA(T4G, T4H, T4F);
					{
					     E Tfx, T9S, T9Z, T4P;
					     Tfx = T9P + T9R;
					     T9S = T9P - T9R;
					     T9Z = T4I - T4O;
					     T4P = T4I + T4O;
					     T9T = T9N - T9S;
					     Td7 = T9N + T9S;
					     Tfy = Tfw - Tfx;
					     ThN = Tfw + Tfx;
					     Tfz = T4C - T4P;
					     T4Q = T4C + T4P;
					     Td6 = T9Y - T9Z;
					     Ta0 = T9Y + T9Z;
					}
				   }
			      }
			      {
				   E T9G, T4W, T9C, T5f, T55, T58, T57, T9I, T52, T9z, T56;
				   {
					E T5b, T5e, T5d, T9B, T5c;
					{
					     E T4S, T4V, T4R, T4U, T9F, T4T, T5a;
					     T4S = ri[WS(ios, 61)];
					     TfN = Tfz + Tfy;
					     TfA = Tfy - Tfz;
					     Taf = FMA(KP414213562, T9T, Ta0);
					     Ta1 = FNMS(KP414213562, Ta0, T9T);
					     Td8 = FNMS(KP414213562, Td7, Td6);
					     Tdh = FMA(KP414213562, Td6, Td7);
					     T4V = ii[WS(ios, 61)];
					     T4R = W[120];
					     T4U = W[121];
					     T5b = ri[WS(ios, 45)];
					     T5e = ii[WS(ios, 45)];
					     T9F = T4R * T4V;
					     T4T = T4R * T4S;
					     T5a = W[88];
					     T5d = W[89];
					     T9G = FNMS(T4U, T4S, T9F);
					     T4W = FMA(T4U, T4V, T4T);
					     T9B = T5a * T5e;
					     T5c = T5a * T5b;
					}
					{
					     E T4Y, T51, T4X, T50, T9H, T4Z, T54;
					     T4Y = ri[WS(ios, 29)];
					     T51 = ii[WS(ios, 29)];
					     T9C = FNMS(T5d, T5b, T9B);
					     T5f = FMA(T5d, T5e, T5c);
					     T4X = W[56];
					     T50 = W[57];
					     T55 = ri[WS(ios, 13)];
					     T58 = ii[WS(ios, 13)];
					     T9H = T4X * T51;
					     T4Z = T4X * T4Y;
					     T54 = W[24];
					     T57 = W[25];
					     T9I = FNMS(T50, T4Y, T9H);
					     T52 = FMA(T50, T51, T4Z);
					     T9z = T54 * T58;
					     T56 = T54 * T55;
					}
				   }
				   {
					E T9J, TfC, T53, T9y, T9A, T59;
					T9J = T9G - T9I;
					TfC = T9G + T9I;
					T53 = T4W + T52;
					T9y = T4W - T52;
					T9A = FNMS(T57, T55, T9z);
					T59 = FMA(T57, T58, T56);
					{
					     E TfD, T9D, T9K, T5g;
					     TfD = T9A + T9C;
					     T9D = T9A - T9C;
					     T9K = T59 - T5f;
					     T5g = T59 + T5f;
					     T9E = T9y - T9D;
					     Tda = T9y + T9D;
					     TfE = TfC - TfD;
					     ThO = TfC + TfD;
					     TfB = T53 - T5g;
					     T5h = T53 + T5g;
					     Td9 = T9J - T9K;
					     T9L = T9J + T9K;
					}
				   }
			      }
			 }
			 {
			      E Tb2, Tdq, TfZ, Tg0, Tdp, Tb9;
			      {
				   E Tb4, T6i, Tb0, T6B, T6r, T6u, T6t, Tb6, T6o, TaX, T6s;
				   {
					E T6x, T6A, T6z, TaZ, T6y;
					{
					     E T6e, T6h, T6d, T6g, Tb3, T6f, T6w;
					     T6e = ri[WS(ios, 3)];
					     TfO = TfB - TfE;
					     TfF = TfB + TfE;
					     Tag = FNMS(KP414213562, T9E, T9L);
					     T9M = FMA(KP414213562, T9L, T9E);
					     Tdb = FMA(KP414213562, Tda, Td9);
					     Tdi = FNMS(KP414213562, Td9, Tda);
					     T6h = ii[WS(ios, 3)];
					     T6d = W[4];
					     T6g = W[5];
					     T6x = ri[WS(ios, 51)];
					     T6A = ii[WS(ios, 51)];
					     Tb3 = T6d * T6h;
					     T6f = T6d * T6e;
					     T6w = W[100];
					     T6z = W[101];
					     Tb4 = FNMS(T6g, T6e, Tb3);
					     T6i = FMA(T6g, T6h, T6f);
					     TaZ = T6w * T6A;
					     T6y = T6w * T6x;
					}
					{
					     E T6k, T6n, T6j, T6m, Tb5, T6l, T6q;
					     T6k = ri[WS(ios, 35)];
					     T6n = ii[WS(ios, 35)];
					     Tb0 = FNMS(T6z, T6x, TaZ);
					     T6B = FMA(T6z, T6A, T6y);
					     T6j = W[68];
					     T6m = W[69];
					     T6r = ri[WS(ios, 19)];
					     T6u = ii[WS(ios, 19)];
					     Tb5 = T6j * T6n;
					     T6l = T6j * T6k;
					     T6q = W[36];
					     T6t = W[37];
					     Tb6 = FNMS(T6m, T6k, Tb5);
					     T6o = FMA(T6m, T6n, T6l);
					     TaX = T6q * T6u;
					     T6s = T6q * T6r;
					}
				   }
				   {
					E Tb7, TfX, T6p, TaW, TaY, T6v;
					Tb7 = Tb4 - Tb6;
					TfX = Tb4 + Tb6;
					T6p = T6i + T6o;
					TaW = T6i - T6o;
					TaY = FNMS(T6t, T6r, TaX);
					T6v = FMA(T6t, T6u, T6s);
					{
					     E TfY, Tb1, Tb8, T6C;
					     TfY = TaY + Tb0;
					     Tb1 = TaY - Tb0;
					     Tb8 = T6v - T6B;
					     T6C = T6v + T6B;
					     Tb2 = TaW - Tb1;
					     Tdq = TaW + Tb1;
					     TfZ = TfX - TfY;
					     ThY = TfX + TfY;
					     Tg0 = T6p - T6C;
					     T6D = T6p + T6C;
					     Tdp = Tb7 - Tb8;
					     Tb9 = Tb7 + Tb8;
					}
				   }
			      }
			      {
				   E TaP, T6J, TaL, T72, T6S, T6V, T6U, TaR, T6P, TaI, T6T;
				   {
					E T6Y, T71, T70, TaK, T6Z;
					{
					     E T6F, T6I, T6E, T6H, TaO, T6G, T6X;
					     T6F = ri[WS(ios, 59)];
					     Tge = Tg0 + TfZ;
					     Tg1 = TfZ - Tg0;
					     Tbo = FMA(KP414213562, Tb2, Tb9);
					     Tba = FNMS(KP414213562, Tb9, Tb2);
					     Tdr = FNMS(KP414213562, Tdq, Tdp);
					     TdA = FMA(KP414213562, Tdp, Tdq);
					     T6I = ii[WS(ios, 59)];
					     T6E = W[116];
					     T6H = W[117];
					     T6Y = ri[WS(ios, 43)];
					     T71 = ii[WS(ios, 43)];
					     TaO = T6E * T6I;
					     T6G = T6E * T6F;
					     T6X = W[84];
					     T70 = W[85];
					     TaP = FNMS(T6H, T6F, TaO);
					     T6J = FMA(T6H, T6I, T6G);
					     TaK = T6X * T71;
					     T6Z = T6X * T6Y;
					}
					{
					     E T6L, T6O, T6K, T6N, TaQ, T6M, T6R;
					     T6L = ri[WS(ios, 27)];
					     T6O = ii[WS(ios, 27)];
					     TaL = FNMS(T70, T6Y, TaK);
					     T72 = FMA(T70, T71, T6Z);
					     T6K = W[52];
					     T6N = W[53];
					     T6S = ri[WS(ios, 11)];
					     T6V = ii[WS(ios, 11)];
					     TaQ = T6K * T6O;
					     T6M = T6K * T6L;
					     T6R = W[20];
					     T6U = W[21];
					     TaR = FNMS(T6N, T6L, TaQ);
					     T6P = FMA(T6N, T6O, T6M);
					     TaI = T6R * T6V;
					     T6T = T6R * T6S;
					}
				   }
				   {
					E TaS, Tg3, T6Q, TaH, TaJ, T6W;
					TaS = TaP - TaR;
					Tg3 = TaP + TaR;
					T6Q = T6J + T6P;
					TaH = T6J - T6P;
					TaJ = FNMS(T6U, T6S, TaI);
					T6W = FMA(T6U, T6V, T6T);
					{
					     E Tg4, TaM, TaT, T73;
					     Tg4 = TaJ + TaL;
					     TaM = TaJ - TaL;
					     TaT = T6W - T72;
					     T73 = T6W + T72;
					     TaN = TaH - TaM;
					     Tdt = TaH + TaM;
					     Tg5 = Tg3 - Tg4;
					     ThZ = Tg3 + Tg4;
					     Tg2 = T6Q - T73;
					     T74 = T6Q + T73;
					     Tds = TaS - TaT;
					     TaU = TaS + TaT;
					}
				   }
			      }
			 }
		    }
	       }
	       {
		    E Tgf, Tg6, Tbp, TaV, Tdu, TdB, Tje, Tjd, TjO, TjN;
		    {
			 E Thq, Tj7, Thy, ThA, Tht, Tj8, Thx, ThD, ThX, ThV, ThU, Ti0, ThM, ThK, ThJ;
			 E ThP, TiI, TiZ, TiL, Tj0;
			 {
			      E Tio, T1I, Tj1, T3v, Tj2, TiX, TiN, Tir, T76, TiK, TiC, TiG, T5j, Tit, Tiw;
			      E TiJ;
			      {
				   E TiO, TiW, Tip, Tiq;
				   {
					E TO, T1H, T2B, T3u;
					Thq = Tm - TN;
					TO = Tm + TN;
					Tgf = Tg2 - Tg5;
					Tg6 = Tg2 + Tg5;
					Tbp = FNMS(KP414213562, TaN, TaU);
					TaV = FMA(KP414213562, TaU, TaN);
					Tdu = FMA(KP414213562, Tdt, Tds);
					TdB = FNMS(KP414213562, Tds, Tdt);
					T1H = T1f + T1G;
					Tj7 = T1G - T1f;
					Thy = T29 - T2A;
					T2B = T29 + T2A;
					T3u = T32 + T3t;
					ThA = T32 - T3t;
					Tht = Thr - Ths;
					TiO = Thr + Ths;
					Tio = TO - T1H;
					T1I = TO + T1H;
					Tj1 = T3u - T2B;
					T3v = T2B + T3u;
					TiW = TiP + TiV;
					Tj8 = TiV - TiP;
				   }
				   Thx = Thv - Thw;
				   Tip = Thv + Thw;
				   Tiq = ThB + ThC;
				   ThD = ThB - ThC;
				   {
					E T6c, T75, Tiz, TiA;
					ThX = T5K - T6b;
					T6c = T5K + T6b;
					Tj2 = TiW - TiO;
					TiX = TiO + TiW;
					TiN = Tip + Tiq;
					Tir = Tip - Tiq;
					T75 = T6D + T74;
					ThV = T74 - T6D;
					ThU = ThS - ThT;
					Tiz = ThS + ThT;
					TiA = ThY + ThZ;
					Ti0 = ThY - ThZ;
					{
					     E T4p, Tiy, TiB, T5i, Tiu, Tiv;
					     ThM = T3X - T4o;
					     T4p = T3X + T4o;
					     T76 = T6c + T75;
					     Tiy = T6c - T75;
					     TiK = Tiz + TiA;
					     TiB = Tiz - TiA;
					     T5i = T4Q + T5h;
					     ThK = T5h - T4Q;
					     ThJ = ThH - ThI;
					     Tiu = ThH + ThI;
					     Tiv = ThN + ThO;
					     ThP = ThN - ThO;
					     TiC = Tiy - TiB;
					     TiG = Tiy + TiB;
					     T5j = T4p + T5i;
					     Tit = T4p - T5i;
					     Tiw = Tiu - Tiv;
					     TiJ = Tiu + Tiv;
					}
				   }
			      }
			      {
				   E TiE, Tis, TiD, Tj6, Tj5, Tj3, Tj4, TiH;
				   {
					E T3w, TiF, Tix, T77, TiM, TiY;
					TiI = T1I - T3v;
					T3w = T1I + T3v;
					TiF = Tiw - Tit;
					Tix = Tit + Tiw;
					T77 = T5j + T76;
					TiZ = T76 - T5j;
					TiL = TiJ - TiK;
					TiM = TiJ + TiK;
					TiY = TiN + TiX;
					Tj0 = TiX - TiN;
					TiE = Tio - Tir;
					Tis = Tio + Tir;
					ri[0] = T3w + T77;
					ri[WS(ios, 32)] = T3w - T77;
					ii[WS(ios, 32)] = TiY - TiM;
					ii[0] = TiM + TiY;
					TiD = Tix + TiC;
					Tj6 = TiC - Tix;
					Tj5 = Tj2 - Tj1;
					Tj3 = Tj1 + Tj2;
					Tj4 = TiF + TiG;
					TiH = TiF - TiG;
				   }
				   ri[WS(ios, 8)] = FMA(KP707106781, TiD, Tis);
				   ri[WS(ios, 40)] = FNMS(KP707106781, TiD, Tis);
				   ii[WS(ios, 40)] = FNMS(KP707106781, Tj4, Tj3);
				   ii[WS(ios, 8)] = FMA(KP707106781, Tj4, Tj3);
				   ri[WS(ios, 24)] = FMA(KP707106781, TiH, TiE);
				   ri[WS(ios, 56)] = FNMS(KP707106781, TiH, TiE);
				   ii[WS(ios, 56)] = FNMS(KP707106781, Tj6, Tj5);
				   ii[WS(ios, 24)] = FMA(KP707106781, Tj6, Tj5);
			      }
			 }
			 {
			      E Ti8, Thu, Tjf, Tj9, Tib, Tjg, Tja, ThF, Tih, ThW, Tif, Til, Ti5, ThR;
			      ri[WS(ios, 16)] = TiI + TiL;
			      ri[WS(ios, 48)] = TiI - TiL;
			      ii[WS(ios, 48)] = Tj0 - TiZ;
			      ii[WS(ios, 16)] = TiZ + Tj0;
			      Ti8 = Thq + Tht;
			      Thu = Thq - Tht;
			      Tjf = Tj8 - Tj7;
			      Tj9 = Tj7 + Tj8;
			      {
				   E Tie, ThL, Tid, ThQ;
				   {
					E Ti9, Thz, Tia, ThE;
					Ti9 = Thy + Thx;
					Thz = Thx - Thy;
					Tia = ThA - ThD;
					ThE = ThA + ThD;
					Tib = Ti9 + Tia;
					Tjg = Tia - Ti9;
					Tja = Thz + ThE;
					ThF = Thz - ThE;
					Tie = ThJ + ThK;
					ThL = ThJ - ThK;
				   }
				   Tid = ThM + ThP;
				   ThQ = ThM - ThP;
				   Tih = ThU + ThV;
				   ThW = ThU - ThV;
				   Tif = FMA(KP414213562, Tie, Tid);
				   Til = FNMS(KP414213562, Tid, Tie);
				   Ti5 = FNMS(KP414213562, ThL, ThQ);
				   ThR = FMA(KP414213562, ThQ, ThL);
			      }
			      {
				   E Ti4, ThG, Tjh, Tjj, Tig, Ti1;
				   Ti4 = FNMS(KP707106781, ThF, Thu);
				   ThG = FMA(KP707106781, ThF, Thu);
				   Tjh = FMA(KP707106781, Tjg, Tjf);
				   Tjj = FNMS(KP707106781, Tjg, Tjf);
				   Tig = ThX + Ti0;
				   Ti1 = ThX - Ti0;
				   {
					E Tik, Tjb, Tjc, Tin;
					{
					     E Tic, Tim, Ti6, Ti2, Tij, Tii;
					     Tik = FNMS(KP707106781, Tib, Ti8);
					     Tic = FMA(KP707106781, Tib, Ti8);
					     Tii = FNMS(KP414213562, Tih, Tig);
					     Tim = FMA(KP414213562, Tig, Tih);
					     Ti6 = FMA(KP414213562, ThW, Ti1);
					     Ti2 = FNMS(KP414213562, Ti1, ThW);
					     Tij = Tif + Tii;
					     Tje = Tii - Tif;
					     Tjd = FNMS(KP707106781, Tja, Tj9);
					     Tjb = FMA(KP707106781, Tja, Tj9);
					     {
						  E Ti7, Tji, Tjk, Ti3;
						  Ti7 = Ti5 + Ti6;
						  Tji = Ti6 - Ti5;
						  Tjk = ThR + Ti2;
						  Ti3 = ThR - Ti2;
						  ri[WS(ios, 4)] = FMA(KP923879532, Tij, Tic);
						  ri[WS(ios, 36)] = FNMS(KP923879532, Tij, Tic);
						  ri[WS(ios, 60)] = FMA(KP923879532, Ti7, Ti4);
						  ri[WS(ios, 28)] = FNMS(KP923879532, Ti7, Ti4);
						  ii[WS(ios, 44)] = FNMS(KP923879532, Tji, Tjh);
						  ii[WS(ios, 12)] = FMA(KP923879532, Tji, Tjh);
						  ii[WS(ios, 60)] = FMA(KP923879532, Tjk, Tjj);
						  ii[WS(ios, 28)] = FNMS(KP923879532, Tjk, Tjj);
						  ri[WS(ios, 12)] = FMA(KP923879532, Ti3, ThG);
						  ri[WS(ios, 44)] = FNMS(KP923879532, Ti3, ThG);
						  Tjc = Til + Tim;
						  Tin = Til - Tim;
					     }
					}
					ii[WS(ios, 36)] = FNMS(KP923879532, Tjc, Tjb);
					ii[WS(ios, 4)] = FMA(KP923879532, Tjc, Tjb);
					ri[WS(ios, 20)] = FMA(KP923879532, Tin, Tik);
					ri[WS(ios, 52)] = FNMS(KP923879532, Tin, Tik);
				   }
			      }
			 }
		    }
		    {
			 E TjD, TjJ, Tgo, Tf2, Tjp, Tjv, Tha, TgI, Tgd, Tgr, Tjw, Tjq, Tfp, Tgg, Thk;
			 E Tho, Th8, Th4, Tgv, TgB, Tgl, TfR, TjE, Thd, TjK, TgP, Tgx, Tg8, Thh, Thn;
			 E Th7, TgX;
			 {
			      E TgJ, TgK, TgM, TgN, Tg7, TfW, Th1, Thj, Th0, Th2;
			      {
				   E TgE, TeQ, TjB, Tjn, TgF, TgG, TjC, Tf1, TeV, Tf0;
				   TgE = TeM - TeP;
				   TeQ = TeM + TeP;
				   TjB = Tjm - Tjl;
				   Tjn = Tjl + Tjm;
				   TgF = TeU - TeR;
				   TeV = TeR + TeU;
				   ii[WS(ios, 52)] = FNMS(KP923879532, Tje, Tjd);
				   ii[WS(ios, 20)] = FMA(KP923879532, Tje, Tjd);
				   Tf0 = TeW - TeZ;
				   TgG = TeW + TeZ;
				   TjC = Tf0 - TeV;
				   Tf1 = TeV + Tf0;
				   {
					E Tfi, Tgp, Tfd, Tfn;
					{
					     E Tf7, Tjo, TgH, Tfc;
					     TgJ = Tf5 - Tf6;
					     Tf7 = Tf5 + Tf6;
					     TjD = FMA(KP707106781, TjC, TjB);
					     TjJ = FNMS(KP707106781, TjC, TjB);
					     Tgo = FMA(KP707106781, Tf1, TeQ);
					     Tf2 = FNMS(KP707106781, Tf1, TeQ);
					     Tjo = TgF + TgG;
					     TgH = TgF - TgG;
					     Tfc = Tf8 + Tfb;
					     TgK = Tf8 - Tfb;
					     TgM = Tfg - Tfh;
					     Tfi = Tfg + Tfh;
					     Tjp = FMA(KP707106781, Tjo, Tjn);
					     Tjv = FNMS(KP707106781, Tjo, Tjn);
					     Tha = FNMS(KP707106781, TgH, TgE);
					     TgI = FMA(KP707106781, TgH, TgE);
					     Tgp = FMA(KP414213562, Tf7, Tfc);
					     Tfd = FNMS(KP414213562, Tfc, Tf7);
					     Tfn = Tfj + Tfm;
					     TgN = Tfj - Tfm;
					}
					{
					     E TgY, TgZ, Tgq, Tfo;
					     Tgd = Tg9 + Tgc;
					     TgY = Tg9 - Tgc;
					     TgZ = Tg6 - Tg1;
					     Tg7 = Tg1 + Tg6;
					     TfW = TfU + TfV;
					     Th1 = TfU - TfV;
					     Tgq = FNMS(KP414213562, Tfi, Tfn);
					     Tfo = FMA(KP414213562, Tfn, Tfi);
					     Thj = FMA(KP707106781, TgZ, TgY);
					     Th0 = FNMS(KP707106781, TgZ, TgY);
					     Tgr = Tgp + Tgq;
					     Tjw = Tgq - Tgp;
					     Tjq = Tfd + Tfo;
					     Tfp = Tfd - Tfo;
					     Th2 = Tge - Tgf;
					     Tgg = Tge + Tgf;
					}
				   }
			      }
			      {
				   E TgU, TgS, TgR, TgV, Thb, TgL;
				   {
					E TfM, Tgu, TfH, TfP, Tgt, TfQ;
					{
					     E Tfv, TfG, Thi, Th3;
					     TgU = Tft - Tfu;
					     Tfv = Tft + Tfu;
					     TfG = TfA + TfF;
					     TgS = TfF - TfA;
					     TgR = TfI - TfL;
					     TfM = TfI + TfL;
					     Thi = FMA(KP707106781, Th2, Th1);
					     Th3 = FNMS(KP707106781, Th2, Th1);
					     Tgu = FMA(KP707106781, TfG, Tfv);
					     TfH = FNMS(KP707106781, TfG, Tfv);
					     Thk = FNMS(KP198912367, Thj, Thi);
					     Tho = FMA(KP198912367, Thi, Thj);
					     Th8 = FMA(KP668178637, Th0, Th3);
					     Th4 = FNMS(KP668178637, Th3, Th0);
					     TfP = TfN + TfO;
					     TgV = TfN - TfO;
					}
					Tgt = FMA(KP707106781, TfP, TfM);
					TfQ = FNMS(KP707106781, TfP, TfM);
					Thb = FNMS(KP414213562, TgJ, TgK);
					TgL = FMA(KP414213562, TgK, TgJ);
					Tgv = FMA(KP198912367, Tgu, Tgt);
					TgB = FNMS(KP198912367, Tgt, Tgu);
					Tgl = FNMS(KP668178637, TfH, TfQ);
					TfR = FMA(KP668178637, TfQ, TfH);
				   }
				   {
					E Thg, TgT, Thc, TgO, Thf, TgW;
					Thc = FMA(KP414213562, TgM, TgN);
					TgO = FNMS(KP414213562, TgN, TgM);
					Thg = FMA(KP707106781, TgS, TgR);
					TgT = FNMS(KP707106781, TgS, TgR);
					TjE = Thc - Thb;
					Thd = Thb + Thc;
					TjK = TgL + TgO;
					TgP = TgL - TgO;
					Thf = FMA(KP707106781, TgV, TgU);
					TgW = FNMS(KP707106781, TgV, TgU);
					Tgx = FMA(KP707106781, Tg7, TfW);
					Tg8 = FNMS(KP707106781, Tg7, TfW);
					Thh = FMA(KP198912367, Thg, Thf);
					Thn = FNMS(KP198912367, Thf, Thg);
					Th7 = FNMS(KP668178637, TgT, TgW);
					TgX = FMA(KP668178637, TgW, TgT);
				   }
			      }
			 }
			 {
			      E Tju, Tjt, TjI, TjH;
			      {
				   E Tgk, Tfq, Tjx, Tjz, Tgw, Tgh;
				   Tgk = FNMS(KP923879532, Tfp, Tf2);
				   Tfq = FMA(KP923879532, Tfp, Tf2);
				   Tjx = FMA(KP923879532, Tjw, Tjv);
				   Tjz = FNMS(KP923879532, Tjw, Tjv);
				   Tgw = FMA(KP707106781, Tgg, Tgd);
				   Tgh = FNMS(KP707106781, Tgg, Tgd);
				   {
					E TgA, Tjr, Tjs, TgD;
					{
					     E Tgs, TgC, Tgm, Tgi, Tgz, Tgy;
					     TgA = FNMS(KP923879532, Tgr, Tgo);
					     Tgs = FMA(KP923879532, Tgr, Tgo);
					     Tgy = FNMS(KP198912367, Tgx, Tgw);
					     TgC = FMA(KP198912367, Tgw, Tgx);
					     Tgm = FMA(KP668178637, Tg8, Tgh);
					     Tgi = FNMS(KP668178637, Tgh, Tg8);
					     Tgz = Tgv + Tgy;
					     Tju = Tgy - Tgv;
					     Tjt = FNMS(KP923879532, Tjq, Tjp);
					     Tjr = FMA(KP923879532, Tjq, Tjp);
					     {
						  E Tgn, Tjy, TjA, Tgj;
						  Tgn = Tgl + Tgm;
						  Tjy = Tgm - Tgl;
						  TjA = TfR + Tgi;
						  Tgj = TfR - Tgi;
						  ri[WS(ios, 2)] = FMA(KP980785280, Tgz, Tgs);
						  ri[WS(ios, 34)] = FNMS(KP980785280, Tgz, Tgs);
						  ri[WS(ios, 58)] = FMA(KP831469612, Tgn, Tgk);
						  ri[WS(ios, 26)] = FNMS(KP831469612, Tgn, Tgk);
						  ii[WS(ios, 42)] = FNMS(KP831469612, Tjy, Tjx);
						  ii[WS(ios, 10)] = FMA(KP831469612, Tjy, Tjx);
						  ii[WS(ios, 58)] = FMA(KP831469612, TjA, Tjz);
						  ii[WS(ios, 26)] = FNMS(KP831469612, TjA, Tjz);
						  ri[WS(ios, 10)] = FMA(KP831469612, Tgj, Tfq);
						  ri[WS(ios, 42)] = FNMS(KP831469612, Tgj, Tfq);
						  Tjs = TgB + TgC;
						  TgD = TgB - TgC;
					     }
					}
					ii[WS(ios, 34)] = FNMS(KP980785280, Tjs, Tjr);
					ii[WS(ios, 2)] = FMA(KP980785280, Tjs, Tjr);
					ri[WS(ios, 18)] = FMA(KP980785280, TgD, TgA);
					ri[WS(ios, 50)] = FNMS(KP980785280, TgD, TgA);
				   }
			      }
			      {
				   E Th6, TjF, TjG, Th9, TgQ, Th5;
				   Th6 = FNMS(KP923879532, TgP, TgI);
				   TgQ = FMA(KP923879532, TgP, TgI);
				   Th5 = TgX + Th4;
				   TjI = Th4 - TgX;
				   TjH = FNMS(KP923879532, TjE, TjD);
				   TjF = FMA(KP923879532, TjE, TjD);
				   ii[WS(ios, 50)] = FNMS(KP980785280, Tju, Tjt);
				   ii[WS(ios, 18)] = FMA(KP980785280, Tju, Tjt);
				   ri[WS(ios, 6)] = FMA(KP831469612, Th5, TgQ);
				   ri[WS(ios, 38)] = FNMS(KP831469612, Th5, TgQ);
				   TjG = Th7 + Th8;
				   Th9 = Th7 - Th8;
				   ii[WS(ios, 38)] = FNMS(KP831469612, TjG, TjF);
				   ii[WS(ios, 6)] = FMA(KP831469612, TjG, TjF);
				   ri[WS(ios, 22)] = FMA(KP831469612, Th9, Th6);
				   ri[WS(ios, 54)] = FNMS(KP831469612, Th9, Th6);
			      }
			      {
				   E Thm, TjL, TjM, Thp, The, Thl;
				   Thm = FMA(KP923879532, Thd, Tha);
				   The = FNMS(KP923879532, Thd, Tha);
				   Thl = Thh - Thk;
				   TjO = Thh + Thk;
				   TjN = FMA(KP923879532, TjK, TjJ);
				   TjL = FNMS(KP923879532, TjK, TjJ);
				   ii[WS(ios, 54)] = FNMS(KP831469612, TjI, TjH);
				   ii[WS(ios, 22)] = FMA(KP831469612, TjI, TjH);
				   ri[WS(ios, 14)] = FMA(KP980785280, Thl, The);
				   ri[WS(ios, 46)] = FNMS(KP980785280, Thl, The);
				   TjM = Tho - Thn;
				   Thp = Thn + Tho;
				   ii[WS(ios, 46)] = FNMS(KP980785280, TjM, TjL);
				   ii[WS(ios, 14)] = FMA(KP980785280, TjM, TjL);
				   ri[WS(ios, 62)] = FMA(KP980785280, Thp, Thm);
				   ri[WS(ios, 30)] = FNMS(KP980785280, Thp, Thm);
			      }
			 }
		    }
		    {
			 E TjS, TcD, Tcw, TkO, TkN, Tcz;
			 {
			      E TbB, Tkw, Tkq, T99, TbF, TbL, Tbv, Taj, Tcu, Tcy, Tci, Tce, Tcr, Tcx, Tch;
			      E Tc7, TkE, Tcn, TkK, TbZ, TbP, T7J, TbO, T7u, TkB, Tkn, TbI, TbM, Tbw, Tbs;
			      E T7Y, TbQ;
			      {
				   E TbT, TbU, TbW, TbX, Tc4, Tc2, Tc1, Tc5, Tbn, Tbb, TaG, Tcb, Tct, Tca, Tcc;
				   E Tbq, Tcl, TbV;
				   {
					E T8W, Tbz, T8z, T97, T8n, T8y;
					TbT = FMA(KP707106781, T8m, T87);
					T8n = FNMS(KP707106781, T8m, T87);
					T8y = FNMS(KP707106781, T8x, T8u);
					TbU = FMA(KP707106781, T8x, T8u);
					TbW = FMA(KP707106781, T8V, T8G);
					T8W = FNMS(KP707106781, T8V, T8G);
					ii[WS(ios, 62)] = FMA(KP980785280, TjO, TjN);
					ii[WS(ios, 30)] = FNMS(KP980785280, TjO, TjN);
					Tbz = FMA(KP668178637, T8n, T8y);
					T8z = FNMS(KP668178637, T8y, T8n);
					T97 = FNMS(KP707106781, T96, T93);
					TbX = FMA(KP707106781, T96, T93);
					{
					     E Tae, TbE, Ta3, Tah;
					     {
						  E T9x, Ta2, TbA, T98;
						  Tc4 = FMA(KP707106781, T9w, T9h);
						  T9x = FNMS(KP707106781, T9w, T9h);
						  Ta2 = T9M - Ta1;
						  Tc2 = Ta1 + T9M;
						  Tc1 = FMA(KP707106781, Tad, Taa);
						  Tae = FNMS(KP707106781, Tad, Taa);
						  TbA = FNMS(KP668178637, T8W, T97);
						  T98 = FMA(KP668178637, T97, T8W);
						  TbE = FMA(KP923879532, Ta2, T9x);
						  Ta3 = FNMS(KP923879532, Ta2, T9x);
						  TbB = Tbz + TbA;
						  Tkw = TbA - Tbz;
						  Tkq = T8z + T98;
						  T99 = T8z - T98;
						  Tah = Taf - Tag;
						  Tc5 = Taf + Tag;
					     }
					     {
						  E Tc8, Tc9, TbD, Tai;
						  Tbn = FNMS(KP707106781, Tbm, Tbj);
						  Tc8 = FMA(KP707106781, Tbm, Tbj);
						  Tc9 = Tba + TaV;
						  Tbb = TaV - Tba;
						  TaG = FNMS(KP707106781, TaF, Taq);
						  Tcb = FMA(KP707106781, TaF, Taq);
						  TbD = FMA(KP923879532, Tah, Tae);
						  Tai = FNMS(KP923879532, Tah, Tae);
						  Tct = FMA(KP923879532, Tc9, Tc8);
						  Tca = FNMS(KP923879532, Tc9, Tc8);
						  TbF = FMA(KP303346683, TbE, TbD);
						  TbL = FNMS(KP303346683, TbD, TbE);
						  Tbv = FNMS(KP534511135, Ta3, Tai);
						  Taj = FMA(KP534511135, Tai, Ta3);
						  Tcc = Tbo + Tbp;
						  Tbq = Tbo - Tbp;
					     }
					}
				   }
				   {
					E Tcq, Tc3, Tcs, Tcd, Tcp, Tc6;
					Tcs = FMA(KP923879532, Tcc, Tcb);
					Tcd = FNMS(KP923879532, Tcc, Tcb);
					Tcq = FMA(KP923879532, Tc2, Tc1);
					Tc3 = FNMS(KP923879532, Tc2, Tc1);
					Tcu = FNMS(KP098491403, Tct, Tcs);
					Tcy = FMA(KP098491403, Tcs, Tct);
					Tci = FMA(KP820678790, Tca, Tcd);
					Tce = FNMS(KP820678790, Tcd, Tca);
					Tcp = FMA(KP923879532, Tc5, Tc4);
					Tc6 = FNMS(KP923879532, Tc5, Tc4);
					Tcl = FNMS(KP198912367, TbT, TbU);
					TbV = FMA(KP198912367, TbU, TbT);
					Tcr = FMA(KP098491403, Tcq, Tcp);
					Tcx = FNMS(KP098491403, Tcp, Tcq);
					Tch = FNMS(KP820678790, Tc3, Tc6);
					Tc7 = FMA(KP820678790, Tc6, Tc3);
				   }
				   {
					E TbH, Tbc, Tcm, TbY;
					Tcm = FMA(KP198912367, TbW, TbX);
					TbY = FNMS(KP198912367, TbX, TbW);
					TbH = FMA(KP923879532, Tbb, TaG);
					Tbc = FNMS(KP923879532, Tbb, TaG);
					TkE = Tcm - Tcl;
					Tcn = Tcl + Tcm;
					TkK = TbV + TbY;
					TbZ = TbV - TbY;
					{
					     E T7t, Tkm, TbG, Tbr;
					     TjS = T7l + T7s;
					     T7t = T7l - T7s;
					     Tkm = TcC - TcB;
					     TcD = TcB + TcC;
					     TbP = FNMS(KP414213562, T7B, T7I);
					     T7J = FMA(KP414213562, T7I, T7B);
					     TbG = FMA(KP923879532, Tbq, Tbn);
					     Tbr = FNMS(KP923879532, Tbq, Tbn);
					     TbO = FNMS(KP707106781, T7t, T7e);
					     T7u = FMA(KP707106781, T7t, T7e);
					     TkB = FNMS(KP707106781, Tkm, Tkl);
					     Tkn = FMA(KP707106781, Tkm, Tkl);
					     TbI = FNMS(KP303346683, TbH, TbG);
					     TbM = FMA(KP303346683, TbG, TbH);
					     Tbw = FMA(KP534511135, Tbc, Tbr);
					     Tbs = FNMS(KP534511135, Tbr, Tbc);
					     T7Y = FNMS(KP414213562, T7X, T7Q);
					     TbQ = FMA(KP414213562, T7Q, T7X);
					}
				   }
			      }
			      {
				   E TkJ, TkD, Tck, TbS, TbK, Tku, Tkt, TbN;
				   {
					E TkA, Tby, Tkp, Tbu, Tkz, Tbx;
					{
					     E Tbt, T9a, Tkx, Tky, Tkv;
					     TkA = Taj + Tbs;
					     Tbt = Taj - Tbs;
					     {
						  E TkC, T7Z, Tko, TbR, T80;
						  TkC = T7J + T7Y;
						  T7Z = T7J - T7Y;
						  Tko = TbQ - TbP;
						  TbR = TbP + TbQ;
						  TkJ = FMA(KP923879532, TkC, TkB);
						  TkD = FNMS(KP923879532, TkC, TkB);
						  Tby = FMA(KP923879532, T7Z, T7u);
						  T80 = FNMS(KP923879532, T7Z, T7u);
						  Tkv = FNMS(KP923879532, Tko, Tkn);
						  Tkp = FMA(KP923879532, Tko, Tkn);
						  Tck = FMA(KP923879532, TbR, TbO);
						  TbS = FNMS(KP923879532, TbR, TbO);
						  T9a = FMA(KP831469612, T99, T80);
						  Tbu = FNMS(KP831469612, T99, T80);
					     }
					     Tkz = FNMS(KP831469612, Tkw, Tkv);
					     Tkx = FMA(KP831469612, Tkw, Tkv);
					     Tky = Tbw - Tbv;
					     Tbx = Tbv + Tbw;
					     ri[WS(ios, 11)] = FMA(KP881921264, Tbt, T9a);
					     ri[WS(ios, 43)] = FNMS(KP881921264, Tbt, T9a);
					     ii[WS(ios, 43)] = FNMS(KP881921264, Tky, Tkx);
					     ii[WS(ios, 11)] = FMA(KP881921264, Tky, Tkx);
					}
					{
					     E TbC, TbJ, Tkr, Tks;
					     TbK = FNMS(KP831469612, TbB, Tby);
					     TbC = FMA(KP831469612, TbB, Tby);
					     ri[WS(ios, 59)] = FMA(KP881921264, Tbx, Tbu);
					     ri[WS(ios, 27)] = FNMS(KP881921264, Tbx, Tbu);
					     ii[WS(ios, 59)] = FMA(KP881921264, TkA, Tkz);
					     ii[WS(ios, 27)] = FNMS(KP881921264, TkA, Tkz);
					     TbJ = TbF + TbI;
					     Tku = TbI - TbF;
					     Tkt = FNMS(KP831469612, Tkq, Tkp);
					     Tkr = FMA(KP831469612, Tkq, Tkp);
					     Tks = TbL + TbM;
					     TbN = TbL - TbM;
					     ri[WS(ios, 3)] = FMA(KP956940335, TbJ, TbC);
					     ri[WS(ios, 35)] = FNMS(KP956940335, TbJ, TbC);
					     ii[WS(ios, 35)] = FNMS(KP956940335, Tks, Tkr);
					     ii[WS(ios, 3)] = FMA(KP956940335, Tks, Tkr);
					}
				   }
				   {
					E Tcg, TkI, TkH, Tcj;
					{
					     E Tc0, Tcf, TkF, TkG;
					     Tcg = FNMS(KP980785280, TbZ, TbS);
					     Tc0 = FMA(KP980785280, TbZ, TbS);
					     ri[WS(ios, 19)] = FMA(KP956940335, TbN, TbK);
					     ri[WS(ios, 51)] = FNMS(KP956940335, TbN, TbK);
					     ii[WS(ios, 51)] = FNMS(KP956940335, Tku, Tkt);
					     ii[WS(ios, 19)] = FMA(KP956940335, Tku, Tkt);
					     Tcf = Tc7 + Tce;
					     TkI = Tce - Tc7;
					     TkH = FNMS(KP980785280, TkE, TkD);
					     TkF = FMA(KP980785280, TkE, TkD);
					     TkG = Tch + Tci;
					     Tcj = Tch - Tci;
					     ri[WS(ios, 7)] = FMA(KP773010453, Tcf, Tc0);
					     ri[WS(ios, 39)] = FNMS(KP773010453, Tcf, Tc0);
					     ii[WS(ios, 39)] = FNMS(KP773010453, TkG, TkF);
					     ii[WS(ios, 7)] = FMA(KP773010453, TkG, TkF);
					}
					{
					     E Tco, Tcv, TkL, TkM;
					     Tcw = FMA(KP980785280, Tcn, Tck);
					     Tco = FNMS(KP980785280, Tcn, Tck);
					     ri[WS(ios, 23)] = FMA(KP773010453, Tcj, Tcg);
					     ri[WS(ios, 55)] = FNMS(KP773010453, Tcj, Tcg);
					     ii[WS(ios, 55)] = FNMS(KP773010453, TkI, TkH);
					     ii[WS(ios, 23)] = FMA(KP773010453, TkI, TkH);
					     Tcv = Tcr - Tcu;
					     TkO = Tcr + Tcu;
					     TkN = FMA(KP980785280, TkK, TkJ);
					     TkL = FNMS(KP980785280, TkK, TkJ);
					     TkM = Tcy - Tcx;
					     Tcz = Tcx + Tcy;
					     ri[WS(ios, 15)] = FMA(KP995184726, Tcv, Tco);
					     ri[WS(ios, 47)] = FNMS(KP995184726, Tcv, Tco);
					     ii[WS(ios, 47)] = FNMS(KP995184726, TkM, TkL);
					     ii[WS(ios, 15)] = FMA(KP995184726, TkM, TkL);
					}
				   }
			      }
			 }
			 {
			      E TdN, Tk2, TjW, Td1, TdR, TdX, TdH, Tdl, TeG, TeK, Teu, Teq, TeD, TeJ, Tet;
			      E Tej, Tka, Tez, Tkg, Teb, Te1, TcH, Te0, TcE, Tk7, TjT, TdU, TdY, TdI, TdE;
			      E TcK, Te2;
			      {
				   E Te5, Te6, Te8, Te9, Teg, Tee, Ted, Teh, Tdz, Tdv, Tdo, Ten, TeF, Tem, Teo;
				   E TdC, Tex, Te7;
				   {
					E TcP, TcS, TcW, TcZ;
					Te5 = FNMS(KP707106781, TcO, TcN);
					TcP = FMA(KP707106781, TcO, TcN);
					ri[WS(ios, 63)] = FMA(KP995184726, Tcz, Tcw);
					ri[WS(ios, 31)] = FNMS(KP995184726, Tcz, Tcw);
					ii[WS(ios, 63)] = FMA(KP995184726, TkO, TkN);
					ii[WS(ios, 31)] = FNMS(KP995184726, TkO, TkN);
					TcS = FMA(KP707106781, TcR, TcQ);
					Te6 = FNMS(KP707106781, TcR, TcQ);
					Te8 = FNMS(KP707106781, TcV, TcU);
					TcW = FMA(KP707106781, TcV, TcU);
					TcZ = FMA(KP707106781, TcY, TcX);
					Te9 = FNMS(KP707106781, TcY, TcX);
					{
					     E Tdg, TdQ, Tdd, Tdj;
					     {
						  E Td5, TdL, TcT, TdM, Td0, Tdc;
						  Teg = FNMS(KP707106781, Td4, Td3);
						  Td5 = FMA(KP707106781, Td4, Td3);
						  TdL = FMA(KP198912367, TcP, TcS);
						  TcT = FNMS(KP198912367, TcS, TcP);
						  TdM = FNMS(KP198912367, TcW, TcZ);
						  Td0 = FMA(KP198912367, TcZ, TcW);
						  Tdc = Td8 + Tdb;
						  Tee = Tdb - Td8;
						  Ted = FNMS(KP707106781, Tdf, Tde);
						  Tdg = FMA(KP707106781, Tdf, Tde);
						  TdN = TdL + TdM;
						  Tk2 = TdM - TdL;
						  TjW = TcT + Td0;
						  Td1 = TcT - Td0;
						  TdQ = FMA(KP923879532, Tdc, Td5);
						  Tdd = FNMS(KP923879532, Tdc, Td5);
						  Tdj = Tdh + Tdi;
						  Teh = Tdh - Tdi;
					     }
					     {
						  E Tek, Tel, TdP, Tdk;
						  Tdz = FMA(KP707106781, Tdy, Tdx);
						  Tek = FNMS(KP707106781, Tdy, Tdx);
						  Tel = Tdu - Tdr;
						  Tdv = Tdr + Tdu;
						  Tdo = FMA(KP707106781, Tdn, Tdm);
						  Ten = FNMS(KP707106781, Tdn, Tdm);
						  TdP = FMA(KP923879532, Tdj, Tdg);
						  Tdk = FNMS(KP923879532, Tdj, Tdg);
						  TeF = FMA(KP923879532, Tel, Tek);
						  Tem = FNMS(KP923879532, Tel, Tek);
						  TdR = FMA(KP098491403, TdQ, TdP);
						  TdX = FNMS(KP098491403, TdP, TdQ);
						  TdH = FNMS(KP820678790, Tdd, Tdk);
						  Tdl = FMA(KP820678790, Tdk, Tdd);
						  Teo = TdA - TdB;
						  TdC = TdA + TdB;
					     }
					}
				   }
				   {
					E TeC, Tef, TeE, Tep, TeB, Tei;
					TeE = FMA(KP923879532, Teo, Ten);
					Tep = FNMS(KP923879532, Teo, Ten);
					TeC = FMA(KP923879532, Tee, Ted);
					Tef = FNMS(KP923879532, Tee, Ted);
					TeG = FNMS(KP303346683, TeF, TeE);
					TeK = FMA(KP303346683, TeE, TeF);
					Teu = FMA(KP534511135, Tem, Tep);
					Teq = FNMS(KP534511135, Tep, Tem);
					TeB = FMA(KP923879532, Teh, Teg);
					Tei = FNMS(KP923879532, Teh, Teg);
					Tex = FNMS(KP668178637, Te5, Te6);
					Te7 = FMA(KP668178637, Te6, Te5);
					TeD = FMA(KP303346683, TeC, TeB);
					TeJ = FNMS(KP303346683, TeB, TeC);
					Tet = FNMS(KP534511135, Tef, Tei);
					Tej = FMA(KP534511135, Tei, Tef);
				   }
				   {
					E TdT, Tdw, Tey, Tea, TdS, TdD;
					Tey = FMA(KP668178637, Te8, Te9);
					Tea = FNMS(KP668178637, Te9, Te8);
					TdT = FMA(KP923879532, Tdv, Tdo);
					Tdw = FNMS(KP923879532, Tdv, Tdo);
					Tka = Tey - Tex;
					Tez = Tex + Tey;
					Tkg = Te7 + Tea;
					Teb = Te7 - Tea;
					Te1 = FNMS(KP414213562, TcF, TcG);
					TcH = FMA(KP414213562, TcG, TcF);
					TdS = FMA(KP923879532, TdC, Tdz);
					TdD = FNMS(KP923879532, TdC, Tdz);
					Te0 = FNMS(KP707106781, TcD, TcA);
					TcE = FMA(KP707106781, TcD, TcA);
					Tk7 = FNMS(KP707106781, TjS, TjR);
					TjT = FMA(KP707106781, TjS, TjR);
					TdU = FNMS(KP098491403, TdT, TdS);
					TdY = FMA(KP098491403, TdS, TdT);
					TdI = FMA(KP820678790, Tdw, TdD);
					TdE = FNMS(KP820678790, TdD, Tdw);
					TcK = FNMS(KP414213562, TcJ, TcI);
					Te2 = FMA(KP414213562, TcI, TcJ);
				   }
			      }
			      {
				   E Tkf, Tk9, Tew, Te4, TdW, Tk0, TjZ, TdZ;
				   {
					E Tk6, TdK, TjV, TdG, Tk5, TdJ;
					{
					     E TdF, Td2, Tk3, Tk4, Tk1;
					     Tk6 = Tdl + TdE;
					     TdF = Tdl - TdE;
					     {
						  E Tk8, TcL, TjU, Te3, TcM;
						  Tk8 = TcK - TcH;
						  TcL = TcH + TcK;
						  TjU = Te1 + Te2;
						  Te3 = Te1 - Te2;
						  Tkf = FNMS(KP923879532, Tk8, Tk7);
						  Tk9 = FMA(KP923879532, Tk8, Tk7);
						  TdK = FMA(KP923879532, TcL, TcE);
						  TcM = FNMS(KP923879532, TcL, TcE);
						  Tk1 = FNMS(KP923879532, TjU, TjT);
						  TjV = FMA(KP923879532, TjU, TjT);
						  Tew = FNMS(KP923879532, Te3, Te0);
						  Te4 = FMA(KP923879532, Te3, Te0);
						  Td2 = FMA(KP980785280, Td1, TcM);
						  TdG = FNMS(KP980785280, Td1, TcM);
					     }
					     Tk5 = FNMS(KP980785280, Tk2, Tk1);
					     Tk3 = FMA(KP980785280, Tk2, Tk1);
					     Tk4 = TdI - TdH;
					     TdJ = TdH + TdI;
					     ri[WS(ios, 9)] = FMA(KP773010453, TdF, Td2);
					     ri[WS(ios, 41)] = FNMS(KP773010453, TdF, Td2);
					     ii[WS(ios, 41)] = FNMS(KP773010453, Tk4, Tk3);
					     ii[WS(ios, 9)] = FMA(KP773010453, Tk4, Tk3);
					}
					{
					     E TdO, TdV, TjX, TjY;
					     TdW = FNMS(KP980785280, TdN, TdK);
					     TdO = FMA(KP980785280, TdN, TdK);
					     ri[WS(ios, 57)] = FMA(KP773010453, TdJ, TdG);
					     ri[WS(ios, 25)] = FNMS(KP773010453, TdJ, TdG);
					     ii[WS(ios, 57)] = FMA(KP773010453, Tk6, Tk5);
					     ii[WS(ios, 25)] = FNMS(KP773010453, Tk6, Tk5);
					     TdV = TdR + TdU;
					     Tk0 = TdU - TdR;
					     TjZ = FNMS(KP980785280, TjW, TjV);
					     TjX = FMA(KP980785280, TjW, TjV);
					     TjY = TdX + TdY;
					     TdZ = TdX - TdY;
					     ri[WS(ios, 1)] = FMA(KP995184726, TdV, TdO);
					     ri[WS(ios, 33)] = FNMS(KP995184726, TdV, TdO);
					     ii[WS(ios, 33)] = FNMS(KP995184726, TjY, TjX);
					     ii[WS(ios, 1)] = FMA(KP995184726, TjY, TjX);
					}
				   }
				   {
					E Tes, Tke, Tkd, Tev;
					{
					     E Tec, Ter, Tkb, Tkc;
					     Tes = FNMS(KP831469612, Teb, Te4);
					     Tec = FMA(KP831469612, Teb, Te4);
					     ri[WS(ios, 17)] = FMA(KP995184726, TdZ, TdW);
					     ri[WS(ios, 49)] = FNMS(KP995184726, TdZ, TdW);
					     ii[WS(ios, 49)] = FNMS(KP995184726, Tk0, TjZ);
					     ii[WS(ios, 17)] = FMA(KP995184726, Tk0, TjZ);
					     Ter = Tej + Teq;
					     Tke = Teq - Tej;
					     Tkd = FNMS(KP831469612, Tka, Tk9);
					     Tkb = FMA(KP831469612, Tka, Tk9);
					     Tkc = Tet + Teu;
					     Tev = Tet - Teu;
					     ri[WS(ios, 5)] = FMA(KP881921264, Ter, Tec);
					     ri[WS(ios, 37)] = FNMS(KP881921264, Ter, Tec);
					     ii[WS(ios, 37)] = FNMS(KP881921264, Tkc, Tkb);
					     ii[WS(ios, 5)] = FMA(KP881921264, Tkc, Tkb);
					}
					{
					     E TeA, TeH, Tkh, Tki;
					     TeI = FMA(KP831469612, Tez, Tew);
					     TeA = FNMS(KP831469612, Tez, Tew);
					     ri[WS(ios, 21)] = FMA(KP881921264, Tev, Tes);
					     ri[WS(ios, 53)] = FNMS(KP881921264, Tev, Tes);
					     ii[WS(ios, 53)] = FNMS(KP881921264, Tke, Tkd);
					     ii[WS(ios, 21)] = FMA(KP881921264, Tke, Tkd);
					     TeH = TeD - TeG;
					     Tkk = TeD + TeG;
					     Tkj = FMA(KP831469612, Tkg, Tkf);
					     Tkh = FNMS(KP831469612, Tkg, Tkf);
					     Tki = TeK - TeJ;
					     TeL = TeJ + TeK;
					     ri[WS(ios, 13)] = FMA(KP956940335, TeH, TeA);
					     ri[WS(ios, 45)] = FNMS(KP956940335, TeH, TeA);
					     ii[WS(ios, 45)] = FNMS(KP956940335, Tki, Tkh);
					     ii[WS(ios, 13)] = FMA(KP956940335, Tki, Tkh);
					}
				   }
			      }
			 }
		    }
	       }
	  }
	  ri[WS(ios, 61)] = FMA(KP956940335, TeL, TeI);
	  ri[WS(ios, 29)] = FNMS(KP956940335, TeL, TeI);
	  ii[WS(ios, 61)] = FMA(KP956940335, Tkk, Tkj);
	  ii[WS(ios, 29)] = FNMS(KP956940335, Tkk, Tkj);
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_FULL, 0, 64},
     {TW_NEXT, 1, 0}
};

static const ct_desc desc = { 64, "t1_64", twinstr, &GENUS, {520, 126, 518, 0}, 0, 0, 0 };

void X(codelet_t1_64) (planner *p) {
     X(kdft_dit_register) (p, t1_64, &desc);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_twiddle -compact -variables 4 -pipeline-latency 4 -n 64 -name t1_64 -include t.h */

/*
 * This function contains 1038 FP additions, 500 FP multiplications,
 * (or, 808 additions, 270 multiplications, 230 fused multiply/add),
 * 176 stack variables, and 256 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_twiddle.ml,v 1.24 2006-02-12 23:34:12 athena Exp $
 */

#include "t.h"

static const R *t1_64(R *ri, R *ii, const R *W, stride ios, INT m, INT dist)
{
     DK(KP471396736, +0.471396736825997648556387625905254377657460319);
     DK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DK(KP290284677, +0.290284677254462367636192375817395274691476278);
     DK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DK(KP634393284, +0.634393284163645498215171613225493370675687095);
     DK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DK(KP098017140, +0.098017140329560601994195563888641845861136673);
     DK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     INT i;
     for (i = m; i > 0; i = i - 1, ri = ri + dist, ii = ii + dist, W = W + 126, MAKE_VOLATILE_STRIDE(ios)) {
	  E Tj, TcL, ThT, Tin, T6b, Taz, TgT, Thn, TG, Thm, TcO, TgO, T6m, ThQ, TaC;
	  E Tim, T14, Tfq, T6y, T9O, TaG, Tc0, TcU, TeE, T1r, Tfr, T6J, T9P, TaJ, Tc1;
	  E TcZ, TeF, T1Q, T2d, Tfx, Tfu, Tfv, Tfw, T6Q, TaM, Tdb, TeJ, T71, TaQ, T7a;
	  E TaN, Td6, TeI, T77, TaP, T2B, T2Y, Tfz, TfA, TfB, TfC, T7h, TaW, Tdm, TeM;
	  E T7s, TaU, T7B, TaX, Tdh, TeL, T7y, TaT, T5j, TfR, Tec, Tf0, TfY, Tgy, T8D;
	  E Tbl, T8O, Tbx, T9l, Tbm, TdV, TeX, T9i, Tbw, T3M, TfL, TdL, TeQ, TfI, Tgt;
	  E T7K, Tb2, T7V, Tbe, T8s, Tb3, Tdu, TeT, T8p, Tbd, T4x, TfJ, TdE, TdM, TfO;
	  E Tgu, T87, T8v, T8i, T8u, Tba, Tbg, Tdz, TdN, Tb7, Tbh, T64, TfZ, Te5, Ted;
	  E TfU, Tgz, T90, T9o, T9b, T9n, Tbt, Tbz, Te0, Tee, Tbq, TbA;
	  {
	       E T1, TgR, T6, TgQ, Tc, T68, Th, T69;
	       T1 = ri[0];
	       TgR = ii[0];
	       {
		    E T3, T5, T2, T4;
		    T3 = ri[WS(ios, 32)];
		    T5 = ii[WS(ios, 32)];
		    T2 = W[62];
		    T4 = W[63];
		    T6 = FMA(T2, T3, T4 * T5);
		    TgQ = FNMS(T4, T3, T2 * T5);
	       }
	       {
		    E T9, Tb, T8, Ta;
		    T9 = ri[WS(ios, 16)];
		    Tb = ii[WS(ios, 16)];
		    T8 = W[30];
		    Ta = W[31];
		    Tc = FMA(T8, T9, Ta * Tb);
		    T68 = FNMS(Ta, T9, T8 * Tb);
	       }
	       {
		    E Te, Tg, Td, Tf;
		    Te = ri[WS(ios, 48)];
		    Tg = ii[WS(ios, 48)];
		    Td = W[94];
		    Tf = W[95];
		    Th = FMA(Td, Te, Tf * Tg);
		    T69 = FNMS(Tf, Te, Td * Tg);
	       }
	       {
		    E T7, Ti, ThR, ThS;
		    T7 = T1 + T6;
		    Ti = Tc + Th;
		    Tj = T7 + Ti;
		    TcL = T7 - Ti;
		    ThR = TgR - TgQ;
		    ThS = Tc - Th;
		    ThT = ThR - ThS;
		    Tin = ThS + ThR;
	       }
	       {
		    E T67, T6a, TgP, TgS;
		    T67 = T1 - T6;
		    T6a = T68 - T69;
		    T6b = T67 - T6a;
		    Taz = T67 + T6a;
		    TgP = T68 + T69;
		    TgS = TgQ + TgR;
		    TgT = TgP + TgS;
		    Thn = TgS - TgP;
	       }
	  }
	  {
	       E To, T6c, Tt, T6d, T6e, T6f, Tz, T6i, TE, T6j, T6h, T6k;
	       {
		    E Tl, Tn, Tk, Tm;
		    Tl = ri[WS(ios, 8)];
		    Tn = ii[WS(ios, 8)];
		    Tk = W[14];
		    Tm = W[15];
		    To = FMA(Tk, Tl, Tm * Tn);
		    T6c = FNMS(Tm, Tl, Tk * Tn);
	       }
	       {
		    E Tq, Ts, Tp, Tr;
		    Tq = ri[WS(ios, 40)];
		    Ts = ii[WS(ios, 40)];
		    Tp = W[78];
		    Tr = W[79];
		    Tt = FMA(Tp, Tq, Tr * Ts);
		    T6d = FNMS(Tr, Tq, Tp * Ts);
	       }
	       T6e = T6c - T6d;
	       T6f = To - Tt;
	       {
		    E Tw, Ty, Tv, Tx;
		    Tw = ri[WS(ios, 56)];
		    Ty = ii[WS(ios, 56)];
		    Tv = W[110];
		    Tx = W[111];
		    Tz = FMA(Tv, Tw, Tx * Ty);
		    T6i = FNMS(Tx, Tw, Tv * Ty);
	       }
	       {
		    E TB, TD, TA, TC;
		    TB = ri[WS(ios, 24)];
		    TD = ii[WS(ios, 24)];
		    TA = W[46];
		    TC = W[47];
		    TE = FMA(TA, TB, TC * TD);
		    T6j = FNMS(TC, TB, TA * TD);
	       }
	       T6h = Tz - TE;
	       T6k = T6i - T6j;
	       {
		    E Tu, TF, TcM, TcN;
		    Tu = To + Tt;
		    TF = Tz + TE;
		    TG = Tu + TF;
		    Thm = TF - Tu;
		    TcM = T6c + T6d;
		    TcN = T6i + T6j;
		    TcO = TcM - TcN;
		    TgO = TcM + TcN;
	       }
	       {
		    E T6g, T6l, TaA, TaB;
		    T6g = T6e - T6f;
		    T6l = T6h + T6k;
		    T6m = KP707106781 * (T6g - T6l);
		    ThQ = KP707106781 * (T6g + T6l);
		    TaA = T6f + T6e;
		    TaB = T6h - T6k;
		    TaC = KP707106781 * (TaA + TaB);
		    Tim = KP707106781 * (TaB - TaA);
	       }
	  }
	  {
	       E TS, TcQ, T6q, T6t, T13, TcR, T6r, T6w, T6s, T6x;
	       {
		    E TM, T6o, TR, T6p;
		    {
			 E TJ, TL, TI, TK;
			 TJ = ri[WS(ios, 4)];
			 TL = ii[WS(ios, 4)];
			 TI = W[6];
			 TK = W[7];
			 TM = FMA(TI, TJ, TK * TL);
			 T6o = FNMS(TK, TJ, TI * TL);
		    }
		    {
			 E TO, TQ, TN, TP;
			 TO = ri[WS(ios, 36)];
			 TQ = ii[WS(ios, 36)];
			 TN = W[70];
			 TP = W[71];
			 TR = FMA(TN, TO, TP * TQ);
			 T6p = FNMS(TP, TO, TN * TQ);
		    }
		    TS = TM + TR;
		    TcQ = T6o + T6p;
		    T6q = T6o - T6p;
		    T6t = TM - TR;
	       }
	       {
		    E TX, T6u, T12, T6v;
		    {
			 E TU, TW, TT, TV;
			 TU = ri[WS(ios, 20)];
			 TW = ii[WS(ios, 20)];
			 TT = W[38];
			 TV = W[39];
			 TX = FMA(TT, TU, TV * TW);
			 T6u = FNMS(TV, TU, TT * TW);
		    }
		    {
			 E TZ, T11, TY, T10;
			 TZ = ri[WS(ios, 52)];
			 T11 = ii[WS(ios, 52)];
			 TY = W[102];
			 T10 = W[103];
			 T12 = FMA(TY, TZ, T10 * T11);
			 T6v = FNMS(T10, TZ, TY * T11);
		    }
		    T13 = TX + T12;
		    TcR = T6u + T6v;
		    T6r = TX - T12;
		    T6w = T6u - T6v;
	       }
	       T14 = TS + T13;
	       Tfq = TcQ + TcR;
	       T6s = T6q + T6r;
	       T6x = T6t - T6w;
	       T6y = FNMS(KP923879532, T6x, KP382683432 * T6s);
	       T9O = FMA(KP923879532, T6s, KP382683432 * T6x);
	       {
		    E TaE, TaF, TcS, TcT;
		    TaE = T6q - T6r;
		    TaF = T6t + T6w;
		    TaG = FNMS(KP382683432, TaF, KP923879532 * TaE);
		    Tc0 = FMA(KP382683432, TaE, KP923879532 * TaF);
		    TcS = TcQ - TcR;
		    TcT = TS - T13;
		    TcU = TcS - TcT;
		    TeE = TcT + TcS;
	       }
	  }
	  {
	       E T1f, TcW, T6B, T6E, T1q, TcX, T6C, T6H, T6D, T6I;
	       {
		    E T19, T6z, T1e, T6A;
		    {
			 E T16, T18, T15, T17;
			 T16 = ri[WS(ios, 60)];
			 T18 = ii[WS(ios, 60)];
			 T15 = W[118];
			 T17 = W[119];
			 T19 = FMA(T15, T16, T17 * T18);
			 T6z = FNMS(T17, T16, T15 * T18);
		    }
		    {
			 E T1b, T1d, T1a, T1c;
			 T1b = ri[WS(ios, 28)];
			 T1d = ii[WS(ios, 28)];
			 T1a = W[54];
			 T1c = W[55];
			 T1e = FMA(T1a, T1b, T1c * T1d);
			 T6A = FNMS(T1c, T1b, T1a * T1d);
		    }
		    T1f = T19 + T1e;
		    TcW = T6z + T6A;
		    T6B = T6z - T6A;
		    T6E = T19 - T1e;
	       }
	       {
		    E T1k, T6F, T1p, T6G;
		    {
			 E T1h, T1j, T1g, T1i;
			 T1h = ri[WS(ios, 12)];
			 T1j = ii[WS(ios, 12)];
			 T1g = W[22];
			 T1i = W[23];
			 T1k = FMA(T1g, T1h, T1i * T1j);
			 T6F = FNMS(T1i, T1h, T1g * T1j);
		    }
		    {
			 E T1m, T1o, T1l, T1n;
			 T1m = ri[WS(ios, 44)];
			 T1o = ii[WS(ios, 44)];
			 T1l = W[86];
			 T1n = W[87];
			 T1p = FMA(T1l, T1m, T1n * T1o);
			 T6G = FNMS(T1n, T1m, T1l * T1o);
		    }
		    T1q = T1k + T1p;
		    TcX = T6F + T6G;
		    T6C = T1k - T1p;
		    T6H = T6F - T6G;
	       }
	       T1r = T1f + T1q;
	       Tfr = TcW + TcX;
	       T6D = T6B + T6C;
	       T6I = T6E - T6H;
	       T6J = FMA(KP382683432, T6D, KP923879532 * T6I);
	       T9P = FNMS(KP923879532, T6D, KP382683432 * T6I);
	       {
		    E TaH, TaI, TcV, TcY;
		    TaH = T6B - T6C;
		    TaI = T6E + T6H;
		    TaJ = FMA(KP923879532, TaH, KP382683432 * TaI);
		    Tc1 = FNMS(KP382683432, TaH, KP923879532 * TaI);
		    TcV = T1f - T1q;
		    TcY = TcW - TcX;
		    TcZ = TcV + TcY;
		    TeF = TcV - TcY;
	       }
	  }
	  {
	       E T1y, T6M, T1D, T6N, T1E, Td2, T1J, T74, T1O, T75, T1P, Td3, T21, Td8, T6W;
	       E T6Z, T2c, Td9, T6R, T6U;
	       {
		    E T1v, T1x, T1u, T1w;
		    T1v = ri[WS(ios, 2)];
		    T1x = ii[WS(ios, 2)];
		    T1u = W[2];
		    T1w = W[3];
		    T1y = FMA(T1u, T1v, T1w * T1x);
		    T6M = FNMS(T1w, T1v, T1u * T1x);
	       }
	       {
		    E T1A, T1C, T1z, T1B;
		    T1A = ri[WS(ios, 34)];
		    T1C = ii[WS(ios, 34)];
		    T1z = W[66];
		    T1B = W[67];
		    T1D = FMA(T1z, T1A, T1B * T1C);
		    T6N = FNMS(T1B, T1A, T1z * T1C);
	       }
	       T1E = T1y + T1D;
	       Td2 = T6M + T6N;
	       {
		    E T1G, T1I, T1F, T1H;
		    T1G = ri[WS(ios, 18)];
		    T1I = ii[WS(ios, 18)];
		    T1F = W[34];
		    T1H = W[35];
		    T1J = FMA(T1F, T1G, T1H * T1I);
		    T74 = FNMS(T1H, T1G, T1F * T1I);
	       }
	       {
		    E T1L, T1N, T1K, T1M;
		    T1L = ri[WS(ios, 50)];
		    T1N = ii[WS(ios, 50)];
		    T1K = W[98];
		    T1M = W[99];
		    T1O = FMA(T1K, T1L, T1M * T1N);
		    T75 = FNMS(T1M, T1L, T1K * T1N);
	       }
	       T1P = T1J + T1O;
	       Td3 = T74 + T75;
	       {
		    E T1V, T6X, T20, T6Y;
		    {
			 E T1S, T1U, T1R, T1T;
			 T1S = ri[WS(ios, 10)];
			 T1U = ii[WS(ios, 10)];
			 T1R = W[18];
			 T1T = W[19];
			 T1V = FMA(T1R, T1S, T1T * T1U);
			 T6X = FNMS(T1T, T1S, T1R * T1U);
		    }
		    {
			 E T1X, T1Z, T1W, T1Y;
			 T1X = ri[WS(ios, 42)];
			 T1Z = ii[WS(ios, 42)];
			 T1W = W[82];
			 T1Y = W[83];
			 T20 = FMA(T1W, T1X, T1Y * T1Z);
			 T6Y = FNMS(T1Y, T1X, T1W * T1Z);
		    }
		    T21 = T1V + T20;
		    Td8 = T6X + T6Y;
		    T6W = T1V - T20;
		    T6Z = T6X - T6Y;
	       }
	       {
		    E T26, T6S, T2b, T6T;
		    {
			 E T23, T25, T22, T24;
			 T23 = ri[WS(ios, 58)];
			 T25 = ii[WS(ios, 58)];
			 T22 = W[114];
			 T24 = W[115];
			 T26 = FMA(T22, T23, T24 * T25);
			 T6S = FNMS(T24, T23, T22 * T25);
		    }
		    {
			 E T28, T2a, T27, T29;
			 T28 = ri[WS(ios, 26)];
			 T2a = ii[WS(ios, 26)];
			 T27 = W[50];
			 T29 = W[51];
			 T2b = FMA(T27, T28, T29 * T2a);
			 T6T = FNMS(T29, T28, T27 * T2a);
		    }
		    T2c = T26 + T2b;
		    Td9 = T6S + T6T;
		    T6R = T26 - T2b;
		    T6U = T6S - T6T;
	       }
	       T1Q = T1E + T1P;
	       T2d = T21 + T2c;
	       Tfx = T1Q - T2d;
	       Tfu = Td2 + Td3;
	       Tfv = Td8 + Td9;
	       Tfw = Tfu - Tfv;
	       {
		    E T6O, T6P, Td7, Tda;
		    T6O = T6M - T6N;
		    T6P = T1J - T1O;
		    T6Q = T6O + T6P;
		    TaM = T6O - T6P;
		    Td7 = T1E - T1P;
		    Tda = Td8 - Td9;
		    Tdb = Td7 - Tda;
		    TeJ = Td7 + Tda;
	       }
	       {
		    E T6V, T70, T78, T79;
		    T6V = T6R - T6U;
		    T70 = T6W + T6Z;
		    T71 = KP707106781 * (T6V - T70);
		    TaQ = KP707106781 * (T70 + T6V);
		    T78 = T6Z - T6W;
		    T79 = T6R + T6U;
		    T7a = KP707106781 * (T78 - T79);
		    TaN = KP707106781 * (T78 + T79);
	       }
	       {
		    E Td4, Td5, T73, T76;
		    Td4 = Td2 - Td3;
		    Td5 = T2c - T21;
		    Td6 = Td4 - Td5;
		    TeI = Td4 + Td5;
		    T73 = T1y - T1D;
		    T76 = T74 - T75;
		    T77 = T73 - T76;
		    TaP = T73 + T76;
	       }
	  }
	  {
	       E T2j, T7d, T2o, T7e, T2p, Tdd, T2u, T7v, T2z, T7w, T2A, Tde, T2M, Tdj, T7n;
	       E T7q, T2X, Tdk, T7i, T7l;
	       {
		    E T2g, T2i, T2f, T2h;
		    T2g = ri[WS(ios, 62)];
		    T2i = ii[WS(ios, 62)];
		    T2f = W[122];
		    T2h = W[123];
		    T2j = FMA(T2f, T2g, T2h * T2i);
		    T7d = FNMS(T2h, T2g, T2f * T2i);
	       }
	       {
		    E T2l, T2n, T2k, T2m;
		    T2l = ri[WS(ios, 30)];
		    T2n = ii[WS(ios, 30)];
		    T2k = W[58];
		    T2m = W[59];
		    T2o = FMA(T2k, T2l, T2m * T2n);
		    T7e = FNMS(T2m, T2l, T2k * T2n);
	       }
	       T2p = T2j + T2o;
	       Tdd = T7d + T7e;
	       {
		    E T2r, T2t, T2q, T2s;
		    T2r = ri[WS(ios, 14)];
		    T2t = ii[WS(ios, 14)];
		    T2q = W[26];
		    T2s = W[27];
		    T2u = FMA(T2q, T2r, T2s * T2t);
		    T7v = FNMS(T2s, T2r, T2q * T2t);
	       }
	       {
		    E T2w, T2y, T2v, T2x;
		    T2w = ri[WS(ios, 46)];
		    T2y = ii[WS(ios, 46)];
		    T2v = W[90];
		    T2x = W[91];
		    T2z = FMA(T2v, T2w, T2x * T2y);
		    T7w = FNMS(T2x, T2w, T2v * T2y);
	       }
	       T2A = T2u + T2z;
	       Tde = T7v + T7w;
	       {
		    E T2G, T7o, T2L, T7p;
		    {
			 E T2D, T2F, T2C, T2E;
			 T2D = ri[WS(ios, 6)];
			 T2F = ii[WS(ios, 6)];
			 T2C = W[10];
			 T2E = W[11];
			 T2G = FMA(T2C, T2D, T2E * T2F);
			 T7o = FNMS(T2E, T2D, T2C * T2F);
		    }
		    {
			 E T2I, T2K, T2H, T2J;
			 T2I = ri[WS(ios, 38)];
			 T2K = ii[WS(ios, 38)];
			 T2H = W[74];
			 T2J = W[75];
			 T2L = FMA(T2H, T2I, T2J * T2K);
			 T7p = FNMS(T2J, T2I, T2H * T2K);
		    }
		    T2M = T2G + T2L;
		    Tdj = T7o + T7p;
		    T7n = T2G - T2L;
		    T7q = T7o - T7p;
	       }
	       {
		    E T2R, T7j, T2W, T7k;
		    {
			 E T2O, T2Q, T2N, T2P;
			 T2O = ri[WS(ios, 54)];
			 T2Q = ii[WS(ios, 54)];
			 T2N = W[106];
			 T2P = W[107];
			 T2R = FMA(T2N, T2O, T2P * T2Q);
			 T7j = FNMS(T2P, T2O, T2N * T2Q);
		    }
		    {
			 E T2T, T2V, T2S, T2U;
			 T2T = ri[WS(ios, 22)];
			 T2V = ii[WS(ios, 22)];
			 T2S = W[42];
			 T2U = W[43];
			 T2W = FMA(T2S, T2T, T2U * T2V);
			 T7k = FNMS(T2U, T2T, T2S * T2V);
		    }
		    T2X = T2R + T2W;
		    Tdk = T7j + T7k;
		    T7i = T2R - T2W;
		    T7l = T7j - T7k;
	       }
	       T2B = T2p + T2A;
	       T2Y = T2M + T2X;
	       Tfz = T2B - T2Y;
	       TfA = Tdd + Tde;
	       TfB = Tdj + Tdk;
	       TfC = TfA - TfB;
	       {
		    E T7f, T7g, Tdi, Tdl;
		    T7f = T7d - T7e;
		    T7g = T2u - T2z;
		    T7h = T7f + T7g;
		    TaW = T7f - T7g;
		    Tdi = T2p - T2A;
		    Tdl = Tdj - Tdk;
		    Tdm = Tdi - Tdl;
		    TeM = Tdi + Tdl;
	       }
	       {
		    E T7m, T7r, T7z, T7A;
		    T7m = T7i - T7l;
		    T7r = T7n + T7q;
		    T7s = KP707106781 * (T7m - T7r);
		    TaU = KP707106781 * (T7r + T7m);
		    T7z = T7q - T7n;
		    T7A = T7i + T7l;
		    T7B = KP707106781 * (T7z - T7A);
		    TaX = KP707106781 * (T7z + T7A);
	       }
	       {
		    E Tdf, Tdg, T7u, T7x;
		    Tdf = Tdd - Tde;
		    Tdg = T2X - T2M;
		    Tdh = Tdf - Tdg;
		    TeL = Tdf + Tdg;
		    T7u = T2j - T2o;
		    T7x = T7v - T7w;
		    T7y = T7u - T7x;
		    TaT = T7u + T7x;
	       }
	  }
	  {
	       E T4D, T9e, T4I, T9f, T4J, Te8, T4O, T8A, T4T, T8B, T4U, Te9, T56, TdS, T8G;
	       E T8H, T5h, TdT, T8J, T8M;
	       {
		    E T4A, T4C, T4z, T4B;
		    T4A = ri[WS(ios, 63)];
		    T4C = ii[WS(ios, 63)];
		    T4z = W[124];
		    T4B = W[125];
		    T4D = FMA(T4z, T4A, T4B * T4C);
		    T9e = FNMS(T4B, T4A, T4z * T4C);
	       }
	       {
		    E T4F, T4H, T4E, T4G;
		    T4F = ri[WS(ios, 31)];
		    T4H = ii[WS(ios, 31)];
		    T4E = W[60];
		    T4G = W[61];
		    T4I = FMA(T4E, T4F, T4G * T4H);
		    T9f = FNMS(T4G, T4F, T4E * T4H);
	       }
	       T4J = T4D + T4I;
	       Te8 = T9e + T9f;
	       {
		    E T4L, T4N, T4K, T4M;
		    T4L = ri[WS(ios, 15)];
		    T4N = ii[WS(ios, 15)];
		    T4K = W[28];
		    T4M = W[29];
		    T4O = FMA(T4K, T4L, T4M * T4N);
		    T8A = FNMS(T4M, T4L, T4K * T4N);
	       }
	       {
		    E T4Q, T4S, T4P, T4R;
		    T4Q = ri[WS(ios, 47)];
		    T4S = ii[WS(ios, 47)];
		    T4P = W[92];
		    T4R = W[93];
		    T4T = FMA(T4P, T4Q, T4R * T4S);
		    T8B = FNMS(T4R, T4Q, T4P * T4S);
	       }
	       T4U = T4O + T4T;
	       Te9 = T8A + T8B;
	       {
		    E T50, T8E, T55, T8F;
		    {
			 E T4X, T4Z, T4W, T4Y;
			 T4X = ri[WS(ios, 7)];
			 T4Z = ii[WS(ios, 7)];
			 T4W = W[12];
			 T4Y = W[13];
			 T50 = FMA(T4W, T4X, T4Y * T4Z);
			 T8E = FNMS(T4Y, T4X, T4W * T4Z);
		    }
		    {
			 E T52, T54, T51, T53;
			 T52 = ri[WS(ios, 39)];
			 T54 = ii[WS(ios, 39)];
			 T51 = W[76];
			 T53 = W[77];
			 T55 = FMA(T51, T52, T53 * T54);
			 T8F = FNMS(T53, T52, T51 * T54);
		    }
		    T56 = T50 + T55;
		    TdS = T8E + T8F;
		    T8G = T8E - T8F;
		    T8H = T50 - T55;
	       }
	       {
		    E T5b, T8K, T5g, T8L;
		    {
			 E T58, T5a, T57, T59;
			 T58 = ri[WS(ios, 55)];
			 T5a = ii[WS(ios, 55)];
			 T57 = W[108];
			 T59 = W[109];
			 T5b = FMA(T57, T58, T59 * T5a);
			 T8K = FNMS(T59, T58, T57 * T5a);
		    }
		    {
			 E T5d, T5f, T5c, T5e;
			 T5d = ri[WS(ios, 23)];
			 T5f = ii[WS(ios, 23)];
			 T5c = W[44];
			 T5e = W[45];
			 T5g = FMA(T5c, T5d, T5e * T5f);
			 T8L = FNMS(T5e, T5d, T5c * T5f);
		    }
		    T5h = T5b + T5g;
		    TdT = T8K + T8L;
		    T8J = T5b - T5g;
		    T8M = T8K - T8L;
	       }
	       {
		    E T4V, T5i, Tea, Teb;
		    T4V = T4J + T4U;
		    T5i = T56 + T5h;
		    T5j = T4V + T5i;
		    TfR = T4V - T5i;
		    Tea = Te8 - Te9;
		    Teb = T5h - T56;
		    Tec = Tea - Teb;
		    Tf0 = Tea + Teb;
	       }
	       {
		    E TfW, TfX, T8z, T8C;
		    TfW = Te8 + Te9;
		    TfX = TdS + TdT;
		    TfY = TfW - TfX;
		    Tgy = TfW + TfX;
		    T8z = T4D - T4I;
		    T8C = T8A - T8B;
		    T8D = T8z - T8C;
		    Tbl = T8z + T8C;
	       }
	       {
		    E T8I, T8N, T9j, T9k;
		    T8I = T8G - T8H;
		    T8N = T8J + T8M;
		    T8O = KP707106781 * (T8I - T8N);
		    Tbx = KP707106781 * (T8I + T8N);
		    T9j = T8J - T8M;
		    T9k = T8H + T8G;
		    T9l = KP707106781 * (T9j - T9k);
		    Tbm = KP707106781 * (T9k + T9j);
	       }
	       {
		    E TdR, TdU, T9g, T9h;
		    TdR = T4J - T4U;
		    TdU = TdS - TdT;
		    TdV = TdR - TdU;
		    TeX = TdR + TdU;
		    T9g = T9e - T9f;
		    T9h = T4O - T4T;
		    T9i = T9g + T9h;
		    Tbw = T9g - T9h;
	       }
	  }
	  {
	       E T36, T7G, T3b, T7H, T3c, Tdq, T3h, T8m, T3m, T8n, T3n, Tdr, T3z, TdI, T7Q;
	       E T7T, T3K, TdJ, T7L, T7O;
	       {
		    E T33, T35, T32, T34;
		    T33 = ri[WS(ios, 1)];
		    T35 = ii[WS(ios, 1)];
		    T32 = W[0];
		    T34 = W[1];
		    T36 = FMA(T32, T33, T34 * T35);
		    T7G = FNMS(T34, T33, T32 * T35);
	       }
	       {
		    E T38, T3a, T37, T39;
		    T38 = ri[WS(ios, 33)];
		    T3a = ii[WS(ios, 33)];
		    T37 = W[64];
		    T39 = W[65];
		    T3b = FMA(T37, T38, T39 * T3a);
		    T7H = FNMS(T39, T38, T37 * T3a);
	       }
	       T3c = T36 + T3b;
	       Tdq = T7G + T7H;
	       {
		    E T3e, T3g, T3d, T3f;
		    T3e = ri[WS(ios, 17)];
		    T3g = ii[WS(ios, 17)];
		    T3d = W[32];
		    T3f = W[33];
		    T3h = FMA(T3d, T3e, T3f * T3g);
		    T8m = FNMS(T3f, T3e, T3d * T3g);
	       }
	       {
		    E T3j, T3l, T3i, T3k;
		    T3j = ri[WS(ios, 49)];
		    T3l = ii[WS(ios, 49)];
		    T3i = W[96];
		    T3k = W[97];
		    T3m = FMA(T3i, T3j, T3k * T3l);
		    T8n = FNMS(T3k, T3j, T3i * T3l);
	       }
	       T3n = T3h + T3m;
	       Tdr = T8m + T8n;
	       {
		    E T3t, T7R, T3y, T7S;
		    {
			 E T3q, T3s, T3p, T3r;
			 T3q = ri[WS(ios, 9)];
			 T3s = ii[WS(ios, 9)];
			 T3p = W[16];
			 T3r = W[17];
			 T3t = FMA(T3p, T3q, T3r * T3s);
			 T7R = FNMS(T3r, T3q, T3p * T3s);
		    }
		    {
			 E T3v, T3x, T3u, T3w;
			 T3v = ri[WS(ios, 41)];
			 T3x = ii[WS(ios, 41)];
			 T3u = W[80];
			 T3w = W[81];
			 T3y = FMA(T3u, T3v, T3w * T3x);
			 T7S = FNMS(T3w, T3v, T3u * T3x);
		    }
		    T3z = T3t + T3y;
		    TdI = T7R + T7S;
		    T7Q = T3t - T3y;
		    T7T = T7R - T7S;
	       }
	       {
		    E T3E, T7M, T3J, T7N;
		    {
			 E T3B, T3D, T3A, T3C;
			 T3B = ri[WS(ios, 57)];
			 T3D = ii[WS(ios, 57)];
			 T3A = W[112];
			 T3C = W[113];
			 T3E = FMA(T3A, T3B, T3C * T3D);
			 T7M = FNMS(T3C, T3B, T3A * T3D);
		    }
		    {
			 E T3G, T3I, T3F, T3H;
			 T3G = ri[WS(ios, 25)];
			 T3I = ii[WS(ios, 25)];
			 T3F = W[48];
			 T3H = W[49];
			 T3J = FMA(T3F, T3G, T3H * T3I);
			 T7N = FNMS(T3H, T3G, T3F * T3I);
		    }
		    T3K = T3E + T3J;
		    TdJ = T7M + T7N;
		    T7L = T3E - T3J;
		    T7O = T7M - T7N;
	       }
	       {
		    E T3o, T3L, TdH, TdK;
		    T3o = T3c + T3n;
		    T3L = T3z + T3K;
		    T3M = T3o + T3L;
		    TfL = T3o - T3L;
		    TdH = T3c - T3n;
		    TdK = TdI - TdJ;
		    TdL = TdH - TdK;
		    TeQ = TdH + TdK;
	       }
	       {
		    E TfG, TfH, T7I, T7J;
		    TfG = Tdq + Tdr;
		    TfH = TdI + TdJ;
		    TfI = TfG - TfH;
		    Tgt = TfG + TfH;
		    T7I = T7G - T7H;
		    T7J = T3h - T3m;
		    T7K = T7I + T7J;
		    Tb2 = T7I - T7J;
	       }
	       {
		    E T7P, T7U, T8q, T8r;
		    T7P = T7L - T7O;
		    T7U = T7Q + T7T;
		    T7V = KP707106781 * (T7P - T7U);
		    Tbe = KP707106781 * (T7U + T7P);
		    T8q = T7T - T7Q;
		    T8r = T7L + T7O;
		    T8s = KP707106781 * (T8q - T8r);
		    Tb3 = KP707106781 * (T8q + T8r);
	       }
	       {
		    E Tds, Tdt, T8l, T8o;
		    Tds = Tdq - Tdr;
		    Tdt = T3K - T3z;
		    Tdu = Tds - Tdt;
		    TeT = Tds + Tdt;
		    T8l = T36 - T3b;
		    T8o = T8m - T8n;
		    T8p = T8l - T8o;
		    Tbd = T8l + T8o;
	       }
	  }
	  {
	       E T3X, TdB, T8a, T8d, T4v, Tdx, T80, T85, T48, TdC, T8b, T8g, T4k, Tdw, T7X;
	       E T84;
	       {
		    E T3R, T88, T3W, T89;
		    {
			 E T3O, T3Q, T3N, T3P;
			 T3O = ri[WS(ios, 5)];
			 T3Q = ii[WS(ios, 5)];
			 T3N = W[8];
			 T3P = W[9];
			 T3R = FMA(T3N, T3O, T3P * T3Q);
			 T88 = FNMS(T3P, T3O, T3N * T3Q);
		    }
		    {
			 E T3T, T3V, T3S, T3U;
			 T3T = ri[WS(ios, 37)];
			 T3V = ii[WS(ios, 37)];
			 T3S = W[72];
			 T3U = W[73];
			 T3W = FMA(T3S, T3T, T3U * T3V);
			 T89 = FNMS(T3U, T3T, T3S * T3V);
		    }
		    T3X = T3R + T3W;
		    TdB = T88 + T89;
		    T8a = T88 - T89;
		    T8d = T3R - T3W;
	       }
	       {
		    E T4p, T7Y, T4u, T7Z;
		    {
			 E T4m, T4o, T4l, T4n;
			 T4m = ri[WS(ios, 13)];
			 T4o = ii[WS(ios, 13)];
			 T4l = W[24];
			 T4n = W[25];
			 T4p = FMA(T4l, T4m, T4n * T4o);
			 T7Y = FNMS(T4n, T4m, T4l * T4o);
		    }
		    {
			 E T4r, T4t, T4q, T4s;
			 T4r = ri[WS(ios, 45)];
			 T4t = ii[WS(ios, 45)];
			 T4q = W[88];
			 T4s = W[89];
			 T4u = FMA(T4q, T4r, T4s * T4t);
			 T7Z = FNMS(T4s, T4r, T4q * T4t);
		    }
		    T4v = T4p + T4u;
		    Tdx = T7Y + T7Z;
		    T80 = T7Y - T7Z;
		    T85 = T4p - T4u;
	       }
	       {
		    E T42, T8e, T47, T8f;
		    {
			 E T3Z, T41, T3Y, T40;
			 T3Z = ri[WS(ios, 21)];
			 T41 = ii[WS(ios, 21)];
			 T3Y = W[40];
			 T40 = W[41];
			 T42 = FMA(T3Y, T3Z, T40 * T41);
			 T8e = FNMS(T40, T3Z, T3Y * T41);
		    }
		    {
			 E T44, T46, T43, T45;
			 T44 = ri[WS(ios, 53)];
			 T46 = ii[WS(ios, 53)];
			 T43 = W[104];
			 T45 = W[105];
			 T47 = FMA(T43, T44, T45 * T46);
			 T8f = FNMS(T45, T44, T43 * T46);
		    }
		    T48 = T42 + T47;
		    TdC = T8e + T8f;
		    T8b = T42 - T47;
		    T8g = T8e - T8f;
	       }
	       {
		    E T4e, T82, T4j, T83;
		    {
			 E T4b, T4d, T4a, T4c;
			 T4b = ri[WS(ios, 61)];
			 T4d = ii[WS(ios, 61)];
			 T4a = W[120];
			 T4c = W[121];
			 T4e = FMA(T4a, T4b, T4c * T4d);
			 T82 = FNMS(T4c, T4b, T4a * T4d);
		    }
		    {
			 E T4g, T4i, T4f, T4h;
			 T4g = ri[WS(ios, 29)];
			 T4i = ii[WS(ios, 29)];
			 T4f = W[56];
			 T4h = W[57];
			 T4j = FMA(T4f, T4g, T4h * T4i);
			 T83 = FNMS(T4h, T4g, T4f * T4i);
		    }
		    T4k = T4e + T4j;
		    Tdw = T82 + T83;
		    T7X = T4e - T4j;
		    T84 = T82 - T83;
	       }
	       {
		    E T49, T4w, TdA, TdD;
		    T49 = T3X + T48;
		    T4w = T4k + T4v;
		    T4x = T49 + T4w;
		    TfJ = T4w - T49;
		    TdA = T3X - T48;
		    TdD = TdB - TdC;
		    TdE = TdA + TdD;
		    TdM = TdD - TdA;
	       }
	       {
		    E TfM, TfN, T81, T86;
		    TfM = TdB + TdC;
		    TfN = Tdw + Tdx;
		    TfO = TfM - TfN;
		    Tgu = TfM + TfN;
		    T81 = T7X - T80;
		    T86 = T84 + T85;
		    T87 = FNMS(KP923879532, T86, KP382683432 * T81);
		    T8v = FMA(KP382683432, T86, KP923879532 * T81);
	       }
	       {
		    E T8c, T8h, Tb8, Tb9;
		    T8c = T8a + T8b;
		    T8h = T8d - T8g;
		    T8i = FMA(KP923879532, T8c, KP382683432 * T8h);
		    T8u = FNMS(KP923879532, T8h, KP382683432 * T8c);
		    Tb8 = T8a - T8b;
		    Tb9 = T8d + T8g;
		    Tba = FMA(KP382683432, Tb8, KP923879532 * Tb9);
		    Tbg = FNMS(KP382683432, Tb9, KP923879532 * Tb8);
	       }
	       {
		    E Tdv, Tdy, Tb5, Tb6;
		    Tdv = T4k - T4v;
		    Tdy = Tdw - Tdx;
		    Tdz = Tdv - Tdy;
		    TdN = Tdv + Tdy;
		    Tb5 = T7X + T80;
		    Tb6 = T84 - T85;
		    Tb7 = FNMS(KP382683432, Tb6, KP923879532 * Tb5);
		    Tbh = FMA(KP923879532, Tb6, KP382683432 * Tb5);
	       }
	  }
	  {
	       E T5u, TdW, T8S, T8V, T62, Te3, T94, T99, T5F, TdX, T8T, T8Y, T5R, Te2, T93;
	       E T96;
	       {
		    E T5o, T8Q, T5t, T8R;
		    {
			 E T5l, T5n, T5k, T5m;
			 T5l = ri[WS(ios, 3)];
			 T5n = ii[WS(ios, 3)];
			 T5k = W[4];
			 T5m = W[5];
			 T5o = FMA(T5k, T5l, T5m * T5n);
			 T8Q = FNMS(T5m, T5l, T5k * T5n);
		    }
		    {
			 E T5q, T5s, T5p, T5r;
			 T5q = ri[WS(ios, 35)];
			 T5s = ii[WS(ios, 35)];
			 T5p = W[68];
			 T5r = W[69];
			 T5t = FMA(T5p, T5q, T5r * T5s);
			 T8R = FNMS(T5r, T5q, T5p * T5s);
		    }
		    T5u = T5o + T5t;
		    TdW = T8Q + T8R;
		    T8S = T8Q - T8R;
		    T8V = T5o - T5t;
	       }
	       {
		    E T5W, T97, T61, T98;
		    {
			 E T5T, T5V, T5S, T5U;
			 T5T = ri[WS(ios, 11)];
			 T5V = ii[WS(ios, 11)];
			 T5S = W[20];
			 T5U = W[21];
			 T5W = FMA(T5S, T5T, T5U * T5V);
			 T97 = FNMS(T5U, T5T, T5S * T5V);
		    }
		    {
			 E T5Y, T60, T5X, T5Z;
			 T5Y = ri[WS(ios, 43)];
			 T60 = ii[WS(ios, 43)];
			 T5X = W[84];
			 T5Z = W[85];
			 T61 = FMA(T5X, T5Y, T5Z * T60);
			 T98 = FNMS(T5Z, T5Y, T5X * T60);
		    }
		    T62 = T5W + T61;
		    Te3 = T97 + T98;
		    T94 = T5W - T61;
		    T99 = T97 - T98;
	       }
	       {
		    E T5z, T8W, T5E, T8X;
		    {
			 E T5w, T5y, T5v, T5x;
			 T5w = ri[WS(ios, 19)];
			 T5y = ii[WS(ios, 19)];
			 T5v = W[36];
			 T5x = W[37];
			 T5z = FMA(T5v, T5w, T5x * T5y);
			 T8W = FNMS(T5x, T5w, T5v * T5y);
		    }
		    {
			 E T5B, T5D, T5A, T5C;
			 T5B = ri[WS(ios, 51)];
			 T5D = ii[WS(ios, 51)];
			 T5A = W[100];
			 T5C = W[101];
			 T5E = FMA(T5A, T5B, T5C * T5D);
			 T8X = FNMS(T5C, T5B, T5A * T5D);
		    }
		    T5F = T5z + T5E;
		    TdX = T8W + T8X;
		    T8T = T5z - T5E;
		    T8Y = T8W - T8X;
	       }
	       {
		    E T5L, T91, T5Q, T92;
		    {
			 E T5I, T5K, T5H, T5J;
			 T5I = ri[WS(ios, 59)];
			 T5K = ii[WS(ios, 59)];
			 T5H = W[116];
			 T5J = W[117];
			 T5L = FMA(T5H, T5I, T5J * T5K);
			 T91 = FNMS(T5J, T5I, T5H * T5K);
		    }
		    {
			 E T5N, T5P, T5M, T5O;
			 T5N = ri[WS(ios, 27)];
			 T5P = ii[WS(ios, 27)];
			 T5M = W[52];
			 T5O = W[53];
			 T5Q = FMA(T5M, T5N, T5O * T5P);
			 T92 = FNMS(T5O, T5N, T5M * T5P);
		    }
		    T5R = T5L + T5Q;
		    Te2 = T91 + T92;
		    T93 = T91 - T92;
		    T96 = T5L - T5Q;
	       }
	       {
		    E T5G, T63, Te1, Te4;
		    T5G = T5u + T5F;
		    T63 = T5R + T62;
		    T64 = T5G + T63;
		    TfZ = T63 - T5G;
		    Te1 = T5R - T62;
		    Te4 = Te2 - Te3;
		    Te5 = Te1 + Te4;
		    Ted = Te1 - Te4;
	       }
	       {
		    E TfS, TfT, T8U, T8Z;
		    TfS = TdW + TdX;
		    TfT = Te2 + Te3;
		    TfU = TfS - TfT;
		    Tgz = TfS + TfT;
		    T8U = T8S + T8T;
		    T8Z = T8V - T8Y;
		    T90 = FNMS(KP923879532, T8Z, KP382683432 * T8U);
		    T9o = FMA(KP923879532, T8U, KP382683432 * T8Z);
	       }
	       {
		    E T95, T9a, Tbr, Tbs;
		    T95 = T93 + T94;
		    T9a = T96 - T99;
		    T9b = FMA(KP382683432, T95, KP923879532 * T9a);
		    T9n = FNMS(KP923879532, T95, KP382683432 * T9a);
		    Tbr = T93 - T94;
		    Tbs = T96 + T99;
		    Tbt = FMA(KP923879532, Tbr, KP382683432 * Tbs);
		    Tbz = FNMS(KP382683432, Tbr, KP923879532 * Tbs);
	       }
	       {
		    E TdY, TdZ, Tbo, Tbp;
		    TdY = TdW - TdX;
		    TdZ = T5u - T5F;
		    Te0 = TdY - TdZ;
		    Tee = TdZ + TdY;
		    Tbo = T8S - T8T;
		    Tbp = T8V + T8Y;
		    Tbq = FNMS(KP382683432, Tbp, KP923879532 * Tbo);
		    TbA = FMA(KP382683432, Tbo, KP923879532 * Tbp);
	       }
	  }
	  {
	       E T1t, Tgn, TgK, TgL, TgV, Th1, T30, Th0, T66, TgX, Tgw, TgE, TgB, TgF, Tgq;
	       E TgM;
	       {
		    E TH, T1s, TgI, TgJ;
		    TH = Tj + TG;
		    T1s = T14 + T1r;
		    T1t = TH + T1s;
		    Tgn = TH - T1s;
		    TgI = Tgt + Tgu;
		    TgJ = Tgy + Tgz;
		    TgK = TgI - TgJ;
		    TgL = TgI + TgJ;
	       }
	       {
		    E TgN, TgU, T2e, T2Z;
		    TgN = Tfq + Tfr;
		    TgU = TgO + TgT;
		    TgV = TgN + TgU;
		    Th1 = TgU - TgN;
		    T2e = T1Q + T2d;
		    T2Z = T2B + T2Y;
		    T30 = T2e + T2Z;
		    Th0 = T2Z - T2e;
	       }
	       {
		    E T4y, T65, Tgs, Tgv;
		    T4y = T3M + T4x;
		    T65 = T5j + T64;
		    T66 = T4y + T65;
		    TgX = T65 - T4y;
		    Tgs = T3M - T4x;
		    Tgv = Tgt - Tgu;
		    Tgw = Tgs + Tgv;
		    TgE = Tgv - Tgs;
	       }
	       {
		    E Tgx, TgA, Tgo, Tgp;
		    Tgx = T5j - T64;
		    TgA = Tgy - Tgz;
		    TgB = Tgx - TgA;
		    TgF = Tgx + TgA;
		    Tgo = Tfu + Tfv;
		    Tgp = TfA + TfB;
		    Tgq = Tgo - Tgp;
		    TgM = Tgo + Tgp;
	       }
	       {
		    E T31, TgW, TgH, TgY;
		    T31 = T1t + T30;
		    ri[WS(ios, 32)] = T31 - T66;
		    ri[0] = T31 + T66;
		    TgW = TgM + TgV;
		    ii[0] = TgL + TgW;
		    ii[WS(ios, 32)] = TgW - TgL;
		    TgH = T1t - T30;
		    ri[WS(ios, 48)] = TgH - TgK;
		    ri[WS(ios, 16)] = TgH + TgK;
		    TgY = TgV - TgM;
		    ii[WS(ios, 16)] = TgX + TgY;
		    ii[WS(ios, 48)] = TgY - TgX;
	       }
	       {
		    E Tgr, TgC, TgZ, Th2;
		    Tgr = Tgn + Tgq;
		    TgC = KP707106781 * (Tgw + TgB);
		    ri[WS(ios, 40)] = Tgr - TgC;
		    ri[WS(ios, 8)] = Tgr + TgC;
		    TgZ = KP707106781 * (TgE + TgF);
		    Th2 = Th0 + Th1;
		    ii[WS(ios, 8)] = TgZ + Th2;
		    ii[WS(ios, 40)] = Th2 - TgZ;
	       }
	       {
		    E TgD, TgG, Th3, Th4;
		    TgD = Tgn - Tgq;
		    TgG = KP707106781 * (TgE - TgF);
		    ri[WS(ios, 56)] = TgD - TgG;
		    ri[WS(ios, 24)] = TgD + TgG;
		    Th3 = KP707106781 * (TgB - Tgw);
		    Th4 = Th1 - Th0;
		    ii[WS(ios, 24)] = Th3 + Th4;
		    ii[WS(ios, 56)] = Th4 - Th3;
	       }
	  }
	  {
	       E Tft, Tg7, Tgh, Tgl, Th9, Thf, TfE, Th6, TfQ, Tg4, Tga, The, Tge, Tgk, Tg1;
	       E Tg5;
	       {
		    E Tfp, Tfs, Tgf, Tgg;
		    Tfp = Tj - TG;
		    Tfs = Tfq - Tfr;
		    Tft = Tfp - Tfs;
		    Tg7 = Tfp + Tfs;
		    Tgf = TfR + TfU;
		    Tgg = TfY + TfZ;
		    Tgh = FNMS(KP382683432, Tgg, KP923879532 * Tgf);
		    Tgl = FMA(KP923879532, Tgg, KP382683432 * Tgf);
	       }
	       {
		    E Th7, Th8, Tfy, TfD;
		    Th7 = T1r - T14;
		    Th8 = TgT - TgO;
		    Th9 = Th7 + Th8;
		    Thf = Th8 - Th7;
		    Tfy = Tfw - Tfx;
		    TfD = Tfz + TfC;
		    TfE = KP707106781 * (Tfy - TfD);
		    Th6 = KP707106781 * (Tfy + TfD);
	       }
	       {
		    E TfK, TfP, Tg8, Tg9;
		    TfK = TfI - TfJ;
		    TfP = TfL - TfO;
		    TfQ = FMA(KP923879532, TfK, KP382683432 * TfP);
		    Tg4 = FNMS(KP923879532, TfP, KP382683432 * TfK);
		    Tg8 = Tfx + Tfw;
		    Tg9 = Tfz - TfC;
		    Tga = KP707106781 * (Tg8 + Tg9);
		    The = KP707106781 * (Tg9 - Tg8);
	       }
	       {
		    E Tgc, Tgd, TfV, Tg0;
		    Tgc = TfI + TfJ;
		    Tgd = TfL + TfO;
		    Tge = FMA(KP382683432, Tgc, KP923879532 * Tgd);
		    Tgk = FNMS(KP382683432, Tgd, KP923879532 * Tgc);
		    TfV = TfR - TfU;
		    Tg0 = TfY - TfZ;
		    Tg1 = FNMS(KP923879532, Tg0, KP382683432 * TfV);
		    Tg5 = FMA(KP382683432, Tg0, KP923879532 * TfV);
	       }
	       {
		    E TfF, Tg2, Thd, Thg;
		    TfF = Tft + TfE;
		    Tg2 = TfQ + Tg1;
		    ri[WS(ios, 44)] = TfF - Tg2;
		    ri[WS(ios, 12)] = TfF + Tg2;
		    Thd = Tg4 + Tg5;
		    Thg = The + Thf;
		    ii[WS(ios, 12)] = Thd + Thg;
		    ii[WS(ios, 44)] = Thg - Thd;
	       }
	       {
		    E Tg3, Tg6, Thh, Thi;
		    Tg3 = Tft - TfE;
		    Tg6 = Tg4 - Tg5;
		    ri[WS(ios, 60)] = Tg3 - Tg6;
		    ri[WS(ios, 28)] = Tg3 + Tg6;
		    Thh = Tg1 - TfQ;
		    Thi = Thf - The;
		    ii[WS(ios, 28)] = Thh + Thi;
		    ii[WS(ios, 60)] = Thi - Thh;
	       }
	       {
		    E Tgb, Tgi, Th5, Tha;
		    Tgb = Tg7 + Tga;
		    Tgi = Tge + Tgh;
		    ri[WS(ios, 36)] = Tgb - Tgi;
		    ri[WS(ios, 4)] = Tgb + Tgi;
		    Th5 = Tgk + Tgl;
		    Tha = Th6 + Th9;
		    ii[WS(ios, 4)] = Th5 + Tha;
		    ii[WS(ios, 36)] = Tha - Th5;
	       }
	       {
		    E Tgj, Tgm, Thb, Thc;
		    Tgj = Tg7 - Tga;
		    Tgm = Tgk - Tgl;
		    ri[WS(ios, 52)] = Tgj - Tgm;
		    ri[WS(ios, 20)] = Tgj + Tgm;
		    Thb = Tgh - Tge;
		    Thc = Th9 - Th6;
		    ii[WS(ios, 20)] = Thb + Thc;
		    ii[WS(ios, 52)] = Thc - Thb;
	       }
	  }
	  {
	       E Td1, Ten, Tdo, ThA, ThD, ThJ, Teq, ThI, Teh, TeB, Tel, Tex, TdQ, TeA, Tek;
	       E Teu;
	       {
		    E TcP, Td0, Teo, Tep;
		    TcP = TcL - TcO;
		    Td0 = KP707106781 * (TcU - TcZ);
		    Td1 = TcP - Td0;
		    Ten = TcP + Td0;
		    {
			 E Tdc, Tdn, ThB, ThC;
			 Tdc = FNMS(KP923879532, Tdb, KP382683432 * Td6);
			 Tdn = FMA(KP382683432, Tdh, KP923879532 * Tdm);
			 Tdo = Tdc - Tdn;
			 ThA = Tdc + Tdn;
			 ThB = KP707106781 * (TeF - TeE);
			 ThC = Thn - Thm;
			 ThD = ThB + ThC;
			 ThJ = ThC - ThB;
		    }
		    Teo = FMA(KP923879532, Td6, KP382683432 * Tdb);
		    Tep = FNMS(KP923879532, Tdh, KP382683432 * Tdm);
		    Teq = Teo + Tep;
		    ThI = Tep - Teo;
		    {
			 E Te7, Tev, Teg, Tew, Te6, Tef;
			 Te6 = KP707106781 * (Te0 - Te5);
			 Te7 = TdV - Te6;
			 Tev = TdV + Te6;
			 Tef = KP707106781 * (Ted - Tee);
			 Teg = Tec - Tef;
			 Tew = Tec + Tef;
			 Teh = FNMS(KP980785280, Teg, KP195090322 * Te7);
			 TeB = FMA(KP831469612, Tew, KP555570233 * Tev);
			 Tel = FMA(KP195090322, Teg, KP980785280 * Te7);
			 Tex = FNMS(KP555570233, Tew, KP831469612 * Tev);
		    }
		    {
			 E TdG, Tes, TdP, Tet, TdF, TdO;
			 TdF = KP707106781 * (Tdz - TdE);
			 TdG = Tdu - TdF;
			 Tes = Tdu + TdF;
			 TdO = KP707106781 * (TdM - TdN);
			 TdP = TdL - TdO;
			 Tet = TdL + TdO;
			 TdQ = FMA(KP980785280, TdG, KP195090322 * TdP);
			 TeA = FNMS(KP555570233, Tet, KP831469612 * Tes);
			 Tek = FNMS(KP980785280, TdP, KP195090322 * TdG);
			 Teu = FMA(KP555570233, Tes, KP831469612 * Tet);
		    }
	       }
	       {
		    E Tdp, Tei, ThH, ThK;
		    Tdp = Td1 + Tdo;
		    Tei = TdQ + Teh;
		    ri[WS(ios, 46)] = Tdp - Tei;
		    ri[WS(ios, 14)] = Tdp + Tei;
		    ThH = Tek + Tel;
		    ThK = ThI + ThJ;
		    ii[WS(ios, 14)] = ThH + ThK;
		    ii[WS(ios, 46)] = ThK - ThH;
	       }
	       {
		    E Tej, Tem, ThL, ThM;
		    Tej = Td1 - Tdo;
		    Tem = Tek - Tel;
		    ri[WS(ios, 62)] = Tej - Tem;
		    ri[WS(ios, 30)] = Tej + Tem;
		    ThL = Teh - TdQ;
		    ThM = ThJ - ThI;
		    ii[WS(ios, 30)] = ThL + ThM;
		    ii[WS(ios, 62)] = ThM - ThL;
	       }
	       {
		    E Ter, Tey, Thz, ThE;
		    Ter = Ten + Teq;
		    Tey = Teu + Tex;
		    ri[WS(ios, 38)] = Ter - Tey;
		    ri[WS(ios, 6)] = Ter + Tey;
		    Thz = TeA + TeB;
		    ThE = ThA + ThD;
		    ii[WS(ios, 6)] = Thz + ThE;
		    ii[WS(ios, 38)] = ThE - Thz;
	       }
	       {
		    E Tez, TeC, ThF, ThG;
		    Tez = Ten - Teq;
		    TeC = TeA - TeB;
		    ri[WS(ios, 54)] = Tez - TeC;
		    ri[WS(ios, 22)] = Tez + TeC;
		    ThF = Tex - Teu;
		    ThG = ThD - ThA;
		    ii[WS(ios, 22)] = ThF + ThG;
		    ii[WS(ios, 54)] = ThG - ThF;
	       }
	  }
	  {
	       E TeH, Tf9, TeO, Thk, Thp, Thv, Tfc, Thu, Tf3, Tfn, Tf7, Tfj, TeW, Tfm, Tf6;
	       E Tfg;
	       {
		    E TeD, TeG, Tfa, Tfb;
		    TeD = TcL + TcO;
		    TeG = KP707106781 * (TeE + TeF);
		    TeH = TeD - TeG;
		    Tf9 = TeD + TeG;
		    {
			 E TeK, TeN, Thl, Tho;
			 TeK = FNMS(KP382683432, TeJ, KP923879532 * TeI);
			 TeN = FMA(KP923879532, TeL, KP382683432 * TeM);
			 TeO = TeK - TeN;
			 Thk = TeK + TeN;
			 Thl = KP707106781 * (TcU + TcZ);
			 Tho = Thm + Thn;
			 Thp = Thl + Tho;
			 Thv = Tho - Thl;
		    }
		    Tfa = FMA(KP382683432, TeI, KP923879532 * TeJ);
		    Tfb = FNMS(KP382683432, TeL, KP923879532 * TeM);
		    Tfc = Tfa + Tfb;
		    Thu = Tfb - Tfa;
		    {
			 E TeZ, Tfh, Tf2, Tfi, TeY, Tf1;
			 TeY = KP707106781 * (Tee + Ted);
			 TeZ = TeX - TeY;
			 Tfh = TeX + TeY;
			 Tf1 = KP707106781 * (Te0 + Te5);
			 Tf2 = Tf0 - Tf1;
			 Tfi = Tf0 + Tf1;
			 Tf3 = FNMS(KP831469612, Tf2, KP555570233 * TeZ);
			 Tfn = FMA(KP195090322, Tfh, KP980785280 * Tfi);
			 Tf7 = FMA(KP831469612, TeZ, KP555570233 * Tf2);
			 Tfj = FNMS(KP195090322, Tfi, KP980785280 * Tfh);
		    }
		    {
			 E TeS, Tfe, TeV, Tff, TeR, TeU;
			 TeR = KP707106781 * (TdE + Tdz);
			 TeS = TeQ - TeR;
			 Tfe = TeQ + TeR;
			 TeU = KP707106781 * (TdM + TdN);
			 TeV = TeT - TeU;
			 Tff = TeT + TeU;
			 TeW = FMA(KP555570233, TeS, KP831469612 * TeV);
			 Tfm = FNMS(KP195090322, Tfe, KP980785280 * Tff);
			 Tf6 = FNMS(KP831469612, TeS, KP555570233 * TeV);
			 Tfg = FMA(KP980785280, Tfe, KP195090322 * Tff);
		    }
	       }
	       {
		    E TeP, Tf4, Tht, Thw;
		    TeP = TeH + TeO;
		    Tf4 = TeW + Tf3;
		    ri[WS(ios, 42)] = TeP - Tf4;
		    ri[WS(ios, 10)] = TeP + Tf4;
		    Tht = Tf6 + Tf7;
		    Thw = Thu + Thv;
		    ii[WS(ios, 10)] = Tht + Thw;
		    ii[WS(ios, 42)] = Thw - Tht;
	       }
	       {
		    E Tf5, Tf8, Thx, Thy;
		    Tf5 = TeH - TeO;
		    Tf8 = Tf6 - Tf7;
		    ri[WS(ios, 58)] = Tf5 - Tf8;
		    ri[WS(ios, 26)] = Tf5 + Tf8;
		    Thx = Tf3 - TeW;
		    Thy = Thv - Thu;
		    ii[WS(ios, 26)] = Thx + Thy;
		    ii[WS(ios, 58)] = Thy - Thx;
	       }
	       {
		    E Tfd, Tfk, Thj, Thq;
		    Tfd = Tf9 + Tfc;
		    Tfk = Tfg + Tfj;
		    ri[WS(ios, 34)] = Tfd - Tfk;
		    ri[WS(ios, 2)] = Tfd + Tfk;
		    Thj = Tfm + Tfn;
		    Thq = Thk + Thp;
		    ii[WS(ios, 2)] = Thj + Thq;
		    ii[WS(ios, 34)] = Thq - Thj;
	       }
	       {
		    E Tfl, Tfo, Thr, Ths;
		    Tfl = Tf9 - Tfc;
		    Tfo = Tfm - Tfn;
		    ri[WS(ios, 50)] = Tfl - Tfo;
		    ri[WS(ios, 18)] = Tfl + Tfo;
		    Thr = Tfj - Tfg;
		    Ths = Thp - Thk;
		    ii[WS(ios, 18)] = Thr + Ths;
		    ii[WS(ios, 50)] = Ths - Thr;
	       }
	  }
	  {
	       E T6L, T9x, TiD, TiJ, T7E, TiI, T9A, TiA, T8y, T9K, T9u, T9E, T9r, T9L, T9v;
	       E T9H;
	       {
		    E T6n, T6K, TiB, TiC;
		    T6n = T6b - T6m;
		    T6K = T6y - T6J;
		    T6L = T6n - T6K;
		    T9x = T6n + T6K;
		    TiB = T9P - T9O;
		    TiC = Tin - Tim;
		    TiD = TiB + TiC;
		    TiJ = TiC - TiB;
	       }
	       {
		    E T7c, T9y, T7D, T9z;
		    {
			 E T72, T7b, T7t, T7C;
			 T72 = T6Q - T71;
			 T7b = T77 - T7a;
			 T7c = FNMS(KP980785280, T7b, KP195090322 * T72);
			 T9y = FMA(KP980785280, T72, KP195090322 * T7b);
			 T7t = T7h - T7s;
			 T7C = T7y - T7B;
			 T7D = FMA(KP195090322, T7t, KP980785280 * T7C);
			 T9z = FNMS(KP980785280, T7t, KP195090322 * T7C);
		    }
		    T7E = T7c - T7D;
		    TiI = T9z - T9y;
		    T9A = T9y + T9z;
		    TiA = T7c + T7D;
	       }
	       {
		    E T8k, T9C, T8x, T9D;
		    {
			 E T7W, T8j, T8t, T8w;
			 T7W = T7K - T7V;
			 T8j = T87 - T8i;
			 T8k = T7W - T8j;
			 T9C = T7W + T8j;
			 T8t = T8p - T8s;
			 T8w = T8u - T8v;
			 T8x = T8t - T8w;
			 T9D = T8t + T8w;
		    }
		    T8y = FMA(KP995184726, T8k, KP098017140 * T8x);
		    T9K = FNMS(KP634393284, T9D, KP773010453 * T9C);
		    T9u = FNMS(KP995184726, T8x, KP098017140 * T8k);
		    T9E = FMA(KP634393284, T9C, KP773010453 * T9D);
	       }
	       {
		    E T9d, T9F, T9q, T9G;
		    {
			 E T8P, T9c, T9m, T9p;
			 T8P = T8D - T8O;
			 T9c = T90 - T9b;
			 T9d = T8P - T9c;
			 T9F = T8P + T9c;
			 T9m = T9i - T9l;
			 T9p = T9n - T9o;
			 T9q = T9m - T9p;
			 T9G = T9m + T9p;
		    }
		    T9r = FNMS(KP995184726, T9q, KP098017140 * T9d);
		    T9L = FMA(KP773010453, T9G, KP634393284 * T9F);
		    T9v = FMA(KP098017140, T9q, KP995184726 * T9d);
		    T9H = FNMS(KP634393284, T9G, KP773010453 * T9F);
	       }
	       {
		    E T7F, T9s, TiH, TiK;
		    T7F = T6L + T7E;
		    T9s = T8y + T9r;
		    ri[WS(ios, 47)] = T7F - T9s;
		    ri[WS(ios, 15)] = T7F + T9s;
		    TiH = T9u + T9v;
		    TiK = TiI + TiJ;
		    ii[WS(ios, 15)] = TiH + TiK;
		    ii[WS(ios, 47)] = TiK - TiH;
	       }
	       {
		    E T9t, T9w, TiL, TiM;
		    T9t = T6L - T7E;
		    T9w = T9u - T9v;
		    ri[WS(ios, 63)] = T9t - T9w;
		    ri[WS(ios, 31)] = T9t + T9w;
		    TiL = T9r - T8y;
		    TiM = TiJ - TiI;
		    ii[WS(ios, 31)] = TiL + TiM;
		    ii[WS(ios, 63)] = TiM - TiL;
	       }
	       {
		    E T9B, T9I, Tiz, TiE;
		    T9B = T9x + T9A;
		    T9I = T9E + T9H;
		    ri[WS(ios, 39)] = T9B - T9I;
		    ri[WS(ios, 7)] = T9B + T9I;
		    Tiz = T9K + T9L;
		    TiE = TiA + TiD;
		    ii[WS(ios, 7)] = Tiz + TiE;
		    ii[WS(ios, 39)] = TiE - Tiz;
	       }
	       {
		    E T9J, T9M, TiF, TiG;
		    T9J = T9x - T9A;
		    T9M = T9K - T9L;
		    ri[WS(ios, 55)] = T9J - T9M;
		    ri[WS(ios, 23)] = T9J + T9M;
		    TiF = T9H - T9E;
		    TiG = TiD - TiA;
		    ii[WS(ios, 23)] = TiF + TiG;
		    ii[WS(ios, 55)] = TiG - TiF;
	       }
	  }
	  {
	       E TaL, TbJ, Ti9, Tif, Tb0, Tie, TbM, Ti6, Tbk, TbW, TbG, TbQ, TbD, TbX, TbH;
	       E TbT;
	       {
		    E TaD, TaK, Ti7, Ti8;
		    TaD = Taz - TaC;
		    TaK = TaG - TaJ;
		    TaL = TaD - TaK;
		    TbJ = TaD + TaK;
		    Ti7 = Tc1 - Tc0;
		    Ti8 = ThT - ThQ;
		    Ti9 = Ti7 + Ti8;
		    Tif = Ti8 - Ti7;
	       }
	       {
		    E TaS, TbK, TaZ, TbL;
		    {
			 E TaO, TaR, TaV, TaY;
			 TaO = TaM - TaN;
			 TaR = TaP - TaQ;
			 TaS = FNMS(KP831469612, TaR, KP555570233 * TaO);
			 TbK = FMA(KP555570233, TaR, KP831469612 * TaO);
			 TaV = TaT - TaU;
			 TaY = TaW - TaX;
			 TaZ = FMA(KP831469612, TaV, KP555570233 * TaY);
			 TbL = FNMS(KP831469612, TaY, KP555570233 * TaV);
		    }
		    Tb0 = TaS - TaZ;
		    Tie = TbL - TbK;
		    TbM = TbK + TbL;
		    Ti6 = TaS + TaZ;
	       }
	       {
		    E Tbc, TbO, Tbj, TbP;
		    {
			 E Tb4, Tbb, Tbf, Tbi;
			 Tb4 = Tb2 - Tb3;
			 Tbb = Tb7 - Tba;
			 Tbc = Tb4 - Tbb;
			 TbO = Tb4 + Tbb;
			 Tbf = Tbd - Tbe;
			 Tbi = Tbg - Tbh;
			 Tbj = Tbf - Tbi;
			 TbP = Tbf + Tbi;
		    }
		    Tbk = FMA(KP956940335, Tbc, KP290284677 * Tbj);
		    TbW = FNMS(KP471396736, TbP, KP881921264 * TbO);
		    TbG = FNMS(KP956940335, Tbj, KP290284677 * Tbc);
		    TbQ = FMA(KP471396736, TbO, KP881921264 * TbP);
	       }
	       {
		    E Tbv, TbR, TbC, TbS;
		    {
			 E Tbn, Tbu, Tby, TbB;
			 Tbn = Tbl - Tbm;
			 Tbu = Tbq - Tbt;
			 Tbv = Tbn - Tbu;
			 TbR = Tbn + Tbu;
			 Tby = Tbw - Tbx;
			 TbB = Tbz - TbA;
			 TbC = Tby - TbB;
			 TbS = Tby + TbB;
		    }
		    TbD = FNMS(KP956940335, TbC, KP290284677 * Tbv);
		    TbX = FMA(KP881921264, TbS, KP471396736 * TbR);
		    TbH = FMA(KP290284677, TbC, KP956940335 * Tbv);
		    TbT = FNMS(KP471396736, TbS, KP881921264 * TbR);
	       }
	       {
		    E Tb1, TbE, Tid, Tig;
		    Tb1 = TaL + Tb0;
		    TbE = Tbk + TbD;
		    ri[WS(ios, 45)] = Tb1 - TbE;
		    ri[WS(ios, 13)] = Tb1 + TbE;
		    Tid = TbG + TbH;
		    Tig = Tie + Tif;
		    ii[WS(ios, 13)] = Tid + Tig;
		    ii[WS(ios, 45)] = Tig - Tid;
	       }
	       {
		    E TbF, TbI, Tih, Tii;
		    TbF = TaL - Tb0;
		    TbI = TbG - TbH;
		    ri[WS(ios, 61)] = TbF - TbI;
		    ri[WS(ios, 29)] = TbF + TbI;
		    Tih = TbD - Tbk;
		    Tii = Tif - Tie;
		    ii[WS(ios, 29)] = Tih + Tii;
		    ii[WS(ios, 61)] = Tii - Tih;
	       }
	       {
		    E TbN, TbU, Ti5, Tia;
		    TbN = TbJ + TbM;
		    TbU = TbQ + TbT;
		    ri[WS(ios, 37)] = TbN - TbU;
		    ri[WS(ios, 5)] = TbN + TbU;
		    Ti5 = TbW + TbX;
		    Tia = Ti6 + Ti9;
		    ii[WS(ios, 5)] = Ti5 + Tia;
		    ii[WS(ios, 37)] = Tia - Ti5;
	       }
	       {
		    E TbV, TbY, Tib, Tic;
		    TbV = TbJ - TbM;
		    TbY = TbW - TbX;
		    ri[WS(ios, 53)] = TbV - TbY;
		    ri[WS(ios, 21)] = TbV + TbY;
		    Tib = TbT - TbQ;
		    Tic = Ti9 - Ti6;
		    ii[WS(ios, 21)] = Tib + Tic;
		    ii[WS(ios, 53)] = Tic - Tib;
	       }
	  }
	  {
	       E Tc3, Tcv, ThV, Ti1, Tca, Ti0, Tcy, ThO, Tci, TcI, Tcs, TcC, Tcp, TcJ, Tct;
	       E TcF;
	       {
		    E TbZ, Tc2, ThP, ThU;
		    TbZ = Taz + TaC;
		    Tc2 = Tc0 + Tc1;
		    Tc3 = TbZ - Tc2;
		    Tcv = TbZ + Tc2;
		    ThP = TaG + TaJ;
		    ThU = ThQ + ThT;
		    ThV = ThP + ThU;
		    Ti1 = ThU - ThP;
	       }
	       {
		    E Tc6, Tcw, Tc9, Tcx;
		    {
			 E Tc4, Tc5, Tc7, Tc8;
			 Tc4 = TaM + TaN;
			 Tc5 = TaP + TaQ;
			 Tc6 = FNMS(KP195090322, Tc5, KP980785280 * Tc4);
			 Tcw = FMA(KP980785280, Tc5, KP195090322 * Tc4);
			 Tc7 = TaT + TaU;
			 Tc8 = TaW + TaX;
			 Tc9 = FMA(KP195090322, Tc7, KP980785280 * Tc8);
			 Tcx = FNMS(KP195090322, Tc8, KP980785280 * Tc7);
		    }
		    Tca = Tc6 - Tc9;
		    Ti0 = Tcx - Tcw;
		    Tcy = Tcw + Tcx;
		    ThO = Tc6 + Tc9;
	       }
	       {
		    E Tce, TcA, Tch, TcB;
		    {
			 E Tcc, Tcd, Tcf, Tcg;
			 Tcc = Tbd + Tbe;
			 Tcd = Tba + Tb7;
			 Tce = Tcc - Tcd;
			 TcA = Tcc + Tcd;
			 Tcf = Tb2 + Tb3;
			 Tcg = Tbg + Tbh;
			 Tch = Tcf - Tcg;
			 TcB = Tcf + Tcg;
		    }
		    Tci = FMA(KP634393284, Tce, KP773010453 * Tch);
		    TcI = FNMS(KP098017140, TcA, KP995184726 * TcB);
		    Tcs = FNMS(KP773010453, Tce, KP634393284 * Tch);
		    TcC = FMA(KP995184726, TcA, KP098017140 * TcB);
	       }
	       {
		    E Tcl, TcD, Tco, TcE;
		    {
			 E Tcj, Tck, Tcm, Tcn;
			 Tcj = Tbl + Tbm;
			 Tck = TbA + Tbz;
			 Tcl = Tcj - Tck;
			 TcD = Tcj + Tck;
			 Tcm = Tbw + Tbx;
			 Tcn = Tbq + Tbt;
			 Tco = Tcm - Tcn;
			 TcE = Tcm + Tcn;
		    }
		    Tcp = FNMS(KP773010453, Tco, KP634393284 * Tcl);
		    TcJ = FMA(KP098017140, TcD, KP995184726 * TcE);
		    Tct = FMA(KP773010453, Tcl, KP634393284 * Tco);
		    TcF = FNMS(KP098017140, TcE, KP995184726 * TcD);
	       }
	       {
		    E Tcb, Tcq, ThZ, Ti2;
		    Tcb = Tc3 + Tca;
		    Tcq = Tci + Tcp;
		    ri[WS(ios, 41)] = Tcb - Tcq;
		    ri[WS(ios, 9)] = Tcb + Tcq;
		    ThZ = Tcs + Tct;
		    Ti2 = Ti0 + Ti1;
		    ii[WS(ios, 9)] = ThZ + Ti2;
		    ii[WS(ios, 41)] = Ti2 - ThZ;
	       }
	       {
		    E Tcr, Tcu, Ti3, Ti4;
		    Tcr = Tc3 - Tca;
		    Tcu = Tcs - Tct;
		    ri[WS(ios, 57)] = Tcr - Tcu;
		    ri[WS(ios, 25)] = Tcr + Tcu;
		    Ti3 = Tcp - Tci;
		    Ti4 = Ti1 - Ti0;
		    ii[WS(ios, 25)] = Ti3 + Ti4;
		    ii[WS(ios, 57)] = Ti4 - Ti3;
	       }
	       {
		    E Tcz, TcG, ThN, ThW;
		    Tcz = Tcv + Tcy;
		    TcG = TcC + TcF;
		    ri[WS(ios, 33)] = Tcz - TcG;
		    ri[WS(ios, 1)] = Tcz + TcG;
		    ThN = TcI + TcJ;
		    ThW = ThO + ThV;
		    ii[WS(ios, 1)] = ThN + ThW;
		    ii[WS(ios, 33)] = ThW - ThN;
	       }
	       {
		    E TcH, TcK, ThX, ThY;
		    TcH = Tcv - Tcy;
		    TcK = TcI - TcJ;
		    ri[WS(ios, 49)] = TcH - TcK;
		    ri[WS(ios, 17)] = TcH + TcK;
		    ThX = TcF - TcC;
		    ThY = ThV - ThO;
		    ii[WS(ios, 17)] = ThX + ThY;
		    ii[WS(ios, 49)] = ThY - ThX;
	       }
	  }
	  {
	       E T9R, Taj, Tip, Tiv, T9Y, Tiu, Tam, Tik, Ta6, Taw, Tag, Taq, Tad, Tax, Tah;
	       E Tat;
	       {
		    E T9N, T9Q, Til, Tio;
		    T9N = T6b + T6m;
		    T9Q = T9O + T9P;
		    T9R = T9N - T9Q;
		    Taj = T9N + T9Q;
		    Til = T6y + T6J;
		    Tio = Tim + Tin;
		    Tip = Til + Tio;
		    Tiv = Tio - Til;
	       }
	       {
		    E T9U, Tak, T9X, Tal;
		    {
			 E T9S, T9T, T9V, T9W;
			 T9S = T6Q + T71;
			 T9T = T77 + T7a;
			 T9U = FNMS(KP555570233, T9T, KP831469612 * T9S);
			 Tak = FMA(KP555570233, T9S, KP831469612 * T9T);
			 T9V = T7h + T7s;
			 T9W = T7y + T7B;
			 T9X = FMA(KP831469612, T9V, KP555570233 * T9W);
			 Tal = FNMS(KP555570233, T9V, KP831469612 * T9W);
		    }
		    T9Y = T9U - T9X;
		    Tiu = Tal - Tak;
		    Tam = Tak + Tal;
		    Tik = T9U + T9X;
	       }
	       {
		    E Ta2, Tao, Ta5, Tap;
		    {
			 E Ta0, Ta1, Ta3, Ta4;
			 Ta0 = T8p + T8s;
			 Ta1 = T8i + T87;
			 Ta2 = Ta0 - Ta1;
			 Tao = Ta0 + Ta1;
			 Ta3 = T7K + T7V;
			 Ta4 = T8u + T8v;
			 Ta5 = Ta3 - Ta4;
			 Tap = Ta3 + Ta4;
		    }
		    Ta6 = FMA(KP471396736, Ta2, KP881921264 * Ta5);
		    Taw = FNMS(KP290284677, Tao, KP956940335 * Tap);
		    Tag = FNMS(KP881921264, Ta2, KP471396736 * Ta5);
		    Taq = FMA(KP956940335, Tao, KP290284677 * Tap);
	       }
	       {
		    E Ta9, Tar, Tac, Tas;
		    {
			 E Ta7, Ta8, Taa, Tab;
			 Ta7 = T8D + T8O;
			 Ta8 = T9o + T9n;
			 Ta9 = Ta7 - Ta8;
			 Tar = Ta7 + Ta8;
			 Taa = T9i + T9l;
			 Tab = T90 + T9b;
			 Tac = Taa - Tab;
			 Tas = Taa + Tab;
		    }
		    Tad = FNMS(KP881921264, Tac, KP471396736 * Ta9);
		    Tax = FMA(KP290284677, Tar, KP956940335 * Tas);
		    Tah = FMA(KP881921264, Ta9, KP471396736 * Tac);
		    Tat = FNMS(KP290284677, Tas, KP956940335 * Tar);
	       }
	       {
		    E T9Z, Tae, Tit, Tiw;
		    T9Z = T9R + T9Y;
		    Tae = Ta6 + Tad;
		    ri[WS(ios, 43)] = T9Z - Tae;
		    ri[WS(ios, 11)] = T9Z + Tae;
		    Tit = Tag + Tah;
		    Tiw = Tiu + Tiv;
		    ii[WS(ios, 11)] = Tit + Tiw;
		    ii[WS(ios, 43)] = Tiw - Tit;
	       }
	       {
		    E Taf, Tai, Tix, Tiy;
		    Taf = T9R - T9Y;
		    Tai = Tag - Tah;
		    ri[WS(ios, 59)] = Taf - Tai;
		    ri[WS(ios, 27)] = Taf + Tai;
		    Tix = Tad - Ta6;
		    Tiy = Tiv - Tiu;
		    ii[WS(ios, 27)] = Tix + Tiy;
		    ii[WS(ios, 59)] = Tiy - Tix;
	       }
	       {
		    E Tan, Tau, Tij, Tiq;
		    Tan = Taj + Tam;
		    Tau = Taq + Tat;
		    ri[WS(ios, 35)] = Tan - Tau;
		    ri[WS(ios, 3)] = Tan + Tau;
		    Tij = Taw + Tax;
		    Tiq = Tik + Tip;
		    ii[WS(ios, 3)] = Tij + Tiq;
		    ii[WS(ios, 35)] = Tiq - Tij;
	       }
	       {
		    E Tav, Tay, Tir, Tis;
		    Tav = Taj - Tam;
		    Tay = Taw - Tax;
		    ri[WS(ios, 51)] = Tav - Tay;
		    ri[WS(ios, 19)] = Tav + Tay;
		    Tir = Tat - Taq;
		    Tis = Tip - Tik;
		    ii[WS(ios, 19)] = Tir + Tis;
		    ii[WS(ios, 51)] = Tis - Tir;
	       }
	  }
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_FULL, 0, 64},
     {TW_NEXT, 1, 0}
};

static const ct_desc desc = { 64, "t1_64", twinstr, &GENUS, {808, 270, 230, 0}, 0, 0, 0 };

void X(codelet_t1_64) (planner *p) {
     X(kdft_dit_register) (p, t1_64, &desc);
}
#endif				/* HAVE_FMA */
