/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.35
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace be.belgium.eid {

using System;
using System.Runtime.InteropServices;

/// <summary>Class that represents one CRL.</summary>
public class BEID_Crl : BEID_Object {
  private HandleRef swigCPtr;

  internal BEID_Crl(IntPtr cPtr, bool cMemoryOwn) : base(beidlib_dotNetPINVOKE.BEID_CrlUpcast(cPtr), cMemoryOwn) {
    swigCPtr = new HandleRef(this, cPtr);
  }

  internal static HandleRef getCPtr(BEID_Crl obj) {
    return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
  }

  ~BEID_Crl() {
    Dispose();
  }

  public override void Dispose() {
    lock(this) {
      if(swigCPtr.Handle != IntPtr.Zero && swigCMemOwn) {
        swigCMemOwn = false;
        beidlib_dotNetPINVOKE.delete_BEID_Crl(swigCPtr);
      }
      swigCPtr = new HandleRef(null, IntPtr.Zero);
      GC.SuppressFinalize(this);
      base.Dispose();
    }
  }

  /// <summary>
  /// Create a Crl from its uri (without any certificate link).
  /// </summary>
  /// <remarks>
  /// As there is no issuer, this CRL can't be verify and some method are not allowed (ex. getIssuer).
  /// These methods throw BEID_ExBadUsage exception.
  /// </remarks>
  public BEID_Crl(string uri)
      : this(beidlib_dotNetPINVOKE.new_BEID_Crl(uri), true)
  {
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
  }

  /// <summary>Return the uri of the CRL.</summary>
  public string getUri()
  {
    string ret = beidlib_dotNetPINVOKE.BEID_Crl_getUri(swigCPtr);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Return the name of the issuer of the certificate.</summary>
  public string getIssuerName()
  {
    string ret = beidlib_dotNetPINVOKE.BEID_Crl_getIssuerName(swigCPtr);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>
  /// Return the issuer certificate.
  /// </summary>
  /// <remarks>
  /// if there is no issuer (root), BEID_ExCertNoIssuer exception is thrown.
  /// </remarks>
  public BEID_Certificate getIssuer()
  {
    BEID_Certificate ret = new BEID_Certificate(beidlib_dotNetPINVOKE.BEID_Crl_getIssuer(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>
  /// Return the CRL as a byte array.
  /// </summary>
  /// <remarks>
  /// If it comes from a Certif we verify the signature.
  /// If it's created from the URL only we DON'T verify the signature.
  /// </remarks>
  /// <param name="crl">will content the crl</param>  
  /// <param name="bForceDownload">if true the CRL in the cache is not valid anymore and we force a new download</param>
  public BEID_CrlStatus getData(BEID_ByteArray crl, bool bForceDownload)
  {
    BEID_CrlStatus ret = (BEID_CrlStatus)beidlib_dotNetPINVOKE.BEID_Crl_getData__SWIG_0(swigCPtr, BEID_ByteArray.getCPtr(crl), bForceDownload);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>
  /// Return the CRL as a byte array.
  /// </summary>
  /// <remarks>
  /// If it comes from a Certif we verify the signature.
  /// If it's created from the URL only we DON'T verify the signature.
  /// </remarks>
  /// <param name="crl">will content the crl</param>  
  public BEID_CrlStatus getData(BEID_ByteArray crl)
  {
    BEID_CrlStatus ret = (BEID_CrlStatus)beidlib_dotNetPINVOKE.BEID_Crl_getData__SWIG_1(swigCPtr, BEID_ByteArray.getCPtr(crl));
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

}

}
