/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.35
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace be.belgium.eid {

using System;
using System.Runtime.InteropServices;

/// <summary>
/// Abstract base class for all the card type supported.
/// The BEID_ReaderContext::getCard() method will return such an object.
/// </summary>
public class BEID_Card : BEID_Object {
  private HandleRef swigCPtr;

  internal BEID_Card(IntPtr cPtr, bool cMemoryOwn) : base(beidlib_dotNetPINVOKE.BEID_CardUpcast(cPtr), cMemoryOwn) {
    swigCPtr = new HandleRef(this, cPtr);
  }

  internal static HandleRef getCPtr(BEID_Card obj) {
    return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
  }

  ~BEID_Card() {
    Dispose();
  }

  public override void Dispose() {
    lock(this) {
      if(swigCPtr.Handle != IntPtr.Zero && swigCMemOwn) {
        swigCMemOwn = false;
        beidlib_dotNetPINVOKE.delete_BEID_Card(swigCPtr);
      }
      swigCPtr = new HandleRef(null, IntPtr.Zero);
      GC.SuppressFinalize(this);
      base.Dispose();
    }
  }

  /// <summary>Return the type of the card.</summary>
  public virtual BEID_CardType getType()
  {
    BEID_CardType ret = (BEID_CardType)beidlib_dotNetPINVOKE.BEID_Card_getType(swigCPtr);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary> 
  /// Return a document from the card.
  /// </summary>
  /// <remarks>
  /// Throw BEID_ExDocTypeUnknown exception if the document doesn't exist for this card. 
  /// </remarks>
  public virtual BEID_XMLDoc getDocument(BEID_DocumentType type)
  {
    BEID_XMLDoc ret = new BEID_XMLDoc(beidlib_dotNetPINVOKE.BEID_Card_getDocument(swigCPtr, (int)type), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary> 
  /// Return a raw data from the card.
  /// </summary>
  /// <remarks>
  /// Throw BEID_ExFileTypeUnknown exception if the document doesn't exist for this card. 
  /// </remarks>
  public virtual BEID_ByteArray getRawData(BEID_RawDataType type)
  {
    BEID_ByteArray ret = new BEID_ByteArray(beidlib_dotNetPINVOKE.BEID_Card_getRawData(swigCPtr, (int)type), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Send an APDU command to the card and get the result.</summary>
  /// <param name="cmd">is the apdu command</param> 
  /// <returns>a BEID_ByteArray containing the result</returns>
  public virtual BEID_ByteArray sendAPDU(BEID_ByteArray cmd)
  {
    BEID_ByteArray ret = new BEID_ByteArray(beidlib_dotNetPINVOKE.BEID_Card_sendAPDU(swigCPtr, BEID_ByteArray.getCPtr(cmd)), true);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Read a File from the card.</summary>
  /// <param name="fileID">is the path of the file</param>  
  /// <param name="ulOffset">is the offset to begins the reading</param> 
  /// <param name="ulMaxLength">is the maximum length of bytes to read</param>  
  /// <returns>A BEID_ByteArray with the content of the file</returns>
  public virtual BEID_ByteArray readFile(string fileID, uint ulOffset, uint ulMaxLength)
  {
    BEID_ByteArray ret = new BEID_ByteArray(beidlib_dotNetPINVOKE.BEID_Card_readFile__SWIG_0(swigCPtr, fileID, ulOffset, ulMaxLength), true);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Read a File from the card.</summary>
  /// <param name="fileID">is the path of the file</param>  
  /// <param name="ulOffset">is the offset to begins the reading</param> 
  /// <returns>A BEID_ByteArray with the content of the file</returns>
  public virtual BEID_ByteArray readFile(string fileID, uint ulOffset)
  {
    BEID_ByteArray ret = new BEID_ByteArray(beidlib_dotNetPINVOKE.BEID_Card_readFile__SWIG_1(swigCPtr, fileID, ulOffset), true);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Read a File from the card.</summary>
  /// <param name="fileID">is the path of the file</param>  
  /// <returns>A BEID_ByteArray with the content of the file</returns>
  public virtual BEID_ByteArray readFile(string fileID)
  {
    BEID_ByteArray ret = new BEID_ByteArray(beidlib_dotNetPINVOKE.BEID_Card_readFile__SWIG_2(swigCPtr, fileID), true);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Write a file to the card.</summary>
  /// <param name="fileID">is the path of the file</param> 
  /// <param name="oData">contents the bytes to write</param> 
  /// <param name="ulOffset"> is the offset to begins the writing</param> 
  public virtual bool writeFile(string fileID, BEID_ByteArray oData, uint ulOffset)
  {
    bool ret = beidlib_dotNetPINVOKE.BEID_Card_writeFile__SWIG_0(swigCPtr, fileID, BEID_ByteArray.getCPtr(oData), ulOffset);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Write a file to the card.</summary>
  /// <param name="fileID">is the path of the file</param> 
  /// <param name="oData">contents the bytes to write</param> 
  public virtual bool writeFile(string fileID, BEID_ByteArray oData)
  {
    bool ret = beidlib_dotNetPINVOKE.BEID_Card_writeFile__SWIG_1(swigCPtr, fileID, BEID_ByteArray.getCPtr(oData));
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

}

}
