
import logging

import atheist.gvar as gvar

DATEFORMAT = '%d/%m/%y %H:%M:%S'

class XXLoggingFormatter(logging.Formatter):
    def format(self, record):
        record.levelinitial = record.levelname[0]*2
        return logging.Formatter.format(self, record)

def create_basic_handler():
    formatter = XXLoggingFormatter('[%(levelinitial)s] %(message)s', DATEFORMAT)
    console = logging.StreamHandler()
    console.setFormatter(formatter)
    return console

if gvar.Log is None:
    gvar.Log = logging.getLogger('atheist')
    if not gvar.Log.handlers:
        gvar.Log.addHandler(create_basic_handler())

        gvar.Log.propagate = 0
        gvar.Log.setLevel(logging.WARNING)
