/** \file libassogiate/mime-database.hh */
/*
 * This file is part of assoGiate,
 * an editor of the file types database for GNOME.
 *
 * Copyright (C) 2007 Kevin Daughtridge <kevin@kdau.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef LIBASSOGIATE__MIME_DATABASE_HH
#define LIBASSOGIATE__MIME_DATABASE_HH

#include <libassogiate/mime-directory.hh>

/******************************************************************************/
namespace assoGiate {
/******************************************************************************/

typedef std::map<ustring, std::pair<MimeType*, bool> > MimeTypeMap;

/******************************************************************************/
class MimeDatabase : public Glib::Object {
/******************************************************************************/

public:

	static RefPtr<MimeDatabase> load(bool user_db) throw(MimeDatabaseLoadError);

	virtual ~MimeDatabase();
	
	MimeTypeMap& get_types() throw();
	const MimeTypeMap& get_types() const throw();
	
	Location get_target() const throw();
	WritableMimePackage& get_Override_pkg() throw();
	
	sigc::signal<void> signal_changed() throw();

private:

	MimeDatabase(bool user_db) throw(MimeDatabaseLoadError);

	void clear_types() throw();
	void rescan() throw();

	std::list<MimeDirectory*> m_mime_dirs;
	MimeTypeMap m_mime_types;

	Location m_target;
	WritableMimePackage *m_Override_pkg;

	sigc::signal<void> s_changed;
	
	bool m_load_errors;

}; /* class MimeDatabase */

} /* namespace assoGiate */

#endif /* LIBASSOGIATE__MIME_DATABASE_HH */
