/* symbol.c */

# include "symbol.h"
# include <stdlib.h>
# include <string.h>


typedef struct { unsigned char *Text;
                 long Row;
                 long Column;
               } SymbolEntry;

SymbolEntry SymbolTable[1000];
TableIndex FirstFree = 0;


TableIndex InsertSymbol (unsigned char *SymbolText,
                         int NumberOfCharacters,
                         long Row, long Column)
 { SymbolEntry *Symbol;

   Symbol = &SymbolTable[FirstFree];
   if (NumberOfCharacters > 0)
    { Symbol->Text = 
         (unsigned char *) malloc ((size_t) NumberOfCharacters+1);
      memmove (Symbol->Text, SymbolText, NumberOfCharacters);
      Symbol->Text[NumberOfCharacters] = '\0';
    }
   Symbol->Row = Row;
   Symbol->Column = Column;
   return FirstFree++;
 }


unsigned char *GetSymbolText (TableIndex Index)
 {
   return SymbolTable[Index].Text;
 }


long GetSymbolRow (TableIndex Index)
 {
   return SymbolTable[Index].Row;
 }


long GetSymbolColumn (TableIndex Index)
 {
   return SymbolTable[Index].Column;
 }


void DeleteAllSymbols (void)
 {
   TableIndex Index;

   for (Index=0; Index < FirstFree; Index++)
    { free (SymbolTable[Index].Text);
    }
   return;
 }
